/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc.utils;

import com.baidu.brcc.model.R;
import com.baidu.brcc.model.RList;
import com.baidu.brcc.utils.gson.GsonUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OkHttpClientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkHttpClientUtils.class);
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private OkHttpClient okHttpClient = null;

    public OkHttpClientUtils(long readTimeOut, long connectionTimeOut) {
        this.okHttpClient = new OkHttpClient.Builder().readTimeout(readTimeOut, TimeUnit.MILLISECONDS).connectTimeout(connectionTimeOut, TimeUnit.MILLISECONDS).build();
    }

    public <T> R<T> get(String url, Class<T> type, Map<String, Object> param, Map<String, String> header) throws IOException {
        Request.Builder builder = new Request.Builder().url(this.addParam(url, param));
        if (header != null && !header.isEmpty()) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                String value = entry.getValue();
                builder.addHeader(key, value);
            }
        }
        Request request = builder.build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody body = response.body();
            String result = body.string();
            R<T> r = GsonUtils.toRObject(result, type);
            return r;
        }
    }

    public <T> RList<T> getList(String url, Class<T> type, Map<String, Object> param, Map<String, String> header) throws IOException {
        Request.Builder builder = new Request.Builder().url(this.addParam(url, param));
        if (header != null && !header.isEmpty()) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                String value = entry.getValue();
                builder.addHeader(key, value);
            }
        }
        Request request = builder.build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody body = response.body();
            String result = body.string();
            RList<T> rList = GsonUtils.toRList(result, type);
            return rList;
        }
    }

    public <T> R<T> postJson(String url, Class<T> type, String body, Map<String, Object> param, Map<String, String> header) throws IOException {
        Request.Builder builder = new Request.Builder().url(this.addParam(url, param));
        if (header != null && !header.isEmpty()) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                String value = entry.getValue();
                builder.addHeader(key, value);
            }
        }
        RequestBody bodyx = RequestBody.create((MediaType)JSON, (String)body);
        Request request = builder.post(bodyx).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            String result = responseBody.string();
            R<T> r = GsonUtils.toRObject(result, type);
            return r;
        }
    }

    private HttpUrl addParam(String url, Map<String, Object> param) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (param == null || param.isEmpty()) {
            return httpUrl;
        }
        HttpUrl.Builder builder = httpUrl.newBuilder();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            Object value = entry.getValue();
            builder.removeAllQueryParameters(key).addQueryParameter(key, value == null ? "" : value.toString());
        }
        return builder.build();
    }
}

