/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc.utils.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public interface GsonNumberDefaultAdapter<T extends Number>
extends JsonSerializer<T>,
JsonDeserializer<T> {
    public T returnNull();

    public T returnValue(JsonElement var1);

    default public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json == null || json.isJsonNull()) {
            return this.returnNull();
        }
        if (json.isJsonPrimitive()) {
            String stringValue = json.getAsString();
            if (stringValue.equals("") || stringValue.equals("null")) {
                return this.returnNull();
            }
            return this.returnValue(json);
        }
        return this.returnNull();
    }

    default public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(src);
    }
}

