/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc.utils;

import com.baidu.brcc.utils.StringUtils;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtils.class);
    private static final String DEFAULT_LOCAL_IP = "127.0.0.1";
    private static final String DEFAULT_LOCAL_HOSTNAME = "localhost";
    public static final String SDK_VERSION = "1.0.0";
    private static String localIp = null;
    private static String containerId = null;
    private static String idcName = null;
    private static String appName = null;
    private static Boolean useOnlySiteLocalInterfaces = null;
    private static List<String> preferredNetworks = null;
    private static List<String> ignoredInterfaces = null;

    public static String getLocalIp() {
        if (localIp != null) {
            return localIp;
        }
        InetAddress address = NetUtils.findFirstNonLoopbackAddress();
        if (address == null) {
            try {
                address = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                LOGGER.error("getLocalIp error.", (Throwable)e);
            }
        }
        if (address == null) {
            localIp = DEFAULT_LOCAL_IP;
            containerId = DEFAULT_LOCAL_HOSTNAME;
        } else {
            localIp = address.getHostAddress();
            containerId = address.getHostName();
        }
        return localIp;
    }

    public static String getIdc() {
        String idc;
        if (idcName != null) {
            return idcName;
        }
        String envName = System.getProperty("rcc.idcEnvName");
        if (envName == null) {
            envName = System.getProperty("rcc.idc-env-name");
        }
        if (!StringUtils.isBlank(envName) && !StringUtils.isBlank(idc = System.getenv(StringUtils.trimToEmpty(envName)))) {
            idcName = idc;
            return idc;
        }
        idcName = "-";
        return idcName;
    }

    public static String getContainerId() {
        String cid;
        if (containerId != null) {
            return containerId;
        }
        String envName = System.getProperty("rcc.containerIdEnvName");
        if (envName == null) {
            envName = System.getProperty("rcc.container-id-env-name");
        }
        if (!StringUtils.isBlank(envName) && !StringUtils.isBlank(cid = System.getenv(StringUtils.trimToEmpty(envName)))) {
            containerId = cid;
            return cid;
        }
        InetAddress address = NetUtils.findFirstNonLoopbackAddress();
        if (address == null) {
            try {
                address = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                LOGGER.error("getLocalHostName error.", (Throwable)e);
            }
        }
        if (address == null) {
            localIp = DEFAULT_LOCAL_IP;
            containerId = DEFAULT_LOCAL_HOSTNAME;
        } else {
            localIp = address.getHostAddress();
            containerId = address.getHostName();
        }
        return containerId;
    }

    private static InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Testing interface: " + ifc.getDisplayName());
                }
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                if (NetUtils.ignoreInterface(ifc.getDisplayName())) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress() || !NetUtils.isPreferredAddress(address)) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Found non-loopback interface: " + ifc.getDisplayName());
                    }
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error("Cannot get first non-loopback address", (Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to retrieve localhost");
            return null;
        }
    }

    private static boolean ignoreInterface(String interfaceName) {
        for (String regex : NetUtils.getIgnoredInterfaces()) {
            if (!interfaceName.matches(regex)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignoring interface: " + interfaceName);
            }
            return true;
        }
        return false;
    }

    private static boolean isPreferredAddress(InetAddress address) {
        if (NetUtils.isUseOnlySiteLocalInterfaces()) {
            boolean siteLocalAddress = address.isSiteLocalAddress();
            if (!siteLocalAddress && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignoring address: " + address.getHostAddress());
            }
            return siteLocalAddress;
        }
        List<String> preferredNetworks = NetUtils.getPreferredNetworks();
        if (preferredNetworks.isEmpty()) {
            return true;
        }
        for (String regex : preferredNetworks) {
            String hostAddress = address.getHostAddress();
            if (!hostAddress.matches(regex) && !hostAddress.startsWith(regex)) continue;
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ignoring address: " + address.getHostAddress());
        }
        return false;
    }

    private static boolean isUseOnlySiteLocalInterfaces() {
        if (useOnlySiteLocalInterfaces != null) {
            return useOnlySiteLocalInterfaces;
        }
        String property = System.getProperty("rcc.useOnlySiteLocalInterfaces");
        if (property == null) {
            property = System.getProperty("rcc.use-only-site-local-interfaces");
        }
        if (property != null && "TRUE".equalsIgnoreCase(property.trim())) {
            useOnlySiteLocalInterfaces = true;
            return true;
        }
        useOnlySiteLocalInterfaces = false;
        return false;
    }

    private static List<String> getPreferredNetworks() {
        if (preferredNetworks != null) {
            return preferredNetworks;
        }
        String property = System.getProperty("rcc.preferredNetworks");
        if (property == null) {
            property = System.getProperty("rcc.preferred-networks");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (property != null && property.trim().length() > 0) {
            String[] addresses;
            String[] stringArray = addresses = property.trim().split("\\,");
            int n = addresses.length;
            int n2 = 0;
            while (n2 < n) {
                String address = stringArray[n2];
                if (address != null && address.trim().length() > 0) {
                    result.add(address.trim());
                }
                ++n2;
            }
        }
        preferredNetworks = result;
        return result;
    }

    private static List<String> getIgnoredInterfaces() {
        if (ignoredInterfaces != null) {
            return ignoredInterfaces;
        }
        String property = System.getProperty("rcc.ignoredInterfaces");
        if (property == null) {
            property = System.getProperty("rcc.ignored-interfaces");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (property != null && property.trim().length() > 0) {
            String[] addresses;
            String[] stringArray = addresses = property.trim().split("\\,");
            int n = addresses.length;
            int n2 = 0;
            while (n2 < n) {
                String address = stringArray[n2];
                if (address != null && address.trim().length() > 0) {
                    result.add(address.trim());
                }
                ++n2;
            }
        }
        ignoredInterfaces = result;
        return result;
    }

    public static String getAppName() {
        if (appName != null) {
            return appName;
        }
        String property = System.getProperty("rcc.appName");
        if (property == null) {
            property = System.getProperty("rcc.app-name");
        }
        appName = property == null || "".equals(property.trim()) ? "-" : property;
        return appName;
    }
}

