/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc.utils;

import org.springframework.lang.Nullable;

public class StringUtils {
    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end += str.length();
        }
        if (start < 0) {
            start += str.length();
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static boolean hasText(@Nullable String str) {
        return str != null && !str.isEmpty() && StringUtils.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = StringUtils.length(cs);
        if (strLen == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(cs.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToEmpty(String str) {
        return str == null ? "" : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 != null && cs2 != null) {
            if (cs1.length() != cs2.length()) {
                return false;
            }
            if (cs1 instanceof String && cs2 instanceof String) {
                return cs1.equals(cs2);
            }
            int length = cs1.length();
            int i = 0;
            while (i < length) {
                if (cs1.charAt(i) != cs2.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

