/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc.utils.gson;

import com.baidu.brcc.model.R;
import com.baidu.brcc.model.RList;
import com.baidu.brcc.utils.StringUtils;
import com.baidu.brcc.utils.gson.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GsonUtils.class);
    private static final Gson GSON = GsonFactory.createGson();

    public static JsonElement getJsonObject(JsonElement object, String ... path) {
        if (path == null || path.length == 0) {
            return null;
        }
        for (String p : path) {
            if (object == null) {
                return null;
            }
            if (object instanceof JsonPrimitive) {
                return object;
            }
            if (!(object instanceof JsonObject)) continue;
            object = ((JsonObject)object).get(p);
        }
        return object;
    }

    public static JsonArray getJsonArray(JsonObject object, String ... path) {
        if (path == null || path.length == 0) {
            return null;
        }
        for (int i = 0; i < path.length - 1; ++i) {
            if (object == null) {
                return null;
            }
            JsonElement jsonElement = object.get(path[i]);
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                return null;
            }
            object = jsonElement.getAsJsonObject();
        }
        if (object == null) {
            return null;
        }
        JsonElement jsonElement = object.get(path[path.length - 1]);
        if (jsonElement == null || !jsonElement.isJsonArray()) {
            return null;
        }
        return jsonElement.getAsJsonArray();
    }

    public static JsonObject toJsonObject(String json) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        JsonObject jsonObject = null;
        try {
            jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("to json object fail.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("to json object fail.", (Throwable)e);
        }
        return jsonObject;
    }

    public static JsonArray toJsonArray(String json) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        JsonArray jsonArray = null;
        try {
            jsonArray = (JsonArray)GSON.fromJson(json, JsonArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("to json array fail.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("to json array fail.", (Throwable)e);
        }
        if (jsonArray == null) {
            return new JsonArray(0);
        }
        return jsonArray;
    }

    public static <T> T toObject(String json, Class<T> cls) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        Object t = null;
        try {
            t = GSON.fromJson(json, cls);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("to object fail.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("to object fail.", (Throwable)e);
        }
        return (T)t;
    }

    public static <T> T toObject(byte[] json, Class<T> cls) {
        if (json == null || json.length == 0) {
            return null;
        }
        Object t = null;
        try {
            t = GSON.fromJson(new String(json), cls);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("to object fail.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("to object fail.", (Throwable)e);
        }
        return (T)t;
    }

    public static JsonElement toJsonElement(String json) {
        JsonNull element = null;
        if (StringUtils.isBlank(json)) {
            element = JsonNull.INSTANCE;
        } else {
            try {
                element = (JsonElement)GSON.fromJson(json, JsonElement.class);
            }
            catch (Exception ex) {
                element = new JsonPrimitive(json);
            }
            if (element == null) {
                element = new JsonPrimitive(json);
            }
        }
        return element;
    }

    public static <T> T toObject(JsonElement json, Class<T> cls) {
        if (json == null) {
            return null;
        }
        Object t = null;
        try {
            t = GSON.fromJson(json, cls);
        }
        catch (Exception e) {
            LOGGER.error("to object fail.", (Throwable)e);
        }
        return (T)t;
    }

    public static String getStringOrDefault(JsonElement object, String defaultValue, String ... path) {
        JsonElement jsonObject = GsonUtils.getJsonObject(object, path);
        if (jsonObject == null || jsonObject.isJsonNull() || !jsonObject.isJsonPrimitive()) {
            return defaultValue;
        }
        return jsonObject.getAsString();
    }

    public static Byte getByteOrDefault(JsonElement object, Byte defaultValue, String ... path) {
        JsonElement jsonObject = GsonUtils.getJsonObject(object, path);
        if (jsonObject == null || jsonObject.isJsonNull() || !jsonObject.isJsonPrimitive()) {
            return defaultValue;
        }
        Byte result = defaultValue;
        try {
            result = jsonObject.getAsByte();
        }
        catch (NumberFormatException ex) {
            LOGGER.error("getByteOrDefault fail.", (Throwable)ex);
        }
        return result;
    }

    public static Integer getIntegerOrDefault(JsonElement object, Integer defaultValue, String ... path) {
        JsonElement jsonObject = GsonUtils.getJsonObject(object, path);
        if (jsonObject == null || jsonObject.isJsonNull() || !jsonObject.isJsonPrimitive()) {
            return defaultValue;
        }
        Integer result = defaultValue;
        try {
            result = jsonObject.getAsInt();
        }
        catch (NumberFormatException ex) {
            LOGGER.error("getIntegerOrDefault fail.", (Throwable)ex);
        }
        return result;
    }

    public static Long getLongOrDefault(JsonElement object, Long defaultValue, String ... path) {
        JsonElement jsonObject = GsonUtils.getJsonObject(object, path);
        if (jsonObject == null || jsonObject.isJsonNull() || !jsonObject.isJsonPrimitive()) {
            return defaultValue;
        }
        Long result = defaultValue;
        try {
            result = jsonObject.getAsLong();
        }
        catch (NumberFormatException ex) {
            LOGGER.error("getLongOrDefault fail.", (Throwable)ex);
        }
        return result;
    }

    public static Double getDoubleOrDefault(JsonElement object, Double defaultValue, String ... path) {
        JsonElement jsonObject = GsonUtils.getJsonObject(object, path);
        if (jsonObject == null || jsonObject.isJsonNull() || !jsonObject.isJsonPrimitive()) {
            return defaultValue;
        }
        Double result = defaultValue;
        try {
            result = jsonObject.getAsDouble();
        }
        catch (NumberFormatException ex) {
            LOGGER.error("getDoubleOrDefault fail.", (Throwable)ex);
        }
        return result;
    }

    public static JsonElement getJsonElement(JsonObject object, String ... path) {
        if (path == null || path.length == 0 || object == null) {
            return null;
        }
        JsonObject tmpJsonObject = object;
        for (int i = 0; i < path.length - 1; ++i) {
            if (object == null) {
                return null;
            }
            JsonElement jsonElement = tmpJsonObject.get(path[i]);
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                return null;
            }
            tmpJsonObject = jsonElement.getAsJsonObject();
        }
        if (tmpJsonObject == null) {
            return null;
        }
        return tmpJsonObject.get(path[path.length - 1]);
    }

    public static void removeJsonPropertiesProperties(JsonObject jsonObject, String ... property) {
        if (jsonObject == null || property == null || property.length <= 0) {
            return;
        }
        for (String p : property) {
            if (!jsonObject.has(p)) continue;
            jsonObject.remove(p);
        }
    }

    public static String toJsonString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return GSON.toJson(object);
    }

    public static byte[] toJsonBytes(Object object) {
        if (object == null) {
            return null;
        }
        String s = GsonUtils.toJsonString(object);
        if (s == null) {
            return null;
        }
        return s.getBytes();
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        return (List)GSON.fromJson(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType());
    }

    public static <T> R<T> toRObject(String json, Class<T> clazz) {
        return (R)GSON.fromJson(json, TypeToken.getParameterized(R.class, (Type[])new Type[]{clazz}).getType());
    }

    public static <T> RList<T> toRList(String json, Class<T> clazz) {
        return (RList)GSON.fromJson(json, TypeToken.getParameterized(RList.class, (Type[])new Type[]{clazz}).getType());
    }
}

