/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc;

import com.baidu.brcc.ConfigChangedListener;
import com.baidu.brcc.ConfigItemChangedCallable;
import com.baidu.brcc.exception.RccException;
import com.baidu.brcc.model.AuthVo;
import com.baidu.brcc.model.ChangedConfigItem;
import com.baidu.brcc.model.EnvVo;
import com.baidu.brcc.model.ItemVo;
import com.baidu.brcc.model.R;
import com.baidu.brcc.model.RList;
import com.baidu.brcc.model.VersionVo;
import com.baidu.brcc.utils.NetUtils;
import com.baidu.brcc.utils.OkHttpClientUtils;
import com.baidu.brcc.utils.StringUtils;
import com.baidu.brcc.utils.gson.GsonUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigLoader.class);
    private static final String HEADER_VERSION_ID = "Rcc-Version-Id";
    private static final String HEADER_IDC = "Rcc-Idc";
    private static final String HEADER_CONTAINER_ID = "Rcc-Container-Id";
    private static final String HEADER_CLIENT_IP = "Rcc-Client-Ip";
    private static final String HEADER_APP_NAME = "Rcc-App-Name";
    private static final String HEADER_SDK_VERSION = "Rcc-Sdk-Version";
    private static final String HEADER_ENABLE_UPDATE_CALLBACK = "Rcc-Enable-Update-Callback";
    private static final String HEADER_CHECKSUM = "Rcc-Checksum";
    private static final String HEADER_NET_COST = "Rcc-Net-Cost";
    private static final String HEADER_RCC_TS = "Rcc-Ts";
    private static final String HEADER_RCC_SERVER_IN_TS = "Rcc-Server-In-Ts";
    private static final String HEADER_RCC_OUT_TS = "Rcc-Out-Ts";
    private static final String AUTH_API = "/api/auth";
    private static final String ENV_API = "/api/environment/{0}";
    private static final String VERSION_API = "/api/v2/version/{0}";
    private static final String GRAY_VERSION_API = "api/grayVersion/{0}";
    private static final String ITEM_API = "/api/item";
    private boolean enableInterruptService;
    private boolean enableGray;
    private String ccServerUrl;
    private String apiPassword;
    private String projectName;
    private String envName;
    private String ccVersionName;
    private boolean enableUpdateCallback;
    private long callbackInteval;
    private Properties rccProperties;
    private String currentToken;
    private Long envId;
    private Long versionId;
    private String lastCheckSum;
    private OkHttpClientUtils okHttpClientUtils;
    private Long netCost;
    private Collection<ConfigItemChangedCallable> changedCallable;
    private ConfigChangedListener configChangedListener;

    public ConfigLoader(String ccServerUrl, String apiPassword, String projectName, String envName, String ccVersionName, boolean enableUpdateCallback, long connectionTimeOut, long readTimeOut, long callbackInteval, boolean enableInterruptService, boolean enableGray) throws IOException {
        this.ccServerUrl = ccServerUrl;
        this.apiPassword = apiPassword;
        this.projectName = projectName;
        this.envName = envName;
        this.ccVersionName = ccVersionName;
        this.enableUpdateCallback = enableUpdateCallback;
        this.callbackInteval = callbackInteval;
        this.enableInterruptService = enableInterruptService;
        this.enableGray = enableGray;
        this.okHttpClientUtils = new OkHttpClientUtils(readTimeOut, connectionTimeOut);
        this.init();
    }

    private void init() throws IOException {
        String res = this.login();
        if (!StringUtils.isBlank(res)) {
            this.getEnv();
            VersionVo version = this.getVersion();
            this.lastCheckSum = version.getCheckSum();
        }
    }

    public String login() throws IOException {
        String authUrl = this.ccServerUrl.concat(AUTH_API);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("projectName", this.projectName);
        body.put("apiPassword", this.apiPassword);
        R<AuthVo> vo = this.okHttpClientUtils.postJson(authUrl, AuthVo.class, GsonUtils.toJsonString(body), null, null);
        if (vo == null || vo.getData() == null || vo.getStatus() != 0) {
            String msg = null;
            msg = vo == null ? "get rcc token fail." : vo.getMsg();
            if (vo.getStatus() == 100204 && !this.enableInterruptService) {
                return null;
            }
            throw new RccException(msg);
        }
        this.currentToken = vo.getData().getToken();
        return this.currentToken;
    }

    public Long getEnv() throws IOException {
        if (StringUtils.isBlank(this.currentToken)) {
            this.login();
        }
        String envUrl = this.ccServerUrl.concat(MessageFormat.format(ENV_API, this.envName));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("token", this.currentToken);
        R<EnvVo> result = this.okHttpClientUtils.get(envUrl, EnvVo.class, param, null);
        if (result == null || result.getData() == null || result.getStatus() != 0) {
            String msg = null;
            msg = result == null ? "get rcc env by name fail." : result.getMsg();
            throw new RccException(msg);
        }
        this.envId = result.getData().getEnvironmentId();
        return this.envId;
    }

    public VersionVo getVersion() throws IOException {
        if (StringUtils.isBlank(this.currentToken)) {
            this.login();
        }
        if (this.envId == null) {
            this.getEnv();
        }
        String versionUrl = this.ccServerUrl.concat(MessageFormat.format(VERSION_API, this.ccVersionName));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("token", this.currentToken);
        param.put("environmentId", this.envId);
        Map<String, String> header = this.getHeaderInfo();
        param.put("ip", header.get(HEADER_CLIENT_IP));
        param.put("containerId", header.get(HEADER_CONTAINER_ID));
        param.put("idc", header.get(HEADER_IDC));
        param.put("enableGray", this.enableGray);
        R<VersionVo> result = null;
        result = this.okHttpClientUtils.get(versionUrl, VersionVo.class, param, header);
        if (result == null || result.getData() == null || result.getStatus() != 0) {
            String msg = null;
            msg = result == null ? "get rcc version by name fail." : result.getMsg();
            throw new RccException(msg);
        }
        this.versionId = result.getData().getVersionId();
        this.netCost(result);
        return result.getData();
    }

    private void netCost(R<?> r) {
        if (r == null || r.getHeader() == null) {
            return;
        }
        Long t1 = r.getHeader().get(HEADER_RCC_TS);
        Long t2 = r.getHeader().get(HEADER_RCC_SERVER_IN_TS);
        Long t3 = r.getSts();
        Long t4 = r.getHeader().get(HEADER_RCC_OUT_TS);
        if (t1 == null || t2 == null || t3 == null || t4 == null) {
            return;
        }
        this.netCost = (t2 - t1 + t4 - t3) / 2L;
    }

    public Map<String, String> getFromCC() throws IOException {
        if (StringUtils.isBlank(this.currentToken)) {
            this.login();
        }
        String itemUrl = this.ccServerUrl.concat(ITEM_API);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("token", this.currentToken);
        param.put("versionId", this.versionId);
        Map<String, String> header = this.getHeaderInfo();
        RList<ItemVo> r = this.okHttpClientUtils.getList(itemUrl, ItemVo.class, param, header);
        this.netCost(r);
        HashMap<String, String> map = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)r.getData())) {
            Iterator iterator = r.getData().iterator();
            while (iterator.hasNext()) {
                ItemVo itemVo = (ItemVo)iterator.next();
                map.put(itemVo.getKey(), itemVo.getValue());
            }
        }
        return map;
    }

    private Map<String, String> getHeaderInfo() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(HEADER_RCC_TS, System.currentTimeMillis() + "");
        header.put(HEADER_APP_NAME, NetUtils.getAppName());
        header.put(HEADER_CHECKSUM, this.lastCheckSum == null ? "-" : this.lastCheckSum);
        header.put(HEADER_CLIENT_IP, NetUtils.getLocalIp());
        header.put(HEADER_IDC, NetUtils.getIdc());
        header.put(HEADER_CONTAINER_ID, NetUtils.getContainerId());
        header.put(HEADER_VERSION_ID, this.versionId == null ? "" : this.versionId.toString());
        header.put(HEADER_SDK_VERSION, "1.0.0");
        header.put(HEADER_ENABLE_UPDATE_CALLBACK, this.enableUpdateCallback ? "1" : "0");
        header.put(HEADER_NET_COST, this.netCost == null ? "-1" : this.netCost.toString());
        return header;
    }

    public synchronized void startListening(Properties props) {
        if (this.configChangedListener == null) {
            this.configChangedListener = new ConfigChangedListener(props, this);
        }
        if (this.configChangedListener.isStop()) {
            this.configChangedListener.start();
        }
    }

    protected void doCallback(List<ChangedConfigItem> changedConfigItems) {
        if (CollectionUtils.isEmpty(changedConfigItems)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Empty changed config items call back.");
            }
            return;
        }
        if (this.changedCallable != null && !this.changedCallable.isEmpty()) {
            List<ChangedConfigItem> changedItems = Collections.unmodifiableList(changedConfigItems);
            for (ConfigItemChangedCallable configItemChangedCallable : this.changedCallable) {
                try {
                    configItemChangedCallable.changed(changedItems);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String getCcServerUrl() {
        return this.ccServerUrl;
    }

    public void setCcServerUrl(String ccServerUrl) {
        this.ccServerUrl = ccServerUrl;
    }

    public String getApiPassword() {
        return this.apiPassword;
    }

    public void setApiPassword(String apiPassword) {
        this.apiPassword = apiPassword;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getCcVersionName() {
        return this.ccVersionName;
    }

    public void setCcVersionName(String ccVersionName) {
        this.ccVersionName = ccVersionName;
    }

    public boolean isEnableUpdateCallback() {
        return this.enableUpdateCallback;
    }

    public void setEnableUpdateCallback(boolean enableUpdateCallback) {
        this.enableUpdateCallback = enableUpdateCallback;
    }

    public boolean isEnableGray() {
        return this.enableGray;
    }

    public void setEnableGray(boolean enableGray) {
        this.enableGray = enableGray;
    }

    public Properties getRccProperties() {
        return this.rccProperties;
    }

    public void setRccProperties(Properties rccProperties) {
        this.rccProperties = rccProperties;
    }

    public String getCurrentToken() {
        return this.currentToken;
    }

    public String getLastCheckSum() {
        return this.lastCheckSum;
    }

    public void setLastCheckSum(String lastCheckSum) {
        this.lastCheckSum = lastCheckSum;
    }

    public void setCurrentToken(String currentToken) {
        this.currentToken = currentToken;
    }

    public long getCallbackInteval() {
        return this.callbackInteval;
    }

    public void setChangedCallable(Collection<ConfigItemChangedCallable> changedCallable) {
        this.changedCallable = changedCallable;
    }

    public void destory() {
    }
}

