/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc.utils.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;

public class GsonDateDefaultAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            String stringValue = json.getAsString();
            if (stringValue.equals("") || stringValue.equals("null")) {
                return null;
            }
            return new Date(json.getAsJsonPrimitive().getAsLong());
        }
        return null;
    }

    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive((Number)src.getTime());
    }
}

