/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc.utils.gson;

import com.baidu.brcc.utils.gson.GsonDateDefaultAdapter;
import com.baidu.brcc.utils.gson.GsonNumberDefaultAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class GsonFactory {
    public static Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = GsonFactory.registerAdapter(gsonBuilder).create();
        return gson;
    }

    private static GsonBuilder registerAdapter(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new GsonDateDefaultAdapter()).registerTypeAdapter(Byte.class, (Object)new GsonNumberDefaultAdapter<Byte>(){

            @Override
            public Byte returnNull() {
                return null;
            }

            @Override
            public Byte returnValue(JsonElement json) {
                return json.getAsByte();
            }
        }).registerTypeAdapter(Byte.TYPE, (Object)new GsonNumberDefaultAdapter<Byte>(){

            @Override
            public Byte returnNull() {
                return (byte)0;
            }

            @Override
            public Byte returnValue(JsonElement json) {
                return json.getAsByte();
            }
        }).registerTypeAdapter(Short.class, (Object)new GsonNumberDefaultAdapter<Short>(){

            @Override
            public Short returnNull() {
                return null;
            }

            @Override
            public Short returnValue(JsonElement json) {
                return json.getAsShort();
            }
        }).registerTypeAdapter(Short.TYPE, (Object)new GsonNumberDefaultAdapter<Short>(){

            @Override
            public Short returnNull() {
                return (short)0;
            }

            @Override
            public Short returnValue(JsonElement json) {
                return json.getAsShort();
            }
        }).registerTypeAdapter(Integer.class, (Object)new GsonNumberDefaultAdapter<Integer>(){

            @Override
            public Integer returnNull() {
                return null;
            }

            @Override
            public Integer returnValue(JsonElement json) {
                return json.getAsInt();
            }
        }).registerTypeAdapter(Integer.TYPE, (Object)new GsonNumberDefaultAdapter<Integer>(){

            @Override
            public Integer returnNull() {
                return 0;
            }

            @Override
            public Integer returnValue(JsonElement json) {
                return json.getAsInt();
            }
        }).registerTypeAdapter(Long.class, (Object)new GsonNumberDefaultAdapter<Long>(){

            @Override
            public Long returnNull() {
                return null;
            }

            @Override
            public Long returnValue(JsonElement json) {
                return json.getAsLong();
            }
        }).registerTypeAdapter(Long.TYPE, (Object)new GsonNumberDefaultAdapter<Long>(){

            @Override
            public Long returnNull() {
                return 0L;
            }

            @Override
            public Long returnValue(JsonElement json) {
                return json.getAsLong();
            }
        }).registerTypeAdapter(BigInteger.class, (Object)new GsonNumberDefaultAdapter<BigInteger>(){

            @Override
            public BigInteger returnNull() {
                return null;
            }

            @Override
            public BigInteger returnValue(JsonElement json) {
                return json.getAsBigInteger();
            }
        }).registerTypeAdapter(Float.class, (Object)new GsonNumberDefaultAdapter<Float>(){

            @Override
            public Float returnNull() {
                return null;
            }

            @Override
            public Float returnValue(JsonElement json) {
                return Float.valueOf(json.getAsFloat());
            }
        }).registerTypeAdapter(Float.TYPE, (Object)new GsonNumberDefaultAdapter<Float>(){

            @Override
            public Float returnNull() {
                return Float.valueOf(0.0f);
            }

            @Override
            public Float returnValue(JsonElement json) {
                return Float.valueOf(json.getAsFloat());
            }
        }).registerTypeAdapter(Double.class, (Object)new GsonNumberDefaultAdapter<Double>(){

            @Override
            public Double returnNull() {
                return null;
            }

            @Override
            public Double returnValue(JsonElement json) {
                return json.getAsDouble();
            }
        }).registerTypeAdapter(Double.TYPE, (Object)new GsonNumberDefaultAdapter<Double>(){

            @Override
            public Double returnNull() {
                return 0.0;
            }

            @Override
            public Double returnValue(JsonElement json) {
                return json.getAsDouble();
            }
        }).registerTypeAdapter(BigDecimal.class, (Object)new GsonNumberDefaultAdapter<BigDecimal>(){

            @Override
            public BigDecimal returnNull() {
                return null;
            }

            @Override
            public BigDecimal returnValue(JsonElement json) {
                return json.getAsBigDecimal();
            }
        });
        return gsonBuilder;
    }
}

