/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc.spring;

import com.baidu.brcc.ConfigItemChangedCallable;
import com.baidu.brcc.ConfigLoader;
import com.baidu.brcc.exception.RccException;
import com.baidu.brcc.utils.StringUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

public class ConfigCenterPropertyPlaceholderConfigurer
extends PropertySourcesPlaceholderConfigurer
implements ApplicationContextAware,
DisposableBean,
ApplicationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCenterPropertyPlaceholderConfigurer.class);
    private Environment environment;
    private ApplicationContext applicationContext;
    public static final String RCC_PROPERTIES_PROPERTY_SOURCE_NAME = "rccProperties";
    protected Properties ccLoadedProps;
    protected Properties cachedProps = new Properties();
    private boolean rccLoaded = false;
    protected Properties rccProperties = null;
    private boolean enableInterruptService = true;
    private boolean enableGray = false;
    private boolean enableUpdateCallback = false;
    private int connectionTimeout = 3000;
    private int readTimeout = 10000;
    private long callbackInteval = 2000L;
    private String ccServerUrl;
    private String ccPassword;
    private long ccVersion;
    private String ccVersionName;
    private long ccEnvId;
    private boolean logProperties = false;
    private String projectName;
    private String envName;
    private ConfigLoader configLoader;
    private volatile boolean callbackStarted = false;

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public void setEnvironment(Environment environment) {
        if (environment == null) {
            return;
        }
        super.setEnvironment(environment);
        this.environment = environment;
    }

    public void setLogProperties(boolean logProperties) {
        this.logProperties = logProperties;
    }

    public void setCallbackInteval(long callbackInteval) {
        this.callbackInteval = callbackInteval;
    }

    public void setEnableInterruptService(boolean enableInterruptService) {
        this.enableInterruptService = enableInterruptService;
    }

    public void setEnableGray(boolean enableGray) {
        this.enableGray = enableGray;
    }

    public void setCcServerUrl(String ccServerUrl) {
        this.ccServerUrl = ccServerUrl;
    }

    public void setCcPassword(String ccPassword) {
        this.ccPassword = ccPassword;
    }

    public void setCcVersion(long ccVersion) {
        this.ccVersion = ccVersion;
    }

    public void setCcVersionName(String ccVersionName) {
        this.ccVersionName = ccVersionName;
    }

    public void setCcEnvId(long ccEnvId) {
        this.ccEnvId = ccEnvId;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setEnableUpdateCallback(boolean enableUpdateCallback) {
        this.enableUpdateCallback = enableUpdateCallback;
    }

    protected void doProcessProperties(ConfigurableListableBeanFactory beanFactoryToProcess, final StringValueResolver valueResolver) {
        String valueSeparatorTmp;
        PropertySourcesPropertyResolver rccPropertySourcesPropertyResolver;
        block7: {
            Properties ccProperty = new Properties();
            try {
                if (!this.rccLoaded || this.rccProperties == null) {
                    this.rccProperties = this.loadPropertiesFromCC(this.cachedProps);
                }
                ccProperty.putAll((Map<?, ?>)this.rccProperties);
            }
            catch (IOException ex) {
                throw new RccException("load rcc fail");
            }
            PropertiesPropertySource rccPropertySource = new PropertiesPropertySource(RCC_PROPERTIES_PROPERTY_SOURCE_NAME, ccProperty);
            MutablePropertySources rccPropertySources = new MutablePropertySources();
            rccPropertySources.addFirst((PropertySource)rccPropertySource);
            if (this.environment instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)this.environment;
                configurableEnvironment.getPropertySources().addFirst((PropertySource)rccPropertySource);
            }
            rccPropertySourcesPropertyResolver = new PropertySourcesPropertyResolver((PropertySources)rccPropertySources);
            valueSeparatorTmp = null;
            try {
                valueSeparatorTmp = ConfigCenterPropertyPlaceholderConfigurer.getFieldValue(rccPropertySourcesPropertyResolver, "valueSeparator", String.class);
            }
            catch (Exception ex) {
                if (!LOGGER.isErrorEnabled()) break block7;
                LOGGER.error("get field valueSeparator by feflection error", (Throwable)ex);
            }
        }
        if (valueSeparatorTmp == null) {
            valueSeparatorTmp = ":";
        }
        final String valueSeparator = valueSeparatorTmp;
        final StringValueResolver rccValueResolver = new StringValueResolver(){

            public String resolveStringValue(String strVal) {
                if (strVal.contains(valueSeparator) && !rccPropertySourcesPropertyResolver.containsProperty(strVal.split(valueSeparator)[0].trim())) {
                    return strVal;
                }
                String resolved = rccPropertySourcesPropertyResolver.resolvePlaceholders(strVal);
                if (resolved == null) {
                    return null;
                }
                return resolved.equals(ConfigCenterPropertyPlaceholderConfigurer.this.nullValue) ? null : resolved;
            }
        };
        StringValueResolver delegateStringResolver = new StringValueResolver(){

            public String resolveStringValue(String strVal) {
                String resolved = rccValueResolver.resolveStringValue(strVal);
                if (resolved == null) {
                    return null;
                }
                if (resolved.equals(strVal)) {
                    resolved = valueResolver.resolveStringValue(strVal);
                    return resolved.equals(ConfigCenterPropertyPlaceholderConfigurer.this.nullValue) ? null : resolved;
                }
                return resolved;
            }
        };
        super.doProcessProperties(beanFactoryToProcess, delegateStringResolver);
    }

    protected void doLogLoadedProperties(Properties props) {
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        StringBuilder logContent = new StringBuilder();
        logContent.append("Loaded property list:\n");
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> next = iterator.next();
            logContent.append(next.getKey()).append("=");
            String value = String.valueOf(next.getValue());
            if (value == null) {
                logContent.append("\n");
                continue;
            }
            int length = value.length();
            if (length < 2) {
                logContent.append("...");
            } else {
                int sub = length / 2;
                logContent.append(StringUtils.substring(value, 0, sub));
                logContent.append("...");
            }
            logContent.append("\n");
        }
        LOGGER.info(logContent.toString());
    }

    private Map<String, String> loadFromCC() throws IOException {
        this.checkValid();
        return this.configLoader.getFromCC();
    }

    private void checkValid() throws IOException {
        if (this.configLoader == null) {
            this.configLoader = new ConfigLoader(this.ccServerUrl, this.ccPassword, this.projectName, this.envName, this.ccVersionName, this.enableUpdateCallback, this.connectionTimeout, this.readTimeout, this.callbackInteval, this.enableInterruptService, this.enableGray);
        }
    }

    private Properties loadPropertiesFromCC(Properties props) throws IOException {
        Map<String, String> configItems = this.loadFromCC();
        Properties rccProperties = new Properties();
        if (configItems != null) {
            this.ccLoadedProps = new Properties();
            this.ccLoadedProps.putAll(configItems);
            rccProperties.putAll(configItems);
            props.putAll(configItems);
        }
        if (this.logProperties) {
            this.doLogLoadedProperties(rccProperties);
        }
        this.rccLoaded = true;
        return rccProperties;
    }

    protected void loadProperties(Properties props) throws IOException {
        if (this.cachedProps != null) {
            props.putAll((Map<?, ?>)this.cachedProps);
            return;
        }
        this.cachedProps = new Properties(props);
        super.loadProperties(props);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        if (this.configLoader != null) {
            this.configLoader.destory();
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!this.callbackStarted && event instanceof ContextRefreshedEvent) {
            if (this.enableUpdateCallback) {
                Map map = this.applicationContext.getBeansOfType(ConfigItemChangedCallable.class);
                if (map != null && !map.isEmpty()) {
                    this.configLoader.setChangedCallable(map.values());
                }
                this.configLoader.startListening(this.ccLoadedProps);
            }
            this.callbackStarted = true;
        }
    }

    public Map<String, String> getProperties() {
        if (this.cachedProps == null) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> ret = new HashMap<Object, Object>(this.cachedProps);
        return ret;
    }

    public static <T> T getFieldValue(Object target, String fieldName, Class<T> returnType) throws IllegalAccessException {
        if (target == null || !StringUtils.hasText(fieldName)) {
            return null;
        }
        Class<?> targetClass = target.getClass();
        Field field = ReflectionUtils.findField(targetClass, (String)fieldName);
        if (field == null) {
            return null;
        }
        boolean oldAccessible = field.isAccessible();
        boolean change = false;
        if (!oldAccessible) {
            field.setAccessible(true);
            change = true;
        }
        Object o = field.get(target);
        if (change) {
            field.setAccessible(oldAccessible);
        }
        return returnType.cast(o);
    }
}

