/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.availability.asset;

import com.bernardomg.tabletop.dreadball.model.availability.asset.TeamTypeAssetsAvailability;
import com.bernardomg.tabletop.dreadball.model.faction.TeamType;
import com.bernardomg.tabletop.dreadball.model.persistence.faction.PersistentTeamType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity(name="TeamTypeAssetsAvailability")
@Table(name="team_type_asset_avas")
public final class PersistentTeamTypeAssetsAvailability
implements TeamTypeAssetsAvailability,
Serializable {
    private static final long serialVersionUID = -5016337593543278027L;
    @Column(name="cost_card")
    private Integer costCard = 0;
    @Column(name="cost_cheerleader")
    private Integer costCheerleader = 0;
    @Column(name="cost_coaching")
    private Integer costCoaching = 0;
    @Column(name="cost_dice")
    private Integer costDice = 0;
    @Column(name="def_coach")
    private Boolean defCoach = false;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id = -1;
    @Column(name="initial_card")
    private Integer initialCard = 0;
    @Column(name="initial_cheerleader")
    private Integer initialCheer = 0;
    @Column(name="initial_dice")
    private Integer initialDice = 0;
    @Column(name="max_card")
    private Integer maxCard = 0;
    @Column(name="max_cheerleader")
    private Integer maxCheerleader = 0;
    @Column(name="max_dice")
    private Integer maxDice = 0;
    @Column(name="off_coach")
    private Boolean offCoach = false;
    @Column(name="sup_coach")
    private Boolean supCoach = false;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="team_type_id")
    private PersistentTeamType teamType;

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentTeamTypeAssetsAvailability other = (PersistentTeamTypeAssetsAvailability)obj;
        return Objects.equals(this.teamType, other.teamType);
    }

    public final Integer getCheerleaderCost() {
        return this.costCheerleader;
    }

    public final Integer getCheerleaderInitial() {
        return this.initialCheer;
    }

    public final Integer getCheerleaderMax() {
        return this.maxCheerleader;
    }

    public final Integer getCoachingDieCost() {
        return this.costDice;
    }

    public final Integer getCoachingDieInitial() {
        return this.initialDice;
    }

    public final Integer getCoachingDieMax() {
        return this.maxDice;
    }

    public final Integer getCoachingStaffCost() {
        return this.costCoaching;
    }

    public final Integer getDreadballCardCost() {
        return this.costCard;
    }

    public final Integer getDreadballCardInitial() {
        return this.initialCard;
    }

    public final Integer getDreadballCardMax() {
        return this.maxCard;
    }

    public final Integer getId() {
        return this.id;
    }

    public final Boolean getStartingWithDefensiveCoachingStaff() {
        return this.defCoach;
    }

    public final Boolean getStartingWithOffensiveCoachingStaff() {
        return this.offCoach;
    }

    public final Boolean getStartingWithSupportCoachingStaff() {
        return this.supCoach;
    }

    public final TeamType getTeamType() {
        return this.teamType;
    }

    public final int hashCode() {
        return Objects.hash(this.teamType);
    }

    public final void setCheerleadersCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costCheerleader = cost;
    }

    public final void setCheerleadersInitial(Integer initial) {
        Preconditions.checkNotNull((Object)initial, (Object)"Received a null pointer as initial count");
        this.initialCheer = initial;
    }

    public final void setCheerleadersMax(Integer max) {
        Preconditions.checkNotNull((Object)max, (Object)"Received a null pointer as max count");
        this.maxCheerleader = max;
    }

    public final void setCoachingDieCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costDice = cost;
    }

    public final void setCoachingDieInitial(Integer initial) {
        Preconditions.checkNotNull((Object)initial, (Object)"Received a null pointer as initial count");
        this.initialDice = initial;
    }

    public final void setCoachingDieMax(Integer max) {
        Preconditions.checkNotNull((Object)max, (Object)"Received a null pointer as max count");
        this.maxDice = max;
    }

    public final void setCoachingStaffCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costCoaching = cost;
    }

    public final void setDreadballCardCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costCard = cost;
    }

    public final void setDreadballCardInitial(Integer initial) {
        Preconditions.checkNotNull((Object)initial, (Object)"Received a null pointer as initial count");
        this.initialCard = initial;
    }

    public final void setDreadballCardMax(Integer max) {
        Preconditions.checkNotNull((Object)max, (Object)"Received a null pointer as max count");
        this.maxCard = max;
    }

    public final void setId(Integer identifier) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Received a null pointer as id");
        this.id = identifier;
    }

    public final void setStartingWithDefensiveCoachingStaff(Boolean coach) {
        Preconditions.checkNotNull((Object)coach, (Object)"Received a null pointer as coach flag");
        this.defCoach = coach;
    }

    public final void setStartingWithOffensiveCoachingStaff(Boolean coach) {
        Preconditions.checkNotNull((Object)coach, (Object)"Received a null pointer as coach flag");
        this.offCoach = coach;
    }

    public final void setStartingWithSupportCoachingStaff(Boolean coach) {
        Preconditions.checkNotNull((Object)coach, (Object)"Received a null pointer as coach flag");
        this.supCoach = coach;
    }

    public final void setTeamType(PersistentTeamType team) {
        Preconditions.checkNotNull((Object)team, (Object)"Received a null pointer as team type");
        this.teamType = team;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }
}

