/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.availability.unit;

import com.bernardomg.tabletop.dreadball.model.availability.unit.SponsorAffinityGroupAvailability;
import com.bernardomg.tabletop.dreadball.model.persistence.unit.PersistentAffinityGroup;
import com.bernardomg.tabletop.dreadball.model.unit.AffinityGroup;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity(name="SponsorAffinityGroupAvailability")
@Table(name="sponsor_affinity_avas")
public final class PersistentSponsorAffinityGroupAvailability
implements SponsorAffinityGroupAvailability,
Serializable {
    private static final long serialVersionUID = -6796465298138862022L;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="sponsor_affinity_avas_affinity_groups", joinColumns={@JoinColumn(name="sponsor_affinity_ava_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="affinity_id", referencedColumnName="id")})
    private final Collection<PersistentAffinityGroup> affinities = new LinkedHashSet<PersistentAffinityGroup>();
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id = -1;
    @Column(name="name", unique=true)
    private String name = "";
    @Column(name="rank_increase", unique=true)
    private Boolean rankIncrease = false;

    public final void addAffinityGroup(AffinityGroup affinity) {
        Preconditions.checkArgument((boolean)(affinity instanceof PersistentAffinityGroup), (Object)"The AffinityGroup should be an instance of JPAAffinityGroup");
        this.getAffinityGroupsModifiable().add((PersistentAffinityGroup)affinity);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentSponsorAffinityGroupAvailability other = (PersistentSponsorAffinityGroupAvailability)obj;
        return Objects.equals(this.name, other.name);
    }

    public final Collection<AffinityGroup> getAffinityGroups() {
        ArrayList<AffinityGroup> result = new ArrayList<AffinityGroup>();
        for (AffinityGroup affinityGroup : this.getAffinityGroupsModifiable()) {
            result.add(affinityGroup);
        }
        return result;
    }

    public final Integer getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final int hashCode() {
        return Objects.hash(this.name);
    }

    public final Boolean isIncludingRankIncrease() {
        return this.rankIncrease;
    }

    public final void removeAffinityGroup(AffinityGroup affinity) {
        this.getAffinityGroupsModifiable().remove(affinity);
    }

    public final void setAffinityGroups(Collection<PersistentAffinityGroup> affinityGroups) {
        Preconditions.checkNotNull(affinityGroups, (Object)"Received a null pointer as groups");
        this.getAffinityGroupsModifiable().clear();
        this.getAffinityGroupsModifiable().addAll(affinityGroups);
    }

    public final void setId(Integer identifier) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Received a null pointer as identifier");
        this.id = identifier;
    }

    public final void setIncludingRankIncrease(Boolean increase) {
        this.rankIncrease = increase;
    }

    public final void setName(String nameAva) {
        Preconditions.checkNotNull((Object)nameAva, (Object)"Received a null pointer as name");
        this.name = nameAva;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    private final Collection<PersistentAffinityGroup> getAffinityGroupsModifiable() {
        return this.affinities;
    }
}

