/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.unit;

import com.bernardomg.tabletop.dreadball.model.persistence.unit.AbstractPersistentUnit;
import com.bernardomg.tabletop.dreadball.model.persistence.unit.component.PersistentComponent;
import com.bernardomg.tabletop.dreadball.model.unit.AdvancementUnit;
import com.bernardomg.tabletop.dreadball.model.unit.component.Component;
import com.google.common.base.Preconditions;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;

@MappedSuperclass
public abstract class AbstractPersistentAdvancementUnit
extends AbstractPersistentUnit
implements AdvancementUnit {
    @Column(name="experience")
    private Integer experience = 0;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="grafted_implant_id")
    private PersistentComponent implant;
    @Column(name="name")
    private String name = "";
    @Column(name="rank")
    private Integer rank = 0;

    public final Component getGraftedImplant() {
        return this.implant;
    }

    public final Integer getRank() {
        return this.rank;
    }

    public final Integer getUnspentExperience() {
        return this.experience;
    }

    public final Integer getValoration() {
        return null;
    }

    public final void setGraftedImplant(Component graft) {
        Preconditions.checkNotNull((Object)graft, (Object)"Received a null pointer as implant");
        Preconditions.checkArgument((boolean)(graft instanceof PersistentComponent), (Object)"The implant should be an instance of JPAComponent");
        this.implant = (PersistentComponent)graft;
    }

    public final void setRank(Integer rankUnit) {
        Preconditions.checkNotNull((Object)rankUnit, (Object)"Received a null pointer as rank");
        this.rank = rankUnit;
    }

    public final void setUnspentExperience(Integer exp) {
        Preconditions.checkNotNull((Object)exp, (Object)"Received a null pointer as experience");
        this.experience = exp;
    }
}

