/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.unit;

import com.bernardomg.tabletop.dreadball.model.persistence.unit.AbstractPersistentUnit;
import com.bernardomg.tabletop.dreadball.model.persistence.unit.PersistentAffinityGroup;
import com.bernardomg.tabletop.dreadball.model.unit.AffinityGroup;
import com.bernardomg.tabletop.dreadball.model.unit.AffinityUnit;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class AbstractPersistentAffinityUnit
extends AbstractPersistentUnit
implements AffinityUnit {
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="unit_affinities", joinColumns={@JoinColumn(name="unit_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="affinity_id", referencedColumnName="id")})
    private final Collection<PersistentAffinityGroup> affinities = new LinkedHashSet<PersistentAffinityGroup>();
    @Column(name="cost_ally")
    private Integer costAlly = 0;
    @Column(name="cost_friend")
    private Integer costFriend = 0;
    @Column(name="cost_stranger")
    private Integer costStranger = 0;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="unit_hated_affinities", joinColumns={@JoinColumn(name="unit_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="affinity_id", referencedColumnName="id")})
    private final Collection<PersistentAffinityGroup> hated = new LinkedHashSet<PersistentAffinityGroup>();

    public final void addAffinityGroup(PersistentAffinityGroup affinity) {
        Preconditions.checkNotNull((Object)affinity, (Object)"Received a null pointer as the affinity group");
        this.getAffinityGroupsModifiable().add(affinity);
    }

    public final void addHatedAffinityGroup(PersistentAffinityGroup affinity) {
        Preconditions.checkNotNull((Object)affinity, (Object)"Received a null pointer as the hated affinity group");
        this.getHatedAffinityGroupsModifiable().add(affinity);
    }

    public final Collection<AffinityGroup> getAffinityGroups() {
        ArrayList<AffinityGroup> col = new ArrayList<AffinityGroup>();
        for (AffinityGroup affinityGroup : this.getAffinityGroupsModifiable()) {
            col.add(affinityGroup);
        }
        return Collections.unmodifiableCollection(col);
    }

    public final Integer getAllyCost() {
        return this.costAlly;
    }

    public final Integer getFriendCost() {
        return this.costFriend;
    }

    public final Collection<AffinityGroup> getHatedAffinityGroups() {
        ArrayList<AffinityGroup> col = new ArrayList<AffinityGroup>();
        for (AffinityGroup affinityGroup : this.getHatedAffinityGroupsModifiable()) {
            col.add(affinityGroup);
        }
        return Collections.unmodifiableCollection(col);
    }

    public final Integer getStrangerCost() {
        return this.costStranger;
    }

    public final void removeAffinityGroup(AffinityGroup affinity) {
        Preconditions.checkNotNull((Object)affinity, (Object)"Received a null pointer as the affinity group");
        this.getAffinityGroupsModifiable().remove(affinity);
    }

    public final void removeHatedAffinityGroup(AffinityGroup affinity) {
        Preconditions.checkNotNull((Object)affinity, (Object)"Received a null pointer as the hated affinity group");
        this.getHatedAffinityGroupsModifiable().remove(affinity);
    }

    public final void setAffinityGroups(Collection<AffinityGroup> affinityGroups) {
        Preconditions.checkNotNull(affinityGroups, (Object)"Received a null pointer as affinities");
        this.getAffinityGroupsModifiable().clear();
        for (AffinityGroup affinity : affinityGroups) {
            Preconditions.checkArgument((boolean)(affinity instanceof PersistentAffinityGroup), (Object)"All the affinities should be an instanceof JPAAffinityGroup");
            this.getAffinityGroupsModifiable().add((PersistentAffinityGroup)affinity);
        }
    }

    public final void setAllyCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as ally cost");
        this.costAlly = cost;
    }

    public final void setFriendCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as friend cost");
        this.costFriend = cost;
    }

    public final void setHatedAffinityGroups(Collection<AffinityGroup> affinityGroups) {
        Preconditions.checkNotNull(affinityGroups, (Object)"Received a null pointer as hated affinities");
        this.getHatedAffinityGroupsModifiable().clear();
        for (AffinityGroup affinity : affinityGroups) {
            Preconditions.checkArgument((boolean)(affinity instanceof PersistentAffinityGroup), (Object)"All the affinities should be an instanceof JPAAffinityGroup");
            this.getHatedAffinityGroupsModifiable().add((PersistentAffinityGroup)affinity);
        }
    }

    public final void setStrangerCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as stranger cost");
        this.costStranger = cost;
    }

    private final Collection<PersistentAffinityGroup> getAffinityGroupsModifiable() {
        return this.affinities;
    }

    private final Collection<PersistentAffinityGroup> getHatedAffinityGroupsModifiable() {
        return this.hated;
    }
}

