/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.unit;

import com.bernardomg.tabletop.dreadball.model.persistence.unit.stats.PersistentAbility;
import com.bernardomg.tabletop.dreadball.model.persistence.unit.stats.PersistentAttributes;
import com.bernardomg.tabletop.dreadball.model.unit.Role;
import com.bernardomg.tabletop.dreadball.model.unit.Unit;
import com.bernardomg.tabletop.dreadball.model.unit.stats.Ability;
import com.bernardomg.tabletop.dreadball.model.unit.stats.Attributes;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity(name="Unit")
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="unit_type")
@Table(name="units")
public abstract class AbstractPersistentUnit
implements Unit {
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="unit_abilities", joinColumns={@JoinColumn(name="unit_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="ability_id", referencedColumnName="id")})
    private final Collection<PersistentAbility> abilities = new LinkedHashSet<PersistentAbility>();
    @Embedded
    private PersistentAttributes attributes = new PersistentAttributes();
    @Column(name="cost")
    private Integer cost = 0;
    @Column(name="giant")
    private Boolean giant = false;
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    private Integer id = -1;
    @Column(name="mvp")
    private final Boolean mvp = false;
    @Column(name="name")
    private String name = "";
    @Column(name="position")
    @Enumerated(value=EnumType.STRING)
    private Role position = Role.JACK;
    @Column(name="template_name", unique=true)
    private String templateName = "";

    public final void addAbility(Ability ability) {
        Preconditions.checkNotNull((Object)ability, (Object)"Received a null pointer as ability");
        Preconditions.checkArgument((boolean)(ability instanceof PersistentAbility), (Object)"The Ability should be an instanceof JPAAbility");
        this.getAbilitiesModifiable().add((PersistentAbility)ability);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPersistentUnit other = (AbstractPersistentUnit)obj;
        return Objects.equals(this.templateName, other.templateName) && Objects.equals(this.name, other.name);
    }

    public final Collection<Ability> getAbilities() {
        ArrayList<Ability> col = new ArrayList<Ability>();
        for (Ability ability : this.getAbilitiesModifiable()) {
            col.add(ability);
        }
        return Collections.unmodifiableCollection(col);
    }

    public final Attributes getAttributes() {
        return this.attributes;
    }

    public final Integer getCost() {
        return this.cost;
    }

    public final Boolean getGiant() {
        return this.giant;
    }

    public final Integer getId() {
        return this.id;
    }

    public final Boolean getMvp() {
        return this.mvp;
    }

    public final String getName() {
        return this.name;
    }

    public final Role getRole() {
        return this.position;
    }

    public final String getTemplateName() {
        return this.templateName;
    }

    public final int hashCode() {
        return Objects.hash(this.templateName, this.name);
    }

    public final void removeAbility(Ability ability) {
        this.getAbilitiesModifiable().remove(ability);
    }

    public final void setAbilities(Collection<Ability> unitAbilities) {
        Preconditions.checkNotNull(unitAbilities, (Object)"Received a null pointer as abilities");
        this.getAbilitiesModifiable().clear();
        for (Ability ability : unitAbilities) {
            Preconditions.checkArgument((boolean)(ability instanceof PersistentAbility), (Object)"All the abilities should be an instanceof JPAAbility");
            this.getAbilitiesModifiable().add((PersistentAbility)ability);
        }
    }

    public final void setAttributes(Attributes attrs) {
        Preconditions.checkNotNull((Object)attrs, (Object)"Received a null pointer as attributes");
        Preconditions.checkArgument((boolean)(attrs instanceof PersistentAttributes), (Object)"The Attributes should be an instanceof JPAAttributes");
        this.attributes = (PersistentAttributes)attrs;
    }

    public final void setCost(Integer costUnit) {
        Preconditions.checkNotNull((Object)costUnit, (Object)"Received a null pointer as cost");
        this.cost = costUnit;
    }

    public final void setGiant(Boolean giantFlag) {
        Preconditions.checkNotNull((Object)giantFlag, (Object)"Received a null pointer as giant flag");
        this.giant = giantFlag;
    }

    public final void setId(Integer identifier) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Received a null pointer as identifier");
        this.id = identifier;
    }

    public final void setName(String unitName) {
        this.name = unitName;
    }

    public final void setPosition(Role pos) {
        Preconditions.checkNotNull((Object)pos, (Object)"Received a null pointer as team position role");
        this.position = pos;
    }

    public final void setTemplateName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Received a null pointer as name");
        this.templateName = name;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.templateName).add("id", (Object)this.id).toString();
    }

    private final Collection<PersistentAbility> getAbilitiesModifiable() {
        return this.abilities;
    }
}

