/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.availability.asset;

import com.bernardomg.tabletop.dreadball.model.availability.asset.SponsorAssetsAvailability;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity(name="SponsorAssetsAvailability")
@Table(name="sponsor_asset_avas")
public final class PersistentSponsorAssetsAvailability
implements SponsorAssetsAvailability,
Serializable {
    private static final long serialVersionUID = -7367447173870314061L;
    @Column(name="cost_affinity")
    private Integer costAffinity = 0;
    @Column(name="cost_cheerleader")
    private Integer costCheerleader = 0;
    @Column(name="cost_cheerleader_unlock")
    private Integer costCheerUnlock = 0;
    @Column(name="cost_dice")
    private Integer costDice = 0;
    @Column(name="cost_medibot")
    private Integer costMedibot = 0;
    @Column(name="cost_sabotage")
    private Integer costSabotage = 0;
    @Column(name="cost_special_move")
    private Integer costSpecialMove = 0;
    @Column(name="cost_wager")
    private Integer costWager = 0;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id = -1;
    @Column(name="max_wager")
    private Integer maxWager = 0;
    @Column(name="min_team_cost")
    private Integer minTeamCost = 0;

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentSponsorAssetsAvailability other = (PersistentSponsorAssetsAvailability)obj;
        return Objects.equals(this.id, other.id);
    }

    public final Integer getAffinityGroupCost() {
        return this.costAffinity;
    }

    public final Integer getCheerleaderCost() {
        return this.costCheerleader;
    }

    public final Integer getCheerleaderUnlockCost() {
        return this.costCheerUnlock;
    }

    public final Integer getCoachingDieCost() {
        return this.costDice;
    }

    public final Integer getId() {
        return this.id;
    }

    public final Integer getMediBotCost() {
        return this.costMedibot;
    }

    public final Integer getSabotageCardCost() {
        return this.costSabotage;
    }

    public final Integer getSpecialMovementCardCost() {
        return this.costSpecialMove;
    }

    public final Integer getTeamCostMin() {
        return this.minTeamCost;
    }

    public final Integer getWagerCost() {
        return this.costWager;
    }

    public final Integer getWagerMaxCount() {
        return this.maxWager;
    }

    public final int hashCode() {
        return Objects.hash(this.id);
    }

    public final void setAffinityGroupCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costAffinity = cost;
    }

    public final void setCheerleaderCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costCheerleader = cost;
    }

    public final void setCheerleaderUnlockCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costCheerUnlock = cost;
    }

    public final void setCoachingDieCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costDice = cost;
    }

    public final void setId(Integer identifier) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Received a null pointer as id");
        this.id = identifier;
    }

    public final void setMediBotCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costMedibot = cost;
    }

    public final void setSabotageCardCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costSabotage = cost;
    }

    public final void setSpecialMovementCardCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costSpecialMove = cost;
    }

    public final void setTeamCostMin(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.minTeamCost = cost;
    }

    public final void setWagerCost(Integer cost) {
        Preconditions.checkNotNull((Object)cost, (Object)"Received a null pointer as cost");
        this.costWager = cost;
    }

    public final void setWagerMaxCount(Integer max) {
        Preconditions.checkNotNull((Object)max, (Object)"Received a null pointer as maximum number of wagers");
        this.maxWager = max;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }
}

