/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.unit.component;

import com.bernardomg.tabletop.dreadball.model.persistence.unit.AbstractPersistentAdvancementUnit;
import com.bernardomg.tabletop.dreadball.model.persistence.unit.component.PersistentComponent;
import com.bernardomg.tabletop.dreadball.model.unit.component.Component;
import com.bernardomg.tabletop.dreadball.model.unit.component.CompositeAdvancementUnit;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity(name="CompositeAdvancementUnit")
@DiscriminatorValue(value="composite_advancement")
@Table(name="composite_advancement_units")
public final class PersistentCompositeAdvancementUnit
extends AbstractPersistentAdvancementUnit
implements CompositeAdvancementUnit,
Serializable {
    private static final long serialVersionUID = 4751347276326003773L;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="composite_unit_components", joinColumns={@JoinColumn(name="unit_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="component_id", referencedColumnName="id")})
    private final Collection<PersistentComponent> components = new LinkedHashSet<PersistentComponent>();

    public final void addComponent(PersistentComponent component) {
        Preconditions.checkNotNull((Object)component, (Object)"Received a null pointer as component");
        this.getComponentsModifiable().add(component);
    }

    public final Collection<Component> getComponents() {
        ArrayList<Component> col = new ArrayList<Component>();
        for (Component component : this.getComponentsModifiable()) {
            col.add(component);
        }
        return Collections.unmodifiableCollection(col);
    }

    public final void removeComponent(PersistentComponent component) {
        this.getComponentsModifiable().remove(component);
    }

    public final void setComponents(Collection<Component> unitComponents) {
        Preconditions.checkNotNull(unitComponents, (Object)"Received a null pointer as components");
        this.getComponentsModifiable().clear();
        for (Component component : unitComponents) {
            Preconditions.checkArgument((boolean)(component instanceof PersistentComponent), (Object)"All the components should be an instanceof JPAComponent");
            this.getComponentsModifiable().add((PersistentComponent)component);
        }
    }

    private final Collection<PersistentComponent> getComponentsModifiable() {
        return this.components;
    }
}

