/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.faction;

import com.bernardomg.tabletop.dreadball.model.faction.Sponsor;
import com.bernardomg.tabletop.dreadball.model.persistence.player.PersistentAffinityGroup;
import com.bernardomg.tabletop.dreadball.model.player.stats.AffinityGroup;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity(name="Sponsor")
@Table(name="sponsors")
public final class PersistentSponsor
implements Sponsor,
Serializable {
    private static final long serialVersionUID = -6236019919297159189L;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="sponsor_affinity_groups", joinColumns={@JoinColumn(name="sponsor_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="group_id", referencedColumnName="id")})
    private final Collection<PersistentAffinityGroup> affinities = new LinkedHashSet<PersistentAffinityGroup>();
    @Column(name="cash")
    private Integer cash = 0;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id = -1;
    @Column(name="name", unique=true)
    private String name = "";
    @Column(name="rank")
    private Integer rank = 0;

    public final void addAffinityGroup(AffinityGroup affinity) {
        Preconditions.checkArgument((boolean)(affinity instanceof PersistentAffinityGroup), (Object)"The AffinityGroup should be an instance of JPAAffinityGroup");
        this.getAffinityGroupsModifiable().add((PersistentAffinityGroup)affinity);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentSponsor other = (PersistentSponsor)obj;
        return Objects.equals(this.name, other.name);
    }

    public final Collection<AffinityGroup> getAffinityGroups() {
        ArrayList<AffinityGroup> result = new ArrayList<AffinityGroup>();
        for (AffinityGroup affinityGroup : this.getAffinityGroupsModifiable()) {
            result.add(affinityGroup);
        }
        return result;
    }

    public final Integer getCash() {
        return this.cash;
    }

    public final Integer getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final Integer getRank() {
        return this.rank;
    }

    public final int hashCode() {
        return Objects.hashCode(this.name);
    }

    public final void removeAffinityGroup(AffinityGroup affinity) {
        this.getAffinityGroupsModifiable().remove(affinity);
    }

    public final void setAffinityGroups(Collection<AffinityGroup> affinityGroups) {
        this.getAffinityGroupsModifiable().clear();
        if (affinityGroups != null) {
            for (AffinityGroup affinity : affinityGroups) {
                Preconditions.checkArgument((boolean)(affinity instanceof PersistentAffinityGroup), (Object)"The affinities should be an instance of JPAAffinityGroup");
                this.getAffinityGroupsModifiable().add((PersistentAffinityGroup)affinity);
            }
        }
    }

    public final void setCash(Integer spareCash) {
        this.cash = spareCash;
    }

    public final void setId(Integer identifier) {
        this.id = identifier;
    }

    public final void setName(String sponsorName) {
        this.name = sponsorName;
    }

    public final void setRank(Integer sponsorRank) {
        this.rank = sponsorRank;
    }

    public final void setSponsorName(String sponsorName) {
        this.name = sponsorName;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    private final Collection<PersistentAffinityGroup> getAffinityGroupsModifiable() {
        return this.affinities;
    }
}

