/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.player;

import com.bernardomg.tabletop.dreadball.model.persistence.player.stats.PersistentAbility;
import com.bernardomg.tabletop.dreadball.model.persistence.player.stats.PersistentAttributes;
import com.bernardomg.tabletop.dreadball.model.player.Role;
import com.bernardomg.tabletop.dreadball.model.player.TeamPlayer;
import com.bernardomg.tabletop.dreadball.model.player.stats.Ability;
import com.bernardomg.tabletop.dreadball.model.player.stats.Attributes;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity(name="Player")
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="player_type")
@Table(name="players")
public abstract class AbstractPersistentTeamPlayer
implements TeamPlayer {
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="player_abilities", joinColumns={@JoinColumn(name="player_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="ability_id", referencedColumnName="id")})
    private final Collection<PersistentAbility> abilities = new LinkedHashSet<PersistentAbility>();
    @Embedded
    private PersistentAttributes attributes = new PersistentAttributes();
    @Column(name="cost")
    private Integer cost = 0;
    @Column(name="giant")
    private Boolean giant = false;
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    private Integer id = -1;
    @Column(name="mvp")
    private final Boolean mvp = false;
    @Column(name="name")
    private String name = "";
    @Column(name="position")
    @Enumerated(value=EnumType.STRING)
    private Role role = Role.JACK;
    @Column(name="template_name", unique=true)
    private String templateName = "";

    public final void addAbility(Ability ability) {
        Preconditions.checkArgument((boolean)(ability instanceof PersistentAbility), (Object)"The Ability should be an instanceof JPAAbility");
        this.getAbilitiesModifiable().add((PersistentAbility)ability);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPersistentTeamPlayer other = (AbstractPersistentTeamPlayer)obj;
        return Objects.equals(this.templateName, other.templateName) && Objects.equals(this.name, other.name);
    }

    public final Collection<Ability> getAbilities() {
        ArrayList<Ability> col = new ArrayList<Ability>();
        for (Ability ability : this.getAbilitiesModifiable()) {
            col.add(ability);
        }
        return Collections.unmodifiableCollection(col);
    }

    public final Attributes getAttributes() {
        return this.attributes;
    }

    public final Integer getCost() {
        return this.cost;
    }

    public final Boolean getGiant() {
        return this.giant;
    }

    public final Integer getId() {
        return this.id;
    }

    public final Boolean getMvp() {
        return this.mvp;
    }

    public final String getName() {
        return this.name;
    }

    public final Role getRole() {
        return this.role;
    }

    public final String getTemplateName() {
        return this.templateName;
    }

    public final int hashCode() {
        return Objects.hash(this.templateName, this.name);
    }

    public final void removeAbility(Ability ability) {
        this.getAbilitiesModifiable().remove(ability);
    }

    public final void setAbilities(Collection<Ability> playerAbilities) {
        this.getAbilitiesModifiable().clear();
        if (playerAbilities != null) {
            for (Ability ability : playerAbilities) {
                Preconditions.checkArgument((boolean)(ability instanceof PersistentAbility), (Object)"All the abilities should be an instanceof JPAAbility");
                this.getAbilitiesModifiable().add((PersistentAbility)ability);
            }
        }
    }

    public final void setAttributes(Attributes attrs) {
        Preconditions.checkArgument((boolean)(attrs instanceof PersistentAttributes), (Object)"The Attributes should be an instanceof JPAAttributes");
        this.attributes = (PersistentAttributes)attrs;
    }

    public final void setCost(Integer costPlayer) {
        this.cost = costPlayer;
    }

    public final void setGiant(Boolean giantFlag) {
        this.giant = giantFlag;
    }

    public final void setId(Integer identifier) {
        this.id = identifier;
    }

    public final void setName(String playerName) {
        this.name = playerName;
    }

    public final void setRole(Role pos) {
        this.role = pos;
    }

    public final void setTemplateName(String tname) {
        this.templateName = tname;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.templateName).add("id", (Object)this.id).toString();
    }

    private final Collection<PersistentAbility> getAbilitiesModifiable() {
        return this.abilities;
    }
}

