/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.player.component;

import com.bernardomg.tabletop.dreadball.model.persistence.player.component.PersistentComponentLocation;
import com.bernardomg.tabletop.dreadball.model.persistence.player.stats.PersistentAbility;
import com.bernardomg.tabletop.dreadball.model.persistence.player.stats.PersistentAttributes;
import com.bernardomg.tabletop.dreadball.model.player.Role;
import com.bernardomg.tabletop.dreadball.model.player.component.Component;
import com.bernardomg.tabletop.dreadball.model.player.component.ComponentLocation;
import com.bernardomg.tabletop.dreadball.model.player.stats.Ability;
import com.bernardomg.tabletop.dreadball.model.player.stats.Attributes;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class AbstractPersistentComponent
implements Component {
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="COMPONENT_ABILITIES", joinColumns={@JoinColumn(name="component_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="ability_id", referencedColumnName="id")})
    private final Collection<PersistentAbility> abilities = new LinkedHashSet<PersistentAbility>();
    @Embedded
    private PersistentAttributes attributes = new PersistentAttributes();
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    private Integer id = -1;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="location_id")
    private PersistentComponentLocation location;
    @Column(name="name", unique=true)
    private String name = "";
    @ElementCollection(targetClass=Role.class)
    @JoinTable(name="COMPONENT_ROLES", joinColumns={@JoinColumn(name="component_id")})
    @Enumerated(value=EnumType.STRING)
    @Column(name="role")
    private final Collection<Role> roles = new LinkedHashSet<Role>();

    public final void addAbility(Ability ability) {
        Preconditions.checkArgument((boolean)(ability instanceof PersistentAbility), (Object)"The Ability should be an instanceof JPAAbility");
        this.getAbilitiesModifiable().add((PersistentAbility)ability);
    }

    public final void addRole(Role role) {
        this.getRolesModifiable().add(role);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPersistentComponent other = (AbstractPersistentComponent)obj;
        return Objects.equals(this.name, other.name);
    }

    public final Collection<Ability> getAbilities() {
        ArrayList<Ability> col = new ArrayList<Ability>();
        for (Ability ability : this.getAbilitiesModifiable()) {
            col.add(ability);
        }
        return Collections.unmodifiableCollection(col);
    }

    public final Attributes getAttributes() {
        return this.attributes;
    }

    public final Integer getId() {
        return this.id;
    }

    public final ComponentLocation getLocation() {
        return this.location;
    }

    public final String getName() {
        return this.name;
    }

    public final Collection<Role> getRoles() {
        return Collections.unmodifiableCollection(this.getRolesModifiable());
    }

    public final int hashCode() {
        return Objects.hashCode(this.name);
    }

    public final void removeAbility(Ability ability) {
        this.getAbilitiesModifiable().remove(ability);
    }

    public final void removeRole(Role role) {
        this.getRolesModifiable().remove(role);
    }

    public final void setAbilities(Collection<Ability> compAbilities) {
        if (compAbilities != null) {
            for (Ability ability : compAbilities) {
                Preconditions.checkArgument((boolean)(ability instanceof PersistentAbility), (Object)"All the abilities should be an instanceof JPAAbility");
                this.getAbilitiesModifiable().add((PersistentAbility)ability);
            }
        }
    }

    public final void setAttributes(Attributes attrs) {
        Preconditions.checkArgument((boolean)(attrs instanceof PersistentAttributes), (Object)"The Attributes should be an instanceof JPAAttributes");
        this.attributes = (PersistentAttributes)attrs;
    }

    public final void setComponentName(String componentName) {
        this.name = componentName;
    }

    public final void setId(Integer identifier) {
        this.id = identifier;
    }

    public final void setLocation(PersistentComponentLocation compLocation) {
        this.location = compLocation;
    }

    public final void setRole(Collection<Role> comRoles) {
        this.getRolesModifiable().clear();
        if (comRoles != null) {
            this.getRolesModifiable().addAll(comRoles);
        }
    }

    private final Collection<PersistentAbility> getAbilitiesModifiable() {
        return this.abilities;
    }

    private final Collection<Role> getRolesModifiable() {
        return this.roles;
    }
}

