/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.faction;

import com.bernardomg.tabletop.dreadball.model.faction.TeamRule;
import com.bernardomg.tabletop.dreadball.model.faction.TeamType;
import com.bernardomg.tabletop.dreadball.model.persistence.faction.PersistentTeamRule;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity(name="TeamType")
@Table(name="TEAM_TYPES")
public final class PersistentTeamType
implements TeamType,
Serializable {
    private static final long serialVersionUID = -6484889622281976716L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id = -1;
    @Column(name="name", unique=true)
    private String name = "";
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="TEAM_TYPE_RULES", joinColumns={@JoinColumn(name="team_type_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="team_rule_id", referencedColumnName="id")})
    private final Collection<PersistentTeamRule> rules = new LinkedHashSet<PersistentTeamRule>();

    public final void addTeamRule(TeamRule rule) {
        Preconditions.checkArgument((boolean)(rule instanceof PersistentTeamRule), (Object)"The TeamRule should be an instanceof JPATeamRule");
        this.getTeamRulesModifiable().add((PersistentTeamRule)rule);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentTeamType other = (PersistentTeamType)obj;
        return Objects.equals(this.name, other.name);
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Collection<TeamRule> getTeamRules() {
        ArrayList<TeamRule> col = new ArrayList<TeamRule>();
        for (TeamRule teamRule : this.getTeamRulesModifiable()) {
            col.add(teamRule);
        }
        return Collections.unmodifiableCollection(col);
    }

    public final int hashCode() {
        return Objects.hashCode(this.name);
    }

    public final void removeTeamRule(TeamRule rule) {
        this.getTeamRulesModifiable().remove(rule);
    }

    public void setId(Integer identifier) {
        this.id = identifier;
    }

    public void setTeamRules(Collection<TeamRule> teamRules) {
        this.getTeamRulesModifiable().clear();
        if (teamRules != null) {
            for (TeamRule rule : teamRules) {
                Preconditions.checkArgument((boolean)(rule instanceof PersistentTeamRule), (Object)"All the rules should be an instanceof JPATeamRule");
                this.getTeamRulesModifiable().add((PersistentTeamRule)rule);
            }
        }
    }

    public void setTeamTypeName(String typeName) {
        this.name = typeName;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    private final Collection<PersistentTeamRule> getTeamRulesModifiable() {
        return this.rules;
    }
}

