/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.player;

import com.bernardomg.tabletop.dreadball.model.persistence.player.AbstractPersistentTeamPlayer;
import com.bernardomg.tabletop.dreadball.model.persistence.player.stats.PersistentAffinityGroup;
import com.bernardomg.tabletop.dreadball.model.player.AffinityTeamPlayer;
import com.bernardomg.tabletop.dreadball.model.player.stats.AffinityGroup;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class AbstractPersistentAffinityTeamPlayer
extends AbstractPersistentTeamPlayer
implements AffinityTeamPlayer {
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="PLAYER_AFFINITIES", joinColumns={@JoinColumn(name="player_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="affinity_id", referencedColumnName="id")})
    private final Collection<PersistentAffinityGroup> affinities = new LinkedHashSet<PersistentAffinityGroup>();
    @Column(name="ally_cost")
    private Integer allyCost = 0;
    @Column(name="friend_cost")
    private Integer friendCost = 0;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="PLAYER_HATED_AFFINITIES", joinColumns={@JoinColumn(name="player_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="affinity_id", referencedColumnName="id")})
    private final Collection<PersistentAffinityGroup> hated = new LinkedHashSet<PersistentAffinityGroup>();
    @Column(name="stranger_cost")
    private Integer strangerCost = 0;

    public final void addAffinityGroup(PersistentAffinityGroup affinity) {
        this.getAffinityGroupsModifiable().add(affinity);
    }

    public final void addHatedAffinityGroup(PersistentAffinityGroup affinity) {
        this.getHatedAffinityGroupsModifiable().add(affinity);
    }

    public Collection<AffinityGroup> getAffinityGroups() {
        ArrayList<AffinityGroup> col = new ArrayList<AffinityGroup>();
        for (AffinityGroup affinityGroup : this.getAffinityGroupsModifiable()) {
            col.add(affinityGroup);
        }
        return Collections.unmodifiableCollection(col);
    }

    public Integer getAllyCost() {
        return this.allyCost;
    }

    public Integer getFriendCost() {
        return this.friendCost;
    }

    public Collection<AffinityGroup> getHatedAffinityGroups() {
        ArrayList<AffinityGroup> col = new ArrayList<AffinityGroup>();
        for (AffinityGroup affinityGroup : this.getHatedAffinityGroupsModifiable()) {
            col.add(affinityGroup);
        }
        return Collections.unmodifiableCollection(col);
    }

    public Integer getStrangerCost() {
        return this.strangerCost;
    }

    public final void removeAffinityGroup(AffinityGroup affinity) {
        this.getAffinityGroupsModifiable().remove(affinity);
    }

    public final void removeHatedAffinityGroup(AffinityGroup affinity) {
        this.getHatedAffinityGroupsModifiable().remove(affinity);
    }

    public void setAffinityGroups(Collection<AffinityGroup> affinityGroups) {
        this.getAffinityGroupsModifiable().clear();
        if (affinityGroups != null) {
            for (AffinityGroup affinity : affinityGroups) {
                Preconditions.checkArgument((boolean)(affinity instanceof PersistentAffinityGroup), (Object)"All the affinities should be an instanceof JPAAffinityGroup");
                this.getAffinityGroupsModifiable().add((PersistentAffinityGroup)affinity);
            }
        }
    }

    public void setAllyCost(Integer cost) {
        this.allyCost = cost;
    }

    public void setFriendCost(Integer cost) {
        this.friendCost = cost;
    }

    public void setHatedAffinityGroups(Collection<AffinityGroup> affinityGroups) {
        this.getHatedAffinityGroupsModifiable().clear();
        if (affinityGroups != null) {
            for (AffinityGroup affinity : affinityGroups) {
                Preconditions.checkArgument((boolean)(affinity instanceof PersistentAffinityGroup), (Object)"All the affinities should be an instanceof JPAAffinityGroup");
                this.getHatedAffinityGroupsModifiable().add((PersistentAffinityGroup)affinity);
            }
        }
    }

    public void setStrangerCost(Integer cost) {
        this.strangerCost = cost;
    }

    private final Collection<PersistentAffinityGroup> getAffinityGroupsModifiable() {
        return this.affinities;
    }

    private final Collection<PersistentAffinityGroup> getHatedAffinityGroupsModifiable() {
        return this.hated;
    }
}

