/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.player.component;

import com.bernardomg.tabletop.dreadball.model.persistence.player.AbstractPersistentAffinityTeamPlayer;
import com.bernardomg.tabletop.dreadball.model.persistence.player.component.PersistentComponent;
import com.bernardomg.tabletop.dreadball.model.player.component.Component;
import com.bernardomg.tabletop.dreadball.model.player.component.CompositeAffinityTeamPlayer;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity(name="CompositeAffinityPlayer")
@DiscriminatorValue(value="composite_affinity")
@Table(name="COMPOSITE_AFFINITY_PLAYERS")
public class PersistentCompositeAffinityTeamPlayer
extends AbstractPersistentAffinityTeamPlayer
implements CompositeAffinityTeamPlayer,
Serializable {
    private static final long serialVersionUID = -5866596776570200158L;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="PLAYER_COMPONENTS", joinColumns={@JoinColumn(name="player_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="component_id", referencedColumnName="id")})
    private final Collection<PersistentComponent> components = new LinkedHashSet<PersistentComponent>();

    public final void addComponent(PersistentComponent component) {
        this.getComponentsModifiable().add(component);
    }

    public Collection<Component> getComponents() {
        ArrayList<Component> col = new ArrayList<Component>();
        for (Component component : this.getComponentsModifiable()) {
            col.add(component);
        }
        return Collections.unmodifiableCollection(col);
    }

    public final void removeComponent(PersistentComponent component) {
        this.getComponentsModifiable().remove(component);
    }

    public void setComponents(Collection<Component> playerComponents) {
        this.getComponentsModifiable().clear();
        if (playerComponents != null) {
            for (Component component : playerComponents) {
                Preconditions.checkArgument((boolean)(component instanceof PersistentComponent), (Object)"All the components should be an instanceof JPAComponent");
                this.getComponentsModifiable().add((PersistentComponent)component);
            }
        }
    }

    private final Collection<PersistentComponent> getComponentsModifiable() {
        return this.components;
    }
}

