/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.availability.affinity;

import com.bernardomg.tabletop.dreadball.model.availability.affinity.SponsorAffinityGroupAvailability;
import com.bernardomg.tabletop.dreadball.model.persistence.player.stats.PersistentAffinityGroup;
import com.bernardomg.tabletop.dreadball.model.player.stats.AffinityGroup;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity(name="SponsorAffinityGroupAvailability")
@Table(name="AFFINITY_SETS")
public class PersistentSponsorAffinityGroupAvailability
implements SponsorAffinityGroupAvailability,
Serializable {
    private static final long serialVersionUID = -6796465298138862022L;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="AFFINITY_OPTIONS", joinColumns={@JoinColumn(name="affinity_set_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="affinity_id", referencedColumnName="id")})
    private final Set<PersistentAffinityGroup> affinities = new HashSet<PersistentAffinityGroup>();
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id = -1;
    @Column(name="name", unique=true)
    private String name = "";
    @Column(name="rank_increase", unique=true)
    private Boolean rankIncrease = false;

    public final void addAffinityGroup(AffinityGroup affinity) {
        Preconditions.checkArgument((boolean)(affinity instanceof PersistentAffinityGroup), (Object)"The AffinityGroup should be an instance of JPAAffinityGroup");
        this.getAffinityGroupsModifiable().add((PersistentAffinityGroup)affinity);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentSponsorAffinityGroupAvailability other = (PersistentSponsorAffinityGroupAvailability)obj;
        return Objects.equals(this.name, other.name);
    }

    public Collection<AffinityGroup> getAffinityGroups() {
        ArrayList<AffinityGroup> result = new ArrayList<AffinityGroup>();
        for (AffinityGroup affinityGroup : this.getAffinityGroupsModifiable()) {
            result.add(affinityGroup);
        }
        return result;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public final int hashCode() {
        return Objects.hash(this.name);
    }

    public Boolean isIncludingRankIncrease() {
        return this.rankIncrease;
    }

    public final void removeAffinityGroup(AffinityGroup affinity) {
        this.getAffinityGroupsModifiable().remove(affinity);
    }

    public void setAffinityGroups(Collection<PersistentAffinityGroup> affinityGroups) {
        this.getAffinityGroupsModifiable().clear();
        if (affinityGroups != null) {
            this.getAffinityGroupsModifiable().addAll(affinityGroups);
        }
    }

    public void setId(Integer identifier) {
        this.id = identifier;
    }

    public void setIncludingRankIncrease(Boolean increase) {
        this.rankIncrease = increase;
    }

    public void setName(String nameAva) {
        this.name = nameAva;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    private final Collection<PersistentAffinityGroup> getAffinityGroupsModifiable() {
        return this.affinities;
    }
}

