/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dreadball.model.persistence.player.component;

import com.bernardomg.tabletop.dreadball.model.persistence.player.AbstractPersistentAdvancementTeamPlayer;
import com.bernardomg.tabletop.dreadball.model.persistence.player.component.PersistentComponent;
import com.bernardomg.tabletop.dreadball.model.player.component.Component;
import com.bernardomg.tabletop.dreadball.model.player.component.CompositeAdvancementTeamPlayer;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity(name="CompositeAdvancementPlayer")
@DiscriminatorValue(value="composite_advancement")
@Table(name="COMPOSITE_ADVANCEMENT_PLAYERS")
public class PersistentCompositeAdvancementTeamPlayer
extends AbstractPersistentAdvancementTeamPlayer
implements CompositeAdvancementTeamPlayer,
Serializable {
    private static final long serialVersionUID = 4751347276326003773L;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="PLAYER_COMPONENTS", joinColumns={@JoinColumn(name="player_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="component_id", referencedColumnName="id")})
    private final Set<PersistentComponent> components = new HashSet<PersistentComponent>();

    public final void addComponent(PersistentComponent component) {
        this.getComponentsModifiable().add(component);
    }

    public Collection<Component> getComponents() {
        ArrayList<Component> col = new ArrayList<Component>();
        for (Component component : this.getComponentsModifiable()) {
            col.add(component);
        }
        return Collections.unmodifiableCollection(col);
    }

    public final void removeComponent(PersistentComponent component) {
        this.getComponentsModifiable().remove(component);
    }

    public void setComponents(Collection<Component> playerComponents) {
        this.getComponentsModifiable().clear();
        for (Component component : playerComponents) {
            Preconditions.checkArgument((boolean)(component instanceof PersistentComponent), (Object)"All the components should be an instanceof JPAComponent");
            this.getComponentsModifiable().add((PersistentComponent)component);
        }
    }

    private final Collection<PersistentComponent> getComponentsModifiable() {
        return this.components;
    }
}

