/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.console.jcommander;

import com.carrotsearch.console.jcommander.ParameterException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FuzzyMap {
    public static <V> V findInMap(Map<? extends IKey, V> map, IKey name, boolean caseSensitive, boolean allowAbbreviations) {
        if (allowAbbreviations) {
            return FuzzyMap.findAbbreviatedValue(map, name, caseSensitive);
        }
        if (caseSensitive) {
            return map.get(name);
        }
        for (IKey iKey : map.keySet()) {
            if (!iKey.getName().equalsIgnoreCase(name.getName())) continue;
            return map.get(iKey);
        }
        return null;
    }

    private static <V> V findAbbreviatedValue(Map<? extends IKey, V> map, IKey name, boolean caseSensitive) {
        String string = name.getName();
        HashMap<String, V> results = new HashMap<String, V>();
        for (IKey iKey : map.keySet()) {
            String n = iKey.getName();
            boolean match = caseSensitive && n.startsWith(string) || !caseSensitive && n.toLowerCase(Locale.ROOT).startsWith(string.toLowerCase(Locale.ROOT));
            if (!match) continue;
            results.put(n, map.get(iKey));
        }
        if (results.size() > 1) {
            throw new ParameterException("Ambiguous option: " + name + " matches " + results.keySet());
        }
        V result = results.size() == 1 ? (V)results.values().iterator().next() : null;
        return result;
    }

    static interface IKey {
        public String getName();
    }
}

