/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.console.jcommander;

import com.carrotsearch.console.jcommander.CommandGroup;
import com.carrotsearch.console.jcommander.DynamicParameter;
import com.carrotsearch.console.jcommander.FuzzyMap;
import com.carrotsearch.console.jcommander.IDefaultProvider;
import com.carrotsearch.console.jcommander.IStringConverter;
import com.carrotsearch.console.jcommander.IStringConverterFactory;
import com.carrotsearch.console.jcommander.IVariableArity;
import com.carrotsearch.console.jcommander.MissingCommandException;
import com.carrotsearch.console.jcommander.Parameter;
import com.carrotsearch.console.jcommander.ParameterDescription;
import com.carrotsearch.console.jcommander.ParameterException;
import com.carrotsearch.console.jcommander.Parameterized;
import com.carrotsearch.console.jcommander.Parameters;
import com.carrotsearch.console.jcommander.StringKey;
import com.carrotsearch.console.jcommander.Strings;
import com.carrotsearch.console.jcommander.UsageOptions;
import com.carrotsearch.console.jcommander.WrappedParameter;
import com.carrotsearch.console.jcommander.converters.IParameterSplitter;
import com.carrotsearch.console.jcommander.converters.NoConverter;
import com.carrotsearch.console.jcommander.converters.StringConverter;
import com.carrotsearch.console.jcommander.internal.Console;
import com.carrotsearch.console.jcommander.internal.DefaultConsole;
import com.carrotsearch.console.jcommander.internal.DefaultConverterFactory;
import com.carrotsearch.console.jcommander.internal.JDK6Console;
import com.carrotsearch.console.jcommander.internal.Nullable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class JCommander {
    public static final String DEBUG_PROPERTY = "jcommander.debug";
    private Map<FuzzyMap.IKey, ParameterDescription> m_descriptions;
    private List<Object> m_objects = new ArrayList<Object>();
    private boolean m_firstTimeMainParameter = true;
    private Parameterized m_mainParameter = null;
    private Object m_mainParameterObject;
    private Parameter m_mainParameterAnnotation;
    private ParameterDescription m_mainParameterDescription;
    private Map<Parameterized, ParameterDescription> m_requiredFields = new HashMap<Parameterized, ParameterDescription>();
    private Map<Parameterized, ParameterDescription> m_fields = new HashMap<Parameterized, ParameterDescription>();
    private ResourceBundle m_bundle;
    private IDefaultProvider m_defaultProvider;
    private Map<ProgramName, JCommander> m_commands = new LinkedHashMap<ProgramName, JCommander>();
    private Map<FuzzyMap.IKey, ProgramName> aliasMap = new LinkedHashMap<FuzzyMap.IKey, ProgramName>();
    private String m_parsedCommand;
    private String m_parsedAlias;
    private ProgramName m_programName;
    private Comparator<? super ParameterDescription> m_parameterDescriptionComparator = new Comparator<ParameterDescription>(){

        @Override
        public int compare(ParameterDescription p0, ParameterDescription p1) {
            return p0.getLongestName().compareTo(p1.getLongestName());
        }
    };
    private int m_columnSize = 79;
    private boolean m_helpWasSpecified;
    private List<String> m_unknownArgs = new ArrayList<String>();
    private boolean m_acceptUnknownOptions = false;
    private boolean m_allowParameterOverwriting = false;
    private static Console m_console;
    private static LinkedList<IStringConverterFactory> CONVERTER_FACTORIES;
    private final IVariableArity DEFAULT_VARIABLE_ARITY = new DefaultVariableArity();
    private int m_verbose = 0;
    private boolean m_caseSensitiveOptions = true;
    private boolean m_allowAbbreviatedOptions = false;

    public JCommander() {
    }

    public JCommander(Object object) {
        this.addObject(object);
        this.createDescriptions();
    }

    public JCommander(Object object, @Nullable ResourceBundle bundle) {
        this.addObject(object);
        this.setDescriptionsBundle(bundle);
    }

    public JCommander(Object object, ResourceBundle bundle, String ... args) {
        this.addObject(object);
        this.setDescriptionsBundle(bundle);
        this.parse(args);
    }

    public JCommander(Object object, String ... args) {
        this.addObject(object);
        this.parse(args);
    }

    public static Console getConsole() {
        if (m_console == null) {
            try {
                Method consoleMethod = System.class.getDeclaredMethod("console", new Class[0]);
                Object console = consoleMethod.invoke(null, new Object[0]);
                m_console = new JDK6Console(console);
            }
            catch (Throwable t) {
                m_console = new DefaultConsole();
            }
        }
        return m_console;
    }

    public final void addObject(Object object) {
        if (object instanceof Iterable) {
            for (Object o : (Iterable)object) {
                this.m_objects.add(o);
            }
        } else if (object.getClass().isArray()) {
            for (Object o : (Object[])object) {
                this.m_objects.add(o);
            }
        } else {
            this.m_objects.add(object);
        }
    }

    public final void setDescriptionsBundle(ResourceBundle bundle) {
        this.m_bundle = bundle;
    }

    public void parse(String ... args) {
        this.parse(true, args);
    }

    public void parseWithoutValidation(String ... args) {
        this.parse(false, args);
    }

    private void parse(boolean validate, String ... args) {
        StringBuilder sb = new StringBuilder("Parsing \"");
        sb.append((CharSequence)this.join(args).append("\"\n  with:").append((CharSequence)this.join(this.m_objects.toArray())));
        this.p(sb.toString());
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        this.initializeDefaultValues();
        this.parseValues(this.expandArgs(args), validate);
        if (validate) {
            this.validateOptions();
        }
    }

    private StringBuilder join(Object[] args) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(args[i]);
        }
        return result;
    }

    private void initializeDefaultValues() {
        if (this.m_defaultProvider != null) {
            for (ParameterDescription parameterDescription : this.m_descriptions.values()) {
                this.initializeDefaultValue(parameterDescription);
            }
            for (Map.Entry entry : this.m_commands.entrySet()) {
                ((JCommander)entry.getValue()).initializeDefaultValues();
            }
        }
    }

    private void validateOptions() {
        if (this.m_helpWasSpecified) {
            return;
        }
        if (!this.m_requiredFields.isEmpty()) {
            StringBuilder missingFields = new StringBuilder();
            for (ParameterDescription pd : this.m_requiredFields.values()) {
                missingFields.append(pd.getNames()).append(" ");
            }
            throw new ParameterException("The following " + JCommander.pluralize(this.m_requiredFields.size(), "option is required: ", "options are required: ") + missingFields);
        }
        if (this.m_mainParameterDescription != null && this.m_mainParameterDescription.getParameter().required() && !this.m_mainParameterDescription.isAssigned()) {
            throw new ParameterException("Main parameters are required (\"" + this.m_mainParameterDescription.getDescription() + "\")");
        }
    }

    private static String pluralize(int quantity, String singular, String plural) {
        return quantity == 1 ? singular : plural;
    }

    private String[] expandArgs(String[] originalArgv) {
        ArrayList<String> vResult1 = new ArrayList<String>();
        for (String arg : originalArgv) {
            if (arg.startsWith("@")) {
                String fileName = arg.substring(1);
                vResult1.addAll(JCommander.readFile(fileName));
                continue;
            }
            List<String> expanded = this.expandDynamicArg(arg);
            vResult1.addAll(expanded);
        }
        ArrayList<String> vResult2 = new ArrayList<String>();
        for (int i = 0; i < vResult1.size(); ++i) {
            String arg = (String)vResult1.get(i);
            String[] v1 = vResult1.toArray(new String[0]);
            if (this.isOption(v1, arg)) {
                String sep = this.getSeparatorFor(v1, arg);
                if (!" ".equals(sep)) {
                    String[] sp;
                    for (String ssp : sp = arg.split("[" + sep + "]", 2)) {
                        vResult2.add(ssp);
                    }
                    continue;
                }
                vResult2.add(arg);
                continue;
            }
            vResult2.add(arg);
        }
        return vResult2.toArray(new String[vResult2.size()]);
    }

    private List<String> expandDynamicArg(String arg) {
        for (ParameterDescription pd : this.m_descriptions.values()) {
            if (!pd.isDynamicParameter()) continue;
            for (String name : pd.getParameter().names()) {
                if (!arg.startsWith(name) || arg.equals(name)) continue;
                return Arrays.asList(name, arg.substring(name.length()));
            }
        }
        return Arrays.asList(arg);
    }

    private boolean isOption(String[] args, String arg) {
        String prefixes = this.getOptionPrefixes(args, arg);
        return arg.length() > 0 && prefixes.indexOf(arg.charAt(0)) >= 0;
    }

    private ParameterDescription getPrefixDescriptionFor(String arg) {
        for (Map.Entry<FuzzyMap.IKey, ParameterDescription> es : this.m_descriptions.entrySet()) {
            if (!arg.startsWith(es.getKey().getName())) continue;
            return es.getValue();
        }
        return null;
    }

    private ParameterDescription getDescriptionFor(String[] args, String arg) {
        ParameterDescription result = this.getPrefixDescriptionFor(arg);
        if (result != null) {
            return result;
        }
        for (String a : args) {
            ParameterDescription pd = this.getPrefixDescriptionFor(arg);
            if (pd != null) {
                result = pd;
            }
            if (!a.equals(arg)) continue;
            return result;
        }
        throw new ParameterException("Unknown parameter: " + arg);
    }

    private String getSeparatorFor(String[] args, String arg) {
        Parameters p;
        ParameterDescription pd = this.getDescriptionFor(args, arg);
        if (pd != null && (p = pd.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return p.separators();
        }
        return " ";
    }

    private String getOptionPrefixes(String[] args, String arg) {
        Parameters p;
        ParameterDescription pd = this.getDescriptionFor(args, arg);
        if (pd != null && (p = pd.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return p.optionPrefixes();
        }
        String result = "-";
        StringBuilder sb = new StringBuilder();
        for (Object o : this.m_objects) {
            Parameters p2 = o.getClass().getAnnotation(Parameters.class);
            if (p2 == null || "-".equals(p2.optionPrefixes())) continue;
            sb.append(p2.optionPrefixes());
        }
        if (!Strings.isStringEmpty(sb.toString())) {
            result = sb.toString();
        }
        return result;
    }

    private static List<String> readFile(String fileName) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            BufferedReader bufRead = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            while ((line = bufRead.readLine()) != null) {
                if (line.length() <= 0 || line.trim().startsWith("#")) continue;
                result.add(line);
            }
            bufRead.close();
        }
        catch (IOException e) {
            throw new ParameterException("Could not read file " + fileName + ": " + e);
        }
        return result;
    }

    private static String trim(String string) {
        return string;
    }

    private void createDescriptions() {
        this.m_descriptions = new HashMap<FuzzyMap.IKey, ParameterDescription>();
        for (Object object : this.m_objects) {
            this.addDescription(object);
        }
    }

    private void addDescription(Object object) {
        Class<?> cls = object.getClass();
        List<Parameterized> parameterizeds = Parameterized.parseArg(object);
        for (Parameterized parameterized : parameterizeds) {
            WrappedParameter wp = parameterized.getWrappedParameter();
            if (wp != null && wp.getParameter() != null) {
                Parameter annotation = wp.getParameter();
                Parameter p = annotation;
                if (p.names().length == 0) {
                    this.p("Found main parameter:" + parameterized);
                    if (this.m_mainParameter != null) {
                        throw new ParameterException("Only one @Parameter with no names attribute is allowed, found:" + this.m_mainParameter + " and " + parameterized);
                    }
                    this.m_mainParameter = parameterized;
                    this.m_mainParameterObject = object;
                    this.m_mainParameterAnnotation = p;
                    this.m_mainParameterDescription = new ParameterDescription(object, p, parameterized, this.m_bundle, this);
                    continue;
                }
                ParameterDescription pd = new ParameterDescription(object, p, parameterized, this.m_bundle, this);
                for (String name : p.names()) {
                    if (this.m_descriptions.containsKey(new StringKey(name))) {
                        throw new ParameterException("Found the option " + name + " multiple times");
                    }
                    this.p("Adding description for " + name);
                    this.m_fields.put(parameterized, pd);
                    this.m_descriptions.put(new StringKey(name), pd);
                    if (!p.required()) continue;
                    this.m_requiredFields.put(parameterized, pd);
                }
                continue;
            }
            if (parameterized.getDelegateAnnotation() != null) {
                Object delegateObject = parameterized.get(object);
                if (delegateObject == null) {
                    throw new ParameterException("Delegate field '" + parameterized.getName() + "' cannot be null.");
                }
                this.addDescription(delegateObject);
                continue;
            }
            if (wp == null || wp.getDynamicParameter() == null) continue;
            DynamicParameter dp = wp.getDynamicParameter();
            for (String name : dp.names()) {
                if (this.m_descriptions.containsKey(name)) {
                    throw new ParameterException("Found the option " + name + " multiple times");
                }
                this.p("Adding description for " + name);
                ParameterDescription pd = new ParameterDescription(object, dp, parameterized, this.m_bundle, this);
                this.m_fields.put(parameterized, pd);
                this.m_descriptions.put(new StringKey(name), pd);
                if (!dp.required()) continue;
                this.m_requiredFields.put(parameterized, pd);
            }
        }
    }

    private void initializeDefaultValue(ParameterDescription pd) {
        for (String optionName : pd.getParameter().names()) {
            String def = this.m_defaultProvider.getDefaultValueFor(optionName);
            if (def == null) continue;
            this.p("Initializing " + optionName + " with default value:" + def);
            pd.addValue(def, true);
            return;
        }
    }

    private void parseValues(String[] args, boolean validate) {
        int increment;
        boolean commandParsed = false;
        boolean isDashDash = false;
        for (int i = 0; i < args.length && !commandParsed; i += increment) {
            String a;
            String arg = args[i];
            args[i] = a = JCommander.trim(arg);
            this.p("Parsing arg: " + a);
            JCommander jc = this.findCommandByAlias(arg);
            increment = 1;
            if (!isDashDash && !"--".equals(a) && this.isOption(args, a) && jc == null) {
                ParameterDescription pd = this.findParameterDescription(a);
                if (pd != null) {
                    if (pd.getParameter().password()) {
                        char[] password = this.readPassword(pd.getDescription(), pd.getParameter().echoInput());
                        pd.addValue(new String(password));
                        this.m_requiredFields.remove(pd.getParameterized());
                        continue;
                    }
                    if (pd.getParameter().variableArity()) {
                        increment = this.processVariableArity(args, i, pd);
                        continue;
                    }
                    Class<?> fieldType = pd.getParameterized().getType();
                    if ((fieldType == Boolean.TYPE || fieldType == Boolean.class) && pd.getParameter().arity() == -1) {
                        pd.addValue("true");
                        this.m_requiredFields.remove(pd.getParameterized());
                    } else {
                        increment = this.processFixedArity(args, i, pd, fieldType);
                    }
                    if (!pd.isHelp()) continue;
                    this.m_helpWasSpecified = true;
                    continue;
                }
                if (this.m_acceptUnknownOptions) {
                    this.m_unknownArgs.add(arg);
                    ++i;
                    while (i < args.length && !this.isOption(args, args[i])) {
                        this.m_unknownArgs.add(args[i++]);
                    }
                    increment = 0;
                    continue;
                }
                throw new ParameterException("Unknown option: " + arg);
            }
            if (Strings.isStringEmpty(arg)) continue;
            if ("--".equals(arg)) {
                isDashDash = true;
                a = JCommander.trim(args[++i]);
            }
            if (this.m_commands.isEmpty()) {
                ParameterizedType p;
                Type cls;
                List<?> mp = this.getMainParameter(arg);
                String value = a;
                Object convertedValue = value;
                if (this.m_mainParameter.getGenericType() instanceof ParameterizedType && (cls = (p = (ParameterizedType)this.m_mainParameter.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
                    convertedValue = this.convertValue(this.m_mainParameter, (Class)cls, value);
                }
                ParameterDescription.validateParameter(this.m_mainParameterDescription, this.m_mainParameterAnnotation.validateWith(), "Default", value);
                this.m_mainParameterDescription.setAssigned(true);
                mp.add(convertedValue);
                continue;
            }
            if (jc == null && validate) {
                throw new MissingCommandException("Expected a command, got " + arg);
            }
            if (jc == null) continue;
            this.m_parsedCommand = jc.m_programName.m_name;
            this.m_parsedAlias = arg;
            jc.parse(this.subArray(args, i + 1));
            commandParsed = true;
        }
        for (ParameterDescription parameterDescription : this.m_descriptions.values()) {
            if (!parameterDescription.isAssigned()) continue;
            this.m_fields.get(parameterDescription.getParameterized()).setAssigned(true);
        }
    }

    private int processVariableArity(String[] args, int index, ParameterDescription pd) {
        Object arg = pd.getObject();
        IVariableArity va = !(arg instanceof IVariableArity) ? this.DEFAULT_VARIABLE_ARITY : (IVariableArity)arg;
        ArrayList<String> currentArgs = new ArrayList<String>();
        for (int j = index + 1; j < args.length; ++j) {
            currentArgs.add(args[j]);
        }
        int arity = va.processVariableArity(pd.getParameter().names()[0], currentArgs.toArray(new String[0]));
        int result = this.processFixedArity(args, index, pd, List.class, arity);
        return result;
    }

    private int processFixedArity(String[] args, int index, ParameterDescription pd, Class<?> fieldType) {
        int arity = pd.getParameter().arity();
        int n = arity != -1 ? arity : 1;
        return this.processFixedArity(args, index, pd, fieldType, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processFixedArity(String[] args, int originalIndex, ParameterDescription pd, Class<?> fieldType, int arity) {
        int index = originalIndex;
        String arg = args[index];
        if (arity == 0 && (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType))) {
            pd.addValue("true");
            this.m_requiredFields.remove(pd.getParameterized());
            return arity + 1;
        } else {
            int offset;
            if (index >= args.length - 1) throw new ParameterException("Expected a value after parameter " + arg);
            int n = offset = "--".equals(args[index + 1]) ? 1 : 0;
            if (index + arity >= args.length) throw new ParameterException("Expected " + arity + " values after " + arg);
            for (int j = 1; j <= arity; ++j) {
                pd.addValue(JCommander.trim(args[index + j + offset]));
                this.m_requiredFields.remove(pd.getParameterized());
            }
            index += arity + offset;
        }
        return arity + 1;
    }

    private char[] readPassword(String description, boolean echoInput) {
        JCommander.getConsole().print(description + ": ");
        return JCommander.getConsole().readPassword(echoInput);
    }

    private String[] subArray(String[] args, int index) {
        int l = args.length - index;
        String[] result = new String[l];
        System.arraycopy(args, index, result, 0, l);
        return result;
    }

    private List<?> getMainParameter(String arg) {
        if (this.m_mainParameter == null) {
            throw new ParameterException("Was passed main parameter '" + arg + "' but no main parameter was defined");
        }
        ArrayList result = (ArrayList)this.m_mainParameter.get(this.m_mainParameterObject);
        if (result == null) {
            result = new ArrayList();
            if (!List.class.isAssignableFrom(this.m_mainParameter.getType())) {
                throw new ParameterException("Main parameter field " + this.m_mainParameter + " needs to be of type List, not " + this.m_mainParameter.getType());
            }
            this.m_mainParameter.set(this.m_mainParameterObject, result);
        }
        if (this.m_firstTimeMainParameter) {
            result.clear();
            this.m_firstTimeMainParameter = false;
        }
        return result;
    }

    public String getMainParameterDescription() {
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        return this.m_mainParameterAnnotation != null ? this.m_mainParameterAnnotation.description() : null;
    }

    public void setProgramName(String name, String group, String ... aliases) {
        this.m_programName = new ProgramName(name, group, Arrays.asList(aliases));
    }

    public void usage(String commandName) {
        StringBuilder sb = new StringBuilder();
        this.usage(commandName, sb);
        JCommander.getConsole().println(sb.toString());
    }

    public void usage(String commandName, StringBuilder out) {
        this.usage(commandName, out, "");
    }

    public void usage(String commandName, StringBuilder out, String indent) {
        String description = this.getCommandDescription(commandName);
        JCommander jc = this.findCommandByAlias(commandName);
        if (description != null) {
            out.append(indent).append(description);
            out.append("\n\n");
        }
        jc.usage(out, indent);
    }

    public String getCommandDescription(String commandName) {
        JCommander jc = this.findCommandByAlias(commandName);
        if (jc == null) {
            throw new ParameterException("Asking description for unknown command: " + commandName);
        }
        Object arg = jc.getObjects().get(0);
        Parameters p = arg.getClass().getAnnotation(Parameters.class);
        ResourceBundle bundle = null;
        String result = null;
        if (p != null) {
            result = p.commandDescription();
            String bundleName = p.resourceBundle();
            bundle = !"".equals(bundleName) ? ResourceBundle.getBundle(bundleName, Locale.getDefault()) : this.m_bundle;
            if (bundle != null) {
                result = this.getI18nString(bundle, p.commandDescriptionKey(), p.commandDescription());
            }
        }
        return result;
    }

    private String getI18nString(ResourceBundle bundle, String key, String def) {
        String s = bundle != null ? bundle.getString(key) : null;
        return s != null ? s : def;
    }

    public void usage() {
        StringBuilder sb = new StringBuilder();
        this.usage(sb);
        JCommander.getConsole().println(sb.toString());
    }

    public void usage(StringBuilder out) {
        this.usage(out, "");
    }

    public void usage(StringBuilder out, String indent) {
        this.usage(out, indent, UsageOptions.values());
    }

    /*
     * WARNING - void declaration
     */
    public void usage(StringBuilder out, String indent, UsageOptions ... optionList) {
        EnumSet<UsageOptions> options = EnumSet.noneOf(UsageOptions.class);
        options.addAll(Arrays.asList(optionList));
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        boolean hasCommands = !this.m_commands.isEmpty();
        int longestName = 0;
        ArrayList<ParameterDescription> sorted = new ArrayList<ParameterDescription>();
        for (ParameterDescription parameterDescription : this.m_fields.values()) {
            if (parameterDescription.getParameter().hidden()) continue;
            sorted.add(parameterDescription);
            int length = parameterDescription.getNames().length() + 2;
            if (length <= longestName) continue;
            longestName = length;
        }
        if (options.contains((Object)UsageOptions.DISPLAY_SYNTAX_LINE)) {
            String programName = this.m_programName != null ? this.m_programName.getDisplayName() : null;
            out.append(indent).append("Usage:");
            if (programName != null && !programName.isEmpty()) {
                out.append(" ").append(programName);
            }
            if (!sorted.isEmpty()) {
                out.append(" [options]");
            }
            if (hasCommands) {
                out.append(indent).append(" [command] [command options]");
            }
            if (this.m_mainParameterDescription != null) {
                out.append(" " + this.m_mainParameterDescription.getDescription());
            }
            out.append("\n\n");
        }
        Collections.sort(sorted, this.getParameterDescriptionComparator());
        if (options.contains((Object)UsageOptions.DISPLAY_PARAMETERS)) {
            int descriptionIndent = 6;
            if (sorted.size() > 0) {
                out.append(indent).append("  Options:\n");
            }
            for (ParameterDescription pd : sorted) {
                WrappedParameter parameter = pd.getParameter();
                out.append(indent).append("  " + (parameter.required() ? "* " : "  ") + pd.getNames() + "\n" + indent + this.s(descriptionIndent));
                int indentCount = indent.length() + descriptionIndent;
                this.wrapDescription(out, indentCount, pd.getDescription());
                Object def = pd.getDefault();
                if (pd.isDynamicParameter()) {
                    out.append("\n" + this.s(indentCount + 1)).append("Syntax: " + parameter.names()[0] + "key" + parameter.getAssignment() + "value");
                }
                if (def != null) {
                    String displayedDef = Strings.isStringEmpty(def.toString()) ? "<empty string>" : def.toString();
                    out.append("\n" + this.s(indentCount + 1)).append("Default: " + (parameter.password() ? "********" : displayedDef));
                }
                out.append("\n\n");
            }
        }
        if (hasCommands && options.contains((Object)UsageOptions.DISPLAY_COMMANDS)) {
            ArrayList<ProgramName> listOfCommands = new ArrayList<ProgramName>();
            boolean bl = false;
            for (Map.Entry<ProgramName, JCommander> commands : this.m_commands.entrySet()) {
                int n;
                Object arg = commands.getValue().getObjects().get(0);
                Parameters p = arg.getClass().getAnnotation(Parameters.class);
                if (p.hidden() && !options.contains((Object)UsageOptions.DISPLAY_COMMANDS_HIDDEN)) continue;
                ProgramName cmd = (ProgramName)commands.getKey();
                String name = cmd.getDisplayName();
                n = Math.max(n, Character.codePointCount(name, 0, name.length()));
                listOfCommands.add(cmd);
            }
            if (options.contains((Object)UsageOptions.SORT_COMMANDS)) {
                Collections.sort(listOfCommands, new Comparator<ProgramName>(){

                    @Override
                    public int compare(ProgramName p1, ProgramName p2) {
                        return p1.getDisplayName().compareToIgnoreCase(p2.getDisplayName());
                    }
                });
            }
            LinkedHashMap commandGroups = new LinkedHashMap();
            if (options.contains((Object)UsageOptions.GROUP_COMMANDS)) {
                for (ProgramName p : listOfCommands) {
                    String group = p.getGroup();
                    if (!commandGroups.containsKey(group)) {
                        commandGroups.put(group, new ArrayList());
                    }
                    ((List)commandGroups.get(group)).add(p);
                }
            } else {
                commandGroups.put("Commands", listOfCommands);
            }
            var9_16 += 3;
            Iterator i = commandGroups.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if (!((String)e.getKey()).isEmpty()) {
                    out.append(String.format(Locale.ROOT, "  %s:\n", e.getKey()));
                }
                for (ProgramName p : (List)e.getValue()) {
                    if (options.contains((Object)UsageOptions.DISPLAY_OPTIONS_FOR_EACH_COMMAND)) {
                        out.append(indent).append("    " + p.getDisplayName());
                        this.usage(p.getName(), out, "      ");
                    } else {
                        void var9_16;
                        out.append(String.format(Locale.ROOT, "%s%s%-" + (int)var9_16 + "s%s", indent, "    ", p.getDisplayName(), this.getCommandDescription(p.getName())));
                    }
                    out.append("\n");
                }
                if (!i.hasNext()) continue;
                out.append("\n");
            }
        }
    }

    private Comparator<? super ParameterDescription> getParameterDescriptionComparator() {
        return this.m_parameterDescriptionComparator;
    }

    public void setParameterDescriptionComparator(Comparator<? super ParameterDescription> c) {
        this.m_parameterDescriptionComparator = c;
    }

    public void setColumnSize(int columnSize) {
        this.m_columnSize = columnSize;
    }

    public int getColumnSize() {
        return this.m_columnSize;
    }

    private void wrapDescription(StringBuilder out, int indent, String description) {
        int max = this.getColumnSize();
        String[] words = description.split(" ");
        int current = indent;
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (word.length() > max || current + word.length() <= max) {
                out.append(" ").append(word);
                current += word.length() + 1;
                continue;
            }
            out.append("\n").append(this.s(indent + 1)).append(word);
            current = indent;
        }
    }

    public List<ParameterDescription> getParameters() {
        return new ArrayList<ParameterDescription>(this.m_fields.values());
    }

    public ParameterDescription getMainParameter() {
        return this.m_mainParameterDescription;
    }

    private void p(String string) {
        if (this.m_verbose > 0 || System.getProperty(DEBUG_PROPERTY) != null) {
            JCommander.getConsole().println("[JCommander] " + string);
        }
    }

    public void setDefaultProvider(IDefaultProvider defaultProvider) {
        this.m_defaultProvider = defaultProvider;
        for (Map.Entry<ProgramName, JCommander> entry : this.m_commands.entrySet()) {
            entry.getValue().setDefaultProvider(defaultProvider);
        }
    }

    public void addConverterFactory(IStringConverterFactory converterFactory) {
        CONVERTER_FACTORIES.addFirst(converterFactory);
    }

    public <T> Class<? extends IStringConverter<T>> findConverter(Class<T> cls) {
        for (IStringConverterFactory f : CONVERTER_FACTORIES) {
            Class<IStringConverter<T>> result = f.getConverter(cls);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object convertValue(ParameterDescription pd, String value) {
        return this.convertValue(pd.getParameterized(), pd.getParameterized().getType(), value);
    }

    public Object convertValue(Parameterized parameterized, Class type, String value) {
        Object result;
        block16: {
            boolean listConverterWasSpecified;
            Parameter annotation = parameterized.getParameter();
            if (annotation == null) {
                return value;
            }
            Class converterClass = annotation.converter();
            boolean bl = listConverterWasSpecified = annotation.listConverter() != NoConverter.class;
            if (converterClass == null || converterClass == NoConverter.class) {
                converterClass = type.isEnum() ? type : this.findConverter(type);
            }
            if (converterClass == null) {
                Type elementType = parameterized.findFieldGenericType();
                Class clazz = converterClass = elementType != null ? this.findConverter((Class)elementType) : StringConverter.class;
                if (converterClass == null && Enum.class.isAssignableFrom((Class)elementType)) {
                    converterClass = (Class)elementType;
                }
            }
            result = null;
            try {
                String optionName;
                String[] names = annotation.names();
                String string = optionName = names.length > 0 ? names[0] : "[Main class]";
                if (converterClass != null && converterClass.isEnum()) {
                    try {
                        result = Enum.valueOf(converterClass, value);
                        break block16;
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            result = Enum.valueOf(converterClass, value.toUpperCase(Locale.ROOT));
                            break block16;
                        }
                        catch (IllegalArgumentException ex) {
                            throw new ParameterException("Invalid value for " + optionName + " parameter. Allowed values:" + EnumSet.allOf(converterClass));
                        }
                    }
                    catch (Exception e) {
                        throw new ParameterException("Invalid value for " + optionName + " parameter. Allowed values:" + EnumSet.allOf(converterClass));
                    }
                }
                IStringConverter<?> converter = this.instantiateConverter(optionName, converterClass);
                if (type.isAssignableFrom(List.class) && parameterized.getGenericType() instanceof ParameterizedType) {
                    if (listConverterWasSpecified) {
                        IStringConverter<?> listConverter = this.instantiateConverter(optionName, annotation.listConverter());
                        result = listConverter.convert(value);
                    } else {
                        result = this.convertToList(value, converter, annotation.splitter());
                    }
                } else {
                    result = converter.convert(value);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ParameterException(e);
            }
        }
        return result;
    }

    private Object convertToList(String value, IStringConverter<?> converter, Class<? extends IParameterSplitter> splitterClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        IParameterSplitter splitter = splitterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        ArrayList result = new ArrayList();
        for (String param : splitter.split(value)) {
            result.add(converter.convert(param));
        }
        return result;
    }

    private IStringConverter<?> instantiateConverter(String optionName, Class<? extends IStringConverter<?>> converterClass) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] ctors;
        Constructor<?> ctor = null;
        Constructor<?> stringCtor = null;
        for (Constructor<?> c : ctors = converterClass.getDeclaredConstructors()) {
            Class<?>[] types = c.getParameterTypes();
            if (types.length == 1 && types[0].equals(String.class)) {
                stringCtor = c;
                continue;
            }
            if (types.length != 0) continue;
            ctor = c;
        }
        IStringConverter result = stringCtor != null ? (IStringConverter)stringCtor.newInstance(optionName) : (ctor != null ? (IStringConverter)ctor.newInstance(new Object[0]) : null);
        return result;
    }

    public void addCommand(String name, String group, Object object) {
        this.addCommand(name, group, object, new String[0]);
    }

    public void addCommand(Object object) {
        Parameters p = object.getClass().getAnnotation(Parameters.class);
        if (p != null && p.commandNames().length > 0) {
            String cmdGroup = "";
            if (object.getClass().isAnnotationPresent(CommandGroup.class)) {
                cmdGroup = object.getClass().getAnnotation(CommandGroup.class).value();
            }
            for (String commandName : p.commandNames()) {
                this.addCommand(commandName, cmdGroup, object);
            }
        } else {
            throw new ParameterException("Trying to add command " + object.getClass().getName() + " without specifying its names in @Parameters");
        }
    }

    public void addCommand(String name, String group, Object object, String ... aliases) {
        JCommander jc = new JCommander(object);
        jc.setProgramName(name, group, aliases);
        jc.setDefaultProvider(this.m_defaultProvider);
        jc.setAcceptUnknownOptions(this.m_acceptUnknownOptions);
        ProgramName progName = jc.m_programName;
        this.m_commands.put(progName, jc);
        this.aliasMap.put(new StringKey(name), progName);
        for (String a : aliases) {
            StringKey alias = new StringKey(a);
            if (((Object)alias).equals(name)) continue;
            ProgramName mappedName = this.aliasMap.get(alias);
            if (mappedName != null && !mappedName.equals(progName)) {
                throw new ParameterException("Cannot set alias " + alias + " for " + name + " command because it has already been defined for " + mappedName.m_name + " command");
            }
            this.aliasMap.put(alias, progName);
        }
    }

    public Map<String, JCommander> getCommands() {
        LinkedHashMap<String, JCommander> res = new LinkedHashMap<String, JCommander>();
        for (Map.Entry<ProgramName, JCommander> entry : this.m_commands.entrySet()) {
            res.put(entry.getKey().m_name, entry.getValue());
        }
        return res;
    }

    public String getParsedCommand() {
        return this.m_parsedCommand;
    }

    public String getParsedAlias() {
        return this.m_parsedAlias;
    }

    private String s(int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(" ");
        }
        return result.toString();
    }

    public List<Object> getObjects() {
        return this.m_objects;
    }

    private ParameterDescription findParameterDescription(String arg) {
        return FuzzyMap.findInMap(this.m_descriptions, new StringKey(arg), this.m_caseSensitiveOptions, this.m_allowAbbreviatedOptions);
    }

    private JCommander findCommand(ProgramName name) {
        return FuzzyMap.findInMap(this.m_commands, name, this.m_caseSensitiveOptions, this.m_allowAbbreviatedOptions);
    }

    private ProgramName findProgramName(String name) {
        return FuzzyMap.findInMap(this.aliasMap, new StringKey(name), this.m_caseSensitiveOptions, this.m_allowAbbreviatedOptions);
    }

    private JCommander findCommandByAlias(String commandOrAlias) {
        ProgramName progName = this.findProgramName(commandOrAlias);
        if (progName == null) {
            return null;
        }
        JCommander jc = this.findCommand(progName);
        if (jc == null) {
            throw new IllegalStateException("There appears to be inconsistency in the internal command database.  This is likely a bug. Please report.");
        }
        return jc;
    }

    public void setVerbose(int verbose) {
        this.m_verbose = verbose;
    }

    public void setCaseSensitiveOptions(boolean b) {
        this.m_caseSensitiveOptions = b;
    }

    public void setAllowAbbreviatedOptions(boolean b) {
        this.m_allowAbbreviatedOptions = b;
    }

    public void setAcceptUnknownOptions(boolean b) {
        this.m_acceptUnknownOptions = b;
    }

    public List<String> getUnknownOptions() {
        return this.m_unknownArgs;
    }

    public void setAllowParameterOverwriting(boolean b) {
        this.m_allowParameterOverwriting = b;
    }

    public boolean isParameterOverwritingAllowed() {
        return this.m_allowParameterOverwriting;
    }

    static {
        CONVERTER_FACTORIES = new LinkedList();
        CONVERTER_FACTORIES.addFirst(new DefaultConverterFactory());
    }

    private static final class ProgramName
    implements FuzzyMap.IKey {
        private final String m_name;
        private final String group;
        private final List<String> m_aliases;

        ProgramName(String name, String group, List<String> aliases) {
            this.m_name = name;
            this.m_aliases = aliases;
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }

        @Override
        public String getName() {
            return this.m_name;
        }

        private String getDisplayName() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.m_name);
            if (!this.m_aliases.isEmpty()) {
                sb.append("(");
                Iterator<String> aliasesIt = this.m_aliases.iterator();
                while (aliasesIt.hasNext()) {
                    sb.append(aliasesIt.next());
                    if (!aliasesIt.hasNext()) continue;
                    sb.append(",");
                }
                sb.append(")");
            }
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProgramName other = (ProgramName)obj;
            return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private class DefaultVariableArity
    implements IVariableArity {
        private DefaultVariableArity() {
        }

        @Override
        public int processVariableArity(String optionName, String[] options) {
            int i;
            for (i = 0; i < options.length && !JCommander.this.isOption(options, options[i]); ++i) {
            }
            return i;
        }
    }
}

