/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.console.launcher;

import com.carrotsearch.console.jcommander.JCommander;
import com.carrotsearch.console.jcommander.ParameterException;
import com.carrotsearch.console.jcommander.Parameters;
import com.carrotsearch.console.jcommander.UsageOptions;
import com.carrotsearch.console.launcher.Command;
import com.carrotsearch.console.launcher.ExitCode;
import com.carrotsearch.console.launcher.ExitCodes;
import com.carrotsearch.console.launcher.LauncherParameters;
import com.carrotsearch.console.launcher.Loggers;
import com.carrotsearch.console.launcher.LoggingParameters;
import com.carrotsearch.console.launcher.PathConverter;
import com.carrotsearch.console.launcher.ReportCommandException;
import com.carrotsearch.console.launcher.SysPropertiesParameters;
import com.carrotsearch.console.launcher.UriConverter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;

public class Launcher {
    public static final String ENV_SCRIPT_NAME = "SCRIPT_NAME";
    public final boolean configureLoggingDefaults;

    public Launcher() {
        this(true);
    }

    public Launcher(boolean configureLoggingDefaults) {
        this.configureLoggingDefaults = configureLoggingDefaults;
    }

    public ExitCode runCommands(Collection<? extends Command<? extends ExitCode>> cmds, String ... args) {
        return this.runCommands("", cmds, args);
    }

    public ExitCode runCommands(String launchScriptName, Collection<? extends Command<? extends ExitCode>> cmds, String ... args) {
        try {
            this.configureLoggingDefaults();
            if (cmds.isEmpty()) {
                Loggers.CONSOLE.error("The list of available commands is empty.");
                return ExitCodes.ERROR_INTERNAL;
            }
            LauncherParameters launcherParameters = new LauncherParameters();
            JCommander jc = new JCommander(launcherParameters);
            jc.addConverterFactory(new PathConverter());
            jc.addConverterFactory(new UriConverter());
            cmds.forEach(cmd -> cmd.configure(jc));
            cmds.forEach(jc::addCommand);
            jc.setProgramName(launchScriptName, "", new String[0]);
            jc.parse(args);
            String cmd2 = jc.getParsedCommand();
            if (cmd2 == null || launcherParameters.help) {
                Loggers.CONSOLE.info(this.commandHelp(jc, launcherParameters.hidden));
                return ExitCodes.SUCCESS;
            }
            JCommander cmdJc = jc.getCommands().get(cmd2);
            List<Object> objects = cmdJc.getObjects();
            assert (objects.size() == 1) : "Expected exactly one object for command '" + cmd2 + "': " + objects;
            Command command = (Command)objects.iterator().next();
            cmdJc.setProgramName(this.getCommandName(command), "", new String[0]);
            return this.launchCommand(cmdJc, command);
        }
        catch (ParameterException e) {
            Loggers.CONSOLE.error("Invalid arguments (type {} for help): {}", (Object)"--help", (Object)e.getMessage());
            return ExitCodes.ERROR_INVALID_ARGUMENTS;
        }
        catch (Throwable e) {
            Loggers.CONSOLE.error("An unhandled exception occurred while launching commands (use {} to display stack trace): {}", new Object[]{"--verbose", e.toString(), e});
            return ExitCodes.ERROR_INTERNAL;
        }
    }

    public <T extends ExitCode> ExitCode runCommand(Command<T> cmd, String ... args) {
        String cmdName = this.getCommandName(cmd);
        try {
            this.configureLoggingDefaults();
            JCommander jc = new JCommander();
            jc.addObject(cmd);
            jc.setProgramName(cmdName, "", new String[0]);
            jc.addConverterFactory(new PathConverter());
            jc.addConverterFactory(new UriConverter());
            cmd.configure(jc);
            jc.parse(args);
            return this.launchCommand(jc, cmd);
        }
        catch (ParameterException e) {
            Loggers.CONSOLE.error("Invalid arguments (type {} for help): {}", (Object)"--help", (Object)e.getMessage());
            return ExitCodes.ERROR_INVALID_ARGUMENTS;
        }
        catch (Exception e) {
            Loggers.CONSOLE.error("An unhandled exception occurred while launching command '{}' (use {} to display stack trace): {}", new Object[]{cmdName, "--verbose", e.toString(), e});
            return ExitCodes.ERROR_INTERNAL;
        }
    }

    public static List<Command<? extends ExitCode>> lookupCommands() {
        ServiceLoader<Command> sl = ServiceLoader.load(Command.class);
        return sl.stream().map(prov -> (Command)prov.get()).collect(Collectors.toList());
    }

    public static List<Command<? extends ExitCode>> lookupCommands(ClassLoader classLoader) {
        ServiceLoader<Command> sl = ServiceLoader.load(Command.class, classLoader);
        return sl.stream().map(prov -> (Command)prov.get()).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        ExitCode exitCode;
        List<Command<? extends ExitCode>> cmds = Launcher.lookupCommands();
        if (cmds.size() == 1) {
            exitCode = new Launcher().runCommand(cmds.iterator().next(), args);
        } else {
            String scriptName = Stream.of(AccessController.doPrivileged(() -> System.getenv(ENV_SCRIPT_NAME)), "").filter(Objects::nonNull).findFirst().get();
            exitCode = new Launcher().runCommands(scriptName, cmds, args);
        }
        Runtime.getRuntime().exit(exitCode.processReturnValue());
    }

    private <T extends ExitCode> ExitCode launchCommand(JCommander jc, Command<T> cmd) {
        if (cmd.help) {
            Loggers.CONSOLE.info(this.commandHelp(jc, false));
            return ExitCodes.SUCCESS;
        }
        try {
            this.configureSysProps(cmd.sysProps);
            List<URI> configurations = cmd.configureLogging(this.resolveLoggingConfigurations(cmd.logging));
            if (!cmd.logging.skip) {
                this.reloadLoggingConfiguration(configurations);
            }
            return cmd.run();
        }
        catch (ReportCommandException e) {
            String msg = e.getMessage();
            if (msg != null) {
                Loggers.CONSOLE.error(msg, e.getCause());
            }
            return e.exitCode;
        }
    }

    private <T extends ExitCode> String getCommandName(Command<T> cmd) {
        String cmdName = cmd.getClass().getName();
        Parameters parameters = cmd.getClass().getAnnotation(Parameters.class);
        if (parameters != null && parameters.commandNames().length > 0) {
            cmdName = parameters.commandNames()[0];
        }
        return cmdName;
    }

    private void configureSysProps(SysPropertiesParameters sysProps) {
        if (sysProps.sysProperties != null) {
            sysProps.sysProperties.forEach(System::setProperty);
        }
    }

    private String commandHelp(JCommander jc, boolean showHidden) {
        StringBuilder sb = new StringBuilder();
        jc.usage(sb, "", UsageOptions.DISPLAY_SYNTAX_LINE, UsageOptions.DISPLAY_PARAMETERS, showHidden ? UsageOptions.DISPLAY_COMMANDS_HIDDEN : UsageOptions.DISPLAY_COMMANDS, UsageOptions.DISPLAY_COMMANDS, UsageOptions.SORT_COMMANDS, UsageOptions.GROUP_COMMANDS);
        return sb.toString();
    }

    private void reloadLoggingConfiguration(List<URI> configurations) {
        if (configurations.isEmpty()) {
            return;
        }
        ClassLoader cl = this.getClass().getClassLoader();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((ClassLoader)cl, (boolean)false);
        ConfigurationFactory configFactory = ConfigurationFactory.getInstance();
        ArrayList<AbstractConfiguration> configs = new ArrayList<AbstractConfiguration>();
        for (URI configUri : configurations) {
            Configuration configuration = configFactory.getConfiguration(ctx, configUri.toString(), configUri);
            if (!(configuration instanceof AbstractConfiguration)) {
                throw new RuntimeException("Not an AbstractConfiguration?: " + configUri);
            }
            configs.add((AbstractConfiguration)configuration);
        }
        ctx.start((Configuration)new CompositeConfiguration(configs));
    }

    private List<URI> resolveLoggingConfigurations(LoggingParameters logging) {
        ArrayList<String> configs = new ArrayList<String>();
        if (logging.configuration != null) {
            configs.add("--logging-config");
        }
        if (logging.trace) {
            configs.add("--trace");
        }
        if (logging.verbose) {
            configs.add("--verbose");
        }
        if (logging.quiet) {
            configs.add("--quiet");
        }
        if (logging.skip) {
            configs.add("--logging-skip");
        }
        if (configs.size() > 1) {
            throw new ParameterException("Conflicting logging configuration options: " + String.join((CharSequence)", ", configs));
        }
        ArrayList<URI> multiConfigs = new ArrayList<URI>();
        if (logging.configuration != null) {
            Path config = logging.configuration.toAbsolutePath().normalize();
            if (!Files.isRegularFile(config, new LinkOption[0])) {
                throw new ParameterException("Logging configuration file does not exist: " + config);
            }
            multiConfigs.add(config.toUri());
        }
        if (logging.trace) {
            multiConfigs.add(this.getResourceAsURI("log4j2-trace.xml"));
        }
        if (logging.verbose) {
            multiConfigs.add(this.getResourceAsURI("log4j2-verbose.xml"));
        }
        if (logging.quiet) {
            multiConfigs.add(this.getResourceAsURI("log4j2-quiet.xml"));
        }
        if (multiConfigs.isEmpty()) {
            multiConfigs.add(this.getResourceAsURI("log4j2-default.xml"));
        }
        return multiConfigs;
    }

    private void configureLoggingDefaults() {
        if (this.configureLoggingDefaults) {
            try {
                Configurator.initialize((String)"log4j2-init.xml", (ClassLoader)Launcher.class.getClassLoader(), (URI)this.getResourceAsURI("log4j2-init.xml"));
            }
            catch (Error | RuntimeException e) {
                throw new RuntimeException("Could not load or initialize the default logging configuration.", e);
            }
        }
    }

    private URI getResourceAsURI(String resource) {
        try {
            URL url = this.getClass().getResource(resource);
            if (url == null) {
                throw new RuntimeException("Required resource missing: " + resource);
            }
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

