/*
 * Decompiled with CFR 0.152.
 */
package cnabs.service;

import cnabs.dtomodel.AssetsCashflowEntry;
import cnabs.dtomodel.AssetsDistributionEntry;
import cnabs.dtomodel.AssetsRepaymentEntry;
import cnabs.dtomodel.AssetsSimpleDistributionEntry;
import cnabs.dtomodel.DateValueEntry;
import cnabs.dtomodel.SimpleEntry;
import cnabs.dtomodel.SimpleValueEntry;
import cnabs.service.CnabsApi;
import cnabs.service.FormatUtils;
import cnabs.service.HttpUtil;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetService
extends CnabsApi {
    private static StringBuilder getPrefixUrl(@Nullable String subUrl) {
        return new StringBuilder("https://api.cn-abs.com/").append("assets/openapi/assets/").append(subUrl == null ? "" : subUrl);
    }

    public static List<SimpleEntry> getAssetsDistributions(@NotNull String dealNameOrId) {
        return HttpUtil.doGetList(SimpleEntry.class, AssetService.getPrefixUrl(dealNameOrId).append("/distributions"), token, null);
    }

    public static List<AssetsDistributionEntry> getAssetsDistributionItemsByName(@NotNull String dealNameOrId, Date date, @NotNull String name) {
        return HttpUtil.doGetList(AssetsDistributionEntry.class, AssetService.getPrefixUrl(dealNameOrId).append("/distributions/").append(name + "/").append(FormatUtils.dateToYMD(date)), token, null);
    }

    public static List<AssetsSimpleDistributionEntry> getDefaultDistributions(@NotNull String dealNameOrId, Date date) {
        return HttpUtil.doGetList(AssetsSimpleDistributionEntry.class, AssetService.getPrefixUrl(dealNameOrId).append("/distributions/overdue/").append(FormatUtils.dateToYMD(date)), token, null);
    }

    public static List<AssetsSimpleDistributionEntry> getDefaultStatusProcessDistributions(@NotNull String dealNameOrId, Date date) {
        return HttpUtil.doGetList(AssetsSimpleDistributionEntry.class, AssetService.getPrefixUrl(dealNameOrId).append("/distributions/default_process/").append(FormatUtils.dateToYMD(date)), token, null);
    }

    public static List<AssetsCashflowEntry> getPromisedCashflows(@NotNull String dealNameOrId, Date date) {
        return HttpUtil.doGetList(AssetsCashflowEntry.class, AssetService.getPrefixUrl(dealNameOrId).append("/cashflows/forecast/report/").append(FormatUtils.dateToYMD(date)), token, null);
    }

    public static AssetsRepaymentEntry getRepayment(@NotNull String dealNameOrId, Date date) {
        return HttpUtil.doGet(AssetsRepaymentEntry.class, AssetService.getPrefixUrl(dealNameOrId).append("/cashflows/").append(FormatUtils.dateToYMD(date)), token, null);
    }

    public static List<DateValueEntry> getRepaymentDates(@NotNull String dealNameOrId) {
        return HttpUtil.doGetList(DateValueEntry.class, AssetService.getPrefixUrl(dealNameOrId).append("/dates"), token, null);
    }

    public static List<SimpleValueEntry> getAssetsStatisticItems(@NotNull String dealNameOrId, String itemName, Date date) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("itemName", itemName);
        body.put("date", date);
        return HttpUtil.doGetList(SimpleValueEntry.class, AssetService.getPrefixUrl(dealNameOrId).append("/statistics"), token, body);
    }
}

