/*
 * Decompiled with CFR 0.152.
 */
package cnabs.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class HttpUtil {
    public static <T> T doGet(Class<T> t, StringBuilder url, String token, IdentityHashMap<String, Object> params) {
        int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();
        String body = HttpUtil.HttpGetResult(url, token, params);
        Result jo = (Result)JSONObject.parseObject((String)body, Result.class);
        if (jo.code != 200) {
            throw new IllegalArgumentException(jo.message);
        }
        if (jo.data instanceof String || jo.data instanceof BigDecimal) {
            return jo.data;
        }
        return (T)JSON.toJavaObject((JSON)((JSONObject)jo.data), t);
    }

    public static <T> List<T> doGetList(Class<T> t, StringBuilder url, String token, IdentityHashMap<String, Object> params) {
        String body = HttpUtil.HttpGetResult(url, token, params);
        Result jo = (Result)JSONObject.parseObject((String)body, Result.class);
        if (jo.code != 200) {
            throw new IllegalArgumentException(jo.message);
        }
        boolean isList = jo.data instanceof List;
        if (isList) {
            String dataStr = JSONObject.parseObject((String)body).getString("data");
            return JSONArray.parseArray((String)dataStr, t);
        }
        return null;
    }

    public static <T> String HttpGetResult(StringBuilder url, String token, IdentityHashMap<String, Object> params) {
        try {
            if (params != null) {
                url.append("?");
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    Object value = entry.getValue();
                    if (value == null) continue;
                    if (value instanceof Date) {
                        value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value);
                    }
                    url.append(entry.getKey()).append("=").append(value).append("&");
                }
            }
            if (url.charAt(url.length() - 1) == '&') {
                url.deleteCharAt(url.length() - 1);
            }
            HttpClient client = HttpClient.newHttpClient();
            String urlstr = url.toString().replaceAll(" ", "%20");
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(urlstr)).setHeader("Authorization", token).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String body = response.body();
            return body;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public class StringObjectHashMap
    extends HashMap<String, Object> {
    }

    public static class Result<T> {
        public String status;
        public String message;
        public int code;
        public T data;

        public static <T> ResultBuilder<T> builder() {
            return new ResultBuilder();
        }

        public String getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public int getCode() {
            return this.code;
        }

        public T getData() {
            return this.data;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setData(T data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            T this$data = this.getData();
            T other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            T $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "HttpUtil.Result(status=" + this.getStatus() + ", message=" + this.getMessage() + ", code=" + this.getCode() + ", data=" + this.getData() + ")";
        }

        public Result(String status, String message, int code, T data) {
            this.status = status;
            this.message = message;
            this.code = code;
            this.data = data;
        }

        public static class ResultBuilder<T> {
            private String status;
            private String message;
            private int code;
            private T data;

            ResultBuilder() {
            }

            public ResultBuilder<T> status(String status) {
                this.status = status;
                return this;
            }

            public ResultBuilder<T> message(String message) {
                this.message = message;
                return this;
            }

            public ResultBuilder<T> code(int code) {
                this.code = code;
                return this;
            }

            public ResultBuilder<T> data(T data) {
                this.data = data;
                return this;
            }

            public Result<T> build() {
                return new Result<T>(this.status, this.message, this.code, this.data);
            }

            public String toString() {
                return "HttpUtil.Result.ResultBuilder(status=" + this.status + ", message=" + this.message + ", code=" + this.code + ", data=" + this.data + ")";
            }
        }
    }
}

