/*
 * Decompiled with CFR 0.152.
 */
package cnabs.service;

import cnabs.dtomodel.DateRangeValueEntry;
import cnabs.dtomodel.HolidayEntry;
import cnabs.dtomodel.MaturityYieldCurveDto;
import cnabs.dtomodel.MaturityYieldCurveValueDto;
import cnabs.dtomodel.SimpleEntry;
import cnabs.service.CnabsApi;
import cnabs.service.FormatUtils;
import cnabs.service.HttpUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OpendataService
extends CnabsApi {
    private static StringBuilder getPrefixUrl(@Nullable String subUrl) {
        return new StringBuilder("https://api.cn-abs.com/").append("opendata/openapi/").append(subUrl == null ? "" : subUrl);
    }

    public static List<HolidayEntry> getHolidayList(int year) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("year", year);
        return HttpUtil.doGetList(HolidayEntry.class, OpendataService.getPrefixUrl("calendar/cn/holidays"), token, body);
    }

    public static String getDateType(Date date) {
        return HttpUtil.doGet(String.class, OpendataService.getPrefixUrl("calendar/cn/").append(FormatUtils.dateToYMD(date)), token, null);
    }

    public static Map<String, Object> getDateTypes(Date start, Date end) {
        return HttpUtil.doGet(Map.class, OpendataService.getPrefixUrl("calendar/cn/").append(FormatUtils.dateToYMD(start)).append("/").append(FormatUtils.dateToYMD(end)), token, null);
    }

    public static Date shiftTradingDays(Date date, String rule, boolean isModify) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("isModify", isModify);
        String datestr = HttpUtil.doGet(String.class, OpendataService.getPrefixUrl("calendar/cn/adjust/").append(FormatUtils.dateToYMD(date)).append("/").append(rule), token, body);
        return FormatUtils.strToDate(datestr);
    }

    public static List<SimpleEntry> getRates() {
        return HttpUtil.doGetList(SimpleEntry.class, OpendataService.getPrefixUrl("rates"), token, null);
    }

    public static double getRateValue(String name, Date date) {
        BigDecimal val = HttpUtil.doGet(BigDecimal.class, OpendataService.getPrefixUrl("rates/").append(name).append("/").append(FormatUtils.dateToYMD(date)), token, null);
        return val.doubleValue();
    }

    public static List<DateRangeValueEntry> getRateValues(String name, Date begin, Date end) {
        return HttpUtil.doGetList(DateRangeValueEntry.class, OpendataService.getPrefixUrl("rates/").append(name + "/" + FormatUtils.dateToYMD(begin) + "/" + FormatUtils.dateToYMD(end)), token, null);
    }

    public static List<MaturityYieldCurveDto> getYieldCurves(String name, String source, String category, String rating, @Nullable float years) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("name", name);
        body.put("source", source);
        body.put("category", category);
        body.put("rating", rating);
        body.put("years", Float.valueOf(years));
        return HttpUtil.doGetList(MaturityYieldCurveDto.class, OpendataService.getPrefixUrl("yieldcurves/"), token, body);
    }

    public static List<MaturityYieldCurveValueDto> getYieldCurvesValues(String name, @Nullable Date start, @Nullable Date end, @Nullable Boolean isCached) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("name", name);
        body.put("start", start);
        body.put("end", end);
        if (isCached == null) {
            isCached = false;
        }
        body.put("isCached", isCached);
        return HttpUtil.doGetList(MaturityYieldCurveValueDto.class, OpendataService.getPrefixUrl("yieldcurves/values"), token, body);
    }
}

