/*
 * Decompiled with CFR 0.152.
 */
package cnabs.service;

import cnabs.dtomodel.IndustryEntry;
import cnabs.dtomodel.OrganizationEntry;
import cnabs.dtomodel.OrganizationRatingEntry;
import cnabs.dtomodel.OrganizationSimpleEntry;
import cnabs.service.CnabsApi;
import cnabs.service.HttpUtil;
import java.util.IdentityHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrganizationService
extends CnabsApi {
    private static StringBuilder getPrefixUrl(@Nullable String subUrl) {
        return new StringBuilder("https://api.cn-abs.com/").append("organization/openapi/organizations/").append(subUrl == null ? "" : subUrl);
    }

    public static OrganizationEntry getOrganization(@NotNull String orgNameOrId) {
        return HttpUtil.doGet(OrganizationEntry.class, OrganizationService.getPrefixUrl(orgNameOrId), token, null);
    }

    public static List<OrganizationSimpleEntry> getOrganizations(String keywords, String industry) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("keywords", keywords);
        body.put("industry", industry);
        return HttpUtil.doGetList(OrganizationSimpleEntry.class, OrganizationService.getPrefixUrl(null), token, body);
    }

    public static List<OrganizationRatingEntry> getOrgRatings(@NotNull String orgNameOrId) {
        return HttpUtil.doGetList(OrganizationRatingEntry.class, OrganizationService.getPrefixUrl(orgNameOrId).append("/ratings"), token, null);
    }

    public static List<IndustryEntry> getIndustry(@NotNull String source) {
        return HttpUtil.doGetList(IndustryEntry.class, OrganizationService.getPrefixUrl("industry/").append(source), token, null);
    }
}

