/*
 * Decompiled with CFR 0.152.
 */
package cnabs.service;

import cnabs.dtomodel.Deal;
import cnabs.dtomodel.DealBalanceStatisticsEntry;
import cnabs.dtomodel.DealCategoryEntry;
import cnabs.dtomodel.DealDateValueEntry;
import cnabs.dtomodel.DealEntry;
import cnabs.dtomodel.DealExecutionEntry;
import cnabs.dtomodel.DealFeePaymentEntry;
import cnabs.dtomodel.DealOrganization;
import cnabs.dtomodel.DealPaymentDateEntry;
import cnabs.dtomodel.DealSnapshotEntry;
import cnabs.dtomodel.SecuritySimpleEntry;
import cnabs.service.CnabsApi;
import cnabs.service.HttpUtil;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProductService
extends CnabsApi {
    private static StringBuilder getPrefixUrl(@Nullable String subUrl) {
        return new StringBuilder("https://api.cn-abs.com/").append("products/openapi/deals/").append(subUrl == null ? "" : subUrl);
    }

    public static List<Deal> getDealList(@Nullable String keywords, @Nullable String status, @Nullable Integer year, @Nullable String catalog, @Nullable String orgName) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("keywords", keywords);
        body.put("status", status);
        body.put("year", year);
        body.put("catalog", catalog);
        body.put("orgName", orgName);
        return HttpUtil.doGetList(Deal.class, ProductService.getPrefixUrl(""), token, body);
    }

    public static DealEntry getDealDetail(@NotNull String nameOrId) {
        return HttpUtil.doGet(DealEntry.class, ProductService.getPrefixUrl(nameOrId), token, null);
    }

    public static List<DealDateValueEntry> getDealDates(@NotNull String nameOrId, String dateType) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("dateType", dateType);
        return HttpUtil.doGetList(DealDateValueEntry.class, ProductService.getPrefixUrl(nameOrId).append("/dates"), token, body);
    }

    public static List<DealPaymentDateEntry> getPaymentDates(@NotNull String nameOrId) {
        return HttpUtil.doGetList(DealPaymentDateEntry.class, ProductService.getPrefixUrl(nameOrId).append("/payments"), token, null);
    }

    public static List<DealOrganization> getOrgs(@NotNull String nameOrId) {
        return HttpUtil.doGetList(DealOrganization.class, ProductService.getPrefixUrl(nameOrId).append("/orgs"), token, null);
    }

    public static List<DealOrganization> getOrgsByRole(@NotNull String nameOrId, @NotNull String role) {
        return HttpUtil.doGetList(DealOrganization.class, ProductService.getPrefixUrl(nameOrId).append("/orgs/").append(role), token, null);
    }

    public static List<DealExecutionEntry> getExecutions(@NotNull String nameOrId) {
        return HttpUtil.doGetList(DealExecutionEntry.class, ProductService.getPrefixUrl(nameOrId).append("/orgs/execution"), token, null);
    }

    public static DealSnapshotEntry getSnapshot(@NotNull String nameOrId, @Nullable Date date) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("date", date);
        DealSnapshotEntry result = HttpUtil.doGet(DealSnapshotEntry.class, ProductService.getPrefixUrl(nameOrId).append("/snapshot"), token, body);
        return result;
    }

    public static List<DealSnapshotEntry> getSnapshotsHistory(@NotNull String nameOrId, @NotNull Date begin, @NotNull Date end) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("begin", begin);
        body.put("end", end);
        return HttpUtil.doGetList(DealSnapshotEntry.class, ProductService.getPrefixUrl(nameOrId).append("/snapshots"), token, body);
    }

    public static List<SecuritySimpleEntry> getNotes(@NotNull String nameOrId) {
        return HttpUtil.doGetList(SecuritySimpleEntry.class, ProductService.getPrefixUrl(nameOrId).append("/securities"), token, null);
    }

    public static List<DealFeePaymentEntry> getDealFeePayment(@NotNull String nameOrId, @Nullable Date paymentDate) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("paymentDate", paymentDate);
        return HttpUtil.doGetList(DealFeePaymentEntry.class, ProductService.getPrefixUrl(nameOrId).append("/feePayment"), token, body);
    }

    public static List<DealCategoryEntry> getDealCategories(@Nullable String source) {
        return HttpUtil.doGetList(DealCategoryEntry.class, ProductService.getPrefixUrl("category/").append(source == null ? "" : source), token, null);
    }

    public static List<DealBalanceStatisticsEntry> getBalanceStatisticsByCatalog(@NotNull String begin, @NotNull String end, String category) {
        ProductService.ValidateDateStr(begin, end);
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("begin", begin);
        body.put("end", end);
        body.put("category", category);
        return HttpUtil.doGetList(DealBalanceStatisticsEntry.class, ProductService.getPrefixUrl("statistics/dealCategory"), token, body);
    }

    public static List<DealBalanceStatisticsEntry> getBalanceStatisticsByExchange(@NotNull String begin, @NotNull String end, String exchange) {
        ProductService.ValidateDateStr(begin, end);
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("begin", begin);
        body.put("end", end);
        body.put("exchange", exchange);
        List<DealBalanceStatisticsEntry> result = HttpUtil.doGetList(DealBalanceStatisticsEntry.class, ProductService.getPrefixUrl("statistics/exchange"), token, body);
        return result;
    }

    public static List<DealBalanceStatisticsEntry> getBalanceStatisticsByOrg(@NotNull String begin, @NotNull String end, String orgName) {
        ProductService.ValidateDateStr(begin, end);
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("begin", begin);
        body.put("end", end);
        body.put("orgName", orgName);
        List<DealBalanceStatisticsEntry> result = HttpUtil.doGetList(DealBalanceStatisticsEntry.class, ProductService.getPrefixUrl("statistics/org"), token, body);
        return result;
    }

    private static void ValidateDateStr(String ... dates) {
        String regex = "^\\d{4}(-\\d{2})?$";
        for (String date : dates) {
            if (Pattern.matches(regex, date)) continue;
            throw new IllegalArgumentException("\u82e5\u4e3a\u6708\u7edf\u8ba1\uff0c\u683c\u5f0f\u5e94\u4e3ayyyy-MM\uff0c\u82e5\u4e3a\u5e74\u7edf\u8ba1\uff0c\u683c\u5f0f\u5e94\u4e3ayyyy");
        }
    }
}

