/*
 * Decompiled with CFR 0.152.
 */
package cnabs.service;

import cnabs.dtomodel.DateValueEntry;
import cnabs.dtomodel.ProjectEntry;
import cnabs.dtomodel.ProjectStatisticModel;
import cnabs.service.CnabsApi;
import cnabs.service.HttpUtil;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ProjectAuditService
extends CnabsApi {
    private static StringBuilder getPrefixUrl(@Nullable String subUrl) {
        return new StringBuilder("https://api.cn-abs.com/").append("projects/openapi/projects/").append(subUrl == null ? "" : subUrl);
    }

    public static List<ProjectStatisticModel> getExchangeStatistic(Date begin, Date end, String statisticItem) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("begin", begin);
        body.put("end", end);
        body.put("statisticItem", statisticItem);
        return HttpUtil.doGetList(ProjectStatisticModel.class, ProjectAuditService.getPrefixUrl("exchanges"), token, body);
    }

    public static List<DateValueEntry> getProjectHistory(String id) {
        return HttpUtil.doGetList(DateValueEntry.class, ProjectAuditService.getPrefixUrl(id).append("/timelines"), token, null);
    }

    public static List<ProjectEntry> getProjects(String keywords, @Nullable Date begin, @Nullable Date end, String status) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("keywords", keywords);
        body.put("begin", begin);
        body.put("end", end);
        body.put("status", status);
        return HttpUtil.doGetList(ProjectEntry.class, ProjectAuditService.getPrefixUrl(null), token, body);
    }
}

