/*
 * Decompiled with CFR 0.152.
 */
package cnabs.service;

import cnabs.dtomodel.CashflowEntry;
import cnabs.dtomodel.SecurityCouponEntry;
import cnabs.dtomodel.SecurityCreditEntry;
import cnabs.dtomodel.SecurityEntry;
import cnabs.dtomodel.SecurityPaymentEntry;
import cnabs.dtomodel.SecurityRatingEntry;
import cnabs.dtomodel.SecuritySimpleEntry;
import cnabs.dtomodel.SecuritySnapshotEntry;
import cnabs.dtomodel.UpdateEntry;
import cnabs.service.CnabsApi;
import cnabs.service.FormatUtils;
import cnabs.service.HttpUtil;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecurityService
extends CnabsApi {
    private static StringBuilder getPrefixUrl(@Nullable String subUrl) {
        return new StringBuilder("https://api.cn-abs.com/").append("products/openapi/securities/").append(subUrl == null ? "" : subUrl);
    }

    public static List<SecuritySimpleEntry> getSimpleList(@Nullable String keywords, @Nullable Date begin, @Nullable Date end, String status, @Nullable Integer year, @Nullable String catalog, @Nullable String orgName) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("keywords", keywords);
        body.put("begin", begin);
        body.put("end", end);
        body.put("status", status);
        body.put("year", year);
        body.put("catalog", catalog);
        body.put("orgName", orgName);
        return HttpUtil.doGetList(SecuritySimpleEntry.class, SecurityService.getPrefixUrl(""), token, body);
    }

    public static SecurityEntry getSecurity(@NotNull String codeOrId) {
        return HttpUtil.doGet(SecurityEntry.class, SecurityService.getPrefixUrl(codeOrId), token, null);
    }

    public static List<SecurityRatingEntry> getRatingSnapshot(@NotNull String codeOrId, @Nullable Date date, String ratingAgency) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("codeOrId", codeOrId);
        body.put("date", date);
        body.put("ratingAgency", ratingAgency);
        return HttpUtil.doGetList(SecurityRatingEntry.class, SecurityService.getPrefixUrl(codeOrId).append("/ratings/snapshot"), token, body);
    }

    public static List<SecurityRatingEntry> getRatingHistory(@NotNull String codeOrId, @Nullable Date begin, @Nullable Date end, String ratingAgency) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("codeOrId", codeOrId);
        body.put("begin", begin);
        body.put("end", end);
        body.put("ratingAgency", ratingAgency);
        return HttpUtil.doGetList(SecurityRatingEntry.class, SecurityService.getPrefixUrl(codeOrId).append("/ratings"), token, body);
    }

    public static SecurityPaymentEntry getPaymentInfo(@NotNull String codeOrId, Date paymentDate) {
        return HttpUtil.doGet(SecurityPaymentEntry.class, SecurityService.getPrefixUrl(codeOrId).append("/payments/").append(FormatUtils.dateToYMD(paymentDate)), token, null);
    }

    public static List<SecurityPaymentEntry> getPaymentInfos(@NotNull String codeOrId) {
        return HttpUtil.doGetList(SecurityPaymentEntry.class, SecurityService.getPrefixUrl(codeOrId).append("/payments"), token, null);
    }

    public static List<SecuritySnapshotEntry> getSnapshots(@NotNull String codeOrId, @Nullable Date begin, @Nullable Date end) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("codeOrId", codeOrId);
        body.put("begin", begin);
        body.put("end", end);
        return HttpUtil.doGetList(SecuritySnapshotEntry.class, SecurityService.getPrefixUrl(codeOrId).append("/snapshots"), token, body);
    }

    public static SecuritySnapshotEntry getSnapshot(@NotNull String codeOrId, @Nullable Date date) {
        IdentityHashMap<String, Object> body = new IdentityHashMap<String, Object>();
        body.put("date", date);
        return HttpUtil.doGet(SecuritySnapshotEntry.class, SecurityService.getPrefixUrl(codeOrId).append("/snapshot"), token, body);
    }

    public static List<CashflowEntry> getSchedulePayments(@NotNull String codeOrId) {
        return HttpUtil.doGetList(CashflowEntry.class, SecurityService.getPrefixUrl(codeOrId).append("/payments/scheduled"), token, null);
    }

    public static SecurityCouponEntry getSecurityCoupon(@NotNull String codeOrId) {
        return HttpUtil.doGet(SecurityCouponEntry.class, SecurityService.getPrefixUrl(codeOrId).append("/coupon"), token, null);
    }

    public static List<SecurityCreditEntry> getSecurityCredits(@NotNull String codeOrId) {
        return HttpUtil.doGetList(SecurityCreditEntry.class, SecurityService.getPrefixUrl(codeOrId).append("/credits"), token, null);
    }

    public static List<UpdateEntry> getUpdatedNotesAll(@Nullable Date requestTime) {
        return HttpUtil.doGetList(UpdateEntry.class, SecurityService.getPrefixUrl("updated/").append(requestTime != null ? FormatUtils.dateToYMD(requestTime) : ""), token, null);
    }
}

