;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.alexaforbusiness.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.alexaforbusiness/DeleteContactRequest
  (s/keys :req-un [:cognitect.aws.alexaforbusiness.DeleteContactRequest/ContactArn]))

(s/def
  :cognitect.aws.alexaforbusiness/ListBusinessReportSchedulesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListBusinessReportSchedulesResponse/NextToken
     :cognitect.aws.alexaforbusiness.ListBusinessReportSchedulesResponse/BusinessReportSchedules]))

(s/def :cognitect.aws.alexaforbusiness/Url string?)

(s/def
  :cognitect.aws.alexaforbusiness/ListDeviceEventsRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.ListDeviceEventsRequest/DeviceArn]
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListDeviceEventsRequest/EventType
     :cognitect.aws.alexaforbusiness.ListDeviceEventsRequest/NextToken
     :cognitect.aws.alexaforbusiness.ListDeviceEventsRequest/MaxResults]))

(s/def
  :cognitect.aws.alexaforbusiness/GetConferenceProviderResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.GetConferenceProviderResponse/ConferenceProvider]))

(s/def
  :cognitect.aws.alexaforbusiness/CreateBusinessReportScheduleRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/Format
     :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/ContentRange]
    :opt-un
    [:cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/ClientRequestToken
     :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/Recurrence
     :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/S3BucketName
     :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/S3KeyPrefix
     :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/ScheduleName]))

(s/def
  :cognitect.aws.alexaforbusiness/AddressBookDataList
  (s/coll-of :cognitect.aws.alexaforbusiness/AddressBookData))

(s/def
  :cognitect.aws.alexaforbusiness/ListSkillsStoreCategoriesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListSkillsStoreCategoriesRequest/NextToken
     :cognitect.aws.alexaforbusiness.ListSkillsStoreCategoriesRequest/MaxResults]))

(s/def
  :cognitect.aws.alexaforbusiness/AuthorizationResult
  (s/map-of :cognitect.aws.alexaforbusiness/Key :cognitect.aws.alexaforbusiness/Value))

(s/def
  :cognitect.aws.alexaforbusiness/ContactData
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ContactData/ContactArn
     :cognitect.aws.alexaforbusiness.ContactData/DisplayName
     :cognitect.aws.alexaforbusiness.ContactData/LastName
     :cognitect.aws.alexaforbusiness.ContactData/FirstName
     :cognitect.aws.alexaforbusiness.ContactData/PhoneNumber]))

(s/def
  :cognitect.aws.alexaforbusiness/SearchProfilesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchProfilesRequest/NextToken
     :cognitect.aws.alexaforbusiness.SearchProfilesRequest/Filters
     :cognitect.aws.alexaforbusiness.SearchProfilesRequest/MaxResults
     :cognitect.aws.alexaforbusiness.SearchProfilesRequest/SortCriteria]))

(s/def
  :cognitect.aws.alexaforbusiness/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.TagResourceRequest/Arn
     :cognitect.aws.alexaforbusiness.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.alexaforbusiness/OneClickPinDelay
  (s/with-gen
    (s/and string? #(<= 1 (count %) 2))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 2 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.alexaforbusiness/EnablementTypeFilter #{"PENDING" "ENABLED"})

(s/def
  :cognitect.aws.alexaforbusiness/GetRoomResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetRoomResponse/Room]))

(s/def
  :cognitect.aws.alexaforbusiness/AddressBookDescription
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/RoomSkillParameterValue
  (s/with-gen
    (s/and string? #(<= 1 (count %) 512))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 512 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/ListTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.ListTagsRequest/Arn]
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListTagsRequest/NextToken
     :cognitect.aws.alexaforbusiness.ListTagsRequest/MaxResults]))

(s/def
  :cognitect.aws.alexaforbusiness/GetRoomSkillParameterResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.GetRoomSkillParameterResponse/RoomSkillParameter]))

(s/def :cognitect.aws.alexaforbusiness/DistanceUnit #{"IMPERIAL" "METRIC"})

(s/def :cognitect.aws.alexaforbusiness/DisassociateDeviceFromRoomResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/CreateUserResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.CreateUserResponse/UserArn]))

(s/def
  :cognitect.aws.alexaforbusiness/BusinessReportSchedule
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.BusinessReportSchedule/LastBusinessReport
     :cognitect.aws.alexaforbusiness.BusinessReportSchedule/Recurrence
     :cognitect.aws.alexaforbusiness.BusinessReportSchedule/ContentRange
     :cognitect.aws.alexaforbusiness.BusinessReportSchedule/S3BucketName
     :cognitect.aws.alexaforbusiness.BusinessReportSchedule/Format
     :cognitect.aws.alexaforbusiness.BusinessReportSchedule/ScheduleArn
     :cognitect.aws.alexaforbusiness.BusinessReportSchedule/S3KeyPrefix
     :cognitect.aws.alexaforbusiness.BusinessReportSchedule/ScheduleName]))

(s/def
  :cognitect.aws.alexaforbusiness/Tag
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.Tag/Key :cognitect.aws.alexaforbusiness.Tag/Value]))

(s/def
  :cognitect.aws.alexaforbusiness/ConferenceProvidersList
  (s/coll-of :cognitect.aws.alexaforbusiness/ConferenceProvider))

(s/def
  :cognitect.aws.alexaforbusiness/CategoryList
  (s/coll-of :cognitect.aws.alexaforbusiness/Category))

(s/def
  :cognitect.aws.alexaforbusiness/DeveloperInfo
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.DeveloperInfo/PrivacyPolicy
     :cognitect.aws.alexaforbusiness.DeveloperInfo/Email
     :cognitect.aws.alexaforbusiness.DeveloperInfo/DeveloperName
     :cognitect.aws.alexaforbusiness.DeveloperInfo/Url]))

(s/def :cognitect.aws.alexaforbusiness/RejectSkillResponse (s/keys))

(s/def :cognitect.aws.alexaforbusiness/UpdateRoomResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/ResolveRoomResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ResolveRoomResponse/RoomSkillParameters
     :cognitect.aws.alexaforbusiness.ResolveRoomResponse/RoomArn
     :cognitect.aws.alexaforbusiness.ResolveRoomResponse/RoomName]))

(s/def
  :cognitect.aws.alexaforbusiness/SkillGroupName
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/DisassociateSkillFromSkillGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.DisassociateSkillFromSkillGroupRequest/SkillId]
    :opt-un
    [:cognitect.aws.alexaforbusiness.DisassociateSkillFromSkillGroupRequest/SkillGroupArn]))

(s/def
  :cognitect.aws.alexaforbusiness/SearchSkillGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchSkillGroupsResponse/NextToken
     :cognitect.aws.alexaforbusiness.SearchSkillGroupsResponse/TotalCount
     :cognitect.aws.alexaforbusiness.SearchSkillGroupsResponse/SkillGroups]))

(s/def :cognitect.aws.alexaforbusiness/EnablementType #{"PENDING" "ENABLED"})

(s/def
  :cognitect.aws.alexaforbusiness/SortKey
  (s/with-gen
    (s/and string? #(<= 1 (count %) 500))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 500 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.alexaforbusiness/SortValue #{"DESC" "ASC"})

(s/def :cognitect.aws.alexaforbusiness/TagResourceResponse (s/keys))

(s/def :cognitect.aws.alexaforbusiness/ProductDescription string?)

(s/def
  :cognitect.aws.alexaforbusiness/DeleteBusinessReportScheduleRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.DeleteBusinessReportScheduleRequest/ScheduleArn]))

(s/def
  :cognitect.aws.alexaforbusiness/GetConferencePreferenceResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetConferencePreferenceResponse/Preference]))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceData
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.DeviceData/DeviceSerialNumber
     :cognitect.aws.alexaforbusiness.DeviceData/SoftwareVersion
     :cognitect.aws.alexaforbusiness.DeviceData/DeviceStatusInfo
     :cognitect.aws.alexaforbusiness.DeviceData/MacAddress
     :cognitect.aws.alexaforbusiness.DeviceData/DeviceArn
     :cognitect.aws.alexaforbusiness.DeviceData/DeviceType
     :cognitect.aws.alexaforbusiness.DeviceData/DeviceStatus
     :cognitect.aws.alexaforbusiness.DeviceData/DeviceName
     :cognitect.aws.alexaforbusiness.DeviceData/RoomArn
     :cognitect.aws.alexaforbusiness.DeviceData/RoomName]))

(s/def :cognitect.aws.alexaforbusiness/ApplianceManufacturerName string?)

(s/def
  :cognitect.aws.alexaforbusiness/RoomSkillParameters
  (s/coll-of :cognitect.aws.alexaforbusiness/RoomSkillParameter))

(s/def
  :cognitect.aws.alexaforbusiness/ForgetSmartHomeAppliancesRequest
  (s/keys :req-un [:cognitect.aws.alexaforbusiness.ForgetSmartHomeAppliancesRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/UpdateSkillGroupRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.UpdateSkillGroupRequest/SkillGroupName
     :cognitect.aws.alexaforbusiness.UpdateSkillGroupRequest/SkillGroupArn
     :cognitect.aws.alexaforbusiness.UpdateSkillGroupRequest/Description]))

(s/def
  :cognitect.aws.alexaforbusiness/Endpoint
  (s/with-gen
    (s/and string? #(<= 1 (count %) 256))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 256 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/Filter
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.Filter/Key :cognitect.aws.alexaforbusiness.Filter/Values]))

(s/def
  :cognitect.aws.alexaforbusiness/StartSmartHomeApplianceDiscoveryRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.StartSmartHomeApplianceDiscoveryRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/user_UserId
  (s/with-gen #(re-matches (re-pattern "[a-zA-Z0-9@_+.-]*") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/ContactDataList
  (s/coll-of :cognitect.aws.alexaforbusiness/ContactData))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceType
  (s/with-gen #(re-matches (re-pattern "[a-zA-Z0-9]{1,200}") %) #(gen/string)))

(s/def :cognitect.aws.alexaforbusiness/ForgetSmartHomeAppliancesResponse (s/keys))

(s/def :cognitect.aws.alexaforbusiness/ApplianceFriendlyName string?)

(s/def
  :cognitect.aws.alexaforbusiness/SkillsStoreSkill
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SkillsStoreSkill/SkillName
     :cognitect.aws.alexaforbusiness.SkillsStoreSkill/ShortDescription
     :cognitect.aws.alexaforbusiness.SkillsStoreSkill/SupportsLinking
     :cognitect.aws.alexaforbusiness.SkillsStoreSkill/SampleUtterances
     :cognitect.aws.alexaforbusiness.SkillsStoreSkill/SkillDetails
     :cognitect.aws.alexaforbusiness.SkillsStoreSkill/IconUrl
     :cognitect.aws.alexaforbusiness.SkillsStoreSkill/SkillId]))

(s/def
  :cognitect.aws.alexaforbusiness/ListSkillsStoreSkillsByCategoryRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.ListSkillsStoreSkillsByCategoryRequest/CategoryId]
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListSkillsStoreSkillsByCategoryRequest/NextToken
     :cognitect.aws.alexaforbusiness.ListSkillsStoreSkillsByCategoryRequest/MaxResults]))

(s/def
  :cognitect.aws.alexaforbusiness/FilterKey
  (s/with-gen
    (s/and string? #(<= 1 (count %) 500))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 500 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/SearchUsersRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchUsersRequest/NextToken
     :cognitect.aws.alexaforbusiness.SearchUsersRequest/Filters
     :cognitect.aws.alexaforbusiness.SearchUsersRequest/MaxResults
     :cognitect.aws.alexaforbusiness.SearchUsersRequest/SortCriteria]))

(s/def
  :cognitect.aws.alexaforbusiness/BulletPoints
  (s/coll-of :cognitect.aws.alexaforbusiness/BulletPoint))

(s/def
  :cognitect.aws.alexaforbusiness/IPDialIn
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.IPDialIn/Endpoint
     :cognitect.aws.alexaforbusiness.IPDialIn/CommsProtocol]))

(s/def
  :cognitect.aws.alexaforbusiness/ProviderCalendarId
  (s/with-gen
    (s/and string? #(<= 0 (count %) 100))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 0 0) (or 100 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/Feature
  #{"NOTIFICATIONS" "SKILLS" "LISTS" "BLUETOOTH" "VOLUME" "ALL"})

(s/def
  :cognitect.aws.alexaforbusiness/ListBusinessReportSchedulesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListBusinessReportSchedulesRequest/NextToken
     :cognitect.aws.alexaforbusiness.ListBusinessReportSchedulesRequest/MaxResults]))

(s/def
  :cognitect.aws.alexaforbusiness/ConferencePreference
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ConferencePreference/DefaultConferenceProviderArn]))

(s/def :cognitect.aws.alexaforbusiness/Utterance string?)

(s/def :cognitect.aws.alexaforbusiness/TagList (s/coll-of :cognitect.aws.alexaforbusiness/Tag))

(s/def :cognitect.aws.alexaforbusiness/DeleteRoomResponse (s/keys))

(s/def :cognitect.aws.alexaforbusiness/AssociateSkillWithSkillGroupResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/AssociateSkillGroupWithRoomRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.AssociateSkillGroupWithRoomRequest/SkillGroupArn
     :cognitect.aws.alexaforbusiness.AssociateSkillGroupWithRoomRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceName
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def :cognitect.aws.alexaforbusiness/DisassociateSkillFromSkillGroupResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/UserData
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.UserData/Email
     :cognitect.aws.alexaforbusiness.UserData/EnrollmentId
     :cognitect.aws.alexaforbusiness.UserData/LastName
     :cognitect.aws.alexaforbusiness.UserData/UserArn
     :cognitect.aws.alexaforbusiness.UserData/FirstName
     :cognitect.aws.alexaforbusiness.UserData/EnrollmentStatus]))

(s/def
  :cognitect.aws.alexaforbusiness/Profile
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.Profile/Address
     :cognitect.aws.alexaforbusiness.Profile/WakeWord
     :cognitect.aws.alexaforbusiness.Profile/SetupModeDisabled
     :cognitect.aws.alexaforbusiness.Profile/PSTNEnabled
     :cognitect.aws.alexaforbusiness.Profile/Timezone
     :cognitect.aws.alexaforbusiness.Profile/MaxVolumeLimit
     :cognitect.aws.alexaforbusiness.Profile/ProfileArn
     :cognitect.aws.alexaforbusiness.Profile/AddressBookArn
     :cognitect.aws.alexaforbusiness.Profile/TemperatureUnit
     :cognitect.aws.alexaforbusiness.Profile/DistanceUnit
     :cognitect.aws.alexaforbusiness.Profile/IsDefault
     :cognitect.aws.alexaforbusiness.Profile/ProfileName]))

(s/def
  :cognitect.aws.alexaforbusiness/CreateContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.CreateContactRequest/FirstName]
    :opt-un
    [:cognitect.aws.alexaforbusiness.CreateContactRequest/ClientRequestToken
     :cognitect.aws.alexaforbusiness.CreateContactRequest/DisplayName
     :cognitect.aws.alexaforbusiness.CreateContactRequest/LastName
     :cognitect.aws.alexaforbusiness.CreateContactRequest/PhoneNumber]))

(s/def
  :cognitect.aws.alexaforbusiness/ListSkillsStoreCategoriesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListSkillsStoreCategoriesResponse/CategoryList
     :cognitect.aws.alexaforbusiness.ListSkillsStoreCategoriesResponse/NextToken]))

(s/def
  :cognitect.aws.alexaforbusiness/SkillGroupDescription
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def :cognitect.aws.alexaforbusiness/DeleteSkillAuthorizationResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/ConferenceProviderType
  #{"CUSTOM" "BLUEJEANS" "WEBEX" "FUZE" "GOOGLE_HANGOUTS" "ZOOM" "RINGCENTRAL" "POLYCOM"
    "SKYPE_FOR_BUSINESS" "CHIME"})

(s/def :cognitect.aws.alexaforbusiness/GenericKeyword string?)

(s/def
  :cognitect.aws.alexaforbusiness/Key
  (s/with-gen
    (s/and string? #(<= 1 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or nil 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/CountryCode
  (s/with-gen #(re-matches (re-pattern "\\d{1,3}") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/SearchAddressBooksRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchAddressBooksRequest/NextToken
     :cognitect.aws.alexaforbusiness.SearchAddressBooksRequest/Filters
     :cognitect.aws.alexaforbusiness.SearchAddressBooksRequest/MaxResults
     :cognitect.aws.alexaforbusiness.SearchAddressBooksRequest/SortCriteria]))

(s/def
  :cognitect.aws.alexaforbusiness/FilterValueList
  (s/coll-of :cognitect.aws.alexaforbusiness/FilterValue :max-count 5))

(s/def
  :cognitect.aws.alexaforbusiness/RoomName
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/RoomDataList
  (s/coll-of :cognitect.aws.alexaforbusiness/RoomData))

(s/def
  :cognitect.aws.alexaforbusiness/DeleteRoomRequest
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.DeleteRoomRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/UpdateConferenceProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.UpdateConferenceProviderRequest/ConferenceProviderArn
     :cognitect.aws.alexaforbusiness.UpdateConferenceProviderRequest/ConferenceProviderType
     :cognitect.aws.alexaforbusiness.UpdateConferenceProviderRequest/MeetingSetting]
    :opt-un
    [:cognitect.aws.alexaforbusiness.UpdateConferenceProviderRequest/IPDialIn
     :cognitect.aws.alexaforbusiness.UpdateConferenceProviderRequest/PSTNDialIn]))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceStatusDetailCode
  #{"DEVICE_WAS_OFFLINE" "DEVICE_SOFTWARE_UPDATE_NEEDED"})

(s/def
  :cognitect.aws.alexaforbusiness/DisassociateContactFromAddressBookRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.DisassociateContactFromAddressBookRequest/ContactArn
     :cognitect.aws.alexaforbusiness.DisassociateContactFromAddressBookRequest/AddressBookArn]))

(s/def
  :cognitect.aws.alexaforbusiness/Sort
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.Sort/Key :cognitect.aws.alexaforbusiness.Sort/Value]))

(s/def
  :cognitect.aws.alexaforbusiness/GetAddressBookResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetAddressBookResponse/AddressBook]))

(s/def
  :cognitect.aws.alexaforbusiness/DisassociateDeviceFromRoomRequest
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.DisassociateDeviceFromRoomRequest/DeviceArn]))

(s/def
  :cognitect.aws.alexaforbusiness/Email
  (s/with-gen
    #(re-matches
      (re-pattern
        "([0-9a-zA-Z]([+-.\\w]*[0-9a-zA-Z])*@([0-9a-zA-Z][-\\w]*[0-9a-zA-Z]\\.)+[a-zA-Z]{2,9})")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/ConferenceProvider
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ConferenceProvider/IPDialIn
     :cognitect.aws.alexaforbusiness.ConferenceProvider/Type
     :cognitect.aws.alexaforbusiness.ConferenceProvider/PSTNDialIn
     :cognitect.aws.alexaforbusiness.ConferenceProvider/Arn
     :cognitect.aws.alexaforbusiness.ConferenceProvider/Name
     :cognitect.aws.alexaforbusiness.ConferenceProvider/MeetingSetting]))

(s/def
  :cognitect.aws.alexaforbusiness/GetSkillGroupResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetSkillGroupResponse/SkillGroup]))

(s/def
  :cognitect.aws.alexaforbusiness/SendInvitationRequest
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.SendInvitationRequest/UserArn]))

(s/def :cognitect.aws.alexaforbusiness/CommsProtocol #{"SIP" "H323" "SIPS"})

(s/def :cognitect.aws.alexaforbusiness/UpdateAddressBookResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/EnrollmentId
  (s/with-gen
    (s/and string? #(<= 0 (count %) 128))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 0 0) (or 128 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/SampleUtterances
  (s/coll-of :cognitect.aws.alexaforbusiness/Utterance))

(s/def :cognitect.aws.alexaforbusiness/UpdateSkillGroupResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/Room
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.Room/ProviderCalendarId
     :cognitect.aws.alexaforbusiness.Room/Description
     :cognitect.aws.alexaforbusiness.Room/ProfileArn
     :cognitect.aws.alexaforbusiness.Room/RoomArn
     :cognitect.aws.alexaforbusiness.Room/RoomName]))

(s/def
  :cognitect.aws.alexaforbusiness/SkillSummary
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SkillSummary/SkillName
     :cognitect.aws.alexaforbusiness.SkillSummary/SupportsLinking
     :cognitect.aws.alexaforbusiness.SkillSummary/EnablementType
     :cognitect.aws.alexaforbusiness.SkillSummary/SkillType
     :cognitect.aws.alexaforbusiness.SkillSummary/SkillId]))

(s/def :cognitect.aws.alexaforbusiness/BusinessReportInterval #{"ONE_DAY" "ONE_WEEK"})

(s/def
  :cognitect.aws.alexaforbusiness/GenericKeywords
  (s/coll-of :cognitect.aws.alexaforbusiness/GenericKeyword))

(s/def :cognitect.aws.alexaforbusiness/Boolean boolean?)

(s/def
  :cognitect.aws.alexaforbusiness/DeleteSkillAuthorizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.DeleteSkillAuthorizationRequest/SkillId]
    :opt-un
    [:cognitect.aws.alexaforbusiness.DeleteSkillAuthorizationRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/SkillId
  (s/with-gen
    #(re-matches
      (re-pattern
        "(^amzn1\\.ask\\.skill\\.[0-9a-f\\-]{1,200})|(^amzn1\\.echo-sdk-ams\\.app\\.[0-9a-f\\-]{1,200})")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/GetDeviceResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetDeviceResponse/Device]))

(s/def
  :cognitect.aws.alexaforbusiness/AddressBookName
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceEventList
  (s/coll-of :cognitect.aws.alexaforbusiness/DeviceEvent))

(s/def
  :cognitect.aws.alexaforbusiness/AssociateContactWithAddressBookRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.AssociateContactWithAddressBookRequest/ContactArn
     :cognitect.aws.alexaforbusiness.AssociateContactWithAddressBookRequest/AddressBookArn]))

(s/def
  :cognitect.aws.alexaforbusiness/CreateSkillGroupResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.CreateSkillGroupResponse/SkillGroupArn]))

(s/def :cognitect.aws.alexaforbusiness/PutRoomSkillParameterResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/UserDataList
  (s/coll-of :cognitect.aws.alexaforbusiness/UserData))

(s/def
  :cognitect.aws.alexaforbusiness/ContactName
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def :cognitect.aws.alexaforbusiness/UpdateDeviceResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/BusinessReportScheduleList
  (s/coll-of :cognitect.aws.alexaforbusiness/BusinessReportSchedule))

(s/def
  :cognitect.aws.alexaforbusiness/UpdateProfileRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.UpdateProfileRequest/Address
     :cognitect.aws.alexaforbusiness.UpdateProfileRequest/WakeWord
     :cognitect.aws.alexaforbusiness.UpdateProfileRequest/SetupModeDisabled
     :cognitect.aws.alexaforbusiness.UpdateProfileRequest/PSTNEnabled
     :cognitect.aws.alexaforbusiness.UpdateProfileRequest/Timezone
     :cognitect.aws.alexaforbusiness.UpdateProfileRequest/MaxVolumeLimit
     :cognitect.aws.alexaforbusiness.UpdateProfileRequest/ProfileArn
     :cognitect.aws.alexaforbusiness.UpdateProfileRequest/TemperatureUnit
     :cognitect.aws.alexaforbusiness.UpdateProfileRequest/DistanceUnit
     :cognitect.aws.alexaforbusiness.UpdateProfileRequest/IsDefault
     :cognitect.aws.alexaforbusiness.UpdateProfileRequest/ProfileName]))

(s/def
  :cognitect.aws.alexaforbusiness/DeleteSkillGroupRequest
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.DeleteSkillGroupRequest/SkillGroupArn]))

(s/def
  :cognitect.aws.alexaforbusiness/RevokeInvitationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.RevokeInvitationRequest/EnrollmentId
     :cognitect.aws.alexaforbusiness.RevokeInvitationRequest/UserArn]))

(s/def
  :cognitect.aws.alexaforbusiness/PSTNDialIn
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.PSTNDialIn/CountryCode
     :cognitect.aws.alexaforbusiness.PSTNDialIn/PhoneNumber
     :cognitect.aws.alexaforbusiness.PSTNDialIn/OneClickIdDelay
     :cognitect.aws.alexaforbusiness.PSTNDialIn/OneClickPinDelay]))

(s/def :cognitect.aws.alexaforbusiness/SkillType #{"PRIVATE" "PUBLIC"})

(s/def :cognitect.aws.alexaforbusiness/BusinessReportFormat #{"CSV" "CSV_ZIP"})

(s/def :cognitect.aws.alexaforbusiness/DeleteRoomSkillParameterResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/ConferenceProviderName
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/NextToken
  (s/with-gen
    (s/and string? #(<= 1 (count %) 1000))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 1000 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/EnrollmentStatus
  #{"DEREGISTERING" "PENDING" "REGISTERED" "INITIALIZED" "DISASSOCIATING"})

(s/def
  :cognitect.aws.alexaforbusiness/SearchSkillGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchSkillGroupsRequest/NextToken
     :cognitect.aws.alexaforbusiness.SearchSkillGroupsRequest/Filters
     :cognitect.aws.alexaforbusiness.SearchSkillGroupsRequest/MaxResults
     :cognitect.aws.alexaforbusiness.SearchSkillGroupsRequest/SortCriteria]))

(s/def
  :cognitect.aws.alexaforbusiness/Address
  (s/with-gen
    (s/and string? #(<= 1 (count %) 500))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 500 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.alexaforbusiness/DeleteBusinessReportScheduleResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/CreateBusinessReportScheduleResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleResponse/ScheduleArn]))

(s/def
  :cognitect.aws.alexaforbusiness/CreateRoomRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.CreateRoomRequest/RoomName]
    :opt-un
    [:cognitect.aws.alexaforbusiness.CreateRoomRequest/ClientRequestToken
     :cognitect.aws.alexaforbusiness.CreateRoomRequest/ProviderCalendarId
     :cognitect.aws.alexaforbusiness.CreateRoomRequest/Tags
     :cognitect.aws.alexaforbusiness.CreateRoomRequest/Description
     :cognitect.aws.alexaforbusiness.CreateRoomRequest/ProfileArn]))

(s/def
  :cognitect.aws.alexaforbusiness/ListTagsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListTagsResponse/Tags
     :cognitect.aws.alexaforbusiness.ListTagsResponse/NextToken]))

(s/def
  :cognitect.aws.alexaforbusiness/ListSmartHomeAppliancesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListSmartHomeAppliancesResponse/NextToken
     :cognitect.aws.alexaforbusiness.ListSmartHomeAppliancesResponse/SmartHomeAppliances]))

(s/def :cognitect.aws.alexaforbusiness/PutSkillAuthorizationResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/SmartHomeAppliance
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SmartHomeAppliance/Description
     :cognitect.aws.alexaforbusiness.SmartHomeAppliance/FriendlyName
     :cognitect.aws.alexaforbusiness.SmartHomeAppliance/ManufacturerName]))

(s/def
  :cognitect.aws.alexaforbusiness/ProductId
  (s/with-gen #(re-matches (re-pattern "^[a-zA-Z0-9_]{1,256}$") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/SkillSummaryList
  (s/coll-of :cognitect.aws.alexaforbusiness/SkillSummary))

(s/def
  :cognitect.aws.alexaforbusiness/TagValue
  (s/with-gen #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceSerialNumber
  (s/with-gen #(re-matches (re-pattern "[a-zA-Z0-9]{1,200}") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/GetSkillGroupRequest
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetSkillGroupRequest/SkillGroupArn]))

(s/def
  :cognitect.aws.alexaforbusiness/AssociateDeviceWithRoomRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.AssociateDeviceWithRoomRequest/DeviceArn
     :cognitect.aws.alexaforbusiness.AssociateDeviceWithRoomRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/AssociateSkillWithSkillGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.AssociateSkillWithSkillGroupRequest/SkillId]
    :opt-un
    [:cognitect.aws.alexaforbusiness.AssociateSkillWithSkillGroupRequest/SkillGroupArn]))

(s/def
  :cognitect.aws.alexaforbusiness/SearchDevicesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchDevicesRequest/NextToken
     :cognitect.aws.alexaforbusiness.SearchDevicesRequest/Filters
     :cognitect.aws.alexaforbusiness.SearchDevicesRequest/MaxResults
     :cognitect.aws.alexaforbusiness.SearchDevicesRequest/SortCriteria]))

(s/def :cognitect.aws.alexaforbusiness/BusinessReportS3Path string?)

(s/def
  :cognitect.aws.alexaforbusiness/ClientRequestToken
  (s/with-gen #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/OneClickIdDelay
  (s/with-gen
    (s/and string? #(<= 1 (count %) 2))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 2 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/UpdateBusinessReportScheduleRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/ScheduleArn]
    :opt-un
    [:cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/Recurrence
     :cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/S3BucketName
     :cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/Format
     :cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/S3KeyPrefix
     :cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/ScheduleName]))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceDataList
  (s/coll-of :cognitect.aws.alexaforbusiness/DeviceData))

(s/def
  :cognitect.aws.alexaforbusiness/CreateContactResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.CreateContactResponse/ContactArn]))

(s/def :cognitect.aws.alexaforbusiness/AssociateContactWithAddressBookResponse (s/keys))

(s/def :cognitect.aws.alexaforbusiness/SkillStoreType string?)

(s/def
  :cognitect.aws.alexaforbusiness/BusinessReport
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.BusinessReport/DownloadUrl
     :cognitect.aws.alexaforbusiness.BusinessReport/Status
     :cognitect.aws.alexaforbusiness.BusinessReport/DeliveryTime
     :cognitect.aws.alexaforbusiness.BusinessReport/S3Location
     :cognitect.aws.alexaforbusiness.BusinessReport/FailureCode]))

(s/def
  :cognitect.aws.alexaforbusiness/Category
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.Category/CategoryId
     :cognitect.aws.alexaforbusiness.Category/CategoryName]))

(s/def :cognitect.aws.alexaforbusiness/IconUrl string?)

(s/def :cognitect.aws.alexaforbusiness/MacAddress string?)

(s/def
  :cognitect.aws.alexaforbusiness/DeviceStatusDetails
  (s/coll-of :cognitect.aws.alexaforbusiness/DeviceStatusDetail))

(s/def
  :cognitect.aws.alexaforbusiness/UserId
  (s/with-gen #(re-matches (re-pattern "amzn1\\.[A-Za-z0-9+-\\/=.]{1,300}") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/PutRoomSkillParameterRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.PutRoomSkillParameterRequest/SkillId
     :cognitect.aws.alexaforbusiness.PutRoomSkillParameterRequest/RoomSkillParameter]
    :opt-un
    [:cognitect.aws.alexaforbusiness.PutRoomSkillParameterRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/DeleteAddressBookRequest
  (s/keys :req-un [:cognitect.aws.alexaforbusiness.DeleteAddressBookRequest/AddressBookArn]))

(s/def
  :cognitect.aws.alexaforbusiness/CreateProfileResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.CreateProfileResponse/ProfileArn]))

(s/def :cognitect.aws.alexaforbusiness/DeviceEventValue string?)

(s/def
  :cognitect.aws.alexaforbusiness/RoomData
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.RoomData/ProviderCalendarId
     :cognitect.aws.alexaforbusiness.RoomData/Description
     :cognitect.aws.alexaforbusiness.RoomData/ProfileArn
     :cognitect.aws.alexaforbusiness.RoomData/RoomArn
     :cognitect.aws.alexaforbusiness.RoomData/RoomName
     :cognitect.aws.alexaforbusiness.RoomData/ProfileName]))

(s/def :cognitect.aws.alexaforbusiness/EndUserLicenseAgreement string?)

(s/def :cognitect.aws.alexaforbusiness/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/GetRoomSkillParameterRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.GetRoomSkillParameterRequest/SkillId
     :cognitect.aws.alexaforbusiness.GetRoomSkillParameterRequest/ParameterKey]
    :opt-un
    [:cognitect.aws.alexaforbusiness.GetRoomSkillParameterRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/GetProfileRequest
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetProfileRequest/ProfileArn]))

(s/def
  :cognitect.aws.alexaforbusiness/SkillGroupDataList
  (s/coll-of :cognitect.aws.alexaforbusiness/SkillGroupData))

(s/def
  :cognitect.aws.alexaforbusiness/ClientId
  (s/with-gen #(re-matches (re-pattern "^\\S+{1,256}$") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/DeleteUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.DeleteUserRequest/EnrollmentId]
    :opt-un
    [:cognitect.aws.alexaforbusiness.DeleteUserRequest/UserArn]))

(s/def
  :cognitect.aws.alexaforbusiness/ListSkillsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListSkillsResponse/SkillSummaries
     :cognitect.aws.alexaforbusiness.ListSkillsResponse/NextToken]))

(s/def
  :cognitect.aws.alexaforbusiness/FilterList
  (s/coll-of :cognitect.aws.alexaforbusiness/Filter :max-count 25))

(s/def :cognitect.aws.alexaforbusiness/SendInvitationResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/CreateProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.CreateProfileRequest/ProfileName
     :cognitect.aws.alexaforbusiness.CreateProfileRequest/Timezone
     :cognitect.aws.alexaforbusiness.CreateProfileRequest/Address
     :cognitect.aws.alexaforbusiness.CreateProfileRequest/DistanceUnit
     :cognitect.aws.alexaforbusiness.CreateProfileRequest/TemperatureUnit
     :cognitect.aws.alexaforbusiness.CreateProfileRequest/WakeWord]
    :opt-un
    [:cognitect.aws.alexaforbusiness.CreateProfileRequest/ClientRequestToken
     :cognitect.aws.alexaforbusiness.CreateProfileRequest/SetupModeDisabled
     :cognitect.aws.alexaforbusiness.CreateProfileRequest/PSTNEnabled
     :cognitect.aws.alexaforbusiness.CreateProfileRequest/MaxVolumeLimit]))

(s/def
  :cognitect.aws.alexaforbusiness/UpdateDeviceRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.UpdateDeviceRequest/DeviceArn
     :cognitect.aws.alexaforbusiness.UpdateDeviceRequest/DeviceName]))

(s/def :cognitect.aws.alexaforbusiness/ReviewValue string?)

(s/def
  :cognitect.aws.alexaforbusiness/CreateUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.CreateUserRequest/UserId]
    :opt-un
    [:cognitect.aws.alexaforbusiness.CreateUserRequest/ClientRequestToken
     :cognitect.aws.alexaforbusiness.CreateUserRequest/Email
     :cognitect.aws.alexaforbusiness.CreateUserRequest/Tags
     :cognitect.aws.alexaforbusiness.CreateUserRequest/LastName
     :cognitect.aws.alexaforbusiness.CreateUserRequest/FirstName]))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceEvent
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.DeviceEvent/Type
     :cognitect.aws.alexaforbusiness.DeviceEvent/Value
     :cognitect.aws.alexaforbusiness.DeviceEvent/Timestamp]))

(s/def
  :cognitect.aws.alexaforbusiness/DeleteConferenceProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.DeleteConferenceProviderRequest/ConferenceProviderArn]))

(s/def
  :cognitect.aws.alexaforbusiness/Timezone
  (s/with-gen
    (s/and string? #(<= 1 (count %) 100))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 100 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/BusinessReportRecurrence
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.BusinessReportRecurrence/StartDate]))

(s/def :cognitect.aws.alexaforbusiness/CategoryName string?)

(s/def :cognitect.aws.alexaforbusiness/DeleteUserResponse (s/keys))

(s/def :cognitect.aws.alexaforbusiness/DeleteAddressBookResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/RoomDescription
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/user_LastName
  (s/with-gen #(re-matches (re-pattern "([A-Za-z\\-' 0-9._]|\\p{IsLetter})*") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/ListConferenceProvidersRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListConferenceProvidersRequest/NextToken
     :cognitect.aws.alexaforbusiness.ListConferenceProvidersRequest/MaxResults]))

(s/def :cognitect.aws.alexaforbusiness/ReleaseDate string?)

(s/def
  :cognitect.aws.alexaforbusiness/E164PhoneNumber
  (s/with-gen #(re-matches (re-pattern "^\\+\\d{8,}$") %) #(gen/string)))

(s/def :cognitect.aws.alexaforbusiness/ApproveSkillResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/user_FirstName
  (s/with-gen #(re-matches (re-pattern "([A-Za-z\\-' 0-9._]|\\p{IsLetter})*") %) #(gen/string)))

(s/def :cognitect.aws.alexaforbusiness/DeleteProfileResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/SortList
  (s/coll-of :cognitect.aws.alexaforbusiness/Sort :max-count 25))

(s/def :cognitect.aws.alexaforbusiness/DeleteContactResponse (s/keys))

(s/def :cognitect.aws.alexaforbusiness/DeveloperName string?)

(s/def
  :cognitect.aws.alexaforbusiness/GetDeviceRequest
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetDeviceRequest/DeviceArn]))

(s/def
  :cognitect.aws.alexaforbusiness/Date
  (s/with-gen
    #(re-matches (re-pattern "^\\d{4}\\-(0?[1-9]|1[012])\\-(0?[1-9]|[12][0-9]|3[01])$") %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/GetConferenceProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.GetConferenceProviderRequest/ConferenceProviderArn]))

(s/def
  :cognitect.aws.alexaforbusiness/ProfileData
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ProfileData/Address
     :cognitect.aws.alexaforbusiness.ProfileData/WakeWord
     :cognitect.aws.alexaforbusiness.ProfileData/Timezone
     :cognitect.aws.alexaforbusiness.ProfileData/ProfileArn
     :cognitect.aws.alexaforbusiness.ProfileData/TemperatureUnit
     :cognitect.aws.alexaforbusiness.ProfileData/DistanceUnit
     :cognitect.aws.alexaforbusiness.ProfileData/IsDefault
     :cognitect.aws.alexaforbusiness.ProfileData/ProfileName]))

(s/def :cognitect.aws.alexaforbusiness/DeleteDeviceResponse (s/keys))

(s/def :cognitect.aws.alexaforbusiness/DisassociateSkillGroupFromRoomResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/SmartHomeApplianceList
  (s/coll-of :cognitect.aws.alexaforbusiness/SmartHomeAppliance))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceStatusInfo
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.DeviceStatusInfo/DeviceStatusDetails
     :cognitect.aws.alexaforbusiness.DeviceStatusInfo/ConnectionStatus]))

(s/def
  :cognitect.aws.alexaforbusiness/SkillsStoreSkillList
  (s/coll-of :cognitect.aws.alexaforbusiness/SkillsStoreSkill))

(s/def
  :cognitect.aws.alexaforbusiness/Arn
  (s/with-gen
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/ListDeviceEventsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListDeviceEventsResponse/NextToken
     :cognitect.aws.alexaforbusiness.ListDeviceEventsResponse/DeviceEvents]))

(s/def
  :cognitect.aws.alexaforbusiness/AddressBookData
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.AddressBookData/Description
     :cognitect.aws.alexaforbusiness.AddressBookData/AddressBookArn
     :cognitect.aws.alexaforbusiness.AddressBookData/Name]))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceStatusDetail
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.DeviceStatusDetail/Code]))

(s/def
  :cognitect.aws.alexaforbusiness/GetAddressBookRequest
  (s/keys :req-un [:cognitect.aws.alexaforbusiness.GetAddressBookRequest/AddressBookArn]))

(s/def
  :cognitect.aws.alexaforbusiness/RejectSkillRequest
  (s/keys :req-un [:cognitect.aws.alexaforbusiness.RejectSkillRequest/SkillId]))

(s/def
  :cognitect.aws.alexaforbusiness/Reviews
  (s/map-of :cognitect.aws.alexaforbusiness/ReviewKey :cognitect.aws.alexaforbusiness/ReviewValue))

(s/def
  :cognitect.aws.alexaforbusiness/PutConferencePreferenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.PutConferencePreferenceRequest/ConferencePreference]))

(s/def
  :cognitect.aws.alexaforbusiness/StartDeviceSyncRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.StartDeviceSyncRequest/Features]
    :opt-un
    [:cognitect.aws.alexaforbusiness.StartDeviceSyncRequest/DeviceArn
     :cognitect.aws.alexaforbusiness.StartDeviceSyncRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/PutSkillAuthorizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.PutSkillAuthorizationRequest/AuthorizationResult
     :cognitect.aws.alexaforbusiness.PutSkillAuthorizationRequest/SkillId]
    :opt-un
    [:cognitect.aws.alexaforbusiness.PutSkillAuthorizationRequest/RoomArn]))

(s/def :cognitect.aws.alexaforbusiness/PutConferencePreferenceResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/ProfileName
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/Value
  (s/with-gen
    (s/and string? #(<= 1 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or nil 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/SkillDetails
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SkillDetails/GenericKeywords
     :cognitect.aws.alexaforbusiness.SkillDetails/ReleaseDate
     :cognitect.aws.alexaforbusiness.SkillDetails/ProductDescription
     :cognitect.aws.alexaforbusiness.SkillDetails/DeveloperInfo
     :cognitect.aws.alexaforbusiness.SkillDetails/Reviews
     :cognitect.aws.alexaforbusiness.SkillDetails/BulletPoints
     :cognitect.aws.alexaforbusiness.SkillDetails/SkillTypes
     :cognitect.aws.alexaforbusiness.SkillDetails/NewInThisVersionBulletPoints
     :cognitect.aws.alexaforbusiness.SkillDetails/EndUserLicenseAgreement
     :cognitect.aws.alexaforbusiness.SkillDetails/InvocationPhrase]))

(s/def
  :cognitect.aws.alexaforbusiness/BusinessReportFailureCode
  #{"NO_SUCH_BUCKET" "INTERNAL_FAILURE" "ACCESS_DENIED"})

(s/def :cognitect.aws.alexaforbusiness/SkillTypeFilter #{"PRIVATE" "PUBLIC" "ALL"})

(s/def :cognitect.aws.alexaforbusiness/RevokeInvitationResponse (s/keys))

(s/def :cognitect.aws.alexaforbusiness/AssociateSkillGroupWithRoomResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/MaxResults
  (s/with-gen (s/and int? #(<= 1 % 50)) #(gen/choose (or 1 Long/MIN_VALUE) (or 50 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.alexaforbusiness/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.UntagResourceRequest/Arn
     :cognitect.aws.alexaforbusiness.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.alexaforbusiness/TagKey
  (s/with-gen #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) #(gen/string)))

(s/def :cognitect.aws.alexaforbusiness/WakeWord #{"COMPUTER" "ECHO" "ALEXA" "AMAZON"})

(s/def :cognitect.aws.alexaforbusiness/StartDeviceSyncResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/RoomSkillParameterKey
  (s/with-gen
    (s/and string? #(<= 1 (count %) 256))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 256 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.alexaforbusiness/ShortDescription string?)

(s/def
  :cognitect.aws.alexaforbusiness/UserCode
  (s/with-gen
    (s/and string? #(<= 1 (count %) 128))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 128 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/CreateAddressBookRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.CreateAddressBookRequest/Name]
    :opt-un
    [:cognitect.aws.alexaforbusiness.CreateAddressBookRequest/ClientRequestToken
     :cognitect.aws.alexaforbusiness.CreateAddressBookRequest/Description]))

(s/def
  :cognitect.aws.alexaforbusiness/SearchRoomsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchRoomsRequest/NextToken
     :cognitect.aws.alexaforbusiness.SearchRoomsRequest/Filters
     :cognitect.aws.alexaforbusiness.SearchRoomsRequest/MaxResults
     :cognitect.aws.alexaforbusiness.SearchRoomsRequest/SortCriteria]))

(s/def :cognitect.aws.alexaforbusiness/BulletPoint string?)

(s/def
  :cognitect.aws.alexaforbusiness/GetProfileResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetProfileResponse/Profile]))

(s/def :cognitect.aws.alexaforbusiness/DeleteSkillGroupResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/SearchUsersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchUsersResponse/NextToken
     :cognitect.aws.alexaforbusiness.SearchUsersResponse/TotalCount
     :cognitect.aws.alexaforbusiness.SearchUsersResponse/Users]))

(s/def
  :cognitect.aws.alexaforbusiness/DeleteDeviceRequest
  (s/keys :req-un [:cognitect.aws.alexaforbusiness.DeleteDeviceRequest/DeviceArn]))

(s/def
  :cognitect.aws.alexaforbusiness/RegisterAVSDeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.RegisterAVSDeviceRequest/ClientId
     :cognitect.aws.alexaforbusiness.RegisterAVSDeviceRequest/UserCode
     :cognitect.aws.alexaforbusiness.RegisterAVSDeviceRequest/ProductId
     :cognitect.aws.alexaforbusiness.RegisterAVSDeviceRequest/DeviceSerialNumber
     :cognitect.aws.alexaforbusiness.RegisterAVSDeviceRequest/AmazonId]))

(s/def
  :cognitect.aws.alexaforbusiness/ListSkillsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListSkillsRequest/NextToken
     :cognitect.aws.alexaforbusiness.ListSkillsRequest/SkillGroupArn
     :cognitect.aws.alexaforbusiness.ListSkillsRequest/MaxResults
     :cognitect.aws.alexaforbusiness.ListSkillsRequest/EnablementType
     :cognitect.aws.alexaforbusiness.ListSkillsRequest/SkillType]))

(s/def
  :cognitect.aws.alexaforbusiness/CreateSkillGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.CreateSkillGroupRequest/SkillGroupName]
    :opt-un
    [:cognitect.aws.alexaforbusiness.CreateSkillGroupRequest/ClientRequestToken
     :cognitect.aws.alexaforbusiness.CreateSkillGroupRequest/Description]))

(s/def :cognitect.aws.alexaforbusiness/TemperatureUnit #{"CELSIUS" "FAHRENHEIT"})

(s/def :cognitect.aws.alexaforbusiness/UpdateContactResponse (s/keys))

(s/def :cognitect.aws.alexaforbusiness/Timestamp inst?)

(s/def :cognitect.aws.alexaforbusiness/RequirePin #{"OPTIONAL" "NO" "YES"})

(s/def
  :cognitect.aws.alexaforbusiness/DeleteRoomSkillParameterRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.DeleteRoomSkillParameterRequest/SkillId
     :cognitect.aws.alexaforbusiness.DeleteRoomSkillParameterRequest/ParameterKey]
    :opt-un
    [:cognitect.aws.alexaforbusiness.DeleteRoomSkillParameterRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/CreateAddressBookResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.CreateAddressBookResponse/AddressBookArn]))

(s/def
  :cognitect.aws.alexaforbusiness/UpdateAddressBookRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.UpdateAddressBookRequest/AddressBookArn]
    :opt-un
    [:cognitect.aws.alexaforbusiness.UpdateAddressBookRequest/Description
     :cognitect.aws.alexaforbusiness.UpdateAddressBookRequest/Name]))

(s/def
  :cognitect.aws.alexaforbusiness/ApproveSkillRequest
  (s/keys :req-un [:cognitect.aws.alexaforbusiness.ApproveSkillRequest/SkillId]))

(s/def
  :cognitect.aws.alexaforbusiness/DeleteProfileRequest
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.DeleteProfileRequest/ProfileArn]))

(s/def
  :cognitect.aws.alexaforbusiness/BusinessReportContentRange
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.BusinessReportContentRange/Interval]))

(s/def
  :cognitect.aws.alexaforbusiness/RoomSkillParameter
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.RoomSkillParameter/ParameterKey
     :cognitect.aws.alexaforbusiness.RoomSkillParameter/ParameterValue]))

(s/def
  :cognitect.aws.alexaforbusiness/SearchContactsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchContactsResponse/Contacts
     :cognitect.aws.alexaforbusiness.SearchContactsResponse/NextToken
     :cognitect.aws.alexaforbusiness.SearchContactsResponse/TotalCount]))

(s/def
  :cognitect.aws.alexaforbusiness/GetContactRequest
  (s/keys :req-un [:cognitect.aws.alexaforbusiness.GetContactRequest/ContactArn]))

(s/def
  :cognitect.aws.alexaforbusiness/SearchAddressBooksResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchAddressBooksResponse/AddressBooks
     :cognitect.aws.alexaforbusiness.SearchAddressBooksResponse/NextToken
     :cognitect.aws.alexaforbusiness.SearchAddressBooksResponse/TotalCount]))

(s/def
  :cognitect.aws.alexaforbusiness/CreateRoomResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.CreateRoomResponse/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/BusinessReportScheduleName
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/MeetingSetting
  (s/keys :req-un [:cognitect.aws.alexaforbusiness.MeetingSetting/RequirePin]))

(s/def :cognitect.aws.alexaforbusiness/InvocationPhrase string?)

(s/def :cognitect.aws.alexaforbusiness/ReviewKey string?)

(s/def
  :cognitect.aws.alexaforbusiness/SearchProfilesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchProfilesResponse/NextToken
     :cognitect.aws.alexaforbusiness.SearchProfilesResponse/TotalCount
     :cognitect.aws.alexaforbusiness.SearchProfilesResponse/Profiles]))

(s/def :cognitect.aws.alexaforbusiness/BusinessReportStatus #{"SUCCEEDED" "FAILED" "RUNNING"})

(s/def
  :cognitect.aws.alexaforbusiness/BusinessReportS3Location
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.BusinessReportS3Location/Path
     :cognitect.aws.alexaforbusiness.BusinessReportS3Location/BucketName]))

(s/def :cognitect.aws.alexaforbusiness/UpdateProfileResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceStatus
  #{"READY" "PENDING" "WAS_OFFLINE" "DEREGISTERED"})

(s/def :cognitect.aws.alexaforbusiness/SoftwareVersion string?)

(s/def :cognitect.aws.alexaforbusiness/BusinessReportDownloadUrl string?)

(s/def
  :cognitect.aws.alexaforbusiness/SkillName
  (s/with-gen
    #(re-matches
      (re-pattern
        "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/SkillTypes
  (s/coll-of :cognitect.aws.alexaforbusiness/SkillStoreType))

(s/def :cognitect.aws.alexaforbusiness/ConnectionStatus #{"OFFLINE" "ONLINE"})

(s/def
  :cognitect.aws.alexaforbusiness/CustomerS3BucketName
  (s/with-gen #(re-matches (re-pattern "[a-z0-9-\\.]{3,63}") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/AmazonId
  (s/with-gen #(re-matches (re-pattern "[a-zA-Z0-9]{1,18}") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/ResolveRoomRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.ResolveRoomRequest/UserId
     :cognitect.aws.alexaforbusiness.ResolveRoomRequest/SkillId]))

(s/def
  :cognitect.aws.alexaforbusiness/Device
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.Device/DeviceSerialNumber
     :cognitect.aws.alexaforbusiness.Device/SoftwareVersion
     :cognitect.aws.alexaforbusiness.Device/DeviceStatusInfo
     :cognitect.aws.alexaforbusiness.Device/MacAddress
     :cognitect.aws.alexaforbusiness.Device/DeviceArn
     :cognitect.aws.alexaforbusiness.Device/DeviceType
     :cognitect.aws.alexaforbusiness.Device/DeviceStatus
     :cognitect.aws.alexaforbusiness.Device/DeviceName
     :cognitect.aws.alexaforbusiness.Device/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/CreateConferenceProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/ConferenceProviderName
     :cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/ConferenceProviderType
     :cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/MeetingSetting]
    :opt-un
    [:cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/IPDialIn
     :cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/ClientRequestToken
     :cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/PSTNDialIn]))

(s/def
  :cognitect.aws.alexaforbusiness/UpdateRoomRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.UpdateRoomRequest/ProviderCalendarId
     :cognitect.aws.alexaforbusiness.UpdateRoomRequest/Description
     :cognitect.aws.alexaforbusiness.UpdateRoomRequest/ProfileArn
     :cognitect.aws.alexaforbusiness.UpdateRoomRequest/RoomArn
     :cognitect.aws.alexaforbusiness.UpdateRoomRequest/RoomName]))

(s/def
  :cognitect.aws.alexaforbusiness/RegisterAVSDeviceResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.RegisterAVSDeviceResponse/DeviceArn]))

(s/def
  :cognitect.aws.alexaforbusiness/GetRoomRequest
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetRoomRequest/RoomArn]))

(s/def :cognitect.aws.alexaforbusiness/Features (s/coll-of :cognitect.aws.alexaforbusiness/Feature))

(s/def
  :cognitect.aws.alexaforbusiness/NewInThisVersionBulletPoints
  (s/coll-of :cognitect.aws.alexaforbusiness/BulletPoint))

(s/def
  :cognitect.aws.alexaforbusiness/ListConferenceProvidersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListConferenceProvidersResponse/NextToken
     :cognitect.aws.alexaforbusiness.ListConferenceProvidersResponse/ConferenceProviders]))

(s/def
  :cognitect.aws.alexaforbusiness/SearchDevicesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchDevicesResponse/NextToken
     :cognitect.aws.alexaforbusiness.SearchDevicesResponse/TotalCount
     :cognitect.aws.alexaforbusiness.SearchDevicesResponse/Devices]))

(s/def :cognitect.aws.alexaforbusiness/UpdateConferenceProviderResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/ListSmartHomeAppliancesRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.ListSmartHomeAppliancesRequest/RoomArn]
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListSmartHomeAppliancesRequest/NextToken
     :cognitect.aws.alexaforbusiness.ListSmartHomeAppliancesRequest/MaxResults]))

(s/def :cognitect.aws.alexaforbusiness/boolean boolean?)

(s/def
  :cognitect.aws.alexaforbusiness/SkillGroup
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SkillGroup/SkillGroupName
     :cognitect.aws.alexaforbusiness.SkillGroup/SkillGroupArn
     :cognitect.aws.alexaforbusiness.SkillGroup/Description]))

(s/def
  :cognitect.aws.alexaforbusiness/FilterValue
  (s/with-gen
    (s/and string? #(<= 1 (count %) 500))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 500 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.alexaforbusiness/MaxVolumeLimit
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.alexaforbusiness/GetContactResponse
  (s/keys :opt-un [:cognitect.aws.alexaforbusiness.GetContactResponse/Contact]))

(s/def
  :cognitect.aws.alexaforbusiness/SearchContactsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchContactsRequest/NextToken
     :cognitect.aws.alexaforbusiness.SearchContactsRequest/Filters
     :cognitect.aws.alexaforbusiness.SearchContactsRequest/MaxResults
     :cognitect.aws.alexaforbusiness.SearchContactsRequest/SortCriteria]))

(s/def :cognitect.aws.alexaforbusiness/StartSmartHomeApplianceDiscoveryResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/ListSkillsStoreSkillsByCategoryResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.ListSkillsStoreSkillsByCategoryResponse/SkillsStoreSkills
     :cognitect.aws.alexaforbusiness.ListSkillsStoreSkillsByCategoryResponse/NextToken]))

(s/def
  :cognitect.aws.alexaforbusiness/S3KeyPrefix
  (s/with-gen #(re-matches (re-pattern "[A-Za-z0-9!_\\-\\.\\*'()/]*") %) #(gen/string)))

(s/def
  :cognitect.aws.alexaforbusiness/TotalCount
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def :cognitect.aws.alexaforbusiness/DeleteConferenceProviderResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/CreateConferenceProviderResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.CreateConferenceProviderResponse/ConferenceProviderArn]))

(s/def :cognitect.aws.alexaforbusiness/DisassociateContactFromAddressBookResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/AddressBook
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.AddressBook/Description
     :cognitect.aws.alexaforbusiness.AddressBook/AddressBookArn
     :cognitect.aws.alexaforbusiness.AddressBook/Name]))

(s/def :cognitect.aws.alexaforbusiness/ApplianceDescription string?)

(s/def
  :cognitect.aws.alexaforbusiness/SearchRoomsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SearchRoomsResponse/NextToken
     :cognitect.aws.alexaforbusiness.SearchRoomsResponse/TotalCount
     :cognitect.aws.alexaforbusiness.SearchRoomsResponse/Rooms]))

(s/def
  :cognitect.aws.alexaforbusiness/ProfileDataList
  (s/coll-of :cognitect.aws.alexaforbusiness/ProfileData))

(s/def
  :cognitect.aws.alexaforbusiness/SkillListMaxResults
  (s/with-gen (s/and int? #(<= 1 % 10)) #(gen/choose (or 1 Long/MIN_VALUE) (or 10 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.alexaforbusiness/Contact
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.Contact/ContactArn
     :cognitect.aws.alexaforbusiness.Contact/DisplayName
     :cognitect.aws.alexaforbusiness.Contact/LastName
     :cognitect.aws.alexaforbusiness.Contact/FirstName
     :cognitect.aws.alexaforbusiness.Contact/PhoneNumber]))

(s/def
  :cognitect.aws.alexaforbusiness/UpdateContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.alexaforbusiness.UpdateContactRequest/ContactArn]
    :opt-un
    [:cognitect.aws.alexaforbusiness.UpdateContactRequest/DisplayName
     :cognitect.aws.alexaforbusiness.UpdateContactRequest/LastName
     :cognitect.aws.alexaforbusiness.UpdateContactRequest/FirstName
     :cognitect.aws.alexaforbusiness.UpdateContactRequest/PhoneNumber]))

(s/def
  :cognitect.aws.alexaforbusiness/CategoryId
  (s/with-gen (s/and int? #(<= 1 %)) #(gen/choose (or 1 Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.alexaforbusiness/DisassociateSkillGroupFromRoomRequest
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.DisassociateSkillGroupFromRoomRequest/SkillGroupArn
     :cognitect.aws.alexaforbusiness.DisassociateSkillGroupFromRoomRequest/RoomArn]))

(s/def
  :cognitect.aws.alexaforbusiness/OutboundPhoneNumber
  (s/with-gen #(re-matches (re-pattern "\\d{10}") %) #(gen/string)))

(s/def :cognitect.aws.alexaforbusiness/UpdateBusinessReportScheduleResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/TagKeyList
  (s/coll-of :cognitect.aws.alexaforbusiness/TagKey))

(s/def :cognitect.aws.alexaforbusiness/AssociateDeviceWithRoomResponse (s/keys))

(s/def
  :cognitect.aws.alexaforbusiness/SkillGroupData
  (s/keys
    :opt-un
    [:cognitect.aws.alexaforbusiness.SkillGroupData/SkillGroupName
     :cognitect.aws.alexaforbusiness.SkillGroupData/SkillGroupArn
     :cognitect.aws.alexaforbusiness.SkillGroupData/Description]))

(s/def
  :cognitect.aws.alexaforbusiness/DeviceSerialNumberForAVS
  (s/with-gen #(re-matches (re-pattern "^[a-zA-Z0-9]{1,50}$") %) #(gen/string)))

(s/def :cognitect.aws.alexaforbusiness/DeviceEventType #{"DEVICE_STATUS" "CONNECTION_STATUS"})

(s/def :cognitect.aws.alexaforbusiness/GetConferencePreferenceRequest (s/keys))

(s/def :cognitect.aws.alexaforbusiness/PrivacyPolicy string?)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteContactRequest/ContactArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.ListBusinessReportSchedulesResponse/BusinessReportSchedules
  :cognitect.aws.alexaforbusiness/BusinessReportScheduleList)

(s/def
  :cognitect.aws.alexaforbusiness.ListBusinessReportSchedulesResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListDeviceEventsRequest/DeviceArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.ListDeviceEventsRequest/EventType
  :cognitect.aws.alexaforbusiness/DeviceEventType)

(s/def
  :cognitect.aws.alexaforbusiness.ListDeviceEventsRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListDeviceEventsRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.GetConferenceProviderResponse/ConferenceProvider
  :cognitect.aws.alexaforbusiness/ConferenceProvider)

(s/def
  :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/ScheduleName
  :cognitect.aws.alexaforbusiness/BusinessReportScheduleName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/S3BucketName
  :cognitect.aws.alexaforbusiness/CustomerS3BucketName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/S3KeyPrefix
  :cognitect.aws.alexaforbusiness/S3KeyPrefix)

(s/def
  :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/Format
  :cognitect.aws.alexaforbusiness/BusinessReportFormat)

(s/def
  :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/ContentRange
  :cognitect.aws.alexaforbusiness/BusinessReportContentRange)

(s/def
  :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/Recurrence
  :cognitect.aws.alexaforbusiness/BusinessReportRecurrence)

(s/def
  :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleRequest/ClientRequestToken
  :cognitect.aws.alexaforbusiness/ClientRequestToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsStoreCategoriesRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsStoreCategoriesRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def :cognitect.aws.alexaforbusiness.ContactData/ContactArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.ContactData/DisplayName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.ContactData/FirstName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.ContactData/LastName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.ContactData/PhoneNumber
  :cognitect.aws.alexaforbusiness/E164PhoneNumber)

(s/def
  :cognitect.aws.alexaforbusiness.SearchProfilesRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchProfilesRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.SearchProfilesRequest/Filters
  :cognitect.aws.alexaforbusiness/FilterList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchProfilesRequest/SortCriteria
  :cognitect.aws.alexaforbusiness/SortList)

(s/def :cognitect.aws.alexaforbusiness.TagResourceRequest/Arn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.TagResourceRequest/Tags
  :cognitect.aws.alexaforbusiness/TagList)

(s/def :cognitect.aws.alexaforbusiness.GetRoomResponse/Room :cognitect.aws.alexaforbusiness/Room)

(s/def :cognitect.aws.alexaforbusiness.ListTagsRequest/Arn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.ListTagsRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListTagsRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.GetRoomSkillParameterResponse/RoomSkillParameter
  :cognitect.aws.alexaforbusiness/RoomSkillParameter)

(s/def
  :cognitect.aws.alexaforbusiness.CreateUserResponse/UserArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportSchedule/ScheduleArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportSchedule/ScheduleName
  :cognitect.aws.alexaforbusiness/BusinessReportScheduleName)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportSchedule/S3BucketName
  :cognitect.aws.alexaforbusiness/CustomerS3BucketName)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportSchedule/S3KeyPrefix
  :cognitect.aws.alexaforbusiness/S3KeyPrefix)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportSchedule/Format
  :cognitect.aws.alexaforbusiness/BusinessReportFormat)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportSchedule/ContentRange
  :cognitect.aws.alexaforbusiness/BusinessReportContentRange)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportSchedule/Recurrence
  :cognitect.aws.alexaforbusiness/BusinessReportRecurrence)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportSchedule/LastBusinessReport
  :cognitect.aws.alexaforbusiness/BusinessReport)

(s/def :cognitect.aws.alexaforbusiness.Tag/Key :cognitect.aws.alexaforbusiness/TagKey)

(s/def :cognitect.aws.alexaforbusiness.Tag/Value :cognitect.aws.alexaforbusiness/TagValue)

(s/def
  :cognitect.aws.alexaforbusiness.DeveloperInfo/DeveloperName
  :cognitect.aws.alexaforbusiness/DeveloperName)

(s/def
  :cognitect.aws.alexaforbusiness.DeveloperInfo/PrivacyPolicy
  :cognitect.aws.alexaforbusiness/PrivacyPolicy)

(s/def :cognitect.aws.alexaforbusiness.DeveloperInfo/Email :cognitect.aws.alexaforbusiness/Email)

(s/def :cognitect.aws.alexaforbusiness.DeveloperInfo/Url :cognitect.aws.alexaforbusiness/Url)

(s/def
  :cognitect.aws.alexaforbusiness.ResolveRoomResponse/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.ResolveRoomResponse/RoomName
  :cognitect.aws.alexaforbusiness/RoomName)

(s/def
  :cognitect.aws.alexaforbusiness.ResolveRoomResponse/RoomSkillParameters
  :cognitect.aws.alexaforbusiness/RoomSkillParameters)

(s/def
  :cognitect.aws.alexaforbusiness.DisassociateSkillFromSkillGroupRequest/SkillGroupArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.DisassociateSkillFromSkillGroupRequest/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.SearchSkillGroupsResponse/SkillGroups
  :cognitect.aws.alexaforbusiness/SkillGroupDataList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchSkillGroupsResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchSkillGroupsResponse/TotalCount
  :cognitect.aws.alexaforbusiness/TotalCount)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteBusinessReportScheduleRequest/ScheduleArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.GetConferencePreferenceResponse/Preference
  :cognitect.aws.alexaforbusiness/ConferencePreference)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceData/DeviceType
  :cognitect.aws.alexaforbusiness/DeviceType)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceData/DeviceName
  :cognitect.aws.alexaforbusiness/DeviceName)

(s/def :cognitect.aws.alexaforbusiness.DeviceData/RoomName :cognitect.aws.alexaforbusiness/RoomName)

(s/def :cognitect.aws.alexaforbusiness.DeviceData/DeviceArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceData/DeviceSerialNumber
  :cognitect.aws.alexaforbusiness/DeviceSerialNumber)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceData/MacAddress
  :cognitect.aws.alexaforbusiness/MacAddress)

(s/def :cognitect.aws.alexaforbusiness.DeviceData/RoomArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceData/DeviceStatusInfo
  :cognitect.aws.alexaforbusiness/DeviceStatusInfo)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceData/DeviceStatus
  :cognitect.aws.alexaforbusiness/DeviceStatus)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceData/SoftwareVersion
  :cognitect.aws.alexaforbusiness/SoftwareVersion)

(s/def
  :cognitect.aws.alexaforbusiness.ForgetSmartHomeAppliancesRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateSkillGroupRequest/SkillGroupArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateSkillGroupRequest/SkillGroupName
  :cognitect.aws.alexaforbusiness/SkillGroupName)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateSkillGroupRequest/Description
  :cognitect.aws.alexaforbusiness/SkillGroupDescription)

(s/def :cognitect.aws.alexaforbusiness.Filter/Key :cognitect.aws.alexaforbusiness/FilterKey)

(s/def
  :cognitect.aws.alexaforbusiness.Filter/Values
  :cognitect.aws.alexaforbusiness/FilterValueList)

(s/def
  :cognitect.aws.alexaforbusiness.StartSmartHomeApplianceDiscoveryRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.SkillsStoreSkill/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.SkillsStoreSkill/SkillName
  :cognitect.aws.alexaforbusiness/SkillName)

(s/def
  :cognitect.aws.alexaforbusiness.SkillsStoreSkill/ShortDescription
  :cognitect.aws.alexaforbusiness/ShortDescription)

(s/def
  :cognitect.aws.alexaforbusiness.SkillsStoreSkill/IconUrl
  :cognitect.aws.alexaforbusiness/IconUrl)

(s/def
  :cognitect.aws.alexaforbusiness.SkillsStoreSkill/SampleUtterances
  :cognitect.aws.alexaforbusiness/SampleUtterances)

(s/def
  :cognitect.aws.alexaforbusiness.SkillsStoreSkill/SkillDetails
  :cognitect.aws.alexaforbusiness/SkillDetails)

(s/def
  :cognitect.aws.alexaforbusiness.SkillsStoreSkill/SupportsLinking
  :cognitect.aws.alexaforbusiness/boolean)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsStoreSkillsByCategoryRequest/CategoryId
  :cognitect.aws.alexaforbusiness/CategoryId)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsStoreSkillsByCategoryRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsStoreSkillsByCategoryRequest/MaxResults
  :cognitect.aws.alexaforbusiness/SkillListMaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.SearchUsersRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchUsersRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.SearchUsersRequest/Filters
  :cognitect.aws.alexaforbusiness/FilterList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchUsersRequest/SortCriteria
  :cognitect.aws.alexaforbusiness/SortList)

(s/def :cognitect.aws.alexaforbusiness.IPDialIn/Endpoint :cognitect.aws.alexaforbusiness/Endpoint)

(s/def
  :cognitect.aws.alexaforbusiness.IPDialIn/CommsProtocol
  :cognitect.aws.alexaforbusiness/CommsProtocol)

(s/def
  :cognitect.aws.alexaforbusiness.ListBusinessReportSchedulesRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListBusinessReportSchedulesRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.ConferencePreference/DefaultConferenceProviderArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.AssociateSkillGroupWithRoomRequest/SkillGroupArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.AssociateSkillGroupWithRoomRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.UserData/UserArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UserData/FirstName
  :cognitect.aws.alexaforbusiness/user_FirstName)

(s/def
  :cognitect.aws.alexaforbusiness.UserData/LastName
  :cognitect.aws.alexaforbusiness/user_LastName)

(s/def :cognitect.aws.alexaforbusiness.UserData/Email :cognitect.aws.alexaforbusiness/Email)

(s/def
  :cognitect.aws.alexaforbusiness.UserData/EnrollmentStatus
  :cognitect.aws.alexaforbusiness/EnrollmentStatus)

(s/def
  :cognitect.aws.alexaforbusiness.UserData/EnrollmentId
  :cognitect.aws.alexaforbusiness/EnrollmentId)

(s/def
  :cognitect.aws.alexaforbusiness.Profile/DistanceUnit
  :cognitect.aws.alexaforbusiness/DistanceUnit)

(s/def :cognitect.aws.alexaforbusiness.Profile/IsDefault :cognitect.aws.alexaforbusiness/Boolean)

(s/def :cognitect.aws.alexaforbusiness.Profile/AddressBookArn :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.Profile/Address :cognitect.aws.alexaforbusiness/Address)

(s/def :cognitect.aws.alexaforbusiness.Profile/Timezone :cognitect.aws.alexaforbusiness/Timezone)

(s/def
  :cognitect.aws.alexaforbusiness.Profile/ProfileName
  :cognitect.aws.alexaforbusiness/ProfileName)

(s/def
  :cognitect.aws.alexaforbusiness.Profile/SetupModeDisabled
  :cognitect.aws.alexaforbusiness/Boolean)

(s/def :cognitect.aws.alexaforbusiness.Profile/WakeWord :cognitect.aws.alexaforbusiness/WakeWord)

(s/def :cognitect.aws.alexaforbusiness.Profile/PSTNEnabled :cognitect.aws.alexaforbusiness/Boolean)

(s/def :cognitect.aws.alexaforbusiness.Profile/ProfileArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.Profile/TemperatureUnit
  :cognitect.aws.alexaforbusiness/TemperatureUnit)

(s/def
  :cognitect.aws.alexaforbusiness.Profile/MaxVolumeLimit
  :cognitect.aws.alexaforbusiness/MaxVolumeLimit)

(s/def
  :cognitect.aws.alexaforbusiness.CreateContactRequest/DisplayName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateContactRequest/FirstName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateContactRequest/LastName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateContactRequest/PhoneNumber
  :cognitect.aws.alexaforbusiness/E164PhoneNumber)

(s/def
  :cognitect.aws.alexaforbusiness.CreateContactRequest/ClientRequestToken
  :cognitect.aws.alexaforbusiness/ClientRequestToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsStoreCategoriesResponse/CategoryList
  :cognitect.aws.alexaforbusiness/CategoryList)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsStoreCategoriesResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchAddressBooksRequest/Filters
  :cognitect.aws.alexaforbusiness/FilterList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchAddressBooksRequest/SortCriteria
  :cognitect.aws.alexaforbusiness/SortList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchAddressBooksRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchAddressBooksRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteRoomRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateConferenceProviderRequest/ConferenceProviderArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateConferenceProviderRequest/ConferenceProviderType
  :cognitect.aws.alexaforbusiness/ConferenceProviderType)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateConferenceProviderRequest/IPDialIn
  :cognitect.aws.alexaforbusiness/IPDialIn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateConferenceProviderRequest/PSTNDialIn
  :cognitect.aws.alexaforbusiness/PSTNDialIn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateConferenceProviderRequest/MeetingSetting
  :cognitect.aws.alexaforbusiness/MeetingSetting)

(s/def
  :cognitect.aws.alexaforbusiness.DisassociateContactFromAddressBookRequest/ContactArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.DisassociateContactFromAddressBookRequest/AddressBookArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.Sort/Key :cognitect.aws.alexaforbusiness/SortKey)

(s/def :cognitect.aws.alexaforbusiness.Sort/Value :cognitect.aws.alexaforbusiness/SortValue)

(s/def
  :cognitect.aws.alexaforbusiness.GetAddressBookResponse/AddressBook
  :cognitect.aws.alexaforbusiness/AddressBook)

(s/def
  :cognitect.aws.alexaforbusiness.DisassociateDeviceFromRoomRequest/DeviceArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.ConferenceProvider/Arn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.ConferenceProvider/Name
  :cognitect.aws.alexaforbusiness/ConferenceProviderName)

(s/def
  :cognitect.aws.alexaforbusiness.ConferenceProvider/Type
  :cognitect.aws.alexaforbusiness/ConferenceProviderType)

(s/def
  :cognitect.aws.alexaforbusiness.ConferenceProvider/IPDialIn
  :cognitect.aws.alexaforbusiness/IPDialIn)

(s/def
  :cognitect.aws.alexaforbusiness.ConferenceProvider/PSTNDialIn
  :cognitect.aws.alexaforbusiness/PSTNDialIn)

(s/def
  :cognitect.aws.alexaforbusiness.ConferenceProvider/MeetingSetting
  :cognitect.aws.alexaforbusiness/MeetingSetting)

(s/def
  :cognitect.aws.alexaforbusiness.GetSkillGroupResponse/SkillGroup
  :cognitect.aws.alexaforbusiness/SkillGroup)

(s/def
  :cognitect.aws.alexaforbusiness.SendInvitationRequest/UserArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.Room/RoomArn :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.Room/RoomName :cognitect.aws.alexaforbusiness/RoomName)

(s/def
  :cognitect.aws.alexaforbusiness.Room/Description
  :cognitect.aws.alexaforbusiness/RoomDescription)

(s/def
  :cognitect.aws.alexaforbusiness.Room/ProviderCalendarId
  :cognitect.aws.alexaforbusiness/ProviderCalendarId)

(s/def :cognitect.aws.alexaforbusiness.Room/ProfileArn :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.SkillSummary/SkillId :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.SkillSummary/SkillName
  :cognitect.aws.alexaforbusiness/SkillName)

(s/def
  :cognitect.aws.alexaforbusiness.SkillSummary/SupportsLinking
  :cognitect.aws.alexaforbusiness/boolean)

(s/def
  :cognitect.aws.alexaforbusiness.SkillSummary/EnablementType
  :cognitect.aws.alexaforbusiness/EnablementType)

(s/def
  :cognitect.aws.alexaforbusiness.SkillSummary/SkillType
  :cognitect.aws.alexaforbusiness/SkillType)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteSkillAuthorizationRequest/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteSkillAuthorizationRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.GetDeviceResponse/Device
  :cognitect.aws.alexaforbusiness/Device)

(s/def
  :cognitect.aws.alexaforbusiness.AssociateContactWithAddressBookRequest/ContactArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.AssociateContactWithAddressBookRequest/AddressBookArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.CreateSkillGroupResponse/SkillGroupArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/DistanceUnit
  :cognitect.aws.alexaforbusiness/DistanceUnit)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/IsDefault
  :cognitect.aws.alexaforbusiness/Boolean)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/Address
  :cognitect.aws.alexaforbusiness/Address)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/Timezone
  :cognitect.aws.alexaforbusiness/Timezone)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/ProfileName
  :cognitect.aws.alexaforbusiness/ProfileName)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/SetupModeDisabled
  :cognitect.aws.alexaforbusiness/Boolean)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/WakeWord
  :cognitect.aws.alexaforbusiness/WakeWord)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/PSTNEnabled
  :cognitect.aws.alexaforbusiness/Boolean)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/ProfileArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/TemperatureUnit
  :cognitect.aws.alexaforbusiness/TemperatureUnit)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateProfileRequest/MaxVolumeLimit
  :cognitect.aws.alexaforbusiness/MaxVolumeLimit)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteSkillGroupRequest/SkillGroupArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.RevokeInvitationRequest/UserArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.RevokeInvitationRequest/EnrollmentId
  :cognitect.aws.alexaforbusiness/EnrollmentId)

(s/def
  :cognitect.aws.alexaforbusiness.PSTNDialIn/CountryCode
  :cognitect.aws.alexaforbusiness/CountryCode)

(s/def
  :cognitect.aws.alexaforbusiness.PSTNDialIn/PhoneNumber
  :cognitect.aws.alexaforbusiness/OutboundPhoneNumber)

(s/def
  :cognitect.aws.alexaforbusiness.PSTNDialIn/OneClickIdDelay
  :cognitect.aws.alexaforbusiness/OneClickIdDelay)

(s/def
  :cognitect.aws.alexaforbusiness.PSTNDialIn/OneClickPinDelay
  :cognitect.aws.alexaforbusiness/OneClickPinDelay)

(s/def
  :cognitect.aws.alexaforbusiness.SearchSkillGroupsRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchSkillGroupsRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.SearchSkillGroupsRequest/Filters
  :cognitect.aws.alexaforbusiness/FilterList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchSkillGroupsRequest/SortCriteria
  :cognitect.aws.alexaforbusiness/SortList)

(s/def
  :cognitect.aws.alexaforbusiness.CreateBusinessReportScheduleResponse/ScheduleArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.CreateRoomRequest/RoomName
  :cognitect.aws.alexaforbusiness/RoomName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateRoomRequest/Description
  :cognitect.aws.alexaforbusiness/RoomDescription)

(s/def
  :cognitect.aws.alexaforbusiness.CreateRoomRequest/ProfileArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.CreateRoomRequest/ProviderCalendarId
  :cognitect.aws.alexaforbusiness/ProviderCalendarId)

(s/def
  :cognitect.aws.alexaforbusiness.CreateRoomRequest/ClientRequestToken
  :cognitect.aws.alexaforbusiness/ClientRequestToken)

(s/def
  :cognitect.aws.alexaforbusiness.CreateRoomRequest/Tags
  :cognitect.aws.alexaforbusiness/TagList)

(s/def
  :cognitect.aws.alexaforbusiness.ListTagsResponse/Tags
  :cognitect.aws.alexaforbusiness/TagList)

(s/def
  :cognitect.aws.alexaforbusiness.ListTagsResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListSmartHomeAppliancesResponse/SmartHomeAppliances
  :cognitect.aws.alexaforbusiness/SmartHomeApplianceList)

(s/def
  :cognitect.aws.alexaforbusiness.ListSmartHomeAppliancesResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SmartHomeAppliance/FriendlyName
  :cognitect.aws.alexaforbusiness/ApplianceFriendlyName)

(s/def
  :cognitect.aws.alexaforbusiness.SmartHomeAppliance/Description
  :cognitect.aws.alexaforbusiness/ApplianceDescription)

(s/def
  :cognitect.aws.alexaforbusiness.SmartHomeAppliance/ManufacturerName
  :cognitect.aws.alexaforbusiness/ApplianceManufacturerName)

(s/def
  :cognitect.aws.alexaforbusiness.GetSkillGroupRequest/SkillGroupArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.AssociateDeviceWithRoomRequest/DeviceArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.AssociateDeviceWithRoomRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.AssociateSkillWithSkillGroupRequest/SkillGroupArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.AssociateSkillWithSkillGroupRequest/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.SearchDevicesRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchDevicesRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.SearchDevicesRequest/Filters
  :cognitect.aws.alexaforbusiness/FilterList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchDevicesRequest/SortCriteria
  :cognitect.aws.alexaforbusiness/SortList)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/ScheduleArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/S3BucketName
  :cognitect.aws.alexaforbusiness/CustomerS3BucketName)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/S3KeyPrefix
  :cognitect.aws.alexaforbusiness/S3KeyPrefix)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/Format
  :cognitect.aws.alexaforbusiness/BusinessReportFormat)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/ScheduleName
  :cognitect.aws.alexaforbusiness/BusinessReportScheduleName)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateBusinessReportScheduleRequest/Recurrence
  :cognitect.aws.alexaforbusiness/BusinessReportRecurrence)

(s/def
  :cognitect.aws.alexaforbusiness.CreateContactResponse/ContactArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReport/Status
  :cognitect.aws.alexaforbusiness/BusinessReportStatus)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReport/FailureCode
  :cognitect.aws.alexaforbusiness/BusinessReportFailureCode)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReport/S3Location
  :cognitect.aws.alexaforbusiness/BusinessReportS3Location)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReport/DeliveryTime
  :cognitect.aws.alexaforbusiness/Timestamp)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReport/DownloadUrl
  :cognitect.aws.alexaforbusiness/BusinessReportDownloadUrl)

(s/def
  :cognitect.aws.alexaforbusiness.Category/CategoryId
  :cognitect.aws.alexaforbusiness/CategoryId)

(s/def
  :cognitect.aws.alexaforbusiness.Category/CategoryName
  :cognitect.aws.alexaforbusiness/CategoryName)

(s/def
  :cognitect.aws.alexaforbusiness.PutRoomSkillParameterRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.PutRoomSkillParameterRequest/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.PutRoomSkillParameterRequest/RoomSkillParameter
  :cognitect.aws.alexaforbusiness/RoomSkillParameter)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteAddressBookRequest/AddressBookArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileResponse/ProfileArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.RoomData/RoomArn :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.RoomData/RoomName :cognitect.aws.alexaforbusiness/RoomName)

(s/def
  :cognitect.aws.alexaforbusiness.RoomData/Description
  :cognitect.aws.alexaforbusiness/RoomDescription)

(s/def
  :cognitect.aws.alexaforbusiness.RoomData/ProviderCalendarId
  :cognitect.aws.alexaforbusiness/ProviderCalendarId)

(s/def :cognitect.aws.alexaforbusiness.RoomData/ProfileArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.RoomData/ProfileName
  :cognitect.aws.alexaforbusiness/ProfileName)

(s/def
  :cognitect.aws.alexaforbusiness.GetRoomSkillParameterRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.GetRoomSkillParameterRequest/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.GetRoomSkillParameterRequest/ParameterKey
  :cognitect.aws.alexaforbusiness/RoomSkillParameterKey)

(s/def
  :cognitect.aws.alexaforbusiness.GetProfileRequest/ProfileArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteUserRequest/UserArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteUserRequest/EnrollmentId
  :cognitect.aws.alexaforbusiness/EnrollmentId)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsResponse/SkillSummaries
  :cognitect.aws.alexaforbusiness/SkillSummaryList)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileRequest/DistanceUnit
  :cognitect.aws.alexaforbusiness/DistanceUnit)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileRequest/Address
  :cognitect.aws.alexaforbusiness/Address)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileRequest/ClientRequestToken
  :cognitect.aws.alexaforbusiness/ClientRequestToken)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileRequest/Timezone
  :cognitect.aws.alexaforbusiness/Timezone)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileRequest/ProfileName
  :cognitect.aws.alexaforbusiness/ProfileName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileRequest/SetupModeDisabled
  :cognitect.aws.alexaforbusiness/Boolean)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileRequest/WakeWord
  :cognitect.aws.alexaforbusiness/WakeWord)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileRequest/PSTNEnabled
  :cognitect.aws.alexaforbusiness/Boolean)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileRequest/TemperatureUnit
  :cognitect.aws.alexaforbusiness/TemperatureUnit)

(s/def
  :cognitect.aws.alexaforbusiness.CreateProfileRequest/MaxVolumeLimit
  :cognitect.aws.alexaforbusiness/MaxVolumeLimit)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateDeviceRequest/DeviceArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateDeviceRequest/DeviceName
  :cognitect.aws.alexaforbusiness/DeviceName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateUserRequest/UserId
  :cognitect.aws.alexaforbusiness/user_UserId)

(s/def
  :cognitect.aws.alexaforbusiness.CreateUserRequest/FirstName
  :cognitect.aws.alexaforbusiness/user_FirstName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateUserRequest/LastName
  :cognitect.aws.alexaforbusiness/user_LastName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateUserRequest/Email
  :cognitect.aws.alexaforbusiness/Email)

(s/def
  :cognitect.aws.alexaforbusiness.CreateUserRequest/ClientRequestToken
  :cognitect.aws.alexaforbusiness/ClientRequestToken)

(s/def
  :cognitect.aws.alexaforbusiness.CreateUserRequest/Tags
  :cognitect.aws.alexaforbusiness/TagList)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceEvent/Type
  :cognitect.aws.alexaforbusiness/DeviceEventType)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceEvent/Value
  :cognitect.aws.alexaforbusiness/DeviceEventValue)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceEvent/Timestamp
  :cognitect.aws.alexaforbusiness/Timestamp)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteConferenceProviderRequest/ConferenceProviderArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportRecurrence/StartDate
  :cognitect.aws.alexaforbusiness/Date)

(s/def
  :cognitect.aws.alexaforbusiness.ListConferenceProvidersRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListConferenceProvidersRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.GetDeviceRequest/DeviceArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.GetConferenceProviderRequest/ConferenceProviderArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.ProfileData/ProfileArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.ProfileData/ProfileName
  :cognitect.aws.alexaforbusiness/ProfileName)

(s/def
  :cognitect.aws.alexaforbusiness.ProfileData/IsDefault
  :cognitect.aws.alexaforbusiness/Boolean)

(s/def :cognitect.aws.alexaforbusiness.ProfileData/Address :cognitect.aws.alexaforbusiness/Address)

(s/def
  :cognitect.aws.alexaforbusiness.ProfileData/Timezone
  :cognitect.aws.alexaforbusiness/Timezone)

(s/def
  :cognitect.aws.alexaforbusiness.ProfileData/DistanceUnit
  :cognitect.aws.alexaforbusiness/DistanceUnit)

(s/def
  :cognitect.aws.alexaforbusiness.ProfileData/TemperatureUnit
  :cognitect.aws.alexaforbusiness/TemperatureUnit)

(s/def
  :cognitect.aws.alexaforbusiness.ProfileData/WakeWord
  :cognitect.aws.alexaforbusiness/WakeWord)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceStatusInfo/DeviceStatusDetails
  :cognitect.aws.alexaforbusiness/DeviceStatusDetails)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceStatusInfo/ConnectionStatus
  :cognitect.aws.alexaforbusiness/ConnectionStatus)

(s/def
  :cognitect.aws.alexaforbusiness.ListDeviceEventsResponse/DeviceEvents
  :cognitect.aws.alexaforbusiness/DeviceEventList)

(s/def
  :cognitect.aws.alexaforbusiness.ListDeviceEventsResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.AddressBookData/AddressBookArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.AddressBookData/Name
  :cognitect.aws.alexaforbusiness/AddressBookName)

(s/def
  :cognitect.aws.alexaforbusiness.AddressBookData/Description
  :cognitect.aws.alexaforbusiness/AddressBookDescription)

(s/def
  :cognitect.aws.alexaforbusiness.DeviceStatusDetail/Code
  :cognitect.aws.alexaforbusiness/DeviceStatusDetailCode)

(s/def
  :cognitect.aws.alexaforbusiness.GetAddressBookRequest/AddressBookArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.RejectSkillRequest/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.PutConferencePreferenceRequest/ConferencePreference
  :cognitect.aws.alexaforbusiness/ConferencePreference)

(s/def
  :cognitect.aws.alexaforbusiness.StartDeviceSyncRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.StartDeviceSyncRequest/DeviceArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.StartDeviceSyncRequest/Features
  :cognitect.aws.alexaforbusiness/Features)

(s/def
  :cognitect.aws.alexaforbusiness.PutSkillAuthorizationRequest/AuthorizationResult
  :cognitect.aws.alexaforbusiness/AuthorizationResult)

(s/def
  :cognitect.aws.alexaforbusiness.PutSkillAuthorizationRequest/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.PutSkillAuthorizationRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.SkillDetails/DeveloperInfo
  :cognitect.aws.alexaforbusiness/DeveloperInfo)

(s/def
  :cognitect.aws.alexaforbusiness.SkillDetails/ProductDescription
  :cognitect.aws.alexaforbusiness/ProductDescription)

(s/def
  :cognitect.aws.alexaforbusiness.SkillDetails/BulletPoints
  :cognitect.aws.alexaforbusiness/BulletPoints)

(s/def
  :cognitect.aws.alexaforbusiness.SkillDetails/GenericKeywords
  :cognitect.aws.alexaforbusiness/GenericKeywords)

(s/def
  :cognitect.aws.alexaforbusiness.SkillDetails/EndUserLicenseAgreement
  :cognitect.aws.alexaforbusiness/EndUserLicenseAgreement)

(s/def
  :cognitect.aws.alexaforbusiness.SkillDetails/ReleaseDate
  :cognitect.aws.alexaforbusiness/ReleaseDate)

(s/def :cognitect.aws.alexaforbusiness.SkillDetails/Reviews :cognitect.aws.alexaforbusiness/Reviews)

(s/def
  :cognitect.aws.alexaforbusiness.SkillDetails/InvocationPhrase
  :cognitect.aws.alexaforbusiness/InvocationPhrase)

(s/def
  :cognitect.aws.alexaforbusiness.SkillDetails/SkillTypes
  :cognitect.aws.alexaforbusiness/SkillTypes)

(s/def
  :cognitect.aws.alexaforbusiness.SkillDetails/NewInThisVersionBulletPoints
  :cognitect.aws.alexaforbusiness/NewInThisVersionBulletPoints)

(s/def :cognitect.aws.alexaforbusiness.UntagResourceRequest/Arn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UntagResourceRequest/TagKeys
  :cognitect.aws.alexaforbusiness/TagKeyList)

(s/def
  :cognitect.aws.alexaforbusiness.CreateAddressBookRequest/Name
  :cognitect.aws.alexaforbusiness/AddressBookName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateAddressBookRequest/Description
  :cognitect.aws.alexaforbusiness/AddressBookDescription)

(s/def
  :cognitect.aws.alexaforbusiness.CreateAddressBookRequest/ClientRequestToken
  :cognitect.aws.alexaforbusiness/ClientRequestToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchRoomsRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchRoomsRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.SearchRoomsRequest/Filters
  :cognitect.aws.alexaforbusiness/FilterList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchRoomsRequest/SortCriteria
  :cognitect.aws.alexaforbusiness/SortList)

(s/def
  :cognitect.aws.alexaforbusiness.GetProfileResponse/Profile
  :cognitect.aws.alexaforbusiness/Profile)

(s/def
  :cognitect.aws.alexaforbusiness.SearchUsersResponse/Users
  :cognitect.aws.alexaforbusiness/UserDataList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchUsersResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchUsersResponse/TotalCount
  :cognitect.aws.alexaforbusiness/TotalCount)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteDeviceRequest/DeviceArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.RegisterAVSDeviceRequest/ClientId
  :cognitect.aws.alexaforbusiness/ClientId)

(s/def
  :cognitect.aws.alexaforbusiness.RegisterAVSDeviceRequest/UserCode
  :cognitect.aws.alexaforbusiness/UserCode)

(s/def
  :cognitect.aws.alexaforbusiness.RegisterAVSDeviceRequest/ProductId
  :cognitect.aws.alexaforbusiness/ProductId)

(s/def
  :cognitect.aws.alexaforbusiness.RegisterAVSDeviceRequest/DeviceSerialNumber
  :cognitect.aws.alexaforbusiness/DeviceSerialNumberForAVS)

(s/def
  :cognitect.aws.alexaforbusiness.RegisterAVSDeviceRequest/AmazonId
  :cognitect.aws.alexaforbusiness/AmazonId)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsRequest/SkillGroupArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsRequest/EnablementType
  :cognitect.aws.alexaforbusiness/EnablementTypeFilter)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsRequest/SkillType
  :cognitect.aws.alexaforbusiness/SkillTypeFilter)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsRequest/MaxResults
  :cognitect.aws.alexaforbusiness/SkillListMaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.CreateSkillGroupRequest/SkillGroupName
  :cognitect.aws.alexaforbusiness/SkillGroupName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateSkillGroupRequest/Description
  :cognitect.aws.alexaforbusiness/SkillGroupDescription)

(s/def
  :cognitect.aws.alexaforbusiness.CreateSkillGroupRequest/ClientRequestToken
  :cognitect.aws.alexaforbusiness/ClientRequestToken)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteRoomSkillParameterRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteRoomSkillParameterRequest/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteRoomSkillParameterRequest/ParameterKey
  :cognitect.aws.alexaforbusiness/RoomSkillParameterKey)

(s/def
  :cognitect.aws.alexaforbusiness.CreateAddressBookResponse/AddressBookArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateAddressBookRequest/AddressBookArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateAddressBookRequest/Name
  :cognitect.aws.alexaforbusiness/AddressBookName)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateAddressBookRequest/Description
  :cognitect.aws.alexaforbusiness/AddressBookDescription)

(s/def
  :cognitect.aws.alexaforbusiness.ApproveSkillRequest/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def
  :cognitect.aws.alexaforbusiness.DeleteProfileRequest/ProfileArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportContentRange/Interval
  :cognitect.aws.alexaforbusiness/BusinessReportInterval)

(s/def
  :cognitect.aws.alexaforbusiness.RoomSkillParameter/ParameterKey
  :cognitect.aws.alexaforbusiness/RoomSkillParameterKey)

(s/def
  :cognitect.aws.alexaforbusiness.RoomSkillParameter/ParameterValue
  :cognitect.aws.alexaforbusiness/RoomSkillParameterValue)

(s/def
  :cognitect.aws.alexaforbusiness.SearchContactsResponse/Contacts
  :cognitect.aws.alexaforbusiness/ContactDataList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchContactsResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchContactsResponse/TotalCount
  :cognitect.aws.alexaforbusiness/TotalCount)

(s/def
  :cognitect.aws.alexaforbusiness.GetContactRequest/ContactArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.SearchAddressBooksResponse/AddressBooks
  :cognitect.aws.alexaforbusiness/AddressBookDataList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchAddressBooksResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchAddressBooksResponse/TotalCount
  :cognitect.aws.alexaforbusiness/TotalCount)

(s/def
  :cognitect.aws.alexaforbusiness.CreateRoomResponse/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.MeetingSetting/RequirePin
  :cognitect.aws.alexaforbusiness/RequirePin)

(s/def
  :cognitect.aws.alexaforbusiness.SearchProfilesResponse/Profiles
  :cognitect.aws.alexaforbusiness/ProfileDataList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchProfilesResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchProfilesResponse/TotalCount
  :cognitect.aws.alexaforbusiness/TotalCount)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportS3Location/Path
  :cognitect.aws.alexaforbusiness/BusinessReportS3Path)

(s/def
  :cognitect.aws.alexaforbusiness.BusinessReportS3Location/BucketName
  :cognitect.aws.alexaforbusiness/CustomerS3BucketName)

(s/def
  :cognitect.aws.alexaforbusiness.ResolveRoomRequest/UserId
  :cognitect.aws.alexaforbusiness/UserId)

(s/def
  :cognitect.aws.alexaforbusiness.ResolveRoomRequest/SkillId
  :cognitect.aws.alexaforbusiness/SkillId)

(s/def :cognitect.aws.alexaforbusiness.Device/DeviceType :cognitect.aws.alexaforbusiness/DeviceType)

(s/def :cognitect.aws.alexaforbusiness.Device/DeviceName :cognitect.aws.alexaforbusiness/DeviceName)

(s/def :cognitect.aws.alexaforbusiness.Device/DeviceArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.Device/DeviceSerialNumber
  :cognitect.aws.alexaforbusiness/DeviceSerialNumber)

(s/def :cognitect.aws.alexaforbusiness.Device/MacAddress :cognitect.aws.alexaforbusiness/MacAddress)

(s/def :cognitect.aws.alexaforbusiness.Device/RoomArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.Device/DeviceStatusInfo
  :cognitect.aws.alexaforbusiness/DeviceStatusInfo)

(s/def
  :cognitect.aws.alexaforbusiness.Device/DeviceStatus
  :cognitect.aws.alexaforbusiness/DeviceStatus)

(s/def
  :cognitect.aws.alexaforbusiness.Device/SoftwareVersion
  :cognitect.aws.alexaforbusiness/SoftwareVersion)

(s/def
  :cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/ConferenceProviderName
  :cognitect.aws.alexaforbusiness/ConferenceProviderName)

(s/def
  :cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/ConferenceProviderType
  :cognitect.aws.alexaforbusiness/ConferenceProviderType)

(s/def
  :cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/IPDialIn
  :cognitect.aws.alexaforbusiness/IPDialIn)

(s/def
  :cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/PSTNDialIn
  :cognitect.aws.alexaforbusiness/PSTNDialIn)

(s/def
  :cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/MeetingSetting
  :cognitect.aws.alexaforbusiness/MeetingSetting)

(s/def
  :cognitect.aws.alexaforbusiness.CreateConferenceProviderRequest/ClientRequestToken
  :cognitect.aws.alexaforbusiness/ClientRequestToken)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateRoomRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateRoomRequest/RoomName
  :cognitect.aws.alexaforbusiness/RoomName)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateRoomRequest/Description
  :cognitect.aws.alexaforbusiness/RoomDescription)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateRoomRequest/ProviderCalendarId
  :cognitect.aws.alexaforbusiness/ProviderCalendarId)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateRoomRequest/ProfileArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.RegisterAVSDeviceResponse/DeviceArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def :cognitect.aws.alexaforbusiness.GetRoomRequest/RoomArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.ListConferenceProvidersResponse/ConferenceProviders
  :cognitect.aws.alexaforbusiness/ConferenceProvidersList)

(s/def
  :cognitect.aws.alexaforbusiness.ListConferenceProvidersResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchDevicesResponse/Devices
  :cognitect.aws.alexaforbusiness/DeviceDataList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchDevicesResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchDevicesResponse/TotalCount
  :cognitect.aws.alexaforbusiness/TotalCount)

(s/def
  :cognitect.aws.alexaforbusiness.ListSmartHomeAppliancesRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.ListSmartHomeAppliancesRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.ListSmartHomeAppliancesRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def :cognitect.aws.alexaforbusiness.SkillGroup/SkillGroupArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.SkillGroup/SkillGroupName
  :cognitect.aws.alexaforbusiness/SkillGroupName)

(s/def
  :cognitect.aws.alexaforbusiness.SkillGroup/Description
  :cognitect.aws.alexaforbusiness/SkillGroupDescription)

(s/def
  :cognitect.aws.alexaforbusiness.GetContactResponse/Contact
  :cognitect.aws.alexaforbusiness/Contact)

(s/def
  :cognitect.aws.alexaforbusiness.SearchContactsRequest/Filters
  :cognitect.aws.alexaforbusiness/FilterList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchContactsRequest/SortCriteria
  :cognitect.aws.alexaforbusiness/SortList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchContactsRequest/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchContactsRequest/MaxResults
  :cognitect.aws.alexaforbusiness/MaxResults)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsStoreSkillsByCategoryResponse/SkillsStoreSkills
  :cognitect.aws.alexaforbusiness/SkillsStoreSkillList)

(s/def
  :cognitect.aws.alexaforbusiness.ListSkillsStoreSkillsByCategoryResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.CreateConferenceProviderResponse/ConferenceProviderArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.AddressBook/AddressBookArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.AddressBook/Name
  :cognitect.aws.alexaforbusiness/AddressBookName)

(s/def
  :cognitect.aws.alexaforbusiness.AddressBook/Description
  :cognitect.aws.alexaforbusiness/AddressBookDescription)

(s/def
  :cognitect.aws.alexaforbusiness.SearchRoomsResponse/Rooms
  :cognitect.aws.alexaforbusiness/RoomDataList)

(s/def
  :cognitect.aws.alexaforbusiness.SearchRoomsResponse/NextToken
  :cognitect.aws.alexaforbusiness/NextToken)

(s/def
  :cognitect.aws.alexaforbusiness.SearchRoomsResponse/TotalCount
  :cognitect.aws.alexaforbusiness/TotalCount)

(s/def :cognitect.aws.alexaforbusiness.Contact/ContactArn :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.Contact/DisplayName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.Contact/FirstName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def :cognitect.aws.alexaforbusiness.Contact/LastName :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.Contact/PhoneNumber
  :cognitect.aws.alexaforbusiness/E164PhoneNumber)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateContactRequest/ContactArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateContactRequest/DisplayName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateContactRequest/FirstName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateContactRequest/LastName
  :cognitect.aws.alexaforbusiness/ContactName)

(s/def
  :cognitect.aws.alexaforbusiness.UpdateContactRequest/PhoneNumber
  :cognitect.aws.alexaforbusiness/E164PhoneNumber)

(s/def
  :cognitect.aws.alexaforbusiness.DisassociateSkillGroupFromRoomRequest/SkillGroupArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.DisassociateSkillGroupFromRoomRequest/RoomArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.SkillGroupData/SkillGroupArn
  :cognitect.aws.alexaforbusiness/Arn)

(s/def
  :cognitect.aws.alexaforbusiness.SkillGroupData/SkillGroupName
  :cognitect.aws.alexaforbusiness/SkillGroupName)

(s/def
  :cognitect.aws.alexaforbusiness.SkillGroupData/Description
  :cognitect.aws.alexaforbusiness/SkillGroupDescription)

