;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.braket.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.braket/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.braket.TagResourceRequest/resourceArn
     :cognitect.aws.braket.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.braket/CreateQuantumTaskRequestOutputS3BucketString
  (s/spec
    (s/and string? #(<= 3 (count %) 63))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 3 63) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.braket/SearchDevicesRequestFiltersList
  (s/coll-of :cognitect.aws.braket/SearchDevicesFilter :min-count 0 :max-count 10))

(s/def :cognitect.aws.braket/JsonValue string?)

(s/def :cognitect.aws.braket/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.braket/DeviceSummary
  (s/keys
    :req-un
    [:cognitect.aws.braket.DeviceSummary/deviceArn
     :cognitect.aws.braket.DeviceSummary/deviceName
     :cognitect.aws.braket.DeviceSummary/deviceStatus
     :cognitect.aws.braket.DeviceSummary/deviceType
     :cognitect.aws.braket.DeviceSummary/providerName]))

(s/def
  :cognitect.aws.braket/QuantumTaskSummaryList
  (s/coll-of :cognitect.aws.braket/QuantumTaskSummary))

(s/def :cognitect.aws.braket/DeviceType (s/spec string? :gen #(s/gen #{"QPU" "SIMULATOR"})))

(s/def
  :cognitect.aws.braket/CancelQuantumTaskRequest
  (s/keys
    :req-un
    [:cognitect.aws.braket.CancelQuantumTaskRequest/clientToken
     :cognitect.aws.braket.CancelQuantumTaskRequest/quantumTaskArn]))

(s/def
  :cognitect.aws.braket/CancellationStatus
  (s/spec string? :gen #(s/gen #{"CANCELLING" "CANCELLED"})))

(s/def
  :cognitect.aws.braket/DeviceArn
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.braket/SearchDevicesFilterNameString
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.braket/GetDeviceResponse
  (s/keys
    :req-un
    [:cognitect.aws.braket.GetDeviceResponse/deviceArn
     :cognitect.aws.braket.GetDeviceResponse/deviceCapabilities
     :cognitect.aws.braket.GetDeviceResponse/deviceName
     :cognitect.aws.braket.GetDeviceResponse/deviceStatus
     :cognitect.aws.braket.GetDeviceResponse/deviceType
     :cognitect.aws.braket.GetDeviceResponse/providerName]))

(s/def :cognitect.aws.braket/SyntheticTimestamp_date_time inst?)

(s/def
  :cognitect.aws.braket/CreateQuantumTaskResponse
  (s/keys :req-un [:cognitect.aws.braket.CreateQuantumTaskResponse/quantumTaskArn]))

(s/def
  :cognitect.aws.braket/SearchQuantumTasksRequestFiltersList
  (s/coll-of :cognitect.aws.braket/SearchQuantumTasksFilter :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.braket/SearchDevicesRequest
  (s/keys
    :req-un
    [:cognitect.aws.braket.SearchDevicesRequest/filters]
    :opt-un
    [:cognitect.aws.braket.SearchDevicesRequest/maxResults
     :cognitect.aws.braket.SearchDevicesRequest/nextToken]))

(s/def
  :cognitect.aws.braket/GetQuantumTaskRequest
  (s/keys :req-un [:cognitect.aws.braket.GetQuantumTaskRequest/quantumTaskArn]))

(s/def
  :cognitect.aws.braket/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.braket.ListTagsForResourceRequest/resourceArn]))

(s/def :cognitect.aws.braket/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.braket/CreateQuantumTaskRequestOutputS3KeyPrefixString
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.braket/SearchQuantumTasksRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.braket/SearchDevicesFilterValuesList
  (s/coll-of :cognitect.aws.braket/String256 :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.braket/String64
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.braket/CreateQuantumTaskRequest
  (s/keys
    :req-un
    [:cognitect.aws.braket.CreateQuantumTaskRequest/action
     :cognitect.aws.braket.CreateQuantumTaskRequest/clientToken
     :cognitect.aws.braket.CreateQuantumTaskRequest/deviceArn
     :cognitect.aws.braket.CreateQuantumTaskRequest/outputS3Bucket
     :cognitect.aws.braket.CreateQuantumTaskRequest/outputS3KeyPrefix
     :cognitect.aws.braket.CreateQuantumTaskRequest/shots]
    :opt-un
    [:cognitect.aws.braket.CreateQuantumTaskRequest/deviceParameters
     :cognitect.aws.braket.CreateQuantumTaskRequest/tags]))

(s/def
  :cognitect.aws.braket/GetDeviceRequest
  (s/keys :req-un [:cognitect.aws.braket.GetDeviceRequest/deviceArn]))

(s/def
  :cognitect.aws.braket/SearchQuantumTasksFilterOperator
  (s/spec string? :gen #(s/gen #{"LTE" "GTE" "LT" "EQUAL" "GT" "BETWEEN"})))

(s/def
  :cognitect.aws.braket/SearchDevicesFilter
  (s/keys
    :req-un
    [:cognitect.aws.braket.SearchDevicesFilter/name
     :cognitect.aws.braket.SearchDevicesFilter/values]))

(s/def :cognitect.aws.braket/Long (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.braket/QuantumTaskSummary
  (s/keys
    :req-un
    [:cognitect.aws.braket.QuantumTaskSummary/createdAt
     :cognitect.aws.braket.QuantumTaskSummary/deviceArn
     :cognitect.aws.braket.QuantumTaskSummary/outputS3Bucket
     :cognitect.aws.braket.QuantumTaskSummary/outputS3Directory
     :cognitect.aws.braket.QuantumTaskSummary/quantumTaskArn
     :cognitect.aws.braket.QuantumTaskSummary/shots
     :cognitect.aws.braket.QuantumTaskSummary/status]
    :opt-un
    [:cognitect.aws.braket.QuantumTaskSummary/tags
     :cognitect.aws.braket.QuantumTaskSummary/endedAt]))

(s/def
  :cognitect.aws.braket/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.braket.UntagResourceRequest/resourceArn
     :cognitect.aws.braket.UntagResourceRequest/tagKeys]))

(s/def
  :cognitect.aws.braket/TagsMap
  (s/map-of :cognitect.aws.braket/String :cognitect.aws.braket/String))

(s/def :cognitect.aws.braket/DeviceSummaryList (s/coll-of :cognitect.aws.braket/DeviceSummary))

(s/def
  :cognitect.aws.braket/SearchDevicesRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.braket/SearchQuantumTasksRequest
  (s/keys
    :req-un
    [:cognitect.aws.braket.SearchQuantumTasksRequest/filters]
    :opt-un
    [:cognitect.aws.braket.SearchQuantumTasksRequest/maxResults
     :cognitect.aws.braket.SearchQuantumTasksRequest/nextToken]))

(s/def
  :cognitect.aws.braket/SearchQuantumTasksResponse
  (s/keys
    :req-un
    [:cognitect.aws.braket.SearchQuantumTasksResponse/quantumTasks]
    :opt-un
    [:cognitect.aws.braket.SearchQuantumTasksResponse/nextToken]))

(s/def
  :cognitect.aws.braket/SearchQuantumTasksFilter
  (s/keys
    :req-un
    [:cognitect.aws.braket.SearchQuantumTasksFilter/name
     :cognitect.aws.braket.SearchQuantumTasksFilter/operator
     :cognitect.aws.braket.SearchQuantumTasksFilter/values]))

(s/def :cognitect.aws.braket/DeviceStatus (s/spec string? :gen #(s/gen #{"OFFLINE" "ONLINE"})))

(s/def :cognitect.aws.braket/TagKeys (s/coll-of :cognitect.aws.braket/String))

(s/def
  :cognitect.aws.braket/SearchQuantumTasksFilterValuesList
  (s/coll-of :cognitect.aws.braket/String256 :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.braket/SearchDevicesResponse
  (s/keys
    :req-un
    [:cognitect.aws.braket.SearchDevicesResponse/devices]
    :opt-un
    [:cognitect.aws.braket.SearchDevicesResponse/nextToken]))

(s/def
  :cognitect.aws.braket/QuantumTaskStatus
  (s/spec
    string?
    :gen
    #(s/gen #{"COMPLETED" "CANCELLING" "QUEUED" "FAILED" "CANCELLED" "RUNNING" "CREATED"})))

(s/def
  :cognitect.aws.braket/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.braket.ListTagsForResourceResponse/tags]))

(s/def
  :cognitect.aws.braket/CancelQuantumTaskResponse
  (s/keys
    :req-un
    [:cognitect.aws.braket.CancelQuantumTaskResponse/cancellationStatus
     :cognitect.aws.braket.CancelQuantumTaskResponse/quantumTaskArn]))

(s/def :cognitect.aws.braket/String string?)

(s/def
  :cognitect.aws.braket/String256
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.braket/CreateQuantumTaskRequestDeviceParametersString
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.braket/QuantumTaskArn
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.braket/GetQuantumTaskResponse
  (s/keys
    :req-un
    [:cognitect.aws.braket.GetQuantumTaskResponse/createdAt
     :cognitect.aws.braket.GetQuantumTaskResponse/deviceArn
     :cognitect.aws.braket.GetQuantumTaskResponse/deviceParameters
     :cognitect.aws.braket.GetQuantumTaskResponse/outputS3Bucket
     :cognitect.aws.braket.GetQuantumTaskResponse/outputS3Directory
     :cognitect.aws.braket.GetQuantumTaskResponse/quantumTaskArn
     :cognitect.aws.braket.GetQuantumTaskResponse/shots
     :cognitect.aws.braket.GetQuantumTaskResponse/status]
    :opt-un
    [:cognitect.aws.braket.GetQuantumTaskResponse/tags
     :cognitect.aws.braket.GetQuantumTaskResponse/endedAt
     :cognitect.aws.braket.GetQuantumTaskResponse/failureReason]))

(s/def
  :cognitect.aws.braket/CreateQuantumTaskRequestShotsLong
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def :cognitect.aws.braket.TagResourceRequest/resourceArn :cognitect.aws.braket/String)

(s/def :cognitect.aws.braket.TagResourceRequest/tags :cognitect.aws.braket/TagsMap)

(s/def :cognitect.aws.braket.DeviceSummary/deviceArn :cognitect.aws.braket/DeviceArn)

(s/def :cognitect.aws.braket.DeviceSummary/deviceName :cognitect.aws.braket/String)

(s/def :cognitect.aws.braket.DeviceSummary/deviceStatus :cognitect.aws.braket/DeviceStatus)

(s/def :cognitect.aws.braket.DeviceSummary/deviceType :cognitect.aws.braket/DeviceType)

(s/def :cognitect.aws.braket.DeviceSummary/providerName :cognitect.aws.braket/String)

(s/def :cognitect.aws.braket.CancelQuantumTaskRequest/clientToken :cognitect.aws.braket/String64)

(s/def
  :cognitect.aws.braket.CancelQuantumTaskRequest/quantumTaskArn
  :cognitect.aws.braket/QuantumTaskArn)

(s/def :cognitect.aws.braket.GetDeviceResponse/deviceArn :cognitect.aws.braket/DeviceArn)

(s/def :cognitect.aws.braket.GetDeviceResponse/deviceCapabilities :cognitect.aws.braket/JsonValue)

(s/def :cognitect.aws.braket.GetDeviceResponse/deviceName :cognitect.aws.braket/String)

(s/def :cognitect.aws.braket.GetDeviceResponse/deviceStatus :cognitect.aws.braket/DeviceStatus)

(s/def :cognitect.aws.braket.GetDeviceResponse/deviceType :cognitect.aws.braket/DeviceType)

(s/def :cognitect.aws.braket.GetDeviceResponse/providerName :cognitect.aws.braket/String)

(s/def
  :cognitect.aws.braket.CreateQuantumTaskResponse/quantumTaskArn
  :cognitect.aws.braket/QuantumTaskArn)

(s/def
  :cognitect.aws.braket.SearchDevicesRequest/filters
  :cognitect.aws.braket/SearchDevicesRequestFiltersList)

(s/def
  :cognitect.aws.braket.SearchDevicesRequest/maxResults
  :cognitect.aws.braket/SearchDevicesRequestMaxResultsInteger)

(s/def :cognitect.aws.braket.SearchDevicesRequest/nextToken :cognitect.aws.braket/String)

(s/def
  :cognitect.aws.braket.GetQuantumTaskRequest/quantumTaskArn
  :cognitect.aws.braket/QuantumTaskArn)

(s/def :cognitect.aws.braket.ListTagsForResourceRequest/resourceArn :cognitect.aws.braket/String)

(s/def :cognitect.aws.braket.CreateQuantumTaskRequest/action :cognitect.aws.braket/JsonValue)

(s/def :cognitect.aws.braket.CreateQuantumTaskRequest/clientToken :cognitect.aws.braket/String64)

(s/def :cognitect.aws.braket.CreateQuantumTaskRequest/deviceArn :cognitect.aws.braket/DeviceArn)

(s/def
  :cognitect.aws.braket.CreateQuantumTaskRequest/deviceParameters
  :cognitect.aws.braket/CreateQuantumTaskRequestDeviceParametersString)

(s/def
  :cognitect.aws.braket.CreateQuantumTaskRequest/outputS3Bucket
  :cognitect.aws.braket/CreateQuantumTaskRequestOutputS3BucketString)

(s/def
  :cognitect.aws.braket.CreateQuantumTaskRequest/outputS3KeyPrefix
  :cognitect.aws.braket/CreateQuantumTaskRequestOutputS3KeyPrefixString)

(s/def
  :cognitect.aws.braket.CreateQuantumTaskRequest/shots
  :cognitect.aws.braket/CreateQuantumTaskRequestShotsLong)

(s/def :cognitect.aws.braket.CreateQuantumTaskRequest/tags :cognitect.aws.braket/TagsMap)

(s/def :cognitect.aws.braket.GetDeviceRequest/deviceArn :cognitect.aws.braket/DeviceArn)

(s/def
  :cognitect.aws.braket.SearchDevicesFilter/name
  :cognitect.aws.braket/SearchDevicesFilterNameString)

(s/def
  :cognitect.aws.braket.SearchDevicesFilter/values
  :cognitect.aws.braket/SearchDevicesFilterValuesList)

(s/def :cognitect.aws.braket.QuantumTaskSummary/tags :cognitect.aws.braket/TagsMap)

(s/def :cognitect.aws.braket.QuantumTaskSummary/quantumTaskArn :cognitect.aws.braket/QuantumTaskArn)

(s/def
  :cognitect.aws.braket.QuantumTaskSummary/createdAt
  :cognitect.aws.braket/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.braket.QuantumTaskSummary/deviceArn :cognitect.aws.braket/DeviceArn)

(s/def :cognitect.aws.braket.QuantumTaskSummary/shots :cognitect.aws.braket/Long)

(s/def :cognitect.aws.braket.QuantumTaskSummary/outputS3Directory :cognitect.aws.braket/String)

(s/def :cognitect.aws.braket.QuantumTaskSummary/status :cognitect.aws.braket/QuantumTaskStatus)

(s/def :cognitect.aws.braket.QuantumTaskSummary/outputS3Bucket :cognitect.aws.braket/String)

(s/def
  :cognitect.aws.braket.QuantumTaskSummary/endedAt
  :cognitect.aws.braket/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.braket.UntagResourceRequest/resourceArn :cognitect.aws.braket/String)

(s/def :cognitect.aws.braket.UntagResourceRequest/tagKeys :cognitect.aws.braket/TagKeys)

(s/def
  :cognitect.aws.braket.SearchQuantumTasksRequest/filters
  :cognitect.aws.braket/SearchQuantumTasksRequestFiltersList)

(s/def
  :cognitect.aws.braket.SearchQuantumTasksRequest/maxResults
  :cognitect.aws.braket/SearchQuantumTasksRequestMaxResultsInteger)

(s/def :cognitect.aws.braket.SearchQuantumTasksRequest/nextToken :cognitect.aws.braket/String)

(s/def :cognitect.aws.braket.SearchQuantumTasksResponse/nextToken :cognitect.aws.braket/String)

(s/def
  :cognitect.aws.braket.SearchQuantumTasksResponse/quantumTasks
  :cognitect.aws.braket/QuantumTaskSummaryList)

(s/def :cognitect.aws.braket.SearchQuantumTasksFilter/name :cognitect.aws.braket/String64)

(s/def
  :cognitect.aws.braket.SearchQuantumTasksFilter/operator
  :cognitect.aws.braket/SearchQuantumTasksFilterOperator)

(s/def
  :cognitect.aws.braket.SearchQuantumTasksFilter/values
  :cognitect.aws.braket/SearchQuantumTasksFilterValuesList)

(s/def :cognitect.aws.braket.SearchDevicesResponse/devices :cognitect.aws.braket/DeviceSummaryList)

(s/def :cognitect.aws.braket.SearchDevicesResponse/nextToken :cognitect.aws.braket/String)

(s/def :cognitect.aws.braket.ListTagsForResourceResponse/tags :cognitect.aws.braket/TagsMap)

(s/def
  :cognitect.aws.braket.CancelQuantumTaskResponse/cancellationStatus
  :cognitect.aws.braket/CancellationStatus)

(s/def
  :cognitect.aws.braket.CancelQuantumTaskResponse/quantumTaskArn
  :cognitect.aws.braket/QuantumTaskArn)

(s/def :cognitect.aws.braket.GetQuantumTaskResponse/tags :cognitect.aws.braket/TagsMap)

(s/def
  :cognitect.aws.braket.GetQuantumTaskResponse/quantumTaskArn
  :cognitect.aws.braket/QuantumTaskArn)

(s/def
  :cognitect.aws.braket.GetQuantumTaskResponse/createdAt
  :cognitect.aws.braket/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.braket.GetQuantumTaskResponse/deviceArn :cognitect.aws.braket/DeviceArn)

(s/def :cognitect.aws.braket.GetQuantumTaskResponse/shots :cognitect.aws.braket/Long)

(s/def :cognitect.aws.braket.GetQuantumTaskResponse/outputS3Directory :cognitect.aws.braket/String)

(s/def
  :cognitect.aws.braket.GetQuantumTaskResponse/deviceParameters
  :cognitect.aws.braket/JsonValue)

(s/def :cognitect.aws.braket.GetQuantumTaskResponse/status :cognitect.aws.braket/QuantumTaskStatus)

(s/def :cognitect.aws.braket.GetQuantumTaskResponse/failureReason :cognitect.aws.braket/String)

(s/def :cognitect.aws.braket.GetQuantumTaskResponse/outputS3Bucket :cognitect.aws.braket/String)

(s/def
  :cognitect.aws.braket.GetQuantumTaskResponse/endedAt
  :cognitect.aws.braket/SyntheticTimestamp_date_time)

