;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.comprehendmedical.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.comprehendmedical/DetectEntitiesRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.DetectEntitiesRequest/Text]))

(s/def
  :cognitect.aws.comprehendmedical/BoundedLengthString
  (s/with-gen
    (s/and string? #(<= 1 (count %) 20000))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 20000 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.comprehendmedical/TraitList
  (s/coll-of :cognitect.aws.comprehendmedical/Trait))

(s/def
  :cognitect.aws.comprehendmedical/DetectEntitiesResponse
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.DetectEntitiesResponse/Entities]
    :opt-un
    [:cognitect.aws.comprehendmedical.DetectEntitiesResponse/PaginationToken
     :cognitect.aws.comprehendmedical.DetectEntitiesResponse/UnmappedAttributes]))

(s/def
  :cognitect.aws.comprehendmedical/DetectPHIRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.DetectPHIRequest/Text]))

(s/def :cognitect.aws.comprehendmedical/EntityType string?)

(s/def
  :cognitect.aws.comprehendmedical/Integer
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.comprehendmedical/Trait
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.Trait/Score :cognitect.aws.comprehendmedical.Trait/Name]))

(s/def
  :cognitect.aws.comprehendmedical/EntityList
  (s/coll-of :cognitect.aws.comprehendmedical/Entity))

(s/def
  :cognitect.aws.comprehendmedical/DetectPHIResponse
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.DetectPHIResponse/Entities]
    :opt-un
    [:cognitect.aws.comprehendmedical.DetectPHIResponse/PaginationToken]))

(s/def
  :cognitect.aws.comprehendmedical/Float
  (s/with-gen double? #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.comprehendmedical/AttributeList
  (s/coll-of :cognitect.aws.comprehendmedical/Attribute))

(s/def :cognitect.aws.comprehendmedical/EntitySubType string?)

(s/def :cognitect.aws.comprehendmedical/AttributeName string?)

(s/def
  :cognitect.aws.comprehendmedical/UnmappedAttribute
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.UnmappedAttribute/Type
     :cognitect.aws.comprehendmedical.UnmappedAttribute/Attribute]))

(s/def
  :cognitect.aws.comprehendmedical/Attribute
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.Attribute/Type
     :cognitect.aws.comprehendmedical.Attribute/RelationshipScore
     :cognitect.aws.comprehendmedical.Attribute/BeginOffset
     :cognitect.aws.comprehendmedical.Attribute/Score
     :cognitect.aws.comprehendmedical.Attribute/Traits
     :cognitect.aws.comprehendmedical.Attribute/EndOffset
     :cognitect.aws.comprehendmedical.Attribute/Text
     :cognitect.aws.comprehendmedical.Attribute/Id]))

(s/def
  :cognitect.aws.comprehendmedical/UnmappedAttributeList
  (s/coll-of :cognitect.aws.comprehendmedical/UnmappedAttribute))

(s/def
  :cognitect.aws.comprehendmedical/String
  (s/with-gen
    (s/and string? #(<= 1 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or nil 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.comprehendmedical/Entity
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.Entity/Type
     :cognitect.aws.comprehendmedical.Entity/Category
     :cognitect.aws.comprehendmedical.Entity/BeginOffset
     :cognitect.aws.comprehendmedical.Entity/Score
     :cognitect.aws.comprehendmedical.Entity/Attributes
     :cognitect.aws.comprehendmedical.Entity/Traits
     :cognitect.aws.comprehendmedical.Entity/EndOffset
     :cognitect.aws.comprehendmedical.Entity/Text
     :cognitect.aws.comprehendmedical.Entity/Id]))

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesRequest/Text
  :cognitect.aws.comprehendmedical/BoundedLengthString)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesResponse/Entities
  :cognitect.aws.comprehendmedical/EntityList)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesResponse/UnmappedAttributes
  :cognitect.aws.comprehendmedical/UnmappedAttributeList)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesResponse/PaginationToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.DetectPHIRequest/Text
  :cognitect.aws.comprehendmedical/BoundedLengthString)

(s/def :cognitect.aws.comprehendmedical.Trait/Name :cognitect.aws.comprehendmedical/AttributeName)

(s/def :cognitect.aws.comprehendmedical.Trait/Score :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.DetectPHIResponse/Entities
  :cognitect.aws.comprehendmedical/EntityList)

(s/def
  :cognitect.aws.comprehendmedical.DetectPHIResponse/PaginationToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.UnmappedAttribute/Type
  :cognitect.aws.comprehendmedical/EntityType)

(s/def
  :cognitect.aws.comprehendmedical.UnmappedAttribute/Attribute
  :cognitect.aws.comprehendmedical/Attribute)

(s/def
  :cognitect.aws.comprehendmedical.Attribute/Type
  :cognitect.aws.comprehendmedical/EntitySubType)

(s/def :cognitect.aws.comprehendmedical.Attribute/Score :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.Attribute/RelationshipScore
  :cognitect.aws.comprehendmedical/Float)

(s/def :cognitect.aws.comprehendmedical.Attribute/Id :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.Attribute/BeginOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.Attribute/EndOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.Attribute/Text :cognitect.aws.comprehendmedical/String)

(s/def :cognitect.aws.comprehendmedical.Attribute/Traits :cognitect.aws.comprehendmedical/TraitList)

(s/def :cognitect.aws.comprehendmedical.Entity/EndOffset :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.Entity/Score :cognitect.aws.comprehendmedical/Float)

(s/def :cognitect.aws.comprehendmedical.Entity/Id :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.Entity/BeginOffset :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.Entity/Category :cognitect.aws.comprehendmedical/EntityType)

(s/def :cognitect.aws.comprehendmedical.Entity/Text :cognitect.aws.comprehendmedical/String)

(s/def :cognitect.aws.comprehendmedical.Entity/Traits :cognitect.aws.comprehendmedical/TraitList)

(s/def :cognitect.aws.comprehendmedical.Entity/Type :cognitect.aws.comprehendmedical/EntitySubType)

(s/def
  :cognitect.aws.comprehendmedical.Entity/Attributes
  :cognitect.aws.comprehendmedical/AttributeList)

