;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.comprehendmedical.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def :cognitect.aws.comprehendmedical/AnyLengthString string?)

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTTrait
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.SNOMEDCTTrait/Score
     :cognitect.aws.comprehendmedical.SNOMEDCTTrait/Name]))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTConcept
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.SNOMEDCTConcept/Score
     :cognitect.aws.comprehendmedical.SNOMEDCTConcept/Description
     :cognitect.aws.comprehendmedical.SNOMEDCTConcept/Code]))

(s/def
  :cognitect.aws.comprehendmedical/JobName
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.comprehendmedical/StopICD10CMInferenceJobRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.StopICD10CMInferenceJobRequest/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/RxNormConcept
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.RxNormConcept/Score
     :cognitect.aws.comprehendmedical.RxNormConcept/Description
     :cognitect.aws.comprehendmedical.RxNormConcept/Code]))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMConcept
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ICD10CMConcept/Score
     :cognitect.aws.comprehendmedical.ICD10CMConcept/Description
     :cognitect.aws.comprehendmedical.ICD10CMConcept/Code]))

(s/def
  :cognitect.aws.comprehendmedical/RxNormConceptList
  (s/coll-of :cognitect.aws.comprehendmedical/RxNormConcept))

(s/def
  :cognitect.aws.comprehendmedical/RxNormEntity
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.RxNormEntity/RxNormConcepts
     :cognitect.aws.comprehendmedical.RxNormEntity/Type
     :cognitect.aws.comprehendmedical.RxNormEntity/Category
     :cognitect.aws.comprehendmedical.RxNormEntity/BeginOffset
     :cognitect.aws.comprehendmedical.RxNormEntity/Score
     :cognitect.aws.comprehendmedical.RxNormEntity/Attributes
     :cognitect.aws.comprehendmedical.RxNormEntity/Traits
     :cognitect.aws.comprehendmedical.RxNormEntity/EndOffset
     :cognitect.aws.comprehendmedical.RxNormEntity/Text
     :cognitect.aws.comprehendmedical.RxNormEntity/Id]))

(s/def
  :cognitect.aws.comprehendmedical/OntologyLinkingBoundedLengthString
  (s/spec
    (s/and string? #(<= 1 (count %) 10000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 10000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.comprehendmedical/DescribeICD10CMInferenceJobRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.DescribeICD10CMInferenceJobRequest/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/DescribeRxNormInferenceJobRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.DescribeRxNormInferenceJobRequest/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/StopPHIDetectionJobRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.StopPHIDetectionJobRequest/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/DetectEntitiesRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.DetectEntitiesRequest/Text]))

(s/def
  :cognitect.aws.comprehendmedical/StopSNOMEDCTInferenceJobResponse
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.StopSNOMEDCTInferenceJobResponse/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/ManifestFilePath
  (s/spec
    (s/and string? #(<= 1 (count %) 4096))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 4096) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTAttributeList
  (s/coll-of :cognitect.aws.comprehendmedical/SNOMEDCTAttribute))

(s/def
  :cognitect.aws.comprehendmedical/BoundedLengthString
  (s/spec
    (s/and string? #(<= 1 (count %) 20000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 20000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTTraitList
  (s/coll-of :cognitect.aws.comprehendmedical/SNOMEDCTTrait))

(s/def
  :cognitect.aws.comprehendmedical/RxNormEntityList
  (s/coll-of :cognitect.aws.comprehendmedical/RxNormEntity))

(s/def
  :cognitect.aws.comprehendmedical/DescribePHIDetectionJobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.DescribePHIDetectionJobResponse/ComprehendMedicalAsyncJobProperties]))

(s/def
  :cognitect.aws.comprehendmedical/RxNormAttribute
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.RxNormAttribute/Type
     :cognitect.aws.comprehendmedical.RxNormAttribute/RelationshipScore
     :cognitect.aws.comprehendmedical.RxNormAttribute/BeginOffset
     :cognitect.aws.comprehendmedical.RxNormAttribute/Score
     :cognitect.aws.comprehendmedical.RxNormAttribute/Traits
     :cognitect.aws.comprehendmedical.RxNormAttribute/EndOffset
     :cognitect.aws.comprehendmedical.RxNormAttribute/Text
     :cognitect.aws.comprehendmedical.RxNormAttribute/Id]))

(s/def
  :cognitect.aws.comprehendmedical/TraitList
  (s/coll-of :cognitect.aws.comprehendmedical/Trait))

(s/def
  :cognitect.aws.comprehendmedical/DetectEntitiesV2Request
  (s/keys :req-un [:cognitect.aws.comprehendmedical.DetectEntitiesV2Request/Text]))

(s/def
  :cognitect.aws.comprehendmedical/ListICD10CMInferenceJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ListICD10CMInferenceJobsRequest/Filter
     :cognitect.aws.comprehendmedical.ListICD10CMInferenceJobsRequest/NextToken
     :cognitect.aws.comprehendmedical.ListICD10CMInferenceJobsRequest/MaxResults]))

(s/def
  :cognitect.aws.comprehendmedical/JobId
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMEntityList
  (s/coll-of :cognitect.aws.comprehendmedical/ICD10CMEntity))

(s/def
  :cognitect.aws.comprehendmedical/ListSNOMEDCTInferenceJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ListSNOMEDCTInferenceJobsResponse/ComprehendMedicalAsyncJobPropertiesList
     :cognitect.aws.comprehendmedical.ListSNOMEDCTInferenceJobsResponse/NextToken]))

(s/def
  :cognitect.aws.comprehendmedical/DetectEntitiesResponse
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.DetectEntitiesResponse/Entities
     :cognitect.aws.comprehendmedical.DetectEntitiesResponse/ModelVersion]
    :opt-un
    [:cognitect.aws.comprehendmedical.DetectEntitiesResponse/PaginationToken
     :cognitect.aws.comprehendmedical.DetectEntitiesResponse/UnmappedAttributes]))

(s/def
  :cognitect.aws.comprehendmedical/DescribeSNOMEDCTInferenceJobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.DescribeSNOMEDCTInferenceJobResponse/ComprehendMedicalAsyncJobProperties]))

(s/def
  :cognitect.aws.comprehendmedical/StopRxNormInferenceJobResponse
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.StopRxNormInferenceJobResponse/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/InferRxNormRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.InferRxNormRequest/Text]))

(s/def
  :cognitect.aws.comprehendmedical/StartRxNormInferenceJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/InputDataConfig
     :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/OutputDataConfig
     :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/DataAccessRoleArn
     :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/LanguageCode]
    :opt-un
    [:cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/ClientRequestToken
     :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/JobName
     :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/KMSKey]))

(s/def
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobFilter
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobFilter/JobStatus
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobFilter/JobName
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobFilter/SubmitTimeAfter
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobFilter/SubmitTimeBefore]))

(s/def
  :cognitect.aws.comprehendmedical/ListEntitiesDetectionV2JobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ListEntitiesDetectionV2JobsRequest/Filter
     :cognitect.aws.comprehendmedical.ListEntitiesDetectionV2JobsRequest/NextToken
     :cognitect.aws.comprehendmedical.ListEntitiesDetectionV2JobsRequest/MaxResults]))

(s/def
  :cognitect.aws.comprehendmedical/JobStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"COMPLETED" "IN_PROGRESS" "STOP_REQUESTED" "SUBMITTED" "PARTIAL_SUCCESS" "STOPPED"
        "FAILED"})))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMRelationshipType
  (s/spec string? :gen #(s/gen #{"SYSTEM_ORGAN_SITE" "OVERLAP"})))

(s/def
  :cognitect.aws.comprehendmedical/S3Key
  (s/spec #(re-matches (re-pattern ".*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.comprehendmedical/DetectPHIRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.DetectPHIRequest/Text]))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMEntity
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ICD10CMEntity/Type
     :cognitect.aws.comprehendmedical.ICD10CMEntity/Category
     :cognitect.aws.comprehendmedical.ICD10CMEntity/BeginOffset
     :cognitect.aws.comprehendmedical.ICD10CMEntity/Score
     :cognitect.aws.comprehendmedical.ICD10CMEntity/ICD10CMConcepts
     :cognitect.aws.comprehendmedical.ICD10CMEntity/Attributes
     :cognitect.aws.comprehendmedical.ICD10CMEntity/Traits
     :cognitect.aws.comprehendmedical.ICD10CMEntity/EndOffset
     :cognitect.aws.comprehendmedical.ICD10CMEntity/Text
     :cognitect.aws.comprehendmedical.ICD10CMEntity/Id]))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTEntityType
  (s/spec string? :gen #(s/gen #{"TEST_NAME" "TREATMENT_NAME" "DX_NAME" "PROCEDURE_NAME"})))

(s/def
  :cognitect.aws.comprehendmedical/StartEntitiesDetectionV2JobResponse
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobResponse/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/KMSKey
  (s/spec #(re-matches (re-pattern ".*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.comprehendmedical/EntityType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MEDICATION" "PROTECTED_HEALTH_INFORMATION" "TEST_TREATMENT_PROCEDURE" "ANATOMY"
        "TIME_EXPRESSION" "MEDICAL_CONDITION"})))

(s/def
  :cognitect.aws.comprehendmedical/StopEntitiesDetectionV2JobRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.StopEntitiesDetectionV2JobRequest/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTDetails
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.SNOMEDCTDetails/VersionDate
     :cognitect.aws.comprehendmedical.SNOMEDCTDetails/Edition
     :cognitect.aws.comprehendmedical.SNOMEDCTDetails/Language]))

(s/def
  :cognitect.aws.comprehendmedical/RelationshipType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"STRENGTH" "FOR" "TEST_UNIT" "WITH_DOSAGE" "DIRECTION" "SYSTEM_ORGAN_SITE" "FORM"
        "FREQUENCY" "TEST_VALUE" "DURATION" "NEGATIVE" "OVERLAP" "ADMINISTERED_VIA" "RATE"
        "TEST_UNITS" "ROUTE_OR_MODE" "ACUITY" "DOSAGE" "EVERY"})))

(s/def
  :cognitect.aws.comprehendmedical/Characters
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.Characters/OriginalTextCharacters]))

(s/def
  :cognitect.aws.comprehendmedical/StartPHIDetectionJobResponse
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.StartPHIDetectionJobResponse/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/StopEntitiesDetectionV2JobResponse
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.StopEntitiesDetectionV2JobResponse/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTAttributeType
  (s/spec
    string?
    :gen
    #(s/gen #{"TEST_UNIT" "DIRECTION" "SYSTEM_ORGAN_SITE" "TEST_VALUE" "QUALITY" "ACUITY"})))

(s/def
  :cognitect.aws.comprehendmedical/ListRxNormInferenceJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ListRxNormInferenceJobsResponse/ComprehendMedicalAsyncJobPropertiesList
     :cognitect.aws.comprehendmedical.ListRxNormInferenceJobsResponse/NextToken]))

(s/def
  :cognitect.aws.comprehendmedical/RxNormAttributeType
  (s/spec
    string?
    :gen
    #(s/gen #{"STRENGTH" "FORM" "FREQUENCY" "DURATION" "RATE" "ROUTE_OR_MODE" "DOSAGE"})))

(s/def
  :cognitect.aws.comprehendmedical/S3Bucket
  (s/spec #(re-matches (re-pattern "^[0-9a-z\\.\\-_]*(?!\\.)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMAttribute
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ICD10CMAttribute/Type
     :cognitect.aws.comprehendmedical.ICD10CMAttribute/Category
     :cognitect.aws.comprehendmedical.ICD10CMAttribute/RelationshipScore
     :cognitect.aws.comprehendmedical.ICD10CMAttribute/RelationshipType
     :cognitect.aws.comprehendmedical.ICD10CMAttribute/BeginOffset
     :cognitect.aws.comprehendmedical.ICD10CMAttribute/Score
     :cognitect.aws.comprehendmedical.ICD10CMAttribute/Traits
     :cognitect.aws.comprehendmedical.ICD10CMAttribute/EndOffset
     :cognitect.aws.comprehendmedical.ICD10CMAttribute/Text
     :cognitect.aws.comprehendmedical.ICD10CMAttribute/Id]))

(s/def
  :cognitect.aws.comprehendmedical/MaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 500)) :gen #(gen/choose 1 500)))

(s/def
  :cognitect.aws.comprehendmedical/IamRoleArn
  (s/spec
    #(re-matches (re-pattern "arn:aws(-[^:]+)?:iam::[0-9]{12}:role/.+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.comprehendmedical/OutputDataConfig
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.OutputDataConfig/S3Bucket]
    :opt-un
    [:cognitect.aws.comprehendmedical.OutputDataConfig/S3Key]))

(s/def
  :cognitect.aws.comprehendmedical/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.comprehendmedical/ModelVersion string?)

(s/def
  :cognitect.aws.comprehendmedical/DescribeSNOMEDCTInferenceJobRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.DescribeSNOMEDCTInferenceJobRequest/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/ListRxNormInferenceJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ListRxNormInferenceJobsRequest/Filter
     :cognitect.aws.comprehendmedical.ListRxNormInferenceJobsRequest/NextToken
     :cognitect.aws.comprehendmedical.ListRxNormInferenceJobsRequest/MaxResults]))

(s/def
  :cognitect.aws.comprehendmedical/ClientRequestTokenString
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.comprehendmedical/ListPHIDetectionJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ListPHIDetectionJobsResponse/ComprehendMedicalAsyncJobPropertiesList
     :cognitect.aws.comprehendmedical.ListPHIDetectionJobsResponse/NextToken]))

(s/def
  :cognitect.aws.comprehendmedical/RxNormEntityCategory
  (s/spec string? :gen #(s/gen #{"MEDICATION"})))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTAttribute
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Type
     :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Category
     :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/RelationshipScore
     :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/RelationshipType
     :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/BeginOffset
     :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Score
     :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Traits
     :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/EndOffset
     :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/SNOMEDCTConcepts
     :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Text
     :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Id]))

(s/def
  :cognitect.aws.comprehendmedical/Trait
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.Trait/Score :cognitect.aws.comprehendmedical.Trait/Name]))

(s/def
  :cognitect.aws.comprehendmedical/InferICD10CMResponse
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.InferICD10CMResponse/Entities]
    :opt-un
    [:cognitect.aws.comprehendmedical.InferICD10CMResponse/PaginationToken
     :cognitect.aws.comprehendmedical.InferICD10CMResponse/ModelVersion]))

(s/def
  :cognitect.aws.comprehendmedical/EntityList
  (s/coll-of :cognitect.aws.comprehendmedical/Entity))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTEntityList
  (s/coll-of :cognitect.aws.comprehendmedical/SNOMEDCTEntity))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTRelationshipType
  (s/spec
    string?
    :gen
    #(s/gen #{"DIRECTION" "SYSTEM_ORGAN_SITE" "TEST_VALUE" "QUALITY" "TEST_UNITS" "ACUITY"})))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMEntityType
  (s/spec string? :gen #(s/gen #{"DX_NAME" "TIME_EXPRESSION"})))

(s/def
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobPropertiesList
  (s/coll-of :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobProperties))

(s/def
  :cognitect.aws.comprehendmedical/StartSNOMEDCTInferenceJobResponse
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobResponse/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/DescribePHIDetectionJobRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.DescribePHIDetectionJobRequest/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/RxNormEntityType
  (s/spec string? :gen #(s/gen #{"BRAND_NAME" "GENERIC_NAME"})))

(s/def
  :cognitect.aws.comprehendmedical/DetectPHIResponse
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.DetectPHIResponse/Entities
     :cognitect.aws.comprehendmedical.DetectPHIResponse/ModelVersion]
    :opt-un
    [:cognitect.aws.comprehendmedical.DetectPHIResponse/PaginationToken]))

(s/def
  :cognitect.aws.comprehendmedical/DescribeRxNormInferenceJobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.DescribeRxNormInferenceJobResponse/ComprehendMedicalAsyncJobProperties]))

(s/def
  :cognitect.aws.comprehendmedical/StopICD10CMInferenceJobResponse
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.StopICD10CMInferenceJobResponse/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobProperties
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/ExpirationTime
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/InputDataConfig
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/OutputDataConfig
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/EndTime
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/JobStatus
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/JobName
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/ManifestFilePath
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/SubmitTime
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/KMSKey
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/LanguageCode
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/Message
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/DataAccessRoleArn
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/ModelVersion
     :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/StartSNOMEDCTInferenceJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/InputDataConfig
     :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/OutputDataConfig
     :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/DataAccessRoleArn
     :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/LanguageCode]
    :opt-un
    [:cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/ClientRequestToken
     :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/JobName
     :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/KMSKey]))

(s/def
  :cognitect.aws.comprehendmedical/DescribeEntitiesDetectionV2JobRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.DescribeEntitiesDetectionV2JobRequest/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/DescribeICD10CMInferenceJobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.DescribeICD10CMInferenceJobResponse/ComprehendMedicalAsyncJobProperties]))

(s/def
  :cognitect.aws.comprehendmedical/Float
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.comprehendmedical/AttributeList
  (s/coll-of :cognitect.aws.comprehendmedical/Attribute))

(s/def
  :cognitect.aws.comprehendmedical/ListICD10CMInferenceJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ListICD10CMInferenceJobsResponse/ComprehendMedicalAsyncJobPropertiesList
     :cognitect.aws.comprehendmedical.ListICD10CMInferenceJobsResponse/NextToken]))

(s/def
  :cognitect.aws.comprehendmedical/EntitySubType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"URL" "TEST_NAME" "STRENGTH" "AGE" "TIME_TO_TREATMENT_NAME" "CONTACT_POINT"
        "TREATMENT_NAME" "NAME" "TEST_UNIT" "DATE" "TIME_TO_DX_NAME" "DIRECTION" "DX_NAME"
        "SYSTEM_ORGAN_SITE" "FORM" "BRAND_NAME" "TIME_TO_PROCEDURE_NAME" "PROCEDURE_NAME"
        "TIME_TO_TEST_NAME" "GENERIC_NAME" "QUANTITY" "FREQUENCY" "ID" "TEST_VALUE" "QUALITY"
        "DURATION" "RATE" "TEST_UNITS" "ADDRESS" "TIME_EXPRESSION" "ROUTE_OR_MODE" "ACUITY"
        "TIME_TO_MEDICATION_NAME" "DOSAGE" "EMAIL" "PROFESSION" "IDENTIFIER" "PHONE_OR_FAX"})))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTEntityCategory
  (s/spec string? :gen #(s/gen #{"TEST_TREATMENT_PROCEDURE" "ANATOMY" "MEDICAL_CONDITION"})))

(s/def
  :cognitect.aws.comprehendmedical/DetectEntitiesV2Response
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.DetectEntitiesV2Response/Entities
     :cognitect.aws.comprehendmedical.DetectEntitiesV2Response/ModelVersion]
    :opt-un
    [:cognitect.aws.comprehendmedical.DetectEntitiesV2Response/PaginationToken
     :cognitect.aws.comprehendmedical.DetectEntitiesV2Response/UnmappedAttributes]))

(s/def
  :cognitect.aws.comprehendmedical/RxNormTraitList
  (s/coll-of :cognitect.aws.comprehendmedical/RxNormTrait))

(s/def
  :cognitect.aws.comprehendmedical/StartICD10CMInferenceJobResponse
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.StartICD10CMInferenceJobResponse/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/DescribeEntitiesDetectionV2JobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.DescribeEntitiesDetectionV2JobResponse/ComprehendMedicalAsyncJobProperties]))

(s/def
  :cognitect.aws.comprehendmedical/AttributeName
  (s/spec string? :gen #(s/gen #{"SIGN" "NEGATION" "SYMPTOM" "DIAGNOSIS"})))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTEntity
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.SNOMEDCTEntity/Type
     :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Category
     :cognitect.aws.comprehendmedical.SNOMEDCTEntity/BeginOffset
     :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Score
     :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Attributes
     :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Traits
     :cognitect.aws.comprehendmedical.SNOMEDCTEntity/EndOffset
     :cognitect.aws.comprehendmedical.SNOMEDCTEntity/SNOMEDCTConcepts
     :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Text
     :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Id]))

(s/def
  :cognitect.aws.comprehendmedical/InferICD10CMRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.InferICD10CMRequest/Text]))

(s/def
  :cognitect.aws.comprehendmedical/RxNormTraitName
  (s/spec string? :gen #(s/gen #{"NEGATION"})))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTConceptList
  (s/coll-of :cognitect.aws.comprehendmedical/SNOMEDCTConcept))

(s/def
  :cognitect.aws.comprehendmedical/UnmappedAttribute
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.UnmappedAttribute/Type
     :cognitect.aws.comprehendmedical.UnmappedAttribute/Attribute]))

(s/def
  :cognitect.aws.comprehendmedical/StopSNOMEDCTInferenceJobRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.StopSNOMEDCTInferenceJobRequest/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/RxNormAttributeList
  (s/coll-of :cognitect.aws.comprehendmedical/RxNormAttribute))

(s/def
  :cognitect.aws.comprehendmedical/ListPHIDetectionJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ListPHIDetectionJobsRequest/Filter
     :cognitect.aws.comprehendmedical.ListPHIDetectionJobsRequest/NextToken
     :cognitect.aws.comprehendmedical.ListPHIDetectionJobsRequest/MaxResults]))

(s/def :cognitect.aws.comprehendmedical/Timestamp inst?)

(s/def
  :cognitect.aws.comprehendmedical/StartPHIDetectionJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/InputDataConfig
     :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/OutputDataConfig
     :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/DataAccessRoleArn
     :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/LanguageCode]
    :opt-un
    [:cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/ClientRequestToken
     :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/JobName
     :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/KMSKey]))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMTraitList
  (s/coll-of :cognitect.aws.comprehendmedical/ICD10CMTrait))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMAttributeType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"TIME_TO_DX_NAME" "DIRECTION" "SYSTEM_ORGAN_SITE" "QUANTITY" "QUALITY" "TIME_EXPRESSION"
        "ACUITY"})))

(s/def
  :cognitect.aws.comprehendmedical/Attribute
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.Attribute/Type
     :cognitect.aws.comprehendmedical.Attribute/Category
     :cognitect.aws.comprehendmedical.Attribute/RelationshipScore
     :cognitect.aws.comprehendmedical.Attribute/RelationshipType
     :cognitect.aws.comprehendmedical.Attribute/BeginOffset
     :cognitect.aws.comprehendmedical.Attribute/Score
     :cognitect.aws.comprehendmedical.Attribute/Traits
     :cognitect.aws.comprehendmedical.Attribute/EndOffset
     :cognitect.aws.comprehendmedical.Attribute/Text
     :cognitect.aws.comprehendmedical.Attribute/Id]))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMAttributeList
  (s/coll-of :cognitect.aws.comprehendmedical/ICD10CMAttribute))

(s/def
  :cognitect.aws.comprehendmedical/StartICD10CMInferenceJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/InputDataConfig
     :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/OutputDataConfig
     :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/DataAccessRoleArn
     :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/LanguageCode]
    :opt-un
    [:cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/ClientRequestToken
     :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/JobName
     :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/KMSKey]))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMConceptList
  (s/coll-of :cognitect.aws.comprehendmedical/ICD10CMConcept))

(s/def
  :cognitect.aws.comprehendmedical/ListEntitiesDetectionV2JobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ListEntitiesDetectionV2JobsResponse/ComprehendMedicalAsyncJobPropertiesList
     :cognitect.aws.comprehendmedical.ListEntitiesDetectionV2JobsResponse/NextToken]))

(s/def
  :cognitect.aws.comprehendmedical/InputDataConfig
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.InputDataConfig/S3Bucket]
    :opt-un
    [:cognitect.aws.comprehendmedical.InputDataConfig/S3Key]))

(s/def
  :cognitect.aws.comprehendmedical/ListSNOMEDCTInferenceJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ListSNOMEDCTInferenceJobsRequest/Filter
     :cognitect.aws.comprehendmedical.ListSNOMEDCTInferenceJobsRequest/NextToken
     :cognitect.aws.comprehendmedical.ListSNOMEDCTInferenceJobsRequest/MaxResults]))

(s/def
  :cognitect.aws.comprehendmedical/InferSNOMEDCTResponse
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.InferSNOMEDCTResponse/Entities]
    :opt-un
    [:cognitect.aws.comprehendmedical.InferSNOMEDCTResponse/Characters
     :cognitect.aws.comprehendmedical.InferSNOMEDCTResponse/PaginationToken
     :cognitect.aws.comprehendmedical.InferSNOMEDCTResponse/SNOMEDCTDetails
     :cognitect.aws.comprehendmedical.InferSNOMEDCTResponse/ModelVersion]))

(s/def
  :cognitect.aws.comprehendmedical/StopPHIDetectionJobResponse
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.StopPHIDetectionJobResponse/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/InferSNOMEDCTRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.InferSNOMEDCTRequest/Text]))

(s/def
  :cognitect.aws.comprehendmedical/SNOMEDCTTraitName
  (s/spec string? :gen #(s/gen #{"SIGN" "NEGATION" "SYMPTOM" "DIAGNOSIS"})))

(s/def
  :cognitect.aws.comprehendmedical/UnmappedAttributeList
  (s/coll-of :cognitect.aws.comprehendmedical/UnmappedAttribute))

(s/def
  :cognitect.aws.comprehendmedical/RxNormTrait
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.RxNormTrait/Score
     :cognitect.aws.comprehendmedical.RxNormTrait/Name]))

(s/def
  :cognitect.aws.comprehendmedical/StartEntitiesDetectionV2JobRequest
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/InputDataConfig
     :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/OutputDataConfig
     :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/DataAccessRoleArn
     :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/LanguageCode]
    :opt-un
    [:cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/ClientRequestToken
     :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/JobName
     :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/KMSKey]))

(s/def :cognitect.aws.comprehendmedical/LanguageCode (s/spec string? :gen #(s/gen #{"en"})))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMEntityCategory
  (s/spec string? :gen #(s/gen #{"MEDICAL_CONDITION"})))

(s/def
  :cognitect.aws.comprehendmedical/StartRxNormInferenceJobResponse
  (s/keys :opt-un [:cognitect.aws.comprehendmedical.StartRxNormInferenceJobResponse/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/String
  (s/spec
    (s/and string? #(<= 1 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMTraitName
  (s/spec string? :gen #(s/gen #{"SIGN" "NEGATION" "SYMPTOM" "DIAGNOSIS"})))

(s/def
  :cognitect.aws.comprehendmedical/Entity
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.Entity/Type
     :cognitect.aws.comprehendmedical.Entity/Category
     :cognitect.aws.comprehendmedical.Entity/BeginOffset
     :cognitect.aws.comprehendmedical.Entity/Score
     :cognitect.aws.comprehendmedical.Entity/Attributes
     :cognitect.aws.comprehendmedical.Entity/Traits
     :cognitect.aws.comprehendmedical.Entity/EndOffset
     :cognitect.aws.comprehendmedical.Entity/Text
     :cognitect.aws.comprehendmedical.Entity/Id]))

(s/def
  :cognitect.aws.comprehendmedical/StopRxNormInferenceJobRequest
  (s/keys :req-un [:cognitect.aws.comprehendmedical.StopRxNormInferenceJobRequest/JobId]))

(s/def
  :cognitect.aws.comprehendmedical/ICD10CMTrait
  (s/keys
    :opt-un
    [:cognitect.aws.comprehendmedical.ICD10CMTrait/Score
     :cognitect.aws.comprehendmedical.ICD10CMTrait/Name]))

(s/def
  :cognitect.aws.comprehendmedical/InferRxNormResponse
  (s/keys
    :req-un
    [:cognitect.aws.comprehendmedical.InferRxNormResponse/Entities]
    :opt-un
    [:cognitect.aws.comprehendmedical.InferRxNormResponse/PaginationToken
     :cognitect.aws.comprehendmedical.InferRxNormResponse/ModelVersion]))

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTTrait/Name
  :cognitect.aws.comprehendmedical/SNOMEDCTTraitName)

(s/def :cognitect.aws.comprehendmedical.SNOMEDCTTrait/Score :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTConcept/Description
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTConcept/Code
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTConcept/Score
  :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.StopICD10CMInferenceJobRequest/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.RxNormConcept/Description
  :cognitect.aws.comprehendmedical/String)

(s/def :cognitect.aws.comprehendmedical.RxNormConcept/Code :cognitect.aws.comprehendmedical/String)

(s/def :cognitect.aws.comprehendmedical.RxNormConcept/Score :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMConcept/Description
  :cognitect.aws.comprehendmedical/String)

(s/def :cognitect.aws.comprehendmedical.ICD10CMConcept/Code :cognitect.aws.comprehendmedical/String)

(s/def :cognitect.aws.comprehendmedical.ICD10CMConcept/Score :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.RxNormEntity/EndOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.RxNormEntity/Score :cognitect.aws.comprehendmedical/Float)

(s/def :cognitect.aws.comprehendmedical.RxNormEntity/Id :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.RxNormEntity/BeginOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.RxNormEntity/Category
  :cognitect.aws.comprehendmedical/RxNormEntityCategory)

(s/def
  :cognitect.aws.comprehendmedical.RxNormEntity/RxNormConcepts
  :cognitect.aws.comprehendmedical/RxNormConceptList)

(s/def
  :cognitect.aws.comprehendmedical.RxNormEntity/Text
  :cognitect.aws.comprehendmedical/OntologyLinkingBoundedLengthString)

(s/def
  :cognitect.aws.comprehendmedical.RxNormEntity/Traits
  :cognitect.aws.comprehendmedical/RxNormTraitList)

(s/def
  :cognitect.aws.comprehendmedical.RxNormEntity/Type
  :cognitect.aws.comprehendmedical/RxNormEntityType)

(s/def
  :cognitect.aws.comprehendmedical.RxNormEntity/Attributes
  :cognitect.aws.comprehendmedical/RxNormAttributeList)

(s/def
  :cognitect.aws.comprehendmedical.DescribeICD10CMInferenceJobRequest/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.DescribeRxNormInferenceJobRequest/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.StopPHIDetectionJobRequest/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesRequest/Text
  :cognitect.aws.comprehendmedical/BoundedLengthString)

(s/def
  :cognitect.aws.comprehendmedical.StopSNOMEDCTInferenceJobResponse/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.DescribePHIDetectionJobResponse/ComprehendMedicalAsyncJobProperties
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobProperties)

(s/def
  :cognitect.aws.comprehendmedical.RxNormAttribute/Type
  :cognitect.aws.comprehendmedical/RxNormAttributeType)

(s/def
  :cognitect.aws.comprehendmedical.RxNormAttribute/Score
  :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.RxNormAttribute/RelationshipScore
  :cognitect.aws.comprehendmedical/Float)

(s/def :cognitect.aws.comprehendmedical.RxNormAttribute/Id :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.RxNormAttribute/BeginOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.RxNormAttribute/EndOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.RxNormAttribute/Text
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.RxNormAttribute/Traits
  :cognitect.aws.comprehendmedical/RxNormTraitList)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesV2Request/Text
  :cognitect.aws.comprehendmedical/BoundedLengthString)

(s/def
  :cognitect.aws.comprehendmedical.ListICD10CMInferenceJobsRequest/Filter
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobFilter)

(s/def
  :cognitect.aws.comprehendmedical.ListICD10CMInferenceJobsRequest/NextToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.ListICD10CMInferenceJobsRequest/MaxResults
  :cognitect.aws.comprehendmedical/MaxResultsInteger)

(s/def
  :cognitect.aws.comprehendmedical.ListSNOMEDCTInferenceJobsResponse/ComprehendMedicalAsyncJobPropertiesList
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobPropertiesList)

(s/def
  :cognitect.aws.comprehendmedical.ListSNOMEDCTInferenceJobsResponse/NextToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesResponse/Entities
  :cognitect.aws.comprehendmedical/EntityList)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesResponse/UnmappedAttributes
  :cognitect.aws.comprehendmedical/UnmappedAttributeList)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesResponse/PaginationToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesResponse/ModelVersion
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.DescribeSNOMEDCTInferenceJobResponse/ComprehendMedicalAsyncJobProperties
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobProperties)

(s/def
  :cognitect.aws.comprehendmedical.StopRxNormInferenceJobResponse/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.InferRxNormRequest/Text
  :cognitect.aws.comprehendmedical/OntologyLinkingBoundedLengthString)

(s/def
  :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/InputDataConfig
  :cognitect.aws.comprehendmedical/InputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/OutputDataConfig
  :cognitect.aws.comprehendmedical/OutputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/DataAccessRoleArn
  :cognitect.aws.comprehendmedical/IamRoleArn)

(s/def
  :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/JobName
  :cognitect.aws.comprehendmedical/JobName)

(s/def
  :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/ClientRequestToken
  :cognitect.aws.comprehendmedical/ClientRequestTokenString)

(s/def
  :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/KMSKey
  :cognitect.aws.comprehendmedical/KMSKey)

(s/def
  :cognitect.aws.comprehendmedical.StartRxNormInferenceJobRequest/LanguageCode
  :cognitect.aws.comprehendmedical/LanguageCode)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobFilter/JobName
  :cognitect.aws.comprehendmedical/JobName)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobFilter/JobStatus
  :cognitect.aws.comprehendmedical/JobStatus)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobFilter/SubmitTimeBefore
  :cognitect.aws.comprehendmedical/Timestamp)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobFilter/SubmitTimeAfter
  :cognitect.aws.comprehendmedical/Timestamp)

(s/def
  :cognitect.aws.comprehendmedical.ListEntitiesDetectionV2JobsRequest/Filter
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobFilter)

(s/def
  :cognitect.aws.comprehendmedical.ListEntitiesDetectionV2JobsRequest/NextToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.ListEntitiesDetectionV2JobsRequest/MaxResults
  :cognitect.aws.comprehendmedical/MaxResultsInteger)

(s/def
  :cognitect.aws.comprehendmedical.DetectPHIRequest/Text
  :cognitect.aws.comprehendmedical/BoundedLengthString)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMEntity/EndOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.ICD10CMEntity/Score :cognitect.aws.comprehendmedical/Float)

(s/def :cognitect.aws.comprehendmedical.ICD10CMEntity/Id :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMEntity/BeginOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMEntity/Category
  :cognitect.aws.comprehendmedical/ICD10CMEntityCategory)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMEntity/ICD10CMConcepts
  :cognitect.aws.comprehendmedical/ICD10CMConceptList)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMEntity/Text
  :cognitect.aws.comprehendmedical/OntologyLinkingBoundedLengthString)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMEntity/Traits
  :cognitect.aws.comprehendmedical/ICD10CMTraitList)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMEntity/Type
  :cognitect.aws.comprehendmedical/ICD10CMEntityType)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMEntity/Attributes
  :cognitect.aws.comprehendmedical/ICD10CMAttributeList)

(s/def
  :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobResponse/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.StopEntitiesDetectionV2JobRequest/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTDetails/Edition
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTDetails/Language
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTDetails/VersionDate
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.Characters/OriginalTextCharacters
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.StartPHIDetectionJobResponse/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.StopEntitiesDetectionV2JobResponse/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.ListRxNormInferenceJobsResponse/ComprehendMedicalAsyncJobPropertiesList
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobPropertiesList)

(s/def
  :cognitect.aws.comprehendmedical.ListRxNormInferenceJobsResponse/NextToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMAttribute/EndOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMAttribute/Score
  :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMAttribute/Id
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMAttribute/RelationshipScore
  :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMAttribute/BeginOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMAttribute/RelationshipType
  :cognitect.aws.comprehendmedical/ICD10CMRelationshipType)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMAttribute/Category
  :cognitect.aws.comprehendmedical/ICD10CMEntityType)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMAttribute/Text
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMAttribute/Traits
  :cognitect.aws.comprehendmedical/ICD10CMTraitList)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMAttribute/Type
  :cognitect.aws.comprehendmedical/ICD10CMAttributeType)

(s/def
  :cognitect.aws.comprehendmedical.OutputDataConfig/S3Bucket
  :cognitect.aws.comprehendmedical/S3Bucket)

(s/def
  :cognitect.aws.comprehendmedical.OutputDataConfig/S3Key
  :cognitect.aws.comprehendmedical/S3Key)

(s/def
  :cognitect.aws.comprehendmedical.DescribeSNOMEDCTInferenceJobRequest/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.ListRxNormInferenceJobsRequest/Filter
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobFilter)

(s/def
  :cognitect.aws.comprehendmedical.ListRxNormInferenceJobsRequest/NextToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.ListRxNormInferenceJobsRequest/MaxResults
  :cognitect.aws.comprehendmedical/MaxResultsInteger)

(s/def
  :cognitect.aws.comprehendmedical.ListPHIDetectionJobsResponse/ComprehendMedicalAsyncJobPropertiesList
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobPropertiesList)

(s/def
  :cognitect.aws.comprehendmedical.ListPHIDetectionJobsResponse/NextToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/EndOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Score
  :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Id
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/RelationshipScore
  :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/BeginOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/RelationshipType
  :cognitect.aws.comprehendmedical/SNOMEDCTRelationshipType)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Category
  :cognitect.aws.comprehendmedical/SNOMEDCTEntityCategory)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Text
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Traits
  :cognitect.aws.comprehendmedical/SNOMEDCTTraitList)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/Type
  :cognitect.aws.comprehendmedical/SNOMEDCTAttributeType)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTAttribute/SNOMEDCTConcepts
  :cognitect.aws.comprehendmedical/SNOMEDCTConceptList)

(s/def :cognitect.aws.comprehendmedical.Trait/Name :cognitect.aws.comprehendmedical/AttributeName)

(s/def :cognitect.aws.comprehendmedical.Trait/Score :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.InferICD10CMResponse/Entities
  :cognitect.aws.comprehendmedical/ICD10CMEntityList)

(s/def
  :cognitect.aws.comprehendmedical.InferICD10CMResponse/PaginationToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.InferICD10CMResponse/ModelVersion
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobResponse/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.DescribePHIDetectionJobRequest/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.DetectPHIResponse/Entities
  :cognitect.aws.comprehendmedical/EntityList)

(s/def
  :cognitect.aws.comprehendmedical.DetectPHIResponse/PaginationToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.DetectPHIResponse/ModelVersion
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.DescribeRxNormInferenceJobResponse/ComprehendMedicalAsyncJobProperties
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobProperties)

(s/def
  :cognitect.aws.comprehendmedical.StopICD10CMInferenceJobResponse/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/JobName
  :cognitect.aws.comprehendmedical/JobName)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/EndTime
  :cognitect.aws.comprehendmedical/Timestamp)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/ManifestFilePath
  :cognitect.aws.comprehendmedical/ManifestFilePath)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/Message
  :cognitect.aws.comprehendmedical/AnyLengthString)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/JobStatus
  :cognitect.aws.comprehendmedical/JobStatus)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/KMSKey
  :cognitect.aws.comprehendmedical/KMSKey)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/ExpirationTime
  :cognitect.aws.comprehendmedical/Timestamp)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/DataAccessRoleArn
  :cognitect.aws.comprehendmedical/IamRoleArn)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/OutputDataConfig
  :cognitect.aws.comprehendmedical/OutputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/ModelVersion
  :cognitect.aws.comprehendmedical/ModelVersion)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/SubmitTime
  :cognitect.aws.comprehendmedical/Timestamp)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/InputDataConfig
  :cognitect.aws.comprehendmedical/InputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.ComprehendMedicalAsyncJobProperties/LanguageCode
  :cognitect.aws.comprehendmedical/LanguageCode)

(s/def
  :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/InputDataConfig
  :cognitect.aws.comprehendmedical/InputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/OutputDataConfig
  :cognitect.aws.comprehendmedical/OutputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/DataAccessRoleArn
  :cognitect.aws.comprehendmedical/IamRoleArn)

(s/def
  :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/JobName
  :cognitect.aws.comprehendmedical/JobName)

(s/def
  :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/ClientRequestToken
  :cognitect.aws.comprehendmedical/ClientRequestTokenString)

(s/def
  :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/KMSKey
  :cognitect.aws.comprehendmedical/KMSKey)

(s/def
  :cognitect.aws.comprehendmedical.StartSNOMEDCTInferenceJobRequest/LanguageCode
  :cognitect.aws.comprehendmedical/LanguageCode)

(s/def
  :cognitect.aws.comprehendmedical.DescribeEntitiesDetectionV2JobRequest/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.DescribeICD10CMInferenceJobResponse/ComprehendMedicalAsyncJobProperties
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobProperties)

(s/def
  :cognitect.aws.comprehendmedical.ListICD10CMInferenceJobsResponse/ComprehendMedicalAsyncJobPropertiesList
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobPropertiesList)

(s/def
  :cognitect.aws.comprehendmedical.ListICD10CMInferenceJobsResponse/NextToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesV2Response/Entities
  :cognitect.aws.comprehendmedical/EntityList)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesV2Response/UnmappedAttributes
  :cognitect.aws.comprehendmedical/UnmappedAttributeList)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesV2Response/PaginationToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.DetectEntitiesV2Response/ModelVersion
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobResponse/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.DescribeEntitiesDetectionV2JobResponse/ComprehendMedicalAsyncJobProperties
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobProperties)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTEntity/EndOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Score :cognitect.aws.comprehendmedical/Float)

(s/def :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Id :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTEntity/BeginOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Category
  :cognitect.aws.comprehendmedical/SNOMEDCTEntityCategory)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Text
  :cognitect.aws.comprehendmedical/OntologyLinkingBoundedLengthString)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Traits
  :cognitect.aws.comprehendmedical/SNOMEDCTTraitList)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Type
  :cognitect.aws.comprehendmedical/SNOMEDCTEntityType)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTEntity/Attributes
  :cognitect.aws.comprehendmedical/SNOMEDCTAttributeList)

(s/def
  :cognitect.aws.comprehendmedical.SNOMEDCTEntity/SNOMEDCTConcepts
  :cognitect.aws.comprehendmedical/SNOMEDCTConceptList)

(s/def
  :cognitect.aws.comprehendmedical.InferICD10CMRequest/Text
  :cognitect.aws.comprehendmedical/OntologyLinkingBoundedLengthString)

(s/def
  :cognitect.aws.comprehendmedical.UnmappedAttribute/Type
  :cognitect.aws.comprehendmedical/EntityType)

(s/def
  :cognitect.aws.comprehendmedical.UnmappedAttribute/Attribute
  :cognitect.aws.comprehendmedical/Attribute)

(s/def
  :cognitect.aws.comprehendmedical.StopSNOMEDCTInferenceJobRequest/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.ListPHIDetectionJobsRequest/Filter
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobFilter)

(s/def
  :cognitect.aws.comprehendmedical.ListPHIDetectionJobsRequest/NextToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.ListPHIDetectionJobsRequest/MaxResults
  :cognitect.aws.comprehendmedical/MaxResultsInteger)

(s/def
  :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/InputDataConfig
  :cognitect.aws.comprehendmedical/InputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/OutputDataConfig
  :cognitect.aws.comprehendmedical/OutputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/DataAccessRoleArn
  :cognitect.aws.comprehendmedical/IamRoleArn)

(s/def
  :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/JobName
  :cognitect.aws.comprehendmedical/JobName)

(s/def
  :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/ClientRequestToken
  :cognitect.aws.comprehendmedical/ClientRequestTokenString)

(s/def
  :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/KMSKey
  :cognitect.aws.comprehendmedical/KMSKey)

(s/def
  :cognitect.aws.comprehendmedical.StartPHIDetectionJobRequest/LanguageCode
  :cognitect.aws.comprehendmedical/LanguageCode)

(s/def
  :cognitect.aws.comprehendmedical.Attribute/EndOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.Attribute/Score :cognitect.aws.comprehendmedical/Float)

(s/def :cognitect.aws.comprehendmedical.Attribute/Id :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.Attribute/RelationshipScore
  :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.Attribute/BeginOffset
  :cognitect.aws.comprehendmedical/Integer)

(s/def
  :cognitect.aws.comprehendmedical.Attribute/RelationshipType
  :cognitect.aws.comprehendmedical/RelationshipType)

(s/def
  :cognitect.aws.comprehendmedical.Attribute/Category
  :cognitect.aws.comprehendmedical/EntityType)

(s/def :cognitect.aws.comprehendmedical.Attribute/Text :cognitect.aws.comprehendmedical/String)

(s/def :cognitect.aws.comprehendmedical.Attribute/Traits :cognitect.aws.comprehendmedical/TraitList)

(s/def
  :cognitect.aws.comprehendmedical.Attribute/Type
  :cognitect.aws.comprehendmedical/EntitySubType)

(s/def
  :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/InputDataConfig
  :cognitect.aws.comprehendmedical/InputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/OutputDataConfig
  :cognitect.aws.comprehendmedical/OutputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/DataAccessRoleArn
  :cognitect.aws.comprehendmedical/IamRoleArn)

(s/def
  :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/JobName
  :cognitect.aws.comprehendmedical/JobName)

(s/def
  :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/ClientRequestToken
  :cognitect.aws.comprehendmedical/ClientRequestTokenString)

(s/def
  :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/KMSKey
  :cognitect.aws.comprehendmedical/KMSKey)

(s/def
  :cognitect.aws.comprehendmedical.StartICD10CMInferenceJobRequest/LanguageCode
  :cognitect.aws.comprehendmedical/LanguageCode)

(s/def
  :cognitect.aws.comprehendmedical.ListEntitiesDetectionV2JobsResponse/ComprehendMedicalAsyncJobPropertiesList
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobPropertiesList)

(s/def
  :cognitect.aws.comprehendmedical.ListEntitiesDetectionV2JobsResponse/NextToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.InputDataConfig/S3Bucket
  :cognitect.aws.comprehendmedical/S3Bucket)

(s/def
  :cognitect.aws.comprehendmedical.InputDataConfig/S3Key
  :cognitect.aws.comprehendmedical/S3Key)

(s/def
  :cognitect.aws.comprehendmedical.ListSNOMEDCTInferenceJobsRequest/Filter
  :cognitect.aws.comprehendmedical/ComprehendMedicalAsyncJobFilter)

(s/def
  :cognitect.aws.comprehendmedical.ListSNOMEDCTInferenceJobsRequest/NextToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.ListSNOMEDCTInferenceJobsRequest/MaxResults
  :cognitect.aws.comprehendmedical/MaxResultsInteger)

(s/def
  :cognitect.aws.comprehendmedical.InferSNOMEDCTResponse/Entities
  :cognitect.aws.comprehendmedical/SNOMEDCTEntityList)

(s/def
  :cognitect.aws.comprehendmedical.InferSNOMEDCTResponse/PaginationToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.InferSNOMEDCTResponse/ModelVersion
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.InferSNOMEDCTResponse/SNOMEDCTDetails
  :cognitect.aws.comprehendmedical/SNOMEDCTDetails)

(s/def
  :cognitect.aws.comprehendmedical.InferSNOMEDCTResponse/Characters
  :cognitect.aws.comprehendmedical/Characters)

(s/def
  :cognitect.aws.comprehendmedical.StopPHIDetectionJobResponse/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.InferSNOMEDCTRequest/Text
  :cognitect.aws.comprehendmedical/OntologyLinkingBoundedLengthString)

(s/def
  :cognitect.aws.comprehendmedical.RxNormTrait/Name
  :cognitect.aws.comprehendmedical/RxNormTraitName)

(s/def :cognitect.aws.comprehendmedical.RxNormTrait/Score :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/InputDataConfig
  :cognitect.aws.comprehendmedical/InputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/OutputDataConfig
  :cognitect.aws.comprehendmedical/OutputDataConfig)

(s/def
  :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/DataAccessRoleArn
  :cognitect.aws.comprehendmedical/IamRoleArn)

(s/def
  :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/JobName
  :cognitect.aws.comprehendmedical/JobName)

(s/def
  :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/ClientRequestToken
  :cognitect.aws.comprehendmedical/ClientRequestTokenString)

(s/def
  :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/KMSKey
  :cognitect.aws.comprehendmedical/KMSKey)

(s/def
  :cognitect.aws.comprehendmedical.StartEntitiesDetectionV2JobRequest/LanguageCode
  :cognitect.aws.comprehendmedical/LanguageCode)

(s/def
  :cognitect.aws.comprehendmedical.StartRxNormInferenceJobResponse/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def :cognitect.aws.comprehendmedical.Entity/EndOffset :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.Entity/Score :cognitect.aws.comprehendmedical/Float)

(s/def :cognitect.aws.comprehendmedical.Entity/Id :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.Entity/BeginOffset :cognitect.aws.comprehendmedical/Integer)

(s/def :cognitect.aws.comprehendmedical.Entity/Category :cognitect.aws.comprehendmedical/EntityType)

(s/def :cognitect.aws.comprehendmedical.Entity/Text :cognitect.aws.comprehendmedical/String)

(s/def :cognitect.aws.comprehendmedical.Entity/Traits :cognitect.aws.comprehendmedical/TraitList)

(s/def :cognitect.aws.comprehendmedical.Entity/Type :cognitect.aws.comprehendmedical/EntitySubType)

(s/def
  :cognitect.aws.comprehendmedical.Entity/Attributes
  :cognitect.aws.comprehendmedical/AttributeList)

(s/def
  :cognitect.aws.comprehendmedical.StopRxNormInferenceJobRequest/JobId
  :cognitect.aws.comprehendmedical/JobId)

(s/def
  :cognitect.aws.comprehendmedical.ICD10CMTrait/Name
  :cognitect.aws.comprehendmedical/ICD10CMTraitName)

(s/def :cognitect.aws.comprehendmedical.ICD10CMTrait/Score :cognitect.aws.comprehendmedical/Float)

(s/def
  :cognitect.aws.comprehendmedical.InferRxNormResponse/Entities
  :cognitect.aws.comprehendmedical/RxNormEntityList)

(s/def
  :cognitect.aws.comprehendmedical.InferRxNormResponse/PaginationToken
  :cognitect.aws.comprehendmedical/String)

(s/def
  :cognitect.aws.comprehendmedical.InferRxNormResponse/ModelVersion
  :cognitect.aws.comprehendmedical/String)

