;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.connect.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.connect/AssociationId
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SearchContactFlowModulesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchContactFlowModulesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchContactFlowModulesRequest/NextToken
     :cognitect.aws.connect.SearchContactFlowModulesRequest/SearchFilter
     :cognitect.aws.connect.SearchContactFlowModulesRequest/SearchCriteria
     :cognitect.aws.connect.SearchContactFlowModulesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/DescribeViewRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeViewRequest/InstanceId
     :cognitect.aws.connect.DescribeViewRequest/ViewId]))

(s/def
  :cognitect.aws.connect/EvaluationFormNumericQuestionProperties
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormNumericQuestionProperties/MinValue
     :cognitect.aws.connect.EvaluationFormNumericQuestionProperties/MaxValue]
    :opt-un
    [:cognitect.aws.connect.EvaluationFormNumericQuestionProperties/Automation
     :cognitect.aws.connect.EvaluationFormNumericQuestionProperties/Options]))

(s/def
  :cognitect.aws.connect/DescribeEvaluationFormRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeEvaluationFormRequest/InstanceId
     :cognitect.aws.connect.DescribeEvaluationFormRequest/EvaluationFormId]
    :opt-un
    [:cognitect.aws.connect.DescribeEvaluationFormRequest/EvaluationFormVersion]))

(s/def
  :cognitect.aws.connect/ListLambdaFunctionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListLambdaFunctionsResponse/LambdaFunctions
     :cognitect.aws.connect.ListLambdaFunctionsResponse/NextToken]))

(s/def :cognitect.aws.connect/FieldValues (s/coll-of :cognitect.aws.connect/FieldValue))

(s/def
  :cognitect.aws.connect/HierarchyGroupCondition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HierarchyGroupCondition/HierarchyGroupMatchType
     :cognitect.aws.connect.HierarchyGroupCondition/Value]))

(s/def
  :cognitect.aws.connect/TaskTemplateList
  (s/coll-of :cognitect.aws.connect/TaskTemplateMetadata))

(s/def
  :cognitect.aws.connect/InstanceIdOrArn
  (s/spec
    #(re-matches
      (re-pattern
        "^(arn:(aws|aws-us-gov):connect:[a-z]{2}-[a-z]+-[0-9]{1}:[0-9]{1,20}:instance/)?[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/IpCidr
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9:/]*$") %) :gen #(gen/string)))

(s/def :cognitect.aws.connect/Url string?)

(s/def
  :cognitect.aws.connect/CurrentMetricDataCollections
  (s/coll-of :cognitect.aws.connect/CurrentMetricData))

(s/def :cognitect.aws.connect/InboundMessageSourceType (s/spec string? :gen #(s/gen #{"RAW"})))

(s/def
  :cognitect.aws.connect/TaskTemplateName
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/DimensionsV2Value string?)

(s/def
  :cognitect.aws.connect/ContactFlowVersionSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactFlowVersionSummary/Arn
     :cognitect.aws.connect.ContactFlowVersionSummary/VersionDescription
     :cognitect.aws.connect.ContactFlowVersionSummary/Version]))

(s/def
  :cognitect.aws.connect/RuleName
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z._-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/OutboundRawMessage
  (s/keys
    :req-un
    [:cognitect.aws.connect.OutboundRawMessage/Subject
     :cognitect.aws.connect.OutboundRawMessage/Body
     :cognitect.aws.connect.OutboundRawMessage/ContentType]))

(s/def
  :cognitect.aws.connect/PredefinedAttributeSummaryList
  (s/coll-of :cognitect.aws.connect/PredefinedAttributeSummary))

(s/def
  :cognitect.aws.connect/ThrottlingException
  (s/keys :opt-un [:cognitect.aws.connect.ThrottlingException/Message]))

(s/def
  :cognitect.aws.connect/CreateHoursOfOperationOverrideRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/InstanceId
     :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/HoursOfOperationId
     :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/Name
     :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/Config
     :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/EffectiveFrom
     :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/EffectiveTill]
    :opt-un
    [:cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/Description]))

(s/def
  :cognitect.aws.connect/DescribeAuthenticationProfileResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.DescribeAuthenticationProfileResponse/AuthenticationProfile]))

(s/def
  :cognitect.aws.connect/UseCaseId
  (s/spec
    (s/and string? #(<= 1 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 200) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/GetMetricDataResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.GetMetricDataResponse/MetricResults
     :cognitect.aws.connect.GetMetricDataResponse/NextToken]))

(s/def
  :cognitect.aws.connect/ResourceConflictException
  (s/keys :opt-un [:cognitect.aws.connect.ResourceConflictException/Message]))

(s/def
  :cognitect.aws.connect/GetContactMetricsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetContactMetricsRequest/InstanceId
     :cognitect.aws.connect.GetContactMetricsRequest/ContactId
     :cognitect.aws.connect.GetContactMetricsRequest/Metrics]))

(s/def
  :cognitect.aws.connect/TaskTemplateDefaultFieldValueList
  (s/coll-of :cognitect.aws.connect/TaskTemplateDefaultFieldValue))

(s/def :cognitect.aws.connect/SlaAssignmentType (s/spec string? :gen #(s/gen #{"CASES"})))

(s/def :cognitect.aws.connect/Unit (s/spec string? :gen #(s/gen #{"PERCENT" "COUNT" "SECONDS"})))

(s/def
  :cognitect.aws.connect/PredefinedAttribute
  (s/keys
    :opt-un
    [:cognitect.aws.connect.PredefinedAttribute/Values
     :cognitect.aws.connect.PredefinedAttribute/LastModifiedRegion
     :cognitect.aws.connect.PredefinedAttribute/LastModifiedTime
     :cognitect.aws.connect.PredefinedAttribute/Name]))

(s/def
  :cognitect.aws.connect/LexRegion
  (s/spec
    (s/and string? #(>= 60 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 60) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/SendOutboundEmailResponse (s/keys))

(s/def
  :cognitect.aws.connect/AgentHierarchyGroups
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AgentHierarchyGroups/L1Ids
     :cognitect.aws.connect.AgentHierarchyGroups/L3Ids
     :cognitect.aws.connect.AgentHierarchyGroups/L5Ids
     :cognitect.aws.connect.AgentHierarchyGroups/L2Ids
     :cognitect.aws.connect.AgentHierarchyGroups/L4Ids]))

(s/def
  :cognitect.aws.connect/EvaluationScorePercentage
  (s/spec
    (s/and double? #(<= 0 % 100))
    :gen
    #(gen/double* {:infinite? false, :NaN? false, :min 0, :max 100})))

(s/def
  :cognitect.aws.connect/HierarchyGroups
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HierarchyGroups/Level1
     :cognitect.aws.connect.HierarchyGroups/Level3
     :cognitect.aws.connect.HierarchyGroups/Level5
     :cognitect.aws.connect.HierarchyGroups/Level2
     :cognitect.aws.connect.HierarchyGroups/Level4]))

(s/def
  :cognitect.aws.connect/ServiceQuotaExceededExceptionReason
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ServiceQuotaExceededExceptionReason/AttachedFileServiceQuotaExceededExceptionReason]))

(s/def
  :cognitect.aws.connect/FieldValue
  (s/keys :req-un [:cognitect.aws.connect.FieldValue/Id :cognitect.aws.connect.FieldValue/Value]))

(s/def :cognitect.aws.connect/UpdateContactFlowModuleContentResponse (s/keys))

(s/def
  :cognitect.aws.connect/SearchableContactAttributesCriteria
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchableContactAttributesCriteria/Key
     :cognitect.aws.connect.SearchableContactAttributesCriteria/Values]))

(s/def
  :cognitect.aws.connect/SecurityProfileSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SecurityProfileSummary/LastModifiedRegion
     :cognitect.aws.connect.SecurityProfileSummary/Arn
     :cognitect.aws.connect.SecurityProfileSummary/LastModifiedTime
     :cognitect.aws.connect.SecurityProfileSummary/Name
     :cognitect.aws.connect.SecurityProfileSummary/Id]))

(s/def
  :cognitect.aws.connect/RoutingProfileSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.RoutingProfileSearchFilter/TagFilter]))

(s/def
  :cognitect.aws.connect/DescribeHoursOfOperationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeHoursOfOperationRequest/InstanceId
     :cognitect.aws.connect.DescribeHoursOfOperationRequest/HoursOfOperationId]))

(s/def
  :cognitect.aws.connect/ContactTagKey
  (s/spec #(re-matches (re-pattern "^(?!aws:)[a-zA-Z+-=._:/]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.connect/FunctionArnsList (s/coll-of :cognitect.aws.connect/FunctionArn))

(s/def
  :cognitect.aws.connect/CurrentMetricName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AGENTS_ERROR"
        "AGENTS_AFTER_CONTACT_WORK"
        "SLOTS_ACTIVE"
        "AGENTS_ON_CONTACT"
        "AGENTS_NON_PRODUCTIVE"
        "SLOTS_AVAILABLE"
        "AGENTS_ONLINE"
        "AGENTS_ON_CALL"
        "CONTACTS_IN_QUEUE"
        "OLDEST_CONTACT_AGE"
        "CONTACTS_SCHEDULED"
        "AGENTS_AVAILABLE"
        "AGENTS_STAFFED"})))

(s/def
  :cognitect.aws.connect/DirectoryType
  (s/spec string? :gen #(s/gen #{"SAML" "CONNECT_MANAGED" "EXISTING_DIRECTORY"})))

(s/def
  :cognitect.aws.connect/UpdateQueueNameRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateQueueNameRequest/InstanceId
     :cognitect.aws.connect.UpdateQueueNameRequest/QueueId]
    :opt-un
    [:cognitect.aws.connect.UpdateQueueNameRequest/Description
     :cognitect.aws.connect.UpdateQueueNameRequest/Name]))

(s/def
  :cognitect.aws.connect/AgentStatusOrderNumber
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.connect/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.TagResourceRequest/resourceArn
     :cognitect.aws.connect.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.connect/ParticipantTimerValue
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ParticipantTimerValue/ParticipantTimerDurationInMinutes
     :cognitect.aws.connect.ParticipantTimerValue/ParticipantTimerAction]))

(s/def
  :cognitect.aws.connect/EvaluationAnswersOutputMap
  (s/map-of
    :cognitect.aws.connect/ResourceId
    :cognitect.aws.connect/EvaluationAnswerOutput
    :max-count
    100))

(s/def :cognitect.aws.connect/SecurityToken string?)

(s/def :cognitect.aws.connect/OutboundCallsEnabled boolean?)

(s/def
  :cognitect.aws.connect/ViewsClientToken
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:\\/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def :cognitect.aws.connect/ErrorCode string?)

(s/def :cognitect.aws.connect/UpdateContactAttributesResponse (s/keys))

(s/def
  :cognitect.aws.connect/ListRulesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListRulesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListRulesRequest/NextToken
     :cognitect.aws.connect.ListRulesRequest/EventSourceName
     :cognitect.aws.connect.ListRulesRequest/PublishStatus
     :cognitect.aws.connect.ListRulesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/S3Config
  (s/keys
    :req-un
    [:cognitect.aws.connect.S3Config/BucketName :cognitect.aws.connect.S3Config/BucketPrefix]
    :opt-un
    [:cognitect.aws.connect.S3Config/EncryptionConfig]))

(s/def
  :cognitect.aws.connect/UpdateContactFlowContentRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactFlowContentRequest/InstanceId
     :cognitect.aws.connect.UpdateContactFlowContentRequest/ContactFlowId
     :cognitect.aws.connect.UpdateContactFlowContentRequest/Content]))

(s/def
  :cognitect.aws.connect/ServiceQuotaExceededException
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ServiceQuotaExceededException/Message
     :cognitect.aws.connect.ServiceQuotaExceededException/Reason]))

(s/def
  :cognitect.aws.connect/ContactFlowSearchConditionList
  (s/coll-of :cognitect.aws.connect/ContactFlowSearchCriteria))

(s/def
  :cognitect.aws.connect/EvaluationFormId
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ViewId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\_\\-:\\/$]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptContent
  (s/spec
    (s/and string? #(<= 1 (count %) 16384))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 16384) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ResourceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"HIERARCHY_LEVEL"
        "USER"
        "HIERARCHY_GROUP"
        "CONTACT_FLOW"
        "INSTANCE"
        "CONTACT"
        "PHONE_NUMBER"
        "PARTICIPANT"})))

(s/def
  :cognitect.aws.connect/UpdateTaskTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateTaskTemplateRequest/TaskTemplateId
     :cognitect.aws.connect.UpdateTaskTemplateRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.UpdateTaskTemplateRequest/ContactFlowId
     :cognitect.aws.connect.UpdateTaskTemplateRequest/Fields
     :cognitect.aws.connect.UpdateTaskTemplateRequest/Status
     :cognitect.aws.connect.UpdateTaskTemplateRequest/SelfAssignFlowId
     :cognitect.aws.connect.UpdateTaskTemplateRequest/Description
     :cognitect.aws.connect.UpdateTaskTemplateRequest/Defaults
     :cognitect.aws.connect.UpdateTaskTemplateRequest/Name
     :cognitect.aws.connect.UpdateTaskTemplateRequest/Constraints]))

(s/def
  :cognitect.aws.connect/AllowedMonitorCapabilities
  (s/coll-of :cognitect.aws.connect/MonitorCapability :max-count 2))

(s/def :cognitect.aws.connect/ViewTemplate string?)

(s/def
  :cognitect.aws.connect/ListAnalyticsDataLakeDataSetsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListAnalyticsDataLakeDataSetsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListAnalyticsDataLakeDataSetsRequest/NextToken
     :cognitect.aws.connect.ListAnalyticsDataLakeDataSetsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/CommonAttributeAndCondition
  (s/keys :opt-un [:cognitect.aws.connect.CommonAttributeAndCondition/TagConditions]))

(s/def
  :cognitect.aws.connect/ListQuickConnectsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListQuickConnectsResponse/NextToken
     :cognitect.aws.connect.ListQuickConnectsResponse/QuickConnectSummaryList]))

(s/def
  :cognitect.aws.connect/CreateVocabularyRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateVocabularyRequest/InstanceId
     :cognitect.aws.connect.CreateVocabularyRequest/VocabularyName
     :cognitect.aws.connect.CreateVocabularyRequest/LanguageCode
     :cognitect.aws.connect.CreateVocabularyRequest/Content]
    :opt-un
    [:cognitect.aws.connect.CreateVocabularyRequest/Tags
     :cognitect.aws.connect.CreateVocabularyRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptItemsWithContent
  (s/coll-of :cognitect.aws.connect/RealTimeContactAnalysisTranscriptItemWithContent))

(s/def
  :cognitect.aws.connect/DeviceToken
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/Expressions (s/coll-of :cognitect.aws.connect/Expression))

(s/def
  :cognitect.aws.connect/IntegrationAssociationSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.IntegrationAssociationSummary/InstanceId
     :cognitect.aws.connect.IntegrationAssociationSummary/SourceApplicationUrl
     :cognitect.aws.connect.IntegrationAssociationSummary/SourceType
     :cognitect.aws.connect.IntegrationAssociationSummary/SourceApplicationName
     :cognitect.aws.connect.IntegrationAssociationSummary/IntegrationType
     :cognitect.aws.connect.IntegrationAssociationSummary/IntegrationAssociationId
     :cognitect.aws.connect.IntegrationAssociationSummary/IntegrationAssociationArn
     :cognitect.aws.connect.IntegrationAssociationSummary/IntegrationArn]))

(s/def
  :cognitect.aws.connect/QuickConnectSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.QuickConnectSummary/QuickConnectType
     :cognitect.aws.connect.QuickConnectSummary/LastModifiedRegion
     :cognitect.aws.connect.QuickConnectSummary/Arn
     :cognitect.aws.connect.QuickConnectSummary/LastModifiedTime
     :cognitect.aws.connect.QuickConnectSummary/Name
     :cognitect.aws.connect.QuickConnectSummary/Id]))

(s/def
  :cognitect.aws.connect/UserHierarchyGroupSearchConditionList
  (s/coll-of :cognitect.aws.connect/UserHierarchyGroupSearchCriteria))

(s/def
  :cognitect.aws.connect/DisassociateSecurityKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateSecurityKeyRequest/InstanceId
     :cognitect.aws.connect.DisassociateSecurityKeyRequest/AssociationId]
    :opt-un
    [:cognitect.aws.connect.DisassociateSecurityKeyRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/HierarchyPath
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HierarchyPath/LevelFour
     :cognitect.aws.connect.HierarchyPath/LevelOne
     :cognitect.aws.connect.HierarchyPath/LevelTwo
     :cognitect.aws.connect.HierarchyPath/LevelThree
     :cognitect.aws.connect.HierarchyPath/LevelFive]))

(s/def
  :cognitect.aws.connect/VocabularyContent
  (s/spec
    (s/and string? #(<= 1 (count %) 60000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 60000) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/IncludeRawMessage boolean?)

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentType
  (s/spec
    string?
    :gen
    #(s/gen #{"Categories" "Event" "Attachments" "Transcript" "PostContactSummary" "Issues"})))

(s/def
  :cognitect.aws.connect/ChatEventType
  (s/spec string? :gen #(s/gen #{"DISCONNECT" "EVENT" "MESSAGE"})))

(s/def
  :cognitect.aws.connect/ResumeContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ResumeContactRequest/ContactId
     :cognitect.aws.connect.ResumeContactRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ResumeContactRequest/ContactFlowId]))

(s/def
  :cognitect.aws.connect/EvaluationSummaryList
  (s/coll-of :cognitect.aws.connect/EvaluationSummary))

(s/def
  :cognitect.aws.connect/PredefinedAttributeValues
  (s/keys :opt-un [:cognitect.aws.connect.PredefinedAttributeValues/StringList]))

(s/def
  :cognitect.aws.connect/View
  (s/keys
    :opt-un
    [:cognitect.aws.connect.View/Type
     :cognitect.aws.connect.View/ViewContentSha256
     :cognitect.aws.connect.View/Tags
     :cognitect.aws.connect.View/Status
     :cognitect.aws.connect.View/CreatedTime
     :cognitect.aws.connect.View/Description
     :cognitect.aws.connect.View/Content
     :cognitect.aws.connect.View/Arn
     :cognitect.aws.connect.View/VersionDescription
     :cognitect.aws.connect.View/Version
     :cognitect.aws.connect.View/LastModifiedTime
     :cognitect.aws.connect.View/Name
     :cognitect.aws.connect.View/Id]))

(s/def
  :cognitect.aws.connect/ListPromptsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListPromptsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListPromptsRequest/NextToken
     :cognitect.aws.connect.ListPromptsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/DeleteHoursOfOperationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteHoursOfOperationRequest/InstanceId
     :cognitect.aws.connect.DeleteHoursOfOperationRequest/HoursOfOperationId]))

(s/def
  :cognitect.aws.connect/QueueInfo
  (s/keys
    :opt-un
    [:cognitect.aws.connect.QueueInfo/Id :cognitect.aws.connect.QueueInfo/EnqueueTimestamp]))

(s/def
  :cognitect.aws.connect/MaxResult25
  (s/spec (s/and int? #(<= 1 % 25)) :gen #(gen/choose 1 25)))

(s/def
  :cognitect.aws.connect/DisassociateUserProficienciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateUserProficienciesRequest/InstanceId
     :cognitect.aws.connect.DisassociateUserProficienciesRequest/UserId
     :cognitect.aws.connect.DisassociateUserProficienciesRequest/UserProficiencies]))

(s/def
  :cognitect.aws.connect/SearchContactFlowsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchContactFlowsResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchContactFlowsResponse/NextToken
     :cognitect.aws.connect.SearchContactFlowsResponse/ContactFlows]))

(s/def
  :cognitect.aws.connect/StartContactEvaluationResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartContactEvaluationResponse/EvaluationId
     :cognitect.aws.connect.StartContactEvaluationResponse/EvaluationArn]))

(s/def
  :cognitect.aws.connect/InternalServiceException
  (s/keys :opt-un [:cognitect.aws.connect.InternalServiceException/Message]))

(s/def :cognitect.aws.connect/OperationalHours (s/coll-of :cognitect.aws.connect/OperationalHour))

(s/def
  :cognitect.aws.connect/AgentConfig
  (s/keys :req-un [:cognitect.aws.connect.AgentConfig/Distributions]))

(s/def :cognitect.aws.connect/ResourceTypeList (s/coll-of :cognitect.aws.connect/String))

(s/def
  :cognitect.aws.connect/ListPhoneNumbersV2Request
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListPhoneNumbersV2Request/InstanceId
     :cognitect.aws.connect.ListPhoneNumbersV2Request/TargetArn
     :cognitect.aws.connect.ListPhoneNumbersV2Request/NextToken
     :cognitect.aws.connect.ListPhoneNumbersV2Request/PhoneNumberCountryCodes
     :cognitect.aws.connect.ListPhoneNumbersV2Request/PhoneNumberTypes
     :cognitect.aws.connect.ListPhoneNumbersV2Request/MaxResults
     :cognitect.aws.connect.ListPhoneNumbersV2Request/PhoneNumberPrefix]))

(s/def
  :cognitect.aws.connect/HistoricalMetricData
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HistoricalMetricData/Value
     :cognitect.aws.connect.HistoricalMetricData/Metric]))

(s/def :cognitect.aws.connect/PhoneNumberId string?)

(s/def
  :cognitect.aws.connect/CreatePersistentContactAssociationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreatePersistentContactAssociationRequest/InstanceId
     :cognitect.aws.connect.CreatePersistentContactAssociationRequest/InitialContactId
     :cognitect.aws.connect.CreatePersistentContactAssociationRequest/RehydrationType
     :cognitect.aws.connect.CreatePersistentContactAssociationRequest/SourceContactId]
    :opt-un
    [:cognitect.aws.connect.CreatePersistentContactAssociationRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptItemsWithCharacterOffsets
  (s/coll-of
    :cognitect.aws.connect/RealTimeContactAnalysisTranscriptItemWithCharacterOffsets
    :min-count
    0
    :max-count
    10))

(s/def
  :cognitect.aws.connect/PutUserStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.PutUserStatusRequest/UserId
     :cognitect.aws.connect.PutUserStatusRequest/InstanceId
     :cognitect.aws.connect.PutUserStatusRequest/AgentStatusId]))

(s/def
  :cognitect.aws.connect/AssociateDefaultVocabularyRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateDefaultVocabularyRequest/InstanceId
     :cognitect.aws.connect.AssociateDefaultVocabularyRequest/LanguageCode]
    :opt-un
    [:cognitect.aws.connect.AssociateDefaultVocabularyRequest/VocabularyId]))

(s/def
  :cognitect.aws.connect/UrlMetadataSignedHeaders
  (s/map-of
    :cognitect.aws.connect/UrlMetadataSignedHeadersKey
    :cognitect.aws.connect/UrlMetadataSignedHeadersValue))

(s/def
  :cognitect.aws.connect/FlowAssociationSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.FlowAssociationSummary/FlowId
     :cognitect.aws.connect.FlowAssociationSummary/ResourceId
     :cognitect.aws.connect.FlowAssociationSummary/ResourceType]))

(s/def
  :cognitect.aws.connect/UpdateQuickConnectDescription
  (s/spec
    (s/and string? #(<= 0 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 250) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DeleteContactFlowModuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteContactFlowModuleRequest/InstanceId
     :cognitect.aws.connect.DeleteContactFlowModuleRequest/ContactFlowModuleId]))

(s/def
  :cognitect.aws.connect/SecurityProfileSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SecurityProfileSearchCriteria/OrConditions
     :cognitect.aws.connect.SecurityProfileSearchCriteria/StringCondition
     :cognitect.aws.connect.SecurityProfileSearchCriteria/AndConditions]))

(s/def :cognitect.aws.connect/ViewInputSchema string?)

(s/def
  :cognitect.aws.connect/ControlPlaneAttributeFilter
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ControlPlaneAttributeFilter/AndCondition
     :cognitect.aws.connect.ControlPlaneAttributeFilter/TagCondition
     :cognitect.aws.connect.ControlPlaneAttributeFilter/OrConditions]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentTranscript
  (s/keys
    :req-un
    [:cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/Id
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/ParticipantId
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/ParticipantRole
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/Content
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/Time]
    :opt-un
    [:cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/Sentiment
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/ContentType
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/DisplayName
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/Redaction]))

(s/def
  :cognitect.aws.connect/ListRoutingProfileQueuesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListRoutingProfileQueuesResponse/NextToken
     :cognitect.aws.connect.ListRoutingProfileQueuesResponse/LastModifiedRegion
     :cognitect.aws.connect.ListRoutingProfileQueuesResponse/LastModifiedTime
     :cognitect.aws.connect.ListRoutingProfileQueuesResponse/RoutingProfileQueueConfigSummaryList]))

(s/def
  :cognitect.aws.connect/AgentStatusReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AgentStatusReference/StatusName
     :cognitect.aws.connect.AgentStatusReference/StatusStartTimestamp
     :cognitect.aws.connect.AgentStatusReference/StatusArn]))

(s/def
  :cognitect.aws.connect/EvaluationSummary
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationSummary/EvaluationId
     :cognitect.aws.connect.EvaluationSummary/EvaluationArn
     :cognitect.aws.connect.EvaluationSummary/EvaluationFormTitle
     :cognitect.aws.connect.EvaluationSummary/EvaluationFormId
     :cognitect.aws.connect.EvaluationSummary/Status
     :cognitect.aws.connect.EvaluationSummary/EvaluatorArn
     :cognitect.aws.connect.EvaluationSummary/CreatedTime
     :cognitect.aws.connect.EvaluationSummary/LastModifiedTime]
    :opt-un
    [:cognitect.aws.connect.EvaluationSummary/Score]))

(s/def
  :cognitect.aws.connect/DefaultVocabulary
  (s/keys
    :req-un
    [:cognitect.aws.connect.DefaultVocabulary/InstanceId
     :cognitect.aws.connect.DefaultVocabulary/LanguageCode
     :cognitect.aws.connect.DefaultVocabulary/VocabularyId
     :cognitect.aws.connect.DefaultVocabulary/VocabularyName]))

(s/def
  :cognitect.aws.connect/UserIdentityInfoLite
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UserIdentityInfoLite/LastName
     :cognitect.aws.connect.UserIdentityInfoLite/FirstName]))

(s/def
  :cognitect.aws.connect/RehydrationType
  (s/spec string? :gen #(s/gen #{"ENTIRE_PAST_SESSION" "FROM_SEGMENT"})))

(s/def
  :cognitect.aws.connect/TemplateId
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/CreateUserResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateUserResponse/UserId
     :cognitect.aws.connect.CreateUserResponse/UserArn]))

(s/def
  :cognitect.aws.connect/TaskTemplateStatus
  (s/spec string? :gen #(s/gen #{"INACTIVE" "ACTIVE"})))

(s/def :cognitect.aws.connect/RealTimeContactAnalysisTimeInstant inst?)

(s/def
  :cognitect.aws.connect/DeleteEmailAddressRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteEmailAddressRequest/InstanceId
     :cognitect.aws.connect.DeleteEmailAddressRequest/EmailAddressId]))

(s/def
  :cognitect.aws.connect/PhoneNumberSummaryList
  (s/coll-of :cognitect.aws.connect/PhoneNumberSummary))

(s/def
  :cognitect.aws.connect/DirectoryAlias
  (s/spec
    #(re-matches (re-pattern "^(?!d-)([\\da-zA-Z]+)([-]*[\\da-zA-Z])*$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/InvalidContactFlowModuleException
  (s/keys :opt-un [:cognitect.aws.connect.InvalidContactFlowModuleException/Problems]))

(s/def
  :cognitect.aws.connect/UserDataHierarchyGroups
  (s/coll-of :cognitect.aws.connect/HierarchyGroupId :min-count 1 :max-count 1))

(s/def
  :cognitect.aws.connect/SecurityProfile
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SecurityProfile/AllowedAccessControlTags
     :cognitect.aws.connect.SecurityProfile/HierarchyRestrictedResources
     :cognitect.aws.connect.SecurityProfile/Tags
     :cognitect.aws.connect.SecurityProfile/SecurityProfileName
     :cognitect.aws.connect.SecurityProfile/AllowedAccessControlHierarchyGroupId
     :cognitect.aws.connect.SecurityProfile/Description
     :cognitect.aws.connect.SecurityProfile/LastModifiedRegion
     :cognitect.aws.connect.SecurityProfile/Arn
     :cognitect.aws.connect.SecurityProfile/TagRestrictedResources
     :cognitect.aws.connect.SecurityProfile/LastModifiedTime
     :cognitect.aws.connect.SecurityProfile/Id
     :cognitect.aws.connect.SecurityProfile/OrganizationResourceId]))

(s/def
  :cognitect.aws.connect/EvaluationFormSectionTitle
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/HierarchyLevelId string?)

(s/def :cognitect.aws.connect/DeleteViewResponse (s/keys))

(s/def
  :cognitect.aws.connect/ListQueueQuickConnectsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListQueueQuickConnectsResponse/NextToken
     :cognitect.aws.connect.ListQueueQuickConnectsResponse/LastModifiedRegion
     :cognitect.aws.connect.ListQueueQuickConnectsResponse/LastModifiedTime
     :cognitect.aws.connect.ListQueueQuickConnectsResponse/QuickConnectSummaryList]))

(s/def
  :cognitect.aws.connect/AgentStatusTypes
  (s/coll-of :cognitect.aws.connect/AgentStatusType :max-count 3))

(s/def
  :cognitect.aws.connect/FieldValueUnion
  (s/keys
    :opt-un
    [:cognitect.aws.connect.FieldValueUnion/BooleanValue
     :cognitect.aws.connect.FieldValueUnion/DoubleValue
     :cognitect.aws.connect.FieldValueUnion/EmptyValue
     :cognitect.aws.connect.FieldValueUnion/StringValue]))

(s/def
  :cognitect.aws.connect/HistoricalMetricName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"QUEUE_ANSWER_TIME"
        "CONTACTS_HOLD_ABANDONS"
        "CONTACTS_QUEUED"
        "CONTACTS_ABANDONED"
        "CONTACTS_HANDLED"
        "API_CONTACTS_HANDLED"
        "CONTACTS_TRANSFERRED_IN"
        "CONTACTS_TRANSFERRED_OUT_FROM_QUEUE"
        "CONTACTS_MISSED"
        "HOLD_TIME"
        "CALLBACK_CONTACTS_HANDLED"
        "OCCUPANCY"
        "CONTACTS_TRANSFERRED_IN_FROM_QUEUE"
        "ABANDON_TIME"
        "CONTACTS_HANDLED_INCOMING"
        "QUEUED_TIME"
        "CONTACTS_TRANSFERRED_OUT"
        "CONTACTS_AGENT_HUNG_UP_FIRST"
        "HANDLE_TIME"
        "INTERACTION_AND_HOLD_TIME"
        "AFTER_CONTACT_WORK_TIME"
        "CONTACTS_CONSULTED"
        "SERVICE_LEVEL"
        "CONTACTS_HANDLED_OUTBOUND"
        "INTERACTION_TIME"})))

(s/def
  :cognitect.aws.connect/MaxResult10
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.connect/AgentsCriteria
  (s/keys :opt-un [:cognitect.aws.connect.AgentsCriteria/AgentIds]))

(s/def
  :cognitect.aws.connect/UserProficiency
  (s/keys
    :req-un
    [:cognitect.aws.connect.UserProficiency/AttributeName
     :cognitect.aws.connect.UserProficiency/AttributeValue
     :cognitect.aws.connect.UserProficiency/Level]))

(s/def
  :cognitect.aws.connect/ContactFlowNotPublishedException
  (s/keys :opt-un [:cognitect.aws.connect.ContactFlowNotPublishedException/Message]))

(s/def
  :cognitect.aws.connect/ListTrafficDistributionGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListTrafficDistributionGroupsRequest/InstanceId
     :cognitect.aws.connect.ListTrafficDistributionGroupsRequest/NextToken
     :cognitect.aws.connect.ListTrafficDistributionGroupsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/StringReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.StringReference/Value :cognitect.aws.connect.StringReference/Name]))

(s/def
  :cognitect.aws.connect/ContactEvaluations
  (s/map-of :cognitect.aws.connect/EvaluationId :cognitect.aws.connect/ContactEvaluation))

(s/def
  :cognitect.aws.connect/DescribeQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeQueueRequest/InstanceId
     :cognitect.aws.connect.DescribeQueueRequest/QueueId]))

(s/def
  :cognitect.aws.connect/StartTaskContactResponse
  (s/keys :opt-un [:cognitect.aws.connect.StartTaskContactResponse/ContactId]))

(s/def
  :cognitect.aws.connect/BatchPutContactResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.BatchPutContactResponse/SuccessfulRequestList
     :cognitect.aws.connect.BatchPutContactResponse/FailedRequestList]))

(s/def
  :cognitect.aws.connect/AgentUsername
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SearchableSegmentAttributesCriteria
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchableSegmentAttributesCriteria/Key
     :cognitect.aws.connect.SearchableSegmentAttributesCriteria/Values]))

(s/def
  :cognitect.aws.connect/EmailAttachments
  (s/coll-of :cognitect.aws.connect/EmailAttachment :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.connect/StopContactRecordingRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StopContactRecordingRequest/InstanceId
     :cognitect.aws.connect.StopContactRecordingRequest/ContactId
     :cognitect.aws.connect.StopContactRecordingRequest/InitialContactId]
    :opt-un
    [:cognitect.aws.connect.StopContactRecordingRequest/ContactRecordingType]))

(s/def
  :cognitect.aws.connect/ListRoutingProfilesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListRoutingProfilesResponse/RoutingProfileSummaryList
     :cognitect.aws.connect.ListRoutingProfilesResponse/NextToken]))

(s/def
  :cognitect.aws.connect/DisassociateLambdaFunctionRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateLambdaFunctionRequest/InstanceId
     :cognitect.aws.connect.DisassociateLambdaFunctionRequest/FunctionArn]
    :opt-un
    [:cognitect.aws.connect.DisassociateLambdaFunctionRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/QueueSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.QueueSearchFilter/TagFilter]))

(s/def
  :cognitect.aws.connect/EmailMessageContentType
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/ContactFlowDescription string?)

(s/def
  :cognitect.aws.connect/DescribeSecurityProfileResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeSecurityProfileResponse/SecurityProfile]))

(s/def
  :cognitect.aws.connect/AssociateUserProficienciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateUserProficienciesRequest/InstanceId
     :cognitect.aws.connect.AssociateUserProficienciesRequest/UserId
     :cognitect.aws.connect.AssociateUserProficienciesRequest/UserProficiencies]))

(s/def
  :cognitect.aws.connect/UserProficiencyDisassociate
  (s/keys
    :req-un
    [:cognitect.aws.connect.UserProficiencyDisassociate/AttributeName
     :cognitect.aws.connect.UserProficiencyDisassociate/AttributeValue]))

(s/def
  :cognitect.aws.connect/AssociateApprovedOriginRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateApprovedOriginRequest/InstanceId
     :cognitect.aws.connect.AssociateApprovedOriginRequest/Origin]
    :opt-un
    [:cognitect.aws.connect.AssociateApprovedOriginRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/SendOutboundEmailRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SendOutboundEmailRequest/InstanceId
     :cognitect.aws.connect.SendOutboundEmailRequest/FromEmailAddress
     :cognitect.aws.connect.SendOutboundEmailRequest/DestinationEmailAddress
     :cognitect.aws.connect.SendOutboundEmailRequest/EmailMessage
     :cognitect.aws.connect.SendOutboundEmailRequest/TrafficType]
    :opt-un
    [:cognitect.aws.connect.SendOutboundEmailRequest/SourceCampaign
     :cognitect.aws.connect.SendOutboundEmailRequest/AdditionalRecipients
     :cognitect.aws.connect.SendOutboundEmailRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/DescribeContactResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeContactResponse/Contact]))

(s/def :cognitect.aws.connect/EmptyFieldValue (s/keys))

(s/def
  :cognitect.aws.connect/QueueReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.QueueReference/Arn :cognitect.aws.connect.QueueReference/Id]))

(s/def
  :cognitect.aws.connect/VocabularyId
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/Step
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Step/Expression
     :cognitect.aws.connect.Step/Status
     :cognitect.aws.connect.Step/Expiry]))

(s/def
  :cognitect.aws.connect/ListAssociatedContactsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListAssociatedContactsResponse/NextToken
     :cognitect.aws.connect.ListAssociatedContactsResponse/ContactSummaryList]))

(s/def
  :cognitect.aws.connect/PEM
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/UpdateUserSecurityProfilesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateUserSecurityProfilesRequest/SecurityProfileIds
     :cognitect.aws.connect.UpdateUserSecurityProfilesRequest/UserId
     :cognitect.aws.connect.UpdateUserSecurityProfilesRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/InstanceStorageConfig
  (s/keys
    :req-un
    [:cognitect.aws.connect.InstanceStorageConfig/StorageType]
    :opt-un
    [:cognitect.aws.connect.InstanceStorageConfig/KinesisVideoStreamConfig
     :cognitect.aws.connect.InstanceStorageConfig/AssociationId
     :cognitect.aws.connect.InstanceStorageConfig/KinesisStreamConfig
     :cognitect.aws.connect.InstanceStorageConfig/S3Config
     :cognitect.aws.connect.InstanceStorageConfig/KinesisFirehoseConfig]))

(s/def
  :cognitect.aws.connect/TaskDescriptionExpression
  (s/spec
    (s/and string? #(<= 0 (count %) 4096))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4096) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/StartOutboundChatContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartOutboundChatContactRequest/SourceEndpoint
     :cognitect.aws.connect.StartOutboundChatContactRequest/DestinationEndpoint
     :cognitect.aws.connect.StartOutboundChatContactRequest/InstanceId
     :cognitect.aws.connect.StartOutboundChatContactRequest/SegmentAttributes
     :cognitect.aws.connect.StartOutboundChatContactRequest/ContactFlowId]
    :opt-un
    [:cognitect.aws.connect.StartOutboundChatContactRequest/Attributes
     :cognitect.aws.connect.StartOutboundChatContactRequest/ParticipantDetails
     :cognitect.aws.connect.StartOutboundChatContactRequest/ChatDurationInMinutes
     :cognitect.aws.connect.StartOutboundChatContactRequest/SupportedMessagingContentTypes
     :cognitect.aws.connect.StartOutboundChatContactRequest/RelatedContactId
     :cognitect.aws.connect.StartOutboundChatContactRequest/InitialSystemMessage
     :cognitect.aws.connect.StartOutboundChatContactRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/Rule
  (s/keys
    :req-un
    [:cognitect.aws.connect.Rule/Name
     :cognitect.aws.connect.Rule/RuleId
     :cognitect.aws.connect.Rule/RuleArn
     :cognitect.aws.connect.Rule/TriggerEventSource
     :cognitect.aws.connect.Rule/Function
     :cognitect.aws.connect.Rule/Actions
     :cognitect.aws.connect.Rule/PublishStatus
     :cognitect.aws.connect.Rule/CreatedTime
     :cognitect.aws.connect.Rule/LastUpdatedTime
     :cognitect.aws.connect.Rule/LastUpdatedBy]
    :opt-un
    [:cognitect.aws.connect.Rule/Tags]))

(s/def
  :cognitect.aws.connect/UserSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UserSearchCriteria/HierarchyGroupCondition
     :cognitect.aws.connect.UserSearchCriteria/ListCondition
     :cognitect.aws.connect.UserSearchCriteria/OrConditions
     :cognitect.aws.connect.UserSearchCriteria/StringCondition
     :cognitect.aws.connect.UserSearchCriteria/AndConditions]))

(s/def :cognitect.aws.connect/QuickConnectId string?)

(s/def
  :cognitect.aws.connect/AgentResourceId
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DurationMillis
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/ParticipantToken
  (s/spec
    (s/and string? #(<= 1 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EvaluationNote
  (s/keys :opt-un [:cognitect.aws.connect.EvaluationNote/Value]))

(s/def
  :cognitect.aws.connect/CreateIntegrationAssociationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateIntegrationAssociationRequest/InstanceId
     :cognitect.aws.connect.CreateIntegrationAssociationRequest/IntegrationType
     :cognitect.aws.connect.CreateIntegrationAssociationRequest/IntegrationArn]
    :opt-un
    [:cognitect.aws.connect.CreateIntegrationAssociationRequest/SourceApplicationUrl
     :cognitect.aws.connect.CreateIntegrationAssociationRequest/Tags
     :cognitect.aws.connect.CreateIntegrationAssociationRequest/SourceType
     :cognitect.aws.connect.CreateIntegrationAssociationRequest/SourceApplicationName]))

(s/def
  :cognitect.aws.connect/TagRestrictedResourceList
  (s/coll-of :cognitect.aws.connect/TagRestrictedResourceName :max-count 10))

(s/def
  :cognitect.aws.connect/Prefix
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EvaluationStatus
  (s/spec string? :gen #(s/gen #{"DRAFT" "SUBMITTED"})))

(s/def
  :cognitect.aws.connect/TrafficDistributionGroupUserSummaryList
  (s/coll-of :cognitect.aws.connect/TrafficDistributionGroupUserSummary :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.connect/AttributeAndCondition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AttributeAndCondition/HierarchyGroupCondition
     :cognitect.aws.connect.AttributeAndCondition/TagConditions]))

(s/def
  :cognitect.aws.connect/RoutingProfileQueueReference
  (s/keys
    :req-un
    [:cognitect.aws.connect.RoutingProfileQueueReference/QueueId
     :cognitect.aws.connect.RoutingProfileQueueReference/Channel]))

(s/def
  :cognitect.aws.connect/BatchAssociateAnalyticsDataSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.BatchAssociateAnalyticsDataSetResponse/Created
     :cognitect.aws.connect.BatchAssociateAnalyticsDataSetResponse/Errors]))

(s/def
  :cognitect.aws.connect/RoutingProfileSummaryList
  (s/coll-of :cognitect.aws.connect/RoutingProfileSummary))

(s/def
  :cognitect.aws.connect/QuickConnectDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 250) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/GetTrafficDistributionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.GetTrafficDistributionResponse/SignInConfig
     :cognitect.aws.connect.GetTrafficDistributionResponse/Arn
     :cognitect.aws.connect.GetTrafficDistributionResponse/TelephonyConfig
     :cognitect.aws.connect.GetTrafficDistributionResponse/AgentConfig
     :cognitect.aws.connect.GetTrafficDistributionResponse/Id]))

(s/def
  :cognitect.aws.connect/TagMap
  (s/map-of
    :cognitect.aws.connect/TagKey
    :cognitect.aws.connect/TagValue
    :min-count
    1
    :max-count
    50))

(s/def
  :cognitect.aws.connect/ListSecurityProfileApplicationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListSecurityProfileApplicationsResponse/NextToken
     :cognitect.aws.connect.ListSecurityProfileApplicationsResponse/Applications
     :cognitect.aws.connect.ListSecurityProfileApplicationsResponse/LastModifiedRegion
     :cognitect.aws.connect.ListSecurityProfileApplicationsResponse/LastModifiedTime]))

(s/def
  :cognitect.aws.connect/AssociateTrafficDistributionGroupUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateTrafficDistributionGroupUserRequest/TrafficDistributionGroupId
     :cognitect.aws.connect.AssociateTrafficDistributionGroupUserRequest/UserId
     :cognitect.aws.connect.AssociateTrafficDistributionGroupUserRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/FlowAssociationResourceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"WHATSAPP_MESSAGING_PHONE_NUMBER"
        "INBOUND_EMAIL"
        "OUTBOUND_EMAIL"
        "SMS_PHONE_NUMBER"
        "ANALYTICS_CONNECTOR"})))

(s/def
  :cognitect.aws.connect/RegionName
  (s/spec #(re-matches (re-pattern "[a-z]{2}(-[a-z]+){1,2}(-[0-9])?") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/AnswerMachineDetectionConfig
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AnswerMachineDetectionConfig/EnableAnswerMachineDetection
     :cognitect.aws.connect.AnswerMachineDetectionConfig/AwaitAnswerMachinePrompt]))

(s/def
  :cognitect.aws.connect/ConnectionData
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ConnectionData/Meeting :cognitect.aws.connect.ConnectionData/Attendee]))

(s/def
  :cognitect.aws.connect/SupportedMessagingContentTypes
  (s/coll-of :cognitect.aws.connect/SupportedMessagingContentType))

(s/def
  :cognitect.aws.connect/DescribeInstanceStorageConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeInstanceStorageConfigRequest/InstanceId
     :cognitect.aws.connect.DescribeInstanceStorageConfigRequest/AssociationId
     :cognitect.aws.connect.DescribeInstanceStorageConfigRequest/ResourceType]))

(s/def
  :cognitect.aws.connect/AuthenticationErrorDescription
  (s/spec #(re-matches (re-pattern "^[\\x20-\\x21\\x23-\\x5B\\x5D-\\x7E]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/InvalidRequestException
  (s/keys
    :opt-un
    [:cognitect.aws.connect.InvalidRequestException/Message
     :cognitect.aws.connect.InvalidRequestException/Reason]))

(s/def
  :cognitect.aws.connect/UpdateContactFlowModuleContentRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactFlowModuleContentRequest/InstanceId
     :cognitect.aws.connect.UpdateContactFlowModuleContentRequest/ContactFlowModuleId
     :cognitect.aws.connect.UpdateContactFlowModuleContentRequest/Content]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptItemWithCharacterOffsets
  (s/keys
    :req-un
    [:cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemWithCharacterOffsets/Id]
    :opt-un
    [:cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemWithCharacterOffsets/CharacterOffsets]))

(s/def
  :cognitect.aws.connect/EmailHeaderValue
  (s/spec
    (s/and string? #(<= 1 (count %) 20000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 20000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SegmentAttributes
  (s/map-of
    :cognitect.aws.connect/SegmentAttributeName
    :cognitect.aws.connect/SegmentAttributeValue))

(s/def
  :cognitect.aws.connect/CommonHumanReadableName
  (s/spec #(re-matches (re-pattern "^[\\P{C}\\r\\n\\t]{1,127}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/StartScreenSharingRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartScreenSharingRequest/InstanceId
     :cognitect.aws.connect.StartScreenSharingRequest/ContactId]
    :opt-un
    [:cognitect.aws.connect.StartScreenSharingRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/ChatStreamingEndpointARN
  (s/spec
    (s/and string? #(<= 1 (count %) 350))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 350) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ViewContentSha256
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9]$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/PhoneNumberWorkflowStatus
  (s/spec string? :gen #(s/gen #{"IN_PROGRESS" "CLAIMED" "FAILED"})))

(s/def :cognitect.aws.connect/TagsList (s/coll-of :cognitect.aws.connect/TagSet))

(s/def
  :cognitect.aws.connect/SecurityProfilePolicyValue
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/AgentStatusSearchConditionList
  (s/coll-of :cognitect.aws.connect/AgentStatusSearchCriteria))

(s/def
  :cognitect.aws.connect/AssignSlaActionDefinition
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssignSlaActionDefinition/SlaAssignmentType]
    :opt-un
    [:cognitect.aws.connect.AssignSlaActionDefinition/CaseSlaConfiguration]))

(s/def
  :cognitect.aws.connect/AvailableNumberSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AvailableNumberSummary/PhoneNumberCountryCode
     :cognitect.aws.connect.AvailableNumberSummary/PhoneNumberType
     :cognitect.aws.connect.AvailableNumberSummary/PhoneNumber]))

(s/def
  :cognitect.aws.connect/CreatePushNotificationRegistrationResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreatePushNotificationRegistrationResponse/RegistrationId]))

(s/def
  :cognitect.aws.connect/ReferenceStatus
  (s/spec
    string?
    :gen
    #(s/gen #{"AVAILABLE" "REJECTED" "APPROVED" "FAILED" "DELETED" "PROCESSING"})))

(s/def
  :cognitect.aws.connect/ListInstanceAttributesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListInstanceAttributesResponse/NextToken
     :cognitect.aws.connect.ListInstanceAttributesResponse/Attributes]))

(s/def
  :cognitect.aws.connect/StartContactStreamingResponse
  (s/keys :req-un [:cognitect.aws.connect.StartContactStreamingResponse/StreamingId]))

(s/def
  :cognitect.aws.connect/EvaluationFormDescription
  (s/spec
    (s/and string? #(<= 0 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ChatStreamingConfiguration
  (s/keys :req-un [:cognitect.aws.connect.ChatStreamingConfiguration/StreamingEndpointArn]))

(s/def
  :cognitect.aws.connect/AssociateQueueQuickConnectsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateQueueQuickConnectsRequest/InstanceId
     :cognitect.aws.connect.AssociateQueueQuickConnectsRequest/QueueId
     :cognitect.aws.connect.AssociateQueueQuickConnectsRequest/QuickConnectIds]))

(s/def
  :cognitect.aws.connect/UserHierarchyGroupList
  (s/coll-of :cognitect.aws.connect/HierarchyGroup))

(s/def :cognitect.aws.connect/EvaluationFormVersionIsLocked boolean?)

(s/def
  :cognitect.aws.connect/GetCurrentMetricDataResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.GetCurrentMetricDataResponse/MetricResults
     :cognitect.aws.connect.GetCurrentMetricDataResponse/ApproximateTotalCount
     :cognitect.aws.connect.GetCurrentMetricDataResponse/NextToken
     :cognitect.aws.connect.GetCurrentMetricDataResponse/DataSnapshotTime]))

(s/def
  :cognitect.aws.connect/Campaign
  (s/keys :opt-un [:cognitect.aws.connect.Campaign/CampaignId]))

(s/def
  :cognitect.aws.connect/DeactivateEvaluationFormRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeactivateEvaluationFormRequest/InstanceId
     :cognitect.aws.connect.DeactivateEvaluationFormRequest/EvaluationFormId
     :cognitect.aws.connect.DeactivateEvaluationFormRequest/EvaluationFormVersion]))

(s/def
  :cognitect.aws.connect/ContactSearchSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactSearchSummary/InitialContactId
     :cognitect.aws.connect.ContactSearchSummary/QueueInfo
     :cognitect.aws.connect.ContactSearchSummary/PreviousContactId
     :cognitect.aws.connect.ContactSearchSummary/SegmentAttributes
     :cognitect.aws.connect.ContactSearchSummary/DisconnectTimestamp
     :cognitect.aws.connect.ContactSearchSummary/ScheduledTimestamp
     :cognitect.aws.connect.ContactSearchSummary/InitiationTimestamp
     :cognitect.aws.connect.ContactSearchSummary/Arn
     :cognitect.aws.connect.ContactSearchSummary/Channel
     :cognitect.aws.connect.ContactSearchSummary/InitiationMethod
     :cognitect.aws.connect.ContactSearchSummary/Id
     :cognitect.aws.connect.ContactSearchSummary/AgentInfo]))

(s/def
  :cognitect.aws.connect/RoutingProfileSearchConditionList
  (s/coll-of :cognitect.aws.connect/RoutingProfileSearchCriteria))

(s/def :cognitect.aws.connect/Contacts (s/coll-of :cognitect.aws.connect/ContactSearchSummary))

(s/def :cognitect.aws.connect/UpdateParticipantRoleConfigResponse (s/keys))

(s/def
  :cognitect.aws.connect/ListEvaluationFormVersionsResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListEvaluationFormVersionsResponse/EvaluationFormVersionSummaryList]
    :opt-un
    [:cognitect.aws.connect.ListEvaluationFormVersionsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/ProblemDetail
  (s/keys :opt-un [:cognitect.aws.connect.ProblemDetail/message]))

(s/def
  :cognitect.aws.connect/ListDefaultVocabulariesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListDefaultVocabulariesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListDefaultVocabulariesRequest/NextToken
     :cognitect.aws.connect.ListDefaultVocabulariesRequest/LanguageCode
     :cognitect.aws.connect.ListDefaultVocabulariesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/RoutingProfiles
  (s/coll-of :cognitect.aws.connect/RoutingProfileId :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.connect/BotName
  (s/spec
    (s/and string? #(>= 50 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DeactivateEvaluationFormResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeactivateEvaluationFormResponse/EvaluationFormId
     :cognitect.aws.connect.DeactivateEvaluationFormResponse/EvaluationFormArn
     :cognitect.aws.connect.DeactivateEvaluationFormResponse/EvaluationFormVersion]))

(s/def
  :cognitect.aws.connect/RuleTriggerEventSource
  (s/keys
    :req-un
    [:cognitect.aws.connect.RuleTriggerEventSource/EventSourceName]
    :opt-un
    [:cognitect.aws.connect.RuleTriggerEventSource/IntegrationAssociationId]))

(s/def
  :cognitect.aws.connect/InitiateAs
  (s/spec string? :gen #(s/gen #{"COMPLETED" "CONNECTED_TO_USER"})))

(s/def
  :cognitect.aws.connect/ContactNotFoundException
  (s/keys :opt-un [:cognitect.aws.connect.ContactNotFoundException/Message]))

(s/def :cognitect.aws.connect/DeleteAttachedFileResponse (s/keys))

(s/def
  :cognitect.aws.connect/AudioQualityScore
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.connect/DescribeEvaluationFormResponse
  (s/keys :req-un [:cognitect.aws.connect.DescribeEvaluationFormResponse/EvaluationForm]))

(s/def
  :cognitect.aws.connect/AccessTokenDuration
  (s/spec (s/and int? #(<= 10 % 60)) :gen #(gen/choose 10 60)))

(s/def
  :cognitect.aws.connect/ReplicationStatusReason
  (s/spec
    (s/and string? #(<= 0 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListIntegrationAssociationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListIntegrationAssociationsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListIntegrationAssociationsRequest/NextToken
     :cognitect.aws.connect.ListIntegrationAssociationsRequest/IntegrationType
     :cognitect.aws.connect.ListIntegrationAssociationsRequest/MaxResults
     :cognitect.aws.connect.ListIntegrationAssociationsRequest/IntegrationArn]))

(s/def
  :cognitect.aws.connect/CreateSecurityProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateSecurityProfileRequest/SecurityProfileName
     :cognitect.aws.connect.CreateSecurityProfileRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.CreateSecurityProfileRequest/AllowedAccessControlTags
     :cognitect.aws.connect.CreateSecurityProfileRequest/Permissions
     :cognitect.aws.connect.CreateSecurityProfileRequest/HierarchyRestrictedResources
     :cognitect.aws.connect.CreateSecurityProfileRequest/Tags
     :cognitect.aws.connect.CreateSecurityProfileRequest/AllowedAccessControlHierarchyGroupId
     :cognitect.aws.connect.CreateSecurityProfileRequest/Applications
     :cognitect.aws.connect.CreateSecurityProfileRequest/Description
     :cognitect.aws.connect.CreateSecurityProfileRequest/TagRestrictedResources]))

(s/def
  :cognitect.aws.connect/DeleteIntegrationAssociationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteIntegrationAssociationRequest/InstanceId
     :cognitect.aws.connect.DeleteIntegrationAssociationRequest/IntegrationAssociationId]))

(s/def
  :cognitect.aws.connect/ListPromptsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListPromptsResponse/PromptSummaryList
     :cognitect.aws.connect.ListPromptsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/ListRoutingProfileQueuesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListRoutingProfileQueuesRequest/InstanceId
     :cognitect.aws.connect.ListRoutingProfileQueuesRequest/RoutingProfileId]
    :opt-un
    [:cognitect.aws.connect.ListRoutingProfileQueuesRequest/NextToken
     :cognitect.aws.connect.ListRoutingProfileQueuesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/UserSearchSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UserSearchSummary/Username
     :cognitect.aws.connect.UserSearchSummary/PhoneConfig
     :cognitect.aws.connect.UserSearchSummary/IdentityInfo
     :cognitect.aws.connect.UserSearchSummary/Tags
     :cognitect.aws.connect.UserSearchSummary/SecurityProfileIds
     :cognitect.aws.connect.UserSearchSummary/HierarchyGroupId
     :cognitect.aws.connect.UserSearchSummary/Arn
     :cognitect.aws.connect.UserSearchSummary/RoutingProfileId
     :cognitect.aws.connect.UserSearchSummary/DirectoryUserId
     :cognitect.aws.connect.UserSearchSummary/Id]))

(s/def
  :cognitect.aws.connect/StartOutboundVoiceContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartOutboundVoiceContactRequest/DestinationPhoneNumber
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/ContactFlowId
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.StartOutboundVoiceContactRequest/TrafficType
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/Attributes
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/References
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/Description
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/SourcePhoneNumber
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/AnswerMachineDetectionConfig
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/Name
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/RelatedContactId
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/CampaignId
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/ClientToken
     :cognitect.aws.connect.StartOutboundVoiceContactRequest/QueueId]))

(s/def
  :cognitect.aws.connect/RoutingCriteriaInputSteps
  (s/coll-of :cognitect.aws.connect/RoutingCriteriaInputStep))

(s/def
  :cognitect.aws.connect/HoursOfOperationOverrideConfig
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HoursOfOperationOverrideConfig/EndTime
     :cognitect.aws.connect.HoursOfOperationOverrideConfig/StartTime
     :cognitect.aws.connect.HoursOfOperationOverrideConfig/Day]))

(s/def
  :cognitect.aws.connect/PropertyValidationExceptionReason
  (s/spec
    string?
    :gen
    #(s/gen
      #{"NOT_SUPPORTED"
        "UNIQUE_CONSTRAINT_VIOLATED"
        "RESOURCE_NAME_ALREADY_EXISTS"
        "REFERENCED_RESOURCE_NOT_FOUND"
        "INVALID_FORMAT"
        "REQUIRED_PROPERTY_MISSING"})))

(s/def
  :cognitect.aws.connect/KinesisStreamConfig
  (s/keys :req-un [:cognitect.aws.connect.KinesisStreamConfig/StreamArn]))

(s/def
  :cognitect.aws.connect/CreateHoursOfOperationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateHoursOfOperationRequest/InstanceId
     :cognitect.aws.connect.CreateHoursOfOperationRequest/Name
     :cognitect.aws.connect.CreateHoursOfOperationRequest/TimeZone
     :cognitect.aws.connect.CreateHoursOfOperationRequest/Config]
    :opt-un
    [:cognitect.aws.connect.CreateHoursOfOperationRequest/Tags
     :cognitect.aws.connect.CreateHoursOfOperationRequest/Description]))

(s/def
  :cognitect.aws.connect/UpdateContactFlowNameRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactFlowNameRequest/InstanceId
     :cognitect.aws.connect.UpdateContactFlowNameRequest/ContactFlowId]
    :opt-un
    [:cognitect.aws.connect.UpdateContactFlowNameRequest/Description
     :cognitect.aws.connect.UpdateContactFlowNameRequest/Name]))

(s/def
  :cognitect.aws.connect/ActionSummary
  (s/keys :req-un [:cognitect.aws.connect.ActionSummary/ActionType]))

(s/def :cognitect.aws.connect/StartContactRecordingResponse (s/keys))

(s/def
  :cognitect.aws.connect/ContactMetricName
  (s/spec string? :gen #(s/gen #{"POSITION_IN_QUEUE"})))

(s/def
  :cognitect.aws.connect/SearchPredefinedAttributesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchPredefinedAttributesResponse/PredefinedAttributes
     :cognitect.aws.connect.SearchPredefinedAttributesResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchPredefinedAttributesResponse/NextToken]))

(s/def
  :cognitect.aws.connect/UserSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UserSummary/Username
     :cognitect.aws.connect.UserSummary/LastModifiedRegion
     :cognitect.aws.connect.UserSummary/Arn
     :cognitect.aws.connect.UserSummary/LastModifiedTime
     :cognitect.aws.connect.UserSummary/Id]))

(s/def
  :cognitect.aws.connect/VersionNumber
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/SourceCampaign
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SourceCampaign/OutboundRequestId
     :cognitect.aws.connect.SourceCampaign/CampaignId]))

(s/def
  :cognitect.aws.connect/UpdateContactScheduleRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactScheduleRequest/InstanceId
     :cognitect.aws.connect.UpdateContactScheduleRequest/ContactId
     :cognitect.aws.connect.UpdateContactScheduleRequest/ScheduledTime]))

(s/def
  :cognitect.aws.connect/DeleteHoursOfOperationOverrideRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteHoursOfOperationOverrideRequest/InstanceId
     :cognitect.aws.connect.DeleteHoursOfOperationOverrideRequest/HoursOfOperationId
     :cognitect.aws.connect.DeleteHoursOfOperationOverrideRequest/HoursOfOperationOverrideId]))

(s/def :cognitect.aws.connect/SuspendContactRecordingResponse (s/keys))

(s/def
  :cognitect.aws.connect/ContactFlowSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactFlowSearchCriteria/TypeCondition
     :cognitect.aws.connect.ContactFlowSearchCriteria/StateCondition
     :cognitect.aws.connect.ContactFlowSearchCriteria/OrConditions
     :cognitect.aws.connect.ContactFlowSearchCriteria/StringCondition
     :cognitect.aws.connect.ContactFlowSearchCriteria/StatusCondition
     :cognitect.aws.connect.ContactFlowSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/ProficiencyValue
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/HistoricalMetrics (s/coll-of :cognitect.aws.connect/HistoricalMetric))

(s/def
  :cognitect.aws.connect/FailedRequest
  (s/keys
    :opt-un
    [:cognitect.aws.connect.FailedRequest/FailureReasonCode
     :cognitect.aws.connect.FailedRequest/RequestIdentifier
     :cognitect.aws.connect.FailedRequest/FailureReasonMessage]))

(s/def
  :cognitect.aws.connect/ListBotsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListBotsRequest/InstanceId
     :cognitect.aws.connect.ListBotsRequest/LexVersion]
    :opt-un
    [:cognitect.aws.connect.ListBotsRequest/NextToken
     :cognitect.aws.connect.ListBotsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/CreateViewVersionResponse
  (s/keys :opt-un [:cognitect.aws.connect.CreateViewVersionResponse/View]))

(s/def
  :cognitect.aws.connect/UpdateContactEvaluationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactEvaluationRequest/InstanceId
     :cognitect.aws.connect.UpdateContactEvaluationRequest/EvaluationId]
    :opt-un
    [:cognitect.aws.connect.UpdateContactEvaluationRequest/Answers
     :cognitect.aws.connect.UpdateContactEvaluationRequest/Notes]))

(s/def
  :cognitect.aws.connect/QueuePriority
  (s/spec (s/and int? #(<= 1 % 9223372036854775807)) :gen #(gen/choose 1 9223372036854775807)))

(s/def
  :cognitect.aws.connect/OutboundAdditionalRecipients
  (s/keys :opt-un [:cognitect.aws.connect.OutboundAdditionalRecipients/CcEmailAddresses]))

(s/def :cognitect.aws.connect/SecurityKeysList (s/coll-of :cognitect.aws.connect/SecurityKey))

(s/def
  :cognitect.aws.connect/MonitorContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.MonitorContactRequest/InstanceId
     :cognitect.aws.connect.MonitorContactRequest/ContactId
     :cognitect.aws.connect.MonitorContactRequest/UserId]
    :opt-un
    [:cognitect.aws.connect.MonitorContactRequest/AllowedMonitorCapabilities
     :cognitect.aws.connect.MonitorContactRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/CreateEmailAddressResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateEmailAddressResponse/EmailAddressId
     :cognitect.aws.connect.CreateEmailAddressResponse/EmailAddressArn]))

(s/def
  :cognitect.aws.connect/TemplateAttributes
  (s/keys
    :opt-un
    [:cognitect.aws.connect.TemplateAttributes/CustomerProfileAttributes
     :cognitect.aws.connect.TemplateAttributes/CustomAttributes]))

(s/def
  :cognitect.aws.connect/SearchHoursOfOperationOverridesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchHoursOfOperationOverridesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchHoursOfOperationOverridesRequest/NextToken
     :cognitect.aws.connect.SearchHoursOfOperationOverridesRequest/SearchFilter
     :cognitect.aws.connect.SearchHoursOfOperationOverridesRequest/SearchCriteria
     :cognitect.aws.connect.SearchHoursOfOperationOverridesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/ListLambdaFunctionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListLambdaFunctionsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListLambdaFunctionsRequest/NextToken
     :cognitect.aws.connect.ListLambdaFunctionsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/SecurityProfilePolicyKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/PlatformName
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListContactFlowsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListContactFlowsResponse/NextToken
     :cognitect.aws.connect.ListContactFlowsResponse/ContactFlowSummaryList]))

(s/def
  :cognitect.aws.connect/Endpoint
  (s/keys :opt-un [:cognitect.aws.connect.Endpoint/Address :cognitect.aws.connect.Endpoint/Type]))

(s/def
  :cognitect.aws.connect/MatchCriteria
  (s/keys :opt-un [:cognitect.aws.connect.MatchCriteria/AgentsCriteria]))

(s/def
  :cognitect.aws.connect/DestinationNotAllowedException
  (s/keys :opt-un [:cognitect.aws.connect.DestinationNotAllowedException/Message]))

(s/def
  :cognitect.aws.connect/ArtifactStatus
  (s/spec string? :gen #(s/gen #{"IN_PROGRESS" "REJECTED" "APPROVED"})))

(s/def :cognitect.aws.connect/QueueId string?)

(s/def
  :cognitect.aws.connect/DescribeAgentStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeAgentStatusRequest/InstanceId
     :cognitect.aws.connect.DescribeAgentStatusRequest/AgentStatusId]))

(s/def :cognitect.aws.connect/RuleActions (s/coll-of :cognitect.aws.connect/RuleAction))

(s/def
  :cognitect.aws.connect/DescribeRoutingProfileResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeRoutingProfileResponse/RoutingProfile]))

(s/def
  :cognitect.aws.connect/ContactDetailName
  (s/spec
    (s/and string? #(<= 0 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/RuleSummaryList (s/coll-of :cognitect.aws.connect/RuleSummary))

(s/def
  :cognitect.aws.connect/UseCaseType
  (s/spec string? :gen #(s/gen #{"CONNECT_CAMPAIGNS" "RULES_EVALUATION"})))

(s/def
  :cognitect.aws.connect/ListViewsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListViewsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListViewsRequest/Type
     :cognitect.aws.connect.ListViewsRequest/NextToken
     :cognitect.aws.connect.ListViewsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/UpdateViewContentResponse
  (s/keys :opt-un [:cognitect.aws.connect.UpdateViewContentResponse/View]))

(s/def
  :cognitect.aws.connect/UpdateParticipantRoleConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateParticipantRoleConfigRequest/InstanceId
     :cognitect.aws.connect.UpdateParticipantRoleConfigRequest/ContactId
     :cognitect.aws.connect.UpdateParticipantRoleConfigRequest/ChannelConfiguration]))

(s/def :cognitect.aws.connect/MeetingId string?)

(s/def
  :cognitect.aws.connect/ListApprovedOriginsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListApprovedOriginsResponse/NextToken
     :cognitect.aws.connect.ListApprovedOriginsResponse/Origins]))

(s/def
  :cognitect.aws.connect/StartOutboundEmailContactResponse
  (s/keys :opt-un [:cognitect.aws.connect.StartOutboundEmailContactResponse/ContactId]))

(s/def
  :cognitect.aws.connect/ViewSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ViewSummary/Type
     :cognitect.aws.connect.ViewSummary/Status
     :cognitect.aws.connect.ViewSummary/Description
     :cognitect.aws.connect.ViewSummary/Arn
     :cognitect.aws.connect.ViewSummary/Name
     :cognitect.aws.connect.ViewSummary/Id]))

(s/def
  :cognitect.aws.connect/InboundRawMessage
  (s/keys
    :req-un
    [:cognitect.aws.connect.InboundRawMessage/Subject
     :cognitect.aws.connect.InboundRawMessage/Body
     :cognitect.aws.connect.InboundRawMessage/ContentType]
    :opt-un
    [:cognitect.aws.connect.InboundRawMessage/Headers]))

(s/def :cognitect.aws.connect/Delay (s/spec (s/and int? #(<= 0 % 9999)) :gen #(gen/choose 0 9999)))

(s/def
  :cognitect.aws.connect/ThresholdValue
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def :cognitect.aws.connect/Message string?)

(s/def
  :cognitect.aws.connect/OverrideTimeSlice
  (s/keys
    :req-un
    [:cognitect.aws.connect.OverrideTimeSlice/Hours
     :cognitect.aws.connect.OverrideTimeSlice/Minutes]))

(s/def
  :cognitect.aws.connect/HoursOfOperationOverrideYearMonthDayDateFormat
  (s/spec #(re-matches (re-pattern "^\\d{4}-\\d{2}-\\d{2}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/EmailAddressInfo
  (s/keys
    :req-un
    [:cognitect.aws.connect.EmailAddressInfo/EmailAddress]
    :opt-un
    [:cognitect.aws.connect.EmailAddressInfo/DisplayName]))

(s/def
  :cognitect.aws.connect/EvaluationFormQuestionInstructions
  (s/spec
    (s/and string? #(<= 0 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DeviceType
  (s/spec string? :gen #(s/gen #{"GCM" "APNS" "APNS_SANDBOX"})))

(s/def :cognitect.aws.connect/Statistic (s/spec string? :gen #(s/gen #{"SUM" "AVG" "MAX"})))

(s/def :cognitect.aws.connect/MediaRegion string?)

(s/def
  :cognitect.aws.connect/RecordingStatus
  (s/spec string? :gen #(s/gen #{"AVAILABLE" "DELETED"})))

(s/def
  :cognitect.aws.connect/MetricFilterV2
  (s/keys
    :opt-un
    [:cognitect.aws.connect.MetricFilterV2/MetricFilterKey
     :cognitect.aws.connect.MetricFilterV2/MetricFilterValues
     :cognitect.aws.connect.MetricFilterV2/Negate]))

(s/def
  :cognitect.aws.connect/DescribeEmailAddressRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeEmailAddressRequest/InstanceId
     :cognitect.aws.connect.DescribeEmailAddressRequest/EmailAddressId]))

(s/def
  :cognitect.aws.connect/ListContactFlowsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListContactFlowsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListContactFlowsRequest/NextToken
     :cognitect.aws.connect.ListContactFlowsRequest/MaxResults
     :cognitect.aws.connect.ListContactFlowsRequest/ContactFlowTypes]))

(s/def
  :cognitect.aws.connect/UpdateQueueMaxContactsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateQueueMaxContactsRequest/InstanceId
     :cognitect.aws.connect.UpdateQueueMaxContactsRequest/QueueId]
    :opt-un
    [:cognitect.aws.connect.UpdateQueueMaxContactsRequest/MaxContacts]))

(s/def
  :cognitect.aws.connect/HierarchyGroup
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HierarchyGroup/Tags
     :cognitect.aws.connect.HierarchyGroup/LevelId
     :cognitect.aws.connect.HierarchyGroup/HierarchyPath
     :cognitect.aws.connect.HierarchyGroup/LastModifiedRegion
     :cognitect.aws.connect.HierarchyGroup/Arn
     :cognitect.aws.connect.HierarchyGroup/LastModifiedTime
     :cognitect.aws.connect.HierarchyGroup/Name
     :cognitect.aws.connect.HierarchyGroup/Id]))

(s/def
  :cognitect.aws.connect/CreateTaskTemplateResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateTaskTemplateResponse/Id
     :cognitect.aws.connect.CreateTaskTemplateResponse/Arn]))

(s/def
  :cognitect.aws.connect/GetMetricDataV2Request
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetMetricDataV2Request/ResourceArn
     :cognitect.aws.connect.GetMetricDataV2Request/StartTime
     :cognitect.aws.connect.GetMetricDataV2Request/EndTime
     :cognitect.aws.connect.GetMetricDataV2Request/Filters
     :cognitect.aws.connect.GetMetricDataV2Request/Metrics]
    :opt-un
    [:cognitect.aws.connect.GetMetricDataV2Request/NextToken
     :cognitect.aws.connect.GetMetricDataV2Request/Groupings
     :cognitect.aws.connect.GetMetricDataV2Request/Interval
     :cognitect.aws.connect.GetMetricDataV2Request/MaxResults]))

(s/def
  :cognitect.aws.connect/UpdateUserHierarchyGroupNameRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateUserHierarchyGroupNameRequest/Name
     :cognitect.aws.connect.UpdateUserHierarchyGroupNameRequest/HierarchyGroupId
     :cognitect.aws.connect.UpdateUserHierarchyGroupNameRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/RoutingProfileSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.RoutingProfileSearchCriteria/OrConditions
     :cognitect.aws.connect.RoutingProfileSearchCriteria/StringCondition
     :cognitect.aws.connect.RoutingProfileSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/UserDataFilters
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UserDataFilters/UserHierarchyGroups
     :cognitect.aws.connect.UserDataFilters/Agents
     :cognitect.aws.connect.UserDataFilters/Queues
     :cognitect.aws.connect.UserDataFilters/RoutingProfiles
     :cognitect.aws.connect.UserDataFilters/ContactFilter]))

(s/def
  :cognitect.aws.connect/ContactFlowModuleSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactFlowModuleSearchCriteria/StateCondition
     :cognitect.aws.connect.ContactFlowModuleSearchCriteria/OrConditions
     :cognitect.aws.connect.ContactFlowModuleSearchCriteria/StringCondition
     :cognitect.aws.connect.ContactFlowModuleSearchCriteria/StatusCondition
     :cognitect.aws.connect.ContactFlowModuleSearchCriteria/AndConditions]))

(s/def :cognitect.aws.connect/Comparison (s/spec string? :gen #(s/gen #{"LT"})))

(s/def
  :cognitect.aws.connect/TrafficDistributionGroupSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.TrafficDistributionGroupSummary/Status
     :cognitect.aws.connect.TrafficDistributionGroupSummary/Arn
     :cognitect.aws.connect.TrafficDistributionGroupSummary/Name
     :cognitect.aws.connect.TrafficDistributionGroupSummary/IsDefault
     :cognitect.aws.connect.TrafficDistributionGroupSummary/Id
     :cognitect.aws.connect.TrafficDistributionGroupSummary/InstanceArn]))

(s/def
  :cognitect.aws.connect/InstanceArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:(aws|aws-us-gov):connect:[a-z]{2}-[a-z]+-[0-9-]{1}:[0-9]{1,20}:instance/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/GetAttachedFileResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetAttachedFileResponse/FileSizeInBytes]
    :opt-un
    [:cognitect.aws.connect.GetAttachedFileResponse/Tags
     :cognitect.aws.connect.GetAttachedFileResponse/CreatedBy
     :cognitect.aws.connect.GetAttachedFileResponse/AssociatedResourceArn
     :cognitect.aws.connect.GetAttachedFileResponse/DownloadUrlMetadata
     :cognitect.aws.connect.GetAttachedFileResponse/FileStatus
     :cognitect.aws.connect.GetAttachedFileResponse/FileArn
     :cognitect.aws.connect.GetAttachedFileResponse/CreationTime
     :cognitect.aws.connect.GetAttachedFileResponse/FileId
     :cognitect.aws.connect.GetAttachedFileResponse/FileUseCaseType
     :cognitect.aws.connect.GetAttachedFileResponse/FileName]))

(s/def
  :cognitect.aws.connect/PromptSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.PromptSearchFilter/TagFilter]))

(s/def
  :cognitect.aws.connect/DateReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.DateReference/Value :cognitect.aws.connect.DateReference/Name]))

(s/def :cognitect.aws.connect/JoinToken string?)

(s/def
  :cognitect.aws.connect/UpdateUserHierarchyRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateUserHierarchyRequest/UserId
     :cognitect.aws.connect.UpdateUserHierarchyRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.UpdateUserHierarchyRequest/HierarchyGroupId]))

(s/def
  :cognitect.aws.connect/UpdateViewContentRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateViewContentRequest/InstanceId
     :cognitect.aws.connect.UpdateViewContentRequest/ViewId
     :cognitect.aws.connect.UpdateViewContentRequest/Status
     :cognitect.aws.connect.UpdateViewContentRequest/Content]))

(s/def
  :cognitect.aws.connect/DescribeQueueResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeQueueResponse/Queue]))

(s/def
  :cognitect.aws.connect/ListSecurityProfilePermissionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListSecurityProfilePermissionsResponse/Permissions
     :cognitect.aws.connect.ListSecurityProfilePermissionsResponse/NextToken
     :cognitect.aws.connect.ListSecurityProfilePermissionsResponse/LastModifiedRegion
     :cognitect.aws.connect.ListSecurityProfilePermissionsResponse/LastModifiedTime]))

(s/def
  :cognitect.aws.connect/ContactConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.connect.ContactConfiguration/ContactId]
    :opt-un
    [:cognitect.aws.connect.ContactConfiguration/IncludeRawMessage
     :cognitect.aws.connect.ContactConfiguration/ParticipantRole]))

(s/def
  :cognitect.aws.connect/SecurityProfileIds
  (s/coll-of :cognitect.aws.connect/SecurityProfileId :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.connect/AssociateInstanceStorageConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateInstanceStorageConfigRequest/InstanceId
     :cognitect.aws.connect.AssociateInstanceStorageConfigRequest/ResourceType
     :cognitect.aws.connect.AssociateInstanceStorageConfigRequest/StorageConfig]
    :opt-un
    [:cognitect.aws.connect.AssociateInstanceStorageConfigRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/S3Uri
  (s/spec
    #(re-matches
      (re-pattern "s3://\\S+/.+|https://\\\\S+\\\\.s3\\\\.\\\\S+\\\\.amazonaws\\\\.com/\\\\S+")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/HierarchyRestrictedResourceList
  (s/coll-of :cognitect.aws.connect/HierarchyRestrictedResourceName))

(s/def
  :cognitect.aws.connect/QuickConnectSearchSummaryList
  (s/coll-of :cognitect.aws.connect/QuickConnect))

(s/def
  :cognitect.aws.connect/MetadataUrl
  (s/spec
    (s/and string? #(<= 1 (count %) 2000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/HierarchyGroupName string?)

(s/def
  :cognitect.aws.connect/AnalyticsDataSetsResult
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AnalyticsDataSetsResult/DataSetId
     :cognitect.aws.connect.AnalyticsDataSetsResult/DataSetName]))

(s/def
  :cognitect.aws.connect/SearchUsersRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchUsersRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchUsersRequest/NextToken
     :cognitect.aws.connect.SearchUsersRequest/SearchFilter
     :cognitect.aws.connect.SearchUsersRequest/SearchCriteria
     :cognitect.aws.connect.SearchUsersRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/Permission
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DeleteContactFlowVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteContactFlowVersionRequest/InstanceId
     :cognitect.aws.connect.DeleteContactFlowVersionRequest/ContactFlowId
     :cognitect.aws.connect.DeleteContactFlowVersionRequest/ContactFlowVersion]))

(s/def
  :cognitect.aws.connect/InvisibleFieldInfo
  (s/keys :opt-un [:cognitect.aws.connect.InvisibleFieldInfo/Id]))

(s/def
  :cognitect.aws.connect/StartContactStreamingRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartContactStreamingRequest/InstanceId
     :cognitect.aws.connect.StartContactStreamingRequest/ContactId
     :cognitect.aws.connect.StartContactStreamingRequest/ChatStreamingConfiguration
     :cognitect.aws.connect.StartContactStreamingRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/HoursOfOperationSummaryList
  (s/coll-of :cognitect.aws.connect/HoursOfOperationSummary))

(s/def
  :cognitect.aws.connect/PhoneNumberType
  (s/spec
    string?
    :gen
    #(s/gen #{"THIRD_PARTY_TF" "THIRD_PARTY_DID" "DID" "UIFN" "TOLL_FREE" "SHORT_CODE" "SHARED"})))

(s/def
  :cognitect.aws.connect/RealtimeContactAnalysisSegment
  (s/keys
    :opt-un
    [:cognitect.aws.connect.RealtimeContactAnalysisSegment/Categories
     :cognitect.aws.connect.RealtimeContactAnalysisSegment/Event
     :cognitect.aws.connect.RealtimeContactAnalysisSegment/Attachments
     :cognitect.aws.connect.RealtimeContactAnalysisSegment/Transcript
     :cognitect.aws.connect.RealtimeContactAnalysisSegment/PostContactSummary
     :cognitect.aws.connect.RealtimeContactAnalysisSegment/Issues]))

(s/def
  :cognitect.aws.connect/AgentStatusSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AgentStatusSummary/Type
     :cognitect.aws.connect.AgentStatusSummary/LastModifiedRegion
     :cognitect.aws.connect.AgentStatusSummary/Arn
     :cognitect.aws.connect.AgentStatusSummary/LastModifiedTime
     :cognitect.aws.connect.AgentStatusSummary/Name
     :cognitect.aws.connect.AgentStatusSummary/Id]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentIssues
  (s/keys :req-un [:cognitect.aws.connect.RealTimeContactAnalysisSegmentIssues/IssuesDetected]))

(s/def
  :cognitect.aws.connect/ResourceArnOrId
  (s/spec
    (s/and string? #(<= 1 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 250) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisCategoryDetails
  (s/keys :req-un [:cognitect.aws.connect.RealTimeContactAnalysisCategoryDetails/PointsOfInterest]))

(s/def
  :cognitect.aws.connect/EmailAddressList
  (s/coll-of :cognitect.aws.connect/EmailAddressMetadata))

(s/def
  :cognitect.aws.connect/DeletePromptRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeletePromptRequest/InstanceId
     :cognitect.aws.connect.DeletePromptRequest/PromptId]))

(s/def
  :cognitect.aws.connect/OutboundEmailContent
  (s/keys
    :req-un
    [:cognitect.aws.connect.OutboundEmailContent/MessageSourceType]
    :opt-un
    [:cognitect.aws.connect.OutboundEmailContent/TemplatedMessageConfig
     :cognitect.aws.connect.OutboundEmailContent/RawMessage]))

(s/def
  :cognitect.aws.connect/EncryptionConfig
  (s/keys
    :req-un
    [:cognitect.aws.connect.EncryptionConfig/EncryptionType
     :cognitect.aws.connect.EncryptionConfig/KeyId]))

(s/def
  :cognitect.aws.connect/MetricDataV2
  (s/keys
    :opt-un
    [:cognitect.aws.connect.MetricDataV2/Value :cognitect.aws.connect.MetricDataV2/Metric]))

(s/def :cognitect.aws.connect/DeleteContactFlowModuleResponse (s/keys))

(s/def :cognitect.aws.connect/DeleteEmailAddressResponse (s/keys))

(s/def :cognitect.aws.connect/Groupings (s/coll-of :cognitect.aws.connect/Grouping :max-count 2))

(s/def
  :cognitect.aws.connect/ContactTagMap
  (s/map-of
    :cognitect.aws.connect/ContactTagKey
    :cognitect.aws.connect/ContactTagValue
    :min-count
    1
    :max-count
    6))

(s/def
  :cognitect.aws.connect/RoutingCriteriaInputStep
  (s/keys
    :opt-un
    [:cognitect.aws.connect.RoutingCriteriaInputStep/Expression
     :cognitect.aws.connect.RoutingCriteriaInputStep/Expiry]))

(s/def
  :cognitect.aws.connect/NumberCondition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.NumberCondition/MinValue
     :cognitect.aws.connect.NumberCondition/MaxValue
     :cognitect.aws.connect.NumberCondition/ComparisonType
     :cognitect.aws.connect.NumberCondition/FieldName]))

(s/def
  :cognitect.aws.connect/TotalPauseDurationInSeconds
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/StartChatContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartChatContactRequest/InstanceId
     :cognitect.aws.connect.StartChatContactRequest/ContactFlowId
     :cognitect.aws.connect.StartChatContactRequest/ParticipantDetails]
    :opt-un
    [:cognitect.aws.connect.StartChatContactRequest/CustomerId
     :cognitect.aws.connect.StartChatContactRequest/SegmentAttributes
     :cognitect.aws.connect.StartChatContactRequest/Attributes
     :cognitect.aws.connect.StartChatContactRequest/PersistentChat
     :cognitect.aws.connect.StartChatContactRequest/ChatDurationInMinutes
     :cognitect.aws.connect.StartChatContactRequest/InitialMessage
     :cognitect.aws.connect.StartChatContactRequest/SupportedMessagingContentTypes
     :cognitect.aws.connect.StartChatContactRequest/RelatedContactId
     :cognitect.aws.connect.StartChatContactRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/DeleteTrafficDistributionGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteTrafficDistributionGroupRequest/TrafficDistributionGroupId]))

(s/def
  :cognitect.aws.connect/IntegrationType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"VOICE_ID"
        "CALL_TRANSFER_CONNECTOR"
        "WISDOM_QUICK_RESPONSES"
        "FILE_SCANNER"
        "COGNITO_USER_POOL"
        "WISDOM_KNOWLEDGE_BASE"
        "Q_MESSAGE_TEMPLATES"
        "EVENT"
        "CASES_DOMAIN"
        "APPLICATION"
        "SES_IDENTITY"
        "PINPOINT_APP"
        "ANALYTICS_CONNECTOR"
        "WISDOM_ASSISTANT"})))

(s/def
  :cognitect.aws.connect/RefreshTokenDuration
  (s/spec (s/and int? #(<= 360 % 720)) :gen #(gen/choose 360 720)))

(s/def :cognitect.aws.connect/LexVersion (s/spec string? :gen #(s/gen #{"V2" "V1"})))

(s/def
  :cognitect.aws.connect/AccessDeniedException
  (s/keys :opt-un [:cognitect.aws.connect.AccessDeniedException/Message]))

(s/def
  :cognitect.aws.connect/ViewVersionSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ViewVersionSummary/Type
     :cognitect.aws.connect.ViewVersionSummary/Description
     :cognitect.aws.connect.ViewVersionSummary/Arn
     :cognitect.aws.connect.ViewVersionSummary/VersionDescription
     :cognitect.aws.connect.ViewVersionSummary/Version
     :cognitect.aws.connect.ViewVersionSummary/Name
     :cognitect.aws.connect.ViewVersionSummary/Id]))

(s/def :cognitect.aws.connect/DataSetIds (s/coll-of :cognitect.aws.connect/DataSetId))

(s/def
  :cognitect.aws.connect/AgentStatusState
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.connect/TagValueString
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/DeleteTaskTemplateResponse (s/keys))

(s/def
  :cognitect.aws.connect/GetPromptFileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetPromptFileRequest/InstanceId
     :cognitect.aws.connect.GetPromptFileRequest/PromptId]))

(s/def
  :cognitect.aws.connect/TagKeyString
  (s/spec
    (s/and string? #(>= 128 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/UpdateContactScheduleResponse (s/keys))

(s/def :cognitect.aws.connect/ErrorMessage string?)

(s/def
  :cognitect.aws.connect/DismissUserContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DismissUserContactRequest/UserId
     :cognitect.aws.connect.DismissUserContactRequest/InstanceId
     :cognitect.aws.connect.DismissUserContactRequest/ContactId]))

(s/def
  :cognitect.aws.connect/Distribution
  (s/keys
    :req-un
    [:cognitect.aws.connect.Distribution/Region :cognitect.aws.connect.Distribution/Percentage]))

(s/def
  :cognitect.aws.connect/AgentStatusName
  (s/spec
    (s/and string? #(<= 1 (count %) 127))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 127) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/UpdatePhoneNumberMetadataRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdatePhoneNumberMetadataRequest/PhoneNumberId]
    :opt-un
    [:cognitect.aws.connect.UpdatePhoneNumberMetadataRequest/PhoneNumberDescription
     :cognitect.aws.connect.UpdatePhoneNumberMetadataRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/DefaultVocabularyList
  (s/coll-of :cognitect.aws.connect/DefaultVocabulary))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisPostContactSummaryStatus
  (s/spec string? :gen #(s/gen #{"COMPLETED" "FAILED"})))

(s/def
  :cognitect.aws.connect/AssociatedContactSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AssociatedContactSummary/InitialContactId
     :cognitect.aws.connect.AssociatedContactSummary/PreviousContactId
     :cognitect.aws.connect.AssociatedContactSummary/ContactArn
     :cognitect.aws.connect.AssociatedContactSummary/ContactId
     :cognitect.aws.connect.AssociatedContactSummary/DisconnectTimestamp
     :cognitect.aws.connect.AssociatedContactSummary/InitiationTimestamp
     :cognitect.aws.connect.AssociatedContactSummary/Channel
     :cognitect.aws.connect.AssociatedContactSummary/InitiationMethod
     :cognitect.aws.connect.AssociatedContactSummary/RelatedContactId]))

(s/def :cognitect.aws.connect/DeleteTrafficDistributionGroupResponse (s/keys))

(s/def
  :cognitect.aws.connect/Subtype
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/AudioFeatures
  (s/keys :opt-un [:cognitect.aws.connect.AudioFeatures/EchoReduction]))

(s/def
  :cognitect.aws.connect/VoiceRecordingTrack
  (s/spec string? :gen #(s/gen #{"ALL" "FROM_AGENT" "TO_AGENT"})))

(s/def
  :cognitect.aws.connect/RoutingExpression
  (s/spec
    (s/and string? #(<= 1 (count %) 3000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 3000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/CommonHumanReadableDescription
  (s/spec #(re-matches (re-pattern "^[\\P{C}\\r\\n\\t]{1,250}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/ListPhoneNumbersRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListPhoneNumbersRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListPhoneNumbersRequest/NextToken
     :cognitect.aws.connect.ListPhoneNumbersRequest/PhoneNumberCountryCodes
     :cognitect.aws.connect.ListPhoneNumbersRequest/PhoneNumberTypes
     :cognitect.aws.connect.ListPhoneNumbersRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/ReplicateInstanceRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ReplicateInstanceRequest/InstanceId
     :cognitect.aws.connect.ReplicateInstanceRequest/ReplicaRegion
     :cognitect.aws.connect.ReplicateInstanceRequest/ReplicaAlias]
    :opt-un
    [:cognitect.aws.connect.ReplicateInstanceRequest/ClientToken]))

(s/def :cognitect.aws.connect/StopContactStreamingResponse (s/keys))

(s/def
  :cognitect.aws.connect/ReferenceStatusReason
  (s/spec
    (s/and string? #(<= 0 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 100) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/UseCaseSummaryList (s/coll-of :cognitect.aws.connect/UseCase))

(s/def :cognitect.aws.connect/UpdateTrafficDistributionResponse (s/keys))

(s/def :cognitect.aws.connect/VideoCapability (s/spec string? :gen #(s/gen #{"SEND"})))

(s/def :cognitect.aws.connect/AssignContactCategoryActionDefinition (s/keys))

(s/def
  :cognitect.aws.connect/HoursOfOperationOverrideConfigList
  (s/coll-of :cognitect.aws.connect/HoursOfOperationOverrideConfig :min-count 0 :max-count 100))

(s/def :cognitect.aws.connect/LexBotConfigList (s/coll-of :cognitect.aws.connect/LexBotConfig))

(s/def :cognitect.aws.connect/DismissUserContactResponse (s/keys))

(s/def
  :cognitect.aws.connect/AuthenticationError
  (s/spec #(re-matches (re-pattern "^[\\x20-\\x21\\x23-\\x5B\\x5D-\\x7E]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/MessageTemplateId
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/FileSizeInBytes
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/AgentInfo
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AgentInfo/AgentPauseDurationInSeconds
     :cognitect.aws.connect.AgentInfo/AfterContactWorkStartTimestamp
     :cognitect.aws.connect.AgentInfo/ConnectedToAgentTimestamp
     :cognitect.aws.connect.AgentInfo/AgentInitiatedHoldDuration
     :cognitect.aws.connect.AgentInfo/AfterContactWorkDuration
     :cognitect.aws.connect.AgentInfo/StateTransitions
     :cognitect.aws.connect.AgentInfo/Capabilities
     :cognitect.aws.connect.AgentInfo/HierarchyGroups
     :cognitect.aws.connect.AgentInfo/DeviceInfo
     :cognitect.aws.connect.AgentInfo/AfterContactWorkEndTimestamp
     :cognitect.aws.connect.AgentInfo/Id]))

(s/def
  :cognitect.aws.connect/UpdateContactRoutingDataRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactRoutingDataRequest/InstanceId
     :cognitect.aws.connect.UpdateContactRoutingDataRequest/ContactId]
    :opt-un
    [:cognitect.aws.connect.UpdateContactRoutingDataRequest/QueueTimeAdjustmentSeconds
     :cognitect.aws.connect.UpdateContactRoutingDataRequest/QueuePriority
     :cognitect.aws.connect.UpdateContactRoutingDataRequest/RoutingCriteria]))

(s/def
  :cognitect.aws.connect/EvaluationFormItem
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EvaluationFormItem/Question
     :cognitect.aws.connect.EvaluationFormItem/Section]))

(s/def
  :cognitect.aws.connect/GetContactAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetContactAttributesRequest/InstanceId
     :cognitect.aws.connect.GetContactAttributesRequest/InitialContactId]))

(s/def
  :cognitect.aws.connect/ListRoutingProfilesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListRoutingProfilesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListRoutingProfilesRequest/NextToken
     :cognitect.aws.connect.ListRoutingProfilesRequest/MaxResults]))

(s/def :cognitect.aws.connect/ScreenShareCapability (s/spec string? :gen #(s/gen #{"SEND"})))

(s/def
  :cognitect.aws.connect/QuickConnectSummaryList
  (s/coll-of :cognitect.aws.connect/QuickConnectSummary))

(s/def
  :cognitect.aws.connect/Meeting
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Meeting/MediaRegion
     :cognitect.aws.connect.Meeting/MediaPlacement
     :cognitect.aws.connect.Meeting/MeetingId
     :cognitect.aws.connect.Meeting/MeetingFeatures]))

(s/def
  :cognitect.aws.connect/SegmentAttributeValueMap
  (s/map-of
    :cognitect.aws.connect/SegmentAttributeName
    :cognitect.aws.connect/SegmentAttributeValue))

(s/def
  :cognitect.aws.connect/UserData
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UserData/Contacts
     :cognitect.aws.connect.UserData/User
     :cognitect.aws.connect.UserData/MaxSlotsByChannel
     :cognitect.aws.connect.UserData/RoutingProfile
     :cognitect.aws.connect.UserData/ActiveSlotsByChannel
     :cognitect.aws.connect.UserData/Status
     :cognitect.aws.connect.UserData/HierarchyPath
     :cognitect.aws.connect.UserData/AvailableSlotsByChannel
     :cognitect.aws.connect.UserData/NextStatus]))

(s/def
  :cognitect.aws.connect/TemplatedMessageConfig
  (s/keys
    :req-un
    [:cognitect.aws.connect.TemplatedMessageConfig/KnowledgeBaseId
     :cognitect.aws.connect.TemplatedMessageConfig/MessageTemplateId
     :cognitect.aws.connect.TemplatedMessageConfig/TemplateAttributes]))

(s/def
  :cognitect.aws.connect/CreateEvaluationFormResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateEvaluationFormResponse/EvaluationFormId
     :cognitect.aws.connect.CreateEvaluationFormResponse/EvaluationFormArn]))

(s/def
  :cognitect.aws.connect/SearchQueuesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchQueuesResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchQueuesResponse/NextToken
     :cognitect.aws.connect.SearchQueuesResponse/Queues]))

(s/def
  :cognitect.aws.connect/DateYearMonthDayFormat
  (s/spec #(re-matches (re-pattern "^\\d{4}-\\d{2}-\\d{2}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/ReleasePhoneNumberRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ReleasePhoneNumberRequest/PhoneNumberId]
    :opt-un
    [:cognitect.aws.connect.ReleasePhoneNumberRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/UpdateUserPhoneConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateUserPhoneConfigRequest/PhoneConfig
     :cognitect.aws.connect.UpdateUserPhoneConfigRequest/UserId
     :cognitect.aws.connect.UpdateUserPhoneConfigRequest/InstanceId]))

(s/def :cognitect.aws.connect/QueueSearchSummaryList (s/coll-of :cognitect.aws.connect/Queue))

(s/def
  :cognitect.aws.connect/CreateContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateContactRequest/InstanceId
     :cognitect.aws.connect.CreateContactRequest/Channel
     :cognitect.aws.connect.CreateContactRequest/InitiationMethod]
    :opt-un
    [:cognitect.aws.connect.CreateContactRequest/PreviousContactId
     :cognitect.aws.connect.CreateContactRequest/SegmentAttributes
     :cognitect.aws.connect.CreateContactRequest/ExpiryDurationInMinutes
     :cognitect.aws.connect.CreateContactRequest/Attributes
     :cognitect.aws.connect.CreateContactRequest/References
     :cognitect.aws.connect.CreateContactRequest/Description
     :cognitect.aws.connect.CreateContactRequest/Name
     :cognitect.aws.connect.CreateContactRequest/RelatedContactId
     :cognitect.aws.connect.CreateContactRequest/ClientToken
     :cognitect.aws.connect.CreateContactRequest/UserInfo
     :cognitect.aws.connect.CreateContactRequest/InitiateAs]))

(s/def
  :cognitect.aws.connect/UpdateRoutingProfileNameRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateRoutingProfileNameRequest/InstanceId
     :cognitect.aws.connect.UpdateRoutingProfileNameRequest/RoutingProfileId]
    :opt-un
    [:cognitect.aws.connect.UpdateRoutingProfileNameRequest/Description
     :cognitect.aws.connect.UpdateRoutingProfileNameRequest/Name]))

(s/def
  :cognitect.aws.connect/LargeNextToken
  (s/spec
    (s/and string? #(<= 1 (count %) 100000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100000) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/AgentIds (s/coll-of :cognitect.aws.connect/AgentId))

(s/def :cognitect.aws.connect/SecurityProfileId string?)

(s/def
  :cognitect.aws.connect/CurrentMetricResult
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CurrentMetricResult/Dimensions
     :cognitect.aws.connect.CurrentMetricResult/Collections]))

(s/def
  :cognitect.aws.connect/SearchableSegmentAttributeValueList
  (s/coll-of :cognitect.aws.connect/SearchableSegmentAttributeValue :min-count 1 :max-count 20))

(s/def
  :cognitect.aws.connect/HistoricalMetricDataCollections
  (s/coll-of :cognitect.aws.connect/HistoricalMetricData))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentAttachments
  (s/keys
    :req-un
    [:cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/Id
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/ParticipantId
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/ParticipantRole
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/Attachments
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/Time]
    :opt-un
    [:cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/DisplayName]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisCharacterIntervals
  (s/coll-of :cognitect.aws.connect/RealTimeContactAnalysisCharacterInterval))

(s/def
  :cognitect.aws.connect/ListContactFlowVersionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListContactFlowVersionsResponse/NextToken
     :cognitect.aws.connect.ListContactFlowVersionsResponse/ContactFlowVersionSummaryList]))

(s/def
  :cognitect.aws.connect/CommonNameLength127
  (s/spec
    (s/and string? #(<= 1 (count %) 127))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 127) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/MaxResult7 (s/spec (s/and int? #(<= 1 % 7)) :gen #(gen/choose 1 7)))

(s/def
  :cognitect.aws.connect/ParticipantTimerConfigList
  (s/coll-of :cognitect.aws.connect/ParticipantTimerConfiguration :min-count 1 :max-count 6))

(s/def
  :cognitect.aws.connect/UserSearchFilter
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UserSearchFilter/UserAttributeFilter
     :cognitect.aws.connect.UserSearchFilter/TagFilter]))

(s/def
  :cognitect.aws.connect/QueueSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.QueueSearchCriteria/QueueTypeCondition
     :cognitect.aws.connect.QueueSearchCriteria/OrConditions
     :cognitect.aws.connect.QueueSearchCriteria/StringCondition
     :cognitect.aws.connect.QueueSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/ListAnalyticsDataAssociationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListAnalyticsDataAssociationsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListAnalyticsDataAssociationsRequest/NextToken
     :cognitect.aws.connect.ListAnalyticsDataAssociationsRequest/DataSetId
     :cognitect.aws.connect.ListAnalyticsDataAssociationsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/Dimensions
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Dimensions/RoutingStepExpression
     :cognitect.aws.connect.Dimensions/Queue
     :cognitect.aws.connect.Dimensions/RoutingProfile
     :cognitect.aws.connect.Dimensions/Channel]))

(s/def
  :cognitect.aws.connect/SearchContactFlowsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchContactFlowsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchContactFlowsRequest/NextToken
     :cognitect.aws.connect.SearchContactFlowsRequest/SearchFilter
     :cognitect.aws.connect.SearchContactFlowsRequest/SearchCriteria
     :cognitect.aws.connect.SearchContactFlowsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/SearchContactFlowModulesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchContactFlowModulesResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchContactFlowModulesResponse/NextToken
     :cognitect.aws.connect.SearchContactFlowModulesResponse/ContactFlowModules]))

(s/def
  :cognitect.aws.connect/SearchableContactAttributesCriteriaList
  (s/coll-of :cognitect.aws.connect/SearchableContactAttributesCriteria :min-count 0 :max-count 15))

(s/def
  :cognitect.aws.connect/TaskActionDefinition
  (s/keys
    :req-un
    [:cognitect.aws.connect.TaskActionDefinition/Name
     :cognitect.aws.connect.TaskActionDefinition/ContactFlowId]
    :opt-un
    [:cognitect.aws.connect.TaskActionDefinition/References
     :cognitect.aws.connect.TaskActionDefinition/Description]))

(s/def
  :cognitect.aws.connect/QuickConnectSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.QuickConnectSearchFilter/TagFilter]))

(s/def
  :cognitect.aws.connect/DeleteContactEvaluationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteContactEvaluationRequest/InstanceId
     :cognitect.aws.connect.DeleteContactEvaluationRequest/EvaluationId]))

(s/def
  :cognitect.aws.connect/CustomerId
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DirectoryId
  (s/spec #(re-matches (re-pattern "^d-[0-9a-f]{10}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/IntervalPeriod
  (s/spec string? :gen #(s/gen #{"WEEK" "TOTAL" "DAY" "THIRTY_MIN" "FIFTEEN_MIN" "HOUR"})))

(s/def :cognitect.aws.connect/DeletePushNotificationRegistrationResponse (s/keys))

(s/def
  :cognitect.aws.connect/VocabularyLanguageCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"en-AB"
        "it-IT"
        "en-WL"
        "de-DE"
        "ca-ES"
        "en-AU"
        "en-IN"
        "da-DK"
        "es-US"
        "fi-FI"
        "id-ID"
        "en-IE"
        "ar-AE"
        "pt-BR"
        "tl-PH"
        "zh-CN"
        "en-NZ"
        "de-CH"
        "hi-IN"
        "nl-NL"
        "fr-CA"
        "ja-JP"
        "en-US"
        "no-NO"
        "fr-FR"
        "en-GB"
        "en-ZA"
        "ko-KR"
        "es-ES"
        "pt-PT"
        "pl-PL"
        "sv-SE"
        "ms-MY"})))

(s/def
  :cognitect.aws.connect/AnsweringMachineDetectionStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AMD_UNRESOLVED"
        "AMD_UNANSWERED"
        "VOICEMAIL_NO_BEEP"
        "AMD_ERROR"
        "UNDETECTED"
        "ERROR"
        "SIT_TONE_BUSY"
        "FAX_MACHINE_DETECTED"
        "AMD_NOT_APPLICABLE"
        "ANSWERED"
        "VOICEMAIL_BEEP"
        "SIT_TONE_DETECTED"
        "SIT_TONE_INVALID_NUMBER"
        "HUMAN_ANSWERED"})))

(s/def
  :cognitect.aws.connect/TaskTemplateField
  (s/keys
    :req-un
    [:cognitect.aws.connect.TaskTemplateField/Id]
    :opt-un
    [:cognitect.aws.connect.TaskTemplateField/Type
     :cognitect.aws.connect.TaskTemplateField/SingleSelectOptions
     :cognitect.aws.connect.TaskTemplateField/Description]))

(s/def
  :cognitect.aws.connect/SegmentAttributeValueInteger
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/AssociateInstanceStorageConfigResponse
  (s/keys :opt-un [:cognitect.aws.connect.AssociateInstanceStorageConfigResponse/AssociationId]))

(s/def
  :cognitect.aws.connect/ListAuthenticationProfilesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListAuthenticationProfilesResponse/NextToken
     :cognitect.aws.connect.ListAuthenticationProfilesResponse/AuthenticationProfileSummaryList]))

(s/def
  :cognitect.aws.connect/PromptDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 250) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/TargetListType (s/spec string? :gen #(s/gen #{"PROFICIENCIES"})))

(s/def
  :cognitect.aws.connect/FilterValueList
  (s/coll-of :cognitect.aws.connect/ResourceArnOrId :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.connect/SearchableSegmentAttributes
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchableSegmentAttributes/Criteria]
    :opt-un
    [:cognitect.aws.connect.SearchableSegmentAttributes/MatchType]))

(s/def
  :cognitect.aws.connect/UpdateRoutingProfileAgentAvailabilityTimerRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateRoutingProfileAgentAvailabilityTimerRequest/InstanceId
     :cognitect.aws.connect.UpdateRoutingProfileAgentAvailabilityTimerRequest/RoutingProfileId
     :cognitect.aws.connect.UpdateRoutingProfileAgentAvailabilityTimerRequest/AgentAvailabilityTimer]))

(s/def
  :cognitect.aws.connect/SearchUserHierarchyGroupsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchUserHierarchyGroupsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchUserHierarchyGroupsRequest/NextToken
     :cognitect.aws.connect.SearchUserHierarchyGroupsRequest/SearchFilter
     :cognitect.aws.connect.SearchUserHierarchyGroupsRequest/SearchCriteria
     :cognitect.aws.connect.SearchUserHierarchyGroupsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/ProficiencyLevel
  (s/spec
    (s/and double? #(<= 1.0 % 5.0))
    :gen
    #(gen/double* {:infinite? false, :NaN? false, :min 1.0, :max 5.0})))

(s/def
  :cognitect.aws.connect/HoursOfOperationTimeSlice
  (s/keys
    :req-un
    [:cognitect.aws.connect.HoursOfOperationTimeSlice/Hours
     :cognitect.aws.connect.HoursOfOperationTimeSlice/Minutes]))

(s/def
  :cognitect.aws.connect/AttachmentName
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/AnalyticsDataAssociationResults
  (s/coll-of :cognitect.aws.connect/AnalyticsDataAssociationResult))

(s/def
  :cognitect.aws.connect/ActivateEvaluationFormResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.ActivateEvaluationFormResponse/EvaluationFormId
     :cognitect.aws.connect.ActivateEvaluationFormResponse/EvaluationFormArn
     :cognitect.aws.connect.ActivateEvaluationFormResponse/EvaluationFormVersion]))

(s/def
  :cognitect.aws.connect/QuickConnectSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.QuickConnectSearchCriteria/OrConditions
     :cognitect.aws.connect.QuickConnectSearchCriteria/StringCondition
     :cognitect.aws.connect.QuickConnectSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/AgentStatusSummaryList
  (s/coll-of :cognitect.aws.connect/AgentStatusSummary))

(s/def
  :cognitect.aws.connect/EvaluationFormQuestionTitle
  (s/spec
    (s/and string? #(<= 0 (count %) 350))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 350) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/StartEmailContactResponse
  (s/keys :opt-un [:cognitect.aws.connect.StartEmailContactResponse/ContactId]))

(s/def
  :cognitect.aws.connect/LexBot
  (s/keys :req-un [:cognitect.aws.connect.LexBot/Name :cognitect.aws.connect.LexBot/LexRegion]))

(s/def
  :cognitect.aws.connect/GetFlowAssociationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetFlowAssociationRequest/InstanceId
     :cognitect.aws.connect.GetFlowAssociationRequest/ResourceId
     :cognitect.aws.connect.GetFlowAssociationRequest/ResourceType]))

(s/def
  :cognitect.aws.connect/CreateQuickConnectResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateQuickConnectResponse/QuickConnectId
     :cognitect.aws.connect.CreateQuickConnectResponse/QuickConnectARN]))

(s/def
  :cognitect.aws.connect/QueueSearchConditionList
  (s/coll-of :cognitect.aws.connect/QueueSearchCriteria))

(s/def
  :cognitect.aws.connect/InstanceId
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ParticipantId
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/UpdateQueueOutboundCallerConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateQueueOutboundCallerConfigRequest/InstanceId
     :cognitect.aws.connect.UpdateQueueOutboundCallerConfigRequest/QueueId
     :cognitect.aws.connect.UpdateQueueOutboundCallerConfigRequest/OutboundCallerConfig]))

(s/def
  :cognitect.aws.connect/ContactTagKeys
  (s/coll-of :cognitect.aws.connect/ContactTagKey :min-count 1 :max-count 6))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisCharacterInterval
  (s/keys
    :req-un
    [:cognitect.aws.connect.RealTimeContactAnalysisCharacterInterval/BeginOffsetChar
     :cognitect.aws.connect.RealTimeContactAnalysisCharacterInterval/EndOffsetChar]))

(s/def
  :cognitect.aws.connect/StringCondition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.StringCondition/ComparisonType
     :cognitect.aws.connect.StringCondition/Value
     :cognitect.aws.connect.StringCondition/FieldName]))

(s/def :cognitect.aws.connect/AssociateFlowResponse (s/keys))

(s/def
  :cognitect.aws.connect/EmailAddress
  (s/spec #(re-matches (re-pattern "[^\\s@]+@[^\\s@]+\\.[^\\s@]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/DescribeContactFlowModuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeContactFlowModuleRequest/InstanceId
     :cognitect.aws.connect.DescribeContactFlowModuleRequest/ContactFlowModuleId]))

(s/def :cognitect.aws.connect/UpdateContactFlowNameResponse (s/keys))

(s/def
  :cognitect.aws.connect/MetricDataCollectionsV2
  (s/coll-of :cognitect.aws.connect/MetricDataV2))

(s/def
  :cognitect.aws.connect/EvaluationAnswerDataNumericValue
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.connect/DeleteQuickConnectRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteQuickConnectRequest/InstanceId
     :cognitect.aws.connect.DeleteQuickConnectRequest/QuickConnectId]))

(s/def
  :cognitect.aws.connect/UpdateTaskTemplateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UpdateTaskTemplateResponse/InstanceId
     :cognitect.aws.connect.UpdateTaskTemplateResponse/ContactFlowId
     :cognitect.aws.connect.UpdateTaskTemplateResponse/Fields
     :cognitect.aws.connect.UpdateTaskTemplateResponse/Status
     :cognitect.aws.connect.UpdateTaskTemplateResponse/SelfAssignFlowId
     :cognitect.aws.connect.UpdateTaskTemplateResponse/CreatedTime
     :cognitect.aws.connect.UpdateTaskTemplateResponse/Description
     :cognitect.aws.connect.UpdateTaskTemplateResponse/Arn
     :cognitect.aws.connect.UpdateTaskTemplateResponse/Defaults
     :cognitect.aws.connect.UpdateTaskTemplateResponse/LastModifiedTime
     :cognitect.aws.connect.UpdateTaskTemplateResponse/Name
     :cognitect.aws.connect.UpdateTaskTemplateResponse/Id
     :cognitect.aws.connect.UpdateTaskTemplateResponse/Constraints]))

(s/def
  :cognitect.aws.connect/ListAuthenticationProfilesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListAuthenticationProfilesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListAuthenticationProfilesRequest/NextToken
     :cognitect.aws.connect.ListAuthenticationProfilesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/ImportPhoneNumberResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ImportPhoneNumberResponse/PhoneNumberArn
     :cognitect.aws.connect.ImportPhoneNumberResponse/PhoneNumberId]))

(s/def :cognitect.aws.connect/ViewActions (s/coll-of :cognitect.aws.connect/ViewAction))

(s/def
  :cognitect.aws.connect/ParticipantCapabilities
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ParticipantCapabilities/Video
     :cognitect.aws.connect.ParticipantCapabilities/ScreenShare]))

(s/def
  :cognitect.aws.connect/CommonAttributeOrConditionList
  (s/coll-of :cognitect.aws.connect/CommonAttributeAndCondition))

(s/def
  :cognitect.aws.connect/ResourceId
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/AssociatePhoneNumberContactFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociatePhoneNumberContactFlowRequest/PhoneNumberId
     :cognitect.aws.connect.AssociatePhoneNumberContactFlowRequest/InstanceId
     :cognitect.aws.connect.AssociatePhoneNumberContactFlowRequest/ContactFlowId]))

(s/def
  :cognitect.aws.connect/CreateSecurityProfileName
  (s/spec #(re-matches (re-pattern "^[ a-zA-Z0-9_@-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/CreatePromptRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreatePromptRequest/InstanceId
     :cognitect.aws.connect.CreatePromptRequest/Name
     :cognitect.aws.connect.CreatePromptRequest/S3Uri]
    :opt-un
    [:cognitect.aws.connect.CreatePromptRequest/Tags
     :cognitect.aws.connect.CreatePromptRequest/Description]))

(s/def
  :cognitect.aws.connect/DeviceInfo
  (s/keys
    :opt-un
    [:cognitect.aws.connect.DeviceInfo/PlatformName
     :cognitect.aws.connect.DeviceInfo/PlatformVersion
     :cognitect.aws.connect.DeviceInfo/OperatingSystem]))

(s/def
  :cognitect.aws.connect/SearchableSegmentAttributesCriteriaList
  (s/coll-of :cognitect.aws.connect/SearchableSegmentAttributesCriteria :min-count 1 :max-count 15))

(s/def
  :cognitect.aws.connect/UpdateQueueOutboundEmailConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateQueueOutboundEmailConfigRequest/InstanceId
     :cognitect.aws.connect.UpdateQueueOutboundEmailConfigRequest/QueueId
     :cognitect.aws.connect.UpdateQueueOutboundEmailConfigRequest/OutboundEmailConfig]))

(s/def :cognitect.aws.connect/HoursOfOperationName string?)

(s/def
  :cognitect.aws.connect/ReferenceKey
  (s/spec
    (s/and string? #(<= 1 (count %) 4096))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 4096) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/Sort
  (s/keys :req-un [:cognitect.aws.connect.Sort/FieldName :cognitect.aws.connect.Sort/Order]))

(s/def
  :cognitect.aws.connect/ActionType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"UPDATE_CASE"
        "SEND_NOTIFICATION"
        "ASSIGN_CONTACT_CATEGORY"
        "END_ASSOCIATED_TASKS"
        "CREATE_TASK"
        "GENERATE_EVENTBRIDGE_EVENT"
        "SUBMIT_AUTO_EVALUATION"
        "CREATE_CASE"
        "ASSIGN_SLA"})))

(s/def :cognitect.aws.connect/TagAndConditionList (s/coll-of :cognitect.aws.connect/TagCondition))

(s/def
  :cognitect.aws.connect/RequiredTaskTemplateFields
  (s/coll-of :cognitect.aws.connect/RequiredFieldInfo))

(s/def
  :cognitect.aws.connect/ContactFlowName
  (s/spec
    (s/and string? #(<= 1 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EmailAttachment
  (s/keys
    :req-un
    [:cognitect.aws.connect.EmailAttachment/FileName :cognitect.aws.connect.EmailAttachment/S3Url]))

(s/def
  :cognitect.aws.connect/SendChatIntegrationEventRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SendChatIntegrationEventRequest/SourceId
     :cognitect.aws.connect.SendChatIntegrationEventRequest/DestinationId
     :cognitect.aws.connect.SendChatIntegrationEventRequest/Event]
    :opt-un
    [:cognitect.aws.connect.SendChatIntegrationEventRequest/Subtype
     :cognitect.aws.connect.SendChatIntegrationEventRequest/NewSessionDetails]))

(s/def
  :cognitect.aws.connect/NextToken2500
  (s/spec
    (s/and string? #(<= 1 (count %) 2500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DescribeVocabularyRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeVocabularyRequest/InstanceId
     :cognitect.aws.connect.DescribeVocabularyRequest/VocabularyId]))

(s/def :cognitect.aws.connect/Email string?)

(s/def
  :cognitect.aws.connect/ListRulesResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListRulesResponse/RuleSummaryList]
    :opt-un
    [:cognitect.aws.connect.ListRulesResponse/NextToken]))

(s/def
  :cognitect.aws.connect/SignInConfig
  (s/keys :req-un [:cognitect.aws.connect.SignInConfig/Distributions]))

(s/def
  :cognitect.aws.connect/ListFlowAssociationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListFlowAssociationsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListFlowAssociationsRequest/NextToken
     :cognitect.aws.connect.ListFlowAssociationsRequest/ResourceType
     :cognitect.aws.connect.ListFlowAssociationsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/EvaluationFormNumericQuestionOption
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormNumericQuestionOption/MinValue
     :cognitect.aws.connect.EvaluationFormNumericQuestionOption/MaxValue]
    :opt-un
    [:cognitect.aws.connect.EvaluationFormNumericQuestionOption/Score
     :cognitect.aws.connect.EvaluationFormNumericQuestionOption/AutomaticFail]))

(s/def
  :cognitect.aws.connect/CreateContactFlowVersionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateContactFlowVersionResponse/ContactFlowArn
     :cognitect.aws.connect.CreateContactFlowVersionResponse/Version]))

(s/def
  :cognitect.aws.connect/TransferContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.TransferContactRequest/InstanceId
     :cognitect.aws.connect.TransferContactRequest/ContactId
     :cognitect.aws.connect.TransferContactRequest/ContactFlowId]
    :opt-un
    [:cognitect.aws.connect.TransferContactRequest/UserId
     :cognitect.aws.connect.TransferContactRequest/ClientToken
     :cognitect.aws.connect.TransferContactRequest/QueueId]))

(s/def :cognitect.aws.connect/MetricsV2 (s/coll-of :cognitect.aws.connect/MetricV2))

(s/def
  :cognitect.aws.connect/SlaName
  (s/spec #(re-matches (re-pattern "^.*[\\S]$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/ContactFlowModuleContent
  (s/spec
    (s/and string? #(<= 1 (count %) 256000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DeleteUseCaseRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteUseCaseRequest/InstanceId
     :cognitect.aws.connect.DeleteUseCaseRequest/IntegrationAssociationId
     :cognitect.aws.connect.DeleteUseCaseRequest/UseCaseId]))

(s/def
  :cognitect.aws.connect/PredefinedAttributeSearchSummaryList
  (s/coll-of :cognitect.aws.connect/PredefinedAttribute))

(s/def
  :cognitect.aws.connect/InstanceReplicationStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"INSTANCE_REPLICATION_IN_PROGRESS"
        "INSTANCE_REPLICATION_DELETION_FAILED"
        "INSTANCE_REPLICATION_FAILED"
        "INSTANCE_REPLICA_DELETING"
        "INSTANCE_REPLICATION_COMPLETE"
        "RESOURCE_REPLICATION_NOT_STARTED"})))

(s/def
  :cognitect.aws.connect/ListEvaluationFormsResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListEvaluationFormsResponse/EvaluationFormSummaryList]
    :opt-un
    [:cognitect.aws.connect.ListEvaluationFormsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/StringComparisonType
  (s/spec string? :gen #(s/gen #{"EXACT" "CONTAINS" "STARTS_WITH"})))

(s/def
  :cognitect.aws.connect/SuccessfulRequest
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SuccessfulRequest/ContactId
     :cognitect.aws.connect.SuccessfulRequest/RequestIdentifier]))

(s/def
  :cognitect.aws.connect/SingleSelectQuestionRuleCategoryAutomationLabel
  (s/spec
    (s/and string? #(<= 1 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EvaluationAnswerData
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EvaluationAnswerData/NotApplicable
     :cognitect.aws.connect.EvaluationAnswerData/NumericValue
     :cognitect.aws.connect.EvaluationAnswerData/StringValue]))

(s/def
  :cognitect.aws.connect/GetContactMetricsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.GetContactMetricsResponse/MetricResults
     :cognitect.aws.connect.GetContactMetricsResponse/Arn
     :cognitect.aws.connect.GetContactMetricsResponse/Id]))

(s/def
  :cognitect.aws.connect/AttributeOrConditionList
  (s/coll-of :cognitect.aws.connect/AttributeAndCondition))

(s/def
  :cognitect.aws.connect/ContactFlowVersionSummaryList
  (s/coll-of :cognitect.aws.connect/ContactFlowVersionSummary))

(s/def
  :cognitect.aws.connect/NumberComparisonType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"RANGE" "LESSER_OR_EQUAL" "GREATER" "EQUAL" "LESSER" "GREATER_OR_EQUAL" "NOT_EQUAL"})))

(s/def
  :cognitect.aws.connect/PhoneNumberStatus
  (s/keys
    :opt-un
    [:cognitect.aws.connect.PhoneNumberStatus/Status
     :cognitect.aws.connect.PhoneNumberStatus/Message]))

(s/def
  :cognitect.aws.connect/MetricFiltersV2List
  (s/coll-of :cognitect.aws.connect/MetricFilterV2 :max-count 2))

(s/def
  :cognitect.aws.connect/EvaluationFormScoringMode
  (s/spec string? :gen #(s/gen #{"SECTION_ONLY" "QUESTION_ONLY"})))

(s/def
  :cognitect.aws.connect/FiltersV2List
  (s/coll-of :cognitect.aws.connect/FilterV2 :min-count 1 :max-count 5))

(s/def
  :cognitect.aws.connect/AuthenticationProfileId
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/StateTransitions (s/coll-of :cognitect.aws.connect/StateTransition))

(s/def :cognitect.aws.connect/DeleteContactFlowVersionResponse (s/keys))

(s/def :cognitect.aws.connect/DeleteViewVersionResponse (s/keys))

(s/def
  :cognitect.aws.connect/ContactFlowSearchSummaryList
  (s/coll-of :cognitect.aws.connect/ContactFlow))

(s/def
  :cognitect.aws.connect/ListUserHierarchyGroupsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListUserHierarchyGroupsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListUserHierarchyGroupsRequest/NextToken
     :cognitect.aws.connect.ListUserHierarchyGroupsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/AliasArn
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SearchAvailablePhoneNumbersRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/PhoneNumberCountryCode
     :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/PhoneNumberType]
    :opt-un
    [:cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/InstanceId
     :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/TargetArn
     :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/NextToken
     :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/MaxResults
     :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/PhoneNumberPrefix]))

(s/def
  :cognitect.aws.connect/OutboundCallerIdName
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/QueueTimeAdjustmentSeconds
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.connect/Conditions (s/coll-of :cognitect.aws.connect/Condition))

(s/def
  :cognitect.aws.connect/CreateParticipantResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateParticipantResponse/ParticipantId
     :cognitect.aws.connect.CreateParticipantResponse/ParticipantCredentials]))

(s/def
  :cognitect.aws.connect/HistoricalMetricResult
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HistoricalMetricResult/Dimensions
     :cognitect.aws.connect.HistoricalMetricResult/Collections]))

(s/def
  :cognitect.aws.connect/InstanceSummaryList
  (s/coll-of :cognitect.aws.connect/InstanceSummary))

(s/def
  :cognitect.aws.connect/ContactDetailDescription
  (s/spec
    (s/and string? #(<= 0 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/OriginsList (s/coll-of :cognitect.aws.connect/Origin))

(s/def
  :cognitect.aws.connect/DurationInSeconds
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/ContactFlowId
  (s/spec
    (s/and string? #(>= 500 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SignInDistributionList
  (s/coll-of :cognitect.aws.connect/SignInDistribution))

(s/def
  :cognitect.aws.connect/TaskTemplateMetadata
  (s/keys
    :opt-un
    [:cognitect.aws.connect.TaskTemplateMetadata/Status
     :cognitect.aws.connect.TaskTemplateMetadata/CreatedTime
     :cognitect.aws.connect.TaskTemplateMetadata/Description
     :cognitect.aws.connect.TaskTemplateMetadata/Arn
     :cognitect.aws.connect.TaskTemplateMetadata/LastModifiedTime
     :cognitect.aws.connect.TaskTemplateMetadata/Name
     :cognitect.aws.connect.TaskTemplateMetadata/Id]))

(s/def
  :cognitect.aws.connect/HierarchyStructureUpdate
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HierarchyStructureUpdate/LevelFour
     :cognitect.aws.connect.HierarchyStructureUpdate/LevelOne
     :cognitect.aws.connect.HierarchyStructureUpdate/LevelTwo
     :cognitect.aws.connect.HierarchyStructureUpdate/LevelThree
     :cognitect.aws.connect.HierarchyStructureUpdate/LevelFive]))

(s/def
  :cognitect.aws.connect/ListUserProficienciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListUserProficienciesRequest/InstanceId
     :cognitect.aws.connect.ListUserProficienciesRequest/UserId]
    :opt-un
    [:cognitect.aws.connect.ListUserProficienciesRequest/NextToken
     :cognitect.aws.connect.ListUserProficienciesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/ListHoursOfOperationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListHoursOfOperationsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListHoursOfOperationsRequest/NextToken
     :cognitect.aws.connect.ListHoursOfOperationsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/BatchGetFlowAssociationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.BatchGetFlowAssociationRequest/InstanceId
     :cognitect.aws.connect.BatchGetFlowAssociationRequest/ResourceIds]
    :opt-un
    [:cognitect.aws.connect.BatchGetFlowAssociationRequest/ResourceType]))

(s/def
  :cognitect.aws.connect/RuleAction
  (s/keys
    :req-un
    [:cognitect.aws.connect.RuleAction/ActionType]
    :opt-un
    [:cognitect.aws.connect.RuleAction/UpdateCaseAction
     :cognitect.aws.connect.RuleAction/SendNotificationAction
     :cognitect.aws.connect.RuleAction/TaskAction
     :cognitect.aws.connect.RuleAction/CreateCaseAction
     :cognitect.aws.connect.RuleAction/AssignSlaAction
     :cognitect.aws.connect.RuleAction/SubmitAutoEvaluationAction
     :cognitect.aws.connect.RuleAction/EndAssociatedTasksAction
     :cognitect.aws.connect.RuleAction/EventBridgeAction
     :cognitect.aws.connect.RuleAction/AssignContactCategoryAction]))

(s/def
  :cognitect.aws.connect/UploadUrlMetadata
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UploadUrlMetadata/UrlExpiry
     :cognitect.aws.connect.UploadUrlMetadata/Url
     :cognitect.aws.connect.UploadUrlMetadata/HeadersToInclude]))

(s/def
  :cognitect.aws.connect/EndpointAddress
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EvaluationAnswersInputMap
  (s/map-of
    :cognitect.aws.connect/ResourceId
    :cognitect.aws.connect/EvaluationAnswerInput
    :max-count
    100))

(s/def :cognitect.aws.connect/SlaType (s/spec string? :gen #(s/gen #{"CaseField"})))

(s/def
  :cognitect.aws.connect/OverrideDays
  (s/spec
    string?
    :gen
    #(s/gen #{"WEDNESDAY" "SUNDAY" "THURSDAY" "TUESDAY" "FRIDAY" "SATURDAY" "MONDAY"})))

(s/def
  :cognitect.aws.connect/SearchEmailAddressesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchEmailAddressesResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchEmailAddressesResponse/NextToken
     :cognitect.aws.connect.SearchEmailAddressesResponse/EmailAddresses]))

(s/def
  :cognitect.aws.connect/DescribeUserHierarchyGroupResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeUserHierarchyGroupResponse/HierarchyGroup]))

(s/def
  :cognitect.aws.connect/ChatEvent
  (s/keys
    :req-un
    [:cognitect.aws.connect.ChatEvent/Type]
    :opt-un
    [:cognitect.aws.connect.ChatEvent/ContentType :cognitect.aws.connect.ChatEvent/Content]))

(s/def :cognitect.aws.connect/MetricResultsV2 (s/coll-of :cognitect.aws.connect/MetricResultV2))

(s/def
  :cognitect.aws.connect/RoutingProfileQueueConfigList
  (s/coll-of :cognitect.aws.connect/RoutingProfileQueueConfig :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.connect/DisassociateAnalyticsDataSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateAnalyticsDataSetRequest/InstanceId
     :cognitect.aws.connect.DisassociateAnalyticsDataSetRequest/DataSetId]
    :opt-un
    [:cognitect.aws.connect.DisassociateAnalyticsDataSetRequest/TargetAccountId]))

(s/def
  :cognitect.aws.connect/ParticipantDetails
  (s/keys :req-un [:cognitect.aws.connect.ParticipantDetails/DisplayName]))

(s/def
  :cognitect.aws.connect/ConditionalOperationFailedException
  (s/keys :opt-un [:cognitect.aws.connect.ConditionalOperationFailedException/Message]))

(s/def
  :cognitect.aws.connect/ViewVersionSummaryList
  (s/coll-of :cognitect.aws.connect/ViewVersionSummary))

(s/def
  :cognitect.aws.connect/TaskTemplateFieldDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/PotentialAudioQualityIssue
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/CreateViewResponse
  (s/keys :opt-un [:cognitect.aws.connect.CreateViewResponse/View]))

(s/def
  :cognitect.aws.connect/GetCurrentUserDataRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetCurrentUserDataRequest/InstanceId
     :cognitect.aws.connect.GetCurrentUserDataRequest/Filters]
    :opt-un
    [:cognitect.aws.connect.GetCurrentUserDataRequest/NextToken
     :cognitect.aws.connect.GetCurrentUserDataRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/Channel
  (s/spec string? :gen #(s/gen #{"VOICE" "TASK" "EMAIL" "CHAT"})))

(s/def
  :cognitect.aws.connect/ReferenceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"URL" "CONTACT_ANALYSIS" "NUMBER" "DATE" "STRING" "EMAIL_MESSAGE" "EMAIL" "ATTACHMENT"})))

(s/def
  :cognitect.aws.connect/QuickConnectTypes
  (s/coll-of :cognitect.aws.connect/QuickConnectType :max-count 3))

(s/def
  :cognitect.aws.connect/CreateRoutingProfileResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateRoutingProfileResponse/RoutingProfileId
     :cognitect.aws.connect.CreateRoutingProfileResponse/RoutingProfileArn]))

(s/def
  :cognitect.aws.connect/DeleteVocabularyResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteVocabularyResponse/VocabularyArn
     :cognitect.aws.connect.DeleteVocabularyResponse/VocabularyId
     :cognitect.aws.connect.DeleteVocabularyResponse/State]))

(s/def
  :cognitect.aws.connect/Applications
  (s/coll-of :cognitect.aws.connect/Application :max-count 10))

(s/def
  :cognitect.aws.connect/NewSessionDetails
  (s/keys
    :opt-un
    [:cognitect.aws.connect.NewSessionDetails/Attributes
     :cognitect.aws.connect.NewSessionDetails/StreamingConfiguration
     :cognitect.aws.connect.NewSessionDetails/ParticipantDetails
     :cognitect.aws.connect.NewSessionDetails/SupportedMessagingContentTypes]))

(s/def :cognitect.aws.connect/UpdateParticipantAuthenticationResponse (s/keys))

(s/def
  :cognitect.aws.connect/ListBotsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListBotsResponse/LexBots
     :cognitect.aws.connect.ListBotsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/EndpointInfo
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EndpointInfo/Address
     :cognitect.aws.connect.EndpointInfo/Type
     :cognitect.aws.connect.EndpointInfo/DisplayName]))

(s/def
  :cognitect.aws.connect/FilterV2
  (s/keys
    :opt-un
    [:cognitect.aws.connect.FilterV2/FilterValues :cognitect.aws.connect.FilterV2/FilterKey]))

(s/def
  :cognitect.aws.connect/ResumeContactRecordingRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ResumeContactRecordingRequest/InstanceId
     :cognitect.aws.connect.ResumeContactRecordingRequest/ContactId
     :cognitect.aws.connect.ResumeContactRecordingRequest/InitialContactId]
    :opt-un
    [:cognitect.aws.connect.ResumeContactRecordingRequest/ContactRecordingType]))

(s/def
  :cognitect.aws.connect/ListSecurityProfilePermissionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListSecurityProfilePermissionsRequest/SecurityProfileId
     :cognitect.aws.connect.ListSecurityProfilePermissionsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListSecurityProfilePermissionsRequest/NextToken
     :cognitect.aws.connect.ListSecurityProfilePermissionsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/SecurityProfileSearchConditionList
  (s/coll-of :cognitect.aws.connect/SecurityProfileSearchCriteria))

(s/def
  :cognitect.aws.connect/RoutingProfileSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.RoutingProfileSummary/LastModifiedRegion
     :cognitect.aws.connect.RoutingProfileSummary/Arn
     :cognitect.aws.connect.RoutingProfileSummary/LastModifiedTime
     :cognitect.aws.connect.RoutingProfileSummary/Name
     :cognitect.aws.connect.RoutingProfileSummary/Id]))

(s/def
  :cognitect.aws.connect/TaskTemplateId
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SourceApplicationName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_ -]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.connect/DimensionsV2Key string?)

(s/def
  :cognitect.aws.connect/SecurityProfilesSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.SecurityProfilesSearchFilter/TagFilter]))

(s/def
  :cognitect.aws.connect/HoursOfOperationSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HoursOfOperationSummary/LastModifiedRegion
     :cognitect.aws.connect.HoursOfOperationSummary/Arn
     :cognitect.aws.connect.HoursOfOperationSummary/LastModifiedTime
     :cognitect.aws.connect.HoursOfOperationSummary/Name
     :cognitect.aws.connect.HoursOfOperationSummary/Id]))

(s/def :cognitect.aws.connect/Index (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/UpdateEvaluationFormResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateEvaluationFormResponse/EvaluationFormId
     :cognitect.aws.connect.UpdateEvaluationFormResponse/EvaluationFormArn
     :cognitect.aws.connect.UpdateEvaluationFormResponse/EvaluationFormVersion]))

(s/def
  :cognitect.aws.connect/HoursOfOperationSearchConditionList
  (s/coll-of :cognitect.aws.connect/HoursOfOperationSearchCriteria))

(s/def
  :cognitect.aws.connect/UrlMetadataSignedHeadersKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EventBridgeActionName
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/Origin
  (s/spec
    (s/and string? #(>= 267 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 267) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/OutboundSubject
  (s/spec
    (s/and string? #(<= 1 (count %) 998))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 998) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/PhoneNumberWorkflowMessage
  (s/spec #(re-matches (re-pattern "^[\\W\\S_]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/BatchGetFlowAssociationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.BatchGetFlowAssociationResponse/FlowAssociationSummaryList]))

(s/def
  :cognitect.aws.connect/ViewName
  (s/spec
    #(re-matches
      (re-pattern "^([\\p{L}\\p{N}_.:\\/=+\\-@()']+[\\p{L}\\p{Z}\\p{N}_.:\\/=+\\-@()']*)$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/ComparisonOperator
  (s/spec
    (s/and string? #(<= 1 (count %) 127))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 127) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/Boolean boolean?)

(s/def
  :cognitect.aws.connect/DescribeInstanceAttributeRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeInstanceAttributeRequest/InstanceId
     :cognitect.aws.connect.DescribeInstanceAttributeRequest/AttributeType]))

(s/def
  :cognitect.aws.connect/SubmitContactEvaluationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SubmitContactEvaluationRequest/InstanceId
     :cognitect.aws.connect.SubmitContactEvaluationRequest/EvaluationId]
    :opt-un
    [:cognitect.aws.connect.SubmitContactEvaluationRequest/Answers
     :cognitect.aws.connect.SubmitContactEvaluationRequest/Notes]))

(s/def
  :cognitect.aws.connect/DateCondition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.DateCondition/ComparisonType
     :cognitect.aws.connect.DateCondition/Value
     :cognitect.aws.connect.DateCondition/FieldName]))

(s/def
  :cognitect.aws.connect/SupportedMessagingContentType
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DescribeHoursOfOperationOverrideResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.DescribeHoursOfOperationOverrideResponse/HoursOfOperationOverride]))

(s/def :cognitect.aws.connect/GroupingV2 string?)

(s/def
  :cognitect.aws.connect/DescribeAuthenticationProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeAuthenticationProfileRequest/AuthenticationProfileId
     :cognitect.aws.connect.DescribeAuthenticationProfileRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/GetEffectiveHoursOfOperationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.GetEffectiveHoursOfOperationsResponse/TimeZone
     :cognitect.aws.connect.GetEffectiveHoursOfOperationsResponse/EffectiveHoursOfOperationList]))

(s/def
  :cognitect.aws.connect/StopContactStreamingRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StopContactStreamingRequest/InstanceId
     :cognitect.aws.connect.StopContactStreamingRequest/ContactId
     :cognitect.aws.connect.StopContactStreamingRequest/StreamingId]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisStatus
  (s/spec string? :gen #(s/gen #{"COMPLETED" "IN_PROGRESS" "FAILED"})))

(s/def
  :cognitect.aws.connect/ChatDurationInMinutes
  (s/spec (s/and int? #(<= 60 % 10080)) :gen #(gen/choose 60 10080)))

(s/def
  :cognitect.aws.connect/EmailAddressSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.EmailAddressSearchFilter/TagFilter]))

(s/def
  :cognitect.aws.connect/ContactFlowModuleId
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/AnalyticsDataAssociationResult
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AnalyticsDataAssociationResult/ResourceShareId
     :cognitect.aws.connect.AnalyticsDataAssociationResult/DataSetId
     :cognitect.aws.connect.AnalyticsDataAssociationResult/ResourceShareArn
     :cognitect.aws.connect.AnalyticsDataAssociationResult/ResourceShareStatus
     :cognitect.aws.connect.AnalyticsDataAssociationResult/TargetAccountId]))

(s/def :cognitect.aws.connect/NullableBoolean boolean?)

(s/def
  :cognitect.aws.connect/VocabularyNextToken
  (s/spec #(re-matches (re-pattern ".*\\S.*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/UserPhoneConfig
  (s/keys
    :req-un
    [:cognitect.aws.connect.UserPhoneConfig/PhoneType]
    :opt-un
    [:cognitect.aws.connect.UserPhoneConfig/AutoAccept
     :cognitect.aws.connect.UserPhoneConfig/AfterContactWorkTimeLimit
     :cognitect.aws.connect.UserPhoneConfig/DeskPhoneNumber]))

(s/def
  :cognitect.aws.connect/AgentContactReferenceList
  (s/coll-of :cognitect.aws.connect/AgentContactReference))

(s/def
  :cognitect.aws.connect/DescribeUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeUserRequest/UserId
     :cognitect.aws.connect.DescribeUserRequest/InstanceId]))

(s/def :cognitect.aws.connect/DirectoryUserId string?)

(s/def
  :cognitect.aws.connect/ListPredefinedAttributesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListPredefinedAttributesResponse/NextToken
     :cognitect.aws.connect.ListPredefinedAttributesResponse/PredefinedAttributeSummaryList]))

(s/def
  :cognitect.aws.connect/ParticipantTimerType
  (s/spec string? :gen #(s/gen #{"IDLE" "DISCONNECT_NONCUSTOMER"})))

(s/def
  :cognitect.aws.connect/CustomerIdNonEmpty
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ParticipantDetailsToAdd
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ParticipantDetailsToAdd/DisplayName
     :cognitect.aws.connect.ParticipantDetailsToAdd/ParticipantCapabilities
     :cognitect.aws.connect.ParticipantDetailsToAdd/ParticipantRole]))

(s/def
  :cognitect.aws.connect/ListHoursOfOperationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListHoursOfOperationsResponse/NextToken
     :cognitect.aws.connect.ListHoursOfOperationsResponse/HoursOfOperationSummaryList]))

(s/def
  :cognitect.aws.connect/EvaluationForm
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationForm/EvaluationFormId
     :cognitect.aws.connect.EvaluationForm/EvaluationFormVersion
     :cognitect.aws.connect.EvaluationForm/Locked
     :cognitect.aws.connect.EvaluationForm/EvaluationFormArn
     :cognitect.aws.connect.EvaluationForm/Title
     :cognitect.aws.connect.EvaluationForm/Status
     :cognitect.aws.connect.EvaluationForm/Items
     :cognitect.aws.connect.EvaluationForm/CreatedTime
     :cognitect.aws.connect.EvaluationForm/CreatedBy
     :cognitect.aws.connect.EvaluationForm/LastModifiedTime
     :cognitect.aws.connect.EvaluationForm/LastModifiedBy]
    :opt-un
    [:cognitect.aws.connect.EvaluationForm/Tags
     :cognitect.aws.connect.EvaluationForm/Description
     :cognitect.aws.connect.EvaluationForm/ScoringStrategy]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisPointsOfInterest
  (s/coll-of
    :cognitect.aws.connect/RealTimeContactAnalysisPointOfInterest
    :min-count
    0
    :max-count
    5))

(s/def
  :cognitect.aws.connect/CreateInstanceRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateInstanceRequest/IdentityManagementType
     :cognitect.aws.connect.CreateInstanceRequest/InboundCallsEnabled
     :cognitect.aws.connect.CreateInstanceRequest/OutboundCallsEnabled]
    :opt-un
    [:cognitect.aws.connect.CreateInstanceRequest/InstanceAlias
     :cognitect.aws.connect.CreateInstanceRequest/Tags
     :cognitect.aws.connect.CreateInstanceRequest/DirectoryId
     :cognitect.aws.connect.CreateInstanceRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/SearchPredefinedAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchPredefinedAttributesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchPredefinedAttributesRequest/NextToken
     :cognitect.aws.connect.SearchPredefinedAttributesRequest/SearchCriteria
     :cognitect.aws.connect.SearchPredefinedAttributesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/GetTaskTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetTaskTemplateRequest/InstanceId
     :cognitect.aws.connect.GetTaskTemplateRequest/TaskTemplateId]
    :opt-un
    [:cognitect.aws.connect.GetTaskTemplateRequest/SnapshotVersion]))

(s/def
  :cognitect.aws.connect/CreateTrafficDistributionGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateTrafficDistributionGroupRequest/Name
     :cognitect.aws.connect.CreateTrafficDistributionGroupRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.CreateTrafficDistributionGroupRequest/Tags
     :cognitect.aws.connect.CreateTrafficDistributionGroupRequest/Description
     :cognitect.aws.connect.CreateTrafficDistributionGroupRequest/ClientToken]))

(s/def :cognitect.aws.connect/UserDataList (s/coll-of :cognitect.aws.connect/UserData))

(s/def :cognitect.aws.connect/UserIdList (s/coll-of :cognitect.aws.connect/UserId))

(s/def
  :cognitect.aws.connect/ListPredefinedAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListPredefinedAttributesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListPredefinedAttributesRequest/NextToken
     :cognitect.aws.connect.ListPredefinedAttributesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/SearchableContactAttributeKey
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/PotentialAudioQualityIssues
  (s/coll-of :cognitect.aws.connect/PotentialAudioQualityIssue :min-count 0 :max-count 3))

(s/def
  :cognitect.aws.connect/DescribeContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeContactRequest/InstanceId
     :cognitect.aws.connect.DescribeContactRequest/ContactId]))

(s/def
  :cognitect.aws.connect/ParticipantMetrics
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ParticipantMetrics/MessagesSent
     :cognitect.aws.connect.ParticipantMetrics/ParticipantId
     :cognitect.aws.connect.ParticipantMetrics/TotalResponseTimeInMillis
     :cognitect.aws.connect.ParticipantMetrics/ParticipantType
     :cognitect.aws.connect.ParticipantMetrics/ConversationAbandon
     :cognitect.aws.connect.ParticipantMetrics/LastMessageTimestamp
     :cognitect.aws.connect.ParticipantMetrics/MessageLengthInChars
     :cognitect.aws.connect.ParticipantMetrics/NumResponses
     :cognitect.aws.connect.ParticipantMetrics/MaxResponseTimeInMillis]))

(s/def
  :cognitect.aws.connect/VocabularySummaryList
  (s/coll-of :cognitect.aws.connect/VocabularySummary))

(s/def
  :cognitect.aws.connect/FragmentNumber
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListContactEvaluationsResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListContactEvaluationsResponse/EvaluationSummaryList]
    :opt-un
    [:cognitect.aws.connect.ListContactEvaluationsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/DescribeInstanceRequest
  (s/keys :req-un [:cognitect.aws.connect.DescribeInstanceRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/FileStatusType
  (s/spec string? :gen #(s/gen #{"REJECTED" "APPROVED" "FAILED" "PROCESSING"})))

(s/def
  :cognitect.aws.connect/DescribePhoneNumberRequest
  (s/keys :req-un [:cognitect.aws.connect.DescribePhoneNumberRequest/PhoneNumberId]))

(s/def
  :cognitect.aws.connect/TaskTemplateSingleSelectOption
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DescribeVocabularyResponse
  (s/keys :req-un [:cognitect.aws.connect.DescribeVocabularyResponse/Vocabulary]))

(s/def
  :cognitect.aws.connect/RuleId
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionOption
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormSingleSelectQuestionOption/RefId
     :cognitect.aws.connect.EvaluationFormSingleSelectQuestionOption/Text]
    :opt-un
    [:cognitect.aws.connect.EvaluationFormSingleSelectQuestionOption/Score
     :cognitect.aws.connect.EvaluationFormSingleSelectQuestionOption/AutomaticFail]))

(s/def
  :cognitect.aws.connect/AgentContactReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AgentContactReference/StateStartTimestamp
     :cognitect.aws.connect.AgentContactReference/Queue
     :cognitect.aws.connect.AgentContactReference/ConnectedToAgentTimestamp
     :cognitect.aws.connect.AgentContactReference/ContactId
     :cognitect.aws.connect.AgentContactReference/Channel
     :cognitect.aws.connect.AgentContactReference/InitiationMethod
     :cognitect.aws.connect.AgentContactReference/AgentContactState]))

(s/def
  :cognitect.aws.connect/HoursOfOperationDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 250) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/RoutingCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.RoutingCriteria/Index
     :cognitect.aws.connect.RoutingCriteria/ActivationTimestamp
     :cognitect.aws.connect.RoutingCriteria/Steps]))

(s/def
  :cognitect.aws.connect/PermissionsList
  (s/coll-of :cognitect.aws.connect/SecurityProfilePermission :max-count 500))

(s/def
  :cognitect.aws.connect/SearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchCriteria/InitiationMethods
     :cognitect.aws.connect.SearchCriteria/QueueIds
     :cognitect.aws.connect.SearchCriteria/ContactAnalysis
     :cognitect.aws.connect.SearchCriteria/SearchableContactAttributes
     :cognitect.aws.connect.SearchCriteria/AgentHierarchyGroups
     :cognitect.aws.connect.SearchCriteria/Channels
     :cognitect.aws.connect.SearchCriteria/SearchableSegmentAttributes
     :cognitect.aws.connect.SearchCriteria/AgentIds]))

(s/def
  :cognitect.aws.connect/HoursOfOperationOverrideList
  (s/coll-of :cognitect.aws.connect/HoursOfOperationOverride))

(s/def
  :cognitect.aws.connect/UserSearchSummaryList
  (s/coll-of :cognitect.aws.connect/UserSearchSummary))

(s/def :cognitect.aws.connect/UserInfo (s/keys :opt-un [:cognitect.aws.connect.UserInfo/UserId]))

(s/def
  :cognitect.aws.connect/AssociateSecurityKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateSecurityKeyRequest/InstanceId
     :cognitect.aws.connect.AssociateSecurityKeyRequest/Key]
    :opt-un
    [:cognitect.aws.connect.AssociateSecurityKeyRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/TranscriptCriteriaList
  (s/coll-of :cognitect.aws.connect/TranscriptCriteria :min-count 0 :max-count 6))

(s/def
  :cognitect.aws.connect/UpdateAgentStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateAgentStatusRequest/InstanceId
     :cognitect.aws.connect.UpdateAgentStatusRequest/AgentStatusId]
    :opt-un
    [:cognitect.aws.connect.UpdateAgentStatusRequest/ResetOrderNumber
     :cognitect.aws.connect.UpdateAgentStatusRequest/DisplayOrder
     :cognitect.aws.connect.UpdateAgentStatusRequest/Description
     :cognitect.aws.connect.UpdateAgentStatusRequest/State
     :cognitect.aws.connect.UpdateAgentStatusRequest/Name]))

(s/def
  :cognitect.aws.connect/EvaluationScoresMap
  (s/map-of
    :cognitect.aws.connect/ResourceId
    :cognitect.aws.connect/EvaluationScore
    :max-count
    100))

(s/def
  :cognitect.aws.connect/ListAssociatedContactsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListAssociatedContactsRequest/InstanceId
     :cognitect.aws.connect.ListAssociatedContactsRequest/ContactId]
    :opt-un
    [:cognitect.aws.connect.ListAssociatedContactsRequest/NextToken
     :cognitect.aws.connect.ListAssociatedContactsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/RoutingProfileReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.RoutingProfileReference/Arn
     :cognitect.aws.connect.RoutingProfileReference/Id]))

(s/def
  :cognitect.aws.connect/ContactReferences
  (s/map-of :cognitect.aws.connect/ReferenceKey :cognitect.aws.connect/Reference))

(s/def
  :cognitect.aws.connect/AuthenticationProfileSummaryList
  (s/coll-of :cognitect.aws.connect/AuthenticationProfileSummary))

(s/def
  :cognitect.aws.connect/ResourceTagsSearchCriteria
  (s/keys :opt-un [:cognitect.aws.connect.ResourceTagsSearchCriteria/TagSearchCondition]))

(s/def :cognitect.aws.connect/DeleteContactFlowResponse (s/keys))

(s/def :cognitect.aws.connect/VocabularyLastModifiedTime inst?)

(s/def
  :cognitect.aws.connect/ContactFlowModuleState
  (s/spec string? :gen #(s/gen #{"ARCHIVED" "ACTIVE"})))

(s/def
  :cognitect.aws.connect/ViewsNextToken
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9=\\/+_.-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/ChatMessage
  (s/keys
    :req-un
    [:cognitect.aws.connect.ChatMessage/ContentType :cognitect.aws.connect.ChatMessage/Content]))

(s/def
  :cognitect.aws.connect/Subject
  (s/spec
    (s/and string? #(<= 1 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 200) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/CustomerProfileAttributesSerialized string?)

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisMatchedDetails
  (s/map-of
    :cognitect.aws.connect/RealTimeContactAnalysisCategoryName
    :cognitect.aws.connect/RealTimeContactAnalysisCategoryDetails
    :min-count
    0
    :max-count
    150))

(s/def
  :cognitect.aws.connect/HoursOfOperationSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.HoursOfOperationSearchFilter/TagFilter]))

(s/def
  :cognitect.aws.connect/PhoneNumberCountryCodes
  (s/coll-of :cognitect.aws.connect/PhoneNumberCountryCode :max-count 10))

(s/def
  :cognitect.aws.connect/OperationalHour
  (s/keys
    :opt-un
    [:cognitect.aws.connect.OperationalHour/Start :cognitect.aws.connect.OperationalHour/End]))

(s/def
  :cognitect.aws.connect/PhoneNumberCountryCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CR"
        "TG"
        "TJ"
        "ZA"
        "IM"
        "PE"
        "LC"
        "CH"
        "RU"
        "MP"
        "CK"
        "SI"
        "AU"
        "KR"
        "IT"
        "FI"
        "SC"
        "SX"
        "TT"
        "TK"
        "MY"
        "SY"
        "MN"
        "KP"
        "AM"
        "DZ"
        "UY"
        "TD"
        "DJ"
        "BI"
        "MK"
        "MU"
        "LI"
        "NU"
        "GR"
        "GY"
        "CG"
        "ML"
        "GM"
        "SA"
        "CX"
        "BH"
        "NE"
        "BN"
        "MF"
        "CD"
        "DK"
        "BJ"
        "ME"
        "SJ"
        "BO"
        "JO"
        "CV"
        "VE"
        "CI"
        "UZ"
        "TN"
        "IS"
        "EH"
        "TM"
        "GA"
        "LS"
        "TZ"
        "AT"
        "LT"
        "NP"
        "BG"
        "IL"
        "GU"
        "PK"
        "PT"
        "HR"
        "VU"
        "PF"
        "BM"
        "MR"
        "GE"
        "HU"
        "TW"
        "MM"
        "VG"
        "YE"
        "SR"
        "PN"
        "VA"
        "AN"
        "PR"
        "KW"
        "SE"
        "GB"
        "VN"
        "CF"
        "PA"
        "VC"
        "JP"
        "IR"
        "AF"
        "LY"
        "MZ"
        "RO"
        "QA"
        "CM"
        "GG"
        "BY"
        "SD"
        "MO"
        "KY"
        "AR"
        "BR"
        "ZW"
        "NR"
        "NZ"
        "AW"
        "FJ"
        "ID"
        "SV"
        "CN"
        "FM"
        "HT"
        "CC"
        "RW"
        "BA"
        "TL"
        "JM"
        "KM"
        "KE"
        "WS"
        "TO"
        "PY"
        "SH"
        "CY"
        "GH"
        "MA"
        "SG"
        "LK"
        "PH"
        "SM"
        "WF"
        "TR"
        "BZ"
        "CU"
        "TV"
        "AD"
        "SB"
        "DM"
        "LR"
        "OM"
        "SO"
        "DO"
        "AL"
        "BL"
        "FR"
        "GW"
        "MS"
        "BB"
        "CA"
        "MG"
        "KH"
        "LA"
        "HN"
        "TH"
        "DE"
        "LB"
        "KZ"
        "AS"
        "EC"
        "NO"
        "AO"
        "FK"
        "ET"
        "MD"
        "AG"
        "BE"
        "MV"
        "SZ"
        "CZ"
        "CL"
        "BT"
        "NL"
        "EG"
        "SN"
        "FO"
        "EE"
        "AQ"
        "ST"
        "KN"
        "BW"
        "MH"
        "NI"
        "PG"
        "VI"
        "IQ"
        "KG"
        "US"
        "ZM"
        "MC"
        "GI"
        "NC"
        "GT"
        "BF"
        "YT"
        "LU"
        "UA"
        "IE"
        "LV"
        "GD"
        "MW"
        "BS"
        "AZ"
        "SK"
        "GQ"
        "TC"
        "RE"
        "IN"
        "ES"
        "GL"
        "KI"
        "HK"
        "CO"
        "RS"
        "IO"
        "NG"
        "UG"
        "CW"
        "SL"
        "ER"
        "JE"
        "AE"
        "PM"
        "BD"
        "MT"
        "AI"
        "GN"
        "PW"
        "NA"
        "MX"
        "PL"})))

(s/def :cognitect.aws.connect/NextToken string?)

(s/def
  :cognitect.aws.connect/IdempotencyException
  (s/keys :opt-un [:cognitect.aws.connect.IdempotencyException/Message]))

(s/def
  :cognitect.aws.connect/AttachedFileError
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AttachedFileError/ErrorMessage
     :cognitect.aws.connect.AttachedFileError/ErrorCode
     :cognitect.aws.connect.AttachedFileError/FileId]))

(s/def
  :cognitect.aws.connect/GlobalSignInEndpoint
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/MeetingFeatureStatus
  (s/spec string? :gen #(s/gen #{"AVAILABLE" "UNAVAILABLE"})))

(s/def
  :cognitect.aws.connect/SearchableSegmentAttributeValue
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DescribePhoneNumberResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribePhoneNumberResponse/ClaimedPhoneNumberSummary]))

(s/def
  :cognitect.aws.connect/HierarchyGroupSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HierarchyGroupSummary/LastModifiedRegion
     :cognitect.aws.connect.HierarchyGroupSummary/Arn
     :cognitect.aws.connect.HierarchyGroupSummary/LastModifiedTime
     :cognitect.aws.connect.HierarchyGroupSummary/Name
     :cognitect.aws.connect.HierarchyGroupSummary/Id]))

(s/def
  :cognitect.aws.connect/CreateQueueResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateQueueResponse/QueueArn
     :cognitect.aws.connect.CreateQueueResponse/QueueId]))

(s/def
  :cognitect.aws.connect/ListEvaluationFormsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListEvaluationFormsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListEvaluationFormsRequest/NextToken
     :cognitect.aws.connect.ListEvaluationFormsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/SearchText
  (s/spec
    (s/and string? #(>= 128 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/KinesisVideoStreamConfig
  (s/keys
    :req-un
    [:cognitect.aws.connect.KinesisVideoStreamConfig/Prefix
     :cognitect.aws.connect.KinesisVideoStreamConfig/RetentionPeriodHours
     :cognitect.aws.connect.KinesisVideoStreamConfig/EncryptionConfig]))

(s/def :cognitect.aws.connect/QueueTypes (s/coll-of :cognitect.aws.connect/QueueType :max-count 2))

(s/def
  :cognitect.aws.connect/CreateEmailAddressRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateEmailAddressRequest/InstanceId
     :cognitect.aws.connect.CreateEmailAddressRequest/EmailAddress]
    :opt-un
    [:cognitect.aws.connect.CreateEmailAddressRequest/Tags
     :cognitect.aws.connect.CreateEmailAddressRequest/DisplayName
     :cognitect.aws.connect.CreateEmailAddressRequest/Description
     :cognitect.aws.connect.CreateEmailAddressRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/OutputTypeNotFoundException
  (s/keys :opt-un [:cognitect.aws.connect.OutputTypeNotFoundException/Message]))

(s/def :cognitect.aws.connect/TagContactResponse (s/keys))

(s/def
  :cognitect.aws.connect/CreateContactFlowModuleResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateContactFlowModuleResponse/Arn
     :cognitect.aws.connect.CreateContactFlowModuleResponse/Id]))

(s/def
  :cognitect.aws.connect/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/CreateCaseActionDefinition
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateCaseActionDefinition/Fields
     :cognitect.aws.connect.CreateCaseActionDefinition/TemplateId]))

(s/def
  :cognitect.aws.connect/TagSet
  (s/keys :opt-un [:cognitect.aws.connect.TagSet/key :cognitect.aws.connect.TagSet/value]))

(s/def
  :cognitect.aws.connect/ListInstancesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListInstancesRequest/NextToken
     :cognitect.aws.connect.ListInstancesRequest/MaxResults]))

(s/def :cognitect.aws.connect/ContactFlowContent string?)

(s/def
  :cognitect.aws.connect/CreateInstanceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateInstanceResponse/Arn
     :cognitect.aws.connect.CreateInstanceResponse/Id]))

(s/def
  :cognitect.aws.connect/OutboundCallerConfig
  (s/keys
    :opt-un
    [:cognitect.aws.connect.OutboundCallerConfig/OutboundCallerIdName
     :cognitect.aws.connect.OutboundCallerConfig/OutboundCallerIdNumberId
     :cognitect.aws.connect.OutboundCallerConfig/OutboundFlowId]))

(s/def
  :cognitect.aws.connect/EvaluationAnswerOutput
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EvaluationAnswerOutput/SystemSuggestedValue
     :cognitect.aws.connect.EvaluationAnswerOutput/Value]))

(s/def
  :cognitect.aws.connect/ReferenceId
  (s/spec
    (s/and string? #(<= 1 (count %) 40))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 40) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/AgentStatusSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AgentStatusSearchCriteria/OrConditions
     :cognitect.aws.connect.AgentStatusSearchCriteria/StringCondition
     :cognitect.aws.connect.AgentStatusSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/Expression
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Expression/AndExpression
     :cognitect.aws.connect.Expression/NotAttributeCondition
     :cognitect.aws.connect.Expression/OrExpression
     :cognitect.aws.connect.Expression/AttributeCondition]))

(s/def
  :cognitect.aws.connect/UpdateUserIdentityInfoRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateUserIdentityInfoRequest/IdentityInfo
     :cognitect.aws.connect.UpdateUserIdentityInfoRequest/UserId
     :cognitect.aws.connect.UpdateUserIdentityInfoRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/TagRestrictedResourceName
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/CustomerVoiceActivity
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CustomerVoiceActivity/GreetingStartTimestamp
     :cognitect.aws.connect.CustomerVoiceActivity/GreetingEndTimestamp]))

(s/def
  :cognitect.aws.connect/EvaluationFormVersionStatus
  (s/spec string? :gen #(s/gen #{"DRAFT" "ACTIVE"})))

(s/def
  :cognitect.aws.connect/ListUserProficienciesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListUserProficienciesResponse/NextToken
     :cognitect.aws.connect.ListUserProficienciesResponse/LastModifiedRegion
     :cognitect.aws.connect.ListUserProficienciesResponse/LastModifiedTime
     :cognitect.aws.connect.ListUserProficienciesResponse/UserProficiencyList]))

(s/def
  :cognitect.aws.connect/ListDefaultVocabulariesResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListDefaultVocabulariesResponse/DefaultVocabularyList]
    :opt-un
    [:cognitect.aws.connect.ListDefaultVocabulariesResponse/NextToken]))

(s/def
  :cognitect.aws.connect/AgentId
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/UpdateTrafficDistributionRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateTrafficDistributionRequest/Id]
    :opt-un
    [:cognitect.aws.connect.UpdateTrafficDistributionRequest/SignInConfig
     :cognitect.aws.connect.UpdateTrafficDistributionRequest/TelephonyConfig
     :cognitect.aws.connect.UpdateTrafficDistributionRequest/AgentConfig]))

(s/def
  :cognitect.aws.connect/ListTrafficDistributionGroupUsersRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListTrafficDistributionGroupUsersRequest/TrafficDistributionGroupId]
    :opt-un
    [:cognitect.aws.connect.ListTrafficDistributionGroupUsersRequest/NextToken
     :cognitect.aws.connect.ListTrafficDistributionGroupUsersRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/Body
  (s/spec
    (s/and string? #(<= 1 (count %) 5242880))
    :gen
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose 1 5242880) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/Queue
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Queue/Tags
     :cognitect.aws.connect.Queue/Status
     :cognitect.aws.connect.Queue/OutboundEmailConfig
     :cognitect.aws.connect.Queue/OutboundCallerConfig
     :cognitect.aws.connect.Queue/Description
     :cognitect.aws.connect.Queue/LastModifiedRegion
     :cognitect.aws.connect.Queue/QueueArn
     :cognitect.aws.connect.Queue/LastModifiedTime
     :cognitect.aws.connect.Queue/Name
     :cognitect.aws.connect.Queue/MaxContacts
     :cognitect.aws.connect.Queue/HoursOfOperationId
     :cognitect.aws.connect.Queue/QueueId]))

(s/def
  :cognitect.aws.connect/HoursOfOperationConfig
  (s/keys
    :req-un
    [:cognitect.aws.connect.HoursOfOperationConfig/Day
     :cognitect.aws.connect.HoursOfOperationConfig/StartTime
     :cognitect.aws.connect.HoursOfOperationConfig/EndTime]))

(s/def
  :cognitect.aws.connect/EvaluationFormItemWeight
  (s/spec
    (s/and double? #(<= 0 % 100))
    :gen
    #(gen/double* {:infinite? false, :NaN? false, :min 0, :max 100})))

(s/def
  :cognitect.aws.connect/CreateContactFlowModuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateContactFlowModuleRequest/InstanceId
     :cognitect.aws.connect.CreateContactFlowModuleRequest/Name
     :cognitect.aws.connect.CreateContactFlowModuleRequest/Content]
    :opt-un
    [:cognitect.aws.connect.CreateContactFlowModuleRequest/Tags
     :cognitect.aws.connect.CreateContactFlowModuleRequest/Description
     :cognitect.aws.connect.CreateContactFlowModuleRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/GetFlowAssociationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.GetFlowAssociationResponse/FlowId
     :cognitect.aws.connect.GetFlowAssociationResponse/ResourceId
     :cognitect.aws.connect.GetFlowAssociationResponse/ResourceType]))

(s/def
  :cognitect.aws.connect/ListTaskTemplatesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListTaskTemplatesResponse/NextToken
     :cognitect.aws.connect.ListTaskTemplatesResponse/TaskTemplates]))

(s/def
  :cognitect.aws.connect/SearchContactsTimeRangeType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"INITIATION_TIMESTAMP"
        "DISCONNECT_TIMESTAMP"
        "SCHEDULED_TIMESTAMP"
        "CONNECTED_TO_AGENT_TIMESTAMP"})))

(s/def
  :cognitect.aws.connect/AttachedFileServiceQuotaExceededExceptionReason
  (s/spec string? :gen #(s/gen #{"TOTAL_FILE_SIZE_EXCEEDED" "TOTAL_FILE_COUNT_EXCEEDED"})))

(s/def
  :cognitect.aws.connect/DescribeRuleResponse
  (s/keys :req-un [:cognitect.aws.connect.DescribeRuleResponse/Rule]))

(s/def
  :cognitect.aws.connect/TagValue
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/RoutingProfileQueueReferenceList
  (s/coll-of :cognitect.aws.connect/RoutingProfileQueueReference))

(s/def
  :cognitect.aws.connect/SubmitContactEvaluationResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.SubmitContactEvaluationResponse/EvaluationId
     :cognitect.aws.connect.SubmitContactEvaluationResponse/EvaluationArn]))

(s/def
  :cognitect.aws.connect/HoursOfOperationOverrideId
  (s/spec
    (s/and string? #(<= 1 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 36) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/PutUserStatusResponse (s/keys))

(s/def :cognitect.aws.connect/SnapshotVersion string?)

(s/def
  :cognitect.aws.connect/HierarchyLevelUpdate
  (s/keys :req-un [:cognitect.aws.connect.HierarchyLevelUpdate/Name]))

(s/def
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionOptionText
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SearchableContactAttributes
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchableContactAttributes/Criteria]
    :opt-un
    [:cognitect.aws.connect.SearchableContactAttributes/MatchType]))

(s/def
  :cognitect.aws.connect/ReferenceSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ReferenceSummary/Attachment
     :cognitect.aws.connect.ReferenceSummary/Email
     :cognitect.aws.connect.ReferenceSummary/Number
     :cognitect.aws.connect.ReferenceSummary/Date
     :cognitect.aws.connect.ReferenceSummary/Url
     :cognitect.aws.connect.ReferenceSummary/String
     :cognitect.aws.connect.ReferenceSummary/EmailMessage]))

(s/def
  :cognitect.aws.connect/PromptSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.PromptSearchCriteria/OrConditions
     :cognitect.aws.connect.PromptSearchCriteria/StringCondition
     :cognitect.aws.connect.PromptSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/CaseSlaConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.connect.CaseSlaConfiguration/Name
     :cognitect.aws.connect.CaseSlaConfiguration/Type
     :cognitect.aws.connect.CaseSlaConfiguration/TargetSlaMinutes]
    :opt-un
    [:cognitect.aws.connect.CaseSlaConfiguration/FieldId
     :cognitect.aws.connect.CaseSlaConfiguration/TargetFieldValues]))

(s/def
  :cognitect.aws.connect/TargetSlaMinutes
  (s/spec (s/and int? #(<= 1 % 129600)) :gen #(gen/choose 1 129600)))

(s/def
  :cognitect.aws.connect/AgentPauseDurationInSeconds
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/ContactDataRequestList
  (s/coll-of :cognitect.aws.connect/ContactDataRequest :min-count 1 :max-count 25))

(s/def
  :cognitect.aws.connect/DeleteTaskTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteTaskTemplateRequest/InstanceId
     :cognitect.aws.connect.DeleteTaskTemplateRequest/TaskTemplateId]))

(s/def
  :cognitect.aws.connect/ContactAnalysis
  (s/keys :opt-un [:cognitect.aws.connect.ContactAnalysis/Transcript]))

(s/def :cognitect.aws.connect/EncryptionType (s/spec string? :gen #(s/gen #{"KMS"})))

(s/def
  :cognitect.aws.connect/ContactSearchSummarySegmentAttributeValue
  (s/keys :opt-un [:cognitect.aws.connect.ContactSearchSummarySegmentAttributeValue/ValueString]))

(s/def
  :cognitect.aws.connect/ViewContent
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ViewContent/Actions
     :cognitect.aws.connect.ViewContent/Template
     :cognitect.aws.connect.ViewContent/InputSchema]))

(s/def :cognitect.aws.connect/Priority (s/spec (s/and int? #(<= 1 % 99)) :gen #(gen/choose 1 99)))

(s/def
  :cognitect.aws.connect/AuthenticationProfileDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 250) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DeleteRuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteRuleRequest/InstanceId
     :cognitect.aws.connect.DeleteRuleRequest/RuleId]))

(s/def
  :cognitect.aws.connect/AudioQualityMetricsInfo
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AudioQualityMetricsInfo/QualityScore
     :cognitect.aws.connect.AudioQualityMetricsInfo/PotentialQualityIssues]))

(s/def
  :cognitect.aws.connect/SearchUserHierarchyGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchUserHierarchyGroupsResponse/UserHierarchyGroups
     :cognitect.aws.connect.SearchUserHierarchyGroupsResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchUserHierarchyGroupsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisSentimentLabel
  (s/spec string? :gen #(s/gen #{"NEUTRAL" "NEGATIVE" "POSITIVE"})))

(s/def
  :cognitect.aws.connect/Threshold
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Threshold/ThresholdValue :cognitect.aws.connect.Threshold/Comparison]))

(s/def
  :cognitect.aws.connect/AttachedFileErrorsList
  (s/coll-of :cognitect.aws.connect/AttachedFileError))

(s/def
  :cognitect.aws.connect/EmailRecipient
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EmailRecipient/Address
     :cognitect.aws.connect.EmailRecipient/DisplayName]))

(s/def
  :cognitect.aws.connect/ContactFlowModulesSummaryList
  (s/coll-of :cognitect.aws.connect/ContactFlowModuleSummary))

(s/def
  :cognitect.aws.connect/CreateContactResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateContactResponse/ContactArn
     :cognitect.aws.connect.CreateContactResponse/ContactId]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisContentType
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/PromptSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.PromptSummary/LastModifiedRegion
     :cognitect.aws.connect.PromptSummary/Arn
     :cognitect.aws.connect.PromptSummary/LastModifiedTime
     :cognitect.aws.connect.PromptSummary/Name
     :cognitect.aws.connect.PromptSummary/Id]))

(s/def
  :cognitect.aws.connect/EmailAddressSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EmailAddressSearchCriteria/OrConditions
     :cognitect.aws.connect.EmailAddressSearchCriteria/StringCondition
     :cognitect.aws.connect.EmailAddressSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/UserSearchConditionList
  (s/coll-of :cognitect.aws.connect/UserSearchCriteria))

(s/def :cognitect.aws.connect/UserSummaryList (s/coll-of :cognitect.aws.connect/UserSummary))

(s/def
  :cognitect.aws.connect/ContactFlowModule
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactFlowModule/Tags
     :cognitect.aws.connect.ContactFlowModule/Status
     :cognitect.aws.connect.ContactFlowModule/Description
     :cognitect.aws.connect.ContactFlowModule/Content
     :cognitect.aws.connect.ContactFlowModule/Arn
     :cognitect.aws.connect.ContactFlowModule/State
     :cognitect.aws.connect.ContactFlowModule/Name
     :cognitect.aws.connect.ContactFlowModule/Id]))

(s/def :cognitect.aws.connect/NotificationDeliveryType (s/spec string? :gen #(s/gen #{"EMAIL"})))

(s/def
  :cognitect.aws.connect/AgentResourceIdList
  (s/coll-of :cognitect.aws.connect/AgentResourceId :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.connect/UrlReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UrlReference/Value :cognitect.aws.connect.UrlReference/Name]))

(s/def
  :cognitect.aws.connect/AfterContactWorkTimeLimit
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/SearchContactsTimeRange
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchContactsTimeRange/Type
     :cognitect.aws.connect.SearchContactsTimeRange/StartTime
     :cognitect.aws.connect.SearchContactsTimeRange/EndTime]))

(s/def
  :cognitect.aws.connect/DisassociateTrafficDistributionGroupUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateTrafficDistributionGroupUserRequest/TrafficDistributionGroupId
     :cognitect.aws.connect.DisassociateTrafficDistributionGroupUserRequest/UserId
     :cognitect.aws.connect.DisassociateTrafficDistributionGroupUserRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/TaskTemplateConstraints
  (s/keys
    :opt-un
    [:cognitect.aws.connect.TaskTemplateConstraints/ReadOnlyFields
     :cognitect.aws.connect.TaskTemplateConstraints/RequiredFields
     :cognitect.aws.connect.TaskTemplateConstraints/InvisibleFields]))

(s/def
  :cognitect.aws.connect/DisassociateQueueQuickConnectsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateQueueQuickConnectsRequest/InstanceId
     :cognitect.aws.connect.DisassociateQueueQuickConnectsRequest/QueueId
     :cognitect.aws.connect.DisassociateQueueQuickConnectsRequest/QuickConnectIds]))

(s/def
  :cognitect.aws.connect/EmailAddressArn
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/HierarchyGroupMatchType
  (s/spec string? :gen #(s/gen #{"EXACT" "WITH_CHILD_GROUPS"})))

(s/def
  :cognitect.aws.connect/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.connect.ListTagsForResourceRequest/resourceArn]))

(s/def
  :cognitect.aws.connect/AssociatedContactSummaryList
  (s/coll-of :cognitect.aws.connect/AssociatedContactSummary))

(s/def
  :cognitect.aws.connect/Description250
  (s/spec #(re-matches (re-pattern "(^[\\S].*[\\S]$)|(^[\\S]$)") %) :gen #(gen/string)))

(s/def :cognitect.aws.connect/ParticipantTimerAction (s/spec string? :gen #(s/gen #{"Unset"})))

(s/def
  :cognitect.aws.connect/DescribeAgentStatusResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeAgentStatusResponse/AgentStatus]))

(s/def
  :cognitect.aws.connect/InstanceSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.InstanceSummary/ServiceRole
     :cognitect.aws.connect.InstanceSummary/OutboundCallsEnabled
     :cognitect.aws.connect.InstanceSummary/InstanceAlias
     :cognitect.aws.connect.InstanceSummary/InstanceAccessUrl
     :cognitect.aws.connect.InstanceSummary/CreatedTime
     :cognitect.aws.connect.InstanceSummary/InboundCallsEnabled
     :cognitect.aws.connect.InstanceSummary/IdentityManagementType
     :cognitect.aws.connect.InstanceSummary/Arn
     :cognitect.aws.connect.InstanceSummary/InstanceStatus
     :cognitect.aws.connect.InstanceSummary/Id]))

(s/def
  :cognitect.aws.connect/ContactFlowModuleDescription
  (s/spec #(re-matches (re-pattern ".*\\S.*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/ContactFilter
  (s/keys :opt-un [:cognitect.aws.connect.ContactFilter/ContactStates]))

(s/def
  :cognitect.aws.connect/URLExpiryInSeconds
  (s/spec (s/and int? #(<= 5 % 300)) :gen #(gen/choose 5 300)))

(s/def
  :cognitect.aws.connect/ApproximateTotalCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/SourceId
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EndpointType
  (s/spec
    string?
    :gen
    #(s/gen #{"TELEPHONE_NUMBER" "EMAIL_ADDRESS" "CONTACT_FLOW" "VOIP" "CONNECT_PHONENUMBER_ARN"})))

(s/def
  :cognitect.aws.connect/SlaFieldValueUnionList
  (s/coll-of :cognitect.aws.connect/FieldValueUnion :max-count 1))

(s/def
  :cognitect.aws.connect/CreateSecurityProfileResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateSecurityProfileResponse/SecurityProfileId
     :cognitect.aws.connect.CreateSecurityProfileResponse/SecurityProfileArn]))

(s/def
  :cognitect.aws.connect/DeleteQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteQueueRequest/InstanceId
     :cognitect.aws.connect.DeleteQueueRequest/QueueId]))

(s/def :cognitect.aws.connect/UserId string?)

(s/def
  :cognitect.aws.connect/ListTrafficDistributionGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListTrafficDistributionGroupsResponse/NextToken
     :cognitect.aws.connect.ListTrafficDistributionGroupsResponse/TrafficDistributionGroupSummaryList]))

(s/def
  :cognitect.aws.connect/ContactState
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MISSED"
        "CONNECTED"
        "PENDING"
        "ERROR"
        "REJECTED"
        "CONNECTED_ONHOLD"
        "CONNECTING"
        "ENDED"
        "INCOMING"})))

(s/def
  :cognitect.aws.connect/RequestIdentifier
  (s/spec
    (s/and string? #(>= 80 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SearchableContactAttributeValue
  (s/spec
    (s/and string? #(<= 0 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DescribeContactFlowResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeContactFlowResponse/ContactFlow]))

(s/def
  :cognitect.aws.connect/DescribeSecurityProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeSecurityProfileRequest/SecurityProfileId
     :cognitect.aws.connect.DescribeSecurityProfileRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/ContactMetricValue
  (s/keys :opt-un [:cognitect.aws.connect.ContactMetricValue/Number]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisSupportedChannel
  (s/spec string? :gen #(s/gen #{"VOICE" "CHAT"})))

(s/def
  :cognitect.aws.connect/ListSecurityProfilesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListSecurityProfilesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListSecurityProfilesRequest/NextToken
     :cognitect.aws.connect.ListSecurityProfilesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/DisplayName
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/UserHierarchyGroupSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UserHierarchyGroupSearchCriteria/OrConditions
     :cognitect.aws.connect.UserHierarchyGroupSearchCriteria/StringCondition
     :cognitect.aws.connect.UserHierarchyGroupSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/BatchAssociateAnalyticsDataSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.BatchAssociateAnalyticsDataSetRequest/InstanceId
     :cognitect.aws.connect.BatchAssociateAnalyticsDataSetRequest/DataSetIds]
    :opt-un
    [:cognitect.aws.connect.BatchAssociateAnalyticsDataSetRequest/TargetAccountId]))

(s/def
  :cognitect.aws.connect/FieldStringValue
  (s/spec
    (s/and string? #(<= 0 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SearchQuickConnectsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchQuickConnectsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchQuickConnectsRequest/NextToken
     :cognitect.aws.connect.SearchQuickConnectsRequest/SearchFilter
     :cognitect.aws.connect.SearchQuickConnectsRequest/SearchCriteria
     :cognitect.aws.connect.SearchQuickConnectsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/DeletePushNotificationRegistrationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeletePushNotificationRegistrationRequest/InstanceId
     :cognitect.aws.connect.DeletePushNotificationRegistrationRequest/RegistrationId
     :cognitect.aws.connect.DeletePushNotificationRegistrationRequest/ContactId]))

(s/def
  :cognitect.aws.connect/TrafficDistributionGroupSummaryList
  (s/coll-of :cognitect.aws.connect/TrafficDistributionGroupSummary :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.connect/InvalidParameterException
  (s/keys :opt-un [:cognitect.aws.connect.InvalidParameterException/Message]))

(s/def
  :cognitect.aws.connect/TaskTemplateFields
  (s/coll-of :cognitect.aws.connect/TaskTemplateField))

(s/def
  :cognitect.aws.connect/UpdateContactAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactAttributesRequest/InitialContactId
     :cognitect.aws.connect.UpdateContactAttributesRequest/InstanceId
     :cognitect.aws.connect.UpdateContactAttributesRequest/Attributes]))

(s/def
  :cognitect.aws.connect/NullableProficiencyLimitValue
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/NumericQuestionPropertyAutomationLabel
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CUSTOMER_HOLD_TIME"
        "OVERALL_CUSTOMER_SENTIMENT_SCORE"
        "NON_TALK_TIME"
        "CONTACT_DURATION"
        "NON_TALK_TIME_PERCENTAGE"
        "AGENT_INTERACTION_DURATION"
        "OVERALL_AGENT_SENTIMENT_SCORE"
        "NUMBER_OF_INTERRUPTIONS"})))

(s/def
  :cognitect.aws.connect/EvaluationFormSection
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormSection/Title
     :cognitect.aws.connect.EvaluationFormSection/RefId
     :cognitect.aws.connect.EvaluationFormSection/Items]
    :opt-un
    [:cognitect.aws.connect.EvaluationFormSection/Instructions
     :cognitect.aws.connect.EvaluationFormSection/Weight]))

(s/def
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionAutomationOption
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EvaluationFormSingleSelectQuestionAutomationOption/RuleCategory]))

(s/def
  :cognitect.aws.connect/PlatformVersion
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/BehaviorType
  (s/spec string? :gen #(s/gen #{"ROUTE_ANY_CHANNEL" "ROUTE_CURRENT_CHANNEL_ONLY"})))

(s/def
  :cognitect.aws.connect/CurrentMetricResults
  (s/coll-of :cognitect.aws.connect/CurrentMetricResult))

(s/def
  :cognitect.aws.connect/DescribeContactFlowModuleResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeContactFlowModuleResponse/ContactFlowModule]))

(s/def
  :cognitect.aws.connect/PhoneNumber
  (s/spec #(re-matches (re-pattern "\\\\+[1-9]\\\\d{1,14}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/HoursOfOperationConfigList
  (s/coll-of :cognitect.aws.connect/HoursOfOperationConfig :min-count 0 :max-count 100))

(s/def :cognitect.aws.connect/AssociateDefaultVocabularyResponse (s/keys))

(s/def
  :cognitect.aws.connect/TagOrConditionList
  (s/coll-of :cognitect.aws.connect/TagAndConditionList))

(s/def :cognitect.aws.connect/DisassociateFlowResponse (s/keys))

(s/def
  :cognitect.aws.connect/EvaluationFormScoringStatus
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.connect/FunctionArn
  (s/spec
    (s/and string? #(<= 1 (count %) 140))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 140) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/AssociateAnalyticsDataSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateAnalyticsDataSetRequest/InstanceId
     :cognitect.aws.connect.AssociateAnalyticsDataSetRequest/DataSetId]
    :opt-un
    [:cognitect.aws.connect.AssociateAnalyticsDataSetRequest/TargetAccountId]))

(s/def
  :cognitect.aws.connect/AssociateSecurityKeyResponse
  (s/keys :opt-un [:cognitect.aws.connect.AssociateSecurityKeyResponse/AssociationId]))

(s/def
  :cognitect.aws.connect/InboundEmailContent
  (s/keys
    :req-un
    [:cognitect.aws.connect.InboundEmailContent/MessageSourceType]
    :opt-un
    [:cognitect.aws.connect.InboundEmailContent/RawMessage]))

(s/def
  :cognitect.aws.connect/TranscriptCriteria
  (s/keys
    :req-un
    [:cognitect.aws.connect.TranscriptCriteria/ParticipantRole
     :cognitect.aws.connect.TranscriptCriteria/SearchText
     :cognitect.aws.connect.TranscriptCriteria/MatchType]))

(s/def :cognitect.aws.connect/MetricNameV2 string?)

(s/def
  :cognitect.aws.connect/StartOutboundEmailContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartOutboundEmailContactRequest/InstanceId
     :cognitect.aws.connect.StartOutboundEmailContactRequest/ContactId
     :cognitect.aws.connect.StartOutboundEmailContactRequest/DestinationEmailAddress
     :cognitect.aws.connect.StartOutboundEmailContactRequest/EmailMessage]
    :opt-un
    [:cognitect.aws.connect.StartOutboundEmailContactRequest/FromEmailAddress
     :cognitect.aws.connect.StartOutboundEmailContactRequest/AdditionalRecipients
     :cognitect.aws.connect.StartOutboundEmailContactRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/DescribeUserResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeUserResponse/User]))

(s/def
  :cognitect.aws.connect/DescribePromptResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribePromptResponse/Prompt]))

(s/def
  :cognitect.aws.connect/ContactInitiationMethod
  (s/spec
    string?
    :gen
    #(s/gen
      #{"QUEUE_TRANSFER"
        "API"
        "OUTBOUND"
        "DISCONNECT"
        "AGENT_REPLY"
        "TRANSFER"
        "EXTERNAL_OUTBOUND"
        "WEBRTC_API"
        "FLOW"
        "MONITOR"
        "CALLBACK"
        "INBOUND"})))

(s/def
  :cognitect.aws.connect/EvaluationFormItemsList
  (s/coll-of :cognitect.aws.connect/EvaluationFormItem :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.connect/LexBotConfig
  (s/keys
    :opt-un
    [:cognitect.aws.connect.LexBotConfig/LexBot :cognitect.aws.connect.LexBotConfig/LexV2Bot]))

(s/def
  :cognitect.aws.connect/DescribeEmailAddressResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.DescribeEmailAddressResponse/CreateTimestamp
     :cognitect.aws.connect.DescribeEmailAddressResponse/EmailAddressId
     :cognitect.aws.connect.DescribeEmailAddressResponse/Tags
     :cognitect.aws.connect.DescribeEmailAddressResponse/ModifiedTimestamp
     :cognitect.aws.connect.DescribeEmailAddressResponse/DisplayName
     :cognitect.aws.connect.DescribeEmailAddressResponse/Description
     :cognitect.aws.connect.DescribeEmailAddressResponse/EmailAddressArn
     :cognitect.aws.connect.DescribeEmailAddressResponse/EmailAddress]))

(s/def
  :cognitect.aws.connect/ViewsInstanceId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\_\\-:\\/]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/InstanceStatus
  (s/spec string? :gen #(s/gen #{"ACTIVE" "CREATION_IN_PROGRESS" "CREATION_FAILED"})))

(s/def
  :cognitect.aws.connect/GetTaskTemplateResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetTaskTemplateResponse/Id
     :cognitect.aws.connect.GetTaskTemplateResponse/Arn
     :cognitect.aws.connect.GetTaskTemplateResponse/Name]
    :opt-un
    [:cognitect.aws.connect.GetTaskTemplateResponse/InstanceId
     :cognitect.aws.connect.GetTaskTemplateResponse/ContactFlowId
     :cognitect.aws.connect.GetTaskTemplateResponse/Fields
     :cognitect.aws.connect.GetTaskTemplateResponse/Tags
     :cognitect.aws.connect.GetTaskTemplateResponse/Status
     :cognitect.aws.connect.GetTaskTemplateResponse/SelfAssignFlowId
     :cognitect.aws.connect.GetTaskTemplateResponse/CreatedTime
     :cognitect.aws.connect.GetTaskTemplateResponse/Description
     :cognitect.aws.connect.GetTaskTemplateResponse/Defaults
     :cognitect.aws.connect.GetTaskTemplateResponse/LastModifiedTime
     :cognitect.aws.connect.GetTaskTemplateResponse/Constraints]))

(s/def
  :cognitect.aws.connect/ListSecurityProfileApplicationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListSecurityProfileApplicationsRequest/SecurityProfileId
     :cognitect.aws.connect.ListSecurityProfileApplicationsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListSecurityProfileApplicationsRequest/NextToken
     :cognitect.aws.connect.ListSecurityProfileApplicationsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/DeleteUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteUserRequest/InstanceId
     :cognitect.aws.connect.DeleteUserRequest/UserId]))

(s/def
  :cognitect.aws.connect/SearchRoutingProfilesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchRoutingProfilesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchRoutingProfilesRequest/NextToken
     :cognitect.aws.connect.SearchRoutingProfilesRequest/SearchFilter
     :cognitect.aws.connect.SearchRoutingProfilesRequest/SearchCriteria
     :cognitect.aws.connect.SearchRoutingProfilesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/ContactFlow
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactFlow/Type
     :cognitect.aws.connect.ContactFlow/Tags
     :cognitect.aws.connect.ContactFlow/Status
     :cognitect.aws.connect.ContactFlow/Description
     :cognitect.aws.connect.ContactFlow/LastModifiedRegion
     :cognitect.aws.connect.ContactFlow/Content
     :cognitect.aws.connect.ContactFlow/Arn
     :cognitect.aws.connect.ContactFlow/VersionDescription
     :cognitect.aws.connect.ContactFlow/State
     :cognitect.aws.connect.ContactFlow/Version
     :cognitect.aws.connect.ContactFlow/LastModifiedTime
     :cognitect.aws.connect.ContactFlow/Name
     :cognitect.aws.connect.ContactFlow/FlowContentSha256
     :cognitect.aws.connect.ContactFlow/Id]))

(s/def
  :cognitect.aws.connect/AuthorizationCode
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListHoursOfOperationOverridesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListHoursOfOperationOverridesRequest/InstanceId
     :cognitect.aws.connect.ListHoursOfOperationOverridesRequest/HoursOfOperationId]
    :opt-un
    [:cognitect.aws.connect.ListHoursOfOperationOverridesRequest/NextToken
     :cognitect.aws.connect.ListHoursOfOperationOverridesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/GetTrafficDistributionRequest
  (s/keys :req-un [:cognitect.aws.connect.GetTrafficDistributionRequest/Id]))

(s/def
  :cognitect.aws.connect/MaxResult500
  (s/spec (s/and int? #(<= 1 % 500)) :gen #(gen/choose 1 500)))

(s/def
  :cognitect.aws.connect/UpdatePhoneNumberResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UpdatePhoneNumberResponse/PhoneNumberArn
     :cognitect.aws.connect.UpdatePhoneNumberResponse/PhoneNumberId]))

(s/def
  :cognitect.aws.connect/TaskTemplateDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/Percentage
  (s/spec (s/and int? #(<= 0 % 100)) :gen #(gen/choose 0 100)))

(s/def
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionDisplayMode
  (s/spec string? :gen #(s/gen #{"RADIO" "DROPDOWN"})))

(s/def
  :cognitect.aws.connect/ProblemMessageString
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/User
  (s/keys
    :opt-un
    [:cognitect.aws.connect.User/Username
     :cognitect.aws.connect.User/PhoneConfig
     :cognitect.aws.connect.User/IdentityInfo
     :cognitect.aws.connect.User/Tags
     :cognitect.aws.connect.User/SecurityProfileIds
     :cognitect.aws.connect.User/LastModifiedRegion
     :cognitect.aws.connect.User/HierarchyGroupId
     :cognitect.aws.connect.User/Arn
     :cognitect.aws.connect.User/LastModifiedTime
     :cognitect.aws.connect.User/RoutingProfileId
     :cognitect.aws.connect.User/DirectoryUserId
     :cognitect.aws.connect.User/Id]))

(s/def
  :cognitect.aws.connect/UpdateEmailAddressMetadataResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UpdateEmailAddressMetadataResponse/EmailAddressId
     :cognitect.aws.connect.UpdateEmailAddressMetadataResponse/EmailAddressArn]))

(s/def
  :cognitect.aws.connect/Range
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Range/MinProficiencyLevel
     :cognitect.aws.connect.Range/MaxProficiencyLevel]))

(s/def
  :cognitect.aws.connect/TotalPauseCount
  (s/spec (s/and int? #(<= 0 % 10)) :gen #(gen/choose 0 10)))

(s/def
  :cognitect.aws.connect/HoursOfOperationList
  (s/coll-of :cognitect.aws.connect/HoursOfOperation))

(s/def
  :cognitect.aws.connect/TrafficDistributionGroup
  (s/keys
    :opt-un
    [:cognitect.aws.connect.TrafficDistributionGroup/Tags
     :cognitect.aws.connect.TrafficDistributionGroup/Status
     :cognitect.aws.connect.TrafficDistributionGroup/Description
     :cognitect.aws.connect.TrafficDistributionGroup/Arn
     :cognitect.aws.connect.TrafficDistributionGroup/Name
     :cognitect.aws.connect.TrafficDistributionGroup/IsDefault
     :cognitect.aws.connect.TrafficDistributionGroup/Id
     :cognitect.aws.connect.TrafficDistributionGroup/InstanceArn]))

(s/def
  :cognitect.aws.connect/DescribeQuickConnectResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeQuickConnectResponse/QuickConnect]))

(s/def
  :cognitect.aws.connect/TaskTemplateDefaultFieldValue
  (s/keys
    :opt-un
    [:cognitect.aws.connect.TaskTemplateDefaultFieldValue/DefaultValue
     :cognitect.aws.connect.TaskTemplateDefaultFieldValue/Id]))

(s/def
  :cognitect.aws.connect/AssociateLambdaFunctionRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateLambdaFunctionRequest/InstanceId
     :cognitect.aws.connect.AssociateLambdaFunctionRequest/FunctionArn]
    :opt-un
    [:cognitect.aws.connect.AssociateLambdaFunctionRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/TrafficDistributionGroupArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:(aws|aws-us-gov):connect:[a-z]{2}-[a-z]+-[0-9]{1}:[0-9]{1,20}:traffic-distribution-group/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/UpdateSecurityProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateSecurityProfileRequest/SecurityProfileId
     :cognitect.aws.connect.UpdateSecurityProfileRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.UpdateSecurityProfileRequest/AllowedAccessControlTags
     :cognitect.aws.connect.UpdateSecurityProfileRequest/Permissions
     :cognitect.aws.connect.UpdateSecurityProfileRequest/HierarchyRestrictedResources
     :cognitect.aws.connect.UpdateSecurityProfileRequest/AllowedAccessControlHierarchyGroupId
     :cognitect.aws.connect.UpdateSecurityProfileRequest/Applications
     :cognitect.aws.connect.UpdateSecurityProfileRequest/Description
     :cognitect.aws.connect.UpdateSecurityProfileRequest/TagRestrictedResources]))

(s/def
  :cognitect.aws.connect/ChatMetrics
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ChatMetrics/AgentMetrics
     :cognitect.aws.connect.ChatMetrics/CustomerMetrics
     :cognitect.aws.connect.ChatMetrics/ChatContactMetrics]))

(s/def
  :cognitect.aws.connect/UrlMetadataSignedHeadersValue
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/UpdateContactEvaluationResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactEvaluationResponse/EvaluationId
     :cognitect.aws.connect.UpdateContactEvaluationResponse/EvaluationArn]))

(s/def
  :cognitect.aws.connect/AuthenticationProfile
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AuthenticationProfile/PeriodicSessionDuration
     :cognitect.aws.connect.AuthenticationProfile/BlockedIps
     :cognitect.aws.connect.AuthenticationProfile/CreatedTime
     :cognitect.aws.connect.AuthenticationProfile/Description
     :cognitect.aws.connect.AuthenticationProfile/LastModifiedRegion
     :cognitect.aws.connect.AuthenticationProfile/Arn
     :cognitect.aws.connect.AuthenticationProfile/MaxSessionDuration
     :cognitect.aws.connect.AuthenticationProfile/LastModifiedTime
     :cognitect.aws.connect.AuthenticationProfile/Name
     :cognitect.aws.connect.AuthenticationProfile/IsDefault
     :cognitect.aws.connect.AuthenticationProfile/AllowedIps
     :cognitect.aws.connect.AuthenticationProfile/Id]))

(s/def :cognitect.aws.connect/TimeZone string?)

(s/def
  :cognitect.aws.connect/Customer
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Customer/Capabilities :cognitect.aws.connect.Customer/DeviceInfo]))

(s/def
  :cognitect.aws.connect/PromptId
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisEventType
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/TaskTemplateFieldIdentifier
  (s/keys :opt-un [:cognitect.aws.connect.TaskTemplateFieldIdentifier/Name]))

(s/def
  :cognitect.aws.connect/CreateParticipantRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateParticipantRequest/InstanceId
     :cognitect.aws.connect.CreateParticipantRequest/ContactId
     :cognitect.aws.connect.CreateParticipantRequest/ParticipantDetails]
    :opt-un
    [:cognitect.aws.connect.CreateParticipantRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/ListPhoneNumbersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListPhoneNumbersResponse/PhoneNumberSummaryList
     :cognitect.aws.connect.ListPhoneNumbersResponse/NextToken]))

(s/def
  :cognitect.aws.connect/ImportPhoneNumberRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ImportPhoneNumberRequest/InstanceId
     :cognitect.aws.connect.ImportPhoneNumberRequest/SourcePhoneNumberArn]
    :opt-un
    [:cognitect.aws.connect.ImportPhoneNumberRequest/PhoneNumberDescription
     :cognitect.aws.connect.ImportPhoneNumberRequest/Tags
     :cognitect.aws.connect.ImportPhoneNumberRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/StartOutboundChatContactResponse
  (s/keys :opt-un [:cognitect.aws.connect.StartOutboundChatContactResponse/ContactId]))

(s/def :cognitect.aws.connect/QueueStatus (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.connect/EndpointDisplayName
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SearchHoursOfOperationOverridesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchHoursOfOperationOverridesResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchHoursOfOperationOverridesResponse/NextToken
     :cognitect.aws.connect.SearchHoursOfOperationOverridesResponse/HoursOfOperationOverrides]))

(s/def
  :cognitect.aws.connect/CurrentMetric
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CurrentMetric/Unit :cognitect.aws.connect.CurrentMetric/Name]))

(s/def
  :cognitect.aws.connect/resourceArnListMaxLimit100
  (s/coll-of :cognitect.aws.connect/ARN :min-count 1 :max-count 100))

(s/def :cognitect.aws.connect/ResumeContactRecordingResponse (s/keys))

(s/def
  :cognitect.aws.connect/SignInDistribution
  (s/keys
    :req-un
    [:cognitect.aws.connect.SignInDistribution/Region
     :cognitect.aws.connect.SignInDistribution/Enabled]))

(s/def
  :cognitect.aws.connect/CreateUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateUserRequest/Username
     :cognitect.aws.connect.CreateUserRequest/PhoneConfig
     :cognitect.aws.connect.CreateUserRequest/SecurityProfileIds
     :cognitect.aws.connect.CreateUserRequest/RoutingProfileId
     :cognitect.aws.connect.CreateUserRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.CreateUserRequest/Password
     :cognitect.aws.connect.CreateUserRequest/IdentityInfo
     :cognitect.aws.connect.CreateUserRequest/Tags
     :cognitect.aws.connect.CreateUserRequest/HierarchyGroupId
     :cognitect.aws.connect.CreateUserRequest/DirectoryUserId]))

(s/def
  :cognitect.aws.connect/ListCondition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListCondition/Conditions
     :cognitect.aws.connect.ListCondition/TargetListType]))

(s/def :cognitect.aws.connect/AssociatedQueueIdList (s/coll-of :cognitect.aws.connect/QueueId))

(s/def
  :cognitect.aws.connect/UpdateEvaluationFormRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateEvaluationFormRequest/InstanceId
     :cognitect.aws.connect.UpdateEvaluationFormRequest/EvaluationFormId
     :cognitect.aws.connect.UpdateEvaluationFormRequest/EvaluationFormVersion
     :cognitect.aws.connect.UpdateEvaluationFormRequest/Title
     :cognitect.aws.connect.UpdateEvaluationFormRequest/Items]
    :opt-un
    [:cognitect.aws.connect.UpdateEvaluationFormRequest/Description
     :cognitect.aws.connect.UpdateEvaluationFormRequest/ScoringStrategy
     :cognitect.aws.connect.UpdateEvaluationFormRequest/CreateNewVersion
     :cognitect.aws.connect.UpdateEvaluationFormRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/StartTaskContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartTaskContactRequest/InstanceId
     :cognitect.aws.connect.StartTaskContactRequest/Name]
    :opt-un
    [:cognitect.aws.connect.StartTaskContactRequest/TaskTemplateId
     :cognitect.aws.connect.StartTaskContactRequest/PreviousContactId
     :cognitect.aws.connect.StartTaskContactRequest/ContactFlowId
     :cognitect.aws.connect.StartTaskContactRequest/SegmentAttributes
     :cognitect.aws.connect.StartTaskContactRequest/ScheduledTime
     :cognitect.aws.connect.StartTaskContactRequest/QuickConnectId
     :cognitect.aws.connect.StartTaskContactRequest/Attributes
     :cognitect.aws.connect.StartTaskContactRequest/References
     :cognitect.aws.connect.StartTaskContactRequest/Description
     :cognitect.aws.connect.StartTaskContactRequest/RelatedContactId
     :cognitect.aws.connect.StartTaskContactRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/DescribeContactEvaluationResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeContactEvaluationResponse/Evaluation
     :cognitect.aws.connect.DescribeContactEvaluationResponse/EvaluationForm]))

(s/def
  :cognitect.aws.connect/RoutingCriteriaInput
  (s/keys :opt-un [:cognitect.aws.connect.RoutingCriteriaInput/Steps]))

(s/def :cognitect.aws.connect/TrafficType (s/spec string? :gen #(s/gen #{"GENERAL" "CAMPAIGN"})))

(s/def
  :cognitect.aws.connect/ControlPlaneUserAttributeFilter
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ControlPlaneUserAttributeFilter/AndCondition
     :cognitect.aws.connect.ControlPlaneUserAttributeFilter/TagCondition
     :cognitect.aws.connect.ControlPlaneUserAttributeFilter/HierarchyGroupCondition
     :cognitect.aws.connect.ControlPlaneUserAttributeFilter/OrConditions]))

(s/def
  :cognitect.aws.connect/ListUseCasesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListUseCasesResponse/NextToken
     :cognitect.aws.connect.ListUseCasesResponse/UseCaseSummaryList]))

(s/def
  :cognitect.aws.connect/CreateRuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateRuleRequest/InstanceId
     :cognitect.aws.connect.CreateRuleRequest/Name
     :cognitect.aws.connect.CreateRuleRequest/TriggerEventSource
     :cognitect.aws.connect.CreateRuleRequest/Function
     :cognitect.aws.connect.CreateRuleRequest/Actions
     :cognitect.aws.connect.CreateRuleRequest/PublishStatus]
    :opt-un
    [:cognitect.aws.connect.CreateRuleRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/AssociateRoutingProfileQueuesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateRoutingProfileQueuesRequest/InstanceId
     :cognitect.aws.connect.AssociateRoutingProfileQueuesRequest/RoutingProfileId
     :cognitect.aws.connect.AssociateRoutingProfileQueuesRequest/QueueConfigs]))

(s/def
  :cognitect.aws.connect/OutboundContactNotPermittedException
  (s/keys :opt-un [:cognitect.aws.connect.OutboundContactNotPermittedException/Message]))

(s/def
  :cognitect.aws.connect/OutboundEmailConfig
  (s/keys :opt-un [:cognitect.aws.connect.OutboundEmailConfig/OutboundEmailAddressId]))

(s/def
  :cognitect.aws.connect/ReplicationConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ReplicationConfiguration/SourceRegion
     :cognitect.aws.connect.ReplicationConfiguration/ReplicationStatusSummaryList
     :cognitect.aws.connect.ReplicationConfiguration/GlobalSignInEndpoint]))

(s/def :cognitect.aws.connect/PromptList (s/coll-of :cognitect.aws.connect/Prompt))

(s/def
  :cognitect.aws.connect/ContactDetails
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactDetails/Description :cognitect.aws.connect.ContactDetails/Name]))

(s/def :cognitect.aws.connect/SearchableQueueType (s/spec string? :gen #(s/gen #{"STANDARD"})))

(s/def
  :cognitect.aws.connect/BatchGetAttachedFileMetadataRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.BatchGetAttachedFileMetadataRequest/FileIds
     :cognitect.aws.connect.BatchGetAttachedFileMetadataRequest/InstanceId
     :cognitect.aws.connect.BatchGetAttachedFileMetadataRequest/AssociatedResourceArn]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisOffset
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/FieldValueId
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/RoutingExpressions
  (s/coll-of :cognitect.aws.connect/RoutingExpression :max-count 50))

(s/def
  :cognitect.aws.connect/Credentials
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Credentials/AccessToken
     :cognitect.aws.connect.Credentials/RefreshToken
     :cognitect.aws.connect.Credentials/RefreshTokenExpiration
     :cognitect.aws.connect.Credentials/AccessTokenExpiration]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisIssuesDetected
  (s/coll-of :cognitect.aws.connect/RealTimeContactAnalysisIssueDetected))

(s/def
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionAutomation
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormSingleSelectQuestionAutomation/Options]
    :opt-un
    [:cognitect.aws.connect.EvaluationFormSingleSelectQuestionAutomation/DefaultOptionRefId]))

(s/def
  :cognitect.aws.connect/AllowedAccessControlTags
  (s/map-of
    :cognitect.aws.connect/SecurityProfilePolicyKey
    :cognitect.aws.connect/SecurityProfilePolicyValue
    :max-count
    4))

(s/def
  :cognitect.aws.connect/URI
  (s/spec
    (s/and string? #(<= 1 (count %) 2000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EvaluationMetadata
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationMetadata/ContactId
     :cognitect.aws.connect.EvaluationMetadata/EvaluatorArn]
    :opt-un
    [:cognitect.aws.connect.EvaluationMetadata/Score
     :cognitect.aws.connect.EvaluationMetadata/ContactAgentId]))

(s/def
  :cognitect.aws.connect/Password
  (s/spec
    #(re-matches (re-pattern "/^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)[a-zA-Z\\d\\S]{8,64}$/") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/RuleSummary
  (s/keys
    :req-un
    [:cognitect.aws.connect.RuleSummary/Name
     :cognitect.aws.connect.RuleSummary/RuleId
     :cognitect.aws.connect.RuleSummary/RuleArn
     :cognitect.aws.connect.RuleSummary/EventSourceName
     :cognitect.aws.connect.RuleSummary/PublishStatus
     :cognitect.aws.connect.RuleSummary/ActionSummaries
     :cognitect.aws.connect.RuleSummary/CreatedTime
     :cognitect.aws.connect.RuleSummary/LastUpdatedTime]))

(s/def
  :cognitect.aws.connect/SearchAvailablePhoneNumbersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchAvailablePhoneNumbersResponse/NextToken
     :cognitect.aws.connect.SearchAvailablePhoneNumbersResponse/AvailableNumbersList]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentPostContactSummary
  (s/keys
    :req-un
    [:cognitect.aws.connect.RealTimeContactAnalysisSegmentPostContactSummary/Status]
    :opt-un
    [:cognitect.aws.connect.RealTimeContactAnalysisSegmentPostContactSummary/Content
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentPostContactSummary/FailureCode]))

(s/def
  :cognitect.aws.connect/AgentStatusDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 250) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListRealtimeContactAnalysisSegmentsV2Response
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Response/Channel
     :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Response/Status
     :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Response/Segments]
    :opt-un
    [:cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Response/NextToken]))

(s/def
  :cognitect.aws.connect/EvaluationFormQuestionTypeProperties
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EvaluationFormQuestionTypeProperties/Numeric
     :cognitect.aws.connect.EvaluationFormQuestionTypeProperties/SingleSelect]))

(s/def
  :cognitect.aws.connect/ResourceVersion
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/NotificationContentType
  (s/spec string? :gen #(s/gen #{"PLAIN_TEXT"})))

(s/def
  :cognitect.aws.connect/Prompt
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Prompt/PromptId
     :cognitect.aws.connect.Prompt/Tags
     :cognitect.aws.connect.Prompt/Description
     :cognitect.aws.connect.Prompt/LastModifiedRegion
     :cognitect.aws.connect.Prompt/LastModifiedTime
     :cognitect.aws.connect.Prompt/Name
     :cognitect.aws.connect.Prompt/PromptARN]))

(s/def
  :cognitect.aws.connect/TrafficDistributionGroupIdOrArn
  (s/spec
    #(re-matches
      (re-pattern
        "^(arn:(aws|aws-us-gov):connect:[a-z]{2}-[a-z-]+-[0-9]{1}:[0-9]{1,20}:traffic-distribution-group/)?[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/DeleteViewRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteViewRequest/InstanceId
     :cognitect.aws.connect.DeleteViewRequest/ViewId]))

(s/def
  :cognitect.aws.connect/ListPhoneNumbersSummaryList
  (s/coll-of :cognitect.aws.connect/ListPhoneNumbersSummary))

(s/def
  :cognitect.aws.connect/HoursOfOperationOverrideSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HoursOfOperationOverrideSearchCriteria/DateCondition
     :cognitect.aws.connect.HoursOfOperationOverrideSearchCriteria/OrConditions
     :cognitect.aws.connect.HoursOfOperationOverrideSearchCriteria/StringCondition
     :cognitect.aws.connect.HoursOfOperationOverrideSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/UpdateRoutingProfileQueuesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateRoutingProfileQueuesRequest/InstanceId
     :cognitect.aws.connect.UpdateRoutingProfileQueuesRequest/RoutingProfileId
     :cognitect.aws.connect.UpdateRoutingProfileQueuesRequest/QueueConfigs]))

(s/def
  :cognitect.aws.connect/CreateQuickConnectRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateQuickConnectRequest/InstanceId
     :cognitect.aws.connect.CreateQuickConnectRequest/Name
     :cognitect.aws.connect.CreateQuickConnectRequest/QuickConnectConfig]
    :opt-un
    [:cognitect.aws.connect.CreateQuickConnectRequest/Tags
     :cognitect.aws.connect.CreateQuickConnectRequest/Description]))

(s/def
  :cognitect.aws.connect/ReplicationStatusSummaryList
  (s/coll-of :cognitect.aws.connect/ReplicationStatusSummary :min-count 0 :max-count 11))

(s/def
  :cognitect.aws.connect/MaxResult100
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.connect/SearchQueuesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchQueuesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchQueuesRequest/NextToken
     :cognitect.aws.connect.SearchQueuesRequest/SearchFilter
     :cognitect.aws.connect.SearchQueuesRequest/SearchCriteria
     :cognitect.aws.connect.SearchQueuesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/EvaluationFormNumericQuestionAutomation
  (s/keys :opt-un [:cognitect.aws.connect.EvaluationFormNumericQuestionAutomation/PropertyValue]))

(s/def
  :cognitect.aws.connect/CreateIntegrationAssociationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateIntegrationAssociationResponse/IntegrationAssociationId
     :cognitect.aws.connect.CreateIntegrationAssociationResponse/IntegrationAssociationArn]))

(s/def
  :cognitect.aws.connect/SegmentAttributeValueString
  (s/spec
    (s/and string? #(<= 0 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DeleteContactFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteContactFlowRequest/InstanceId
     :cognitect.aws.connect.DeleteContactFlowRequest/ContactFlowId]))

(s/def :cognitect.aws.connect/ViewsSummaryList (s/coll-of :cognitect.aws.connect/ViewSummary))

(s/def
  :cognitect.aws.connect/ContactMetrics
  (s/coll-of :cognitect.aws.connect/ContactMetricInfo :min-count 1))

(s/def
  :cognitect.aws.connect/ListViewVersionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListViewVersionsResponse/ViewVersionSummaryList
     :cognitect.aws.connect.ListViewVersionsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/CreateUserHierarchyGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateUserHierarchyGroupRequest/Name
     :cognitect.aws.connect.CreateUserHierarchyGroupRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.CreateUserHierarchyGroupRequest/Tags
     :cognitect.aws.connect.CreateUserHierarchyGroupRequest/ParentGroupId]))

(s/def
  :cognitect.aws.connect/DeleteEvaluationFormRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteEvaluationFormRequest/InstanceId
     :cognitect.aws.connect.DeleteEvaluationFormRequest/EvaluationFormId]
    :opt-un
    [:cognitect.aws.connect.DeleteEvaluationFormRequest/EvaluationFormVersion]))

(s/def
  :cognitect.aws.connect/ListAssociatedContactsRequestMaxResults
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.connect/QueueIdList
  (s/coll-of :cognitect.aws.connect/QueueId :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentEvent
  (s/keys
    :req-un
    [:cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/Id
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/EventType
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/Time]
    :opt-un
    [:cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/ParticipantId
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/DisplayName
     :cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/ParticipantRole]))

(s/def
  :cognitect.aws.connect/MonitorContactResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.MonitorContactResponse/ContactArn
     :cognitect.aws.connect.MonitorContactResponse/ContactId]))

(s/def
  :cognitect.aws.connect/SearchContactsMatchType
  (s/spec string? :gen #(s/gen #{"MATCH_ANY" "MATCH_ALL"})))

(s/def
  :cognitect.aws.connect/QuickConnectConfig
  (s/keys
    :req-un
    [:cognitect.aws.connect.QuickConnectConfig/QuickConnectType]
    :opt-un
    [:cognitect.aws.connect.QuickConnectConfig/PhoneConfig
     :cognitect.aws.connect.QuickConnectConfig/QueueConfig
     :cognitect.aws.connect.QuickConnectConfig/UserConfig]))

(s/def
  :cognitect.aws.connect/ListSecurityProfilesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListSecurityProfilesResponse/NextToken
     :cognitect.aws.connect.ListSecurityProfilesResponse/SecurityProfileSummaryList]))

(s/def
  :cognitect.aws.connect/FileId
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListLexBotsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListLexBotsResponse/LexBots
     :cognitect.aws.connect.ListLexBotsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/DisconnectDetails
  (s/keys :opt-un [:cognitect.aws.connect.DisconnectDetails/PotentialDisconnectIssue]))

(s/def
  :cognitect.aws.connect/ListAnalyticsDataLakeDataSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListAnalyticsDataLakeDataSetsResponse/NextToken
     :cognitect.aws.connect.ListAnalyticsDataLakeDataSetsResponse/Results]))

(s/def
  :cognitect.aws.connect/EvaluationScore
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EvaluationScore/NotApplicable
     :cognitect.aws.connect.EvaluationScore/Percentage
     :cognitect.aws.connect.EvaluationScore/AutomaticFail]))

(s/def :cognitect.aws.connect/RuleFunction string?)

(s/def
  :cognitect.aws.connect/CreatePromptResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreatePromptResponse/PromptId
     :cognitect.aws.connect.CreatePromptResponse/PromptARN]))

(s/def
  :cognitect.aws.connect/CreatePredefinedAttributeRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreatePredefinedAttributeRequest/InstanceId
     :cognitect.aws.connect.CreatePredefinedAttributeRequest/Name
     :cognitect.aws.connect.CreatePredefinedAttributeRequest/Values]))

(s/def
  :cognitect.aws.connect/CustomerQualityMetrics
  (s/keys :opt-un [:cognitect.aws.connect.CustomerQualityMetrics/Audio]))

(s/def
  :cognitect.aws.connect/CreatePersistentContactAssociationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreatePersistentContactAssociationResponse/ContinuedFromContactId]))

(s/def
  :cognitect.aws.connect/EvaluationFormSummaryList
  (s/coll-of :cognitect.aws.connect/EvaluationFormSummary))

(s/def
  :cognitect.aws.connect/ListEvaluationFormVersionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListEvaluationFormVersionsRequest/InstanceId
     :cognitect.aws.connect.ListEvaluationFormVersionsRequest/EvaluationFormId]
    :opt-un
    [:cognitect.aws.connect.ListEvaluationFormVersionsRequest/NextToken
     :cognitect.aws.connect.ListEvaluationFormVersionsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/AuthenticationProfileName
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/QueueType (s/spec string? :gen #(s/gen #{"AGENT" "STANDARD"})))

(s/def
  :cognitect.aws.connect/UpdateCaseActionDefinition
  (s/keys :req-un [:cognitect.aws.connect.UpdateCaseActionDefinition/Fields]))

(s/def
  :cognitect.aws.connect/UpdatePhoneNumberRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdatePhoneNumberRequest/PhoneNumberId]
    :opt-un
    [:cognitect.aws.connect.UpdatePhoneNumberRequest/InstanceId
     :cognitect.aws.connect.UpdatePhoneNumberRequest/TargetArn
     :cognitect.aws.connect.UpdatePhoneNumberRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/ListTaskTemplatesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListTaskTemplatesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListTaskTemplatesRequest/Status
     :cognitect.aws.connect.ListTaskTemplatesRequest/NextToken
     :cognitect.aws.connect.ListTaskTemplatesRequest/MaxResults
     :cognitect.aws.connect.ListTaskTemplatesRequest/Name]))

(s/def :cognitect.aws.connect/SecurityProfileName string?)

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisPostContactSummaryFailureCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"INVALID_ANALYSIS_CONFIGURATION"
        "INTERNAL_ERROR"
        "INSUFFICIENT_CONVERSATION_CONTENT"
        "QUOTA_EXCEEDED"
        "FAILED_SAFETY_GUIDELINES"})))

(s/def
  :cognitect.aws.connect/AgentFirstName
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DownloadUrlMetadata
  (s/keys
    :opt-un
    [:cognitect.aws.connect.DownloadUrlMetadata/UrlExpiry
     :cognitect.aws.connect.DownloadUrlMetadata/Url]))

(s/def
  :cognitect.aws.connect/PredefinedAttributeSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.PredefinedAttributeSearchCriteria/OrConditions
     :cognitect.aws.connect.PredefinedAttributeSearchCriteria/StringCondition
     :cognitect.aws.connect.PredefinedAttributeSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/RealtimeContactAnalysisSegments
  (s/coll-of :cognitect.aws.connect/RealtimeContactAnalysisSegment))

(s/def
  :cognitect.aws.connect/Problems
  (s/coll-of :cognitect.aws.connect/ProblemDetail :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.connect/DescribeHoursOfOperationResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeHoursOfOperationResponse/HoursOfOperation]))

(s/def
  :cognitect.aws.connect/Namespace
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/Name128
  (s/spec #(re-matches (re-pattern "(^[\\S].*[\\S]$)|(^[\\S]$)") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/DescribeInstanceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.DescribeInstanceResponse/ReplicationConfiguration
     :cognitect.aws.connect.DescribeInstanceResponse/Instance]))

(s/def
  :cognitect.aws.connect/IntegrationAssociationSummaryList
  (s/coll-of :cognitect.aws.connect/IntegrationAssociationSummary))

(s/def
  :cognitect.aws.connect/InstanceStorageResourceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS"
        "CONTACT_TRACE_RECORDS"
        "SCREEN_RECORDINGS"
        "CONTACT_EVALUATIONS"
        "EMAIL_MESSAGES"
        "AGENT_EVENTS"
        "MEDIA_STREAMS"
        "CALL_RECORDINGS"
        "SCHEDULED_REPORTS"
        "CHAT_TRANSCRIPTS"
        "ATTACHMENTS"
        "REAL_TIME_CONTACT_ANALYSIS_CHAT_SEGMENTS"
        "REAL_TIME_CONTACT_ANALYSIS_SEGMENTS"})))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisPostContactSummaryContent
  (s/spec
    (s/and string? #(<= 1 (count %) 1270))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1270) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ChatContactMetrics
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ChatContactMetrics/AgentFirstResponseTimestamp
     :cognitect.aws.connect.ChatContactMetrics/TotalBotMessages
     :cognitect.aws.connect.ChatContactMetrics/ConversationTurnCount
     :cognitect.aws.connect.ChatContactMetrics/MultiParty
     :cognitect.aws.connect.ChatContactMetrics/TotalMessages
     :cognitect.aws.connect.ChatContactMetrics/TotalBotMessageLengthInChars
     :cognitect.aws.connect.ChatContactMetrics/AgentFirstResponseTimeInMillis
     :cognitect.aws.connect.ChatContactMetrics/ConversationCloseTimeInMillis]))

(s/def
  :cognitect.aws.connect/PhoneNumberQuickConnectConfig
  (s/keys :req-un [:cognitect.aws.connect.PhoneNumberQuickConnectConfig/PhoneNumber]))

(s/def
  :cognitect.aws.connect/ChatParticipantRoleConfig
  (s/keys :req-un [:cognitect.aws.connect.ChatParticipantRoleConfig/ParticipantTimerConfigList]))

(s/def :cognitect.aws.connect/PhoneType (s/spec string? :gen #(s/gen #{"SOFT_PHONE" "DESK_PHONE"})))

(s/def
  :cognitect.aws.connect/SearchResourceTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchResourceTagsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchResourceTagsRequest/NextToken
     :cognitect.aws.connect.SearchResourceTagsRequest/SearchCriteria
     :cognitect.aws.connect.SearchResourceTagsRequest/MaxResults
     :cognitect.aws.connect.SearchResourceTagsRequest/ResourceTypes]))

(s/def :cognitect.aws.connect/RoutingProfileId string?)

(s/def
  :cognitect.aws.connect/CurrentMetricData
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CurrentMetricData/Value
     :cognitect.aws.connect.CurrentMetricData/Metric]))

(s/def
  :cognitect.aws.connect/UpdateUserHierarchyStructureRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateUserHierarchyStructureRequest/HierarchyStructure
     :cognitect.aws.connect.UpdateUserHierarchyStructureRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/StartContactEvaluationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartContactEvaluationRequest/InstanceId
     :cognitect.aws.connect.StartContactEvaluationRequest/ContactId
     :cognitect.aws.connect.StartContactEvaluationRequest/EvaluationFormId]
    :opt-un
    [:cognitect.aws.connect.StartContactEvaluationRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/AgentHierarchyGroup
  (s/keys :opt-un [:cognitect.aws.connect.AgentHierarchyGroup/Arn]))

(s/def
  :cognitect.aws.connect/MediaConcurrencies
  (s/coll-of :cognitect.aws.connect/MediaConcurrency))

(s/def
  :cognitect.aws.connect/ContactDataRequest
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactDataRequest/Campaign
     :cognitect.aws.connect.ContactDataRequest/SystemEndpoint
     :cognitect.aws.connect.ContactDataRequest/Attributes
     :cognitect.aws.connect.ContactDataRequest/CustomerEndpoint
     :cognitect.aws.connect.ContactDataRequest/RequestIdentifier
     :cognitect.aws.connect.ContactDataRequest/QueueId]))

(s/def
  :cognitect.aws.connect/MetricResultV2
  (s/keys
    :opt-un
    [:cognitect.aws.connect.MetricResultV2/MetricInterval
     :cognitect.aws.connect.MetricResultV2/Dimensions
     :cognitect.aws.connect.MetricResultV2/Collections]))

(s/def
  :cognitect.aws.connect/UpdatePromptRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdatePromptRequest/InstanceId
     :cognitect.aws.connect.UpdatePromptRequest/PromptId]
    :opt-un
    [:cognitect.aws.connect.UpdatePromptRequest/S3Uri
     :cognitect.aws.connect.UpdatePromptRequest/Description
     :cognitect.aws.connect.UpdatePromptRequest/Name]))

(s/def
  :cognitect.aws.connect/ContactId
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/MaxResult2 (s/spec (s/and int? #(<= 1 % 2)) :gen #(gen/choose 1 2)))

(s/def
  :cognitect.aws.connect/QueueSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.QueueSummary/QueueType
     :cognitect.aws.connect.QueueSummary/LastModifiedRegion
     :cognitect.aws.connect.QueueSummary/Arn
     :cognitect.aws.connect.QueueSummary/LastModifiedTime
     :cognitect.aws.connect.QueueSummary/Name
     :cognitect.aws.connect.QueueSummary/Id]))

(s/def
  :cognitect.aws.connect/VocabularySummary
  (s/keys
    :req-un
    [:cognitect.aws.connect.VocabularySummary/Name
     :cognitect.aws.connect.VocabularySummary/Id
     :cognitect.aws.connect.VocabularySummary/Arn
     :cognitect.aws.connect.VocabularySummary/LanguageCode
     :cognitect.aws.connect.VocabularySummary/State
     :cognitect.aws.connect.VocabularySummary/LastModifiedTime]
    :opt-un
    [:cognitect.aws.connect.VocabularySummary/FailureReason]))

(s/def
  :cognitect.aws.connect/DescribeHoursOfOperationOverrideRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeHoursOfOperationOverrideRequest/InstanceId
     :cognitect.aws.connect.DescribeHoursOfOperationOverrideRequest/HoursOfOperationId
     :cognitect.aws.connect.DescribeHoursOfOperationOverrideRequest/HoursOfOperationOverrideId]))

(s/def
  :cognitect.aws.connect/PropertyValidationExceptionProperty
  (s/keys
    :req-un
    [:cognitect.aws.connect.PropertyValidationExceptionProperty/PropertyPath
     :cognitect.aws.connect.PropertyValidationExceptionProperty/Reason
     :cognitect.aws.connect.PropertyValidationExceptionProperty/Message]))

(s/def
  :cognitect.aws.connect/UpdateQueueStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateQueueStatusRequest/InstanceId
     :cognitect.aws.connect.UpdateQueueStatusRequest/QueueId
     :cognitect.aws.connect.UpdateQueueStatusRequest/Status]))

(s/def :cognitect.aws.connect/SortOrder (s/spec string? :gen #(s/gen #{"ASCENDING" "DESCENDING"})))

(s/def
  :cognitect.aws.connect/GetFederationTokenResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.GetFederationTokenResponse/UserId
     :cognitect.aws.connect.GetFederationTokenResponse/Credentials
     :cognitect.aws.connect.GetFederationTokenResponse/SignInUrl
     :cognitect.aws.connect.GetFederationTokenResponse/UserArn]))

(s/def
  :cognitect.aws.connect/DateComparisonType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"GREATER_THAN" "LESS_THAN" "LESS_THAN_OR_EQUAL_TO" "EQUAL_TO" "GREATER_THAN_OR_EQUAL_TO"})))

(s/def
  :cognitect.aws.connect/UserHierarchyGroupSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.UserHierarchyGroupSearchFilter/AttributeFilter]))

(s/def
  :cognitect.aws.connect/Grouping
  (s/spec string? :gen #(s/gen #{"ROUTING_PROFILE" "QUEUE" "CHANNEL" "ROUTING_STEP_EXPRESSION"})))

(s/def
  :cognitect.aws.connect/DescribeUserHierarchyGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeUserHierarchyGroupRequest/HierarchyGroupId
     :cognitect.aws.connect.DescribeUserHierarchyGroupRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/Attendee
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Attendee/AttendeeId :cognitect.aws.connect.Attendee/JoinToken]))

(s/def
  :cognitect.aws.connect/ParticipantTimerDurationInMinutes
  (s/spec (s/and int? #(<= 2 % 480)) :gen #(gen/choose 2 480)))

(s/def
  :cognitect.aws.connect/QueueInfoInput
  (s/keys :opt-un [:cognitect.aws.connect.QueueInfoInput/Id]))

(s/def
  :cognitect.aws.connect/SendChatIntegrationEventResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SendChatIntegrationEventResponse/InitialContactId
     :cognitect.aws.connect.SendChatIntegrationEventResponse/NewChatCreated]))

(s/def
  :cognitect.aws.connect/ContactRecordingType
  (s/spec string? :gen #(s/gen #{"AGENT" "SCREEN" "IVR"})))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptItemRedaction
  (s/keys
    :opt-un
    [:cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemRedaction/CharacterOffsets]))

(s/def
  :cognitect.aws.connect/DescribeContactEvaluationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeContactEvaluationRequest/InstanceId
     :cognitect.aws.connect.DescribeContactEvaluationRequest/EvaluationId]))

(s/def
  :cognitect.aws.connect/ReferenceValue
  (s/spec
    (s/and string? #(<= 0 (count %) 4096))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4096) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/RoutingProfileDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 250) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ContactFlowStatus
  (s/spec string? :gen #(s/gen #{"PUBLISHED" "SAVED"})))

(s/def
  :cognitect.aws.connect/UpdateEmailAddressMetadataRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateEmailAddressMetadataRequest/InstanceId
     :cognitect.aws.connect.UpdateEmailAddressMetadataRequest/EmailAddressId]
    :opt-un
    [:cognitect.aws.connect.UpdateEmailAddressMetadataRequest/DisplayName
     :cognitect.aws.connect.UpdateEmailAddressMetadataRequest/Description
     :cognitect.aws.connect.UpdateEmailAddressMetadataRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/ContactFlowSummaryList
  (s/coll-of :cognitect.aws.connect/ContactFlowSummary))

(s/def
  :cognitect.aws.connect/UpdateUserRoutingProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateUserRoutingProfileRequest/RoutingProfileId
     :cognitect.aws.connect.UpdateUserRoutingProfileRequest/UserId
     :cognitect.aws.connect.UpdateUserRoutingProfileRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/CreateRoutingProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateRoutingProfileRequest/InstanceId
     :cognitect.aws.connect.CreateRoutingProfileRequest/Name
     :cognitect.aws.connect.CreateRoutingProfileRequest/Description
     :cognitect.aws.connect.CreateRoutingProfileRequest/DefaultOutboundQueueId
     :cognitect.aws.connect.CreateRoutingProfileRequest/MediaConcurrencies]
    :opt-un
    [:cognitect.aws.connect.CreateRoutingProfileRequest/AgentAvailabilityTimer
     :cognitect.aws.connect.CreateRoutingProfileRequest/Tags
     :cognitect.aws.connect.CreateRoutingProfileRequest/QueueConfigs]))

(s/def
  :cognitect.aws.connect/ReadOnlyFieldInfo
  (s/keys :opt-un [:cognitect.aws.connect.ReadOnlyFieldInfo/Id]))

(s/def
  :cognitect.aws.connect/SecurityKey
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SecurityKey/AssociationId
     :cognitect.aws.connect.SecurityKey/Key
     :cognitect.aws.connect.SecurityKey/CreationTime]))

(s/def
  :cognitect.aws.connect/CreateQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateQueueRequest/InstanceId
     :cognitect.aws.connect.CreateQueueRequest/Name
     :cognitect.aws.connect.CreateQueueRequest/HoursOfOperationId]
    :opt-un
    [:cognitect.aws.connect.CreateQueueRequest/Tags
     :cognitect.aws.connect.CreateQueueRequest/OutboundEmailConfig
     :cognitect.aws.connect.CreateQueueRequest/OutboundCallerConfig
     :cognitect.aws.connect.CreateQueueRequest/Description
     :cognitect.aws.connect.CreateQueueRequest/MaxContacts
     :cognitect.aws.connect.CreateQueueRequest/QuickConnectIds]))

(s/def
  :cognitect.aws.connect/InstanceStorageConfigs
  (s/coll-of :cognitect.aws.connect/InstanceStorageConfig))

(s/def
  :cognitect.aws.connect/StartChatContactResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.StartChatContactResponse/ParticipantToken
     :cognitect.aws.connect.StartChatContactResponse/ContinuedFromContactId
     :cognitect.aws.connect.StartChatContactResponse/ParticipantId
     :cognitect.aws.connect.StartChatContactResponse/ContactId]))

(s/def
  :cognitect.aws.connect/UpdateRoutingProfileDefaultOutboundQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateRoutingProfileDefaultOutboundQueueRequest/InstanceId
     :cognitect.aws.connect.UpdateRoutingProfileDefaultOutboundQueueRequest/RoutingProfileId
     :cognitect.aws.connect.UpdateRoutingProfileDefaultOutboundQueueRequest/DefaultOutboundQueueId]))

(s/def :cognitect.aws.connect/EvaluationArn string?)

(s/def
  :cognitect.aws.connect/BatchGetAttachedFileMetadataResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.BatchGetAttachedFileMetadataResponse/Files
     :cognitect.aws.connect.BatchGetAttachedFileMetadataResponse/Errors]))

(s/def :cognitect.aws.connect/Long (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.connect/ChannelList (s/coll-of :cognitect.aws.connect/Channel))

(s/def
  :cognitect.aws.connect/SearchVocabulariesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchVocabulariesResponse/NextToken
     :cognitect.aws.connect.SearchVocabulariesResponse/VocabularySummaryList]))

(s/def
  :cognitect.aws.connect/QueueQuickConnectConfig
  (s/keys
    :req-un
    [:cognitect.aws.connect.QueueQuickConnectConfig/QueueId
     :cognitect.aws.connect.QueueQuickConnectConfig/ContactFlowId]))

(s/def :cognitect.aws.connect/UpdateContactRoutingDataResponse (s/keys))

(s/def
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionAutomationOptionList
  (s/coll-of
    :cognitect.aws.connect/EvaluationFormSingleSelectQuestionAutomationOption
    :min-count
    1
    :max-count
    20))

(s/def
  :cognitect.aws.connect/SearchAgentStatusesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchAgentStatusesResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchAgentStatusesResponse/NextToken
     :cognitect.aws.connect.SearchAgentStatusesResponse/AgentStatuses]))

(s/def
  :cognitect.aws.connect/HierarchyPathReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HierarchyPathReference/LevelFour
     :cognitect.aws.connect.HierarchyPathReference/LevelOne
     :cognitect.aws.connect.HierarchyPathReference/LevelTwo
     :cognitect.aws.connect.HierarchyPathReference/LevelThree
     :cognitect.aws.connect.HierarchyPathReference/LevelFive]))

(s/def
  :cognitect.aws.connect/ListQueuesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListQueuesResponse/NextToken
     :cognitect.aws.connect.ListQueuesResponse/QueueSummaryList]))

(s/def
  :cognitect.aws.connect/HoursOfOperationOverrideSearchConditionList
  (s/coll-of :cognitect.aws.connect/HoursOfOperationOverrideSearchCriteria))

(s/def :cognitect.aws.connect/CurrentMetrics (s/coll-of :cognitect.aws.connect/CurrentMetric))

(s/def :cognitect.aws.connect/VocabularyFailureReason string?)

(s/def
  :cognitect.aws.connect/Instance
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Instance/ServiceRole
     :cognitect.aws.connect.Instance/OutboundCallsEnabled
     :cognitect.aws.connect.Instance/InstanceAlias
     :cognitect.aws.connect.Instance/Tags
     :cognitect.aws.connect.Instance/InstanceAccessUrl
     :cognitect.aws.connect.Instance/CreatedTime
     :cognitect.aws.connect.Instance/StatusReason
     :cognitect.aws.connect.Instance/InboundCallsEnabled
     :cognitect.aws.connect.Instance/IdentityManagementType
     :cognitect.aws.connect.Instance/Arn
     :cognitect.aws.connect.Instance/InstanceStatus
     :cognitect.aws.connect.Instance/Id]))

(s/def
  :cognitect.aws.connect/DescribeContactFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeContactFlowRequest/InstanceId
     :cognitect.aws.connect.DescribeContactFlowRequest/ContactFlowId]))

(s/def
  :cognitect.aws.connect/UseCase
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UseCase/UseCaseType
     :cognitect.aws.connect.UseCase/UseCaseArn
     :cognitect.aws.connect.UseCase/UseCaseId]))

(s/def
  :cognitect.aws.connect/UpdateInstanceStorageConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateInstanceStorageConfigRequest/InstanceId
     :cognitect.aws.connect.UpdateInstanceStorageConfigRequest/AssociationId
     :cognitect.aws.connect.UpdateInstanceStorageConfigRequest/ResourceType
     :cognitect.aws.connect.UpdateInstanceStorageConfigRequest/StorageConfig]
    :opt-un
    [:cognitect.aws.connect.UpdateInstanceStorageConfigRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/TagContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.TagContactRequest/ContactId
     :cognitect.aws.connect.TagContactRequest/InstanceId
     :cognitect.aws.connect.TagContactRequest/Tags]))

(s/def
  :cognitect.aws.connect/ListUserHierarchyGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListUserHierarchyGroupsResponse/UserHierarchyGroupSummaryList
     :cognitect.aws.connect.ListUserHierarchyGroupsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/ErrorResult
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ErrorResult/ErrorMessage :cognitect.aws.connect.ErrorResult/ErrorCode]))

(s/def
  :cognitect.aws.connect/SingleSelectOptions
  (s/coll-of :cognitect.aws.connect/TaskTemplateSingleSelectOption))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisCategoryName
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/MonitorCapability
  (s/spec string? :gen #(s/gen #{"BARGE" "SILENT_MONITOR"})))

(s/def
  :cognitect.aws.connect/DisassociateInstanceStorageConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateInstanceStorageConfigRequest/InstanceId
     :cognitect.aws.connect.DisassociateInstanceStorageConfigRequest/AssociationId
     :cognitect.aws.connect.DisassociateInstanceStorageConfigRequest/ResourceType]
    :opt-un
    [:cognitect.aws.connect.DisassociateInstanceStorageConfigRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/AgentsMinOneMaxHundred
  (s/coll-of :cognitect.aws.connect/UserId :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.connect/TrafficDistributionGroupId
  (s/spec
    #(re-matches (re-pattern "^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/DescribeRoutingProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeRoutingProfileRequest/InstanceId
     :cognitect.aws.connect.DescribeRoutingProfileRequest/RoutingProfileId]))

(s/def
  :cognitect.aws.connect/UserIdentityInfo
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UserIdentityInfo/Email
     :cognitect.aws.connect.UserIdentityInfo/SecondaryEmail
     :cognitect.aws.connect.UserIdentityInfo/Mobile
     :cognitect.aws.connect.UserIdentityInfo/LastName
     :cognitect.aws.connect.UserIdentityInfo/FirstName]))

(s/def
  :cognitect.aws.connect/EmailHeaders
  (s/map-of :cognitect.aws.connect/EmailHeaderType :cognitect.aws.connect/EmailHeaderValue))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisPointOfInterest
  (s/keys :opt-un [:cognitect.aws.connect.RealTimeContactAnalysisPointOfInterest/TranscriptItems]))

(s/def
  :cognitect.aws.connect/MediaPlacement
  (s/keys
    :opt-un
    [:cognitect.aws.connect.MediaPlacement/AudioFallbackUrl
     :cognitect.aws.connect.MediaPlacement/SignalingUrl
     :cognitect.aws.connect.MediaPlacement/TurnControlUrl
     :cognitect.aws.connect.MediaPlacement/AudioHostUrl
     :cognitect.aws.connect.MediaPlacement/EventIngestionUrl]))

(s/def
  :cognitect.aws.connect/AgentStatusSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.AgentStatusSearchFilter/AttributeFilter]))

(s/def
  :cognitect.aws.connect/HistoricalMetric
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HistoricalMetric/Unit
     :cognitect.aws.connect.HistoricalMetric/Threshold
     :cognitect.aws.connect.HistoricalMetric/Name
     :cognitect.aws.connect.HistoricalMetric/Statistic]))

(s/def
  :cognitect.aws.connect/ListPhoneNumbersV2Response
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListPhoneNumbersV2Response/ListPhoneNumbersSummaryList
     :cognitect.aws.connect.ListPhoneNumbersV2Response/NextToken]))

(s/def
  :cognitect.aws.connect/CreateUseCaseResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateUseCaseResponse/UseCaseArn
     :cognitect.aws.connect.CreateUseCaseResponse/UseCaseId]))

(s/def
  :cognitect.aws.connect/StartEmailContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartEmailContactRequest/InstanceId
     :cognitect.aws.connect.StartEmailContactRequest/FromEmailAddress
     :cognitect.aws.connect.StartEmailContactRequest/DestinationEmailAddress
     :cognitect.aws.connect.StartEmailContactRequest/EmailMessage]
    :opt-un
    [:cognitect.aws.connect.StartEmailContactRequest/ContactFlowId
     :cognitect.aws.connect.StartEmailContactRequest/SegmentAttributes
     :cognitect.aws.connect.StartEmailContactRequest/Attachments
     :cognitect.aws.connect.StartEmailContactRequest/Attributes
     :cognitect.aws.connect.StartEmailContactRequest/References
     :cognitect.aws.connect.StartEmailContactRequest/Description
     :cognitect.aws.connect.StartEmailContactRequest/AdditionalRecipients
     :cognitect.aws.connect.StartEmailContactRequest/Name
     :cognitect.aws.connect.StartEmailContactRequest/RelatedContactId
     :cognitect.aws.connect.StartEmailContactRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/ExpiryDurationInMinutes
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/CreateUseCaseRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateUseCaseRequest/InstanceId
     :cognitect.aws.connect.CreateUseCaseRequest/IntegrationAssociationId
     :cognitect.aws.connect.CreateUseCaseRequest/UseCaseType]
    :opt-un
    [:cognitect.aws.connect.CreateUseCaseRequest/Tags]))

(s/def :cognitect.aws.connect/UpdateContactFlowContentResponse (s/keys))

(s/def
  :cognitect.aws.connect/OutboundMessageSourceType
  (s/spec string? :gen #(s/gen #{"TEMPLATE" "RAW"})))

(s/def
  :cognitect.aws.connect/InitiationMethodList
  (s/coll-of :cognitect.aws.connect/ContactInitiationMethod))

(s/def
  :cognitect.aws.connect/ClaimPhoneNumberRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ClaimPhoneNumberRequest/PhoneNumber]
    :opt-un
    [:cognitect.aws.connect.ClaimPhoneNumberRequest/InstanceId
     :cognitect.aws.connect.ClaimPhoneNumberRequest/PhoneNumberDescription
     :cognitect.aws.connect.ClaimPhoneNumberRequest/TargetArn
     :cognitect.aws.connect.ClaimPhoneNumberRequest/Tags
     :cognitect.aws.connect.ClaimPhoneNumberRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/StreamingId
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/TaskTemplateFieldType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"URL"
        "DESCRIPTION"
        "NAME"
        "DATE_TIME"
        "NUMBER"
        "SELF_ASSIGN"
        "QUICK_CONNECT"
        "TEXT_AREA"
        "TEXT"
        "SINGLE_SELECT"
        "EMAIL"
        "EXPIRY_DURATION"
        "SCHEDULED_TIME"
        "BOOLEAN"})))

(s/def
  :cognitect.aws.connect/PromptName
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/BoxedBoolean boolean?)

(s/def
  :cognitect.aws.connect/UpdateContactFlowMetadataRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactFlowMetadataRequest/InstanceId
     :cognitect.aws.connect.UpdateContactFlowMetadataRequest/ContactFlowId]
    :opt-un
    [:cognitect.aws.connect.UpdateContactFlowMetadataRequest/ContactFlowState
     :cognitect.aws.connect.UpdateContactFlowMetadataRequest/Description
     :cognitect.aws.connect.UpdateContactFlowMetadataRequest/Name]))

(s/def
  :cognitect.aws.connect/DeleteVocabularyRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteVocabularyRequest/InstanceId
     :cognitect.aws.connect.DeleteVocabularyRequest/VocabularyId]))

(s/def :cognitect.aws.connect/ISO8601Datetime string?)

(s/def
  :cognitect.aws.connect/TrafficDistributionGroupStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"UPDATE_IN_PROGRESS"
        "ACTIVE"
        "PENDING_DELETION"
        "CREATION_IN_PROGRESS"
        "DELETION_FAILED"
        "CREATION_FAILED"})))

(s/def
  :cognitect.aws.connect/PersistentChat
  (s/keys
    :opt-un
    [:cognitect.aws.connect.PersistentChat/SourceContactId
     :cognitect.aws.connect.PersistentChat/RehydrationType]))

(s/def
  :cognitect.aws.connect/ContactFlowSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.ContactFlowSearchFilter/TagFilter]))

(s/def
  :cognitect.aws.connect/CreateContactFlowResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateContactFlowResponse/ContactFlowArn
     :cognitect.aws.connect.CreateContactFlowResponse/ContactFlowId
     :cognitect.aws.connect.CreateContactFlowResponse/FlowContentSha256]))

(s/def
  :cognitect.aws.connect/AgentAvailabilityTimer
  (s/spec string? :gen #(s/gen #{"TIME_SINCE_LAST_INBOUND" "TIME_SINCE_LAST_ACTIVITY"})))

(s/def
  :cognitect.aws.connect/DeleteRoutingProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteRoutingProfileRequest/InstanceId
     :cognitect.aws.connect.DeleteRoutingProfileRequest/RoutingProfileId]))

(s/def
  :cognitect.aws.connect/SingleSelectQuestionRuleCategoryAutomation
  (s/keys
    :req-un
    [:cognitect.aws.connect.SingleSelectQuestionRuleCategoryAutomation/Category
     :cognitect.aws.connect.SingleSelectQuestionRuleCategoryAutomation/Condition
     :cognitect.aws.connect.SingleSelectQuestionRuleCategoryAutomation/OptionRefId]))

(s/def
  :cognitect.aws.connect/RoutingProfile
  (s/keys
    :opt-un
    [:cognitect.aws.connect.RoutingProfile/AgentAvailabilityTimer
     :cognitect.aws.connect.RoutingProfile/InstanceId
     :cognitect.aws.connect.RoutingProfile/Tags
     :cognitect.aws.connect.RoutingProfile/DefaultOutboundQueueId
     :cognitect.aws.connect.RoutingProfile/MediaConcurrencies
     :cognitect.aws.connect.RoutingProfile/AssociatedQueueIds
     :cognitect.aws.connect.RoutingProfile/Description
     :cognitect.aws.connect.RoutingProfile/LastModifiedRegion
     :cognitect.aws.connect.RoutingProfile/NumberOfAssociatedQueues
     :cognitect.aws.connect.RoutingProfile/NumberOfAssociatedUsers
     :cognitect.aws.connect.RoutingProfile/LastModifiedTime
     :cognitect.aws.connect.RoutingProfile/Name
     :cognitect.aws.connect.RoutingProfile/RoutingProfileId
     :cognitect.aws.connect.RoutingProfile/IsDefault
     :cognitect.aws.connect.RoutingProfile/RoutingProfileArn]))

(s/def
  :cognitect.aws.connect/BatchPutContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.BatchPutContactRequest/InstanceId
     :cognitect.aws.connect.BatchPutContactRequest/ContactDataRequestList]
    :opt-un
    [:cognitect.aws.connect.BatchPutContactRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/GetEffectiveHoursOfOperationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetEffectiveHoursOfOperationsRequest/InstanceId
     :cognitect.aws.connect.GetEffectiveHoursOfOperationsRequest/HoursOfOperationId
     :cognitect.aws.connect.GetEffectiveHoursOfOperationsRequest/FromDate
     :cognitect.aws.connect.GetEffectiveHoursOfOperationsRequest/ToDate]))

(s/def
  :cognitect.aws.connect/DescribeInstanceAttributeResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeInstanceAttributeResponse/Attribute]))

(s/def
  :cognitect.aws.connect/AwsRegion
  (s/spec #(re-matches (re-pattern "[a-z]{2}(-[a-z]+){1,2}(-[0-9])?") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/AgentStatusType
  (s/spec string? :gen #(s/gen #{"CUSTOM" "ROUTABLE" "OFFLINE"})))

(s/def :cognitect.aws.connect/UpdateContactFlowModuleMetadataResponse (s/keys))

(s/def
  :cognitect.aws.connect/HierarchyGroupIdList
  (s/coll-of :cognitect.aws.connect/HierarchyGroupId :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.connect/QuickConnectsList
  (s/coll-of :cognitect.aws.connect/QuickConnectId :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.connect/Queues
  (s/coll-of :cognitect.aws.connect/QueueId :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.connect/UntagContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UntagContactRequest/ContactId
     :cognitect.aws.connect.UntagContactRequest/InstanceId
     :cognitect.aws.connect.UntagContactRequest/TagKeys]))

(s/def :cognitect.aws.connect/ErrorResults (s/coll-of :cognitect.aws.connect/ErrorResult))

(s/def
  :cognitect.aws.connect/AuthenticationProfileSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AuthenticationProfileSummary/LastModifiedRegion
     :cognitect.aws.connect.AuthenticationProfileSummary/Arn
     :cognitect.aws.connect.AuthenticationProfileSummary/LastModifiedTime
     :cognitect.aws.connect.AuthenticationProfileSummary/Name
     :cognitect.aws.connect.AuthenticationProfileSummary/IsDefault
     :cognitect.aws.connect.AuthenticationProfileSummary/Id]))

(s/def
  :cognitect.aws.connect/ListContactReferencesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListContactReferencesRequest/InstanceId
     :cognitect.aws.connect.ListContactReferencesRequest/ContactId
     :cognitect.aws.connect.ListContactReferencesRequest/ReferenceTypes]
    :opt-un
    [:cognitect.aws.connect.ListContactReferencesRequest/NextToken]))

(s/def
  :cognitect.aws.connect/CreateTrafficDistributionGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateTrafficDistributionGroupResponse/Arn
     :cognitect.aws.connect.CreateTrafficDistributionGroupResponse/Id]))

(s/def
  :cognitect.aws.connect/RoutingCriteriaInputStepExpiry
  (s/keys :opt-un [:cognitect.aws.connect.RoutingCriteriaInputStepExpiry/DurationInSeconds]))

(s/def
  :cognitect.aws.connect/DisassociatePhoneNumberContactFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociatePhoneNumberContactFlowRequest/PhoneNumberId
     :cognitect.aws.connect.DisassociatePhoneNumberContactFlowRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/Value
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.connect/ContactMetricResults
  (s/coll-of :cognitect.aws.connect/ContactMetricResult))

(s/def
  :cognitect.aws.connect/ContactFlowSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactFlowSummary/ContactFlowState
     :cognitect.aws.connect.ContactFlowSummary/ContactFlowType
     :cognitect.aws.connect.ContactFlowSummary/Arn
     :cognitect.aws.connect.ContactFlowSummary/Name
     :cognitect.aws.connect.ContactFlowSummary/Id
     :cognitect.aws.connect.ContactFlowSummary/ContactFlowStatus]))

(s/def :cognitect.aws.connect/ARN string?)

(s/def
  :cognitect.aws.connect/UpdateViewMetadataRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateViewMetadataRequest/InstanceId
     :cognitect.aws.connect.UpdateViewMetadataRequest/ViewId]
    :opt-un
    [:cognitect.aws.connect.UpdateViewMetadataRequest/Description
     :cognitect.aws.connect.UpdateViewMetadataRequest/Name]))

(s/def
  :cognitect.aws.connect/QuickConnectName
  (s/spec
    (s/and string? #(<= 1 (count %) 127))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 127) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/QueueSummaryList (s/coll-of :cognitect.aws.connect/QueueSummary))

(s/def :cognitect.aws.connect/ResumeContactResponse (s/keys))

(s/def :cognitect.aws.connect/AgentStatusList (s/coll-of :cognitect.aws.connect/AgentStatus))

(s/def
  :cognitect.aws.connect/EvaluationFormVersionSummary
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormVersionSummary/EvaluationFormArn
     :cognitect.aws.connect.EvaluationFormVersionSummary/EvaluationFormId
     :cognitect.aws.connect.EvaluationFormVersionSummary/EvaluationFormVersion
     :cognitect.aws.connect.EvaluationFormVersionSummary/Locked
     :cognitect.aws.connect.EvaluationFormVersionSummary/Status
     :cognitect.aws.connect.EvaluationFormVersionSummary/CreatedTime
     :cognitect.aws.connect.EvaluationFormVersionSummary/CreatedBy
     :cognitect.aws.connect.EvaluationFormVersionSummary/LastModifiedTime
     :cognitect.aws.connect.EvaluationFormVersionSummary/LastModifiedBy]))

(s/def
  :cognitect.aws.connect/Hours
  (s/spec (s/and int? #(<= 0 % 87600)) :gen #(gen/choose 0 87600)))

(s/def
  :cognitect.aws.connect/ChannelToCountMap
  (s/map-of :cognitect.aws.connect/Channel :cognitect.aws.connect/IntegerCount))

(s/def
  :cognitect.aws.connect/InstanceAttributeValue
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ParticipantTokenCredentials
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ParticipantTokenCredentials/ParticipantToken
     :cognitect.aws.connect.ParticipantTokenCredentials/Expiry]))

(s/def
  :cognitect.aws.connect/SearchHoursOfOperationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchHoursOfOperationsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchHoursOfOperationsRequest/NextToken
     :cognitect.aws.connect.SearchHoursOfOperationsRequest/SearchFilter
     :cognitect.aws.connect.SearchHoursOfOperationsRequest/SearchCriteria
     :cognitect.aws.connect.SearchHoursOfOperationsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/ViewType
  (s/spec string? :gen #(s/gen #{"CUSTOMER_MANAGED" "AWS_MANAGED"})))

(s/def
  :cognitect.aws.connect/ContactFlowModuleSearchFilter
  (s/keys :opt-un [:cognitect.aws.connect.ContactFlowModuleSearchFilter/TagFilter]))

(s/def
  :cognitect.aws.connect/EmailReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EmailReference/Value :cognitect.aws.connect.EmailReference/Name]))

(s/def
  :cognitect.aws.connect/ListInstanceStorageConfigsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListInstanceStorageConfigsResponse/StorageConfigs
     :cognitect.aws.connect.ListInstanceStorageConfigsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/AttributeName
  (s/spec
    (s/and string? #(<= 1 (count %) 32767))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 32767) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListAnalyticsDataAssociationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListAnalyticsDataAssociationsResponse/NextToken
     :cognitect.aws.connect.ListAnalyticsDataAssociationsResponse/Results]))

(s/def
  :cognitect.aws.connect/Application
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Application/ApplicationPermissions
     :cognitect.aws.connect.Application/Namespace]))

(s/def
  :cognitect.aws.connect/DescribePredefinedAttributeRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribePredefinedAttributeRequest/InstanceId
     :cognitect.aws.connect.DescribePredefinedAttributeRequest/Name]))

(s/def
  :cognitect.aws.connect/Name
  (s/spec
    (s/and string? #(<= 0 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/UpdateRoutingProfileConcurrencyRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateRoutingProfileConcurrencyRequest/InstanceId
     :cognitect.aws.connect.UpdateRoutingProfileConcurrencyRequest/RoutingProfileId
     :cognitect.aws.connect.UpdateRoutingProfileConcurrencyRequest/MediaConcurrencies]))

(s/def
  :cognitect.aws.connect/InvisibleTaskTemplateFields
  (s/coll-of :cognitect.aws.connect/InvisibleFieldInfo))

(s/def
  :cognitect.aws.connect/SearchPromptsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchPromptsResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchPromptsResponse/NextToken
     :cognitect.aws.connect.SearchPromptsResponse/Prompts]))

(s/def
  :cognitect.aws.connect/ListContactFlowVersionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListContactFlowVersionsRequest/InstanceId
     :cognitect.aws.connect.ListContactFlowVersionsRequest/ContactFlowId]
    :opt-un
    [:cognitect.aws.connect.ListContactFlowVersionsRequest/NextToken
     :cognitect.aws.connect.ListContactFlowVersionsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/BucketName
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListQueuesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListQueuesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListQueuesRequest/NextToken
     :cognitect.aws.connect.ListQueuesRequest/MaxResults
     :cognitect.aws.connect.ListQueuesRequest/QueueTypes]))

(s/def
  :cognitect.aws.connect/RecordingLocation
  (s/spec
    (s/and string? #(<= 0 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/AssociateLexBotRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateLexBotRequest/InstanceId
     :cognitect.aws.connect.AssociateLexBotRequest/LexBot]
    :opt-un
    [:cognitect.aws.connect.AssociateLexBotRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/EvaluationFormVersionSummaryList
  (s/coll-of :cognitect.aws.connect/EvaluationFormVersionSummary))

(s/def
  :cognitect.aws.connect/MaxResults
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.connect/UpdateHoursOfOperationOverrideRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/InstanceId
     :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/HoursOfOperationId
     :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/HoursOfOperationOverrideId]
    :opt-un
    [:cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/Config
     :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/Description
     :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/EffectiveFrom
     :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/EffectiveTill
     :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/Name]))

(s/def :cognitect.aws.connect/Steps (s/coll-of :cognitect.aws.connect/Step))

(s/def
  :cognitect.aws.connect/ContactFlowState
  (s/spec string? :gen #(s/gen #{"ARCHIVED" "ACTIVE"})))

(s/def
  :cognitect.aws.connect/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UntagResourceRequest/resourceArn
     :cognitect.aws.connect.UntagResourceRequest/tagKeys]))

(s/def
  :cognitect.aws.connect/TagKey
  (s/spec
    #(re-matches (re-pattern "^(?!aws:)[\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/DescribePredefinedAttributeResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribePredefinedAttributeResponse/PredefinedAttribute]))

(s/def
  :cognitect.aws.connect/InboundSubject
  (s/spec
    (s/and string? #(<= 0 (count %) 998))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 998) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/PropertyValidationException
  (s/keys
    :req-un
    [:cognitect.aws.connect.PropertyValidationException/Message]
    :opt-un
    [:cognitect.aws.connect.PropertyValidationException/PropertyList]))

(s/def :cognitect.aws.connect/UntagContactResponse (s/keys))

(s/def
  :cognitect.aws.connect/GetFederationTokenRequest
  (s/keys :req-un [:cognitect.aws.connect.GetFederationTokenRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/ListAgentStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListAgentStatusRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListAgentStatusRequest/AgentStatusTypes
     :cognitect.aws.connect.ListAgentStatusRequest/NextToken
     :cognitect.aws.connect.ListAgentStatusRequest/MaxResults]))

(s/def :cognitect.aws.connect/ViewStatus (s/spec string? :gen #(s/gen #{"PUBLISHED" "SAVED"})))

(s/def
  :cognitect.aws.connect/Hours24Format
  (s/spec (s/and int? #(<= 0 % 23)) :gen #(gen/choose 0 23)))

(s/def
  :cognitect.aws.connect/UpdateQuickConnectNameRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateQuickConnectNameRequest/InstanceId
     :cognitect.aws.connect.UpdateQuickConnectNameRequest/QuickConnectId]
    :opt-un
    [:cognitect.aws.connect.UpdateQuickConnectNameRequest/Description
     :cognitect.aws.connect.UpdateQuickConnectNameRequest/Name]))

(s/def
  :cognitect.aws.connect/ListInstanceAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListInstanceAttributesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListInstanceAttributesRequest/NextToken
     :cognitect.aws.connect.ListInstanceAttributesRequest/MaxResults]))

(s/def :cognitect.aws.connect/EmailRecipientsList (s/coll-of :cognitect.aws.connect/EmailRecipient))

(s/def :cognitect.aws.connect/StopContactRecordingResponse (s/keys))

(s/def
  :cognitect.aws.connect/CreatePushNotificationRegistrationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreatePushNotificationRegistrationRequest/InstanceId
     :cognitect.aws.connect.CreatePushNotificationRegistrationRequest/PinpointAppArn
     :cognitect.aws.connect.CreatePushNotificationRegistrationRequest/DeviceToken
     :cognitect.aws.connect.CreatePushNotificationRegistrationRequest/DeviceType
     :cognitect.aws.connect.CreatePushNotificationRegistrationRequest/ContactConfiguration]
    :opt-un
    [:cognitect.aws.connect.CreatePushNotificationRegistrationRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/ContactFlowType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"OUTBOUND_WHISPER"
        "CONTACT_FLOW"
        "QUEUE_TRANSFER"
        "AGENT_TRANSFER"
        "CUSTOMER_HOLD"
        "CAMPAIGN"
        "CUSTOMER_QUEUE"
        "AGENT_HOLD"
        "CUSTOMER_WHISPER"
        "AGENT_WHISPER"})))

(s/def :cognitect.aws.connect/LexBotsList (s/coll-of :cognitect.aws.connect/LexBot))

(s/def
  :cognitect.aws.connect/NotificationRecipientType
  (s/keys
    :opt-un
    [:cognitect.aws.connect.NotificationRecipientType/UserIds
     :cognitect.aws.connect.NotificationRecipientType/UserTags]))

(s/def
  :cognitect.aws.connect/PredefinedAttributeName
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/PhoneNumberDescription
  (s/spec #(re-matches (re-pattern "^[\\W\\S_]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisIssueDetected
  (s/keys :req-un [:cognitect.aws.connect.RealTimeContactAnalysisIssueDetected/TranscriptItems]))

(s/def
  :cognitect.aws.connect/ViewAction
  (s/spec
    #(re-matches
      (re-pattern "^([\\p{L}\\p{N}_.:\\/=+\\-@()']+[\\p{L}\\p{Z}\\p{N}_.:\\/=+\\-@()']*)$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.connect/RoutingCriteriaStepStatus
  (s/spec string? :gen #(s/gen #{"EXPIRED" "INACTIVE" "ACTIVE" "JOINED"})))

(s/def
  :cognitect.aws.connect/SortableFieldName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CHANNEL"
        "INITIATION_TIMESTAMP"
        "DISCONNECT_TIMESTAMP"
        "SCHEDULED_TIMESTAMP"
        "CONNECTED_TO_AGENT_TIMESTAMP"
        "INITIATION_METHOD"})))

(s/def
  :cognitect.aws.connect/UserNotFoundException
  (s/keys :opt-un [:cognitect.aws.connect.UserNotFoundException/Message]))

(s/def
  :cognitect.aws.connect/InstanceStatusReason
  (s/keys :opt-un [:cognitect.aws.connect.InstanceStatusReason/Message]))

(s/def
  :cognitect.aws.connect/EmailAddressDisplayName
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/GetContactAttributesResponse
  (s/keys :opt-un [:cognitect.aws.connect.GetContactAttributesResponse/Attributes]))

(s/def
  :cognitect.aws.connect/MetricInterval
  (s/keys
    :opt-un
    [:cognitect.aws.connect.MetricInterval/EndTime
     :cognitect.aws.connect.MetricInterval/StartTime
     :cognitect.aws.connect.MetricInterval/Interval]))

(s/def
  :cognitect.aws.connect/DescribeTrafficDistributionGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.DescribeTrafficDistributionGroupResponse/TrafficDistributionGroup]))

(s/def
  :cognitect.aws.connect/Concurrency
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.connect/ThresholdV2
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ThresholdV2/ThresholdValue
     :cognitect.aws.connect.ThresholdV2/Comparison]))

(s/def
  :cognitect.aws.connect/PreSignedAttachmentUrl
  (s/spec
    (s/and string? #(<= 1 (count %) 2000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/UpdateViewMetadataResponse (s/keys))

(s/def
  :cognitect.aws.connect/TagCondition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.TagCondition/TagKey :cognitect.aws.connect.TagCondition/TagValue]))

(s/def
  :cognitect.aws.connect/StartAttachedFileUploadRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartAttachedFileUploadRequest/InstanceId
     :cognitect.aws.connect.StartAttachedFileUploadRequest/FileName
     :cognitect.aws.connect.StartAttachedFileUploadRequest/FileSizeInBytes
     :cognitect.aws.connect.StartAttachedFileUploadRequest/FileUseCaseType
     :cognitect.aws.connect.StartAttachedFileUploadRequest/AssociatedResourceArn]
    :opt-un
    [:cognitect.aws.connect.StartAttachedFileUploadRequest/UrlExpiryInSeconds
     :cognitect.aws.connect.StartAttachedFileUploadRequest/Tags
     :cognitect.aws.connect.StartAttachedFileUploadRequest/CreatedBy
     :cognitect.aws.connect.StartAttachedFileUploadRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/DescribeViewResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeViewResponse/View]))

(s/def
  :cognitect.aws.connect/ContactSearchSummaryAgentInfo
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactSearchSummaryAgentInfo/ConnectedToAgentTimestamp
     :cognitect.aws.connect.ContactSearchSummaryAgentInfo/Id]))

(s/def
  :cognitect.aws.connect/Duration
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def :cognitect.aws.connect/LexV2Bot (s/keys :opt-un [:cognitect.aws.connect.LexV2Bot/AliasArn]))

(s/def
  :cognitect.aws.connect/ChatContentType
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/StartWebRTCContactResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.StartWebRTCContactResponse/ParticipantToken
     :cognitect.aws.connect.StartWebRTCContactResponse/ParticipantId
     :cognitect.aws.connect.StartWebRTCContactResponse/ContactId
     :cognitect.aws.connect.StartWebRTCContactResponse/ConnectionData]))

(s/def
  :cognitect.aws.connect/EvaluationAnswerInput
  (s/keys :opt-un [:cognitect.aws.connect.EvaluationAnswerInput/Value]))

(s/def
  :cognitect.aws.connect/EmailAddressSearchConditionList
  (s/coll-of :cognitect.aws.connect/EmailAddressSearchCriteria))

(s/def
  :cognitect.aws.connect/Description
  (s/spec
    (s/and string? #(<= 0 (count %) 4096))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4096) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ControlPlaneTagFilter
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ControlPlaneTagFilter/TagCondition
     :cognitect.aws.connect.ControlPlaneTagFilter/OrConditions
     :cognitect.aws.connect.ControlPlaneTagFilter/AndConditions]))

(s/def
  :cognitect.aws.connect/CreateAgentStatusResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateAgentStatusResponse/AgentStatusId
     :cognitect.aws.connect.CreateAgentStatusResponse/AgentStatusARN]))

(s/def
  :cognitect.aws.connect/NullableProficiencyLevel
  (s/spec
    (s/and double? #(<= 1.0 % 5.0))
    :gen
    #(gen/double* {:infinite? false, :NaN? false, :min 1.0, :max 5.0})))

(s/def
  :cognitect.aws.connect/UpdateInstanceAttributeRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateInstanceAttributeRequest/InstanceId
     :cognitect.aws.connect.UpdateInstanceAttributeRequest/AttributeType
     :cognitect.aws.connect.UpdateInstanceAttributeRequest/Value]
    :opt-un
    [:cognitect.aws.connect.UpdateInstanceAttributeRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/ListViewsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListViewsResponse/ViewsSummaryList
     :cognitect.aws.connect.ListViewsResponse/NextToken]))

(s/def :cognitect.aws.connect/AgentStatusId string?)

(s/def
  :cognitect.aws.connect/ListContactEvaluationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListContactEvaluationsRequest/InstanceId
     :cognitect.aws.connect.ListContactEvaluationsRequest/ContactId]
    :opt-un
    [:cognitect.aws.connect.ListContactEvaluationsRequest/NextToken]))

(s/def
  :cognitect.aws.connect/SearchUsersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchUsersResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchUsersResponse/NextToken
     :cognitect.aws.connect.SearchUsersResponse/Users]))

(s/def
  :cognitect.aws.connect/SecurityProfilesSearchSummaryList
  (s/coll-of :cognitect.aws.connect/SecurityProfileSearchSummary))

(s/def
  :cognitect.aws.connect/KinesisFirehoseConfig
  (s/keys :req-un [:cognitect.aws.connect.KinesisFirehoseConfig/FirehoseArn]))

(s/def
  :cognitect.aws.connect/AssociateFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateFlowRequest/InstanceId
     :cognitect.aws.connect.AssociateFlowRequest/ResourceId
     :cognitect.aws.connect.AssociateFlowRequest/FlowId
     :cognitect.aws.connect.AssociateFlowRequest/ResourceType]))

(s/def
  :cognitect.aws.connect/PhoneNumberPrefix
  (s/spec #(re-matches (re-pattern "\\\\+?[0-9]{1,11}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/SearchTextList
  (s/coll-of :cognitect.aws.connect/SearchText :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.connect/IntervalDetails
  (s/keys
    :opt-un
    [:cognitect.aws.connect.IntervalDetails/TimeZone
     :cognitect.aws.connect.IntervalDetails/IntervalPeriod]))

(s/def
  :cognitect.aws.connect/DisassociateApprovedOriginRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateApprovedOriginRequest/InstanceId
     :cognitect.aws.connect.DisassociateApprovedOriginRequest/Origin]
    :opt-un
    [:cognitect.aws.connect.DisassociateApprovedOriginRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/DisassociateFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateFlowRequest/InstanceId
     :cognitect.aws.connect.DisassociateFlowRequest/ResourceId
     :cognitect.aws.connect.DisassociateFlowRequest/ResourceType]))

(s/def :cognitect.aws.connect/CompleteAttachedFileUploadResponse (s/keys))

(s/def
  :cognitect.aws.connect/OutboundRequestId
  (s/spec
    (s/and string? #(<= 36 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 36 36) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ReferenceSummaryList
  (s/coll-of :cognitect.aws.connect/ReferenceSummary))

(s/def
  :cognitect.aws.connect/RequiredFieldInfo
  (s/keys :opt-un [:cognitect.aws.connect.RequiredFieldInfo/Id]))

(s/def
  :cognitect.aws.connect/CreateContactFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateContactFlowRequest/InstanceId
     :cognitect.aws.connect.CreateContactFlowRequest/Name
     :cognitect.aws.connect.CreateContactFlowRequest/Type
     :cognitect.aws.connect.CreateContactFlowRequest/Content]
    :opt-un
    [:cognitect.aws.connect.CreateContactFlowRequest/Tags
     :cognitect.aws.connect.CreateContactFlowRequest/Status
     :cognitect.aws.connect.CreateContactFlowRequest/Description]))

(s/def
  :cognitect.aws.connect/ClientToken
  (s/spec
    (s/and string? #(>= 500 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/Transcript
  (s/keys
    :req-un
    [:cognitect.aws.connect.Transcript/Criteria]
    :opt-un
    [:cognitect.aws.connect.Transcript/MatchType]))

(s/def
  :cognitect.aws.connect/ListApprovedOriginsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListApprovedOriginsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListApprovedOriginsRequest/NextToken
     :cognitect.aws.connect.ListApprovedOriginsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/QuickConnectSearchConditionList
  (s/coll-of :cognitect.aws.connect/QuickConnectSearchCriteria))

(s/def :cognitect.aws.connect/UpdateContactResponse (s/keys))

(s/def :cognitect.aws.connect/DisconnectReasonCode string?)

(s/def
  :cognitect.aws.connect/ListLexBotsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListLexBotsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListLexBotsRequest/NextToken
     :cognitect.aws.connect.ListLexBotsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/EvaluationFormQuestionType
  (s/spec string? :gen #(s/gen #{"SINGLESELECT" "TEXT" "NUMERIC"})))

(s/def
  :cognitect.aws.connect/QualityMetrics
  (s/keys
    :opt-un
    [:cognitect.aws.connect.QualityMetrics/Customer :cognitect.aws.connect.QualityMetrics/Agent]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptItemWithContent
  (s/keys
    :req-un
    [:cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemWithContent/Id]
    :opt-un
    [:cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemWithContent/CharacterOffsets
     :cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemWithContent/Content]))

(s/def :cognitect.aws.connect/Timestamp inst?)

(s/def
  :cognitect.aws.connect/DescribeInstanceStorageConfigResponse
  (s/keys :opt-un [:cognitect.aws.connect.DescribeInstanceStorageConfigResponse/StorageConfig]))

(s/def
  :cognitect.aws.connect/FlowContentSha256
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9]{64}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/MaxResult1000
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.connect/BatchDisassociateAnalyticsDataSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.BatchDisassociateAnalyticsDataSetResponse/Deleted
     :cognitect.aws.connect.BatchDisassociateAnalyticsDataSetResponse/Errors]))

(s/def
  :cognitect.aws.connect/MaxResult200
  (s/spec (s/and int? #(<= 1 % 200)) :gen #(gen/choose 1 200)))

(s/def
  :cognitect.aws.connect/ListPhoneNumbersSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListPhoneNumbersSummary/InstanceId
     :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumberDescription
     :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumberCountryCode
     :cognitect.aws.connect.ListPhoneNumbersSummary/TargetArn
     :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumberArn
     :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumberType
     :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumberId
     :cognitect.aws.connect.ListPhoneNumbersSummary/SourcePhoneNumberArn
     :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumber]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisTimeData
  (s/keys :opt-un [:cognitect.aws.connect.RealTimeContactAnalysisTimeData/AbsoluteTime]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisOutputType
  (s/spec string? :gen #(s/gen #{"Raw" "Redacted"})))

(s/def
  :cognitect.aws.connect/ContactMetricResult
  (s/keys
    :req-un
    [:cognitect.aws.connect.ContactMetricResult/Name
     :cognitect.aws.connect.ContactMetricResult/Value]))

(s/def
  :cognitect.aws.connect/ListFlowAssociationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListFlowAssociationsResponse/NextToken
     :cognitect.aws.connect.ListFlowAssociationsResponse/FlowAssociationSummaryList]))

(s/def
  :cognitect.aws.connect/UpdatePredefinedAttributeRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdatePredefinedAttributeRequest/InstanceId
     :cognitect.aws.connect.UpdatePredefinedAttributeRequest/Name]
    :opt-un
    [:cognitect.aws.connect.UpdatePredefinedAttributeRequest/Values]))

(s/def :cognitect.aws.connect/RecordingDeletionReason string?)

(s/def
  :cognitect.aws.connect/RoutingProfileName
  (s/spec
    (s/and string? #(<= 1 (count %) 127))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 127) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ContactStates
  (s/coll-of :cognitect.aws.connect/ContactState :max-count 9))

(s/def
  :cognitect.aws.connect/CompleteAttachedFileUploadRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CompleteAttachedFileUploadRequest/InstanceId
     :cognitect.aws.connect.CompleteAttachedFileUploadRequest/FileId
     :cognitect.aws.connect.CompleteAttachedFileUploadRequest/AssociatedResourceArn]))

(s/def :cognitect.aws.connect/DisassociateTrafficDistributionGroupUserResponse (s/keys))

(s/def
  :cognitect.aws.connect/RecordingInfo
  (s/keys
    :opt-un
    [:cognitect.aws.connect.RecordingInfo/DeletionReason
     :cognitect.aws.connect.RecordingInfo/Location
     :cognitect.aws.connect.RecordingInfo/Status
     :cognitect.aws.connect.RecordingInfo/StopTimestamp
     :cognitect.aws.connect.RecordingInfo/ParticipantType
     :cognitect.aws.connect.RecordingInfo/StartTimestamp
     :cognitect.aws.connect.RecordingInfo/MediaStreamType
     :cognitect.aws.connect.RecordingInfo/StorageType
     :cognitect.aws.connect.RecordingInfo/FragmentStopNumber
     :cognitect.aws.connect.RecordingInfo/FragmentStartNumber]))

(s/def
  :cognitect.aws.connect/GroupingsV2
  (s/coll-of :cognitect.aws.connect/GroupingV2 :max-count 4))

(s/def
  :cognitect.aws.connect/FlowAssociationSummaryList
  (s/coll-of :cognitect.aws.connect/FlowAssociationSummary))

(s/def :cognitect.aws.connect/PromptSummaryList (s/coll-of :cognitect.aws.connect/PromptSummary))

(s/def
  :cognitect.aws.connect/ContactFlowModuleStatus
  (s/spec string? :gen #(s/gen #{"PUBLISHED" "SAVED"})))

(s/def
  :cognitect.aws.connect/ContactEvaluation
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactEvaluation/FormId
     :cognitect.aws.connect.ContactEvaluation/EndTimestamp
     :cognitect.aws.connect.ContactEvaluation/EvaluationArn
     :cognitect.aws.connect.ContactEvaluation/DeleteTimestamp
     :cognitect.aws.connect.ContactEvaluation/Status
     :cognitect.aws.connect.ContactEvaluation/StartTimestamp
     :cognitect.aws.connect.ContactEvaluation/ExportLocation]))

(s/def
  :cognitect.aws.connect/AvailableNumbersList
  (s/coll-of :cognitect.aws.connect/AvailableNumberSummary))

(s/def
  :cognitect.aws.connect/OperatingSystem
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DescribePromptRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribePromptRequest/InstanceId
     :cognitect.aws.connect.DescribePromptRequest/PromptId]))

(s/def
  :cognitect.aws.connect/DataSetId
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListUseCasesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListUseCasesRequest/InstanceId
     :cognitect.aws.connect.ListUseCasesRequest/IntegrationAssociationId]
    :opt-un
    [:cognitect.aws.connect.ListUseCasesRequest/NextToken
     :cognitect.aws.connect.ListUseCasesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/SearchAgentStatusesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchAgentStatusesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchAgentStatusesRequest/NextToken
     :cognitect.aws.connect.SearchAgentStatusesRequest/SearchFilter
     :cognitect.aws.connect.SearchAgentStatusesRequest/SearchCriteria
     :cognitect.aws.connect.SearchAgentStatusesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/BatchDisassociateAnalyticsDataSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.BatchDisassociateAnalyticsDataSetRequest/InstanceId
     :cognitect.aws.connect.BatchDisassociateAnalyticsDataSetRequest/DataSetIds]
    :opt-un
    [:cognitect.aws.connect.BatchDisassociateAnalyticsDataSetRequest/TargetAccountId]))

(s/def
  :cognitect.aws.connect/TelephonyConfig
  (s/keys :req-un [:cognitect.aws.connect.TelephonyConfig/Distributions]))

(s/def
  :cognitect.aws.connect/PredefinedAttributeSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.PredefinedAttributeSummary/LastModifiedRegion
     :cognitect.aws.connect.PredefinedAttributeSummary/LastModifiedTime
     :cognitect.aws.connect.PredefinedAttributeSummary/Name]))

(s/def
  :cognitect.aws.connect/MeetingFeaturesConfiguration
  (s/keys :opt-un [:cognitect.aws.connect.MeetingFeaturesConfiguration/Audio]))

(s/def
  :cognitect.aws.connect/AttributeCondition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AttributeCondition/ComparisonOperator
     :cognitect.aws.connect.AttributeCondition/ProficiencyLevel
     :cognitect.aws.connect.AttributeCondition/Range
     :cognitect.aws.connect.AttributeCondition/Value
     :cognitect.aws.connect.AttributeCondition/Name
     :cognitect.aws.connect.AttributeCondition/MatchCriteria]))

(s/def
  :cognitect.aws.connect/EmailAddressMetadata
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EmailAddressMetadata/EmailAddressId
     :cognitect.aws.connect.EmailAddressMetadata/DisplayName
     :cognitect.aws.connect.EmailAddressMetadata/Description
     :cognitect.aws.connect.EmailAddressMetadata/EmailAddressArn
     :cognitect.aws.connect.EmailAddressMetadata/EmailAddress]))

(s/def
  :cognitect.aws.connect/ContentType
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListUsersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListUsersResponse/UserSummaryList
     :cognitect.aws.connect.ListUsersResponse/NextToken]))

(s/def :cognitect.aws.connect/FailedRequestList (s/coll-of :cognitect.aws.connect/FailedRequest))

(s/def
  :cognitect.aws.connect/SendNotificationActionDefinition
  (s/keys
    :req-un
    [:cognitect.aws.connect.SendNotificationActionDefinition/DeliveryMethod
     :cognitect.aws.connect.SendNotificationActionDefinition/Content
     :cognitect.aws.connect.SendNotificationActionDefinition/ContentType
     :cognitect.aws.connect.SendNotificationActionDefinition/Recipient]
    :opt-un
    [:cognitect.aws.connect.SendNotificationActionDefinition/Subject]))

(s/def
  :cognitect.aws.connect/SuccessfulRequestList
  (s/coll-of :cognitect.aws.connect/SuccessfulRequest))

(s/def
  :cognitect.aws.connect/EvaluationFormQuestionAnswerScore
  (s/spec (s/and int? #(<= 0 % 10)) :gen #(gen/choose 0 10)))

(s/def
  :cognitect.aws.connect/MetricV2
  (s/keys
    :opt-un
    [:cognitect.aws.connect.MetricV2/MetricFilters
     :cognitect.aws.connect.MetricV2/Threshold
     :cognitect.aws.connect.MetricV2/Name]))

(s/def
  :cognitect.aws.connect/ApplicationPermissions
  (s/coll-of :cognitect.aws.connect/Permission :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.connect/UserTagMap
  (s/map-of :cognitect.aws.connect/String :cognitect.aws.connect/String))

(s/def
  :cognitect.aws.connect/EmailHeaderType
  (s/spec
    string?
    :gen
    #(s/gen #{"X_SES_SPAM_VERDICT" "X_SES_VIRUS_VERDICT" "MESSAGE_ID" "IN_REPLY_TO" "REFERENCES"})))

(s/def
  :cognitect.aws.connect/UserProficiencyDisassociateList
  (s/coll-of :cognitect.aws.connect/UserProficiencyDisassociate))

(s/def
  :cognitect.aws.connect/UpdateRuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateRuleRequest/RuleId
     :cognitect.aws.connect.UpdateRuleRequest/InstanceId
     :cognitect.aws.connect.UpdateRuleRequest/Name
     :cognitect.aws.connect.UpdateRuleRequest/Function
     :cognitect.aws.connect.UpdateRuleRequest/Actions
     :cognitect.aws.connect.UpdateRuleRequest/PublishStatus]))

(s/def
  :cognitect.aws.connect/EventSourceName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"OnZendeskTicketStatusUpdate"
        "OnRealTimeCallAnalysisAvailable"
        "OnMetricDataUpdate"
        "OnCaseCreate"
        "OnSlaBreach"
        "OnZendeskTicketCreate"
        "OnCaseUpdate"
        "OnPostChatAnalysisAvailable"
        "OnSalesforceCaseCreate"
        "OnPostCallAnalysisAvailable"
        "OnRealTimeChatAnalysisAvailable"
        "OnContactEvaluationSubmit"})))

(s/def
  :cognitect.aws.connect/QueueName
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/MediaConcurrency
  (s/keys
    :req-un
    [:cognitect.aws.connect.MediaConcurrency/Channel
     :cognitect.aws.connect.MediaConcurrency/Concurrency]
    :opt-un
    [:cognitect.aws.connect.MediaConcurrency/CrossChannelBehavior]))

(s/def
  :cognitect.aws.connect/HoursOfOperationDays
  (s/spec
    string?
    :gen
    #(s/gen #{"WEDNESDAY" "SUNDAY" "THURSDAY" "TUESDAY" "FRIDAY" "SATURDAY" "MONDAY"})))

(s/def
  :cognitect.aws.connect/NumericQuestionPropertyValueAutomation
  (s/keys :req-un [:cognitect.aws.connect.NumericQuestionPropertyValueAutomation/Label]))

(s/def
  :cognitect.aws.connect/Attributes
  (s/map-of :cognitect.aws.connect/AttributeName :cognitect.aws.connect/AttributeValue))

(s/def
  :cognitect.aws.connect/PhoneNumberSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.PhoneNumberSummary/PhoneNumberCountryCode
     :cognitect.aws.connect.PhoneNumberSummary/PhoneNumberType
     :cognitect.aws.connect.PhoneNumberSummary/Arn
     :cognitect.aws.connect.PhoneNumberSummary/Id
     :cognitect.aws.connect.PhoneNumberSummary/PhoneNumber]))

(s/def
  :cognitect.aws.connect/IntegerCount
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/AssociateAnalyticsDataSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AssociateAnalyticsDataSetResponse/ResourceShareId
     :cognitect.aws.connect.AssociateAnalyticsDataSetResponse/DataSetId
     :cognitect.aws.connect.AssociateAnalyticsDataSetResponse/ResourceShareArn
     :cognitect.aws.connect.AssociateAnalyticsDataSetResponse/TargetAccountId]))

(s/def
  :cognitect.aws.connect/SearchContactsResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchContactsResponse/Contacts]
    :opt-un
    [:cognitect.aws.connect.SearchContactsResponse/NextToken
     :cognitect.aws.connect.SearchContactsResponse/TotalCount]))

(s/def
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionOptionList
  (s/coll-of
    :cognitect.aws.connect/EvaluationFormSingleSelectQuestionOption
    :min-count
    1
    :max-count
    256))

(s/def
  :cognitect.aws.connect/ParticipantTimerConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.connect.ParticipantTimerConfiguration/ParticipantRole
     :cognitect.aws.connect.ParticipantTimerConfiguration/TimerType
     :cognitect.aws.connect.ParticipantTimerConfiguration/TimerValue]))

(s/def
  :cognitect.aws.connect/DescribeUserHierarchyStructureRequest
  (s/keys :req-un [:cognitect.aws.connect.DescribeUserHierarchyStructureRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/ContactTagValue
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/Condition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Condition/StringCondition
     :cognitect.aws.connect.Condition/NumberCondition]))

(s/def
  :cognitect.aws.connect/ListContactReferencesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListContactReferencesResponse/NextToken
     :cognitect.aws.connect.ListContactReferencesResponse/ReferenceSummaryList]))

(s/def
  :cognitect.aws.connect/ListUsersRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListUsersRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListUsersRequest/NextToken
     :cognitect.aws.connect.ListUsersRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/CreateVocabularyResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateVocabularyResponse/VocabularyArn
     :cognitect.aws.connect.CreateVocabularyResponse/VocabularyId
     :cognitect.aws.connect.CreateVocabularyResponse/State]))

(s/def
  :cognitect.aws.connect/SecurityProfilePermission
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DescribeTrafficDistributionGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeTrafficDistributionGroupRequest/TrafficDistributionGroupId]))

(s/def
  :cognitect.aws.connect/ContactSearchSummarySegmentAttributes
  (s/map-of
    :cognitect.aws.connect/SegmentAttributeName
    :cognitect.aws.connect/ContactSearchSummarySegmentAttributeValue))

(s/def :cognitect.aws.connect/AssociateTrafficDistributionGroupUserResponse (s/keys))

(s/def
  :cognitect.aws.connect/ParticipantType
  (s/spec string? :gen #(s/gen #{"AGENT" "THIRDPARTY" "MANAGER" "ALL" "CUSTOMER"})))

(s/def
  :cognitect.aws.connect/CreateViewVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateViewVersionRequest/InstanceId
     :cognitect.aws.connect.CreateViewVersionRequest/ViewId]
    :opt-un
    [:cognitect.aws.connect.CreateViewVersionRequest/ViewContentSha256
     :cognitect.aws.connect.CreateViewVersionRequest/VersionDescription]))

(s/def
  :cognitect.aws.connect/Filters
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Filters/RoutingStepExpressions
     :cognitect.aws.connect.Filters/Queues
     :cognitect.aws.connect.Filters/RoutingProfiles
     :cognitect.aws.connect.Filters/Channels]))

(s/def
  :cognitect.aws.connect/ContactSearchSummaryQueueInfo
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactSearchSummaryQueueInfo/Id
     :cognitect.aws.connect.ContactSearchSummaryQueueInfo/EnqueueTimestamp]))

(s/def
  :cognitect.aws.connect/CurrentMetricSortCriteriaMaxOne
  (s/coll-of :cognitect.aws.connect/CurrentMetricSortCriteria :min-count 0 :max-count 1))

(s/def
  :cognitect.aws.connect/EvaluationFormContent
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormContent/EvaluationFormVersion
     :cognitect.aws.connect.EvaluationFormContent/EvaluationFormId
     :cognitect.aws.connect.EvaluationFormContent/EvaluationFormArn
     :cognitect.aws.connect.EvaluationFormContent/Title
     :cognitect.aws.connect.EvaluationFormContent/Items]
    :opt-un
    [:cognitect.aws.connect.EvaluationFormContent/Description
     :cognitect.aws.connect.EvaluationFormContent/ScoringStrategy]))

(s/def
  :cognitect.aws.connect/ChatContent
  (s/spec
    (s/and string? #(<= 1 (count %) 16384))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 16384) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/Evaluation
  (s/keys
    :req-un
    [:cognitect.aws.connect.Evaluation/EvaluationId
     :cognitect.aws.connect.Evaluation/EvaluationArn
     :cognitect.aws.connect.Evaluation/Metadata
     :cognitect.aws.connect.Evaluation/Answers
     :cognitect.aws.connect.Evaluation/Notes
     :cognitect.aws.connect.Evaluation/Status
     :cognitect.aws.connect.Evaluation/CreatedTime
     :cognitect.aws.connect.Evaluation/LastModifiedTime]
    :opt-un
    [:cognitect.aws.connect.Evaluation/Tags :cognitect.aws.connect.Evaluation/Scores]))

(s/def
  :cognitect.aws.connect/SearchSecurityProfilesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchSecurityProfilesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchSecurityProfilesRequest/NextToken
     :cognitect.aws.connect.SearchSecurityProfilesRequest/SearchFilter
     :cognitect.aws.connect.SearchSecurityProfilesRequest/SearchCriteria
     :cognitect.aws.connect.SearchSecurityProfilesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/EvaluationNotesMap
  (s/map-of :cognitect.aws.connect/ResourceId :cognitect.aws.connect/EvaluationNote :max-count 100))

(s/def :cognitect.aws.connect/StartScreenSharingResponse (s/keys))

(s/def :cognitect.aws.connect/Count (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/SegmentAttributeValue
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SegmentAttributeValue/ValueString
     :cognitect.aws.connect.SegmentAttributeValue/ValueInteger
     :cognitect.aws.connect.SegmentAttributeValue/ValueMap]))

(s/def
  :cognitect.aws.connect/FileUseCaseType
  (s/spec string? :gen #(s/gen #{"EMAIL_MESSAGE" "ATTACHMENT"})))

(s/def
  :cognitect.aws.connect/AttachedFileInvalidRequestExceptionReason
  (s/spec string? :gen #(s/gen #{"INVALID_FILE_NAME" "INVALID_FILE_SIZE" "INVALID_FILE_TYPE"})))

(s/def
  :cognitect.aws.connect/ContactFlowModuleSearchSummaryList
  (s/coll-of :cognitect.aws.connect/ContactFlowModule))

(s/def
  :cognitect.aws.connect/ListContactFlowModulesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListContactFlowModulesResponse/NextToken
     :cognitect.aws.connect.ListContactFlowModulesResponse/ContactFlowModulesSummaryList]))

(s/def
  :cognitect.aws.connect/HistoricalMetricResults
  (s/coll-of :cognitect.aws.connect/HistoricalMetricResult))

(s/def :cognitect.aws.connect/timestamp inst?)

(s/def
  :cognitect.aws.connect/CreateTaskTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateTaskTemplateRequest/InstanceId
     :cognitect.aws.connect.CreateTaskTemplateRequest/Name
     :cognitect.aws.connect.CreateTaskTemplateRequest/Fields]
    :opt-un
    [:cognitect.aws.connect.CreateTaskTemplateRequest/ContactFlowId
     :cognitect.aws.connect.CreateTaskTemplateRequest/Status
     :cognitect.aws.connect.CreateTaskTemplateRequest/SelfAssignFlowId
     :cognitect.aws.connect.CreateTaskTemplateRequest/Description
     :cognitect.aws.connect.CreateTaskTemplateRequest/Defaults
     :cognitect.aws.connect.CreateTaskTemplateRequest/ClientToken
     :cognitect.aws.connect.CreateTaskTemplateRequest/Constraints]))

(s/def
  :cognitect.aws.connect/QuickConnect
  (s/keys
    :opt-un
    [:cognitect.aws.connect.QuickConnect/Tags
     :cognitect.aws.connect.QuickConnect/QuickConnectId
     :cognitect.aws.connect.QuickConnect/QuickConnectARN
     :cognitect.aws.connect.QuickConnect/Description
     :cognitect.aws.connect.QuickConnect/LastModifiedRegion
     :cognitect.aws.connect.QuickConnect/LastModifiedTime
     :cognitect.aws.connect.QuickConnect/QuickConnectConfig
     :cognitect.aws.connect.QuickConnect/Name]))

(s/def
  :cognitect.aws.connect/ListSecurityKeysResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListSecurityKeysResponse/SecurityKeys
     :cognitect.aws.connect.ListSecurityKeysResponse/NextToken]))

(s/def
  :cognitect.aws.connect/AllowedCapabilities
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AllowedCapabilities/Customer
     :cognitect.aws.connect.AllowedCapabilities/Agent]))

(s/def
  :cognitect.aws.connect/ListContactFlowModulesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListContactFlowModulesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListContactFlowModulesRequest/ContactFlowModuleState
     :cognitect.aws.connect.ListContactFlowModulesRequest/NextToken
     :cognitect.aws.connect.ListContactFlowModulesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/EvaluationFormScoringStrategy
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormScoringStrategy/Mode
     :cognitect.aws.connect.EvaluationFormScoringStrategy/Status]))

(s/def
  :cognitect.aws.connect/ListTrafficDistributionGroupUsersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListTrafficDistributionGroupUsersResponse/TrafficDistributionGroupUserSummaryList
     :cognitect.aws.connect.ListTrafficDistributionGroupUsersResponse/NextToken]))

(s/def
  :cognitect.aws.connect/AdditionalEmailRecipients
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AdditionalEmailRecipients/ToList
     :cognitect.aws.connect.AdditionalEmailRecipients/CcList]))

(s/def
  :cognitect.aws.connect/TransferContactResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.TransferContactResponse/ContactArn
     :cognitect.aws.connect.TransferContactResponse/ContactId]))

(s/def
  :cognitect.aws.connect/CreateContactFlowVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateContactFlowVersionRequest/InstanceId
     :cognitect.aws.connect.CreateContactFlowVersionRequest/ContactFlowId]
    :opt-un
    [:cognitect.aws.connect.CreateContactFlowVersionRequest/Description
     :cognitect.aws.connect.CreateContactFlowVersionRequest/LastModifiedRegion
     :cognitect.aws.connect.CreateContactFlowVersionRequest/ContactFlowVersion
     :cognitect.aws.connect.CreateContactFlowVersionRequest/LastModifiedTime
     :cognitect.aws.connect.CreateContactFlowVersionRequest/FlowContentSha256]))

(s/def
  :cognitect.aws.connect/StartAttachedFileUploadResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.StartAttachedFileUploadResponse/UploadUrlMetadata
     :cognitect.aws.connect.StartAttachedFileUploadResponse/CreatedBy
     :cognitect.aws.connect.StartAttachedFileUploadResponse/FileStatus
     :cognitect.aws.connect.StartAttachedFileUploadResponse/FileArn
     :cognitect.aws.connect.StartAttachedFileUploadResponse/CreationTime
     :cognitect.aws.connect.StartAttachedFileUploadResponse/FileId]))

(s/def
  :cognitect.aws.connect/KeyId
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/PauseContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.PauseContactRequest/ContactId
     :cognitect.aws.connect.PauseContactRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.PauseContactRequest/ContactFlowId]))

(s/def
  :cognitect.aws.connect/EffectiveHoursOfOperations
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EffectiveHoursOfOperations/OperationalHours
     :cognitect.aws.connect.EffectiveHoursOfOperations/Date]))

(s/def
  :cognitect.aws.connect/MinutesLimit60
  (s/spec (s/and int? #(<= 0 % 59)) :gen #(gen/choose 0 59)))

(s/def
  :cognitect.aws.connect/CreateUserHierarchyGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateUserHierarchyGroupResponse/HierarchyGroupId
     :cognitect.aws.connect.CreateUserHierarchyGroupResponse/HierarchyGroupArn]))

(s/def
  :cognitect.aws.connect/FileName
  (s/spec #(re-matches (re-pattern "^\\P{C}*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisAttachment
  (s/keys
    :req-un
    [:cognitect.aws.connect.RealTimeContactAnalysisAttachment/AttachmentName
     :cognitect.aws.connect.RealTimeContactAnalysisAttachment/AttachmentId]
    :opt-un
    [:cognitect.aws.connect.RealTimeContactAnalysisAttachment/Status
     :cognitect.aws.connect.RealTimeContactAnalysisAttachment/ContentType]))

(s/def
  :cognitect.aws.connect/RegistrationId
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/CreateHoursOfOperationOverrideResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateHoursOfOperationOverrideResponse/HoursOfOperationOverrideId]))

(s/def
  :cognitect.aws.connect/PromptSearchConditionList
  (s/coll-of :cognitect.aws.connect/PromptSearchCriteria))

(s/def
  :cognitect.aws.connect/TimerEligibleParticipantRoles
  (s/spec string? :gen #(s/gen #{"AGENT" "CUSTOMER"})))

(s/def
  :cognitect.aws.connect/ListAgentStatusResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListAgentStatusResponse/NextToken
     :cognitect.aws.connect.ListAgentStatusResponse/AgentStatusSummaryList]))

(s/def
  :cognitect.aws.connect/AgentQualityMetrics
  (s/keys :opt-un [:cognitect.aws.connect.AgentQualityMetrics/Audio]))

(s/def
  :cognitect.aws.connect/DisassociateRoutingProfileQueuesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateRoutingProfileQueuesRequest/InstanceId
     :cognitect.aws.connect.DisassociateRoutingProfileQueuesRequest/RoutingProfileId
     :cognitect.aws.connect.DisassociateRoutingProfileQueuesRequest/QueueReferences]))

(s/def
  :cognitect.aws.connect/ListIntegrationAssociationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListIntegrationAssociationsResponse/IntegrationAssociationSummaryList
     :cognitect.aws.connect.ListIntegrationAssociationsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/ViewInputContent
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ViewInputContent/Actions
     :cognitect.aws.connect.ViewInputContent/Template]))

(s/def
  :cognitect.aws.connect/StartOutboundVoiceContactResponse
  (s/keys :opt-un [:cognitect.aws.connect.StartOutboundVoiceContactResponse/ContactId]))

(s/def
  :cognitect.aws.connect/Attribute
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Attribute/AttributeType :cognitect.aws.connect.Attribute/Value]))

(s/def
  :cognitect.aws.connect/FileIdList
  (s/coll-of :cognitect.aws.connect/FileId :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.connect/InstanceAttributeType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"OUTBOUND_CALLS"
        "MULTI_PARTY_CHAT_CONFERENCE"
        "EARLY_MEDIA"
        "USE_CUSTOM_TTS_VOICES"
        "HIGH_VOLUME_OUTBOUND"
        "MULTI_PARTY_CONFERENCE"
        "CONTACTFLOW_LOGS"
        "AUTO_RESOLVE_BEST_VOICES"
        "ENHANCED_CONTACT_MONITORING"
        "ENHANCED_CHAT_MONITORING"
        "CONTACT_LENS"
        "INBOUND_CALLS"})))

(s/def
  :cognitect.aws.connect/CreateRuleResponse
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateRuleResponse/RuleArn
     :cognitect.aws.connect.CreateRuleResponse/RuleId]))

(s/def
  :cognitect.aws.connect/InvalidContactFlowException
  (s/keys :opt-un [:cognitect.aws.connect.InvalidContactFlowException/problems]))

(s/def
  :cognitect.aws.connect/DeletePredefinedAttributeRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeletePredefinedAttributeRequest/InstanceId
     :cognitect.aws.connect.DeletePredefinedAttributeRequest/Name]))

(s/def
  :cognitect.aws.connect/UpdatePromptResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UpdatePromptResponse/PromptId
     :cognitect.aws.connect.UpdatePromptResponse/PromptARN]))

(s/def :cognitect.aws.connect/HierarchyLevelName string?)

(s/def
  :cognitect.aws.connect/SecurityProfileDescription
  (s/spec
    (s/and string? #(>= 250 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 250) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/UpdateContactFlowMetadataResponse (s/keys))

(s/def
  :cognitect.aws.connect/Double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionProperties
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormSingleSelectQuestionProperties/Options]
    :opt-un
    [:cognitect.aws.connect.EvaluationFormSingleSelectQuestionProperties/Automation
     :cognitect.aws.connect.EvaluationFormSingleSelectQuestionProperties/DisplayAs]))

(s/def
  :cognitect.aws.connect/SecurityProfileSummaryList
  (s/coll-of :cognitect.aws.connect/SecurityProfileSummary))

(s/def
  :cognitect.aws.connect/RoutingProfileQueueConfig
  (s/keys
    :req-un
    [:cognitect.aws.connect.RoutingProfileQueueConfig/QueueReference
     :cognitect.aws.connect.RoutingProfileQueueConfig/Priority
     :cognitect.aws.connect.RoutingProfileQueueConfig/Delay]))

(s/def :cognitect.aws.connect/IvrRecordingTrack (s/spec string? :gen #(s/gen #{"ALL"})))

(s/def
  :cognitect.aws.connect/SecurityProfileSearchSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SecurityProfileSearchSummary/Tags
     :cognitect.aws.connect.SecurityProfileSearchSummary/SecurityProfileName
     :cognitect.aws.connect.SecurityProfileSearchSummary/Description
     :cognitect.aws.connect.SecurityProfileSearchSummary/Arn
     :cognitect.aws.connect.SecurityProfileSearchSummary/Id
     :cognitect.aws.connect.SecurityProfileSearchSummary/OrganizationResourceId]))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisAttachments
  (s/coll-of :cognitect.aws.connect/RealTimeContactAnalysisAttachment :max-count 10))

(s/def
  :cognitect.aws.connect/ThresholdCollections
  (s/coll-of :cognitect.aws.connect/ThresholdV2 :max-count 1))

(s/def
  :cognitect.aws.connect/ReplicationStatusSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ReplicationStatusSummary/ReplicationStatus
     :cognitect.aws.connect.ReplicationStatusSummary/ReplicationStatusReason
     :cognitect.aws.connect.ReplicationStatusSummary/Region]))

(s/def
  :cognitect.aws.connect/UpdateParticipantAuthenticationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateParticipantAuthenticationRequest/State
     :cognitect.aws.connect.UpdateParticipantAuthenticationRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.UpdateParticipantAuthenticationRequest/ErrorDescription
     :cognitect.aws.connect.UpdateParticipantAuthenticationRequest/Error
     :cognitect.aws.connect.UpdateParticipantAuthenticationRequest/Code]))

(s/def
  :cognitect.aws.connect/SuspendContactRecordingRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SuspendContactRecordingRequest/InstanceId
     :cognitect.aws.connect.SuspendContactRecordingRequest/ContactId
     :cognitect.aws.connect.SuspendContactRecordingRequest/InitialContactId]
    :opt-un
    [:cognitect.aws.connect.SuspendContactRecordingRequest/ContactRecordingType]))

(s/def
  :cognitect.aws.connect/NumberReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.NumberReference/Value :cognitect.aws.connect.NumberReference/Name]))

(s/def
  :cognitect.aws.connect/HierarchyGroupSummaryReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HierarchyGroupSummaryReference/Arn
     :cognitect.aws.connect.HierarchyGroupSummaryReference/Id]))

(s/def
  :cognitect.aws.connect/ArtifactId
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/StopContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StopContactRequest/ContactId
     :cognitect.aws.connect.StopContactRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.StopContactRequest/DisconnectReason]))

(s/def
  :cognitect.aws.connect/DeleteInstanceRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteInstanceRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.DeleteInstanceRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/StateTransition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.StateTransition/StateStartTimestamp
     :cognitect.aws.connect.StateTransition/StateEndTimestamp
     :cognitect.aws.connect.StateTransition/State]))

(s/def
  :cognitect.aws.connect/HierarchyLevel
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HierarchyLevel/LastModifiedRegion
     :cognitect.aws.connect.HierarchyLevel/Arn
     :cognitect.aws.connect.HierarchyLevel/LastModifiedTime
     :cognitect.aws.connect.HierarchyLevel/Name
     :cognitect.aws.connect.HierarchyLevel/Id]))

(s/def
  :cognitect.aws.connect/ContactFlowModuleSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ContactFlowModuleSummary/Arn
     :cognitect.aws.connect.ContactFlowModuleSummary/State
     :cognitect.aws.connect.ContactFlowModuleSummary/Name
     :cognitect.aws.connect.ContactFlowModuleSummary/Id]))

(s/def
  :cognitect.aws.connect/InvalidRequestExceptionReason
  (s/keys
    :opt-un
    [:cognitect.aws.connect.InvalidRequestExceptionReason/AttachedFileInvalidRequestExceptionReason]))

(s/def :cognitect.aws.connect/HierarchyGroupId string?)

(s/def
  :cognitect.aws.connect/ListViewVersionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListViewVersionsRequest/InstanceId
     :cognitect.aws.connect.ListViewVersionsRequest/ViewId]
    :opt-un
    [:cognitect.aws.connect.ListViewVersionsRequest/NextToken
     :cognitect.aws.connect.ListViewVersionsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/InboundAdditionalRecipients
  (s/keys
    :opt-un
    [:cognitect.aws.connect.InboundAdditionalRecipients/ToAddresses
     :cognitect.aws.connect.InboundAdditionalRecipients/CcAddresses]))

(s/def
  :cognitect.aws.connect/WisdomInfo
  (s/keys :opt-un [:cognitect.aws.connect.WisdomInfo/SessionArn]))

(s/def
  :cognitect.aws.connect/MaximumResultReturnedException
  (s/keys :opt-un [:cognitect.aws.connect.MaximumResultReturnedException/Message]))

(s/def
  :cognitect.aws.connect/GetCurrentMetricDataRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetCurrentMetricDataRequest/InstanceId
     :cognitect.aws.connect.GetCurrentMetricDataRequest/Filters
     :cognitect.aws.connect.GetCurrentMetricDataRequest/CurrentMetrics]
    :opt-un
    [:cognitect.aws.connect.GetCurrentMetricDataRequest/NextToken
     :cognitect.aws.connect.GetCurrentMetricDataRequest/Groupings
     :cognitect.aws.connect.GetCurrentMetricDataRequest/MaxResults
     :cognitect.aws.connect.GetCurrentMetricDataRequest/SortCriteria]))

(s/def
  :cognitect.aws.connect/AttachedFile
  (s/keys
    :req-un
    [:cognitect.aws.connect.AttachedFile/CreationTime
     :cognitect.aws.connect.AttachedFile/FileArn
     :cognitect.aws.connect.AttachedFile/FileId
     :cognitect.aws.connect.AttachedFile/FileName
     :cognitect.aws.connect.AttachedFile/FileSizeInBytes
     :cognitect.aws.connect.AttachedFile/FileStatus]
    :opt-un
    [:cognitect.aws.connect.AttachedFile/Tags
     :cognitect.aws.connect.AttachedFile/CreatedBy
     :cognitect.aws.connect.AttachedFile/AssociatedResourceArn
     :cognitect.aws.connect.AttachedFile/FileUseCaseType]))

(s/def
  :cognitect.aws.connect/CurrentMetricSortCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CurrentMetricSortCriteria/SortOrder
     :cognitect.aws.connect.CurrentMetricSortCriteria/SortByMetric]))

(s/def
  :cognitect.aws.connect/QuickConnectType
  (s/spec string? :gen #(s/gen #{"USER" "QUEUE" "PHONE_NUMBER"})))

(s/def :cognitect.aws.connect/Channels (s/coll-of :cognitect.aws.connect/Channel :max-count 4))

(s/def
  :cognitect.aws.connect/HierarchyRestrictedResourceName
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/IpCidrList (s/coll-of :cognitect.aws.connect/IpCidr))

(s/def :cognitect.aws.connect/PauseContactResponse (s/keys))

(s/def
  :cognitect.aws.connect/ContactMetricInfo
  (s/keys :req-un [:cognitect.aws.connect.ContactMetricInfo/Name]))

(s/def
  :cognitect.aws.connect/UpdateParticipantRoleConfigChannelInfo
  (s/keys :opt-un [:cognitect.aws.connect.UpdateParticipantRoleConfigChannelInfo/Chat]))

(s/def
  :cognitect.aws.connect/EmailAddressId
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EvaluationFormNumericQuestionOptionList
  (s/coll-of :cognitect.aws.connect/EvaluationFormNumericQuestionOption :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.connect/ContactFlowTypes
  (s/coll-of :cognitect.aws.connect/ContactFlowType :max-count 10))

(s/def
  :cognitect.aws.connect/UpdateUserProficienciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateUserProficienciesRequest/InstanceId
     :cognitect.aws.connect.UpdateUserProficienciesRequest/UserId
     :cognitect.aws.connect.UpdateUserProficienciesRequest/UserProficiencies]))

(s/def
  :cognitect.aws.connect/ViewDescription
  (s/spec
    #(re-matches
      (re-pattern "^([\\p{L}\\p{N}_.:\\/=+\\-@,()']+[\\p{L}\\p{Z}\\p{N}_.:\\/=+\\-@,()']*)$")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.connect/RoutingProfileList (s/coll-of :cognitect.aws.connect/RoutingProfile))

(s/def
  :cognitect.aws.connect/DeleteUserHierarchyGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteUserHierarchyGroupRequest/HierarchyGroupId
     :cognitect.aws.connect.DeleteUserHierarchyGroupRequest/InstanceId]))

(s/def
  :cognitect.aws.connect/UpdateContactFlowModuleMetadataRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactFlowModuleMetadataRequest/InstanceId
     :cognitect.aws.connect.UpdateContactFlowModuleMetadataRequest/ContactFlowModuleId]
    :opt-un
    [:cognitect.aws.connect.UpdateContactFlowModuleMetadataRequest/Description
     :cognitect.aws.connect.UpdateContactFlowModuleMetadataRequest/State
     :cognitect.aws.connect.UpdateContactFlowModuleMetadataRequest/Name]))

(s/def
  :cognitect.aws.connect/TagSearchCondition
  (s/keys
    :opt-un
    [:cognitect.aws.connect.TagSearchCondition/tagKeyComparisonType
     :cognitect.aws.connect.TagSearchCondition/tagValueComparisonType
     :cognitect.aws.connect.TagSearchCondition/tagValue
     :cognitect.aws.connect.TagSearchCondition/tagKey]))

(s/def
  :cognitect.aws.connect/PropertyValidationExceptionPropertyList
  (s/coll-of :cognitect.aws.connect/PropertyValidationExceptionProperty))

(s/def
  :cognitect.aws.connect/SearchResourceTagsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchResourceTagsResponse/Tags
     :cognitect.aws.connect.SearchResourceTagsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/GetMetricDataV2Response
  (s/keys
    :opt-un
    [:cognitect.aws.connect.GetMetricDataV2Response/MetricResults
     :cognitect.aws.connect.GetMetricDataV2Response/NextToken]))

(s/def :cognitect.aws.connect/AttributesList (s/coll-of :cognitect.aws.connect/Attribute))

(s/def
  :cognitect.aws.connect/ActivateEvaluationFormRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ActivateEvaluationFormRequest/InstanceId
     :cognitect.aws.connect.ActivateEvaluationFormRequest/EvaluationFormId
     :cognitect.aws.connect.ActivateEvaluationFormRequest/EvaluationFormVersion]))

(s/def :cognitect.aws.connect/ExportLocation string?)

(s/def
  :cognitect.aws.connect/TrafficDistributionGroupUserSummary
  (s/keys :opt-un [:cognitect.aws.connect.TrafficDistributionGroupUserSummary/UserId]))

(s/def
  :cognitect.aws.connect/IntegrationAssociationId
  (s/spec
    (s/and string? #(<= 1 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 200) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.connect.ListTagsForResourceResponse/tags]))

(s/def :cognitect.aws.connect/DistributionList (s/coll-of :cognitect.aws.connect/Distribution))

(s/def :cognitect.aws.connect/NewChatCreated boolean?)

(s/def
  :cognitect.aws.connect/StartContactRecordingRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartContactRecordingRequest/InstanceId
     :cognitect.aws.connect.StartContactRecordingRequest/ContactId
     :cognitect.aws.connect.StartContactRecordingRequest/InitialContactId
     :cognitect.aws.connect.StartContactRecordingRequest/VoiceRecordingConfiguration]))

(s/def
  :cognitect.aws.connect/CreateEvaluationFormRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateEvaluationFormRequest/InstanceId
     :cognitect.aws.connect.CreateEvaluationFormRequest/Title
     :cognitect.aws.connect.CreateEvaluationFormRequest/Items]
    :opt-un
    [:cognitect.aws.connect.CreateEvaluationFormRequest/Description
     :cognitect.aws.connect.CreateEvaluationFormRequest/ScoringStrategy
     :cognitect.aws.connect.CreateEvaluationFormRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/TaskTemplateFieldName
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/MediaStreamType (s/spec string? :gen #(s/gen #{"VIDEO" "AUDIO"})))

(s/def :cognitect.aws.connect/EndAssociatedTasksActionDefinition (s/keys))

(s/def
  :cognitect.aws.connect/LimitExceededException
  (s/keys :opt-un [:cognitect.aws.connect.LimitExceededException/Message]))

(s/def
  :cognitect.aws.connect/AgentLastName
  (s/spec
    (s/and string? #(<= 0 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/PhoneNumberTypes
  (s/coll-of :cognitect.aws.connect/PhoneNumberType :max-count 6))

(s/def
  :cognitect.aws.connect/UserProficiencyList
  (s/coll-of :cognitect.aws.connect/UserProficiency))

(s/def :cognitect.aws.connect/AWSAccountId string?)

(s/def
  :cognitect.aws.connect/CreatedByInfo
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreatedByInfo/ConnectUserArn
     :cognitect.aws.connect.CreatedByInfo/AWSIdentityArn]))

(s/def
  :cognitect.aws.connect/ClaimedPhoneNumberSummary
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ClaimedPhoneNumberSummary/InstanceId
     :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberDescription
     :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberCountryCode
     :cognitect.aws.connect.ClaimedPhoneNumberSummary/TargetArn
     :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberArn
     :cognitect.aws.connect.ClaimedPhoneNumberSummary/Tags
     :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberType
     :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberStatus
     :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberId
     :cognitect.aws.connect.ClaimedPhoneNumberSummary/SourcePhoneNumberArn
     :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumber]))

(s/def
  :cognitect.aws.connect/ListInstancesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListInstancesResponse/InstanceSummaryList
     :cognitect.aws.connect.ListInstancesResponse/NextToken]))

(s/def
  :cognitect.aws.connect/UpdateAgentStatusDescription
  (s/spec
    (s/and string? #(<= 0 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 250) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SubmitAutoEvaluationActionDefinition
  (s/keys :req-un [:cognitect.aws.connect.SubmitAutoEvaluationActionDefinition/EvaluationFormId]))

(s/def
  :cognitect.aws.connect/DisassociateLexBotRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateLexBotRequest/InstanceId
     :cognitect.aws.connect.DisassociateLexBotRequest/BotName
     :cognitect.aws.connect.DisassociateLexBotRequest/LexRegion]
    :opt-un
    [:cognitect.aws.connect.DisassociateLexBotRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/HierarchyGroupSummaryList
  (s/coll-of :cognitect.aws.connect/HierarchyGroupSummary))

(s/def
  :cognitect.aws.connect/HoursOfOperationSearchCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HoursOfOperationSearchCriteria/OrConditions
     :cognitect.aws.connect.HoursOfOperationSearchCriteria/StringCondition
     :cognitect.aws.connect.HoursOfOperationSearchCriteria/AndConditions]))

(s/def
  :cognitect.aws.connect/SearchContactsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchContactsRequest/InstanceId
     :cognitect.aws.connect.SearchContactsRequest/TimeRange]
    :opt-un
    [:cognitect.aws.connect.SearchContactsRequest/Sort
     :cognitect.aws.connect.SearchContactsRequest/NextToken
     :cognitect.aws.connect.SearchContactsRequest/SearchCriteria
     :cognitect.aws.connect.SearchContactsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/VocabularyName
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z._-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/TaskTemplateArn
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentTypes
  (s/coll-of :cognitect.aws.connect/RealTimeContactAnalysisSegmentType :max-count 6))

(s/def
  :cognitect.aws.connect/PredefinedAttributeStringValuesList
  (s/coll-of :cognitect.aws.connect/PredefinedAttributeStringValue :min-count 1 :max-count 128))

(s/def
  :cognitect.aws.connect/ReadOnlyTaskTemplateFields
  (s/coll-of :cognitect.aws.connect/ReadOnlyFieldInfo))

(s/def
  :cognitect.aws.connect/UpdateHoursOfOperationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateHoursOfOperationRequest/InstanceId
     :cognitect.aws.connect.UpdateHoursOfOperationRequest/HoursOfOperationId]
    :opt-un
    [:cognitect.aws.connect.UpdateHoursOfOperationRequest/Config
     :cognitect.aws.connect.UpdateHoursOfOperationRequest/TimeZone
     :cognitect.aws.connect.UpdateHoursOfOperationRequest/Description
     :cognitect.aws.connect.UpdateHoursOfOperationRequest/Name]))

(s/def
  :cognitect.aws.connect/UserReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.UserReference/Arn :cognitect.aws.connect.UserReference/Id]))

(s/def
  :cognitect.aws.connect/RoutingProfileQueueConfigSummary
  (s/keys
    :req-un
    [:cognitect.aws.connect.RoutingProfileQueueConfigSummary/QueueId
     :cognitect.aws.connect.RoutingProfileQueueConfigSummary/QueueArn
     :cognitect.aws.connect.RoutingProfileQueueConfigSummary/QueueName
     :cognitect.aws.connect.RoutingProfileQueueConfigSummary/Priority
     :cognitect.aws.connect.RoutingProfileQueueConfigSummary/Delay
     :cognitect.aws.connect.RoutingProfileQueueConfigSummary/Channel]))

(s/def
  :cognitect.aws.connect/TaskNameExpression
  (s/spec
    (s/and string? #(<= 1 (count %) 512))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 512) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/EvaluationAnswerDataStringValue
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListQuickConnectsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListQuickConnectsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListQuickConnectsRequest/NextToken
     :cognitect.aws.connect.ListQuickConnectsRequest/MaxResults
     :cognitect.aws.connect.ListQuickConnectsRequest/QuickConnectTypes]))

(s/def
  :cognitect.aws.connect/HoursOfOperationOverride
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HoursOfOperationOverride/Config
     :cognitect.aws.connect.HoursOfOperationOverride/HoursOfOperationArn
     :cognitect.aws.connect.HoursOfOperationOverride/HoursOfOperationOverrideId
     :cognitect.aws.connect.HoursOfOperationOverride/Description
     :cognitect.aws.connect.HoursOfOperationOverride/EffectiveFrom
     :cognitect.aws.connect.HoursOfOperationOverride/EffectiveTill
     :cognitect.aws.connect.HoursOfOperationOverride/Name
     :cognitect.aws.connect.HoursOfOperationOverride/HoursOfOperationId]))

(s/def
  :cognitect.aws.connect/ContactFlowModuleName
  (s/spec #(re-matches (re-pattern ".*\\S.*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/DescribeRuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeRuleRequest/InstanceId
     :cognitect.aws.connect.DescribeRuleRequest/RuleId]))

(s/def
  :cognitect.aws.connect/SearchRoutingProfilesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchRoutingProfilesResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchRoutingProfilesResponse/NextToken
     :cognitect.aws.connect.SearchRoutingProfilesResponse/RoutingProfiles]))

(s/def
  :cognitect.aws.connect/ResourceInUseException
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ResourceInUseException/ResourceId
     :cognitect.aws.connect.ResourceInUseException/Message
     :cognitect.aws.connect.ResourceInUseException/ResourceType]))

(s/def
  :cognitect.aws.connect/Content
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListSecurityKeysRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListSecurityKeysRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.ListSecurityKeysRequest/NextToken
     :cognitect.aws.connect.ListSecurityKeysRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/TotalCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/UpdateHoursOfOperationDescription
  (s/spec
    (s/and string? #(<= 0 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 250) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ReferenceArn
  (s/spec #(re-matches (re-pattern "^[-:/A-Za-z0-9]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.connect/UpdateQuickConnectConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateQuickConnectConfigRequest/InstanceId
     :cognitect.aws.connect.UpdateQuickConnectConfigRequest/QuickConnectId
     :cognitect.aws.connect.UpdateQuickConnectConfigRequest/QuickConnectConfig]))

(s/def
  :cognitect.aws.connect/TaskTemplateFieldValue
  (s/spec
    (s/and string? #(<= 0 (count %) 4096))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4096) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/SearchableSegmentAttributeKey
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/ListHoursOfOperationOverridesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ListHoursOfOperationOverridesResponse/HoursOfOperationOverrideList
     :cognitect.aws.connect.ListHoursOfOperationOverridesResponse/NextToken
     :cognitect.aws.connect.ListHoursOfOperationOverridesResponse/LastModifiedRegion
     :cognitect.aws.connect.ListHoursOfOperationOverridesResponse/LastModifiedTime]))

(s/def
  :cognitect.aws.connect/GetAttachedFileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetAttachedFileRequest/InstanceId
     :cognitect.aws.connect.GetAttachedFileRequest/FileId
     :cognitect.aws.connect.GetAttachedFileRequest/AssociatedResourceArn]
    :opt-un
    [:cognitect.aws.connect.GetAttachedFileRequest/UrlExpiryInSeconds]))

(s/def
  :cognitect.aws.connect/GetMetricDataRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.GetMetricDataRequest/InstanceId
     :cognitect.aws.connect.GetMetricDataRequest/StartTime
     :cognitect.aws.connect.GetMetricDataRequest/EndTime
     :cognitect.aws.connect.GetMetricDataRequest/Filters
     :cognitect.aws.connect.GetMetricDataRequest/HistoricalMetrics]
    :opt-un
    [:cognitect.aws.connect.GetMetricDataRequest/NextToken
     :cognitect.aws.connect.GetMetricDataRequest/Groupings
     :cognitect.aws.connect.GetMetricDataRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/ListInstanceStorageConfigsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListInstanceStorageConfigsRequest/InstanceId
     :cognitect.aws.connect.ListInstanceStorageConfigsRequest/ResourceType]
    :opt-un
    [:cognitect.aws.connect.ListInstanceStorageConfigsRequest/NextToken
     :cognitect.aws.connect.ListInstanceStorageConfigsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/PredefinedAttributeSearchConditionList
  (s/coll-of :cognitect.aws.connect/PredefinedAttributeSearchCriteria))

(s/def
  :cognitect.aws.connect/DeleteSecurityProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteSecurityProfileRequest/InstanceId
     :cognitect.aws.connect.DeleteSecurityProfileRequest/SecurityProfileId]))

(s/def
  :cognitect.aws.connect/EvaluationFormTitle
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DuplicateResourceException
  (s/keys :opt-un [:cognitect.aws.connect.DuplicateResourceException/Message]))

(s/def :cognitect.aws.connect/EvaluationId string?)

(s/def
  :cognitect.aws.connect/VocabularyState
  (s/spec
    string?
    :gen
    #(s/gen #{"DELETE_IN_PROGRESS" "ACTIVE" "CREATION_IN_PROGRESS" "CREATION_FAILED"})))

(s/def :cognitect.aws.connect/StopContactResponse (s/keys))

(s/def
  :cognitect.aws.connect/Expiry
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Expiry/DurationInSeconds
     :cognitect.aws.connect.Expiry/ExpiryTimestamp]))

(s/def
  :cognitect.aws.connect/DestinationId
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/HierarchyStructure
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HierarchyStructure/LevelFour
     :cognitect.aws.connect.HierarchyStructure/LevelOne
     :cognitect.aws.connect.HierarchyStructure/LevelTwo
     :cognitect.aws.connect.HierarchyStructure/LevelThree
     :cognitect.aws.connect.HierarchyStructure/LevelFive]))

(s/def
  :cognitect.aws.connect/QueueMaxContacts
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/TooManyRequestsException
  (s/keys :opt-un [:cognitect.aws.connect.TooManyRequestsException/Message]))

(s/def
  :cognitect.aws.connect/SingleSelectQuestionRuleCategoryAutomationCondition
  (s/spec string? :gen #(s/gen #{"PRESENT" "NOT_PRESENT"})))

(s/def
  :cognitect.aws.connect/StorageType
  (s/spec string? :gen #(s/gen #{"KINESIS_FIREHOSE" "KINESIS_STREAM" "S3" "KINESIS_VIDEO_STREAM"})))

(s/def
  :cognitect.aws.connect/CrossChannelBehavior
  (s/keys :req-un [:cognitect.aws.connect.CrossChannelBehavior/BehaviorType]))

(s/def
  :cognitect.aws.connect/ListRealtimeContactAnalysisSegmentsV2Request
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/InstanceId
     :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/ContactId
     :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/OutputType
     :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/SegmentTypes]
    :opt-un
    [:cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/NextToken
     :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/MaxResults]))

(s/def
  :cognitect.aws.connect/CreateAgentStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateAgentStatusRequest/InstanceId
     :cognitect.aws.connect.CreateAgentStatusRequest/Name
     :cognitect.aws.connect.CreateAgentStatusRequest/State]
    :opt-un
    [:cognitect.aws.connect.CreateAgentStatusRequest/Tags
     :cognitect.aws.connect.CreateAgentStatusRequest/DisplayOrder
     :cognitect.aws.connect.CreateAgentStatusRequest/Description]))

(s/def
  :cognitect.aws.connect/GetPromptFileResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.GetPromptFileResponse/PromptPresignedUrl
     :cognitect.aws.connect.GetPromptFileResponse/LastModifiedRegion
     :cognitect.aws.connect.GetPromptFileResponse/LastModifiedTime]))

(s/def
  :cognitect.aws.connect/ReplicateInstanceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ReplicateInstanceResponse/Arn
     :cognitect.aws.connect.ReplicateInstanceResponse/Id]))

(s/def
  :cognitect.aws.connect/EvaluationNoteString
  (s/spec
    (s/and string? #(<= 0 (count %) 3072))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 3072) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DisconnectReason
  (s/keys :opt-un [:cognitect.aws.connect.DisconnectReason/Code]))

(s/def
  :cognitect.aws.connect/UpdateAuthenticationProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateAuthenticationProfileRequest/AuthenticationProfileId
     :cognitect.aws.connect.UpdateAuthenticationProfileRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.UpdateAuthenticationProfileRequest/PeriodicSessionDuration
     :cognitect.aws.connect.UpdateAuthenticationProfileRequest/BlockedIps
     :cognitect.aws.connect.UpdateAuthenticationProfileRequest/Description
     :cognitect.aws.connect.UpdateAuthenticationProfileRequest/Name
     :cognitect.aws.connect.UpdateAuthenticationProfileRequest/AllowedIps]))

(s/def
  :cognitect.aws.connect/AttributeValue
  (s/spec
    (s/and string? #(<= 0 (count %) 32767))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 32767) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/FormId string?)

(s/def
  :cognitect.aws.connect/CampaignId
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/VoiceRecordingConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.connect.VoiceRecordingConfiguration/IvrRecordingTrack
     :cognitect.aws.connect.VoiceRecordingConfiguration/VoiceRecordingTrack]))

(s/def
  :cognitect.aws.connect/EmailAddressRecipientList
  (s/coll-of :cognitect.aws.connect/EmailAddressInfo :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.connect/UserQuickConnectConfig
  (s/keys
    :req-un
    [:cognitect.aws.connect.UserQuickConnectConfig/UserId
     :cognitect.aws.connect.UserQuickConnectConfig/ContactFlowId]))

(s/def
  :cognitect.aws.connect/UpdateQueueHoursOfOperationRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateQueueHoursOfOperationRequest/InstanceId
     :cognitect.aws.connect.UpdateQueueHoursOfOperationRequest/QueueId
     :cognitect.aws.connect.UpdateQueueHoursOfOperationRequest/HoursOfOperationId]))

(s/def
  :cognitect.aws.connect/RulePublishStatus
  (s/spec string? :gen #(s/gen #{"PUBLISHED" "DRAFT"})))

(s/def
  :cognitect.aws.connect/DimensionsV2Map
  (s/map-of :cognitect.aws.connect/DimensionsV2Key :cognitect.aws.connect/DimensionsV2Value))

(s/def :cognitect.aws.connect/Recordings (s/coll-of :cognitect.aws.connect/RecordingInfo))

(s/def
  :cognitect.aws.connect/ParticipantState
  (s/spec string? :gen #(s/gen #{"MISSED" "INITIAL" "CONNECTED" "DISCONNECTED"})))

(s/def
  :cognitect.aws.connect/GetCurrentUserDataResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.GetCurrentUserDataResponse/ApproximateTotalCount
     :cognitect.aws.connect.GetCurrentUserDataResponse/NextToken
     :cognitect.aws.connect.GetCurrentUserDataResponse/UserDataList]))

(s/def
  :cognitect.aws.connect/SourceType
  (s/spec string? :gen #(s/gen #{"SALESFORCE" "CASES" "ZENDESK"})))

(s/def
  :cognitect.aws.connect/DisassociateBotRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DisassociateBotRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.DisassociateBotRequest/LexBot
     :cognitect.aws.connect.DisassociateBotRequest/LexV2Bot
     :cognitect.aws.connect.DisassociateBotRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/EventBridgeActionDefinition
  (s/keys :req-un [:cognitect.aws.connect.EventBridgeActionDefinition/Name]))

(s/def
  :cognitect.aws.connect/ReferenceTypes
  (s/coll-of :cognitect.aws.connect/ReferenceType :max-count 6))

(s/def
  :cognitect.aws.connect/AttachmentReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AttachmentReference/Status
     :cognitect.aws.connect.AttachmentReference/Value
     :cognitect.aws.connect.AttachmentReference/Arn
     :cognitect.aws.connect.AttachmentReference/Name]))

(s/def
  :cognitect.aws.connect/PredefinedAttributeStringValue
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DeleteViewVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteViewVersionRequest/InstanceId
     :cognitect.aws.connect.DeleteViewVersionRequest/ViewId
     :cognitect.aws.connect.DeleteViewVersionRequest/ViewVersion]))

(s/def
  :cognitect.aws.connect/SearchHoursOfOperationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchHoursOfOperationsResponse/HoursOfOperations
     :cognitect.aws.connect.SearchHoursOfOperationsResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchHoursOfOperationsResponse/NextToken]))

(s/def
  :cognitect.aws.connect/MessageTemplateKnowledgeBaseId
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.connect/String string?)

(s/def :cognitect.aws.connect/AttendeeId string?)

(s/def
  :cognitect.aws.connect/Contact
  (s/keys
    :opt-un
    [:cognitect.aws.connect.Contact/Recordings
     :cognitect.aws.connect.Contact/Campaign
     :cognitect.aws.connect.Contact/InitialContactId
     :cognitect.aws.connect.Contact/QueueInfo
     :cognitect.aws.connect.Contact/PreviousContactId
     :cognitect.aws.connect.Contact/LastUpdateTimestamp
     :cognitect.aws.connect.Contact/CustomerId
     :cognitect.aws.connect.Contact/LastResumedTimestamp
     :cognitect.aws.connect.Contact/ConnectedToSystemTimestamp
     :cognitect.aws.connect.Contact/SegmentAttributes
     :cognitect.aws.connect.Contact/LastPausedTimestamp
     :cognitect.aws.connect.Contact/DisconnectReason
     :cognitect.aws.connect.Contact/Customer
     :cognitect.aws.connect.Contact/ContactEvaluations
     :cognitect.aws.connect.Contact/QueueTimeAdjustmentSeconds
     :cognitect.aws.connect.Contact/Tags
     :cognitect.aws.connect.Contact/WisdomInfo
     :cognitect.aws.connect.Contact/SystemEndpoint
     :cognitect.aws.connect.Contact/ContactDetails
     :cognitect.aws.connect.Contact/Attributes
     :cognitect.aws.connect.Contact/QualityMetrics
     :cognitect.aws.connect.Contact/TotalPauseCount
     :cognitect.aws.connect.Contact/Description
     :cognitect.aws.connect.Contact/DisconnectTimestamp
     :cognitect.aws.connect.Contact/ScheduledTimestamp
     :cognitect.aws.connect.Contact/TotalPauseDurationInSeconds
     :cognitect.aws.connect.Contact/InitiationTimestamp
     :cognitect.aws.connect.Contact/QueuePriority
     :cognitect.aws.connect.Contact/Arn
     :cognitect.aws.connect.Contact/AdditionalEmailRecipients
     :cognitect.aws.connect.Contact/Channel
     :cognitect.aws.connect.Contact/InitiationMethod
     :cognitect.aws.connect.Contact/CustomerEndpoint
     :cognitect.aws.connect.Contact/DisconnectDetails
     :cognitect.aws.connect.Contact/Name
     :cognitect.aws.connect.Contact/RelatedContactId
     :cognitect.aws.connect.Contact/RoutingCriteria
     :cognitect.aws.connect.Contact/ContactAssociationId
     :cognitect.aws.connect.Contact/AnsweringMachineDetectionStatus
     :cognitect.aws.connect.Contact/ChatMetrics
     :cognitect.aws.connect.Contact/Id
     :cognitect.aws.connect.Contact/CustomerVoiceActivity
     :cognitect.aws.connect.Contact/AgentInfo]))

(s/def
  :cognitect.aws.connect/UpdateContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.UpdateContactRequest/InstanceId
     :cognitect.aws.connect.UpdateContactRequest/ContactId]
    :opt-un
    [:cognitect.aws.connect.UpdateContactRequest/QueueInfo
     :cognitect.aws.connect.UpdateContactRequest/SegmentAttributes
     :cognitect.aws.connect.UpdateContactRequest/SystemEndpoint
     :cognitect.aws.connect.UpdateContactRequest/References
     :cognitect.aws.connect.UpdateContactRequest/Description
     :cognitect.aws.connect.UpdateContactRequest/CustomerEndpoint
     :cognitect.aws.connect.UpdateContactRequest/Name
     :cognitect.aws.connect.UpdateContactRequest/UserInfo]))

(s/def
  :cognitect.aws.connect/ClaimPhoneNumberResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.ClaimPhoneNumberResponse/PhoneNumberArn
     :cognitect.aws.connect.ClaimPhoneNumberResponse/PhoneNumberId]))

(s/def
  :cognitect.aws.connect/ListQueueQuickConnectsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.ListQueueQuickConnectsRequest/InstanceId
     :cognitect.aws.connect.ListQueueQuickConnectsRequest/QueueId]
    :opt-un
    [:cognitect.aws.connect.ListQueueQuickConnectsRequest/NextToken
     :cognitect.aws.connect.ListQueueQuickConnectsRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/SearchPromptsRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchPromptsRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchPromptsRequest/NextToken
     :cognitect.aws.connect.SearchPromptsRequest/SearchFilter
     :cognitect.aws.connect.SearchPromptsRequest/SearchCriteria
     :cognitect.aws.connect.SearchPromptsRequest/MaxResults]))

(s/def :cognitect.aws.connect/HoursOfOperationId string?)

(s/def
  :cognitect.aws.connect/CreateHoursOfOperationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.CreateHoursOfOperationResponse/HoursOfOperationArn
     :cognitect.aws.connect.CreateHoursOfOperationResponse/HoursOfOperationId]))

(s/def
  :cognitect.aws.connect/ViewVersion
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.connect/HoursOfOperation
  (s/keys
    :opt-un
    [:cognitect.aws.connect.HoursOfOperation/Config
     :cognitect.aws.connect.HoursOfOperation/TimeZone
     :cognitect.aws.connect.HoursOfOperation/Tags
     :cognitect.aws.connect.HoursOfOperation/HoursOfOperationArn
     :cognitect.aws.connect.HoursOfOperation/Description
     :cognitect.aws.connect.HoursOfOperation/LastModifiedRegion
     :cognitect.aws.connect.HoursOfOperation/LastModifiedTime
     :cognitect.aws.connect.HoursOfOperation/Name
     :cognitect.aws.connect.HoursOfOperation/HoursOfOperationId]))

(s/def :cognitect.aws.connect/InboundCallsEnabled boolean?)

(s/def
  :cognitect.aws.connect/ListFlowAssociationResourceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"WHATSAPP_MESSAGING_PHONE_NUMBER"
        "INBOUND_EMAIL"
        "OUTBOUND_EMAIL"
        "ANALYTICS_CONNECTOR"
        "VOICE_PHONE_NUMBER"})))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisId256
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/FailureReasonCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"INVALID_CUSTOMER_ENDPOINT"
        "INVALID_SYSTEM_ENDPOINT"
        "INVALID_ATTRIBUTE_KEY"
        "MISSING_QUEUE_ID_AND_SYSTEM_ENDPOINT"
        "IDEMPOTENCY_EXCEPTION"
        "MISSING_CUSTOMER_ENDPOINT"
        "MISSING_CAMPAIGN"
        "INVALID_QUEUE"
        "INTERNAL_ERROR"
        "REQUEST_THROTTLED"})))

(s/def
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentCategories
  (s/keys :req-un [:cognitect.aws.connect.RealTimeContactAnalysisSegmentCategories/MatchedDetails]))

(s/def
  :cognitect.aws.connect/SegmentAttributeName
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/DeleteAttachedFileRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DeleteAttachedFileRequest/InstanceId
     :cognitect.aws.connect.DeleteAttachedFileRequest/FileId
     :cognitect.aws.connect.DeleteAttachedFileRequest/AssociatedResourceArn]))

(s/def
  :cognitect.aws.connect/EffectiveHoursOfOperationList
  (s/coll-of :cognitect.aws.connect/EffectiveHoursOfOperations))

(s/def
  :cognitect.aws.connect/ContactFlowModuleSearchConditionList
  (s/coll-of :cognitect.aws.connect/ContactFlowModuleSearchCriteria))

(s/def
  :cognitect.aws.connect/StartWebRTCContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.StartWebRTCContactRequest/ContactFlowId
     :cognitect.aws.connect.StartWebRTCContactRequest/InstanceId
     :cognitect.aws.connect.StartWebRTCContactRequest/ParticipantDetails]
    :opt-un
    [:cognitect.aws.connect.StartWebRTCContactRequest/Attributes
     :cognitect.aws.connect.StartWebRTCContactRequest/References
     :cognitect.aws.connect.StartWebRTCContactRequest/Description
     :cognitect.aws.connect.StartWebRTCContactRequest/AllowedCapabilities
     :cognitect.aws.connect.StartWebRTCContactRequest/RelatedContactId
     :cognitect.aws.connect.StartWebRTCContactRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/SearchEmailAddressesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchEmailAddressesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchEmailAddressesRequest/NextToken
     :cognitect.aws.connect.SearchEmailAddressesRequest/SearchFilter
     :cognitect.aws.connect.SearchEmailAddressesRequest/SearchCriteria
     :cognitect.aws.connect.SearchEmailAddressesRequest/MaxResults]))

(s/def :cognitect.aws.connect/ActionSummaries (s/coll-of :cognitect.aws.connect/ActionSummary))

(s/def
  :cognitect.aws.connect/AssociateBotRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.AssociateBotRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.AssociateBotRequest/LexBot
     :cognitect.aws.connect.AssociateBotRequest/LexV2Bot
     :cognitect.aws.connect.AssociateBotRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/EmailMessageReference
  (s/keys
    :opt-un
    [:cognitect.aws.connect.EmailMessageReference/Arn
     :cognitect.aws.connect.EmailMessageReference/Name]))

(s/def
  :cognitect.aws.connect/PromptPresignedUrl
  (s/spec
    (s/and string? #(<= 1 (count %) 2000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/MetricFilterValueList
  (s/coll-of :cognitect.aws.connect/String :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.connect/DescribeUserHierarchyStructureResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.DescribeUserHierarchyStructureResponse/HierarchyStructure]))

(s/def
  :cognitect.aws.connect/EvaluationFormSummary
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormSummary/EvaluationFormId
     :cognitect.aws.connect.EvaluationFormSummary/EvaluationFormArn
     :cognitect.aws.connect.EvaluationFormSummary/Title
     :cognitect.aws.connect.EvaluationFormSummary/CreatedTime
     :cognitect.aws.connect.EvaluationFormSummary/CreatedBy
     :cognitect.aws.connect.EvaluationFormSummary/LastModifiedTime
     :cognitect.aws.connect.EvaluationFormSummary/LastModifiedBy
     :cognitect.aws.connect.EvaluationFormSummary/LatestVersion]
    :opt-un
    [:cognitect.aws.connect.EvaluationFormSummary/ActiveVersion
     :cognitect.aws.connect.EvaluationFormSummary/LastActivatedTime
     :cognitect.aws.connect.EvaluationFormSummary/LastActivatedBy]))

(s/def
  :cognitect.aws.connect/PotentialDisconnectIssue
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/Reference
  (s/keys
    :req-un
    [:cognitect.aws.connect.Reference/Type]
    :opt-un
    [:cognitect.aws.connect.Reference/Status
     :cognitect.aws.connect.Reference/StatusReason
     :cognitect.aws.connect.Reference/Value
     :cognitect.aws.connect.Reference/Arn]))

(s/def
  :cognitect.aws.connect/CreateViewRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.CreateViewRequest/InstanceId
     :cognitect.aws.connect.CreateViewRequest/Status
     :cognitect.aws.connect.CreateViewRequest/Content
     :cognitect.aws.connect.CreateViewRequest/Name]
    :opt-un
    [:cognitect.aws.connect.CreateViewRequest/Tags
     :cognitect.aws.connect.CreateViewRequest/Description
     :cognitect.aws.connect.CreateViewRequest/ClientToken]))

(s/def
  :cognitect.aws.connect/ResourceNotFoundException
  (s/keys :opt-un [:cognitect.aws.connect.ResourceNotFoundException/Message]))

(s/def
  :cognitect.aws.connect/SearchSecurityProfilesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchSecurityProfilesResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchSecurityProfilesResponse/NextToken
     :cognitect.aws.connect.SearchSecurityProfilesResponse/SecurityProfiles]))

(s/def :cognitect.aws.connect/AttachedFilesList (s/coll-of :cognitect.aws.connect/AttachedFile))

(s/def
  :cognitect.aws.connect/ConflictException
  (s/keys :opt-un [:cognitect.aws.connect.ConflictException/Message]))

(s/def
  :cognitect.aws.connect/TaskTemplateDefaults
  (s/keys :opt-un [:cognitect.aws.connect.TaskTemplateDefaults/DefaultFieldValues]))

(s/def
  :cognitect.aws.connect/AnalyticsDataSetsResults
  (s/coll-of :cognitect.aws.connect/AnalyticsDataSetsResult))

(s/def
  :cognitect.aws.connect/QueueDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 250))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 250) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.connect/TagKeyList
  (s/coll-of :cognitect.aws.connect/TagKey :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.connect/RoutingProfileQueueConfigSummaryList
  (s/coll-of :cognitect.aws.connect/RoutingProfileQueueConfigSummary))

(s/def
  :cognitect.aws.connect/EvaluationFormQuestion
  (s/keys
    :req-un
    [:cognitect.aws.connect.EvaluationFormQuestion/Title
     :cognitect.aws.connect.EvaluationFormQuestion/RefId
     :cognitect.aws.connect.EvaluationFormQuestion/QuestionType]
    :opt-un
    [:cognitect.aws.connect.EvaluationFormQuestion/Instructions
     :cognitect.aws.connect.EvaluationFormQuestion/Weight
     :cognitect.aws.connect.EvaluationFormQuestion/QuestionTypeProperties
     :cognitect.aws.connect.EvaluationFormQuestion/NotApplicableEnabled]))

(s/def
  :cognitect.aws.connect/SearchVocabulariesRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.SearchVocabulariesRequest/InstanceId]
    :opt-un
    [:cognitect.aws.connect.SearchVocabulariesRequest/NextToken
     :cognitect.aws.connect.SearchVocabulariesRequest/LanguageCode
     :cognitect.aws.connect.SearchVocabulariesRequest/NameStartsWith
     :cognitect.aws.connect.SearchVocabulariesRequest/State
     :cognitect.aws.connect.SearchVocabulariesRequest/MaxResults]))

(s/def
  :cognitect.aws.connect/SearchableContactAttributeValueList
  (s/coll-of :cognitect.aws.connect/SearchableContactAttributeValue :min-count 0 :max-count 20))

(s/def
  :cognitect.aws.connect/DescribeQuickConnectRequest
  (s/keys
    :req-un
    [:cognitect.aws.connect.DescribeQuickConnectRequest/InstanceId
     :cognitect.aws.connect.DescribeQuickConnectRequest/QuickConnectId]))

(s/def
  :cognitect.aws.connect/ParticipantRole
  (s/spec string? :gen #(s/gen #{"SYSTEM" "AGENT" "SUPERVISOR" "CUSTOM_BOT" "CUSTOMER"})))

(s/def
  :cognitect.aws.connect/Status
  (s/spec string? :gen #(s/gen #{"IN_PROGRESS" "COMPLETE" "DELETED"})))

(s/def
  :cognitect.aws.connect/SearchQuickConnectsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.connect.SearchQuickConnectsResponse/ApproximateTotalCount
     :cognitect.aws.connect.SearchQuickConnectsResponse/NextToken
     :cognitect.aws.connect.SearchQuickConnectsResponse/QuickConnects]))

(s/def
  :cognitect.aws.connect/AgentStatus
  (s/keys
    :opt-un
    [:cognitect.aws.connect.AgentStatus/Type
     :cognitect.aws.connect.AgentStatus/Tags
     :cognitect.aws.connect.AgentStatus/AgentStatusId
     :cognitect.aws.connect.AgentStatus/DisplayOrder
     :cognitect.aws.connect.AgentStatus/Description
     :cognitect.aws.connect.AgentStatus/LastModifiedRegion
     :cognitect.aws.connect.AgentStatus/State
     :cognitect.aws.connect.AgentStatus/LastModifiedTime
     :cognitect.aws.connect.AgentStatus/Name
     :cognitect.aws.connect.AgentStatus/AgentStatusARN]))

(s/def
  :cognitect.aws.connect/ResourceNotReadyException
  (s/keys :opt-un [:cognitect.aws.connect.ResourceNotReadyException/Message]))

(s/def
  :cognitect.aws.connect/Vocabulary
  (s/keys
    :req-un
    [:cognitect.aws.connect.Vocabulary/Name
     :cognitect.aws.connect.Vocabulary/Id
     :cognitect.aws.connect.Vocabulary/Arn
     :cognitect.aws.connect.Vocabulary/LanguageCode
     :cognitect.aws.connect.Vocabulary/State
     :cognitect.aws.connect.Vocabulary/LastModifiedTime]
    :opt-un
    [:cognitect.aws.connect.Vocabulary/Tags
     :cognitect.aws.connect.Vocabulary/FailureReason
     :cognitect.aws.connect.Vocabulary/Content]))

(s/def :cognitect.aws.connect/AutoAccept boolean?)

(s/def
  :cognitect.aws.connect.SearchContactFlowModulesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchContactFlowModulesRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchContactFlowModulesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchContactFlowModulesRequest/SearchFilter
  :cognitect.aws.connect/ContactFlowModuleSearchFilter)

(s/def
  :cognitect.aws.connect.SearchContactFlowModulesRequest/SearchCriteria
  :cognitect.aws.connect/ContactFlowModuleSearchCriteria)

(s/def :cognitect.aws.connect.DescribeViewRequest/InstanceId :cognitect.aws.connect/ViewsInstanceId)

(s/def :cognitect.aws.connect.DescribeViewRequest/ViewId :cognitect.aws.connect/ViewId)

(s/def
  :cognitect.aws.connect.EvaluationFormNumericQuestionProperties/MinValue
  :cognitect.aws.connect/Integer)

(s/def
  :cognitect.aws.connect.EvaluationFormNumericQuestionProperties/MaxValue
  :cognitect.aws.connect/Integer)

(s/def
  :cognitect.aws.connect.EvaluationFormNumericQuestionProperties/Options
  :cognitect.aws.connect/EvaluationFormNumericQuestionOptionList)

(s/def
  :cognitect.aws.connect.EvaluationFormNumericQuestionProperties/Automation
  :cognitect.aws.connect/EvaluationFormNumericQuestionAutomation)

(s/def
  :cognitect.aws.connect.DescribeEvaluationFormRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeEvaluationFormRequest/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.DescribeEvaluationFormRequest/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.ListLambdaFunctionsResponse/LambdaFunctions
  :cognitect.aws.connect/FunctionArnsList)

(s/def
  :cognitect.aws.connect.ListLambdaFunctionsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.HierarchyGroupCondition/Value :cognitect.aws.connect/String)

(s/def
  :cognitect.aws.connect.HierarchyGroupCondition/HierarchyGroupMatchType
  :cognitect.aws.connect/HierarchyGroupMatchType)

(s/def :cognitect.aws.connect.ContactFlowVersionSummary/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ContactFlowVersionSummary/VersionDescription
  :cognitect.aws.connect/ContactFlowDescription)

(s/def
  :cognitect.aws.connect.ContactFlowVersionSummary/Version
  :cognitect.aws.connect/ResourceVersion)

(s/def :cognitect.aws.connect.OutboundRawMessage/Subject :cognitect.aws.connect/OutboundSubject)

(s/def :cognitect.aws.connect.OutboundRawMessage/Body :cognitect.aws.connect/Body)

(s/def
  :cognitect.aws.connect.OutboundRawMessage/ContentType
  :cognitect.aws.connect/EmailMessageContentType)

(s/def :cognitect.aws.connect.ThrottlingException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/Name
  :cognitect.aws.connect/CommonHumanReadableName)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/Description
  :cognitect.aws.connect/CommonHumanReadableDescription)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/Config
  :cognitect.aws.connect/HoursOfOperationOverrideConfigList)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/EffectiveFrom
  :cognitect.aws.connect/HoursOfOperationOverrideYearMonthDayDateFormat)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationOverrideRequest/EffectiveTill
  :cognitect.aws.connect/HoursOfOperationOverrideYearMonthDayDateFormat)

(s/def
  :cognitect.aws.connect.DescribeAuthenticationProfileResponse/AuthenticationProfile
  :cognitect.aws.connect/AuthenticationProfile)

(s/def :cognitect.aws.connect.GetMetricDataResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.GetMetricDataResponse/MetricResults
  :cognitect.aws.connect/HistoricalMetricResults)

(s/def :cognitect.aws.connect.ResourceConflictException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.GetContactMetricsRequest/InstanceId
  :cognitect.aws.connect/InstanceIdOrArn)

(s/def
  :cognitect.aws.connect.GetContactMetricsRequest/ContactId
  :cognitect.aws.connect/InstanceIdOrArn)

(s/def
  :cognitect.aws.connect.GetContactMetricsRequest/Metrics
  :cognitect.aws.connect/ContactMetrics)

(s/def
  :cognitect.aws.connect.PredefinedAttribute/Name
  :cognitect.aws.connect/PredefinedAttributeName)

(s/def
  :cognitect.aws.connect.PredefinedAttribute/Values
  :cognitect.aws.connect/PredefinedAttributeValues)

(s/def :cognitect.aws.connect.PredefinedAttribute/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.PredefinedAttribute/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.AgentHierarchyGroups/L1Ids
  :cognitect.aws.connect/HierarchyGroupIdList)

(s/def
  :cognitect.aws.connect.AgentHierarchyGroups/L2Ids
  :cognitect.aws.connect/HierarchyGroupIdList)

(s/def
  :cognitect.aws.connect.AgentHierarchyGroups/L3Ids
  :cognitect.aws.connect/HierarchyGroupIdList)

(s/def
  :cognitect.aws.connect.AgentHierarchyGroups/L4Ids
  :cognitect.aws.connect/HierarchyGroupIdList)

(s/def
  :cognitect.aws.connect.AgentHierarchyGroups/L5Ids
  :cognitect.aws.connect/HierarchyGroupIdList)

(s/def :cognitect.aws.connect.HierarchyGroups/Level1 :cognitect.aws.connect/AgentHierarchyGroup)

(s/def :cognitect.aws.connect.HierarchyGroups/Level2 :cognitect.aws.connect/AgentHierarchyGroup)

(s/def :cognitect.aws.connect.HierarchyGroups/Level3 :cognitect.aws.connect/AgentHierarchyGroup)

(s/def :cognitect.aws.connect.HierarchyGroups/Level4 :cognitect.aws.connect/AgentHierarchyGroup)

(s/def :cognitect.aws.connect.HierarchyGroups/Level5 :cognitect.aws.connect/AgentHierarchyGroup)

(s/def
  :cognitect.aws.connect.ServiceQuotaExceededExceptionReason/AttachedFileServiceQuotaExceededExceptionReason
  :cognitect.aws.connect/AttachedFileServiceQuotaExceededExceptionReason)

(s/def :cognitect.aws.connect.FieldValue/Id :cognitect.aws.connect/FieldValueId)

(s/def :cognitect.aws.connect.FieldValue/Value :cognitect.aws.connect/FieldValueUnion)

(s/def
  :cognitect.aws.connect.SearchableContactAttributesCriteria/Key
  :cognitect.aws.connect/SearchableContactAttributeKey)

(s/def
  :cognitect.aws.connect.SearchableContactAttributesCriteria/Values
  :cognitect.aws.connect/SearchableContactAttributeValueList)

(s/def :cognitect.aws.connect.SecurityProfileSummary/Id :cognitect.aws.connect/SecurityProfileId)

(s/def :cognitect.aws.connect.SecurityProfileSummary/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.SecurityProfileSummary/Name
  :cognitect.aws.connect/SecurityProfileName)

(s/def
  :cognitect.aws.connect.SecurityProfileSummary/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.SecurityProfileSummary/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.RoutingProfileSearchFilter/TagFilter
  :cognitect.aws.connect/ControlPlaneTagFilter)

(s/def
  :cognitect.aws.connect.DescribeHoursOfOperationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeHoursOfOperationRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def :cognitect.aws.connect.UpdateQueueNameRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.UpdateQueueNameRequest/QueueId :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.UpdateQueueNameRequest/Name
  :cognitect.aws.connect/CommonNameLength127)

(s/def
  :cognitect.aws.connect.UpdateQueueNameRequest/Description
  :cognitect.aws.connect/QueueDescription)

(s/def :cognitect.aws.connect.TagResourceRequest/resourceArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.TagResourceRequest/tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.ParticipantTimerValue/ParticipantTimerAction
  :cognitect.aws.connect/ParticipantTimerAction)

(s/def
  :cognitect.aws.connect.ParticipantTimerValue/ParticipantTimerDurationInMinutes
  :cognitect.aws.connect/ParticipantTimerDurationInMinutes)

(s/def :cognitect.aws.connect.ListRulesRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListRulesRequest/PublishStatus
  :cognitect.aws.connect/RulePublishStatus)

(s/def
  :cognitect.aws.connect.ListRulesRequest/EventSourceName
  :cognitect.aws.connect/EventSourceName)

(s/def :cognitect.aws.connect.ListRulesRequest/MaxResults :cognitect.aws.connect/MaxResult200)

(s/def :cognitect.aws.connect.ListRulesRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.S3Config/BucketName :cognitect.aws.connect/BucketName)

(s/def :cognitect.aws.connect.S3Config/BucketPrefix :cognitect.aws.connect/Prefix)

(s/def :cognitect.aws.connect.S3Config/EncryptionConfig :cognitect.aws.connect/EncryptionConfig)

(s/def
  :cognitect.aws.connect.UpdateContactFlowContentRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowContentRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowContentRequest/Content
  :cognitect.aws.connect/ContactFlowContent)

(s/def :cognitect.aws.connect.ServiceQuotaExceededException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.ServiceQuotaExceededException/Reason
  :cognitect.aws.connect/ServiceQuotaExceededExceptionReason)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateRequest/TaskTemplateId
  :cognitect.aws.connect/TaskTemplateId)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateRequest/Constraints
  :cognitect.aws.connect/TaskTemplateConstraints)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateRequest/Defaults
  :cognitect.aws.connect/TaskTemplateDefaults)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateRequest/Name
  :cognitect.aws.connect/TaskTemplateName)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateRequest/Description
  :cognitect.aws.connect/TaskTemplateDescription)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateRequest/SelfAssignFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateRequest/Fields
  :cognitect.aws.connect/TaskTemplateFields)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateRequest/Status
  :cognitect.aws.connect/TaskTemplateStatus)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataLakeDataSetsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataLakeDataSetsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataLakeDataSetsRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.CommonAttributeAndCondition/TagConditions
  :cognitect.aws.connect/TagAndConditionList)

(s/def
  :cognitect.aws.connect.ListQuickConnectsResponse/QuickConnectSummaryList
  :cognitect.aws.connect/QuickConnectSummaryList)

(s/def :cognitect.aws.connect.ListQuickConnectsResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.CreateVocabularyRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.CreateVocabularyRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateVocabularyRequest/VocabularyName
  :cognitect.aws.connect/VocabularyName)

(s/def
  :cognitect.aws.connect.CreateVocabularyRequest/LanguageCode
  :cognitect.aws.connect/VocabularyLanguageCode)

(s/def
  :cognitect.aws.connect.CreateVocabularyRequest/Content
  :cognitect.aws.connect/VocabularyContent)

(s/def :cognitect.aws.connect.CreateVocabularyRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.IntegrationAssociationSummary/IntegrationAssociationId
  :cognitect.aws.connect/IntegrationAssociationId)

(s/def
  :cognitect.aws.connect.IntegrationAssociationSummary/IntegrationAssociationArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.IntegrationAssociationSummary/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.IntegrationAssociationSummary/IntegrationType
  :cognitect.aws.connect/IntegrationType)

(s/def
  :cognitect.aws.connect.IntegrationAssociationSummary/IntegrationArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.IntegrationAssociationSummary/SourceApplicationUrl
  :cognitect.aws.connect/URI)

(s/def
  :cognitect.aws.connect.IntegrationAssociationSummary/SourceApplicationName
  :cognitect.aws.connect/SourceApplicationName)

(s/def
  :cognitect.aws.connect.IntegrationAssociationSummary/SourceType
  :cognitect.aws.connect/SourceType)

(s/def :cognitect.aws.connect.QuickConnectSummary/Id :cognitect.aws.connect/QuickConnectId)

(s/def :cognitect.aws.connect.QuickConnectSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.QuickConnectSummary/Name :cognitect.aws.connect/QuickConnectName)

(s/def
  :cognitect.aws.connect.QuickConnectSummary/QuickConnectType
  :cognitect.aws.connect/QuickConnectType)

(s/def :cognitect.aws.connect.QuickConnectSummary/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.QuickConnectSummary/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.DisassociateSecurityKeyRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DisassociateSecurityKeyRequest/AssociationId
  :cognitect.aws.connect/AssociationId)

(s/def
  :cognitect.aws.connect.DisassociateSecurityKeyRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.HierarchyPath/LevelOne :cognitect.aws.connect/HierarchyGroupSummary)

(s/def :cognitect.aws.connect.HierarchyPath/LevelTwo :cognitect.aws.connect/HierarchyGroupSummary)

(s/def :cognitect.aws.connect.HierarchyPath/LevelThree :cognitect.aws.connect/HierarchyGroupSummary)

(s/def :cognitect.aws.connect.HierarchyPath/LevelFour :cognitect.aws.connect/HierarchyGroupSummary)

(s/def :cognitect.aws.connect.HierarchyPath/LevelFive :cognitect.aws.connect/HierarchyGroupSummary)

(s/def :cognitect.aws.connect.ResumeContactRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.ResumeContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ResumeContactRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.PredefinedAttributeValues/StringList
  :cognitect.aws.connect/PredefinedAttributeStringValuesList)

(s/def :cognitect.aws.connect.View/VersionDescription :cognitect.aws.connect/ViewDescription)

(s/def :cognitect.aws.connect.View/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.View/ViewContentSha256 :cognitect.aws.connect/ViewContentSha256)

(s/def :cognitect.aws.connect.View/Id :cognitect.aws.connect/ViewId)

(s/def :cognitect.aws.connect.View/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.View/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.View/Name :cognitect.aws.connect/ViewName)

(s/def :cognitect.aws.connect.View/Description :cognitect.aws.connect/ViewDescription)

(s/def :cognitect.aws.connect.View/Type :cognitect.aws.connect/ViewType)

(s/def :cognitect.aws.connect.View/CreatedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.View/Version :cognitect.aws.connect/ViewVersion)

(s/def :cognitect.aws.connect.View/Content :cognitect.aws.connect/ViewContent)

(s/def :cognitect.aws.connect.View/Status :cognitect.aws.connect/ViewStatus)

(s/def :cognitect.aws.connect.ListPromptsRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListPromptsRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ListPromptsRequest/MaxResults :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.DeleteHoursOfOperationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteHoursOfOperationRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def :cognitect.aws.connect.QueueInfo/Id :cognitect.aws.connect/QueueId)

(s/def :cognitect.aws.connect.QueueInfo/EnqueueTimestamp :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.DisassociateUserProficienciesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DisassociateUserProficienciesRequest/UserId
  :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.DisassociateUserProficienciesRequest/UserProficiencies
  :cognitect.aws.connect/UserProficiencyDisassociateList)

(s/def
  :cognitect.aws.connect.SearchContactFlowsResponse/ContactFlows
  :cognitect.aws.connect/ContactFlowSearchSummaryList)

(s/def
  :cognitect.aws.connect.SearchContactFlowsResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchContactFlowsResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def
  :cognitect.aws.connect.StartContactEvaluationResponse/EvaluationId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.StartContactEvaluationResponse/EvaluationArn
  :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.InternalServiceException/Message :cognitect.aws.connect/Message)

(s/def :cognitect.aws.connect.AgentConfig/Distributions :cognitect.aws.connect/DistributionList)

(s/def :cognitect.aws.connect.ListPhoneNumbersV2Request/TargetArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersV2Request/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersV2Request/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersV2Request/NextToken
  :cognitect.aws.connect/LargeNextToken)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersV2Request/PhoneNumberCountryCodes
  :cognitect.aws.connect/PhoneNumberCountryCodes)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersV2Request/PhoneNumberTypes
  :cognitect.aws.connect/PhoneNumberTypes)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersV2Request/PhoneNumberPrefix
  :cognitect.aws.connect/PhoneNumberPrefix)

(s/def :cognitect.aws.connect.HistoricalMetricData/Metric :cognitect.aws.connect/HistoricalMetric)

(s/def :cognitect.aws.connect.HistoricalMetricData/Value :cognitect.aws.connect/Value)

(s/def
  :cognitect.aws.connect.CreatePersistentContactAssociationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreatePersistentContactAssociationRequest/InitialContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.CreatePersistentContactAssociationRequest/RehydrationType
  :cognitect.aws.connect/RehydrationType)

(s/def
  :cognitect.aws.connect.CreatePersistentContactAssociationRequest/SourceContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.CreatePersistentContactAssociationRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.PutUserStatusRequest/UserId :cognitect.aws.connect/UserId)

(s/def :cognitect.aws.connect.PutUserStatusRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.PutUserStatusRequest/AgentStatusId
  :cognitect.aws.connect/AgentStatusId)

(s/def
  :cognitect.aws.connect.AssociateDefaultVocabularyRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.AssociateDefaultVocabularyRequest/LanguageCode
  :cognitect.aws.connect/VocabularyLanguageCode)

(s/def
  :cognitect.aws.connect.AssociateDefaultVocabularyRequest/VocabularyId
  :cognitect.aws.connect/VocabularyId)

(s/def :cognitect.aws.connect.FlowAssociationSummary/ResourceId :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.FlowAssociationSummary/FlowId :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.FlowAssociationSummary/ResourceType
  :cognitect.aws.connect/ListFlowAssociationResourceType)

(s/def
  :cognitect.aws.connect.DeleteContactFlowModuleRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteContactFlowModuleRequest/ContactFlowModuleId
  :cognitect.aws.connect/ContactFlowModuleId)

(s/def
  :cognitect.aws.connect.SecurityProfileSearchCriteria/OrConditions
  :cognitect.aws.connect/SecurityProfileSearchConditionList)

(s/def
  :cognitect.aws.connect.SecurityProfileSearchCriteria/AndConditions
  :cognitect.aws.connect/SecurityProfileSearchConditionList)

(s/def
  :cognitect.aws.connect.SecurityProfileSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def
  :cognitect.aws.connect.ControlPlaneAttributeFilter/OrConditions
  :cognitect.aws.connect/CommonAttributeOrConditionList)

(s/def
  :cognitect.aws.connect.ControlPlaneAttributeFilter/AndCondition
  :cognitect.aws.connect/CommonAttributeAndCondition)

(s/def
  :cognitect.aws.connect.ControlPlaneAttributeFilter/TagCondition
  :cognitect.aws.connect/TagCondition)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/Redaction
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptItemRedaction)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/Id
  :cognitect.aws.connect/RealTimeContactAnalysisId256)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/ParticipantId
  :cognitect.aws.connect/ParticipantId)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/DisplayName
  :cognitect.aws.connect/DisplayName)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/Sentiment
  :cognitect.aws.connect/RealTimeContactAnalysisSentimentLabel)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/Time
  :cognitect.aws.connect/RealTimeContactAnalysisTimeData)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/ContentType
  :cognitect.aws.connect/RealTimeContactAnalysisContentType)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/Content
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptContent)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentTranscript/ParticipantRole
  :cognitect.aws.connect/ParticipantRole)

(s/def
  :cognitect.aws.connect.ListRoutingProfileQueuesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListRoutingProfileQueuesResponse/RoutingProfileQueueConfigSummaryList
  :cognitect.aws.connect/RoutingProfileQueueConfigSummaryList)

(s/def
  :cognitect.aws.connect.ListRoutingProfileQueuesResponse/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.ListRoutingProfileQueuesResponse/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.AgentStatusReference/StatusStartTimestamp
  :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.AgentStatusReference/StatusArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.AgentStatusReference/StatusName
  :cognitect.aws.connect/AgentStatusName)

(s/def :cognitect.aws.connect.EvaluationSummary/EvaluationFormId :cognitect.aws.connect/ResourceId)

(s/def :cognitect.aws.connect.EvaluationSummary/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.EvaluationSummary/Score :cognitect.aws.connect/EvaluationScore)

(s/def :cognitect.aws.connect.EvaluationSummary/EvaluationArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.EvaluationSummary/CreatedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.EvaluationSummary/EvaluatorArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.EvaluationSummary/EvaluationFormTitle
  :cognitect.aws.connect/EvaluationFormTitle)

(s/def :cognitect.aws.connect.EvaluationSummary/EvaluationId :cognitect.aws.connect/ResourceId)

(s/def :cognitect.aws.connect.EvaluationSummary/Status :cognitect.aws.connect/EvaluationStatus)

(s/def :cognitect.aws.connect.DefaultVocabulary/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DefaultVocabulary/LanguageCode
  :cognitect.aws.connect/VocabularyLanguageCode)

(s/def :cognitect.aws.connect.DefaultVocabulary/VocabularyId :cognitect.aws.connect/VocabularyId)

(s/def
  :cognitect.aws.connect.DefaultVocabulary/VocabularyName
  :cognitect.aws.connect/VocabularyName)

(s/def :cognitect.aws.connect.UserIdentityInfoLite/FirstName :cognitect.aws.connect/AgentFirstName)

(s/def :cognitect.aws.connect.UserIdentityInfoLite/LastName :cognitect.aws.connect/AgentLastName)

(s/def :cognitect.aws.connect.CreateUserResponse/UserId :cognitect.aws.connect/UserId)

(s/def :cognitect.aws.connect.CreateUserResponse/UserArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.DeleteEmailAddressRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteEmailAddressRequest/EmailAddressId
  :cognitect.aws.connect/EmailAddressId)

(s/def
  :cognitect.aws.connect.InvalidContactFlowModuleException/Problems
  :cognitect.aws.connect/Problems)

(s/def
  :cognitect.aws.connect.SecurityProfile/OrganizationResourceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SecurityProfile/HierarchyRestrictedResources
  :cognitect.aws.connect/HierarchyRestrictedResourceList)

(s/def :cognitect.aws.connect.SecurityProfile/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.SecurityProfile/Id :cognitect.aws.connect/SecurityProfileId)

(s/def :cognitect.aws.connect.SecurityProfile/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.SecurityProfile/AllowedAccessControlHierarchyGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def
  :cognitect.aws.connect.SecurityProfile/AllowedAccessControlTags
  :cognitect.aws.connect/AllowedAccessControlTags)

(s/def
  :cognitect.aws.connect.SecurityProfile/SecurityProfileName
  :cognitect.aws.connect/SecurityProfileName)

(s/def
  :cognitect.aws.connect.SecurityProfile/TagRestrictedResources
  :cognitect.aws.connect/TagRestrictedResourceList)

(s/def :cognitect.aws.connect.SecurityProfile/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.SecurityProfile/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.SecurityProfile/Description
  :cognitect.aws.connect/SecurityProfileDescription)

(s/def
  :cognitect.aws.connect.ListQueueQuickConnectsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListQueueQuickConnectsResponse/QuickConnectSummaryList
  :cognitect.aws.connect/QuickConnectSummaryList)

(s/def
  :cognitect.aws.connect.ListQueueQuickConnectsResponse/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.ListQueueQuickConnectsResponse/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.FieldValueUnion/BooleanValue :cognitect.aws.connect/Boolean)

(s/def :cognitect.aws.connect.FieldValueUnion/DoubleValue :cognitect.aws.connect/Double)

(s/def :cognitect.aws.connect.FieldValueUnion/EmptyValue :cognitect.aws.connect/EmptyFieldValue)

(s/def :cognitect.aws.connect.FieldValueUnion/StringValue :cognitect.aws.connect/FieldStringValue)

(s/def :cognitect.aws.connect.AgentsCriteria/AgentIds :cognitect.aws.connect/AgentIds)

(s/def
  :cognitect.aws.connect.UserProficiency/AttributeName
  :cognitect.aws.connect/PredefinedAttributeName)

(s/def
  :cognitect.aws.connect.UserProficiency/AttributeValue
  :cognitect.aws.connect/PredefinedAttributeStringValue)

(s/def :cognitect.aws.connect.UserProficiency/Level :cognitect.aws.connect/ProficiencyLevel)

(s/def
  :cognitect.aws.connect.ContactFlowNotPublishedException/Message
  :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.ListTrafficDistributionGroupsRequest/MaxResults
  :cognitect.aws.connect/MaxResult10)

(s/def
  :cognitect.aws.connect.ListTrafficDistributionGroupsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListTrafficDistributionGroupsRequest/InstanceId
  :cognitect.aws.connect/InstanceIdOrArn)

(s/def :cognitect.aws.connect.StringReference/Name :cognitect.aws.connect/ReferenceKey)

(s/def :cognitect.aws.connect.StringReference/Value :cognitect.aws.connect/ReferenceValue)

(s/def :cognitect.aws.connect.DescribeQueueRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DescribeQueueRequest/QueueId :cognitect.aws.connect/QueueId)

(s/def :cognitect.aws.connect.StartTaskContactResponse/ContactId :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.BatchPutContactResponse/SuccessfulRequestList
  :cognitect.aws.connect/SuccessfulRequestList)

(s/def
  :cognitect.aws.connect.BatchPutContactResponse/FailedRequestList
  :cognitect.aws.connect/FailedRequestList)

(s/def
  :cognitect.aws.connect.SearchableSegmentAttributesCriteria/Key
  :cognitect.aws.connect/SearchableSegmentAttributeKey)

(s/def
  :cognitect.aws.connect.SearchableSegmentAttributesCriteria/Values
  :cognitect.aws.connect/SearchableSegmentAttributeValueList)

(s/def
  :cognitect.aws.connect.StopContactRecordingRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StopContactRecordingRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StopContactRecordingRequest/InitialContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StopContactRecordingRequest/ContactRecordingType
  :cognitect.aws.connect/ContactRecordingType)

(s/def
  :cognitect.aws.connect.ListRoutingProfilesResponse/RoutingProfileSummaryList
  :cognitect.aws.connect/RoutingProfileSummaryList)

(s/def
  :cognitect.aws.connect.ListRoutingProfilesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.DisassociateLambdaFunctionRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DisassociateLambdaFunctionRequest/FunctionArn
  :cognitect.aws.connect/FunctionArn)

(s/def
  :cognitect.aws.connect.DisassociateLambdaFunctionRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.QueueSearchFilter/TagFilter
  :cognitect.aws.connect/ControlPlaneTagFilter)

(s/def
  :cognitect.aws.connect.DescribeSecurityProfileResponse/SecurityProfile
  :cognitect.aws.connect/SecurityProfile)

(s/def
  :cognitect.aws.connect.AssociateUserProficienciesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.AssociateUserProficienciesRequest/UserId
  :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.AssociateUserProficienciesRequest/UserProficiencies
  :cognitect.aws.connect/UserProficiencyList)

(s/def
  :cognitect.aws.connect.UserProficiencyDisassociate/AttributeName
  :cognitect.aws.connect/PredefinedAttributeName)

(s/def
  :cognitect.aws.connect.UserProficiencyDisassociate/AttributeValue
  :cognitect.aws.connect/PredefinedAttributeStringValue)

(s/def
  :cognitect.aws.connect.AssociateApprovedOriginRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.AssociateApprovedOriginRequest/Origin :cognitect.aws.connect/Origin)

(s/def
  :cognitect.aws.connect.AssociateApprovedOriginRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.SendOutboundEmailRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SendOutboundEmailRequest/FromEmailAddress
  :cognitect.aws.connect/EmailAddressInfo)

(s/def
  :cognitect.aws.connect.SendOutboundEmailRequest/DestinationEmailAddress
  :cognitect.aws.connect/EmailAddressInfo)

(s/def
  :cognitect.aws.connect.SendOutboundEmailRequest/AdditionalRecipients
  :cognitect.aws.connect/OutboundAdditionalRecipients)

(s/def
  :cognitect.aws.connect.SendOutboundEmailRequest/EmailMessage
  :cognitect.aws.connect/OutboundEmailContent)

(s/def
  :cognitect.aws.connect.SendOutboundEmailRequest/TrafficType
  :cognitect.aws.connect/TrafficType)

(s/def
  :cognitect.aws.connect.SendOutboundEmailRequest/SourceCampaign
  :cognitect.aws.connect/SourceCampaign)

(s/def
  :cognitect.aws.connect.SendOutboundEmailRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.DescribeContactResponse/Contact :cognitect.aws.connect/Contact)

(s/def :cognitect.aws.connect.QueueReference/Id :cognitect.aws.connect/QueueId)

(s/def :cognitect.aws.connect.QueueReference/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Step/Expiry :cognitect.aws.connect/Expiry)

(s/def :cognitect.aws.connect.Step/Expression :cognitect.aws.connect/Expression)

(s/def :cognitect.aws.connect.Step/Status :cognitect.aws.connect/RoutingCriteriaStepStatus)

(s/def
  :cognitect.aws.connect.ListAssociatedContactsResponse/ContactSummaryList
  :cognitect.aws.connect/AssociatedContactSummaryList)

(s/def
  :cognitect.aws.connect.ListAssociatedContactsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.UpdateUserSecurityProfilesRequest/SecurityProfileIds
  :cognitect.aws.connect/SecurityProfileIds)

(s/def
  :cognitect.aws.connect.UpdateUserSecurityProfilesRequest/UserId
  :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.UpdateUserSecurityProfilesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.InstanceStorageConfig/AssociationId
  :cognitect.aws.connect/AssociationId)

(s/def :cognitect.aws.connect.InstanceStorageConfig/StorageType :cognitect.aws.connect/StorageType)

(s/def :cognitect.aws.connect.InstanceStorageConfig/S3Config :cognitect.aws.connect/S3Config)

(s/def
  :cognitect.aws.connect.InstanceStorageConfig/KinesisVideoStreamConfig
  :cognitect.aws.connect/KinesisVideoStreamConfig)

(s/def
  :cognitect.aws.connect.InstanceStorageConfig/KinesisStreamConfig
  :cognitect.aws.connect/KinesisStreamConfig)

(s/def
  :cognitect.aws.connect.InstanceStorageConfig/KinesisFirehoseConfig
  :cognitect.aws.connect/KinesisFirehoseConfig)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/SupportedMessagingContentTypes
  :cognitect.aws.connect/SupportedMessagingContentTypes)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/SegmentAttributes
  :cognitect.aws.connect/SegmentAttributes)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/SourceEndpoint
  :cognitect.aws.connect/Endpoint)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/DestinationEndpoint
  :cognitect.aws.connect/Endpoint)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/InitialSystemMessage
  :cognitect.aws.connect/ChatMessage)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/ParticipantDetails
  :cognitect.aws.connect/ParticipantDetails)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/ChatDurationInMinutes
  :cognitect.aws.connect/ChatDurationInMinutes)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/RelatedContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactRequest/Attributes
  :cognitect.aws.connect/Attributes)

(s/def :cognitect.aws.connect.Rule/Function :cognitect.aws.connect/RuleFunction)

(s/def :cognitect.aws.connect.Rule/Actions :cognitect.aws.connect/RuleActions)

(s/def :cognitect.aws.connect.Rule/RuleArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Rule/LastUpdatedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.Rule/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.Rule/RuleId :cognitect.aws.connect/RuleId)

(s/def :cognitect.aws.connect.Rule/PublishStatus :cognitect.aws.connect/RulePublishStatus)

(s/def :cognitect.aws.connect.Rule/Name :cognitect.aws.connect/RuleName)

(s/def :cognitect.aws.connect.Rule/CreatedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.Rule/LastUpdatedBy :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Rule/TriggerEventSource :cognitect.aws.connect/RuleTriggerEventSource)

(s/def
  :cognitect.aws.connect.UserSearchCriteria/OrConditions
  :cognitect.aws.connect/UserSearchConditionList)

(s/def
  :cognitect.aws.connect.UserSearchCriteria/AndConditions
  :cognitect.aws.connect/UserSearchConditionList)

(s/def
  :cognitect.aws.connect.UserSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def :cognitect.aws.connect.UserSearchCriteria/ListCondition :cognitect.aws.connect/ListCondition)

(s/def
  :cognitect.aws.connect.UserSearchCriteria/HierarchyGroupCondition
  :cognitect.aws.connect/HierarchyGroupCondition)

(s/def :cognitect.aws.connect.EvaluationNote/Value :cognitect.aws.connect/EvaluationNoteString)

(s/def
  :cognitect.aws.connect.CreateIntegrationAssociationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateIntegrationAssociationRequest/IntegrationType
  :cognitect.aws.connect/IntegrationType)

(s/def
  :cognitect.aws.connect.CreateIntegrationAssociationRequest/IntegrationArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateIntegrationAssociationRequest/SourceApplicationUrl
  :cognitect.aws.connect/URI)

(s/def
  :cognitect.aws.connect.CreateIntegrationAssociationRequest/SourceApplicationName
  :cognitect.aws.connect/SourceApplicationName)

(s/def
  :cognitect.aws.connect.CreateIntegrationAssociationRequest/SourceType
  :cognitect.aws.connect/SourceType)

(s/def
  :cognitect.aws.connect.CreateIntegrationAssociationRequest/Tags
  :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.AttributeAndCondition/TagConditions
  :cognitect.aws.connect/TagAndConditionList)

(s/def
  :cognitect.aws.connect.AttributeAndCondition/HierarchyGroupCondition
  :cognitect.aws.connect/HierarchyGroupCondition)

(s/def :cognitect.aws.connect.RoutingProfileQueueReference/QueueId :cognitect.aws.connect/QueueId)

(s/def :cognitect.aws.connect.RoutingProfileQueueReference/Channel :cognitect.aws.connect/Channel)

(s/def
  :cognitect.aws.connect.BatchAssociateAnalyticsDataSetResponse/Created
  :cognitect.aws.connect/AnalyticsDataAssociationResults)

(s/def
  :cognitect.aws.connect.BatchAssociateAnalyticsDataSetResponse/Errors
  :cognitect.aws.connect/ErrorResults)

(s/def
  :cognitect.aws.connect.GetTrafficDistributionResponse/TelephonyConfig
  :cognitect.aws.connect/TelephonyConfig)

(s/def
  :cognitect.aws.connect.GetTrafficDistributionResponse/Id
  :cognitect.aws.connect/TrafficDistributionGroupId)

(s/def
  :cognitect.aws.connect.GetTrafficDistributionResponse/Arn
  :cognitect.aws.connect/TrafficDistributionGroupArn)

(s/def
  :cognitect.aws.connect.GetTrafficDistributionResponse/SignInConfig
  :cognitect.aws.connect/SignInConfig)

(s/def
  :cognitect.aws.connect.GetTrafficDistributionResponse/AgentConfig
  :cognitect.aws.connect/AgentConfig)

(s/def
  :cognitect.aws.connect.ListSecurityProfileApplicationsResponse/Applications
  :cognitect.aws.connect/Applications)

(s/def
  :cognitect.aws.connect.ListSecurityProfileApplicationsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListSecurityProfileApplicationsResponse/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.ListSecurityProfileApplicationsResponse/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.AssociateTrafficDistributionGroupUserRequest/TrafficDistributionGroupId
  :cognitect.aws.connect/TrafficDistributionGroupIdOrArn)

(s/def
  :cognitect.aws.connect.AssociateTrafficDistributionGroupUserRequest/UserId
  :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.AssociateTrafficDistributionGroupUserRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.AnswerMachineDetectionConfig/EnableAnswerMachineDetection
  :cognitect.aws.connect/Boolean)

(s/def
  :cognitect.aws.connect.AnswerMachineDetectionConfig/AwaitAnswerMachinePrompt
  :cognitect.aws.connect/Boolean)

(s/def :cognitect.aws.connect.ConnectionData/Attendee :cognitect.aws.connect/Attendee)

(s/def :cognitect.aws.connect.ConnectionData/Meeting :cognitect.aws.connect/Meeting)

(s/def
  :cognitect.aws.connect.DescribeInstanceStorageConfigRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeInstanceStorageConfigRequest/AssociationId
  :cognitect.aws.connect/AssociationId)

(s/def
  :cognitect.aws.connect.DescribeInstanceStorageConfigRequest/ResourceType
  :cognitect.aws.connect/InstanceStorageResourceType)

(s/def :cognitect.aws.connect.InvalidRequestException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.InvalidRequestException/Reason
  :cognitect.aws.connect/InvalidRequestExceptionReason)

(s/def
  :cognitect.aws.connect.UpdateContactFlowModuleContentRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowModuleContentRequest/ContactFlowModuleId
  :cognitect.aws.connect/ContactFlowModuleId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowModuleContentRequest/Content
  :cognitect.aws.connect/ContactFlowModuleContent)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemWithCharacterOffsets/Id
  :cognitect.aws.connect/RealTimeContactAnalysisId256)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemWithCharacterOffsets/CharacterOffsets
  :cognitect.aws.connect/RealTimeContactAnalysisCharacterInterval)

(s/def
  :cognitect.aws.connect.StartScreenSharingRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.StartScreenSharingRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.StartScreenSharingRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.AssignSlaActionDefinition/SlaAssignmentType
  :cognitect.aws.connect/SlaAssignmentType)

(s/def
  :cognitect.aws.connect.AssignSlaActionDefinition/CaseSlaConfiguration
  :cognitect.aws.connect/CaseSlaConfiguration)

(s/def :cognitect.aws.connect.AvailableNumberSummary/PhoneNumber :cognitect.aws.connect/PhoneNumber)

(s/def
  :cognitect.aws.connect.AvailableNumberSummary/PhoneNumberCountryCode
  :cognitect.aws.connect/PhoneNumberCountryCode)

(s/def
  :cognitect.aws.connect.AvailableNumberSummary/PhoneNumberType
  :cognitect.aws.connect/PhoneNumberType)

(s/def
  :cognitect.aws.connect.CreatePushNotificationRegistrationResponse/RegistrationId
  :cognitect.aws.connect/RegistrationId)

(s/def
  :cognitect.aws.connect.ListInstanceAttributesResponse/Attributes
  :cognitect.aws.connect/AttributesList)

(s/def
  :cognitect.aws.connect.ListInstanceAttributesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.StartContactStreamingResponse/StreamingId
  :cognitect.aws.connect/StreamingId)

(s/def
  :cognitect.aws.connect.ChatStreamingConfiguration/StreamingEndpointArn
  :cognitect.aws.connect/ChatStreamingEndpointARN)

(s/def
  :cognitect.aws.connect.AssociateQueueQuickConnectsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.AssociateQueueQuickConnectsRequest/QueueId
  :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.AssociateQueueQuickConnectsRequest/QuickConnectIds
  :cognitect.aws.connect/QuickConnectsList)

(s/def
  :cognitect.aws.connect.GetCurrentMetricDataResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.GetCurrentMetricDataResponse/MetricResults
  :cognitect.aws.connect/CurrentMetricResults)

(s/def
  :cognitect.aws.connect.GetCurrentMetricDataResponse/DataSnapshotTime
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.GetCurrentMetricDataResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.Campaign/CampaignId :cognitect.aws.connect/CampaignId)

(s/def
  :cognitect.aws.connect.DeactivateEvaluationFormRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeactivateEvaluationFormRequest/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.DeactivateEvaluationFormRequest/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.ContactSearchSummary/InitialContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ContactSearchSummary/QueueInfo
  :cognitect.aws.connect/ContactSearchSummaryQueueInfo)

(s/def
  :cognitect.aws.connect.ContactSearchSummary/PreviousContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ContactSearchSummary/SegmentAttributes
  :cognitect.aws.connect/ContactSearchSummarySegmentAttributes)

(s/def
  :cognitect.aws.connect.ContactSearchSummary/AgentInfo
  :cognitect.aws.connect/ContactSearchSummaryAgentInfo)

(s/def :cognitect.aws.connect.ContactSearchSummary/Id :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.ContactSearchSummary/Channel :cognitect.aws.connect/Channel)

(s/def
  :cognitect.aws.connect.ContactSearchSummary/DisconnectTimestamp
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.ContactSearchSummary/ScheduledTimestamp
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.ContactSearchSummary/InitiationMethod
  :cognitect.aws.connect/ContactInitiationMethod)

(s/def :cognitect.aws.connect.ContactSearchSummary/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ContactSearchSummary/InitiationTimestamp
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.ListEvaluationFormVersionsResponse/EvaluationFormVersionSummaryList
  :cognitect.aws.connect/EvaluationFormVersionSummaryList)

(s/def
  :cognitect.aws.connect.ListEvaluationFormVersionsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ProblemDetail/message :cognitect.aws.connect/ProblemMessageString)

(s/def
  :cognitect.aws.connect.ListDefaultVocabulariesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListDefaultVocabulariesRequest/LanguageCode
  :cognitect.aws.connect/VocabularyLanguageCode)

(s/def
  :cognitect.aws.connect.ListDefaultVocabulariesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.ListDefaultVocabulariesRequest/NextToken
  :cognitect.aws.connect/VocabularyNextToken)

(s/def
  :cognitect.aws.connect.DeactivateEvaluationFormResponse/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.DeactivateEvaluationFormResponse/EvaluationFormArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.DeactivateEvaluationFormResponse/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.RuleTriggerEventSource/EventSourceName
  :cognitect.aws.connect/EventSourceName)

(s/def
  :cognitect.aws.connect.RuleTriggerEventSource/IntegrationAssociationId
  :cognitect.aws.connect/IntegrationAssociationId)

(s/def :cognitect.aws.connect.ContactNotFoundException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.DescribeEvaluationFormResponse/EvaluationForm
  :cognitect.aws.connect/EvaluationForm)

(s/def
  :cognitect.aws.connect.ListIntegrationAssociationsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListIntegrationAssociationsRequest/IntegrationType
  :cognitect.aws.connect/IntegrationType)

(s/def
  :cognitect.aws.connect.ListIntegrationAssociationsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListIntegrationAssociationsRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.ListIntegrationAssociationsRequest/IntegrationArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileRequest/HierarchyRestrictedResources
  :cognitect.aws.connect/HierarchyRestrictedResourceList)

(s/def :cognitect.aws.connect.CreateSecurityProfileRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileRequest/AllowedAccessControlHierarchyGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileRequest/Applications
  :cognitect.aws.connect/Applications)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileRequest/Permissions
  :cognitect.aws.connect/PermissionsList)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileRequest/AllowedAccessControlTags
  :cognitect.aws.connect/AllowedAccessControlTags)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileRequest/SecurityProfileName
  :cognitect.aws.connect/CreateSecurityProfileName)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileRequest/TagRestrictedResources
  :cognitect.aws.connect/TagRestrictedResourceList)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileRequest/Description
  :cognitect.aws.connect/SecurityProfileDescription)

(s/def
  :cognitect.aws.connect.DeleteIntegrationAssociationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteIntegrationAssociationRequest/IntegrationAssociationId
  :cognitect.aws.connect/IntegrationAssociationId)

(s/def
  :cognitect.aws.connect.ListPromptsResponse/PromptSummaryList
  :cognitect.aws.connect/PromptSummaryList)

(s/def :cognitect.aws.connect.ListPromptsResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListRoutingProfileQueuesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListRoutingProfileQueuesRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def
  :cognitect.aws.connect.ListRoutingProfileQueuesRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListRoutingProfileQueuesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.UserSearchSummary/IdentityInfo
  :cognitect.aws.connect/UserIdentityInfoLite)

(s/def
  :cognitect.aws.connect.UserSearchSummary/SecurityProfileIds
  :cognitect.aws.connect/SecurityProfileIds)

(s/def :cognitect.aws.connect.UserSearchSummary/Id :cognitect.aws.connect/UserId)

(s/def :cognitect.aws.connect.UserSearchSummary/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.UserSearchSummary/DirectoryUserId
  :cognitect.aws.connect/DirectoryUserId)

(s/def
  :cognitect.aws.connect.UserSearchSummary/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def :cognitect.aws.connect.UserSearchSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.UserSearchSummary/PhoneConfig :cognitect.aws.connect/UserPhoneConfig)

(s/def :cognitect.aws.connect.UserSearchSummary/Username :cognitect.aws.connect/AgentUsername)

(s/def
  :cognitect.aws.connect.UserSearchSummary/HierarchyGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/References
  :cognitect.aws.connect/ContactReferences)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/AnswerMachineDetectionConfig
  :cognitect.aws.connect/AnswerMachineDetectionConfig)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/QueueId
  :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/DestinationPhoneNumber
  :cognitect.aws.connect/PhoneNumber)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/SourcePhoneNumber
  :cognitect.aws.connect/PhoneNumber)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/TrafficType
  :cognitect.aws.connect/TrafficType)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/RelatedContactId
  :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.StartOutboundVoiceContactRequest/Name :cognitect.aws.connect/Name)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/Description
  :cognitect.aws.connect/Description)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/Attributes
  :cognitect.aws.connect/Attributes)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactRequest/CampaignId
  :cognitect.aws.connect/CampaignId)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverrideConfig/Day
  :cognitect.aws.connect/OverrideDays)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverrideConfig/StartTime
  :cognitect.aws.connect/OverrideTimeSlice)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverrideConfig/EndTime
  :cognitect.aws.connect/OverrideTimeSlice)

(s/def :cognitect.aws.connect.KinesisStreamConfig/StreamArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationRequest/Name
  :cognitect.aws.connect/CommonNameLength127)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationRequest/Description
  :cognitect.aws.connect/HoursOfOperationDescription)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationRequest/TimeZone
  :cognitect.aws.connect/TimeZone)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationRequest/Config
  :cognitect.aws.connect/HoursOfOperationConfigList)

(s/def :cognitect.aws.connect.CreateHoursOfOperationRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.UpdateContactFlowNameRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowNameRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowNameRequest/Name
  :cognitect.aws.connect/ContactFlowName)

(s/def
  :cognitect.aws.connect.UpdateContactFlowNameRequest/Description
  :cognitect.aws.connect/ContactFlowDescription)

(s/def :cognitect.aws.connect.ActionSummary/ActionType :cognitect.aws.connect/ActionType)

(s/def
  :cognitect.aws.connect.SearchPredefinedAttributesResponse/PredefinedAttributes
  :cognitect.aws.connect/PredefinedAttributeSearchSummaryList)

(s/def
  :cognitect.aws.connect.SearchPredefinedAttributesResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchPredefinedAttributesResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.UserSummary/Id :cognitect.aws.connect/UserId)

(s/def :cognitect.aws.connect.UserSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.UserSummary/Username :cognitect.aws.connect/AgentUsername)

(s/def :cognitect.aws.connect.UserSummary/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.UserSummary/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.SourceCampaign/CampaignId :cognitect.aws.connect/CampaignId)

(s/def
  :cognitect.aws.connect.SourceCampaign/OutboundRequestId
  :cognitect.aws.connect/OutboundRequestId)

(s/def
  :cognitect.aws.connect.UpdateContactScheduleRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateContactScheduleRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.UpdateContactScheduleRequest/ScheduledTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.DeleteHoursOfOperationOverrideRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteHoursOfOperationOverrideRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def
  :cognitect.aws.connect.DeleteHoursOfOperationOverrideRequest/HoursOfOperationOverrideId
  :cognitect.aws.connect/HoursOfOperationOverrideId)

(s/def
  :cognitect.aws.connect.ContactFlowSearchCriteria/OrConditions
  :cognitect.aws.connect/ContactFlowSearchConditionList)

(s/def
  :cognitect.aws.connect.ContactFlowSearchCriteria/AndConditions
  :cognitect.aws.connect/ContactFlowSearchConditionList)

(s/def
  :cognitect.aws.connect.ContactFlowSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def
  :cognitect.aws.connect.ContactFlowSearchCriteria/TypeCondition
  :cognitect.aws.connect/ContactFlowType)

(s/def
  :cognitect.aws.connect.ContactFlowSearchCriteria/StateCondition
  :cognitect.aws.connect/ContactFlowState)

(s/def
  :cognitect.aws.connect.ContactFlowSearchCriteria/StatusCondition
  :cognitect.aws.connect/ContactFlowStatus)

(s/def
  :cognitect.aws.connect.FailedRequest/RequestIdentifier
  :cognitect.aws.connect/RequestIdentifier)

(s/def
  :cognitect.aws.connect.FailedRequest/FailureReasonCode
  :cognitect.aws.connect/FailureReasonCode)

(s/def :cognitect.aws.connect.FailedRequest/FailureReasonMessage :cognitect.aws.connect/String)

(s/def :cognitect.aws.connect.ListBotsRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListBotsRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ListBotsRequest/MaxResults :cognitect.aws.connect/MaxResult25)

(s/def :cognitect.aws.connect.ListBotsRequest/LexVersion :cognitect.aws.connect/LexVersion)

(s/def :cognitect.aws.connect.CreateViewVersionResponse/View :cognitect.aws.connect/View)

(s/def
  :cognitect.aws.connect.UpdateContactEvaluationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateContactEvaluationRequest/EvaluationId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.UpdateContactEvaluationRequest/Answers
  :cognitect.aws.connect/EvaluationAnswersInputMap)

(s/def
  :cognitect.aws.connect.UpdateContactEvaluationRequest/Notes
  :cognitect.aws.connect/EvaluationNotesMap)

(s/def
  :cognitect.aws.connect.OutboundAdditionalRecipients/CcEmailAddresses
  :cognitect.aws.connect/EmailAddressRecipientList)

(s/def :cognitect.aws.connect.MonitorContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.MonitorContactRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.MonitorContactRequest/UserId :cognitect.aws.connect/AgentResourceId)

(s/def
  :cognitect.aws.connect.MonitorContactRequest/AllowedMonitorCapabilities
  :cognitect.aws.connect/AllowedMonitorCapabilities)

(s/def :cognitect.aws.connect.MonitorContactRequest/ClientToken :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.CreateEmailAddressResponse/EmailAddressId
  :cognitect.aws.connect/EmailAddressId)

(s/def
  :cognitect.aws.connect.CreateEmailAddressResponse/EmailAddressArn
  :cognitect.aws.connect/EmailAddressArn)

(s/def :cognitect.aws.connect.TemplateAttributes/CustomAttributes :cognitect.aws.connect/Attributes)

(s/def
  :cognitect.aws.connect.TemplateAttributes/CustomerProfileAttributes
  :cognitect.aws.connect/CustomerProfileAttributesSerialized)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationOverridesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationOverridesRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationOverridesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationOverridesRequest/SearchFilter
  :cognitect.aws.connect/HoursOfOperationSearchFilter)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationOverridesRequest/SearchCriteria
  :cognitect.aws.connect/HoursOfOperationOverrideSearchCriteria)

(s/def
  :cognitect.aws.connect.ListLambdaFunctionsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListLambdaFunctionsRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListLambdaFunctionsRequest/MaxResults
  :cognitect.aws.connect/MaxResult25)

(s/def
  :cognitect.aws.connect.ListContactFlowsResponse/ContactFlowSummaryList
  :cognitect.aws.connect/ContactFlowSummaryList)

(s/def :cognitect.aws.connect.ListContactFlowsResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.Endpoint/Type :cognitect.aws.connect/EndpointType)

(s/def :cognitect.aws.connect.Endpoint/Address :cognitect.aws.connect/EndpointAddress)

(s/def :cognitect.aws.connect.MatchCriteria/AgentsCriteria :cognitect.aws.connect/AgentsCriteria)

(s/def :cognitect.aws.connect.DestinationNotAllowedException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.DescribeAgentStatusRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeAgentStatusRequest/AgentStatusId
  :cognitect.aws.connect/AgentStatusId)

(s/def
  :cognitect.aws.connect.DescribeRoutingProfileResponse/RoutingProfile
  :cognitect.aws.connect/RoutingProfile)

(s/def :cognitect.aws.connect.ListViewsRequest/InstanceId :cognitect.aws.connect/ViewsInstanceId)

(s/def :cognitect.aws.connect.ListViewsRequest/Type :cognitect.aws.connect/ViewType)

(s/def :cognitect.aws.connect.ListViewsRequest/NextToken :cognitect.aws.connect/ViewsNextToken)

(s/def :cognitect.aws.connect.ListViewsRequest/MaxResults :cognitect.aws.connect/MaxResults)

(s/def :cognitect.aws.connect.UpdateViewContentResponse/View :cognitect.aws.connect/View)

(s/def
  :cognitect.aws.connect.UpdateParticipantRoleConfigRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateParticipantRoleConfigRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.UpdateParticipantRoleConfigRequest/ChannelConfiguration
  :cognitect.aws.connect/UpdateParticipantRoleConfigChannelInfo)

(s/def
  :cognitect.aws.connect.ListApprovedOriginsResponse/Origins
  :cognitect.aws.connect/OriginsList)

(s/def
  :cognitect.aws.connect.ListApprovedOriginsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.StartOutboundEmailContactResponse/ContactId
  :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.ViewSummary/Id :cognitect.aws.connect/ViewId)

(s/def :cognitect.aws.connect.ViewSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.ViewSummary/Name :cognitect.aws.connect/ViewName)

(s/def :cognitect.aws.connect.ViewSummary/Type :cognitect.aws.connect/ViewType)

(s/def :cognitect.aws.connect.ViewSummary/Status :cognitect.aws.connect/ViewStatus)

(s/def :cognitect.aws.connect.ViewSummary/Description :cognitect.aws.connect/ViewDescription)

(s/def :cognitect.aws.connect.InboundRawMessage/Subject :cognitect.aws.connect/InboundSubject)

(s/def :cognitect.aws.connect.InboundRawMessage/Body :cognitect.aws.connect/Body)

(s/def
  :cognitect.aws.connect.InboundRawMessage/ContentType
  :cognitect.aws.connect/EmailMessageContentType)

(s/def :cognitect.aws.connect.InboundRawMessage/Headers :cognitect.aws.connect/EmailHeaders)

(s/def :cognitect.aws.connect.OverrideTimeSlice/Hours :cognitect.aws.connect/Hours24Format)

(s/def :cognitect.aws.connect.OverrideTimeSlice/Minutes :cognitect.aws.connect/MinutesLimit60)

(s/def :cognitect.aws.connect.EmailAddressInfo/EmailAddress :cognitect.aws.connect/EmailAddress)

(s/def
  :cognitect.aws.connect.EmailAddressInfo/DisplayName
  :cognitect.aws.connect/EmailAddressDisplayName)

(s/def :cognitect.aws.connect.MetricFilterV2/MetricFilterKey :cognitect.aws.connect/String)

(s/def
  :cognitect.aws.connect.MetricFilterV2/MetricFilterValues
  :cognitect.aws.connect/MetricFilterValueList)

(s/def :cognitect.aws.connect.MetricFilterV2/Negate :cognitect.aws.connect/Boolean)

(s/def
  :cognitect.aws.connect.DescribeEmailAddressRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeEmailAddressRequest/EmailAddressId
  :cognitect.aws.connect/EmailAddressId)

(s/def :cognitect.aws.connect.ListContactFlowsRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListContactFlowsRequest/ContactFlowTypes
  :cognitect.aws.connect/ContactFlowTypes)

(s/def :cognitect.aws.connect.ListContactFlowsRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListContactFlowsRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.UpdateQueueMaxContactsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.UpdateQueueMaxContactsRequest/QueueId :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.UpdateQueueMaxContactsRequest/MaxContacts
  :cognitect.aws.connect/QueueMaxContacts)

(s/def :cognitect.aws.connect.HierarchyGroup/Id :cognitect.aws.connect/HierarchyGroupId)

(s/def :cognitect.aws.connect.HierarchyGroup/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.HierarchyGroup/Name :cognitect.aws.connect/HierarchyGroupName)

(s/def :cognitect.aws.connect.HierarchyGroup/LevelId :cognitect.aws.connect/HierarchyLevelId)

(s/def :cognitect.aws.connect.HierarchyGroup/HierarchyPath :cognitect.aws.connect/HierarchyPath)

(s/def :cognitect.aws.connect.HierarchyGroup/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.HierarchyGroup/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.HierarchyGroup/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.CreateTaskTemplateResponse/Id :cognitect.aws.connect/TaskTemplateId)

(s/def :cognitect.aws.connect.CreateTaskTemplateResponse/Arn :cognitect.aws.connect/TaskTemplateArn)

(s/def :cognitect.aws.connect.GetMetricDataV2Request/EndTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.GetMetricDataV2Request/Groupings :cognitect.aws.connect/GroupingsV2)

(s/def :cognitect.aws.connect.GetMetricDataV2Request/NextToken :cognitect.aws.connect/NextToken2500)

(s/def :cognitect.aws.connect.GetMetricDataV2Request/Metrics :cognitect.aws.connect/MetricsV2)

(s/def
  :cognitect.aws.connect.GetMetricDataV2Request/Interval
  :cognitect.aws.connect/IntervalDetails)

(s/def :cognitect.aws.connect.GetMetricDataV2Request/StartTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.GetMetricDataV2Request/MaxResults :cognitect.aws.connect/MaxResult100)

(s/def :cognitect.aws.connect.GetMetricDataV2Request/ResourceArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.GetMetricDataV2Request/Filters :cognitect.aws.connect/FiltersV2List)

(s/def
  :cognitect.aws.connect.UpdateUserHierarchyGroupNameRequest/Name
  :cognitect.aws.connect/HierarchyGroupName)

(s/def
  :cognitect.aws.connect.UpdateUserHierarchyGroupNameRequest/HierarchyGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def
  :cognitect.aws.connect.UpdateUserHierarchyGroupNameRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.RoutingProfileSearchCriteria/OrConditions
  :cognitect.aws.connect/RoutingProfileSearchConditionList)

(s/def
  :cognitect.aws.connect.RoutingProfileSearchCriteria/AndConditions
  :cognitect.aws.connect/RoutingProfileSearchConditionList)

(s/def
  :cognitect.aws.connect.RoutingProfileSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def :cognitect.aws.connect.UserDataFilters/Queues :cognitect.aws.connect/Queues)

(s/def :cognitect.aws.connect.UserDataFilters/ContactFilter :cognitect.aws.connect/ContactFilter)

(s/def
  :cognitect.aws.connect.UserDataFilters/RoutingProfiles
  :cognitect.aws.connect/RoutingProfiles)

(s/def :cognitect.aws.connect.UserDataFilters/Agents :cognitect.aws.connect/AgentsMinOneMaxHundred)

(s/def
  :cognitect.aws.connect.UserDataFilters/UserHierarchyGroups
  :cognitect.aws.connect/UserDataHierarchyGroups)

(s/def
  :cognitect.aws.connect.ContactFlowModuleSearchCriteria/OrConditions
  :cognitect.aws.connect/ContactFlowModuleSearchConditionList)

(s/def
  :cognitect.aws.connect.ContactFlowModuleSearchCriteria/AndConditions
  :cognitect.aws.connect/ContactFlowModuleSearchConditionList)

(s/def
  :cognitect.aws.connect.ContactFlowModuleSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def
  :cognitect.aws.connect.ContactFlowModuleSearchCriteria/StateCondition
  :cognitect.aws.connect/ContactFlowModuleState)

(s/def
  :cognitect.aws.connect.ContactFlowModuleSearchCriteria/StatusCondition
  :cognitect.aws.connect/ContactFlowModuleStatus)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroupSummary/Id
  :cognitect.aws.connect/TrafficDistributionGroupId)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroupSummary/Arn
  :cognitect.aws.connect/TrafficDistributionGroupArn)

(s/def :cognitect.aws.connect.TrafficDistributionGroupSummary/Name :cognitect.aws.connect/Name128)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroupSummary/InstanceArn
  :cognitect.aws.connect/InstanceArn)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroupSummary/Status
  :cognitect.aws.connect/TrafficDistributionGroupStatus)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroupSummary/IsDefault
  :cognitect.aws.connect/Boolean)

(s/def :cognitect.aws.connect.GetAttachedFileResponse/FileArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.GetAttachedFileResponse/FileSizeInBytes
  :cognitect.aws.connect/FileSizeInBytes)

(s/def :cognitect.aws.connect.GetAttachedFileResponse/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.GetAttachedFileResponse/CreatedBy
  :cognitect.aws.connect/CreatedByInfo)

(s/def
  :cognitect.aws.connect.GetAttachedFileResponse/FileStatus
  :cognitect.aws.connect/FileStatusType)

(s/def :cognitect.aws.connect.GetAttachedFileResponse/FileId :cognitect.aws.connect/FileId)

(s/def
  :cognitect.aws.connect.GetAttachedFileResponse/DownloadUrlMetadata
  :cognitect.aws.connect/DownloadUrlMetadata)

(s/def
  :cognitect.aws.connect.GetAttachedFileResponse/CreationTime
  :cognitect.aws.connect/ISO8601Datetime)

(s/def
  :cognitect.aws.connect.GetAttachedFileResponse/AssociatedResourceArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.GetAttachedFileResponse/FileUseCaseType
  :cognitect.aws.connect/FileUseCaseType)

(s/def :cognitect.aws.connect.GetAttachedFileResponse/FileName :cognitect.aws.connect/FileName)

(s/def
  :cognitect.aws.connect.PromptSearchFilter/TagFilter
  :cognitect.aws.connect/ControlPlaneTagFilter)

(s/def :cognitect.aws.connect.DateReference/Name :cognitect.aws.connect/ReferenceKey)

(s/def :cognitect.aws.connect.DateReference/Value :cognitect.aws.connect/ReferenceValue)

(s/def
  :cognitect.aws.connect.UpdateUserHierarchyRequest/HierarchyGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def :cognitect.aws.connect.UpdateUserHierarchyRequest/UserId :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.UpdateUserHierarchyRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateViewContentRequest/InstanceId
  :cognitect.aws.connect/ViewsInstanceId)

(s/def :cognitect.aws.connect.UpdateViewContentRequest/ViewId :cognitect.aws.connect/ViewId)

(s/def :cognitect.aws.connect.UpdateViewContentRequest/Status :cognitect.aws.connect/ViewStatus)

(s/def
  :cognitect.aws.connect.UpdateViewContentRequest/Content
  :cognitect.aws.connect/ViewInputContent)

(s/def :cognitect.aws.connect.DescribeQueueResponse/Queue :cognitect.aws.connect/Queue)

(s/def
  :cognitect.aws.connect.ListSecurityProfilePermissionsResponse/Permissions
  :cognitect.aws.connect/PermissionsList)

(s/def
  :cognitect.aws.connect.ListSecurityProfilePermissionsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListSecurityProfilePermissionsResponse/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.ListSecurityProfilePermissionsResponse/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.ContactConfiguration/ContactId :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ContactConfiguration/ParticipantRole
  :cognitect.aws.connect/ParticipantRole)

(s/def
  :cognitect.aws.connect.ContactConfiguration/IncludeRawMessage
  :cognitect.aws.connect/IncludeRawMessage)

(s/def
  :cognitect.aws.connect.AssociateInstanceStorageConfigRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.AssociateInstanceStorageConfigRequest/ResourceType
  :cognitect.aws.connect/InstanceStorageResourceType)

(s/def
  :cognitect.aws.connect.AssociateInstanceStorageConfigRequest/StorageConfig
  :cognitect.aws.connect/InstanceStorageConfig)

(s/def
  :cognitect.aws.connect.AssociateInstanceStorageConfigRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.AnalyticsDataSetsResult/DataSetId :cognitect.aws.connect/DataSetId)

(s/def :cognitect.aws.connect.AnalyticsDataSetsResult/DataSetName :cognitect.aws.connect/String)

(s/def :cognitect.aws.connect.SearchUsersRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.SearchUsersRequest/NextToken :cognitect.aws.connect/NextToken2500)

(s/def :cognitect.aws.connect.SearchUsersRequest/MaxResults :cognitect.aws.connect/MaxResult500)

(s/def
  :cognitect.aws.connect.SearchUsersRequest/SearchFilter
  :cognitect.aws.connect/UserSearchFilter)

(s/def
  :cognitect.aws.connect.SearchUsersRequest/SearchCriteria
  :cognitect.aws.connect/UserSearchCriteria)

(s/def
  :cognitect.aws.connect.DeleteContactFlowVersionRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteContactFlowVersionRequest/ContactFlowId
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.DeleteContactFlowVersionRequest/ContactFlowVersion
  :cognitect.aws.connect/ResourceVersion)

(s/def
  :cognitect.aws.connect.InvisibleFieldInfo/Id
  :cognitect.aws.connect/TaskTemplateFieldIdentifier)

(s/def
  :cognitect.aws.connect.StartContactStreamingRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartContactStreamingRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartContactStreamingRequest/ChatStreamingConfiguration
  :cognitect.aws.connect/ChatStreamingConfiguration)

(s/def
  :cognitect.aws.connect.StartContactStreamingRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.RealtimeContactAnalysisSegment/Transcript
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentTranscript)

(s/def
  :cognitect.aws.connect.RealtimeContactAnalysisSegment/Categories
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentCategories)

(s/def
  :cognitect.aws.connect.RealtimeContactAnalysisSegment/Issues
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentIssues)

(s/def
  :cognitect.aws.connect.RealtimeContactAnalysisSegment/Event
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentEvent)

(s/def
  :cognitect.aws.connect.RealtimeContactAnalysisSegment/Attachments
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentAttachments)

(s/def
  :cognitect.aws.connect.RealtimeContactAnalysisSegment/PostContactSummary
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentPostContactSummary)

(s/def :cognitect.aws.connect.AgentStatusSummary/Id :cognitect.aws.connect/AgentStatusId)

(s/def :cognitect.aws.connect.AgentStatusSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.AgentStatusSummary/Name :cognitect.aws.connect/AgentStatusName)

(s/def :cognitect.aws.connect.AgentStatusSummary/Type :cognitect.aws.connect/AgentStatusType)

(s/def :cognitect.aws.connect.AgentStatusSummary/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.AgentStatusSummary/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentIssues/IssuesDetected
  :cognitect.aws.connect/RealTimeContactAnalysisIssuesDetected)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisCategoryDetails/PointsOfInterest
  :cognitect.aws.connect/RealTimeContactAnalysisPointsOfInterest)

(s/def :cognitect.aws.connect.DeletePromptRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DeletePromptRequest/PromptId :cognitect.aws.connect/PromptId)

(s/def
  :cognitect.aws.connect.OutboundEmailContent/MessageSourceType
  :cognitect.aws.connect/OutboundMessageSourceType)

(s/def
  :cognitect.aws.connect.OutboundEmailContent/TemplatedMessageConfig
  :cognitect.aws.connect/TemplatedMessageConfig)

(s/def
  :cognitect.aws.connect.OutboundEmailContent/RawMessage
  :cognitect.aws.connect/OutboundRawMessage)

(s/def :cognitect.aws.connect.EncryptionConfig/EncryptionType :cognitect.aws.connect/EncryptionType)

(s/def :cognitect.aws.connect.EncryptionConfig/KeyId :cognitect.aws.connect/KeyId)

(s/def :cognitect.aws.connect.MetricDataV2/Metric :cognitect.aws.connect/MetricV2)

(s/def :cognitect.aws.connect.MetricDataV2/Value :cognitect.aws.connect/Value)

(s/def
  :cognitect.aws.connect.RoutingCriteriaInputStep/Expiry
  :cognitect.aws.connect/RoutingCriteriaInputStepExpiry)

(s/def :cognitect.aws.connect.RoutingCriteriaInputStep/Expression :cognitect.aws.connect/Expression)

(s/def :cognitect.aws.connect.NumberCondition/FieldName :cognitect.aws.connect/String)

(s/def
  :cognitect.aws.connect.NumberCondition/MinValue
  :cognitect.aws.connect/NullableProficiencyLimitValue)

(s/def
  :cognitect.aws.connect.NumberCondition/MaxValue
  :cognitect.aws.connect/NullableProficiencyLimitValue)

(s/def
  :cognitect.aws.connect.NumberCondition/ComparisonType
  :cognitect.aws.connect/NumberComparisonType)

(s/def
  :cognitect.aws.connect.StartChatContactRequest/SupportedMessagingContentTypes
  :cognitect.aws.connect/SupportedMessagingContentTypes)

(s/def
  :cognitect.aws.connect.StartChatContactRequest/SegmentAttributes
  :cognitect.aws.connect/SegmentAttributes)

(s/def
  :cognitect.aws.connect.StartChatContactRequest/InitialMessage
  :cognitect.aws.connect/ChatMessage)

(s/def
  :cognitect.aws.connect.StartChatContactRequest/CustomerId
  :cognitect.aws.connect/CustomerIdNonEmpty)

(s/def :cognitect.aws.connect.StartChatContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartChatContactRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.StartChatContactRequest/ParticipantDetails
  :cognitect.aws.connect/ParticipantDetails)

(s/def
  :cognitect.aws.connect.StartChatContactRequest/ChatDurationInMinutes
  :cognitect.aws.connect/ChatDurationInMinutes)

(s/def
  :cognitect.aws.connect.StartChatContactRequest/RelatedContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartChatContactRequest/PersistentChat
  :cognitect.aws.connect/PersistentChat)

(s/def
  :cognitect.aws.connect.StartChatContactRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.StartChatContactRequest/Attributes :cognitect.aws.connect/Attributes)

(s/def
  :cognitect.aws.connect.DeleteTrafficDistributionGroupRequest/TrafficDistributionGroupId
  :cognitect.aws.connect/TrafficDistributionGroupIdOrArn)

(s/def :cognitect.aws.connect.AccessDeniedException/Message :cognitect.aws.connect/Message)

(s/def :cognitect.aws.connect.ViewVersionSummary/Id :cognitect.aws.connect/ViewId)

(s/def :cognitect.aws.connect.ViewVersionSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.ViewVersionSummary/Description :cognitect.aws.connect/ViewDescription)

(s/def :cognitect.aws.connect.ViewVersionSummary/Name :cognitect.aws.connect/ViewName)

(s/def :cognitect.aws.connect.ViewVersionSummary/Type :cognitect.aws.connect/ViewType)

(s/def :cognitect.aws.connect.ViewVersionSummary/Version :cognitect.aws.connect/ViewVersion)

(s/def
  :cognitect.aws.connect.ViewVersionSummary/VersionDescription
  :cognitect.aws.connect/ViewDescription)

(s/def :cognitect.aws.connect.GetPromptFileRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.GetPromptFileRequest/PromptId :cognitect.aws.connect/PromptId)

(s/def :cognitect.aws.connect.DismissUserContactRequest/UserId :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.DismissUserContactRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DismissUserContactRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.Distribution/Region :cognitect.aws.connect/AwsRegion)

(s/def :cognitect.aws.connect.Distribution/Percentage :cognitect.aws.connect/Percentage)

(s/def
  :cognitect.aws.connect.UpdatePhoneNumberMetadataRequest/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def
  :cognitect.aws.connect.UpdatePhoneNumberMetadataRequest/PhoneNumberDescription
  :cognitect.aws.connect/PhoneNumberDescription)

(s/def
  :cognitect.aws.connect.UpdatePhoneNumberMetadataRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.AssociatedContactSummary/InitialContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.AssociatedContactSummary/PreviousContactId
  :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.AssociatedContactSummary/Channel :cognitect.aws.connect/Channel)

(s/def
  :cognitect.aws.connect.AssociatedContactSummary/DisconnectTimestamp
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.AssociatedContactSummary/RelatedContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.AssociatedContactSummary/InitiationMethod
  :cognitect.aws.connect/ContactInitiationMethod)

(s/def :cognitect.aws.connect.AssociatedContactSummary/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.AssociatedContactSummary/ContactArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.AssociatedContactSummary/InitiationTimestamp
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.AudioFeatures/EchoReduction
  :cognitect.aws.connect/MeetingFeatureStatus)

(s/def :cognitect.aws.connect.ListPhoneNumbersRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersRequest/PhoneNumberTypes
  :cognitect.aws.connect/PhoneNumberTypes)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersRequest/PhoneNumberCountryCodes
  :cognitect.aws.connect/PhoneNumberCountryCodes)

(s/def :cognitect.aws.connect.ListPhoneNumbersRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.ReplicateInstanceRequest/InstanceId
  :cognitect.aws.connect/InstanceIdOrArn)

(s/def
  :cognitect.aws.connect.ReplicateInstanceRequest/ReplicaRegion
  :cognitect.aws.connect/AwsRegion)

(s/def
  :cognitect.aws.connect.ReplicateInstanceRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.ReplicateInstanceRequest/ReplicaAlias
  :cognitect.aws.connect/DirectoryAlias)

(s/def :cognitect.aws.connect.AgentInfo/HierarchyGroups :cognitect.aws.connect/HierarchyGroups)

(s/def
  :cognitect.aws.connect.AgentInfo/AfterContactWorkStartTimestamp
  :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.AgentInfo/Id :cognitect.aws.connect/AgentResourceId)

(s/def :cognitect.aws.connect.AgentInfo/AgentInitiatedHoldDuration :cognitect.aws.connect/Duration)

(s/def :cognitect.aws.connect.AgentInfo/DeviceInfo :cognitect.aws.connect/DeviceInfo)

(s/def :cognitect.aws.connect.AgentInfo/StateTransitions :cognitect.aws.connect/StateTransitions)

(s/def
  :cognitect.aws.connect.AgentInfo/AfterContactWorkEndTimestamp
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.AgentInfo/AgentPauseDurationInSeconds
  :cognitect.aws.connect/AgentPauseDurationInSeconds)

(s/def :cognitect.aws.connect.AgentInfo/Capabilities :cognitect.aws.connect/ParticipantCapabilities)

(s/def :cognitect.aws.connect.AgentInfo/AfterContactWorkDuration :cognitect.aws.connect/Duration)

(s/def :cognitect.aws.connect.AgentInfo/ConnectedToAgentTimestamp :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.UpdateContactRoutingDataRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateContactRoutingDataRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.UpdateContactRoutingDataRequest/QueueTimeAdjustmentSeconds
  :cognitect.aws.connect/QueueTimeAdjustmentSeconds)

(s/def
  :cognitect.aws.connect.UpdateContactRoutingDataRequest/QueuePriority
  :cognitect.aws.connect/QueuePriority)

(s/def
  :cognitect.aws.connect.UpdateContactRoutingDataRequest/RoutingCriteria
  :cognitect.aws.connect/RoutingCriteriaInput)

(s/def
  :cognitect.aws.connect.EvaluationFormItem/Section
  :cognitect.aws.connect/EvaluationFormSection)

(s/def
  :cognitect.aws.connect.EvaluationFormItem/Question
  :cognitect.aws.connect/EvaluationFormQuestion)

(s/def
  :cognitect.aws.connect.GetContactAttributesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.GetContactAttributesRequest/InitialContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ListRoutingProfilesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListRoutingProfilesRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListRoutingProfilesRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def :cognitect.aws.connect.Meeting/MediaRegion :cognitect.aws.connect/MediaRegion)

(s/def :cognitect.aws.connect.Meeting/MediaPlacement :cognitect.aws.connect/MediaPlacement)

(s/def
  :cognitect.aws.connect.Meeting/MeetingFeatures
  :cognitect.aws.connect/MeetingFeaturesConfiguration)

(s/def :cognitect.aws.connect.Meeting/MeetingId :cognitect.aws.connect/MeetingId)

(s/def :cognitect.aws.connect.UserData/HierarchyPath :cognitect.aws.connect/HierarchyPathReference)

(s/def
  :cognitect.aws.connect.UserData/ActiveSlotsByChannel
  :cognitect.aws.connect/ChannelToCountMap)

(s/def :cognitect.aws.connect.UserData/Contacts :cognitect.aws.connect/AgentContactReferenceList)

(s/def :cognitect.aws.connect.UserData/MaxSlotsByChannel :cognitect.aws.connect/ChannelToCountMap)

(s/def :cognitect.aws.connect.UserData/NextStatus :cognitect.aws.connect/AgentStatusName)

(s/def :cognitect.aws.connect.UserData/User :cognitect.aws.connect/UserReference)

(s/def
  :cognitect.aws.connect.UserData/RoutingProfile
  :cognitect.aws.connect/RoutingProfileReference)

(s/def
  :cognitect.aws.connect.UserData/AvailableSlotsByChannel
  :cognitect.aws.connect/ChannelToCountMap)

(s/def :cognitect.aws.connect.UserData/Status :cognitect.aws.connect/AgentStatusReference)

(s/def
  :cognitect.aws.connect.TemplatedMessageConfig/KnowledgeBaseId
  :cognitect.aws.connect/MessageTemplateKnowledgeBaseId)

(s/def
  :cognitect.aws.connect.TemplatedMessageConfig/MessageTemplateId
  :cognitect.aws.connect/MessageTemplateId)

(s/def
  :cognitect.aws.connect.TemplatedMessageConfig/TemplateAttributes
  :cognitect.aws.connect/TemplateAttributes)

(s/def
  :cognitect.aws.connect.CreateEvaluationFormResponse/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.CreateEvaluationFormResponse/EvaluationFormArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.SearchQueuesResponse/Queues
  :cognitect.aws.connect/QueueSearchSummaryList)

(s/def :cognitect.aws.connect.SearchQueuesResponse/NextToken :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchQueuesResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def
  :cognitect.aws.connect.ReleasePhoneNumberRequest/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def
  :cognitect.aws.connect.ReleasePhoneNumberRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.UpdateUserPhoneConfigRequest/PhoneConfig
  :cognitect.aws.connect/UserPhoneConfig)

(s/def :cognitect.aws.connect.UpdateUserPhoneConfigRequest/UserId :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.UpdateUserPhoneConfigRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateContactRequest/References
  :cognitect.aws.connect/ContactReferences)

(s/def
  :cognitect.aws.connect.CreateContactRequest/PreviousContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.CreateContactRequest/SegmentAttributes
  :cognitect.aws.connect/SegmentAttributes)

(s/def :cognitect.aws.connect.CreateContactRequest/InitiateAs :cognitect.aws.connect/InitiateAs)

(s/def :cognitect.aws.connect.CreateContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.CreateContactRequest/Channel :cognitect.aws.connect/Channel)

(s/def :cognitect.aws.connect.CreateContactRequest/UserInfo :cognitect.aws.connect/UserInfo)

(s/def
  :cognitect.aws.connect.CreateContactRequest/RelatedContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.CreateContactRequest/InitiationMethod
  :cognitect.aws.connect/ContactInitiationMethod)

(s/def
  :cognitect.aws.connect.CreateContactRequest/ExpiryDurationInMinutes
  :cognitect.aws.connect/ExpiryDurationInMinutes)

(s/def :cognitect.aws.connect.CreateContactRequest/Name :cognitect.aws.connect/Name)

(s/def :cognitect.aws.connect.CreateContactRequest/Description :cognitect.aws.connect/Description)

(s/def :cognitect.aws.connect.CreateContactRequest/ClientToken :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.CreateContactRequest/Attributes :cognitect.aws.connect/Attributes)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileNameRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileNameRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileNameRequest/Name
  :cognitect.aws.connect/RoutingProfileName)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileNameRequest/Description
  :cognitect.aws.connect/RoutingProfileDescription)

(s/def :cognitect.aws.connect.CurrentMetricResult/Dimensions :cognitect.aws.connect/Dimensions)

(s/def
  :cognitect.aws.connect.CurrentMetricResult/Collections
  :cognitect.aws.connect/CurrentMetricDataCollections)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/Id
  :cognitect.aws.connect/RealTimeContactAnalysisId256)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/ParticipantId
  :cognitect.aws.connect/ParticipantId)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/ParticipantRole
  :cognitect.aws.connect/ParticipantRole)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/DisplayName
  :cognitect.aws.connect/DisplayName)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/Attachments
  :cognitect.aws.connect/RealTimeContactAnalysisAttachments)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentAttachments/Time
  :cognitect.aws.connect/RealTimeContactAnalysisTimeData)

(s/def
  :cognitect.aws.connect.ListContactFlowVersionsResponse/ContactFlowVersionSummaryList
  :cognitect.aws.connect/ContactFlowVersionSummaryList)

(s/def
  :cognitect.aws.connect.ListContactFlowVersionsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.UserSearchFilter/TagFilter
  :cognitect.aws.connect/ControlPlaneTagFilter)

(s/def
  :cognitect.aws.connect.UserSearchFilter/UserAttributeFilter
  :cognitect.aws.connect/ControlPlaneUserAttributeFilter)

(s/def
  :cognitect.aws.connect.QueueSearchCriteria/OrConditions
  :cognitect.aws.connect/QueueSearchConditionList)

(s/def
  :cognitect.aws.connect.QueueSearchCriteria/AndConditions
  :cognitect.aws.connect/QueueSearchConditionList)

(s/def
  :cognitect.aws.connect.QueueSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def
  :cognitect.aws.connect.QueueSearchCriteria/QueueTypeCondition
  :cognitect.aws.connect/SearchableQueueType)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataAssociationsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataAssociationsRequest/DataSetId
  :cognitect.aws.connect/DataSetId)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataAssociationsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataAssociationsRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def :cognitect.aws.connect.Dimensions/Queue :cognitect.aws.connect/QueueReference)

(s/def :cognitect.aws.connect.Dimensions/Channel :cognitect.aws.connect/Channel)

(s/def
  :cognitect.aws.connect.Dimensions/RoutingProfile
  :cognitect.aws.connect/RoutingProfileReference)

(s/def
  :cognitect.aws.connect.Dimensions/RoutingStepExpression
  :cognitect.aws.connect/RoutingExpression)

(s/def
  :cognitect.aws.connect.SearchContactFlowsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchContactFlowsRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchContactFlowsRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchContactFlowsRequest/SearchFilter
  :cognitect.aws.connect/ContactFlowSearchFilter)

(s/def
  :cognitect.aws.connect.SearchContactFlowsRequest/SearchCriteria
  :cognitect.aws.connect/ContactFlowSearchCriteria)

(s/def
  :cognitect.aws.connect.SearchContactFlowModulesResponse/ContactFlowModules
  :cognitect.aws.connect/ContactFlowModuleSearchSummaryList)

(s/def
  :cognitect.aws.connect.SearchContactFlowModulesResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchContactFlowModulesResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.TaskActionDefinition/Name :cognitect.aws.connect/TaskNameExpression)

(s/def
  :cognitect.aws.connect.TaskActionDefinition/Description
  :cognitect.aws.connect/TaskDescriptionExpression)

(s/def
  :cognitect.aws.connect.TaskActionDefinition/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.TaskActionDefinition/References
  :cognitect.aws.connect/ContactReferences)

(s/def
  :cognitect.aws.connect.QuickConnectSearchFilter/TagFilter
  :cognitect.aws.connect/ControlPlaneTagFilter)

(s/def
  :cognitect.aws.connect.DeleteContactEvaluationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteContactEvaluationRequest/EvaluationId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.TaskTemplateField/Id
  :cognitect.aws.connect/TaskTemplateFieldIdentifier)

(s/def
  :cognitect.aws.connect.TaskTemplateField/Description
  :cognitect.aws.connect/TaskTemplateFieldDescription)

(s/def :cognitect.aws.connect.TaskTemplateField/Type :cognitect.aws.connect/TaskTemplateFieldType)

(s/def
  :cognitect.aws.connect.TaskTemplateField/SingleSelectOptions
  :cognitect.aws.connect/SingleSelectOptions)

(s/def
  :cognitect.aws.connect.AssociateInstanceStorageConfigResponse/AssociationId
  :cognitect.aws.connect/AssociationId)

(s/def
  :cognitect.aws.connect.ListAuthenticationProfilesResponse/AuthenticationProfileSummaryList
  :cognitect.aws.connect/AuthenticationProfileSummaryList)

(s/def
  :cognitect.aws.connect.ListAuthenticationProfilesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.SearchableSegmentAttributes/Criteria
  :cognitect.aws.connect/SearchableSegmentAttributesCriteriaList)

(s/def
  :cognitect.aws.connect.SearchableSegmentAttributes/MatchType
  :cognitect.aws.connect/SearchContactsMatchType)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileAgentAvailabilityTimerRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileAgentAvailabilityTimerRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileAgentAvailabilityTimerRequest/AgentAvailabilityTimer
  :cognitect.aws.connect/AgentAvailabilityTimer)

(s/def
  :cognitect.aws.connect.SearchUserHierarchyGroupsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchUserHierarchyGroupsRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchUserHierarchyGroupsRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchUserHierarchyGroupsRequest/SearchFilter
  :cognitect.aws.connect/UserHierarchyGroupSearchFilter)

(s/def
  :cognitect.aws.connect.SearchUserHierarchyGroupsRequest/SearchCriteria
  :cognitect.aws.connect/UserHierarchyGroupSearchCriteria)

(s/def :cognitect.aws.connect.HoursOfOperationTimeSlice/Hours :cognitect.aws.connect/Hours24Format)

(s/def
  :cognitect.aws.connect.HoursOfOperationTimeSlice/Minutes
  :cognitect.aws.connect/MinutesLimit60)

(s/def
  :cognitect.aws.connect.ActivateEvaluationFormResponse/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.ActivateEvaluationFormResponse/EvaluationFormArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ActivateEvaluationFormResponse/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.QuickConnectSearchCriteria/OrConditions
  :cognitect.aws.connect/QuickConnectSearchConditionList)

(s/def
  :cognitect.aws.connect.QuickConnectSearchCriteria/AndConditions
  :cognitect.aws.connect/QuickConnectSearchConditionList)

(s/def
  :cognitect.aws.connect.QuickConnectSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def :cognitect.aws.connect.StartEmailContactResponse/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.LexBot/Name :cognitect.aws.connect/BotName)

(s/def :cognitect.aws.connect.LexBot/LexRegion :cognitect.aws.connect/LexRegion)

(s/def
  :cognitect.aws.connect.GetFlowAssociationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.GetFlowAssociationRequest/ResourceId :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.GetFlowAssociationRequest/ResourceType
  :cognitect.aws.connect/FlowAssociationResourceType)

(s/def :cognitect.aws.connect.CreateQuickConnectResponse/QuickConnectARN :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateQuickConnectResponse/QuickConnectId
  :cognitect.aws.connect/QuickConnectId)

(s/def
  :cognitect.aws.connect.UpdateQueueOutboundCallerConfigRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateQueueOutboundCallerConfigRequest/QueueId
  :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.UpdateQueueOutboundCallerConfigRequest/OutboundCallerConfig
  :cognitect.aws.connect/OutboundCallerConfig)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisCharacterInterval/BeginOffsetChar
  :cognitect.aws.connect/RealTimeContactAnalysisOffset)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisCharacterInterval/EndOffsetChar
  :cognitect.aws.connect/RealTimeContactAnalysisOffset)

(s/def :cognitect.aws.connect.StringCondition/FieldName :cognitect.aws.connect/String)

(s/def :cognitect.aws.connect.StringCondition/Value :cognitect.aws.connect/String)

(s/def
  :cognitect.aws.connect.StringCondition/ComparisonType
  :cognitect.aws.connect/StringComparisonType)

(s/def
  :cognitect.aws.connect.DescribeContactFlowModuleRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeContactFlowModuleRequest/ContactFlowModuleId
  :cognitect.aws.connect/ContactFlowModuleId)

(s/def
  :cognitect.aws.connect.DeleteQuickConnectRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteQuickConnectRequest/QuickConnectId
  :cognitect.aws.connect/QuickConnectId)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/LastModifiedTime
  :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.UpdateTaskTemplateResponse/Id :cognitect.aws.connect/TaskTemplateId)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/Constraints
  :cognitect.aws.connect/TaskTemplateConstraints)

(s/def :cognitect.aws.connect.UpdateTaskTemplateResponse/Arn :cognitect.aws.connect/TaskTemplateArn)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/Defaults
  :cognitect.aws.connect/TaskTemplateDefaults)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/Name
  :cognitect.aws.connect/TaskTemplateName)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/Description
  :cognitect.aws.connect/TaskTemplateDescription)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/CreatedTime
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/SelfAssignFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/Fields
  :cognitect.aws.connect/TaskTemplateFields)

(s/def
  :cognitect.aws.connect.UpdateTaskTemplateResponse/Status
  :cognitect.aws.connect/TaskTemplateStatus)

(s/def
  :cognitect.aws.connect.ListAuthenticationProfilesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListAuthenticationProfilesRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.ListAuthenticationProfilesRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ImportPhoneNumberResponse/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def :cognitect.aws.connect.ImportPhoneNumberResponse/PhoneNumberArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.ParticipantCapabilities/Video :cognitect.aws.connect/VideoCapability)

(s/def
  :cognitect.aws.connect.ParticipantCapabilities/ScreenShare
  :cognitect.aws.connect/ScreenShareCapability)

(s/def
  :cognitect.aws.connect.AssociatePhoneNumberContactFlowRequest/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def
  :cognitect.aws.connect.AssociatePhoneNumberContactFlowRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.AssociatePhoneNumberContactFlowRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def :cognitect.aws.connect.CreatePromptRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.CreatePromptRequest/Name :cognitect.aws.connect/CommonNameLength127)

(s/def
  :cognitect.aws.connect.CreatePromptRequest/Description
  :cognitect.aws.connect/PromptDescription)

(s/def :cognitect.aws.connect.CreatePromptRequest/S3Uri :cognitect.aws.connect/S3Uri)

(s/def :cognitect.aws.connect.CreatePromptRequest/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.DeviceInfo/PlatformName :cognitect.aws.connect/PlatformName)

(s/def :cognitect.aws.connect.DeviceInfo/PlatformVersion :cognitect.aws.connect/PlatformVersion)

(s/def :cognitect.aws.connect.DeviceInfo/OperatingSystem :cognitect.aws.connect/OperatingSystem)

(s/def
  :cognitect.aws.connect.UpdateQueueOutboundEmailConfigRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateQueueOutboundEmailConfigRequest/QueueId
  :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.UpdateQueueOutboundEmailConfigRequest/OutboundEmailConfig
  :cognitect.aws.connect/OutboundEmailConfig)

(s/def :cognitect.aws.connect.Sort/FieldName :cognitect.aws.connect/SortableFieldName)

(s/def :cognitect.aws.connect.Sort/Order :cognitect.aws.connect/SortOrder)

(s/def :cognitect.aws.connect.EmailAttachment/FileName :cognitect.aws.connect/FileName)

(s/def :cognitect.aws.connect.EmailAttachment/S3Url :cognitect.aws.connect/PreSignedAttachmentUrl)

(s/def
  :cognitect.aws.connect.SendChatIntegrationEventRequest/SourceId
  :cognitect.aws.connect/SourceId)

(s/def
  :cognitect.aws.connect.SendChatIntegrationEventRequest/DestinationId
  :cognitect.aws.connect/DestinationId)

(s/def
  :cognitect.aws.connect.SendChatIntegrationEventRequest/Subtype
  :cognitect.aws.connect/Subtype)

(s/def
  :cognitect.aws.connect.SendChatIntegrationEventRequest/Event
  :cognitect.aws.connect/ChatEvent)

(s/def
  :cognitect.aws.connect.SendChatIntegrationEventRequest/NewSessionDetails
  :cognitect.aws.connect/NewSessionDetails)

(s/def
  :cognitect.aws.connect.DescribeVocabularyRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeVocabularyRequest/VocabularyId
  :cognitect.aws.connect/VocabularyId)

(s/def
  :cognitect.aws.connect.ListRulesResponse/RuleSummaryList
  :cognitect.aws.connect/RuleSummaryList)

(s/def :cognitect.aws.connect.ListRulesResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.SignInConfig/Distributions
  :cognitect.aws.connect/SignInDistributionList)

(s/def
  :cognitect.aws.connect.ListFlowAssociationsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListFlowAssociationsRequest/ResourceType
  :cognitect.aws.connect/ListFlowAssociationResourceType)

(s/def
  :cognitect.aws.connect.ListFlowAssociationsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListFlowAssociationsRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.EvaluationFormNumericQuestionOption/MinValue
  :cognitect.aws.connect/Integer)

(s/def
  :cognitect.aws.connect.EvaluationFormNumericQuestionOption/MaxValue
  :cognitect.aws.connect/Integer)

(s/def
  :cognitect.aws.connect.EvaluationFormNumericQuestionOption/Score
  :cognitect.aws.connect/EvaluationFormQuestionAnswerScore)

(s/def
  :cognitect.aws.connect.EvaluationFormNumericQuestionOption/AutomaticFail
  :cognitect.aws.connect/Boolean)

(s/def
  :cognitect.aws.connect.CreateContactFlowVersionResponse/ContactFlowArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateContactFlowVersionResponse/Version
  :cognitect.aws.connect/ResourceVersion)

(s/def :cognitect.aws.connect.TransferContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.TransferContactRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.TransferContactRequest/QueueId :cognitect.aws.connect/QueueId)

(s/def :cognitect.aws.connect.TransferContactRequest/UserId :cognitect.aws.connect/AgentResourceId)

(s/def
  :cognitect.aws.connect.TransferContactRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def :cognitect.aws.connect.TransferContactRequest/ClientToken :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.DeleteUseCaseRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteUseCaseRequest/IntegrationAssociationId
  :cognitect.aws.connect/IntegrationAssociationId)

(s/def :cognitect.aws.connect.DeleteUseCaseRequest/UseCaseId :cognitect.aws.connect/UseCaseId)

(s/def
  :cognitect.aws.connect.ListEvaluationFormsResponse/EvaluationFormSummaryList
  :cognitect.aws.connect/EvaluationFormSummaryList)

(s/def
  :cognitect.aws.connect.ListEvaluationFormsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.SuccessfulRequest/RequestIdentifier
  :cognitect.aws.connect/RequestIdentifier)

(s/def :cognitect.aws.connect.SuccessfulRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.EvaluationAnswerData/StringValue
  :cognitect.aws.connect/EvaluationAnswerDataStringValue)

(s/def
  :cognitect.aws.connect.EvaluationAnswerData/NumericValue
  :cognitect.aws.connect/EvaluationAnswerDataNumericValue)

(s/def :cognitect.aws.connect.EvaluationAnswerData/NotApplicable :cognitect.aws.connect/Boolean)

(s/def
  :cognitect.aws.connect.GetContactMetricsResponse/MetricResults
  :cognitect.aws.connect/ContactMetricResults)

(s/def :cognitect.aws.connect.GetContactMetricsResponse/Id :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.GetContactMetricsResponse/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.PhoneNumberStatus/Status
  :cognitect.aws.connect/PhoneNumberWorkflowStatus)

(s/def
  :cognitect.aws.connect.PhoneNumberStatus/Message
  :cognitect.aws.connect/PhoneNumberWorkflowMessage)

(s/def
  :cognitect.aws.connect.ListUserHierarchyGroupsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListUserHierarchyGroupsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListUserHierarchyGroupsRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/TargetArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/PhoneNumberCountryCode
  :cognitect.aws.connect/PhoneNumberCountryCode)

(s/def
  :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/PhoneNumberType
  :cognitect.aws.connect/PhoneNumberType)

(s/def
  :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/PhoneNumberPrefix
  :cognitect.aws.connect/PhoneNumberPrefix)

(s/def
  :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/MaxResults
  :cognitect.aws.connect/MaxResult10)

(s/def
  :cognitect.aws.connect.SearchAvailablePhoneNumbersRequest/NextToken
  :cognitect.aws.connect/LargeNextToken)

(s/def
  :cognitect.aws.connect.CreateParticipantResponse/ParticipantCredentials
  :cognitect.aws.connect/ParticipantTokenCredentials)

(s/def
  :cognitect.aws.connect.CreateParticipantResponse/ParticipantId
  :cognitect.aws.connect/ParticipantId)

(s/def :cognitect.aws.connect.HistoricalMetricResult/Dimensions :cognitect.aws.connect/Dimensions)

(s/def
  :cognitect.aws.connect.HistoricalMetricResult/Collections
  :cognitect.aws.connect/HistoricalMetricDataCollections)

(s/def :cognitect.aws.connect.TaskTemplateMetadata/Id :cognitect.aws.connect/TaskTemplateId)

(s/def :cognitect.aws.connect.TaskTemplateMetadata/Arn :cognitect.aws.connect/TaskTemplateArn)

(s/def :cognitect.aws.connect.TaskTemplateMetadata/Name :cognitect.aws.connect/TaskTemplateName)

(s/def
  :cognitect.aws.connect.TaskTemplateMetadata/Description
  :cognitect.aws.connect/TaskTemplateDescription)

(s/def :cognitect.aws.connect.TaskTemplateMetadata/Status :cognitect.aws.connect/TaskTemplateStatus)

(s/def
  :cognitect.aws.connect.TaskTemplateMetadata/LastModifiedTime
  :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.TaskTemplateMetadata/CreatedTime :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.HierarchyStructureUpdate/LevelOne
  :cognitect.aws.connect/HierarchyLevelUpdate)

(s/def
  :cognitect.aws.connect.HierarchyStructureUpdate/LevelTwo
  :cognitect.aws.connect/HierarchyLevelUpdate)

(s/def
  :cognitect.aws.connect.HierarchyStructureUpdate/LevelThree
  :cognitect.aws.connect/HierarchyLevelUpdate)

(s/def
  :cognitect.aws.connect.HierarchyStructureUpdate/LevelFour
  :cognitect.aws.connect/HierarchyLevelUpdate)

(s/def
  :cognitect.aws.connect.HierarchyStructureUpdate/LevelFive
  :cognitect.aws.connect/HierarchyLevelUpdate)

(s/def
  :cognitect.aws.connect.ListUserProficienciesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListUserProficienciesRequest/UserId :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.ListUserProficienciesRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListUserProficienciesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationsRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.BatchGetFlowAssociationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.BatchGetFlowAssociationRequest/ResourceIds
  :cognitect.aws.connect/resourceArnListMaxLimit100)

(s/def
  :cognitect.aws.connect.BatchGetFlowAssociationRequest/ResourceType
  :cognitect.aws.connect/ListFlowAssociationResourceType)

(s/def
  :cognitect.aws.connect.RuleAction/CreateCaseAction
  :cognitect.aws.connect/CreateCaseActionDefinition)

(s/def :cognitect.aws.connect.RuleAction/ActionType :cognitect.aws.connect/ActionType)

(s/def
  :cognitect.aws.connect.RuleAction/SubmitAutoEvaluationAction
  :cognitect.aws.connect/SubmitAutoEvaluationActionDefinition)

(s/def
  :cognitect.aws.connect.RuleAction/EndAssociatedTasksAction
  :cognitect.aws.connect/EndAssociatedTasksActionDefinition)

(s/def
  :cognitect.aws.connect.RuleAction/UpdateCaseAction
  :cognitect.aws.connect/UpdateCaseActionDefinition)

(s/def
  :cognitect.aws.connect.RuleAction/EventBridgeAction
  :cognitect.aws.connect/EventBridgeActionDefinition)

(s/def :cognitect.aws.connect.RuleAction/TaskAction :cognitect.aws.connect/TaskActionDefinition)

(s/def
  :cognitect.aws.connect.RuleAction/AssignContactCategoryAction
  :cognitect.aws.connect/AssignContactCategoryActionDefinition)

(s/def
  :cognitect.aws.connect.RuleAction/SendNotificationAction
  :cognitect.aws.connect/SendNotificationActionDefinition)

(s/def
  :cognitect.aws.connect.RuleAction/AssignSlaAction
  :cognitect.aws.connect/AssignSlaActionDefinition)

(s/def :cognitect.aws.connect.UploadUrlMetadata/Url :cognitect.aws.connect/MetadataUrl)

(s/def :cognitect.aws.connect.UploadUrlMetadata/UrlExpiry :cognitect.aws.connect/ISO8601Datetime)

(s/def
  :cognitect.aws.connect.UploadUrlMetadata/HeadersToInclude
  :cognitect.aws.connect/UrlMetadataSignedHeaders)

(s/def
  :cognitect.aws.connect.SearchEmailAddressesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.SearchEmailAddressesResponse/EmailAddresses
  :cognitect.aws.connect/EmailAddressList)

(s/def
  :cognitect.aws.connect.SearchEmailAddressesResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def
  :cognitect.aws.connect.DescribeUserHierarchyGroupResponse/HierarchyGroup
  :cognitect.aws.connect/HierarchyGroup)

(s/def :cognitect.aws.connect.ChatEvent/Type :cognitect.aws.connect/ChatEventType)

(s/def :cognitect.aws.connect.ChatEvent/ContentType :cognitect.aws.connect/ChatContentType)

(s/def :cognitect.aws.connect.ChatEvent/Content :cognitect.aws.connect/ChatContent)

(s/def
  :cognitect.aws.connect.DisassociateAnalyticsDataSetRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DisassociateAnalyticsDataSetRequest/DataSetId
  :cognitect.aws.connect/DataSetId)

(s/def
  :cognitect.aws.connect.DisassociateAnalyticsDataSetRequest/TargetAccountId
  :cognitect.aws.connect/AWSAccountId)

(s/def :cognitect.aws.connect.ParticipantDetails/DisplayName :cognitect.aws.connect/DisplayName)

(s/def
  :cognitect.aws.connect.ConditionalOperationFailedException/Message
  :cognitect.aws.connect/Message)

(s/def :cognitect.aws.connect.CreateViewResponse/View :cognitect.aws.connect/View)

(s/def
  :cognitect.aws.connect.GetCurrentUserDataRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.GetCurrentUserDataRequest/Filters
  :cognitect.aws.connect/UserDataFilters)

(s/def :cognitect.aws.connect.GetCurrentUserDataRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.GetCurrentUserDataRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.CreateRoutingProfileResponse/RoutingProfileArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateRoutingProfileResponse/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def :cognitect.aws.connect.DeleteVocabularyResponse/VocabularyArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.DeleteVocabularyResponse/VocabularyId
  :cognitect.aws.connect/VocabularyId)

(s/def :cognitect.aws.connect.DeleteVocabularyResponse/State :cognitect.aws.connect/VocabularyState)

(s/def
  :cognitect.aws.connect.NewSessionDetails/SupportedMessagingContentTypes
  :cognitect.aws.connect/SupportedMessagingContentTypes)

(s/def
  :cognitect.aws.connect.NewSessionDetails/ParticipantDetails
  :cognitect.aws.connect/ParticipantDetails)

(s/def :cognitect.aws.connect.NewSessionDetails/Attributes :cognitect.aws.connect/Attributes)

(s/def
  :cognitect.aws.connect.NewSessionDetails/StreamingConfiguration
  :cognitect.aws.connect/ChatStreamingConfiguration)

(s/def :cognitect.aws.connect.ListBotsResponse/LexBots :cognitect.aws.connect/LexBotConfigList)

(s/def :cognitect.aws.connect.ListBotsResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.EndpointInfo/Type :cognitect.aws.connect/EndpointType)

(s/def :cognitect.aws.connect.EndpointInfo/Address :cognitect.aws.connect/EndpointAddress)

(s/def :cognitect.aws.connect.EndpointInfo/DisplayName :cognitect.aws.connect/EndpointDisplayName)

(s/def :cognitect.aws.connect.FilterV2/FilterKey :cognitect.aws.connect/ResourceArnOrId)

(s/def :cognitect.aws.connect.FilterV2/FilterValues :cognitect.aws.connect/FilterValueList)

(s/def
  :cognitect.aws.connect.ResumeContactRecordingRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ResumeContactRecordingRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ResumeContactRecordingRequest/InitialContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ResumeContactRecordingRequest/ContactRecordingType
  :cognitect.aws.connect/ContactRecordingType)

(s/def
  :cognitect.aws.connect.ListSecurityProfilePermissionsRequest/SecurityProfileId
  :cognitect.aws.connect/SecurityProfileId)

(s/def
  :cognitect.aws.connect.ListSecurityProfilePermissionsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListSecurityProfilePermissionsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListSecurityProfilePermissionsRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def :cognitect.aws.connect.RoutingProfileSummary/Id :cognitect.aws.connect/RoutingProfileId)

(s/def :cognitect.aws.connect.RoutingProfileSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.RoutingProfileSummary/Name :cognitect.aws.connect/RoutingProfileName)

(s/def
  :cognitect.aws.connect.RoutingProfileSummary/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.RoutingProfileSummary/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.SecurityProfilesSearchFilter/TagFilter
  :cognitect.aws.connect/ControlPlaneTagFilter)

(s/def :cognitect.aws.connect.HoursOfOperationSummary/Id :cognitect.aws.connect/HoursOfOperationId)

(s/def :cognitect.aws.connect.HoursOfOperationSummary/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.HoursOfOperationSummary/Name
  :cognitect.aws.connect/HoursOfOperationName)

(s/def
  :cognitect.aws.connect.HoursOfOperationSummary/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.HoursOfOperationSummary/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormResponse/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormResponse/EvaluationFormArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormResponse/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.BatchGetFlowAssociationResponse/FlowAssociationSummaryList
  :cognitect.aws.connect/FlowAssociationSummaryList)

(s/def
  :cognitect.aws.connect.DescribeInstanceAttributeRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeInstanceAttributeRequest/AttributeType
  :cognitect.aws.connect/InstanceAttributeType)

(s/def
  :cognitect.aws.connect.SubmitContactEvaluationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SubmitContactEvaluationRequest/EvaluationId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.SubmitContactEvaluationRequest/Answers
  :cognitect.aws.connect/EvaluationAnswersInputMap)

(s/def
  :cognitect.aws.connect.SubmitContactEvaluationRequest/Notes
  :cognitect.aws.connect/EvaluationNotesMap)

(s/def :cognitect.aws.connect.DateCondition/FieldName :cognitect.aws.connect/String)

(s/def :cognitect.aws.connect.DateCondition/Value :cognitect.aws.connect/DateYearMonthDayFormat)

(s/def
  :cognitect.aws.connect.DateCondition/ComparisonType
  :cognitect.aws.connect/DateComparisonType)

(s/def
  :cognitect.aws.connect.DescribeHoursOfOperationOverrideResponse/HoursOfOperationOverride
  :cognitect.aws.connect/HoursOfOperationOverride)

(s/def
  :cognitect.aws.connect.DescribeAuthenticationProfileRequest/AuthenticationProfileId
  :cognitect.aws.connect/AuthenticationProfileId)

(s/def
  :cognitect.aws.connect.DescribeAuthenticationProfileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.GetEffectiveHoursOfOperationsResponse/EffectiveHoursOfOperationList
  :cognitect.aws.connect/EffectiveHoursOfOperationList)

(s/def
  :cognitect.aws.connect.GetEffectiveHoursOfOperationsResponse/TimeZone
  :cognitect.aws.connect/TimeZone)

(s/def
  :cognitect.aws.connect.StopContactStreamingRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StopContactStreamingRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StopContactStreamingRequest/StreamingId
  :cognitect.aws.connect/StreamingId)

(s/def
  :cognitect.aws.connect.EmailAddressSearchFilter/TagFilter
  :cognitect.aws.connect/ControlPlaneTagFilter)

(s/def
  :cognitect.aws.connect.AnalyticsDataAssociationResult/DataSetId
  :cognitect.aws.connect/DataSetId)

(s/def
  :cognitect.aws.connect.AnalyticsDataAssociationResult/TargetAccountId
  :cognitect.aws.connect/AWSAccountId)

(s/def
  :cognitect.aws.connect.AnalyticsDataAssociationResult/ResourceShareId
  :cognitect.aws.connect/String)

(s/def
  :cognitect.aws.connect.AnalyticsDataAssociationResult/ResourceShareArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.AnalyticsDataAssociationResult/ResourceShareStatus
  :cognitect.aws.connect/String)

(s/def :cognitect.aws.connect.UserPhoneConfig/PhoneType :cognitect.aws.connect/PhoneType)

(s/def :cognitect.aws.connect.UserPhoneConfig/AutoAccept :cognitect.aws.connect/AutoAccept)

(s/def
  :cognitect.aws.connect.UserPhoneConfig/AfterContactWorkTimeLimit
  :cognitect.aws.connect/AfterContactWorkTimeLimit)

(s/def :cognitect.aws.connect.UserPhoneConfig/DeskPhoneNumber :cognitect.aws.connect/PhoneNumber)

(s/def :cognitect.aws.connect.DescribeUserRequest/UserId :cognitect.aws.connect/UserId)

(s/def :cognitect.aws.connect.DescribeUserRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListPredefinedAttributesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListPredefinedAttributesResponse/PredefinedAttributeSummaryList
  :cognitect.aws.connect/PredefinedAttributeSummaryList)

(s/def
  :cognitect.aws.connect.ParticipantDetailsToAdd/ParticipantRole
  :cognitect.aws.connect/ParticipantRole)

(s/def
  :cognitect.aws.connect.ParticipantDetailsToAdd/DisplayName
  :cognitect.aws.connect/DisplayName)

(s/def
  :cognitect.aws.connect.ParticipantDetailsToAdd/ParticipantCapabilities
  :cognitect.aws.connect/ParticipantCapabilities)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationsResponse/HoursOfOperationSummaryList
  :cognitect.aws.connect/HoursOfOperationSummaryList)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.EvaluationForm/EvaluationFormId :cognitect.aws.connect/ResourceId)

(s/def :cognitect.aws.connect.EvaluationForm/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.EvaluationForm/Items :cognitect.aws.connect/EvaluationFormItemsList)

(s/def :cognitect.aws.connect.EvaluationForm/EvaluationFormArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.EvaluationForm/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.EvaluationForm/Title :cognitect.aws.connect/EvaluationFormTitle)

(s/def
  :cognitect.aws.connect.EvaluationForm/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.EvaluationForm/Locked
  :cognitect.aws.connect/EvaluationFormVersionIsLocked)

(s/def
  :cognitect.aws.connect.EvaluationForm/ScoringStrategy
  :cognitect.aws.connect/EvaluationFormScoringStrategy)

(s/def :cognitect.aws.connect.EvaluationForm/CreatedBy :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.EvaluationForm/Description
  :cognitect.aws.connect/EvaluationFormDescription)

(s/def :cognitect.aws.connect.EvaluationForm/LastModifiedBy :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.EvaluationForm/CreatedTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.EvaluationForm/Status
  :cognitect.aws.connect/EvaluationFormVersionStatus)

(s/def :cognitect.aws.connect.CreateInstanceRequest/ClientToken :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.CreateInstanceRequest/IdentityManagementType
  :cognitect.aws.connect/DirectoryType)

(s/def
  :cognitect.aws.connect.CreateInstanceRequest/InstanceAlias
  :cognitect.aws.connect/DirectoryAlias)

(s/def :cognitect.aws.connect.CreateInstanceRequest/DirectoryId :cognitect.aws.connect/DirectoryId)

(s/def
  :cognitect.aws.connect.CreateInstanceRequest/InboundCallsEnabled
  :cognitect.aws.connect/InboundCallsEnabled)

(s/def
  :cognitect.aws.connect.CreateInstanceRequest/OutboundCallsEnabled
  :cognitect.aws.connect/OutboundCallsEnabled)

(s/def :cognitect.aws.connect.CreateInstanceRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.SearchPredefinedAttributesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchPredefinedAttributesRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchPredefinedAttributesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchPredefinedAttributesRequest/SearchCriteria
  :cognitect.aws.connect/PredefinedAttributeSearchCriteria)

(s/def :cognitect.aws.connect.GetTaskTemplateRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.GetTaskTemplateRequest/TaskTemplateId
  :cognitect.aws.connect/TaskTemplateId)

(s/def
  :cognitect.aws.connect.GetTaskTemplateRequest/SnapshotVersion
  :cognitect.aws.connect/SnapshotVersion)

(s/def
  :cognitect.aws.connect.CreateTrafficDistributionGroupRequest/Name
  :cognitect.aws.connect/Name128)

(s/def
  :cognitect.aws.connect.CreateTrafficDistributionGroupRequest/Description
  :cognitect.aws.connect/Description250)

(s/def
  :cognitect.aws.connect.CreateTrafficDistributionGroupRequest/InstanceId
  :cognitect.aws.connect/InstanceIdOrArn)

(s/def
  :cognitect.aws.connect.CreateTrafficDistributionGroupRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.CreateTrafficDistributionGroupRequest/Tags
  :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.ListPredefinedAttributesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListPredefinedAttributesRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListPredefinedAttributesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def :cognitect.aws.connect.DescribeContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DescribeContactRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ParticipantMetrics/TotalResponseTimeInMillis
  :cognitect.aws.connect/DurationMillis)

(s/def :cognitect.aws.connect.ParticipantMetrics/ParticipantId :cognitect.aws.connect/ParticipantId)

(s/def
  :cognitect.aws.connect.ParticipantMetrics/MaxResponseTimeInMillis
  :cognitect.aws.connect/DurationMillis)

(s/def :cognitect.aws.connect.ParticipantMetrics/MessagesSent :cognitect.aws.connect/Count)

(s/def
  :cognitect.aws.connect.ParticipantMetrics/ConversationAbandon
  :cognitect.aws.connect/NullableBoolean)

(s/def :cognitect.aws.connect.ParticipantMetrics/NumResponses :cognitect.aws.connect/Count)

(s/def :cognitect.aws.connect.ParticipantMetrics/MessageLengthInChars :cognitect.aws.connect/Count)

(s/def
  :cognitect.aws.connect.ParticipantMetrics/ParticipantType
  :cognitect.aws.connect/ParticipantType)

(s/def
  :cognitect.aws.connect.ParticipantMetrics/LastMessageTimestamp
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.ListContactEvaluationsResponse/EvaluationSummaryList
  :cognitect.aws.connect/EvaluationSummaryList)

(s/def
  :cognitect.aws.connect.ListContactEvaluationsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.DescribeInstanceRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribePhoneNumberRequest/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def
  :cognitect.aws.connect.DescribeVocabularyResponse/Vocabulary
  :cognitect.aws.connect/Vocabulary)

(s/def
  :cognitect.aws.connect.EvaluationFormSingleSelectQuestionOption/RefId
  :cognitect.aws.connect/ReferenceId)

(s/def
  :cognitect.aws.connect.EvaluationFormSingleSelectQuestionOption/Text
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionOptionText)

(s/def
  :cognitect.aws.connect.EvaluationFormSingleSelectQuestionOption/Score
  :cognitect.aws.connect/EvaluationFormQuestionAnswerScore)

(s/def
  :cognitect.aws.connect.EvaluationFormSingleSelectQuestionOption/AutomaticFail
  :cognitect.aws.connect/Boolean)

(s/def :cognitect.aws.connect.AgentContactReference/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.AgentContactReference/Channel :cognitect.aws.connect/Channel)

(s/def
  :cognitect.aws.connect.AgentContactReference/InitiationMethod
  :cognitect.aws.connect/ContactInitiationMethod)

(s/def
  :cognitect.aws.connect.AgentContactReference/AgentContactState
  :cognitect.aws.connect/ContactState)

(s/def
  :cognitect.aws.connect.AgentContactReference/StateStartTimestamp
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.AgentContactReference/ConnectedToAgentTimestamp
  :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.AgentContactReference/Queue :cognitect.aws.connect/QueueReference)

(s/def :cognitect.aws.connect.RoutingCriteria/Steps :cognitect.aws.connect/Steps)

(s/def :cognitect.aws.connect.RoutingCriteria/ActivationTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.RoutingCriteria/Index :cognitect.aws.connect/Index)

(s/def :cognitect.aws.connect.SearchCriteria/AgentIds :cognitect.aws.connect/AgentResourceIdList)

(s/def
  :cognitect.aws.connect.SearchCriteria/AgentHierarchyGroups
  :cognitect.aws.connect/AgentHierarchyGroups)

(s/def :cognitect.aws.connect.SearchCriteria/Channels :cognitect.aws.connect/ChannelList)

(s/def :cognitect.aws.connect.SearchCriteria/ContactAnalysis :cognitect.aws.connect/ContactAnalysis)

(s/def
  :cognitect.aws.connect.SearchCriteria/InitiationMethods
  :cognitect.aws.connect/InitiationMethodList)

(s/def :cognitect.aws.connect.SearchCriteria/QueueIds :cognitect.aws.connect/QueueIdList)

(s/def
  :cognitect.aws.connect.SearchCriteria/SearchableContactAttributes
  :cognitect.aws.connect/SearchableContactAttributes)

(s/def
  :cognitect.aws.connect.SearchCriteria/SearchableSegmentAttributes
  :cognitect.aws.connect/SearchableSegmentAttributes)

(s/def :cognitect.aws.connect.UserInfo/UserId :cognitect.aws.connect/AgentResourceId)

(s/def
  :cognitect.aws.connect.AssociateSecurityKeyRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.AssociateSecurityKeyRequest/Key :cognitect.aws.connect/PEM)

(s/def
  :cognitect.aws.connect.AssociateSecurityKeyRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.UpdateAgentStatusRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateAgentStatusRequest/AgentStatusId
  :cognitect.aws.connect/AgentStatusId)

(s/def :cognitect.aws.connect.UpdateAgentStatusRequest/Name :cognitect.aws.connect/AgentStatusName)

(s/def
  :cognitect.aws.connect.UpdateAgentStatusRequest/Description
  :cognitect.aws.connect/UpdateAgentStatusDescription)

(s/def
  :cognitect.aws.connect.UpdateAgentStatusRequest/State
  :cognitect.aws.connect/AgentStatusState)

(s/def
  :cognitect.aws.connect.UpdateAgentStatusRequest/DisplayOrder
  :cognitect.aws.connect/AgentStatusOrderNumber)

(s/def
  :cognitect.aws.connect.UpdateAgentStatusRequest/ResetOrderNumber
  :cognitect.aws.connect/Boolean)

(s/def
  :cognitect.aws.connect.ListAssociatedContactsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListAssociatedContactsRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ListAssociatedContactsRequest/MaxResults
  :cognitect.aws.connect/ListAssociatedContactsRequestMaxResults)

(s/def
  :cognitect.aws.connect.ListAssociatedContactsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.RoutingProfileReference/Id :cognitect.aws.connect/RoutingProfileId)

(s/def :cognitect.aws.connect.RoutingProfileReference/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ResourceTagsSearchCriteria/TagSearchCondition
  :cognitect.aws.connect/TagSearchCondition)

(s/def :cognitect.aws.connect.ChatMessage/ContentType :cognitect.aws.connect/ChatContentType)

(s/def :cognitect.aws.connect.ChatMessage/Content :cognitect.aws.connect/ChatContent)

(s/def
  :cognitect.aws.connect.HoursOfOperationSearchFilter/TagFilter
  :cognitect.aws.connect/ControlPlaneTagFilter)

(s/def :cognitect.aws.connect.OperationalHour/Start :cognitect.aws.connect/OverrideTimeSlice)

(s/def :cognitect.aws.connect.OperationalHour/End :cognitect.aws.connect/OverrideTimeSlice)

(s/def :cognitect.aws.connect.IdempotencyException/Message :cognitect.aws.connect/Message)

(s/def :cognitect.aws.connect.AttachedFileError/ErrorCode :cognitect.aws.connect/ErrorCode)

(s/def :cognitect.aws.connect.AttachedFileError/ErrorMessage :cognitect.aws.connect/ErrorMessage)

(s/def :cognitect.aws.connect.AttachedFileError/FileId :cognitect.aws.connect/FileId)

(s/def
  :cognitect.aws.connect.DescribePhoneNumberResponse/ClaimedPhoneNumberSummary
  :cognitect.aws.connect/ClaimedPhoneNumberSummary)

(s/def :cognitect.aws.connect.HierarchyGroupSummary/Id :cognitect.aws.connect/HierarchyGroupId)

(s/def :cognitect.aws.connect.HierarchyGroupSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.HierarchyGroupSummary/Name :cognitect.aws.connect/HierarchyGroupName)

(s/def
  :cognitect.aws.connect.HierarchyGroupSummary/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.HierarchyGroupSummary/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.CreateQueueResponse/QueueArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.CreateQueueResponse/QueueId :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.ListEvaluationFormsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListEvaluationFormsRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def :cognitect.aws.connect.ListEvaluationFormsRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.KinesisVideoStreamConfig/Prefix :cognitect.aws.connect/Prefix)

(s/def
  :cognitect.aws.connect.KinesisVideoStreamConfig/RetentionPeriodHours
  :cognitect.aws.connect/Hours)

(s/def
  :cognitect.aws.connect.KinesisVideoStreamConfig/EncryptionConfig
  :cognitect.aws.connect/EncryptionConfig)

(s/def
  :cognitect.aws.connect.CreateEmailAddressRequest/Description
  :cognitect.aws.connect/Description)

(s/def
  :cognitect.aws.connect.CreateEmailAddressRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateEmailAddressRequest/EmailAddress
  :cognitect.aws.connect/EmailAddress)

(s/def
  :cognitect.aws.connect.CreateEmailAddressRequest/DisplayName
  :cognitect.aws.connect/EmailAddressDisplayName)

(s/def :cognitect.aws.connect.CreateEmailAddressRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.CreateEmailAddressRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.OutputTypeNotFoundException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.CreateContactFlowModuleResponse/Id
  :cognitect.aws.connect/ContactFlowModuleId)

(s/def :cognitect.aws.connect.CreateContactFlowModuleResponse/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.CreateCaseActionDefinition/Fields :cognitect.aws.connect/FieldValues)

(s/def
  :cognitect.aws.connect.CreateCaseActionDefinition/TemplateId
  :cognitect.aws.connect/TemplateId)

(s/def :cognitect.aws.connect.TagSet/key :cognitect.aws.connect/TagKey)

(s/def :cognitect.aws.connect.TagSet/value :cognitect.aws.connect/TagValue)

(s/def :cognitect.aws.connect.ListInstancesRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ListInstancesRequest/MaxResults :cognitect.aws.connect/MaxResult10)

(s/def :cognitect.aws.connect.CreateInstanceResponse/Id :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.CreateInstanceResponse/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.OutboundCallerConfig/OutboundCallerIdName
  :cognitect.aws.connect/OutboundCallerIdName)

(s/def
  :cognitect.aws.connect.OutboundCallerConfig/OutboundCallerIdNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def
  :cognitect.aws.connect.OutboundCallerConfig/OutboundFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.EvaluationAnswerOutput/Value
  :cognitect.aws.connect/EvaluationAnswerData)

(s/def
  :cognitect.aws.connect.EvaluationAnswerOutput/SystemSuggestedValue
  :cognitect.aws.connect/EvaluationAnswerData)

(s/def
  :cognitect.aws.connect.AgentStatusSearchCriteria/OrConditions
  :cognitect.aws.connect/AgentStatusSearchConditionList)

(s/def
  :cognitect.aws.connect.AgentStatusSearchCriteria/AndConditions
  :cognitect.aws.connect/AgentStatusSearchConditionList)

(s/def
  :cognitect.aws.connect.AgentStatusSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def
  :cognitect.aws.connect.Expression/AttributeCondition
  :cognitect.aws.connect/AttributeCondition)

(s/def :cognitect.aws.connect.Expression/AndExpression :cognitect.aws.connect/Expressions)

(s/def :cognitect.aws.connect.Expression/OrExpression :cognitect.aws.connect/Expressions)

(s/def
  :cognitect.aws.connect.Expression/NotAttributeCondition
  :cognitect.aws.connect/AttributeCondition)

(s/def
  :cognitect.aws.connect.UpdateUserIdentityInfoRequest/IdentityInfo
  :cognitect.aws.connect/UserIdentityInfo)

(s/def :cognitect.aws.connect.UpdateUserIdentityInfoRequest/UserId :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.UpdateUserIdentityInfoRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CustomerVoiceActivity/GreetingStartTimestamp
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.CustomerVoiceActivity/GreetingEndTimestamp
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.ListUserProficienciesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListUserProficienciesResponse/UserProficiencyList
  :cognitect.aws.connect/UserProficiencyList)

(s/def
  :cognitect.aws.connect.ListUserProficienciesResponse/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.ListUserProficienciesResponse/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.ListDefaultVocabulariesResponse/DefaultVocabularyList
  :cognitect.aws.connect/DefaultVocabularyList)

(s/def
  :cognitect.aws.connect.ListDefaultVocabulariesResponse/NextToken
  :cognitect.aws.connect/VocabularyNextToken)

(s/def
  :cognitect.aws.connect.UpdateTrafficDistributionRequest/Id
  :cognitect.aws.connect/TrafficDistributionGroupIdOrArn)

(s/def
  :cognitect.aws.connect.UpdateTrafficDistributionRequest/TelephonyConfig
  :cognitect.aws.connect/TelephonyConfig)

(s/def
  :cognitect.aws.connect.UpdateTrafficDistributionRequest/SignInConfig
  :cognitect.aws.connect/SignInConfig)

(s/def
  :cognitect.aws.connect.UpdateTrafficDistributionRequest/AgentConfig
  :cognitect.aws.connect/AgentConfig)

(s/def
  :cognitect.aws.connect.ListTrafficDistributionGroupUsersRequest/TrafficDistributionGroupId
  :cognitect.aws.connect/TrafficDistributionGroupIdOrArn)

(s/def
  :cognitect.aws.connect.ListTrafficDistributionGroupUsersRequest/MaxResults
  :cognitect.aws.connect/MaxResult10)

(s/def
  :cognitect.aws.connect.ListTrafficDistributionGroupUsersRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.Queue/QueueArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Queue/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.Queue/QueueId :cognitect.aws.connect/QueueId)

(s/def :cognitect.aws.connect.Queue/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.Queue/MaxContacts :cognitect.aws.connect/QueueMaxContacts)

(s/def
  :cognitect.aws.connect.Queue/OutboundCallerConfig
  :cognitect.aws.connect/OutboundCallerConfig)

(s/def :cognitect.aws.connect.Queue/OutboundEmailConfig :cognitect.aws.connect/OutboundEmailConfig)

(s/def :cognitect.aws.connect.Queue/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.Queue/Name :cognitect.aws.connect/CommonNameLength127)

(s/def :cognitect.aws.connect.Queue/Description :cognitect.aws.connect/QueueDescription)

(s/def :cognitect.aws.connect.Queue/HoursOfOperationId :cognitect.aws.connect/HoursOfOperationId)

(s/def :cognitect.aws.connect.Queue/Status :cognitect.aws.connect/QueueStatus)

(s/def
  :cognitect.aws.connect.HoursOfOperationConfig/Day
  :cognitect.aws.connect/HoursOfOperationDays)

(s/def
  :cognitect.aws.connect.HoursOfOperationConfig/StartTime
  :cognitect.aws.connect/HoursOfOperationTimeSlice)

(s/def
  :cognitect.aws.connect.HoursOfOperationConfig/EndTime
  :cognitect.aws.connect/HoursOfOperationTimeSlice)

(s/def
  :cognitect.aws.connect.CreateContactFlowModuleRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateContactFlowModuleRequest/Name
  :cognitect.aws.connect/ContactFlowModuleName)

(s/def
  :cognitect.aws.connect.CreateContactFlowModuleRequest/Description
  :cognitect.aws.connect/ContactFlowModuleDescription)

(s/def
  :cognitect.aws.connect.CreateContactFlowModuleRequest/Content
  :cognitect.aws.connect/ContactFlowModuleContent)

(s/def :cognitect.aws.connect.CreateContactFlowModuleRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.CreateContactFlowModuleRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.GetFlowAssociationResponse/ResourceId :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.GetFlowAssociationResponse/FlowId :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.GetFlowAssociationResponse/ResourceType
  :cognitect.aws.connect/FlowAssociationResourceType)

(s/def
  :cognitect.aws.connect.ListTaskTemplatesResponse/TaskTemplates
  :cognitect.aws.connect/TaskTemplateList)

(s/def :cognitect.aws.connect.ListTaskTemplatesResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.DescribeRuleResponse/Rule :cognitect.aws.connect/Rule)

(s/def
  :cognitect.aws.connect.SubmitContactEvaluationResponse/EvaluationId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.SubmitContactEvaluationResponse/EvaluationArn
  :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.HierarchyLevelUpdate/Name :cognitect.aws.connect/HierarchyLevelName)

(s/def
  :cognitect.aws.connect.SearchableContactAttributes/Criteria
  :cognitect.aws.connect/SearchableContactAttributesCriteriaList)

(s/def
  :cognitect.aws.connect.SearchableContactAttributes/MatchType
  :cognitect.aws.connect/SearchContactsMatchType)

(s/def :cognitect.aws.connect.ReferenceSummary/Url :cognitect.aws.connect/UrlReference)

(s/def
  :cognitect.aws.connect.ReferenceSummary/Attachment
  :cognitect.aws.connect/AttachmentReference)

(s/def
  :cognitect.aws.connect.ReferenceSummary/EmailMessage
  :cognitect.aws.connect/EmailMessageReference)

(s/def :cognitect.aws.connect.ReferenceSummary/String :cognitect.aws.connect/StringReference)

(s/def :cognitect.aws.connect.ReferenceSummary/Number :cognitect.aws.connect/NumberReference)

(s/def :cognitect.aws.connect.ReferenceSummary/Date :cognitect.aws.connect/DateReference)

(s/def :cognitect.aws.connect.ReferenceSummary/Email :cognitect.aws.connect/EmailReference)

(s/def
  :cognitect.aws.connect.PromptSearchCriteria/OrConditions
  :cognitect.aws.connect/PromptSearchConditionList)

(s/def
  :cognitect.aws.connect.PromptSearchCriteria/AndConditions
  :cognitect.aws.connect/PromptSearchConditionList)

(s/def
  :cognitect.aws.connect.PromptSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def :cognitect.aws.connect.CaseSlaConfiguration/Name :cognitect.aws.connect/SlaName)

(s/def :cognitect.aws.connect.CaseSlaConfiguration/Type :cognitect.aws.connect/SlaType)

(s/def :cognitect.aws.connect.CaseSlaConfiguration/FieldId :cognitect.aws.connect/FieldValueId)

(s/def
  :cognitect.aws.connect.CaseSlaConfiguration/TargetFieldValues
  :cognitect.aws.connect/SlaFieldValueUnionList)

(s/def
  :cognitect.aws.connect.CaseSlaConfiguration/TargetSlaMinutes
  :cognitect.aws.connect/TargetSlaMinutes)

(s/def
  :cognitect.aws.connect.DeleteTaskTemplateRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteTaskTemplateRequest/TaskTemplateId
  :cognitect.aws.connect/TaskTemplateId)

(s/def :cognitect.aws.connect.ContactAnalysis/Transcript :cognitect.aws.connect/Transcript)

(s/def
  :cognitect.aws.connect.ContactSearchSummarySegmentAttributeValue/ValueString
  :cognitect.aws.connect/SegmentAttributeValueString)

(s/def :cognitect.aws.connect.ViewContent/InputSchema :cognitect.aws.connect/ViewInputSchema)

(s/def :cognitect.aws.connect.ViewContent/Template :cognitect.aws.connect/ViewTemplate)

(s/def :cognitect.aws.connect.ViewContent/Actions :cognitect.aws.connect/ViewActions)

(s/def :cognitect.aws.connect.DeleteRuleRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DeleteRuleRequest/RuleId :cognitect.aws.connect/RuleId)

(s/def
  :cognitect.aws.connect.AudioQualityMetricsInfo/QualityScore
  :cognitect.aws.connect/AudioQualityScore)

(s/def
  :cognitect.aws.connect.AudioQualityMetricsInfo/PotentialQualityIssues
  :cognitect.aws.connect/PotentialAudioQualityIssues)

(s/def
  :cognitect.aws.connect.SearchUserHierarchyGroupsResponse/UserHierarchyGroups
  :cognitect.aws.connect/UserHierarchyGroupList)

(s/def
  :cognitect.aws.connect.SearchUserHierarchyGroupsResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchUserHierarchyGroupsResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.Threshold/Comparison :cognitect.aws.connect/Comparison)

(s/def :cognitect.aws.connect.Threshold/ThresholdValue :cognitect.aws.connect/ThresholdValue)

(s/def :cognitect.aws.connect.EmailRecipient/Address :cognitect.aws.connect/EndpointAddress)

(s/def :cognitect.aws.connect.EmailRecipient/DisplayName :cognitect.aws.connect/EndpointDisplayName)

(s/def :cognitect.aws.connect.CreateContactResponse/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.CreateContactResponse/ContactArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.PromptSummary/Id :cognitect.aws.connect/PromptId)

(s/def :cognitect.aws.connect.PromptSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.PromptSummary/Name :cognitect.aws.connect/PromptName)

(s/def :cognitect.aws.connect.PromptSummary/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.PromptSummary/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.EmailAddressSearchCriteria/OrConditions
  :cognitect.aws.connect/EmailAddressSearchConditionList)

(s/def
  :cognitect.aws.connect.EmailAddressSearchCriteria/AndConditions
  :cognitect.aws.connect/EmailAddressSearchConditionList)

(s/def
  :cognitect.aws.connect.EmailAddressSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def :cognitect.aws.connect.ContactFlowModule/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.ContactFlowModule/Id :cognitect.aws.connect/ContactFlowModuleId)

(s/def :cognitect.aws.connect.ContactFlowModule/Name :cognitect.aws.connect/ContactFlowModuleName)

(s/def
  :cognitect.aws.connect.ContactFlowModule/Content
  :cognitect.aws.connect/ContactFlowModuleContent)

(s/def
  :cognitect.aws.connect.ContactFlowModule/Description
  :cognitect.aws.connect/ContactFlowModuleDescription)

(s/def :cognitect.aws.connect.ContactFlowModule/State :cognitect.aws.connect/ContactFlowModuleState)

(s/def
  :cognitect.aws.connect.ContactFlowModule/Status
  :cognitect.aws.connect/ContactFlowModuleStatus)

(s/def :cognitect.aws.connect.ContactFlowModule/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.UrlReference/Name :cognitect.aws.connect/ReferenceKey)

(s/def :cognitect.aws.connect.UrlReference/Value :cognitect.aws.connect/ReferenceValue)

(s/def
  :cognitect.aws.connect.SearchContactsTimeRange/Type
  :cognitect.aws.connect/SearchContactsTimeRangeType)

(s/def :cognitect.aws.connect.SearchContactsTimeRange/StartTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.SearchContactsTimeRange/EndTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.DisassociateTrafficDistributionGroupUserRequest/TrafficDistributionGroupId
  :cognitect.aws.connect/TrafficDistributionGroupIdOrArn)

(s/def
  :cognitect.aws.connect.DisassociateTrafficDistributionGroupUserRequest/UserId
  :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.DisassociateTrafficDistributionGroupUserRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.TaskTemplateConstraints/RequiredFields
  :cognitect.aws.connect/RequiredTaskTemplateFields)

(s/def
  :cognitect.aws.connect.TaskTemplateConstraints/ReadOnlyFields
  :cognitect.aws.connect/ReadOnlyTaskTemplateFields)

(s/def
  :cognitect.aws.connect.TaskTemplateConstraints/InvisibleFields
  :cognitect.aws.connect/InvisibleTaskTemplateFields)

(s/def
  :cognitect.aws.connect.DisassociateQueueQuickConnectsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DisassociateQueueQuickConnectsRequest/QueueId
  :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.DisassociateQueueQuickConnectsRequest/QuickConnectIds
  :cognitect.aws.connect/QuickConnectsList)

(s/def :cognitect.aws.connect.ListTagsForResourceRequest/resourceArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.DescribeAgentStatusResponse/AgentStatus
  :cognitect.aws.connect/AgentStatus)

(s/def
  :cognitect.aws.connect.InstanceSummary/OutboundCallsEnabled
  :cognitect.aws.connect/OutboundCallsEnabled)

(s/def :cognitect.aws.connect.InstanceSummary/Id :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.InstanceSummary/InstanceAlias :cognitect.aws.connect/DirectoryAlias)

(s/def
  :cognitect.aws.connect.InstanceSummary/IdentityManagementType
  :cognitect.aws.connect/DirectoryType)

(s/def :cognitect.aws.connect.InstanceSummary/InstanceStatus :cognitect.aws.connect/InstanceStatus)

(s/def :cognitect.aws.connect.InstanceSummary/ServiceRole :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.InstanceSummary/InstanceAccessUrl :cognitect.aws.connect/Url)

(s/def :cognitect.aws.connect.InstanceSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.InstanceSummary/CreatedTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.InstanceSummary/InboundCallsEnabled
  :cognitect.aws.connect/InboundCallsEnabled)

(s/def :cognitect.aws.connect.ContactFilter/ContactStates :cognitect.aws.connect/ContactStates)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileResponse/SecurityProfileId
  :cognitect.aws.connect/SecurityProfileId)

(s/def
  :cognitect.aws.connect.CreateSecurityProfileResponse/SecurityProfileArn
  :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.DeleteQueueRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DeleteQueueRequest/QueueId :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.ListTrafficDistributionGroupsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListTrafficDistributionGroupsResponse/TrafficDistributionGroupSummaryList
  :cognitect.aws.connect/TrafficDistributionGroupSummaryList)

(s/def
  :cognitect.aws.connect.DescribeContactFlowResponse/ContactFlow
  :cognitect.aws.connect/ContactFlow)

(s/def
  :cognitect.aws.connect.DescribeSecurityProfileRequest/SecurityProfileId
  :cognitect.aws.connect/SecurityProfileId)

(s/def
  :cognitect.aws.connect.DescribeSecurityProfileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ContactMetricValue/Number :cognitect.aws.connect/Double)

(s/def
  :cognitect.aws.connect.ListSecurityProfilesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListSecurityProfilesRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListSecurityProfilesRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.UserHierarchyGroupSearchCriteria/OrConditions
  :cognitect.aws.connect/UserHierarchyGroupSearchConditionList)

(s/def
  :cognitect.aws.connect.UserHierarchyGroupSearchCriteria/AndConditions
  :cognitect.aws.connect/UserHierarchyGroupSearchConditionList)

(s/def
  :cognitect.aws.connect.UserHierarchyGroupSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def
  :cognitect.aws.connect.BatchAssociateAnalyticsDataSetRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.BatchAssociateAnalyticsDataSetRequest/DataSetIds
  :cognitect.aws.connect/DataSetIds)

(s/def
  :cognitect.aws.connect.BatchAssociateAnalyticsDataSetRequest/TargetAccountId
  :cognitect.aws.connect/AWSAccountId)

(s/def
  :cognitect.aws.connect.SearchQuickConnectsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchQuickConnectsRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchQuickConnectsRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchQuickConnectsRequest/SearchFilter
  :cognitect.aws.connect/QuickConnectSearchFilter)

(s/def
  :cognitect.aws.connect.SearchQuickConnectsRequest/SearchCriteria
  :cognitect.aws.connect/QuickConnectSearchCriteria)

(s/def
  :cognitect.aws.connect.DeletePushNotificationRegistrationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeletePushNotificationRegistrationRequest/RegistrationId
  :cognitect.aws.connect/RegistrationId)

(s/def
  :cognitect.aws.connect.DeletePushNotificationRegistrationRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.InvalidParameterException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.UpdateContactAttributesRequest/InitialContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.UpdateContactAttributesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateContactAttributesRequest/Attributes
  :cognitect.aws.connect/Attributes)

(s/def
  :cognitect.aws.connect.EvaluationFormSection/Title
  :cognitect.aws.connect/EvaluationFormSectionTitle)

(s/def :cognitect.aws.connect.EvaluationFormSection/RefId :cognitect.aws.connect/ReferenceId)

(s/def
  :cognitect.aws.connect.EvaluationFormSection/Instructions
  :cognitect.aws.connect/EvaluationFormQuestionInstructions)

(s/def
  :cognitect.aws.connect.EvaluationFormSection/Items
  :cognitect.aws.connect/EvaluationFormItemsList)

(s/def
  :cognitect.aws.connect.EvaluationFormSection/Weight
  :cognitect.aws.connect/EvaluationFormItemWeight)

(s/def
  :cognitect.aws.connect.EvaluationFormSingleSelectQuestionAutomationOption/RuleCategory
  :cognitect.aws.connect/SingleSelectQuestionRuleCategoryAutomation)

(s/def
  :cognitect.aws.connect.DescribeContactFlowModuleResponse/ContactFlowModule
  :cognitect.aws.connect/ContactFlowModule)

(s/def
  :cognitect.aws.connect.AssociateAnalyticsDataSetRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.AssociateAnalyticsDataSetRequest/DataSetId
  :cognitect.aws.connect/DataSetId)

(s/def
  :cognitect.aws.connect.AssociateAnalyticsDataSetRequest/TargetAccountId
  :cognitect.aws.connect/AWSAccountId)

(s/def
  :cognitect.aws.connect.AssociateSecurityKeyResponse/AssociationId
  :cognitect.aws.connect/AssociationId)

(s/def
  :cognitect.aws.connect.InboundEmailContent/MessageSourceType
  :cognitect.aws.connect/InboundMessageSourceType)

(s/def
  :cognitect.aws.connect.InboundEmailContent/RawMessage
  :cognitect.aws.connect/InboundRawMessage)

(s/def
  :cognitect.aws.connect.TranscriptCriteria/ParticipantRole
  :cognitect.aws.connect/ParticipantRole)

(s/def :cognitect.aws.connect.TranscriptCriteria/SearchText :cognitect.aws.connect/SearchTextList)

(s/def
  :cognitect.aws.connect.TranscriptCriteria/MatchType
  :cognitect.aws.connect/SearchContactsMatchType)

(s/def
  :cognitect.aws.connect.StartOutboundEmailContactRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartOutboundEmailContactRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartOutboundEmailContactRequest/FromEmailAddress
  :cognitect.aws.connect/EmailAddressInfo)

(s/def
  :cognitect.aws.connect.StartOutboundEmailContactRequest/DestinationEmailAddress
  :cognitect.aws.connect/EmailAddressInfo)

(s/def
  :cognitect.aws.connect.StartOutboundEmailContactRequest/AdditionalRecipients
  :cognitect.aws.connect/OutboundAdditionalRecipients)

(s/def
  :cognitect.aws.connect.StartOutboundEmailContactRequest/EmailMessage
  :cognitect.aws.connect/OutboundEmailContent)

(s/def
  :cognitect.aws.connect.StartOutboundEmailContactRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.DescribeUserResponse/User :cognitect.aws.connect/User)

(s/def :cognitect.aws.connect.DescribePromptResponse/Prompt :cognitect.aws.connect/Prompt)

(s/def :cognitect.aws.connect.LexBotConfig/LexBot :cognitect.aws.connect/LexBot)

(s/def :cognitect.aws.connect.LexBotConfig/LexV2Bot :cognitect.aws.connect/LexV2Bot)

(s/def
  :cognitect.aws.connect.DescribeEmailAddressResponse/EmailAddressId
  :cognitect.aws.connect/EmailAddressId)

(s/def
  :cognitect.aws.connect.DescribeEmailAddressResponse/EmailAddressArn
  :cognitect.aws.connect/EmailAddressArn)

(s/def
  :cognitect.aws.connect.DescribeEmailAddressResponse/EmailAddress
  :cognitect.aws.connect/EmailAddress)

(s/def
  :cognitect.aws.connect.DescribeEmailAddressResponse/DisplayName
  :cognitect.aws.connect/EmailAddressDisplayName)

(s/def
  :cognitect.aws.connect.DescribeEmailAddressResponse/Description
  :cognitect.aws.connect/Description)

(s/def
  :cognitect.aws.connect.DescribeEmailAddressResponse/CreateTimestamp
  :cognitect.aws.connect/ISO8601Datetime)

(s/def
  :cognitect.aws.connect.DescribeEmailAddressResponse/ModifiedTimestamp
  :cognitect.aws.connect/ISO8601Datetime)

(s/def :cognitect.aws.connect.DescribeEmailAddressResponse/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.GetTaskTemplateResponse/LastModifiedTime
  :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.GetTaskTemplateResponse/Id :cognitect.aws.connect/TaskTemplateId)

(s/def :cognitect.aws.connect.GetTaskTemplateResponse/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.GetTaskTemplateResponse/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.GetTaskTemplateResponse/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.GetTaskTemplateResponse/Constraints
  :cognitect.aws.connect/TaskTemplateConstraints)

(s/def :cognitect.aws.connect.GetTaskTemplateResponse/Arn :cognitect.aws.connect/TaskTemplateArn)

(s/def
  :cognitect.aws.connect.GetTaskTemplateResponse/Defaults
  :cognitect.aws.connect/TaskTemplateDefaults)

(s/def :cognitect.aws.connect.GetTaskTemplateResponse/Name :cognitect.aws.connect/TaskTemplateName)

(s/def
  :cognitect.aws.connect.GetTaskTemplateResponse/Description
  :cognitect.aws.connect/TaskTemplateDescription)

(s/def :cognitect.aws.connect.GetTaskTemplateResponse/CreatedTime :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.GetTaskTemplateResponse/SelfAssignFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.GetTaskTemplateResponse/Fields
  :cognitect.aws.connect/TaskTemplateFields)

(s/def
  :cognitect.aws.connect.GetTaskTemplateResponse/Status
  :cognitect.aws.connect/TaskTemplateStatus)

(s/def
  :cognitect.aws.connect.ListSecurityProfileApplicationsRequest/SecurityProfileId
  :cognitect.aws.connect/SecurityProfileId)

(s/def
  :cognitect.aws.connect.ListSecurityProfileApplicationsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListSecurityProfileApplicationsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListSecurityProfileApplicationsRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def :cognitect.aws.connect.DeleteUserRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DeleteUserRequest/UserId :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.SearchRoutingProfilesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchRoutingProfilesRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchRoutingProfilesRequest/MaxResults
  :cognitect.aws.connect/MaxResult500)

(s/def
  :cognitect.aws.connect.SearchRoutingProfilesRequest/SearchFilter
  :cognitect.aws.connect/RoutingProfileSearchFilter)

(s/def
  :cognitect.aws.connect.SearchRoutingProfilesRequest/SearchCriteria
  :cognitect.aws.connect/RoutingProfileSearchCriteria)

(s/def
  :cognitect.aws.connect.ContactFlow/VersionDescription
  :cognitect.aws.connect/ContactFlowDescription)

(s/def :cognitect.aws.connect.ContactFlow/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.ContactFlow/Id :cognitect.aws.connect/ContactFlowId)

(s/def :cognitect.aws.connect.ContactFlow/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.ContactFlow/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.ContactFlow/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.ContactFlow/Name :cognitect.aws.connect/ContactFlowName)

(s/def :cognitect.aws.connect.ContactFlow/Description :cognitect.aws.connect/ContactFlowDescription)

(s/def :cognitect.aws.connect.ContactFlow/Type :cognitect.aws.connect/ContactFlowType)

(s/def
  :cognitect.aws.connect.ContactFlow/FlowContentSha256
  :cognitect.aws.connect/FlowContentSha256)

(s/def :cognitect.aws.connect.ContactFlow/State :cognitect.aws.connect/ContactFlowState)

(s/def :cognitect.aws.connect.ContactFlow/Version :cognitect.aws.connect/ResourceVersion)

(s/def :cognitect.aws.connect.ContactFlow/Content :cognitect.aws.connect/ContactFlowContent)

(s/def :cognitect.aws.connect.ContactFlow/Status :cognitect.aws.connect/ContactFlowStatus)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationOverridesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationOverridesRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationOverridesRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationOverridesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.GetTrafficDistributionRequest/Id
  :cognitect.aws.connect/TrafficDistributionGroupIdOrArn)

(s/def
  :cognitect.aws.connect.UpdatePhoneNumberResponse/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def :cognitect.aws.connect.UpdatePhoneNumberResponse/PhoneNumberArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.User/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.User/IdentityInfo :cognitect.aws.connect/UserIdentityInfo)

(s/def :cognitect.aws.connect.User/SecurityProfileIds :cognitect.aws.connect/SecurityProfileIds)

(s/def :cognitect.aws.connect.User/Id :cognitect.aws.connect/UserId)

(s/def :cognitect.aws.connect.User/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.User/DirectoryUserId :cognitect.aws.connect/DirectoryUserId)

(s/def :cognitect.aws.connect.User/RoutingProfileId :cognitect.aws.connect/RoutingProfileId)

(s/def :cognitect.aws.connect.User/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.User/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.User/PhoneConfig :cognitect.aws.connect/UserPhoneConfig)

(s/def :cognitect.aws.connect.User/Username :cognitect.aws.connect/AgentUsername)

(s/def :cognitect.aws.connect.User/HierarchyGroupId :cognitect.aws.connect/HierarchyGroupId)

(s/def
  :cognitect.aws.connect.UpdateEmailAddressMetadataResponse/EmailAddressId
  :cognitect.aws.connect/EmailAddressId)

(s/def
  :cognitect.aws.connect.UpdateEmailAddressMetadataResponse/EmailAddressArn
  :cognitect.aws.connect/EmailAddressArn)

(s/def
  :cognitect.aws.connect.Range/MinProficiencyLevel
  :cognitect.aws.connect/NullableProficiencyLevel)

(s/def
  :cognitect.aws.connect.Range/MaxProficiencyLevel
  :cognitect.aws.connect/NullableProficiencyLevel)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroup/Id
  :cognitect.aws.connect/TrafficDistributionGroupId)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroup/Arn
  :cognitect.aws.connect/TrafficDistributionGroupArn)

(s/def :cognitect.aws.connect.TrafficDistributionGroup/Name :cognitect.aws.connect/Name128)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroup/Description
  :cognitect.aws.connect/Description250)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroup/InstanceArn
  :cognitect.aws.connect/InstanceArn)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroup/Status
  :cognitect.aws.connect/TrafficDistributionGroupStatus)

(s/def :cognitect.aws.connect.TrafficDistributionGroup/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.TrafficDistributionGroup/IsDefault :cognitect.aws.connect/Boolean)

(s/def
  :cognitect.aws.connect.DescribeQuickConnectResponse/QuickConnect
  :cognitect.aws.connect/QuickConnect)

(s/def
  :cognitect.aws.connect.TaskTemplateDefaultFieldValue/Id
  :cognitect.aws.connect/TaskTemplateFieldIdentifier)

(s/def
  :cognitect.aws.connect.TaskTemplateDefaultFieldValue/DefaultValue
  :cognitect.aws.connect/TaskTemplateFieldValue)

(s/def
  :cognitect.aws.connect.AssociateLambdaFunctionRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.AssociateLambdaFunctionRequest/FunctionArn
  :cognitect.aws.connect/FunctionArn)

(s/def
  :cognitect.aws.connect.AssociateLambdaFunctionRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.UpdateSecurityProfileRequest/HierarchyRestrictedResources
  :cognitect.aws.connect/HierarchyRestrictedResourceList)

(s/def
  :cognitect.aws.connect.UpdateSecurityProfileRequest/SecurityProfileId
  :cognitect.aws.connect/SecurityProfileId)

(s/def
  :cognitect.aws.connect.UpdateSecurityProfileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateSecurityProfileRequest/AllowedAccessControlHierarchyGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def
  :cognitect.aws.connect.UpdateSecurityProfileRequest/Applications
  :cognitect.aws.connect/Applications)

(s/def
  :cognitect.aws.connect.UpdateSecurityProfileRequest/Permissions
  :cognitect.aws.connect/PermissionsList)

(s/def
  :cognitect.aws.connect.UpdateSecurityProfileRequest/AllowedAccessControlTags
  :cognitect.aws.connect/AllowedAccessControlTags)

(s/def
  :cognitect.aws.connect.UpdateSecurityProfileRequest/TagRestrictedResources
  :cognitect.aws.connect/TagRestrictedResourceList)

(s/def
  :cognitect.aws.connect.UpdateSecurityProfileRequest/Description
  :cognitect.aws.connect/SecurityProfileDescription)

(s/def
  :cognitect.aws.connect.ChatMetrics/ChatContactMetrics
  :cognitect.aws.connect/ChatContactMetrics)

(s/def :cognitect.aws.connect.ChatMetrics/AgentMetrics :cognitect.aws.connect/ParticipantMetrics)

(s/def :cognitect.aws.connect.ChatMetrics/CustomerMetrics :cognitect.aws.connect/ParticipantMetrics)

(s/def
  :cognitect.aws.connect.UpdateContactEvaluationResponse/EvaluationId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.UpdateContactEvaluationResponse/EvaluationArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.AuthenticationProfile/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.AuthenticationProfile/BlockedIps :cognitect.aws.connect/IpCidrList)

(s/def :cognitect.aws.connect.AuthenticationProfile/AllowedIps :cognitect.aws.connect/IpCidrList)

(s/def
  :cognitect.aws.connect.AuthenticationProfile/Id
  :cognitect.aws.connect/AuthenticationProfileId)

(s/def :cognitect.aws.connect.AuthenticationProfile/IsDefault :cognitect.aws.connect/Boolean)

(s/def
  :cognitect.aws.connect.AuthenticationProfile/PeriodicSessionDuration
  :cognitect.aws.connect/AccessTokenDuration)

(s/def
  :cognitect.aws.connect.AuthenticationProfile/MaxSessionDuration
  :cognitect.aws.connect/RefreshTokenDuration)

(s/def :cognitect.aws.connect.AuthenticationProfile/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.AuthenticationProfile/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.AuthenticationProfile/Name
  :cognitect.aws.connect/AuthenticationProfileName)

(s/def
  :cognitect.aws.connect.AuthenticationProfile/Description
  :cognitect.aws.connect/AuthenticationProfileDescription)

(s/def :cognitect.aws.connect.AuthenticationProfile/CreatedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.Customer/DeviceInfo :cognitect.aws.connect/DeviceInfo)

(s/def :cognitect.aws.connect.Customer/Capabilities :cognitect.aws.connect/ParticipantCapabilities)

(s/def
  :cognitect.aws.connect.TaskTemplateFieldIdentifier/Name
  :cognitect.aws.connect/TaskTemplateFieldName)

(s/def :cognitect.aws.connect.CreateParticipantRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.CreateParticipantRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.CreateParticipantRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.CreateParticipantRequest/ParticipantDetails
  :cognitect.aws.connect/ParticipantDetailsToAdd)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersResponse/PhoneNumberSummaryList
  :cognitect.aws.connect/PhoneNumberSummaryList)

(s/def :cognitect.aws.connect.ListPhoneNumbersResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ImportPhoneNumberRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ImportPhoneNumberRequest/SourcePhoneNumberArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ImportPhoneNumberRequest/PhoneNumberDescription
  :cognitect.aws.connect/PhoneNumberDescription)

(s/def :cognitect.aws.connect.ImportPhoneNumberRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.ImportPhoneNumberRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.StartOutboundChatContactResponse/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationOverridesResponse/HoursOfOperationOverrides
  :cognitect.aws.connect/HoursOfOperationOverrideList)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationOverridesResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationOverridesResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.CurrentMetric/Name :cognitect.aws.connect/CurrentMetricName)

(s/def :cognitect.aws.connect.CurrentMetric/Unit :cognitect.aws.connect/Unit)

(s/def :cognitect.aws.connect.SignInDistribution/Region :cognitect.aws.connect/AwsRegion)

(s/def :cognitect.aws.connect.SignInDistribution/Enabled :cognitect.aws.connect/Boolean)

(s/def
  :cognitect.aws.connect.CreateUserRequest/IdentityInfo
  :cognitect.aws.connect/UserIdentityInfo)

(s/def
  :cognitect.aws.connect.CreateUserRequest/SecurityProfileIds
  :cognitect.aws.connect/SecurityProfileIds)

(s/def :cognitect.aws.connect.CreateUserRequest/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.CreateUserRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateUserRequest/DirectoryUserId
  :cognitect.aws.connect/DirectoryUserId)

(s/def :cognitect.aws.connect.CreateUserRequest/Password :cognitect.aws.connect/Password)

(s/def
  :cognitect.aws.connect.CreateUserRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def :cognitect.aws.connect.CreateUserRequest/PhoneConfig :cognitect.aws.connect/UserPhoneConfig)

(s/def :cognitect.aws.connect.CreateUserRequest/Username :cognitect.aws.connect/AgentUsername)

(s/def
  :cognitect.aws.connect.CreateUserRequest/HierarchyGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def :cognitect.aws.connect.ListCondition/TargetListType :cognitect.aws.connect/TargetListType)

(s/def :cognitect.aws.connect.ListCondition/Conditions :cognitect.aws.connect/Conditions)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormRequest/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormRequest/Items
  :cognitect.aws.connect/EvaluationFormItemsList)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormRequest/Title
  :cognitect.aws.connect/EvaluationFormTitle)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormRequest/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormRequest/ScoringStrategy
  :cognitect.aws.connect/EvaluationFormScoringStrategy)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormRequest/Description
  :cognitect.aws.connect/EvaluationFormDescription)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.UpdateEvaluationFormRequest/CreateNewVersion
  :cognitect.aws.connect/BoxedBoolean)

(s/def
  :cognitect.aws.connect.StartTaskContactRequest/References
  :cognitect.aws.connect/ContactReferences)

(s/def
  :cognitect.aws.connect.StartTaskContactRequest/QuickConnectId
  :cognitect.aws.connect/QuickConnectId)

(s/def
  :cognitect.aws.connect.StartTaskContactRequest/PreviousContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartTaskContactRequest/SegmentAttributes
  :cognitect.aws.connect/SegmentAttributes)

(s/def
  :cognitect.aws.connect.StartTaskContactRequest/ScheduledTime
  :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.StartTaskContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartTaskContactRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.StartTaskContactRequest/TaskTemplateId
  :cognitect.aws.connect/TaskTemplateId)

(s/def
  :cognitect.aws.connect.StartTaskContactRequest/RelatedContactId
  :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.StartTaskContactRequest/Name :cognitect.aws.connect/Name)

(s/def
  :cognitect.aws.connect.StartTaskContactRequest/Description
  :cognitect.aws.connect/Description)

(s/def
  :cognitect.aws.connect.StartTaskContactRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.StartTaskContactRequest/Attributes :cognitect.aws.connect/Attributes)

(s/def
  :cognitect.aws.connect.DescribeContactEvaluationResponse/Evaluation
  :cognitect.aws.connect/Evaluation)

(s/def
  :cognitect.aws.connect.DescribeContactEvaluationResponse/EvaluationForm
  :cognitect.aws.connect/EvaluationFormContent)

(s/def
  :cognitect.aws.connect.RoutingCriteriaInput/Steps
  :cognitect.aws.connect/RoutingCriteriaInputSteps)

(s/def
  :cognitect.aws.connect.ControlPlaneUserAttributeFilter/OrConditions
  :cognitect.aws.connect/AttributeOrConditionList)

(s/def
  :cognitect.aws.connect.ControlPlaneUserAttributeFilter/AndCondition
  :cognitect.aws.connect/AttributeAndCondition)

(s/def
  :cognitect.aws.connect.ControlPlaneUserAttributeFilter/TagCondition
  :cognitect.aws.connect/TagCondition)

(s/def
  :cognitect.aws.connect.ControlPlaneUserAttributeFilter/HierarchyGroupCondition
  :cognitect.aws.connect/HierarchyGroupCondition)

(s/def
  :cognitect.aws.connect.ListUseCasesResponse/UseCaseSummaryList
  :cognitect.aws.connect/UseCaseSummaryList)

(s/def :cognitect.aws.connect.ListUseCasesResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.CreateRuleRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.CreateRuleRequest/Name :cognitect.aws.connect/RuleName)

(s/def
  :cognitect.aws.connect.CreateRuleRequest/TriggerEventSource
  :cognitect.aws.connect/RuleTriggerEventSource)

(s/def :cognitect.aws.connect.CreateRuleRequest/Function :cognitect.aws.connect/RuleFunction)

(s/def :cognitect.aws.connect.CreateRuleRequest/Actions :cognitect.aws.connect/RuleActions)

(s/def
  :cognitect.aws.connect.CreateRuleRequest/PublishStatus
  :cognitect.aws.connect/RulePublishStatus)

(s/def :cognitect.aws.connect.CreateRuleRequest/ClientToken :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.AssociateRoutingProfileQueuesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.AssociateRoutingProfileQueuesRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def
  :cognitect.aws.connect.AssociateRoutingProfileQueuesRequest/QueueConfigs
  :cognitect.aws.connect/RoutingProfileQueueConfigList)

(s/def
  :cognitect.aws.connect.OutboundContactNotPermittedException/Message
  :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.OutboundEmailConfig/OutboundEmailAddressId
  :cognitect.aws.connect/EmailAddressId)

(s/def
  :cognitect.aws.connect.ReplicationConfiguration/ReplicationStatusSummaryList
  :cognitect.aws.connect/ReplicationStatusSummaryList)

(s/def
  :cognitect.aws.connect.ReplicationConfiguration/SourceRegion
  :cognitect.aws.connect/AwsRegion)

(s/def
  :cognitect.aws.connect.ReplicationConfiguration/GlobalSignInEndpoint
  :cognitect.aws.connect/GlobalSignInEndpoint)

(s/def :cognitect.aws.connect.ContactDetails/Name :cognitect.aws.connect/ContactDetailName)

(s/def
  :cognitect.aws.connect.ContactDetails/Description
  :cognitect.aws.connect/ContactDetailDescription)

(s/def
  :cognitect.aws.connect.BatchGetAttachedFileMetadataRequest/FileIds
  :cognitect.aws.connect/FileIdList)

(s/def
  :cognitect.aws.connect.BatchGetAttachedFileMetadataRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.BatchGetAttachedFileMetadataRequest/AssociatedResourceArn
  :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Credentials/AccessToken :cognitect.aws.connect/SecurityToken)

(s/def :cognitect.aws.connect.Credentials/AccessTokenExpiration :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.Credentials/RefreshToken :cognitect.aws.connect/SecurityToken)

(s/def :cognitect.aws.connect.Credentials/RefreshTokenExpiration :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.EvaluationFormSingleSelectQuestionAutomation/Options
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionAutomationOptionList)

(s/def
  :cognitect.aws.connect.EvaluationFormSingleSelectQuestionAutomation/DefaultOptionRefId
  :cognitect.aws.connect/ReferenceId)

(s/def :cognitect.aws.connect.EvaluationMetadata/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.EvaluationMetadata/EvaluatorArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.EvaluationMetadata/ContactAgentId :cognitect.aws.connect/ResourceId)

(s/def :cognitect.aws.connect.EvaluationMetadata/Score :cognitect.aws.connect/EvaluationScore)

(s/def :cognitect.aws.connect.RuleSummary/Name :cognitect.aws.connect/RuleName)

(s/def :cognitect.aws.connect.RuleSummary/RuleId :cognitect.aws.connect/RuleId)

(s/def :cognitect.aws.connect.RuleSummary/RuleArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.RuleSummary/EventSourceName :cognitect.aws.connect/EventSourceName)

(s/def :cognitect.aws.connect.RuleSummary/PublishStatus :cognitect.aws.connect/RulePublishStatus)

(s/def :cognitect.aws.connect.RuleSummary/ActionSummaries :cognitect.aws.connect/ActionSummaries)

(s/def :cognitect.aws.connect.RuleSummary/CreatedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.RuleSummary/LastUpdatedTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.SearchAvailablePhoneNumbersResponse/NextToken
  :cognitect.aws.connect/LargeNextToken)

(s/def
  :cognitect.aws.connect.SearchAvailablePhoneNumbersResponse/AvailableNumbersList
  :cognitect.aws.connect/AvailableNumbersList)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentPostContactSummary/Content
  :cognitect.aws.connect/RealTimeContactAnalysisPostContactSummaryContent)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentPostContactSummary/Status
  :cognitect.aws.connect/RealTimeContactAnalysisPostContactSummaryStatus)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentPostContactSummary/FailureCode
  :cognitect.aws.connect/RealTimeContactAnalysisPostContactSummaryFailureCode)

(s/def
  :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Response/Channel
  :cognitect.aws.connect/RealTimeContactAnalysisSupportedChannel)

(s/def
  :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Response/Status
  :cognitect.aws.connect/RealTimeContactAnalysisStatus)

(s/def
  :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Response/Segments
  :cognitect.aws.connect/RealtimeContactAnalysisSegments)

(s/def
  :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Response/NextToken
  :cognitect.aws.connect/LargeNextToken)

(s/def
  :cognitect.aws.connect.EvaluationFormQuestionTypeProperties/Numeric
  :cognitect.aws.connect/EvaluationFormNumericQuestionProperties)

(s/def
  :cognitect.aws.connect.EvaluationFormQuestionTypeProperties/SingleSelect
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionProperties)

(s/def :cognitect.aws.connect.Prompt/PromptARN :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Prompt/PromptId :cognitect.aws.connect/PromptId)

(s/def :cognitect.aws.connect.Prompt/Name :cognitect.aws.connect/CommonNameLength127)

(s/def :cognitect.aws.connect.Prompt/Description :cognitect.aws.connect/PromptDescription)

(s/def :cognitect.aws.connect.Prompt/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.Prompt/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.Prompt/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.DeleteViewRequest/InstanceId :cognitect.aws.connect/ViewsInstanceId)

(s/def :cognitect.aws.connect.DeleteViewRequest/ViewId :cognitect.aws.connect/ViewId)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverrideSearchCriteria/OrConditions
  :cognitect.aws.connect/HoursOfOperationOverrideSearchConditionList)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverrideSearchCriteria/AndConditions
  :cognitect.aws.connect/HoursOfOperationOverrideSearchConditionList)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverrideSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverrideSearchCriteria/DateCondition
  :cognitect.aws.connect/DateCondition)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileQueuesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileQueuesRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileQueuesRequest/QueueConfigs
  :cognitect.aws.connect/RoutingProfileQueueConfigList)

(s/def
  :cognitect.aws.connect.CreateQuickConnectRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateQuickConnectRequest/Name
  :cognitect.aws.connect/QuickConnectName)

(s/def
  :cognitect.aws.connect.CreateQuickConnectRequest/Description
  :cognitect.aws.connect/QuickConnectDescription)

(s/def
  :cognitect.aws.connect.CreateQuickConnectRequest/QuickConnectConfig
  :cognitect.aws.connect/QuickConnectConfig)

(s/def :cognitect.aws.connect.CreateQuickConnectRequest/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.SearchQueuesRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.SearchQueuesRequest/NextToken :cognitect.aws.connect/NextToken2500)

(s/def :cognitect.aws.connect.SearchQueuesRequest/MaxResults :cognitect.aws.connect/MaxResult500)

(s/def
  :cognitect.aws.connect.SearchQueuesRequest/SearchFilter
  :cognitect.aws.connect/QueueSearchFilter)

(s/def
  :cognitect.aws.connect.SearchQueuesRequest/SearchCriteria
  :cognitect.aws.connect/QueueSearchCriteria)

(s/def
  :cognitect.aws.connect.EvaluationFormNumericQuestionAutomation/PropertyValue
  :cognitect.aws.connect/NumericQuestionPropertyValueAutomation)

(s/def
  :cognitect.aws.connect.CreateIntegrationAssociationResponse/IntegrationAssociationId
  :cognitect.aws.connect/IntegrationAssociationId)

(s/def
  :cognitect.aws.connect.CreateIntegrationAssociationResponse/IntegrationAssociationArn
  :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.DeleteContactFlowRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteContactFlowRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.ListViewVersionsResponse/ViewVersionSummaryList
  :cognitect.aws.connect/ViewVersionSummaryList)

(s/def
  :cognitect.aws.connect.ListViewVersionsResponse/NextToken
  :cognitect.aws.connect/ViewsNextToken)

(s/def
  :cognitect.aws.connect.CreateUserHierarchyGroupRequest/Name
  :cognitect.aws.connect/HierarchyGroupName)

(s/def
  :cognitect.aws.connect.CreateUserHierarchyGroupRequest/ParentGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def
  :cognitect.aws.connect.CreateUserHierarchyGroupRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.CreateUserHierarchyGroupRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.DeleteEvaluationFormRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteEvaluationFormRequest/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.DeleteEvaluationFormRequest/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/Id
  :cognitect.aws.connect/RealTimeContactAnalysisId256)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/ParticipantId
  :cognitect.aws.connect/ParticipantId)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/ParticipantRole
  :cognitect.aws.connect/ParticipantRole)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/DisplayName
  :cognitect.aws.connect/DisplayName)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/EventType
  :cognitect.aws.connect/RealTimeContactAnalysisEventType)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentEvent/Time
  :cognitect.aws.connect/RealTimeContactAnalysisTimeData)

(s/def :cognitect.aws.connect.MonitorContactResponse/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.MonitorContactResponse/ContactArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.QuickConnectConfig/QuickConnectType
  :cognitect.aws.connect/QuickConnectType)

(s/def
  :cognitect.aws.connect.QuickConnectConfig/UserConfig
  :cognitect.aws.connect/UserQuickConnectConfig)

(s/def
  :cognitect.aws.connect.QuickConnectConfig/QueueConfig
  :cognitect.aws.connect/QueueQuickConnectConfig)

(s/def
  :cognitect.aws.connect.QuickConnectConfig/PhoneConfig
  :cognitect.aws.connect/PhoneNumberQuickConnectConfig)

(s/def
  :cognitect.aws.connect.ListSecurityProfilesResponse/SecurityProfileSummaryList
  :cognitect.aws.connect/SecurityProfileSummaryList)

(s/def
  :cognitect.aws.connect.ListSecurityProfilesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ListLexBotsResponse/LexBots :cognitect.aws.connect/LexBotsList)

(s/def :cognitect.aws.connect.ListLexBotsResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.DisconnectDetails/PotentialDisconnectIssue
  :cognitect.aws.connect/PotentialDisconnectIssue)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataLakeDataSetsResponse/Results
  :cognitect.aws.connect/AnalyticsDataSetsResults)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataLakeDataSetsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.EvaluationScore/Percentage
  :cognitect.aws.connect/EvaluationScorePercentage)

(s/def :cognitect.aws.connect.EvaluationScore/NotApplicable :cognitect.aws.connect/Boolean)

(s/def :cognitect.aws.connect.EvaluationScore/AutomaticFail :cognitect.aws.connect/Boolean)

(s/def :cognitect.aws.connect.CreatePromptResponse/PromptARN :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.CreatePromptResponse/PromptId :cognitect.aws.connect/PromptId)

(s/def
  :cognitect.aws.connect.CreatePredefinedAttributeRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreatePredefinedAttributeRequest/Name
  :cognitect.aws.connect/PredefinedAttributeName)

(s/def
  :cognitect.aws.connect.CreatePredefinedAttributeRequest/Values
  :cognitect.aws.connect/PredefinedAttributeValues)

(s/def
  :cognitect.aws.connect.CustomerQualityMetrics/Audio
  :cognitect.aws.connect/AudioQualityMetricsInfo)

(s/def
  :cognitect.aws.connect.CreatePersistentContactAssociationResponse/ContinuedFromContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ListEvaluationFormVersionsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListEvaluationFormVersionsRequest/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.ListEvaluationFormVersionsRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.ListEvaluationFormVersionsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.UpdateCaseActionDefinition/Fields :cognitect.aws.connect/FieldValues)

(s/def
  :cognitect.aws.connect.UpdatePhoneNumberRequest/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def :cognitect.aws.connect.UpdatePhoneNumberRequest/TargetArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.UpdatePhoneNumberRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdatePhoneNumberRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.ListTaskTemplatesRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListTaskTemplatesRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListTaskTemplatesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.ListTaskTemplatesRequest/Status
  :cognitect.aws.connect/TaskTemplateStatus)

(s/def :cognitect.aws.connect.ListTaskTemplatesRequest/Name :cognitect.aws.connect/TaskTemplateName)

(s/def :cognitect.aws.connect.DownloadUrlMetadata/Url :cognitect.aws.connect/MetadataUrl)

(s/def :cognitect.aws.connect.DownloadUrlMetadata/UrlExpiry :cognitect.aws.connect/ISO8601Datetime)

(s/def
  :cognitect.aws.connect.PredefinedAttributeSearchCriteria/OrConditions
  :cognitect.aws.connect/PredefinedAttributeSearchConditionList)

(s/def
  :cognitect.aws.connect.PredefinedAttributeSearchCriteria/AndConditions
  :cognitect.aws.connect/PredefinedAttributeSearchConditionList)

(s/def
  :cognitect.aws.connect.PredefinedAttributeSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def
  :cognitect.aws.connect.DescribeHoursOfOperationResponse/HoursOfOperation
  :cognitect.aws.connect/HoursOfOperation)

(s/def :cognitect.aws.connect.DescribeInstanceResponse/Instance :cognitect.aws.connect/Instance)

(s/def
  :cognitect.aws.connect.DescribeInstanceResponse/ReplicationConfiguration
  :cognitect.aws.connect/ReplicationConfiguration)

(s/def :cognitect.aws.connect.ChatContactMetrics/MultiParty :cognitect.aws.connect/NullableBoolean)

(s/def :cognitect.aws.connect.ChatContactMetrics/TotalMessages :cognitect.aws.connect/Count)

(s/def :cognitect.aws.connect.ChatContactMetrics/TotalBotMessages :cognitect.aws.connect/Count)

(s/def
  :cognitect.aws.connect.ChatContactMetrics/TotalBotMessageLengthInChars
  :cognitect.aws.connect/Count)

(s/def
  :cognitect.aws.connect.ChatContactMetrics/ConversationCloseTimeInMillis
  :cognitect.aws.connect/DurationMillis)

(s/def :cognitect.aws.connect.ChatContactMetrics/ConversationTurnCount :cognitect.aws.connect/Count)

(s/def
  :cognitect.aws.connect.ChatContactMetrics/AgentFirstResponseTimestamp
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.ChatContactMetrics/AgentFirstResponseTimeInMillis
  :cognitect.aws.connect/DurationMillis)

(s/def
  :cognitect.aws.connect.PhoneNumberQuickConnectConfig/PhoneNumber
  :cognitect.aws.connect/PhoneNumber)

(s/def
  :cognitect.aws.connect.ChatParticipantRoleConfig/ParticipantTimerConfigList
  :cognitect.aws.connect/ParticipantTimerConfigList)

(s/def
  :cognitect.aws.connect.SearchResourceTagsRequest/InstanceId
  :cognitect.aws.connect/InstanceIdOrArn)

(s/def
  :cognitect.aws.connect.SearchResourceTagsRequest/ResourceTypes
  :cognitect.aws.connect/ResourceTypeList)

(s/def
  :cognitect.aws.connect.SearchResourceTagsRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchResourceTagsRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchResourceTagsRequest/SearchCriteria
  :cognitect.aws.connect/ResourceTagsSearchCriteria)

(s/def :cognitect.aws.connect.CurrentMetricData/Metric :cognitect.aws.connect/CurrentMetric)

(s/def :cognitect.aws.connect.CurrentMetricData/Value :cognitect.aws.connect/Value)

(s/def
  :cognitect.aws.connect.UpdateUserHierarchyStructureRequest/HierarchyStructure
  :cognitect.aws.connect/HierarchyStructureUpdate)

(s/def
  :cognitect.aws.connect.UpdateUserHierarchyStructureRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartContactEvaluationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartContactEvaluationRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartContactEvaluationRequest/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.StartContactEvaluationRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.AgentHierarchyGroup/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.ContactDataRequest/SystemEndpoint :cognitect.aws.connect/Endpoint)

(s/def :cognitect.aws.connect.ContactDataRequest/CustomerEndpoint :cognitect.aws.connect/Endpoint)

(s/def
  :cognitect.aws.connect.ContactDataRequest/RequestIdentifier
  :cognitect.aws.connect/RequestIdentifier)

(s/def :cognitect.aws.connect.ContactDataRequest/QueueId :cognitect.aws.connect/QueueId)

(s/def :cognitect.aws.connect.ContactDataRequest/Attributes :cognitect.aws.connect/Attributes)

(s/def :cognitect.aws.connect.ContactDataRequest/Campaign :cognitect.aws.connect/Campaign)

(s/def :cognitect.aws.connect.MetricResultV2/Dimensions :cognitect.aws.connect/DimensionsV2Map)

(s/def :cognitect.aws.connect.MetricResultV2/MetricInterval :cognitect.aws.connect/MetricInterval)

(s/def
  :cognitect.aws.connect.MetricResultV2/Collections
  :cognitect.aws.connect/MetricDataCollectionsV2)

(s/def :cognitect.aws.connect.UpdatePromptRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.UpdatePromptRequest/PromptId :cognitect.aws.connect/PromptId)

(s/def :cognitect.aws.connect.UpdatePromptRequest/Name :cognitect.aws.connect/CommonNameLength127)

(s/def
  :cognitect.aws.connect.UpdatePromptRequest/Description
  :cognitect.aws.connect/PromptDescription)

(s/def :cognitect.aws.connect.UpdatePromptRequest/S3Uri :cognitect.aws.connect/S3Uri)

(s/def :cognitect.aws.connect.QueueSummary/Id :cognitect.aws.connect/QueueId)

(s/def :cognitect.aws.connect.QueueSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.QueueSummary/Name :cognitect.aws.connect/QueueName)

(s/def :cognitect.aws.connect.QueueSummary/QueueType :cognitect.aws.connect/QueueType)

(s/def :cognitect.aws.connect.QueueSummary/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.QueueSummary/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.VocabularySummary/Name :cognitect.aws.connect/VocabularyName)

(s/def :cognitect.aws.connect.VocabularySummary/Id :cognitect.aws.connect/VocabularyId)

(s/def :cognitect.aws.connect.VocabularySummary/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.VocabularySummary/LanguageCode
  :cognitect.aws.connect/VocabularyLanguageCode)

(s/def :cognitect.aws.connect.VocabularySummary/State :cognitect.aws.connect/VocabularyState)

(s/def
  :cognitect.aws.connect.VocabularySummary/LastModifiedTime
  :cognitect.aws.connect/VocabularyLastModifiedTime)

(s/def
  :cognitect.aws.connect.VocabularySummary/FailureReason
  :cognitect.aws.connect/VocabularyFailureReason)

(s/def
  :cognitect.aws.connect.DescribeHoursOfOperationOverrideRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeHoursOfOperationOverrideRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def
  :cognitect.aws.connect.DescribeHoursOfOperationOverrideRequest/HoursOfOperationOverrideId
  :cognitect.aws.connect/HoursOfOperationOverrideId)

(s/def
  :cognitect.aws.connect.PropertyValidationExceptionProperty/PropertyPath
  :cognitect.aws.connect/String)

(s/def
  :cognitect.aws.connect.PropertyValidationExceptionProperty/Reason
  :cognitect.aws.connect/PropertyValidationExceptionReason)

(s/def
  :cognitect.aws.connect.PropertyValidationExceptionProperty/Message
  :cognitect.aws.connect/Message)

(s/def :cognitect.aws.connect.UpdateQueueStatusRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.UpdateQueueStatusRequest/QueueId :cognitect.aws.connect/QueueId)

(s/def :cognitect.aws.connect.UpdateQueueStatusRequest/Status :cognitect.aws.connect/QueueStatus)

(s/def
  :cognitect.aws.connect.GetFederationTokenResponse/Credentials
  :cognitect.aws.connect/Credentials)

(s/def :cognitect.aws.connect.GetFederationTokenResponse/SignInUrl :cognitect.aws.connect/Url)

(s/def :cognitect.aws.connect.GetFederationTokenResponse/UserArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.GetFederationTokenResponse/UserId
  :cognitect.aws.connect/AgentResourceId)

(s/def
  :cognitect.aws.connect.UserHierarchyGroupSearchFilter/AttributeFilter
  :cognitect.aws.connect/ControlPlaneAttributeFilter)

(s/def
  :cognitect.aws.connect.DescribeUserHierarchyGroupRequest/HierarchyGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def
  :cognitect.aws.connect.DescribeUserHierarchyGroupRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.Attendee/AttendeeId :cognitect.aws.connect/AttendeeId)

(s/def :cognitect.aws.connect.Attendee/JoinToken :cognitect.aws.connect/JoinToken)

(s/def :cognitect.aws.connect.QueueInfoInput/Id :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.SendChatIntegrationEventResponse/InitialContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.SendChatIntegrationEventResponse/NewChatCreated
  :cognitect.aws.connect/NewChatCreated)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemRedaction/CharacterOffsets
  :cognitect.aws.connect/RealTimeContactAnalysisCharacterIntervals)

(s/def
  :cognitect.aws.connect.DescribeContactEvaluationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeContactEvaluationRequest/EvaluationId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.UpdateEmailAddressMetadataRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateEmailAddressMetadataRequest/EmailAddressId
  :cognitect.aws.connect/EmailAddressId)

(s/def
  :cognitect.aws.connect.UpdateEmailAddressMetadataRequest/Description
  :cognitect.aws.connect/Description)

(s/def
  :cognitect.aws.connect.UpdateEmailAddressMetadataRequest/DisplayName
  :cognitect.aws.connect/EmailAddressDisplayName)

(s/def
  :cognitect.aws.connect.UpdateEmailAddressMetadataRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.UpdateUserRoutingProfileRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def :cognitect.aws.connect.UpdateUserRoutingProfileRequest/UserId :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.UpdateUserRoutingProfileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateRoutingProfileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateRoutingProfileRequest/Name
  :cognitect.aws.connect/RoutingProfileName)

(s/def
  :cognitect.aws.connect.CreateRoutingProfileRequest/Description
  :cognitect.aws.connect/RoutingProfileDescription)

(s/def
  :cognitect.aws.connect.CreateRoutingProfileRequest/DefaultOutboundQueueId
  :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.CreateRoutingProfileRequest/QueueConfigs
  :cognitect.aws.connect/RoutingProfileQueueConfigList)

(s/def
  :cognitect.aws.connect.CreateRoutingProfileRequest/MediaConcurrencies
  :cognitect.aws.connect/MediaConcurrencies)

(s/def :cognitect.aws.connect.CreateRoutingProfileRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.CreateRoutingProfileRequest/AgentAvailabilityTimer
  :cognitect.aws.connect/AgentAvailabilityTimer)

(s/def
  :cognitect.aws.connect.ReadOnlyFieldInfo/Id
  :cognitect.aws.connect/TaskTemplateFieldIdentifier)

(s/def :cognitect.aws.connect.SecurityKey/AssociationId :cognitect.aws.connect/AssociationId)

(s/def :cognitect.aws.connect.SecurityKey/Key :cognitect.aws.connect/PEM)

(s/def :cognitect.aws.connect.SecurityKey/CreationTime :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.CreateQueueRequest/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.CreateQueueRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateQueueRequest/MaxContacts
  :cognitect.aws.connect/QueueMaxContacts)

(s/def
  :cognitect.aws.connect.CreateQueueRequest/QuickConnectIds
  :cognitect.aws.connect/QuickConnectsList)

(s/def
  :cognitect.aws.connect.CreateQueueRequest/OutboundCallerConfig
  :cognitect.aws.connect/OutboundCallerConfig)

(s/def
  :cognitect.aws.connect.CreateQueueRequest/OutboundEmailConfig
  :cognitect.aws.connect/OutboundEmailConfig)

(s/def :cognitect.aws.connect.CreateQueueRequest/Name :cognitect.aws.connect/CommonNameLength127)

(s/def
  :cognitect.aws.connect.CreateQueueRequest/Description
  :cognitect.aws.connect/QueueDescription)

(s/def
  :cognitect.aws.connect.CreateQueueRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def :cognitect.aws.connect.StartChatContactResponse/ContactId :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartChatContactResponse/ParticipantId
  :cognitect.aws.connect/ParticipantId)

(s/def
  :cognitect.aws.connect.StartChatContactResponse/ParticipantToken
  :cognitect.aws.connect/ParticipantToken)

(s/def
  :cognitect.aws.connect.StartChatContactResponse/ContinuedFromContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileDefaultOutboundQueueRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileDefaultOutboundQueueRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileDefaultOutboundQueueRequest/DefaultOutboundQueueId
  :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.BatchGetAttachedFileMetadataResponse/Files
  :cognitect.aws.connect/AttachedFilesList)

(s/def
  :cognitect.aws.connect.BatchGetAttachedFileMetadataResponse/Errors
  :cognitect.aws.connect/AttachedFileErrorsList)

(s/def
  :cognitect.aws.connect.SearchVocabulariesResponse/VocabularySummaryList
  :cognitect.aws.connect/VocabularySummaryList)

(s/def
  :cognitect.aws.connect.SearchVocabulariesResponse/NextToken
  :cognitect.aws.connect/VocabularyNextToken)

(s/def :cognitect.aws.connect.QueueQuickConnectConfig/QueueId :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.QueueQuickConnectConfig/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.SearchAgentStatusesResponse/AgentStatuses
  :cognitect.aws.connect/AgentStatusList)

(s/def
  :cognitect.aws.connect.SearchAgentStatusesResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchAgentStatusesResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def
  :cognitect.aws.connect.HierarchyPathReference/LevelOne
  :cognitect.aws.connect/HierarchyGroupSummaryReference)

(s/def
  :cognitect.aws.connect.HierarchyPathReference/LevelTwo
  :cognitect.aws.connect/HierarchyGroupSummaryReference)

(s/def
  :cognitect.aws.connect.HierarchyPathReference/LevelThree
  :cognitect.aws.connect/HierarchyGroupSummaryReference)

(s/def
  :cognitect.aws.connect.HierarchyPathReference/LevelFour
  :cognitect.aws.connect/HierarchyGroupSummaryReference)

(s/def
  :cognitect.aws.connect.HierarchyPathReference/LevelFive
  :cognitect.aws.connect/HierarchyGroupSummaryReference)

(s/def
  :cognitect.aws.connect.ListQueuesResponse/QueueSummaryList
  :cognitect.aws.connect/QueueSummaryList)

(s/def :cognitect.aws.connect.ListQueuesResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.Instance/OutboundCallsEnabled
  :cognitect.aws.connect/OutboundCallsEnabled)

(s/def :cognitect.aws.connect.Instance/StatusReason :cognitect.aws.connect/InstanceStatusReason)

(s/def :cognitect.aws.connect.Instance/Id :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.Instance/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.Instance/InstanceAlias :cognitect.aws.connect/DirectoryAlias)

(s/def :cognitect.aws.connect.Instance/IdentityManagementType :cognitect.aws.connect/DirectoryType)

(s/def :cognitect.aws.connect.Instance/InstanceStatus :cognitect.aws.connect/InstanceStatus)

(s/def :cognitect.aws.connect.Instance/ServiceRole :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Instance/InstanceAccessUrl :cognitect.aws.connect/Url)

(s/def :cognitect.aws.connect.Instance/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Instance/CreatedTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.Instance/InboundCallsEnabled
  :cognitect.aws.connect/InboundCallsEnabled)

(s/def
  :cognitect.aws.connect.DescribeContactFlowRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeContactFlowRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def :cognitect.aws.connect.UseCase/UseCaseId :cognitect.aws.connect/UseCaseId)

(s/def :cognitect.aws.connect.UseCase/UseCaseArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.UseCase/UseCaseType :cognitect.aws.connect/UseCaseType)

(s/def
  :cognitect.aws.connect.UpdateInstanceStorageConfigRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateInstanceStorageConfigRequest/AssociationId
  :cognitect.aws.connect/AssociationId)

(s/def
  :cognitect.aws.connect.UpdateInstanceStorageConfigRequest/ResourceType
  :cognitect.aws.connect/InstanceStorageResourceType)

(s/def
  :cognitect.aws.connect.UpdateInstanceStorageConfigRequest/StorageConfig
  :cognitect.aws.connect/InstanceStorageConfig)

(s/def
  :cognitect.aws.connect.UpdateInstanceStorageConfigRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.TagContactRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.TagContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.TagContactRequest/Tags :cognitect.aws.connect/ContactTagMap)

(s/def
  :cognitect.aws.connect.ListUserHierarchyGroupsResponse/UserHierarchyGroupSummaryList
  :cognitect.aws.connect/HierarchyGroupSummaryList)

(s/def
  :cognitect.aws.connect.ListUserHierarchyGroupsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ErrorResult/ErrorCode :cognitect.aws.connect/String)

(s/def :cognitect.aws.connect.ErrorResult/ErrorMessage :cognitect.aws.connect/String)

(s/def
  :cognitect.aws.connect.DisassociateInstanceStorageConfigRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DisassociateInstanceStorageConfigRequest/AssociationId
  :cognitect.aws.connect/AssociationId)

(s/def
  :cognitect.aws.connect.DisassociateInstanceStorageConfigRequest/ResourceType
  :cognitect.aws.connect/InstanceStorageResourceType)

(s/def
  :cognitect.aws.connect.DisassociateInstanceStorageConfigRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.DescribeRoutingProfileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeRoutingProfileRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def :cognitect.aws.connect.UserIdentityInfo/FirstName :cognitect.aws.connect/AgentFirstName)

(s/def :cognitect.aws.connect.UserIdentityInfo/LastName :cognitect.aws.connect/AgentLastName)

(s/def :cognitect.aws.connect.UserIdentityInfo/Email :cognitect.aws.connect/Email)

(s/def :cognitect.aws.connect.UserIdentityInfo/SecondaryEmail :cognitect.aws.connect/Email)

(s/def :cognitect.aws.connect.UserIdentityInfo/Mobile :cognitect.aws.connect/PhoneNumber)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisPointOfInterest/TranscriptItems
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptItemsWithCharacterOffsets)

(s/def :cognitect.aws.connect.MediaPlacement/AudioHostUrl :cognitect.aws.connect/URI)

(s/def :cognitect.aws.connect.MediaPlacement/AudioFallbackUrl :cognitect.aws.connect/URI)

(s/def :cognitect.aws.connect.MediaPlacement/SignalingUrl :cognitect.aws.connect/URI)

(s/def :cognitect.aws.connect.MediaPlacement/TurnControlUrl :cognitect.aws.connect/URI)

(s/def :cognitect.aws.connect.MediaPlacement/EventIngestionUrl :cognitect.aws.connect/URI)

(s/def
  :cognitect.aws.connect.AgentStatusSearchFilter/AttributeFilter
  :cognitect.aws.connect/ControlPlaneAttributeFilter)

(s/def :cognitect.aws.connect.HistoricalMetric/Name :cognitect.aws.connect/HistoricalMetricName)

(s/def :cognitect.aws.connect.HistoricalMetric/Threshold :cognitect.aws.connect/Threshold)

(s/def :cognitect.aws.connect.HistoricalMetric/Statistic :cognitect.aws.connect/Statistic)

(s/def :cognitect.aws.connect.HistoricalMetric/Unit :cognitect.aws.connect/Unit)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersV2Response/NextToken
  :cognitect.aws.connect/LargeNextToken)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersV2Response/ListPhoneNumbersSummaryList
  :cognitect.aws.connect/ListPhoneNumbersSummaryList)

(s/def :cognitect.aws.connect.CreateUseCaseResponse/UseCaseId :cognitect.aws.connect/UseCaseId)

(s/def :cognitect.aws.connect.CreateUseCaseResponse/UseCaseArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/DestinationEmailAddress
  :cognitect.aws.connect/EmailAddress)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/References
  :cognitect.aws.connect/ContactReferences)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/SegmentAttributes
  :cognitect.aws.connect/SegmentAttributes)

(s/def :cognitect.aws.connect.StartEmailContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/RelatedContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/EmailMessage
  :cognitect.aws.connect/InboundEmailContent)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/Attachments
  :cognitect.aws.connect/EmailAttachments)

(s/def :cognitect.aws.connect.StartEmailContactRequest/Name :cognitect.aws.connect/Name)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/Description
  :cognitect.aws.connect/Description)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/FromEmailAddress
  :cognitect.aws.connect/EmailAddressInfo)

(s/def
  :cognitect.aws.connect.StartEmailContactRequest/AdditionalRecipients
  :cognitect.aws.connect/InboundAdditionalRecipients)

(s/def :cognitect.aws.connect.StartEmailContactRequest/Attributes :cognitect.aws.connect/Attributes)

(s/def :cognitect.aws.connect.CreateUseCaseRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateUseCaseRequest/IntegrationAssociationId
  :cognitect.aws.connect/IntegrationAssociationId)

(s/def :cognitect.aws.connect.CreateUseCaseRequest/UseCaseType :cognitect.aws.connect/UseCaseType)

(s/def :cognitect.aws.connect.CreateUseCaseRequest/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.ClaimPhoneNumberRequest/TargetArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.ClaimPhoneNumberRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ClaimPhoneNumberRequest/PhoneNumber
  :cognitect.aws.connect/PhoneNumber)

(s/def
  :cognitect.aws.connect.ClaimPhoneNumberRequest/PhoneNumberDescription
  :cognitect.aws.connect/PhoneNumberDescription)

(s/def :cognitect.aws.connect.ClaimPhoneNumberRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.ClaimPhoneNumberRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.UpdateContactFlowMetadataRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowMetadataRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowMetadataRequest/Name
  :cognitect.aws.connect/ContactFlowName)

(s/def
  :cognitect.aws.connect.UpdateContactFlowMetadataRequest/Description
  :cognitect.aws.connect/ContactFlowDescription)

(s/def
  :cognitect.aws.connect.UpdateContactFlowMetadataRequest/ContactFlowState
  :cognitect.aws.connect/ContactFlowState)

(s/def :cognitect.aws.connect.DeleteVocabularyRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteVocabularyRequest/VocabularyId
  :cognitect.aws.connect/VocabularyId)

(s/def :cognitect.aws.connect.PersistentChat/RehydrationType :cognitect.aws.connect/RehydrationType)

(s/def :cognitect.aws.connect.PersistentChat/SourceContactId :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ContactFlowSearchFilter/TagFilter
  :cognitect.aws.connect/ControlPlaneTagFilter)

(s/def
  :cognitect.aws.connect.CreateContactFlowResponse/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def :cognitect.aws.connect.CreateContactFlowResponse/ContactFlowArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateContactFlowResponse/FlowContentSha256
  :cognitect.aws.connect/FlowContentSha256)

(s/def
  :cognitect.aws.connect.DeleteRoutingProfileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteRoutingProfileRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def
  :cognitect.aws.connect.SingleSelectQuestionRuleCategoryAutomation/Category
  :cognitect.aws.connect/SingleSelectQuestionRuleCategoryAutomationLabel)

(s/def
  :cognitect.aws.connect.SingleSelectQuestionRuleCategoryAutomation/Condition
  :cognitect.aws.connect/SingleSelectQuestionRuleCategoryAutomationCondition)

(s/def
  :cognitect.aws.connect.SingleSelectQuestionRuleCategoryAutomation/OptionRefId
  :cognitect.aws.connect/ReferenceId)

(s/def :cognitect.aws.connect.RoutingProfile/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.RoutingProfile/AssociatedQueueIds
  :cognitect.aws.connect/AssociatedQueueIdList)

(s/def :cognitect.aws.connect.RoutingProfile/RoutingProfileArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.RoutingProfile/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.RoutingProfile/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.RoutingProfile/IsDefault :cognitect.aws.connect/Boolean)

(s/def :cognitect.aws.connect.RoutingProfile/DefaultOutboundQueueId :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.RoutingProfile/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def
  :cognitect.aws.connect.RoutingProfile/MediaConcurrencies
  :cognitect.aws.connect/MediaConcurrencies)

(s/def :cognitect.aws.connect.RoutingProfile/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.RoutingProfile/AgentAvailabilityTimer
  :cognitect.aws.connect/AgentAvailabilityTimer)

(s/def :cognitect.aws.connect.RoutingProfile/Name :cognitect.aws.connect/RoutingProfileName)

(s/def
  :cognitect.aws.connect.RoutingProfile/Description
  :cognitect.aws.connect/RoutingProfileDescription)

(s/def :cognitect.aws.connect.RoutingProfile/NumberOfAssociatedQueues :cognitect.aws.connect/Long)

(s/def :cognitect.aws.connect.RoutingProfile/NumberOfAssociatedUsers :cognitect.aws.connect/Long)

(s/def :cognitect.aws.connect.BatchPutContactRequest/ClientToken :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.BatchPutContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.BatchPutContactRequest/ContactDataRequestList
  :cognitect.aws.connect/ContactDataRequestList)

(s/def
  :cognitect.aws.connect.GetEffectiveHoursOfOperationsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.GetEffectiveHoursOfOperationsRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def
  :cognitect.aws.connect.GetEffectiveHoursOfOperationsRequest/FromDate
  :cognitect.aws.connect/HoursOfOperationOverrideYearMonthDayDateFormat)

(s/def
  :cognitect.aws.connect.GetEffectiveHoursOfOperationsRequest/ToDate
  :cognitect.aws.connect/HoursOfOperationOverrideYearMonthDayDateFormat)

(s/def
  :cognitect.aws.connect.DescribeInstanceAttributeResponse/Attribute
  :cognitect.aws.connect/Attribute)

(s/def :cognitect.aws.connect.UntagContactRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.UntagContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.UntagContactRequest/TagKeys :cognitect.aws.connect/ContactTagKeys)

(s/def
  :cognitect.aws.connect.AuthenticationProfileSummary/Id
  :cognitect.aws.connect/AuthenticationProfileId)

(s/def :cognitect.aws.connect.AuthenticationProfileSummary/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.AuthenticationProfileSummary/Name
  :cognitect.aws.connect/AuthenticationProfileName)

(s/def :cognitect.aws.connect.AuthenticationProfileSummary/IsDefault :cognitect.aws.connect/Boolean)

(s/def
  :cognitect.aws.connect.AuthenticationProfileSummary/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.AuthenticationProfileSummary/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.ListContactReferencesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListContactReferencesRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ListContactReferencesRequest/ReferenceTypes
  :cognitect.aws.connect/ReferenceTypes)

(s/def
  :cognitect.aws.connect.ListContactReferencesRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.CreateTrafficDistributionGroupResponse/Id
  :cognitect.aws.connect/TrafficDistributionGroupId)

(s/def
  :cognitect.aws.connect.CreateTrafficDistributionGroupResponse/Arn
  :cognitect.aws.connect/TrafficDistributionGroupArn)

(s/def
  :cognitect.aws.connect.RoutingCriteriaInputStepExpiry/DurationInSeconds
  :cognitect.aws.connect/DurationInSeconds)

(s/def
  :cognitect.aws.connect.DisassociatePhoneNumberContactFlowRequest/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def
  :cognitect.aws.connect.DisassociatePhoneNumberContactFlowRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ContactFlowSummary/Id :cognitect.aws.connect/ContactFlowId)

(s/def :cognitect.aws.connect.ContactFlowSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.ContactFlowSummary/Name :cognitect.aws.connect/ContactFlowName)

(s/def
  :cognitect.aws.connect.ContactFlowSummary/ContactFlowType
  :cognitect.aws.connect/ContactFlowType)

(s/def
  :cognitect.aws.connect.ContactFlowSummary/ContactFlowState
  :cognitect.aws.connect/ContactFlowState)

(s/def
  :cognitect.aws.connect.ContactFlowSummary/ContactFlowStatus
  :cognitect.aws.connect/ContactFlowStatus)

(s/def
  :cognitect.aws.connect.UpdateViewMetadataRequest/InstanceId
  :cognitect.aws.connect/ViewsInstanceId)

(s/def :cognitect.aws.connect.UpdateViewMetadataRequest/ViewId :cognitect.aws.connect/ViewId)

(s/def :cognitect.aws.connect.UpdateViewMetadataRequest/Name :cognitect.aws.connect/ViewName)

(s/def
  :cognitect.aws.connect.UpdateViewMetadataRequest/Description
  :cognitect.aws.connect/ViewDescription)

(s/def
  :cognitect.aws.connect.EvaluationFormVersionSummary/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.EvaluationFormVersionSummary/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.EvaluationFormVersionSummary/EvaluationFormArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.EvaluationFormVersionSummary/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.EvaluationFormVersionSummary/Locked
  :cognitect.aws.connect/EvaluationFormVersionIsLocked)

(s/def :cognitect.aws.connect.EvaluationFormVersionSummary/CreatedBy :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.EvaluationFormVersionSummary/LastModifiedBy
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.EvaluationFormVersionSummary/CreatedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.EvaluationFormVersionSummary/Status
  :cognitect.aws.connect/EvaluationFormVersionStatus)

(s/def
  :cognitect.aws.connect.ParticipantTokenCredentials/ParticipantToken
  :cognitect.aws.connect/ParticipantToken)

(s/def
  :cognitect.aws.connect.ParticipantTokenCredentials/Expiry
  :cognitect.aws.connect/ISO8601Datetime)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationsRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationsRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationsRequest/SearchFilter
  :cognitect.aws.connect/HoursOfOperationSearchFilter)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationsRequest/SearchCriteria
  :cognitect.aws.connect/HoursOfOperationSearchCriteria)

(s/def
  :cognitect.aws.connect.ContactFlowModuleSearchFilter/TagFilter
  :cognitect.aws.connect/ControlPlaneTagFilter)

(s/def :cognitect.aws.connect.EmailReference/Name :cognitect.aws.connect/ReferenceKey)

(s/def :cognitect.aws.connect.EmailReference/Value :cognitect.aws.connect/ReferenceValue)

(s/def
  :cognitect.aws.connect.ListInstanceStorageConfigsResponse/StorageConfigs
  :cognitect.aws.connect/InstanceStorageConfigs)

(s/def
  :cognitect.aws.connect.ListInstanceStorageConfigsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataAssociationsResponse/Results
  :cognitect.aws.connect/AnalyticsDataAssociationResults)

(s/def
  :cognitect.aws.connect.ListAnalyticsDataAssociationsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.Application/Namespace :cognitect.aws.connect/Namespace)

(s/def
  :cognitect.aws.connect.Application/ApplicationPermissions
  :cognitect.aws.connect/ApplicationPermissions)

(s/def
  :cognitect.aws.connect.DescribePredefinedAttributeRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribePredefinedAttributeRequest/Name
  :cognitect.aws.connect/PredefinedAttributeName)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileConcurrencyRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileConcurrencyRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def
  :cognitect.aws.connect.UpdateRoutingProfileConcurrencyRequest/MediaConcurrencies
  :cognitect.aws.connect/MediaConcurrencies)

(s/def :cognitect.aws.connect.SearchPromptsResponse/Prompts :cognitect.aws.connect/PromptList)

(s/def :cognitect.aws.connect.SearchPromptsResponse/NextToken :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchPromptsResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def
  :cognitect.aws.connect.ListContactFlowVersionsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListContactFlowVersionsRequest/ContactFlowId
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ListContactFlowVersionsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListContactFlowVersionsRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def :cognitect.aws.connect.ListQueuesRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListQueuesRequest/QueueTypes :cognitect.aws.connect/QueueTypes)

(s/def :cognitect.aws.connect.ListQueuesRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ListQueuesRequest/MaxResults :cognitect.aws.connect/MaxResult1000)

(s/def :cognitect.aws.connect.AssociateLexBotRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.AssociateLexBotRequest/LexBot :cognitect.aws.connect/LexBot)

(s/def :cognitect.aws.connect.AssociateLexBotRequest/ClientToken :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/HoursOfOperationOverrideId
  :cognitect.aws.connect/HoursOfOperationOverrideId)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/Name
  :cognitect.aws.connect/CommonHumanReadableName)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/Description
  :cognitect.aws.connect/CommonHumanReadableDescription)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/Config
  :cognitect.aws.connect/HoursOfOperationOverrideConfigList)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/EffectiveFrom
  :cognitect.aws.connect/HoursOfOperationOverrideYearMonthDayDateFormat)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationOverrideRequest/EffectiveTill
  :cognitect.aws.connect/HoursOfOperationOverrideYearMonthDayDateFormat)

(s/def :cognitect.aws.connect.UntagResourceRequest/resourceArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.UntagResourceRequest/tagKeys :cognitect.aws.connect/TagKeyList)

(s/def
  :cognitect.aws.connect.DescribePredefinedAttributeResponse/PredefinedAttribute
  :cognitect.aws.connect/PredefinedAttribute)

(s/def :cognitect.aws.connect.PropertyValidationException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.PropertyValidationException/PropertyList
  :cognitect.aws.connect/PropertyValidationExceptionPropertyList)

(s/def
  :cognitect.aws.connect.GetFederationTokenRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListAgentStatusRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListAgentStatusRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListAgentStatusRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.ListAgentStatusRequest/AgentStatusTypes
  :cognitect.aws.connect/AgentStatusTypes)

(s/def
  :cognitect.aws.connect.UpdateQuickConnectNameRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateQuickConnectNameRequest/QuickConnectId
  :cognitect.aws.connect/QuickConnectId)

(s/def
  :cognitect.aws.connect.UpdateQuickConnectNameRequest/Name
  :cognitect.aws.connect/QuickConnectName)

(s/def
  :cognitect.aws.connect.UpdateQuickConnectNameRequest/Description
  :cognitect.aws.connect/UpdateQuickConnectDescription)

(s/def
  :cognitect.aws.connect.ListInstanceAttributesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListInstanceAttributesRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListInstanceAttributesRequest/MaxResults
  :cognitect.aws.connect/MaxResult7)

(s/def
  :cognitect.aws.connect.CreatePushNotificationRegistrationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreatePushNotificationRegistrationRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.CreatePushNotificationRegistrationRequest/PinpointAppArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreatePushNotificationRegistrationRequest/DeviceToken
  :cognitect.aws.connect/DeviceToken)

(s/def
  :cognitect.aws.connect.CreatePushNotificationRegistrationRequest/DeviceType
  :cognitect.aws.connect/DeviceType)

(s/def
  :cognitect.aws.connect.CreatePushNotificationRegistrationRequest/ContactConfiguration
  :cognitect.aws.connect/ContactConfiguration)

(s/def :cognitect.aws.connect.NotificationRecipientType/UserTags :cognitect.aws.connect/UserTagMap)

(s/def :cognitect.aws.connect.NotificationRecipientType/UserIds :cognitect.aws.connect/UserIdList)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisIssueDetected/TranscriptItems
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptItemsWithContent)

(s/def :cognitect.aws.connect.UserNotFoundException/Message :cognitect.aws.connect/Message)

(s/def :cognitect.aws.connect.InstanceStatusReason/Message :cognitect.aws.connect/String)

(s/def
  :cognitect.aws.connect.GetContactAttributesResponse/Attributes
  :cognitect.aws.connect/Attributes)

(s/def :cognitect.aws.connect.MetricInterval/Interval :cognitect.aws.connect/IntervalPeriod)

(s/def :cognitect.aws.connect.MetricInterval/StartTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.MetricInterval/EndTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.DescribeTrafficDistributionGroupResponse/TrafficDistributionGroup
  :cognitect.aws.connect/TrafficDistributionGroup)

(s/def :cognitect.aws.connect.ThresholdV2/Comparison :cognitect.aws.connect/ResourceArnOrId)

(s/def :cognitect.aws.connect.ThresholdV2/ThresholdValue :cognitect.aws.connect/ThresholdValue)

(s/def :cognitect.aws.connect.TagCondition/TagKey :cognitect.aws.connect/String)

(s/def :cognitect.aws.connect.TagCondition/TagValue :cognitect.aws.connect/String)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadRequest/UrlExpiryInSeconds
  :cognitect.aws.connect/URLExpiryInSeconds)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadRequest/FileSizeInBytes
  :cognitect.aws.connect/FileSizeInBytes)

(s/def :cognitect.aws.connect.StartAttachedFileUploadRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadRequest/CreatedBy
  :cognitect.aws.connect/CreatedByInfo)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadRequest/AssociatedResourceArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadRequest/FileUseCaseType
  :cognitect.aws.connect/FileUseCaseType)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadRequest/FileName
  :cognitect.aws.connect/FileName)

(s/def :cognitect.aws.connect.DescribeViewResponse/View :cognitect.aws.connect/View)

(s/def
  :cognitect.aws.connect.ContactSearchSummaryAgentInfo/Id
  :cognitect.aws.connect/AgentResourceId)

(s/def
  :cognitect.aws.connect.ContactSearchSummaryAgentInfo/ConnectedToAgentTimestamp
  :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.LexV2Bot/AliasArn :cognitect.aws.connect/AliasArn)

(s/def
  :cognitect.aws.connect.StartWebRTCContactResponse/ConnectionData
  :cognitect.aws.connect/ConnectionData)

(s/def :cognitect.aws.connect.StartWebRTCContactResponse/ContactId :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartWebRTCContactResponse/ParticipantId
  :cognitect.aws.connect/ParticipantId)

(s/def
  :cognitect.aws.connect.StartWebRTCContactResponse/ParticipantToken
  :cognitect.aws.connect/ParticipantToken)

(s/def
  :cognitect.aws.connect.EvaluationAnswerInput/Value
  :cognitect.aws.connect/EvaluationAnswerData)

(s/def
  :cognitect.aws.connect.ControlPlaneTagFilter/OrConditions
  :cognitect.aws.connect/TagOrConditionList)

(s/def
  :cognitect.aws.connect.ControlPlaneTagFilter/AndConditions
  :cognitect.aws.connect/TagAndConditionList)

(s/def
  :cognitect.aws.connect.ControlPlaneTagFilter/TagCondition
  :cognitect.aws.connect/TagCondition)

(s/def :cognitect.aws.connect.CreateAgentStatusResponse/AgentStatusARN :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateAgentStatusResponse/AgentStatusId
  :cognitect.aws.connect/AgentStatusId)

(s/def
  :cognitect.aws.connect.UpdateInstanceAttributeRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateInstanceAttributeRequest/AttributeType
  :cognitect.aws.connect/InstanceAttributeType)

(s/def
  :cognitect.aws.connect.UpdateInstanceAttributeRequest/Value
  :cognitect.aws.connect/InstanceAttributeValue)

(s/def
  :cognitect.aws.connect.UpdateInstanceAttributeRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.ListViewsResponse/ViewsSummaryList
  :cognitect.aws.connect/ViewsSummaryList)

(s/def :cognitect.aws.connect.ListViewsResponse/NextToken :cognitect.aws.connect/ViewsNextToken)

(s/def
  :cognitect.aws.connect.ListContactEvaluationsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListContactEvaluationsRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ListContactEvaluationsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.SearchUsersResponse/Users
  :cognitect.aws.connect/UserSearchSummaryList)

(s/def :cognitect.aws.connect.SearchUsersResponse/NextToken :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchUsersResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.KinesisFirehoseConfig/FirehoseArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.AssociateFlowRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.AssociateFlowRequest/ResourceId :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.AssociateFlowRequest/FlowId :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.AssociateFlowRequest/ResourceType
  :cognitect.aws.connect/FlowAssociationResourceType)

(s/def :cognitect.aws.connect.IntervalDetails/TimeZone :cognitect.aws.connect/String)

(s/def :cognitect.aws.connect.IntervalDetails/IntervalPeriod :cognitect.aws.connect/IntervalPeriod)

(s/def
  :cognitect.aws.connect.DisassociateApprovedOriginRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DisassociateApprovedOriginRequest/Origin
  :cognitect.aws.connect/Origin)

(s/def
  :cognitect.aws.connect.DisassociateApprovedOriginRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.DisassociateFlowRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DisassociateFlowRequest/ResourceId :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.DisassociateFlowRequest/ResourceType
  :cognitect.aws.connect/FlowAssociationResourceType)

(s/def
  :cognitect.aws.connect.RequiredFieldInfo/Id
  :cognitect.aws.connect/TaskTemplateFieldIdentifier)

(s/def :cognitect.aws.connect.CreateContactFlowRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.CreateContactFlowRequest/Name :cognitect.aws.connect/ContactFlowName)

(s/def :cognitect.aws.connect.CreateContactFlowRequest/Type :cognitect.aws.connect/ContactFlowType)

(s/def
  :cognitect.aws.connect.CreateContactFlowRequest/Description
  :cognitect.aws.connect/ContactFlowDescription)

(s/def
  :cognitect.aws.connect.CreateContactFlowRequest/Content
  :cognitect.aws.connect/ContactFlowContent)

(s/def
  :cognitect.aws.connect.CreateContactFlowRequest/Status
  :cognitect.aws.connect/ContactFlowStatus)

(s/def :cognitect.aws.connect.CreateContactFlowRequest/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.Transcript/Criteria :cognitect.aws.connect/TranscriptCriteriaList)

(s/def :cognitect.aws.connect.Transcript/MatchType :cognitect.aws.connect/SearchContactsMatchType)

(s/def
  :cognitect.aws.connect.ListApprovedOriginsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListApprovedOriginsRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListApprovedOriginsRequest/MaxResults
  :cognitect.aws.connect/MaxResult25)

(s/def :cognitect.aws.connect.ListLexBotsRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListLexBotsRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ListLexBotsRequest/MaxResults :cognitect.aws.connect/MaxResult25)

(s/def :cognitect.aws.connect.QualityMetrics/Agent :cognitect.aws.connect/AgentQualityMetrics)

(s/def :cognitect.aws.connect.QualityMetrics/Customer :cognitect.aws.connect/CustomerQualityMetrics)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemWithContent/Content
  :cognitect.aws.connect/RealTimeContactAnalysisTranscriptContent)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemWithContent/Id
  :cognitect.aws.connect/RealTimeContactAnalysisId256)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisTranscriptItemWithContent/CharacterOffsets
  :cognitect.aws.connect/RealTimeContactAnalysisCharacterInterval)

(s/def
  :cognitect.aws.connect.DescribeInstanceStorageConfigResponse/StorageConfig
  :cognitect.aws.connect/InstanceStorageConfig)

(s/def
  :cognitect.aws.connect.BatchDisassociateAnalyticsDataSetResponse/Deleted
  :cognitect.aws.connect/DataSetIds)

(s/def
  :cognitect.aws.connect.BatchDisassociateAnalyticsDataSetResponse/Errors
  :cognitect.aws.connect/ErrorResults)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumberArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumberType
  :cognitect.aws.connect/PhoneNumberType)

(s/def :cognitect.aws.connect.ListPhoneNumbersSummary/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersSummary/SourcePhoneNumberArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumberCountryCode
  :cognitect.aws.connect/PhoneNumberCountryCode)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumber
  :cognitect.aws.connect/PhoneNumber)

(s/def
  :cognitect.aws.connect.ListPhoneNumbersSummary/PhoneNumberDescription
  :cognitect.aws.connect/PhoneNumberDescription)

(s/def :cognitect.aws.connect.ListPhoneNumbersSummary/TargetArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisTimeData/AbsoluteTime
  :cognitect.aws.connect/RealTimeContactAnalysisTimeInstant)

(s/def :cognitect.aws.connect.ContactMetricResult/Name :cognitect.aws.connect/ContactMetricName)

(s/def :cognitect.aws.connect.ContactMetricResult/Value :cognitect.aws.connect/ContactMetricValue)

(s/def
  :cognitect.aws.connect.ListFlowAssociationsResponse/FlowAssociationSummaryList
  :cognitect.aws.connect/FlowAssociationSummaryList)

(s/def
  :cognitect.aws.connect.ListFlowAssociationsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.UpdatePredefinedAttributeRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdatePredefinedAttributeRequest/Name
  :cognitect.aws.connect/PredefinedAttributeName)

(s/def
  :cognitect.aws.connect.UpdatePredefinedAttributeRequest/Values
  :cognitect.aws.connect/PredefinedAttributeValues)

(s/def
  :cognitect.aws.connect.CompleteAttachedFileUploadRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CompleteAttachedFileUploadRequest/FileId
  :cognitect.aws.connect/FileId)

(s/def
  :cognitect.aws.connect.CompleteAttachedFileUploadRequest/AssociatedResourceArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.RecordingInfo/FragmentStopNumber
  :cognitect.aws.connect/FragmentNumber)

(s/def :cognitect.aws.connect.RecordingInfo/StopTimestamp :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.RecordingInfo/FragmentStartNumber
  :cognitect.aws.connect/FragmentNumber)

(s/def :cognitect.aws.connect.RecordingInfo/ParticipantType :cognitect.aws.connect/ParticipantType)

(s/def :cognitect.aws.connect.RecordingInfo/StartTimestamp :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.RecordingInfo/DeletionReason
  :cognitect.aws.connect/RecordingDeletionReason)

(s/def :cognitect.aws.connect.RecordingInfo/Location :cognitect.aws.connect/RecordingLocation)

(s/def :cognitect.aws.connect.RecordingInfo/MediaStreamType :cognitect.aws.connect/MediaStreamType)

(s/def :cognitect.aws.connect.RecordingInfo/StorageType :cognitect.aws.connect/StorageType)

(s/def :cognitect.aws.connect.RecordingInfo/Status :cognitect.aws.connect/RecordingStatus)

(s/def :cognitect.aws.connect.ContactEvaluation/FormId :cognitect.aws.connect/FormId)

(s/def :cognitect.aws.connect.ContactEvaluation/EvaluationArn :cognitect.aws.connect/EvaluationArn)

(s/def :cognitect.aws.connect.ContactEvaluation/Status :cognitect.aws.connect/Status)

(s/def :cognitect.aws.connect.ContactEvaluation/StartTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.ContactEvaluation/EndTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.ContactEvaluation/DeleteTimestamp :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.ContactEvaluation/ExportLocation
  :cognitect.aws.connect/ExportLocation)

(s/def :cognitect.aws.connect.DescribePromptRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DescribePromptRequest/PromptId :cognitect.aws.connect/PromptId)

(s/def :cognitect.aws.connect.ListUseCasesRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListUseCasesRequest/IntegrationAssociationId
  :cognitect.aws.connect/IntegrationAssociationId)

(s/def :cognitect.aws.connect.ListUseCasesRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ListUseCasesRequest/MaxResults :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchAgentStatusesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchAgentStatusesRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchAgentStatusesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchAgentStatusesRequest/SearchFilter
  :cognitect.aws.connect/AgentStatusSearchFilter)

(s/def
  :cognitect.aws.connect.SearchAgentStatusesRequest/SearchCriteria
  :cognitect.aws.connect/AgentStatusSearchCriteria)

(s/def
  :cognitect.aws.connect.BatchDisassociateAnalyticsDataSetRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.BatchDisassociateAnalyticsDataSetRequest/DataSetIds
  :cognitect.aws.connect/DataSetIds)

(s/def
  :cognitect.aws.connect.BatchDisassociateAnalyticsDataSetRequest/TargetAccountId
  :cognitect.aws.connect/AWSAccountId)

(s/def :cognitect.aws.connect.TelephonyConfig/Distributions :cognitect.aws.connect/DistributionList)

(s/def
  :cognitect.aws.connect.PredefinedAttributeSummary/Name
  :cognitect.aws.connect/PredefinedAttributeName)

(s/def
  :cognitect.aws.connect.PredefinedAttributeSummary/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.PredefinedAttributeSummary/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.MeetingFeaturesConfiguration/Audio
  :cognitect.aws.connect/AudioFeatures)

(s/def
  :cognitect.aws.connect.AttributeCondition/Name
  :cognitect.aws.connect/PredefinedAttributeName)

(s/def :cognitect.aws.connect.AttributeCondition/Value :cognitect.aws.connect/ProficiencyValue)

(s/def
  :cognitect.aws.connect.AttributeCondition/ProficiencyLevel
  :cognitect.aws.connect/NullableProficiencyLevel)

(s/def :cognitect.aws.connect.AttributeCondition/Range :cognitect.aws.connect/Range)

(s/def :cognitect.aws.connect.AttributeCondition/MatchCriteria :cognitect.aws.connect/MatchCriteria)

(s/def
  :cognitect.aws.connect.AttributeCondition/ComparisonOperator
  :cognitect.aws.connect/ComparisonOperator)

(s/def
  :cognitect.aws.connect.EmailAddressMetadata/EmailAddressId
  :cognitect.aws.connect/EmailAddressId)

(s/def
  :cognitect.aws.connect.EmailAddressMetadata/EmailAddressArn
  :cognitect.aws.connect/EmailAddressArn)

(s/def :cognitect.aws.connect.EmailAddressMetadata/EmailAddress :cognitect.aws.connect/EmailAddress)

(s/def :cognitect.aws.connect.EmailAddressMetadata/Description :cognitect.aws.connect/Description)

(s/def
  :cognitect.aws.connect.EmailAddressMetadata/DisplayName
  :cognitect.aws.connect/EmailAddressDisplayName)

(s/def
  :cognitect.aws.connect.ListUsersResponse/UserSummaryList
  :cognitect.aws.connect/UserSummaryList)

(s/def :cognitect.aws.connect.ListUsersResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.SendNotificationActionDefinition/DeliveryMethod
  :cognitect.aws.connect/NotificationDeliveryType)

(s/def
  :cognitect.aws.connect.SendNotificationActionDefinition/Subject
  :cognitect.aws.connect/Subject)

(s/def
  :cognitect.aws.connect.SendNotificationActionDefinition/Content
  :cognitect.aws.connect/Content)

(s/def
  :cognitect.aws.connect.SendNotificationActionDefinition/ContentType
  :cognitect.aws.connect/NotificationContentType)

(s/def
  :cognitect.aws.connect.SendNotificationActionDefinition/Recipient
  :cognitect.aws.connect/NotificationRecipientType)

(s/def :cognitect.aws.connect.MetricV2/Name :cognitect.aws.connect/MetricNameV2)

(s/def :cognitect.aws.connect.MetricV2/Threshold :cognitect.aws.connect/ThresholdCollections)

(s/def :cognitect.aws.connect.MetricV2/MetricFilters :cognitect.aws.connect/MetricFiltersV2List)

(s/def :cognitect.aws.connect.UpdateRuleRequest/RuleId :cognitect.aws.connect/RuleId)

(s/def :cognitect.aws.connect.UpdateRuleRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.UpdateRuleRequest/Name :cognitect.aws.connect/RuleName)

(s/def :cognitect.aws.connect.UpdateRuleRequest/Function :cognitect.aws.connect/RuleFunction)

(s/def :cognitect.aws.connect.UpdateRuleRequest/Actions :cognitect.aws.connect/RuleActions)

(s/def
  :cognitect.aws.connect.UpdateRuleRequest/PublishStatus
  :cognitect.aws.connect/RulePublishStatus)

(s/def :cognitect.aws.connect.MediaConcurrency/Channel :cognitect.aws.connect/Channel)

(s/def :cognitect.aws.connect.MediaConcurrency/Concurrency :cognitect.aws.connect/Concurrency)

(s/def
  :cognitect.aws.connect.MediaConcurrency/CrossChannelBehavior
  :cognitect.aws.connect/CrossChannelBehavior)

(s/def
  :cognitect.aws.connect.NumericQuestionPropertyValueAutomation/Label
  :cognitect.aws.connect/NumericQuestionPropertyAutomationLabel)

(s/def :cognitect.aws.connect.PhoneNumberSummary/Id :cognitect.aws.connect/PhoneNumberId)

(s/def :cognitect.aws.connect.PhoneNumberSummary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.PhoneNumberSummary/PhoneNumber :cognitect.aws.connect/PhoneNumber)

(s/def
  :cognitect.aws.connect.PhoneNumberSummary/PhoneNumberType
  :cognitect.aws.connect/PhoneNumberType)

(s/def
  :cognitect.aws.connect.PhoneNumberSummary/PhoneNumberCountryCode
  :cognitect.aws.connect/PhoneNumberCountryCode)

(s/def
  :cognitect.aws.connect.AssociateAnalyticsDataSetResponse/DataSetId
  :cognitect.aws.connect/DataSetId)

(s/def
  :cognitect.aws.connect.AssociateAnalyticsDataSetResponse/TargetAccountId
  :cognitect.aws.connect/AWSAccountId)

(s/def
  :cognitect.aws.connect.AssociateAnalyticsDataSetResponse/ResourceShareId
  :cognitect.aws.connect/String)

(s/def
  :cognitect.aws.connect.AssociateAnalyticsDataSetResponse/ResourceShareArn
  :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.SearchContactsResponse/Contacts :cognitect.aws.connect/Contacts)

(s/def
  :cognitect.aws.connect.SearchContactsResponse/NextToken
  :cognitect.aws.connect/LargeNextToken)

(s/def :cognitect.aws.connect.SearchContactsResponse/TotalCount :cognitect.aws.connect/TotalCount)

(s/def
  :cognitect.aws.connect.ParticipantTimerConfiguration/ParticipantRole
  :cognitect.aws.connect/TimerEligibleParticipantRoles)

(s/def
  :cognitect.aws.connect.ParticipantTimerConfiguration/TimerType
  :cognitect.aws.connect/ParticipantTimerType)

(s/def
  :cognitect.aws.connect.ParticipantTimerConfiguration/TimerValue
  :cognitect.aws.connect/ParticipantTimerValue)

(s/def
  :cognitect.aws.connect.DescribeUserHierarchyStructureRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.Condition/StringCondition :cognitect.aws.connect/StringCondition)

(s/def :cognitect.aws.connect.Condition/NumberCondition :cognitect.aws.connect/NumberCondition)

(s/def
  :cognitect.aws.connect.ListContactReferencesResponse/ReferenceSummaryList
  :cognitect.aws.connect/ReferenceSummaryList)

(s/def
  :cognitect.aws.connect.ListContactReferencesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ListUsersRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListUsersRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ListUsersRequest/MaxResults :cognitect.aws.connect/MaxResult1000)

(s/def :cognitect.aws.connect.CreateVocabularyResponse/VocabularyArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateVocabularyResponse/VocabularyId
  :cognitect.aws.connect/VocabularyId)

(s/def :cognitect.aws.connect.CreateVocabularyResponse/State :cognitect.aws.connect/VocabularyState)

(s/def
  :cognitect.aws.connect.DescribeTrafficDistributionGroupRequest/TrafficDistributionGroupId
  :cognitect.aws.connect/TrafficDistributionGroupIdOrArn)

(s/def
  :cognitect.aws.connect.CreateViewVersionRequest/InstanceId
  :cognitect.aws.connect/ViewsInstanceId)

(s/def :cognitect.aws.connect.CreateViewVersionRequest/ViewId :cognitect.aws.connect/ViewId)

(s/def
  :cognitect.aws.connect.CreateViewVersionRequest/VersionDescription
  :cognitect.aws.connect/ViewDescription)

(s/def
  :cognitect.aws.connect.CreateViewVersionRequest/ViewContentSha256
  :cognitect.aws.connect/ViewContentSha256)

(s/def :cognitect.aws.connect.Filters/Queues :cognitect.aws.connect/Queues)

(s/def :cognitect.aws.connect.Filters/Channels :cognitect.aws.connect/Channels)

(s/def :cognitect.aws.connect.Filters/RoutingProfiles :cognitect.aws.connect/RoutingProfiles)

(s/def
  :cognitect.aws.connect.Filters/RoutingStepExpressions
  :cognitect.aws.connect/RoutingExpressions)

(s/def :cognitect.aws.connect.ContactSearchSummaryQueueInfo/Id :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.ContactSearchSummaryQueueInfo/EnqueueTimestamp
  :cognitect.aws.connect/timestamp)

(s/def
  :cognitect.aws.connect.EvaluationFormContent/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.EvaluationFormContent/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def :cognitect.aws.connect.EvaluationFormContent/EvaluationFormArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.EvaluationFormContent/Title
  :cognitect.aws.connect/EvaluationFormTitle)

(s/def
  :cognitect.aws.connect.EvaluationFormContent/Description
  :cognitect.aws.connect/EvaluationFormDescription)

(s/def
  :cognitect.aws.connect.EvaluationFormContent/Items
  :cognitect.aws.connect/EvaluationFormItemsList)

(s/def
  :cognitect.aws.connect.EvaluationFormContent/ScoringStrategy
  :cognitect.aws.connect/EvaluationFormScoringStrategy)

(s/def :cognitect.aws.connect.Evaluation/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.Evaluation/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.Evaluation/Answers :cognitect.aws.connect/EvaluationAnswersOutputMap)

(s/def :cognitect.aws.connect.Evaluation/Metadata :cognitect.aws.connect/EvaluationMetadata)

(s/def :cognitect.aws.connect.Evaluation/EvaluationArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Evaluation/Notes :cognitect.aws.connect/EvaluationNotesMap)

(s/def :cognitect.aws.connect.Evaluation/Scores :cognitect.aws.connect/EvaluationScoresMap)

(s/def :cognitect.aws.connect.Evaluation/CreatedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.Evaluation/EvaluationId :cognitect.aws.connect/ResourceId)

(s/def :cognitect.aws.connect.Evaluation/Status :cognitect.aws.connect/EvaluationStatus)

(s/def
  :cognitect.aws.connect.SearchSecurityProfilesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchSecurityProfilesRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchSecurityProfilesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchSecurityProfilesRequest/SearchCriteria
  :cognitect.aws.connect/SecurityProfileSearchCriteria)

(s/def
  :cognitect.aws.connect.SearchSecurityProfilesRequest/SearchFilter
  :cognitect.aws.connect/SecurityProfilesSearchFilter)

(s/def
  :cognitect.aws.connect.SegmentAttributeValue/ValueString
  :cognitect.aws.connect/SegmentAttributeValueString)

(s/def
  :cognitect.aws.connect.SegmentAttributeValue/ValueMap
  :cognitect.aws.connect/SegmentAttributeValueMap)

(s/def
  :cognitect.aws.connect.SegmentAttributeValue/ValueInteger
  :cognitect.aws.connect/SegmentAttributeValueInteger)

(s/def
  :cognitect.aws.connect.ListContactFlowModulesResponse/ContactFlowModulesSummaryList
  :cognitect.aws.connect/ContactFlowModulesSummaryList)

(s/def
  :cognitect.aws.connect.ListContactFlowModulesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.CreateTaskTemplateRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateTaskTemplateRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.CreateTaskTemplateRequest/Constraints
  :cognitect.aws.connect/TaskTemplateConstraints)

(s/def
  :cognitect.aws.connect.CreateTaskTemplateRequest/Defaults
  :cognitect.aws.connect/TaskTemplateDefaults)

(s/def
  :cognitect.aws.connect.CreateTaskTemplateRequest/Name
  :cognitect.aws.connect/TaskTemplateName)

(s/def
  :cognitect.aws.connect.CreateTaskTemplateRequest/Description
  :cognitect.aws.connect/TaskTemplateDescription)

(s/def
  :cognitect.aws.connect.CreateTaskTemplateRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.CreateTaskTemplateRequest/SelfAssignFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.CreateTaskTemplateRequest/Fields
  :cognitect.aws.connect/TaskTemplateFields)

(s/def
  :cognitect.aws.connect.CreateTaskTemplateRequest/Status
  :cognitect.aws.connect/TaskTemplateStatus)

(s/def :cognitect.aws.connect.QuickConnect/QuickConnectARN :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.QuickConnect/QuickConnectId :cognitect.aws.connect/QuickConnectId)

(s/def :cognitect.aws.connect.QuickConnect/Name :cognitect.aws.connect/QuickConnectName)

(s/def
  :cognitect.aws.connect.QuickConnect/Description
  :cognitect.aws.connect/QuickConnectDescription)

(s/def
  :cognitect.aws.connect.QuickConnect/QuickConnectConfig
  :cognitect.aws.connect/QuickConnectConfig)

(s/def :cognitect.aws.connect.QuickConnect/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.QuickConnect/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.QuickConnect/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.ListSecurityKeysResponse/SecurityKeys
  :cognitect.aws.connect/SecurityKeysList)

(s/def :cognitect.aws.connect.ListSecurityKeysResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.AllowedCapabilities/Customer
  :cognitect.aws.connect/ParticipantCapabilities)

(s/def
  :cognitect.aws.connect.AllowedCapabilities/Agent
  :cognitect.aws.connect/ParticipantCapabilities)

(s/def
  :cognitect.aws.connect.ListContactFlowModulesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListContactFlowModulesRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListContactFlowModulesRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.ListContactFlowModulesRequest/ContactFlowModuleState
  :cognitect.aws.connect/ContactFlowModuleState)

(s/def
  :cognitect.aws.connect.EvaluationFormScoringStrategy/Mode
  :cognitect.aws.connect/EvaluationFormScoringMode)

(s/def
  :cognitect.aws.connect.EvaluationFormScoringStrategy/Status
  :cognitect.aws.connect/EvaluationFormScoringStatus)

(s/def
  :cognitect.aws.connect.ListTrafficDistributionGroupUsersResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListTrafficDistributionGroupUsersResponse/TrafficDistributionGroupUserSummaryList
  :cognitect.aws.connect/TrafficDistributionGroupUserSummaryList)

(s/def
  :cognitect.aws.connect.AdditionalEmailRecipients/ToList
  :cognitect.aws.connect/EmailRecipientsList)

(s/def
  :cognitect.aws.connect.AdditionalEmailRecipients/CcList
  :cognitect.aws.connect/EmailRecipientsList)

(s/def :cognitect.aws.connect.TransferContactResponse/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.TransferContactResponse/ContactArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateContactFlowVersionRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateContactFlowVersionRequest/Description
  :cognitect.aws.connect/ContactFlowDescription)

(s/def
  :cognitect.aws.connect.CreateContactFlowVersionRequest/ContactFlowId
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.CreateContactFlowVersionRequest/FlowContentSha256
  :cognitect.aws.connect/FlowContentSha256)

(s/def
  :cognitect.aws.connect.CreateContactFlowVersionRequest/ContactFlowVersion
  :cognitect.aws.connect/ResourceVersion)

(s/def
  :cognitect.aws.connect.CreateContactFlowVersionRequest/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.CreateContactFlowVersionRequest/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.StartAttachedFileUploadResponse/FileArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.StartAttachedFileUploadResponse/FileId :cognitect.aws.connect/FileId)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadResponse/CreationTime
  :cognitect.aws.connect/ISO8601Datetime)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadResponse/FileStatus
  :cognitect.aws.connect/FileStatusType)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadResponse/CreatedBy
  :cognitect.aws.connect/CreatedByInfo)

(s/def
  :cognitect.aws.connect.StartAttachedFileUploadResponse/UploadUrlMetadata
  :cognitect.aws.connect/UploadUrlMetadata)

(s/def :cognitect.aws.connect.PauseContactRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.PauseContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.PauseContactRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.EffectiveHoursOfOperations/Date
  :cognitect.aws.connect/HoursOfOperationOverrideYearMonthDayDateFormat)

(s/def
  :cognitect.aws.connect.EffectiveHoursOfOperations/OperationalHours
  :cognitect.aws.connect/OperationalHours)

(s/def
  :cognitect.aws.connect.CreateUserHierarchyGroupResponse/HierarchyGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def
  :cognitect.aws.connect.CreateUserHierarchyGroupResponse/HierarchyGroupArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisAttachment/AttachmentName
  :cognitect.aws.connect/AttachmentName)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisAttachment/ContentType
  :cognitect.aws.connect/ContentType)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisAttachment/AttachmentId
  :cognitect.aws.connect/ArtifactId)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisAttachment/Status
  :cognitect.aws.connect/ArtifactStatus)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationOverrideResponse/HoursOfOperationOverrideId
  :cognitect.aws.connect/HoursOfOperationOverrideId)

(s/def :cognitect.aws.connect.ListAgentStatusResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListAgentStatusResponse/AgentStatusSummaryList
  :cognitect.aws.connect/AgentStatusSummaryList)

(s/def
  :cognitect.aws.connect.AgentQualityMetrics/Audio
  :cognitect.aws.connect/AudioQualityMetricsInfo)

(s/def
  :cognitect.aws.connect.DisassociateRoutingProfileQueuesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DisassociateRoutingProfileQueuesRequest/RoutingProfileId
  :cognitect.aws.connect/RoutingProfileId)

(s/def
  :cognitect.aws.connect.DisassociateRoutingProfileQueuesRequest/QueueReferences
  :cognitect.aws.connect/RoutingProfileQueueReferenceList)

(s/def
  :cognitect.aws.connect.ListIntegrationAssociationsResponse/IntegrationAssociationSummaryList
  :cognitect.aws.connect/IntegrationAssociationSummaryList)

(s/def
  :cognitect.aws.connect.ListIntegrationAssociationsResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ViewInputContent/Template :cognitect.aws.connect/ViewTemplate)

(s/def :cognitect.aws.connect.ViewInputContent/Actions :cognitect.aws.connect/ViewActions)

(s/def
  :cognitect.aws.connect.StartOutboundVoiceContactResponse/ContactId
  :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.Attribute/AttributeType :cognitect.aws.connect/InstanceAttributeType)

(s/def :cognitect.aws.connect.Attribute/Value :cognitect.aws.connect/InstanceAttributeValue)

(s/def :cognitect.aws.connect.CreateRuleResponse/RuleArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.CreateRuleResponse/RuleId :cognitect.aws.connect/RuleId)

(s/def :cognitect.aws.connect.InvalidContactFlowException/problems :cognitect.aws.connect/Problems)

(s/def
  :cognitect.aws.connect.DeletePredefinedAttributeRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeletePredefinedAttributeRequest/Name
  :cognitect.aws.connect/PredefinedAttributeName)

(s/def :cognitect.aws.connect.UpdatePromptResponse/PromptARN :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.UpdatePromptResponse/PromptId :cognitect.aws.connect/PromptId)

(s/def
  :cognitect.aws.connect.EvaluationFormSingleSelectQuestionProperties/Options
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionOptionList)

(s/def
  :cognitect.aws.connect.EvaluationFormSingleSelectQuestionProperties/DisplayAs
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionDisplayMode)

(s/def
  :cognitect.aws.connect.EvaluationFormSingleSelectQuestionProperties/Automation
  :cognitect.aws.connect/EvaluationFormSingleSelectQuestionAutomation)

(s/def
  :cognitect.aws.connect.RoutingProfileQueueConfig/QueueReference
  :cognitect.aws.connect/RoutingProfileQueueReference)

(s/def :cognitect.aws.connect.RoutingProfileQueueConfig/Priority :cognitect.aws.connect/Priority)

(s/def :cognitect.aws.connect.RoutingProfileQueueConfig/Delay :cognitect.aws.connect/Delay)

(s/def
  :cognitect.aws.connect.SecurityProfileSearchSummary/Id
  :cognitect.aws.connect/SecurityProfileId)

(s/def
  :cognitect.aws.connect.SecurityProfileSearchSummary/OrganizationResourceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.SecurityProfileSearchSummary/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.SecurityProfileSearchSummary/SecurityProfileName
  :cognitect.aws.connect/SecurityProfileName)

(s/def
  :cognitect.aws.connect.SecurityProfileSearchSummary/Description
  :cognitect.aws.connect/SecurityProfileDescription)

(s/def :cognitect.aws.connect.SecurityProfileSearchSummary/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.ReplicationStatusSummary/Region :cognitect.aws.connect/AwsRegion)

(s/def
  :cognitect.aws.connect.ReplicationStatusSummary/ReplicationStatus
  :cognitect.aws.connect/InstanceReplicationStatus)

(s/def
  :cognitect.aws.connect.ReplicationStatusSummary/ReplicationStatusReason
  :cognitect.aws.connect/ReplicationStatusReason)

(s/def
  :cognitect.aws.connect.UpdateParticipantAuthenticationRequest/State
  :cognitect.aws.connect/ParticipantToken)

(s/def
  :cognitect.aws.connect.UpdateParticipantAuthenticationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateParticipantAuthenticationRequest/Code
  :cognitect.aws.connect/AuthorizationCode)

(s/def
  :cognitect.aws.connect.UpdateParticipantAuthenticationRequest/Error
  :cognitect.aws.connect/AuthenticationError)

(s/def
  :cognitect.aws.connect.UpdateParticipantAuthenticationRequest/ErrorDescription
  :cognitect.aws.connect/AuthenticationErrorDescription)

(s/def
  :cognitect.aws.connect.SuspendContactRecordingRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SuspendContactRecordingRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.SuspendContactRecordingRequest/InitialContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.SuspendContactRecordingRequest/ContactRecordingType
  :cognitect.aws.connect/ContactRecordingType)

(s/def :cognitect.aws.connect.NumberReference/Name :cognitect.aws.connect/ReferenceKey)

(s/def :cognitect.aws.connect.NumberReference/Value :cognitect.aws.connect/ReferenceValue)

(s/def
  :cognitect.aws.connect.HierarchyGroupSummaryReference/Id
  :cognitect.aws.connect/HierarchyGroupId)

(s/def :cognitect.aws.connect.HierarchyGroupSummaryReference/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.StopContactRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.StopContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StopContactRequest/DisconnectReason
  :cognitect.aws.connect/DisconnectReason)

(s/def :cognitect.aws.connect.DeleteInstanceRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DeleteInstanceRequest/ClientToken :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.StateTransition/State :cognitect.aws.connect/ParticipantState)

(s/def :cognitect.aws.connect.StateTransition/StateStartTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.StateTransition/StateEndTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.HierarchyLevel/Id :cognitect.aws.connect/HierarchyLevelId)

(s/def :cognitect.aws.connect.HierarchyLevel/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.HierarchyLevel/Name :cognitect.aws.connect/HierarchyLevelName)

(s/def :cognitect.aws.connect.HierarchyLevel/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.HierarchyLevel/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.ContactFlowModuleSummary/Id
  :cognitect.aws.connect/ContactFlowModuleId)

(s/def :cognitect.aws.connect.ContactFlowModuleSummary/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ContactFlowModuleSummary/Name
  :cognitect.aws.connect/ContactFlowModuleName)

(s/def
  :cognitect.aws.connect.ContactFlowModuleSummary/State
  :cognitect.aws.connect/ContactFlowModuleState)

(s/def
  :cognitect.aws.connect.InvalidRequestExceptionReason/AttachedFileInvalidRequestExceptionReason
  :cognitect.aws.connect/AttachedFileInvalidRequestExceptionReason)

(s/def
  :cognitect.aws.connect.ListViewVersionsRequest/InstanceId
  :cognitect.aws.connect/ViewsInstanceId)

(s/def :cognitect.aws.connect.ListViewVersionsRequest/ViewId :cognitect.aws.connect/ViewId)

(s/def
  :cognitect.aws.connect.ListViewVersionsRequest/NextToken
  :cognitect.aws.connect/ViewsNextToken)

(s/def :cognitect.aws.connect.ListViewVersionsRequest/MaxResults :cognitect.aws.connect/MaxResults)

(s/def
  :cognitect.aws.connect.InboundAdditionalRecipients/ToAddresses
  :cognitect.aws.connect/EmailAddressRecipientList)

(s/def
  :cognitect.aws.connect.InboundAdditionalRecipients/CcAddresses
  :cognitect.aws.connect/EmailAddressRecipientList)

(s/def :cognitect.aws.connect.WisdomInfo/SessionArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.MaximumResultReturnedException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.GetCurrentMetricDataRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.GetCurrentMetricDataRequest/Filters :cognitect.aws.connect/Filters)

(s/def
  :cognitect.aws.connect.GetCurrentMetricDataRequest/Groupings
  :cognitect.aws.connect/Groupings)

(s/def
  :cognitect.aws.connect.GetCurrentMetricDataRequest/CurrentMetrics
  :cognitect.aws.connect/CurrentMetrics)

(s/def
  :cognitect.aws.connect.GetCurrentMetricDataRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.GetCurrentMetricDataRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.GetCurrentMetricDataRequest/SortCriteria
  :cognitect.aws.connect/CurrentMetricSortCriteriaMaxOne)

(s/def :cognitect.aws.connect.AttachedFile/FileArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.AttachedFile/FileSizeInBytes :cognitect.aws.connect/FileSizeInBytes)

(s/def :cognitect.aws.connect.AttachedFile/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.AttachedFile/CreatedBy :cognitect.aws.connect/CreatedByInfo)

(s/def :cognitect.aws.connect.AttachedFile/FileStatus :cognitect.aws.connect/FileStatusType)

(s/def :cognitect.aws.connect.AttachedFile/FileId :cognitect.aws.connect/FileId)

(s/def :cognitect.aws.connect.AttachedFile/CreationTime :cognitect.aws.connect/ISO8601Datetime)

(s/def :cognitect.aws.connect.AttachedFile/AssociatedResourceArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.AttachedFile/FileUseCaseType :cognitect.aws.connect/FileUseCaseType)

(s/def :cognitect.aws.connect.AttachedFile/FileName :cognitect.aws.connect/FileName)

(s/def
  :cognitect.aws.connect.CurrentMetricSortCriteria/SortByMetric
  :cognitect.aws.connect/CurrentMetricName)

(s/def :cognitect.aws.connect.CurrentMetricSortCriteria/SortOrder :cognitect.aws.connect/SortOrder)

(s/def :cognitect.aws.connect.ContactMetricInfo/Name :cognitect.aws.connect/ContactMetricName)

(s/def
  :cognitect.aws.connect.UpdateParticipantRoleConfigChannelInfo/Chat
  :cognitect.aws.connect/ChatParticipantRoleConfig)

(s/def
  :cognitect.aws.connect.UpdateUserProficienciesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.UpdateUserProficienciesRequest/UserId :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.UpdateUserProficienciesRequest/UserProficiencies
  :cognitect.aws.connect/UserProficiencyList)

(s/def
  :cognitect.aws.connect.DeleteUserHierarchyGroupRequest/HierarchyGroupId
  :cognitect.aws.connect/HierarchyGroupId)

(s/def
  :cognitect.aws.connect.DeleteUserHierarchyGroupRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowModuleMetadataRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowModuleMetadataRequest/ContactFlowModuleId
  :cognitect.aws.connect/ContactFlowModuleId)

(s/def
  :cognitect.aws.connect.UpdateContactFlowModuleMetadataRequest/Name
  :cognitect.aws.connect/ContactFlowModuleName)

(s/def
  :cognitect.aws.connect.UpdateContactFlowModuleMetadataRequest/Description
  :cognitect.aws.connect/ContactFlowModuleDescription)

(s/def
  :cognitect.aws.connect.UpdateContactFlowModuleMetadataRequest/State
  :cognitect.aws.connect/ContactFlowModuleState)

(s/def :cognitect.aws.connect.TagSearchCondition/tagKey :cognitect.aws.connect/TagKeyString)

(s/def :cognitect.aws.connect.TagSearchCondition/tagValue :cognitect.aws.connect/TagValueString)

(s/def
  :cognitect.aws.connect.TagSearchCondition/tagKeyComparisonType
  :cognitect.aws.connect/StringComparisonType)

(s/def
  :cognitect.aws.connect.TagSearchCondition/tagValueComparisonType
  :cognitect.aws.connect/StringComparisonType)

(s/def :cognitect.aws.connect.SearchResourceTagsResponse/Tags :cognitect.aws.connect/TagsList)

(s/def
  :cognitect.aws.connect.SearchResourceTagsResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.GetMetricDataV2Response/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.GetMetricDataV2Response/MetricResults
  :cognitect.aws.connect/MetricResultsV2)

(s/def
  :cognitect.aws.connect.ActivateEvaluationFormRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ActivateEvaluationFormRequest/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.ActivateEvaluationFormRequest/EvaluationFormVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.TrafficDistributionGroupUserSummary/UserId
  :cognitect.aws.connect/UserId)

(s/def :cognitect.aws.connect.ListTagsForResourceResponse/tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.StartContactRecordingRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartContactRecordingRequest/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartContactRecordingRequest/InitialContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartContactRecordingRequest/VoiceRecordingConfiguration
  :cognitect.aws.connect/VoiceRecordingConfiguration)

(s/def
  :cognitect.aws.connect.CreateEvaluationFormRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.CreateEvaluationFormRequest/Title
  :cognitect.aws.connect/EvaluationFormTitle)

(s/def
  :cognitect.aws.connect.CreateEvaluationFormRequest/Description
  :cognitect.aws.connect/EvaluationFormDescription)

(s/def
  :cognitect.aws.connect.CreateEvaluationFormRequest/Items
  :cognitect.aws.connect/EvaluationFormItemsList)

(s/def
  :cognitect.aws.connect.CreateEvaluationFormRequest/ScoringStrategy
  :cognitect.aws.connect/EvaluationFormScoringStrategy)

(s/def
  :cognitect.aws.connect.CreateEvaluationFormRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.LimitExceededException/Message :cognitect.aws.connect/Message)

(s/def :cognitect.aws.connect.CreatedByInfo/ConnectUserArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.CreatedByInfo/AWSIdentityArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberType
  :cognitect.aws.connect/PhoneNumberType)

(s/def :cognitect.aws.connect.ClaimedPhoneNumberSummary/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.ClaimedPhoneNumberSummary/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ClaimedPhoneNumberSummary/SourcePhoneNumberArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberStatus
  :cognitect.aws.connect/PhoneNumberStatus)

(s/def
  :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberCountryCode
  :cognitect.aws.connect/PhoneNumberCountryCode)

(s/def
  :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumber
  :cognitect.aws.connect/PhoneNumber)

(s/def
  :cognitect.aws.connect.ClaimedPhoneNumberSummary/PhoneNumberDescription
  :cognitect.aws.connect/PhoneNumberDescription)

(s/def :cognitect.aws.connect.ClaimedPhoneNumberSummary/TargetArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ListInstancesResponse/InstanceSummaryList
  :cognitect.aws.connect/InstanceSummaryList)

(s/def :cognitect.aws.connect.ListInstancesResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.SubmitAutoEvaluationActionDefinition/EvaluationFormId
  :cognitect.aws.connect/EvaluationFormId)

(s/def
  :cognitect.aws.connect.DisassociateLexBotRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DisassociateLexBotRequest/BotName :cognitect.aws.connect/BotName)

(s/def :cognitect.aws.connect.DisassociateLexBotRequest/LexRegion :cognitect.aws.connect/LexRegion)

(s/def
  :cognitect.aws.connect.DisassociateLexBotRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.HoursOfOperationSearchCriteria/OrConditions
  :cognitect.aws.connect/HoursOfOperationSearchConditionList)

(s/def
  :cognitect.aws.connect.HoursOfOperationSearchCriteria/AndConditions
  :cognitect.aws.connect/HoursOfOperationSearchConditionList)

(s/def
  :cognitect.aws.connect.HoursOfOperationSearchCriteria/StringCondition
  :cognitect.aws.connect/StringCondition)

(s/def :cognitect.aws.connect.SearchContactsRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchContactsRequest/TimeRange
  :cognitect.aws.connect/SearchContactsTimeRange)

(s/def
  :cognitect.aws.connect.SearchContactsRequest/SearchCriteria
  :cognitect.aws.connect/SearchCriteria)

(s/def :cognitect.aws.connect.SearchContactsRequest/MaxResults :cognitect.aws.connect/MaxResult100)

(s/def :cognitect.aws.connect.SearchContactsRequest/NextToken :cognitect.aws.connect/LargeNextToken)

(s/def :cognitect.aws.connect.SearchContactsRequest/Sort :cognitect.aws.connect/Sort)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationRequest/Name
  :cognitect.aws.connect/CommonNameLength127)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationRequest/Description
  :cognitect.aws.connect/UpdateHoursOfOperationDescription)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationRequest/TimeZone
  :cognitect.aws.connect/TimeZone)

(s/def
  :cognitect.aws.connect.UpdateHoursOfOperationRequest/Config
  :cognitect.aws.connect/HoursOfOperationConfigList)

(s/def :cognitect.aws.connect.UserReference/Id :cognitect.aws.connect/UserId)

(s/def :cognitect.aws.connect.UserReference/Arn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.RoutingProfileQueueConfigSummary/QueueId
  :cognitect.aws.connect/QueueId)

(s/def :cognitect.aws.connect.RoutingProfileQueueConfigSummary/QueueArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.RoutingProfileQueueConfigSummary/QueueName
  :cognitect.aws.connect/QueueName)

(s/def
  :cognitect.aws.connect.RoutingProfileQueueConfigSummary/Priority
  :cognitect.aws.connect/Priority)

(s/def :cognitect.aws.connect.RoutingProfileQueueConfigSummary/Delay :cognitect.aws.connect/Delay)

(s/def
  :cognitect.aws.connect.RoutingProfileQueueConfigSummary/Channel
  :cognitect.aws.connect/Channel)

(s/def :cognitect.aws.connect.ListQuickConnectsRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListQuickConnectsRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListQuickConnectsRequest/MaxResults
  :cognitect.aws.connect/MaxResult1000)

(s/def
  :cognitect.aws.connect.ListQuickConnectsRequest/QuickConnectTypes
  :cognitect.aws.connect/QuickConnectTypes)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverride/HoursOfOperationOverrideId
  :cognitect.aws.connect/HoursOfOperationOverrideId)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverride/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverride/HoursOfOperationArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverride/Name
  :cognitect.aws.connect/CommonHumanReadableName)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverride/Description
  :cognitect.aws.connect/CommonHumanReadableDescription)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverride/Config
  :cognitect.aws.connect/HoursOfOperationOverrideConfigList)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverride/EffectiveFrom
  :cognitect.aws.connect/HoursOfOperationOverrideYearMonthDayDateFormat)

(s/def
  :cognitect.aws.connect.HoursOfOperationOverride/EffectiveTill
  :cognitect.aws.connect/HoursOfOperationOverrideYearMonthDayDateFormat)

(s/def :cognitect.aws.connect.DescribeRuleRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DescribeRuleRequest/RuleId :cognitect.aws.connect/RuleId)

(s/def
  :cognitect.aws.connect.SearchRoutingProfilesResponse/RoutingProfiles
  :cognitect.aws.connect/RoutingProfileList)

(s/def
  :cognitect.aws.connect.SearchRoutingProfilesResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchRoutingProfilesResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.ResourceInUseException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.ResourceInUseException/ResourceType
  :cognitect.aws.connect/ResourceType)

(s/def :cognitect.aws.connect.ResourceInUseException/ResourceId :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.ListSecurityKeysRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListSecurityKeysRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.ListSecurityKeysRequest/MaxResults :cognitect.aws.connect/MaxResult2)

(s/def
  :cognitect.aws.connect.UpdateQuickConnectConfigRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateQuickConnectConfigRequest/QuickConnectId
  :cognitect.aws.connect/QuickConnectId)

(s/def
  :cognitect.aws.connect.UpdateQuickConnectConfigRequest/QuickConnectConfig
  :cognitect.aws.connect/QuickConnectConfig)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationOverridesResponse/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationOverridesResponse/HoursOfOperationOverrideList
  :cognitect.aws.connect/HoursOfOperationOverrideList)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationOverridesResponse/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def
  :cognitect.aws.connect.ListHoursOfOperationOverridesResponse/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.GetAttachedFileRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.GetAttachedFileRequest/FileId :cognitect.aws.connect/FileId)

(s/def
  :cognitect.aws.connect.GetAttachedFileRequest/UrlExpiryInSeconds
  :cognitect.aws.connect/URLExpiryInSeconds)

(s/def
  :cognitect.aws.connect.GetAttachedFileRequest/AssociatedResourceArn
  :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.GetMetricDataRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.GetMetricDataRequest/StartTime :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.GetMetricDataRequest/EndTime :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.GetMetricDataRequest/Filters :cognitect.aws.connect/Filters)

(s/def :cognitect.aws.connect.GetMetricDataRequest/Groupings :cognitect.aws.connect/Groupings)

(s/def
  :cognitect.aws.connect.GetMetricDataRequest/HistoricalMetrics
  :cognitect.aws.connect/HistoricalMetrics)

(s/def :cognitect.aws.connect.GetMetricDataRequest/NextToken :cognitect.aws.connect/NextToken)

(s/def :cognitect.aws.connect.GetMetricDataRequest/MaxResults :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.ListInstanceStorageConfigsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListInstanceStorageConfigsRequest/ResourceType
  :cognitect.aws.connect/InstanceStorageResourceType)

(s/def
  :cognitect.aws.connect.ListInstanceStorageConfigsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListInstanceStorageConfigsRequest/MaxResults
  :cognitect.aws.connect/MaxResult10)

(s/def
  :cognitect.aws.connect.DeleteSecurityProfileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DeleteSecurityProfileRequest/SecurityProfileId
  :cognitect.aws.connect/SecurityProfileId)

(s/def :cognitect.aws.connect.DuplicateResourceException/Message :cognitect.aws.connect/Message)

(s/def :cognitect.aws.connect.Expiry/DurationInSeconds :cognitect.aws.connect/DurationInSeconds)

(s/def :cognitect.aws.connect.Expiry/ExpiryTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.HierarchyStructure/LevelOne :cognitect.aws.connect/HierarchyLevel)

(s/def :cognitect.aws.connect.HierarchyStructure/LevelTwo :cognitect.aws.connect/HierarchyLevel)

(s/def :cognitect.aws.connect.HierarchyStructure/LevelThree :cognitect.aws.connect/HierarchyLevel)

(s/def :cognitect.aws.connect.HierarchyStructure/LevelFour :cognitect.aws.connect/HierarchyLevel)

(s/def :cognitect.aws.connect.HierarchyStructure/LevelFive :cognitect.aws.connect/HierarchyLevel)

(s/def :cognitect.aws.connect.TooManyRequestsException/Message :cognitect.aws.connect/Message)

(s/def :cognitect.aws.connect.CrossChannelBehavior/BehaviorType :cognitect.aws.connect/BehaviorType)

(s/def
  :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/ContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/NextToken
  :cognitect.aws.connect/LargeNextToken)

(s/def
  :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/OutputType
  :cognitect.aws.connect/RealTimeContactAnalysisOutputType)

(s/def
  :cognitect.aws.connect.ListRealtimeContactAnalysisSegmentsV2Request/SegmentTypes
  :cognitect.aws.connect/RealTimeContactAnalysisSegmentTypes)

(s/def :cognitect.aws.connect.CreateAgentStatusRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.CreateAgentStatusRequest/Name :cognitect.aws.connect/AgentStatusName)

(s/def
  :cognitect.aws.connect.CreateAgentStatusRequest/Description
  :cognitect.aws.connect/AgentStatusDescription)

(s/def
  :cognitect.aws.connect.CreateAgentStatusRequest/State
  :cognitect.aws.connect/AgentStatusState)

(s/def
  :cognitect.aws.connect.CreateAgentStatusRequest/DisplayOrder
  :cognitect.aws.connect/AgentStatusOrderNumber)

(s/def :cognitect.aws.connect.CreateAgentStatusRequest/Tags :cognitect.aws.connect/TagMap)

(s/def
  :cognitect.aws.connect.GetPromptFileResponse/PromptPresignedUrl
  :cognitect.aws.connect/PromptPresignedUrl)

(s/def
  :cognitect.aws.connect.GetPromptFileResponse/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.GetPromptFileResponse/LastModifiedRegion
  :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.ReplicateInstanceResponse/Id :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ReplicateInstanceResponse/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.DisconnectReason/Code :cognitect.aws.connect/DisconnectReasonCode)

(s/def
  :cognitect.aws.connect.UpdateAuthenticationProfileRequest/AuthenticationProfileId
  :cognitect.aws.connect/AuthenticationProfileId)

(s/def
  :cognitect.aws.connect.UpdateAuthenticationProfileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateAuthenticationProfileRequest/Name
  :cognitect.aws.connect/AuthenticationProfileName)

(s/def
  :cognitect.aws.connect.UpdateAuthenticationProfileRequest/Description
  :cognitect.aws.connect/AuthenticationProfileDescription)

(s/def
  :cognitect.aws.connect.UpdateAuthenticationProfileRequest/AllowedIps
  :cognitect.aws.connect/IpCidrList)

(s/def
  :cognitect.aws.connect.UpdateAuthenticationProfileRequest/BlockedIps
  :cognitect.aws.connect/IpCidrList)

(s/def
  :cognitect.aws.connect.UpdateAuthenticationProfileRequest/PeriodicSessionDuration
  :cognitect.aws.connect/AccessTokenDuration)

(s/def
  :cognitect.aws.connect.VoiceRecordingConfiguration/VoiceRecordingTrack
  :cognitect.aws.connect/VoiceRecordingTrack)

(s/def
  :cognitect.aws.connect.VoiceRecordingConfiguration/IvrRecordingTrack
  :cognitect.aws.connect/IvrRecordingTrack)

(s/def :cognitect.aws.connect.UserQuickConnectConfig/UserId :cognitect.aws.connect/UserId)

(s/def
  :cognitect.aws.connect.UserQuickConnectConfig/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.UpdateQueueHoursOfOperationRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.UpdateQueueHoursOfOperationRequest/QueueId
  :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.UpdateQueueHoursOfOperationRequest/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def :cognitect.aws.connect.GetCurrentUserDataResponse/NextToken :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.GetCurrentUserDataResponse/UserDataList
  :cognitect.aws.connect/UserDataList)

(s/def
  :cognitect.aws.connect.GetCurrentUserDataResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.DisassociateBotRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DisassociateBotRequest/LexBot :cognitect.aws.connect/LexBot)

(s/def :cognitect.aws.connect.DisassociateBotRequest/LexV2Bot :cognitect.aws.connect/LexV2Bot)

(s/def :cognitect.aws.connect.DisassociateBotRequest/ClientToken :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.EventBridgeActionDefinition/Name
  :cognitect.aws.connect/EventBridgeActionName)

(s/def :cognitect.aws.connect.AttachmentReference/Name :cognitect.aws.connect/ReferenceKey)

(s/def :cognitect.aws.connect.AttachmentReference/Value :cognitect.aws.connect/ReferenceValue)

(s/def :cognitect.aws.connect.AttachmentReference/Status :cognitect.aws.connect/ReferenceStatus)

(s/def :cognitect.aws.connect.AttachmentReference/Arn :cognitect.aws.connect/ReferenceArn)

(s/def
  :cognitect.aws.connect.DeleteViewVersionRequest/InstanceId
  :cognitect.aws.connect/ViewsInstanceId)

(s/def :cognitect.aws.connect.DeleteViewVersionRequest/ViewId :cognitect.aws.connect/ViewId)

(s/def
  :cognitect.aws.connect.DeleteViewVersionRequest/ViewVersion
  :cognitect.aws.connect/ViewVersion)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationsResponse/HoursOfOperations
  :cognitect.aws.connect/HoursOfOperationList)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationsResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchHoursOfOperationsResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.Contact/InitialContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.Contact/QueueInfo :cognitect.aws.connect/QueueInfo)

(s/def :cognitect.aws.connect.Contact/ContactEvaluations :cognitect.aws.connect/ContactEvaluations)

(s/def :cognitect.aws.connect.Contact/PreviousContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.Contact/SegmentAttributes :cognitect.aws.connect/SegmentAttributes)

(s/def :cognitect.aws.connect.Contact/Campaign :cognitect.aws.connect/Campaign)

(s/def :cognitect.aws.connect.Contact/QueuePriority :cognitect.aws.connect/QueuePriority)

(s/def
  :cognitect.aws.connect.Contact/TotalPauseDurationInSeconds
  :cognitect.aws.connect/TotalPauseDurationInSeconds)

(s/def :cognitect.aws.connect.Contact/LastResumedTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.Contact/AgentInfo :cognitect.aws.connect/AgentInfo)

(s/def :cognitect.aws.connect.Contact/Id :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.Contact/CustomerId :cognitect.aws.connect/CustomerId)

(s/def
  :cognitect.aws.connect.Contact/AnsweringMachineDetectionStatus
  :cognitect.aws.connect/AnsweringMachineDetectionStatus)

(s/def :cognitect.aws.connect.Contact/Tags :cognitect.aws.connect/ContactTagMap)

(s/def
  :cognitect.aws.connect.Contact/QueueTimeAdjustmentSeconds
  :cognitect.aws.connect/QueueTimeAdjustmentSeconds)

(s/def :cognitect.aws.connect.Contact/CustomerEndpoint :cognitect.aws.connect/EndpointInfo)

(s/def :cognitect.aws.connect.Contact/Channel :cognitect.aws.connect/Channel)

(s/def :cognitect.aws.connect.Contact/DisconnectTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.Contact/RoutingCriteria :cognitect.aws.connect/RoutingCriteria)

(s/def
  :cognitect.aws.connect.Contact/CustomerVoiceActivity
  :cognitect.aws.connect/CustomerVoiceActivity)

(s/def :cognitect.aws.connect.Contact/ContactAssociationId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.Contact/LastUpdateTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.Contact/ConnectedToSystemTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.Contact/TotalPauseCount :cognitect.aws.connect/TotalPauseCount)

(s/def :cognitect.aws.connect.Contact/ChatMetrics :cognitect.aws.connect/ChatMetrics)

(s/def :cognitect.aws.connect.Contact/Customer :cognitect.aws.connect/Customer)

(s/def :cognitect.aws.connect.Contact/ContactDetails :cognitect.aws.connect/ContactDetails)

(s/def :cognitect.aws.connect.Contact/LastPausedTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.Contact/RelatedContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.Contact/ScheduledTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.Contact/DisconnectDetails :cognitect.aws.connect/DisconnectDetails)

(s/def
  :cognitect.aws.connect.Contact/InitiationMethod
  :cognitect.aws.connect/ContactInitiationMethod)

(s/def :cognitect.aws.connect.Contact/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Contact/Name :cognitect.aws.connect/Name)

(s/def :cognitect.aws.connect.Contact/Description :cognitect.aws.connect/Description)

(s/def :cognitect.aws.connect.Contact/QualityMetrics :cognitect.aws.connect/QualityMetrics)

(s/def :cognitect.aws.connect.Contact/Attributes :cognitect.aws.connect/Attributes)

(s/def
  :cognitect.aws.connect.Contact/AdditionalEmailRecipients
  :cognitect.aws.connect/AdditionalEmailRecipients)

(s/def :cognitect.aws.connect.Contact/SystemEndpoint :cognitect.aws.connect/EndpointInfo)

(s/def :cognitect.aws.connect.Contact/WisdomInfo :cognitect.aws.connect/WisdomInfo)

(s/def :cognitect.aws.connect.Contact/InitiationTimestamp :cognitect.aws.connect/timestamp)

(s/def :cognitect.aws.connect.Contact/DisconnectReason :cognitect.aws.connect/String)

(s/def :cognitect.aws.connect.Contact/Recordings :cognitect.aws.connect/Recordings)

(s/def :cognitect.aws.connect.UpdateContactRequest/QueueInfo :cognitect.aws.connect/QueueInfoInput)

(s/def
  :cognitect.aws.connect.UpdateContactRequest/References
  :cognitect.aws.connect/ContactReferences)

(s/def
  :cognitect.aws.connect.UpdateContactRequest/SegmentAttributes
  :cognitect.aws.connect/SegmentAttributes)

(s/def :cognitect.aws.connect.UpdateContactRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.UpdateContactRequest/CustomerEndpoint :cognitect.aws.connect/Endpoint)

(s/def :cognitect.aws.connect.UpdateContactRequest/UserInfo :cognitect.aws.connect/UserInfo)

(s/def :cognitect.aws.connect.UpdateContactRequest/ContactId :cognitect.aws.connect/ContactId)

(s/def :cognitect.aws.connect.UpdateContactRequest/Name :cognitect.aws.connect/Name)

(s/def :cognitect.aws.connect.UpdateContactRequest/Description :cognitect.aws.connect/Description)

(s/def :cognitect.aws.connect.UpdateContactRequest/SystemEndpoint :cognitect.aws.connect/Endpoint)

(s/def
  :cognitect.aws.connect.ClaimPhoneNumberResponse/PhoneNumberId
  :cognitect.aws.connect/PhoneNumberId)

(s/def :cognitect.aws.connect.ClaimPhoneNumberResponse/PhoneNumberArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.ListQueueQuickConnectsRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.ListQueueQuickConnectsRequest/QueueId :cognitect.aws.connect/QueueId)

(s/def
  :cognitect.aws.connect.ListQueueQuickConnectsRequest/NextToken
  :cognitect.aws.connect/NextToken)

(s/def
  :cognitect.aws.connect.ListQueueQuickConnectsRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def :cognitect.aws.connect.SearchPromptsRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.SearchPromptsRequest/NextToken :cognitect.aws.connect/NextToken2500)

(s/def :cognitect.aws.connect.SearchPromptsRequest/MaxResults :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchPromptsRequest/SearchFilter
  :cognitect.aws.connect/PromptSearchFilter)

(s/def
  :cognitect.aws.connect.SearchPromptsRequest/SearchCriteria
  :cognitect.aws.connect/PromptSearchCriteria)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationResponse/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def
  :cognitect.aws.connect.CreateHoursOfOperationResponse/HoursOfOperationArn
  :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.HoursOfOperation/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.HoursOfOperation/Config
  :cognitect.aws.connect/HoursOfOperationConfigList)

(s/def :cognitect.aws.connect.HoursOfOperation/HoursOfOperationArn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.HoursOfOperation/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.HoursOfOperation/TimeZone :cognitect.aws.connect/TimeZone)

(s/def :cognitect.aws.connect.HoursOfOperation/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.HoursOfOperation/Name :cognitect.aws.connect/CommonNameLength127)

(s/def
  :cognitect.aws.connect.HoursOfOperation/Description
  :cognitect.aws.connect/HoursOfOperationDescription)

(s/def
  :cognitect.aws.connect.HoursOfOperation/HoursOfOperationId
  :cognitect.aws.connect/HoursOfOperationId)

(s/def
  :cognitect.aws.connect.RealTimeContactAnalysisSegmentCategories/MatchedDetails
  :cognitect.aws.connect/RealTimeContactAnalysisMatchedDetails)

(s/def
  :cognitect.aws.connect.DeleteAttachedFileRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.DeleteAttachedFileRequest/FileId :cognitect.aws.connect/FileId)

(s/def
  :cognitect.aws.connect.DeleteAttachedFileRequest/AssociatedResourceArn
  :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.StartWebRTCContactRequest/References
  :cognitect.aws.connect/ContactReferences)

(s/def
  :cognitect.aws.connect.StartWebRTCContactRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.StartWebRTCContactRequest/ContactFlowId
  :cognitect.aws.connect/ContactFlowId)

(s/def
  :cognitect.aws.connect.StartWebRTCContactRequest/ParticipantDetails
  :cognitect.aws.connect/ParticipantDetails)

(s/def
  :cognitect.aws.connect.StartWebRTCContactRequest/RelatedContactId
  :cognitect.aws.connect/ContactId)

(s/def
  :cognitect.aws.connect.StartWebRTCContactRequest/Description
  :cognitect.aws.connect/Description)

(s/def
  :cognitect.aws.connect.StartWebRTCContactRequest/ClientToken
  :cognitect.aws.connect/ClientToken)

(s/def
  :cognitect.aws.connect.StartWebRTCContactRequest/Attributes
  :cognitect.aws.connect/Attributes)

(s/def
  :cognitect.aws.connect.StartWebRTCContactRequest/AllowedCapabilities
  :cognitect.aws.connect/AllowedCapabilities)

(s/def
  :cognitect.aws.connect.SearchEmailAddressesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchEmailAddressesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchEmailAddressesRequest/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchEmailAddressesRequest/SearchCriteria
  :cognitect.aws.connect/EmailAddressSearchCriteria)

(s/def
  :cognitect.aws.connect.SearchEmailAddressesRequest/SearchFilter
  :cognitect.aws.connect/EmailAddressSearchFilter)

(s/def :cognitect.aws.connect.AssociateBotRequest/InstanceId :cognitect.aws.connect/InstanceId)

(s/def :cognitect.aws.connect.AssociateBotRequest/LexBot :cognitect.aws.connect/LexBot)

(s/def :cognitect.aws.connect.AssociateBotRequest/LexV2Bot :cognitect.aws.connect/LexV2Bot)

(s/def :cognitect.aws.connect.AssociateBotRequest/ClientToken :cognitect.aws.connect/ClientToken)

(s/def :cognitect.aws.connect.EmailMessageReference/Name :cognitect.aws.connect/ReferenceKey)

(s/def :cognitect.aws.connect.EmailMessageReference/Arn :cognitect.aws.connect/ReferenceArn)

(s/def
  :cognitect.aws.connect.DescribeUserHierarchyStructureResponse/HierarchyStructure
  :cognitect.aws.connect/HierarchyStructure)

(s/def
  :cognitect.aws.connect.EvaluationFormSummary/EvaluationFormId
  :cognitect.aws.connect/ResourceId)

(s/def
  :cognitect.aws.connect.EvaluationFormSummary/LastModifiedTime
  :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.EvaluationFormSummary/LastActivatedTime
  :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.EvaluationFormSummary/EvaluationFormArn :cognitect.aws.connect/ARN)

(s/def
  :cognitect.aws.connect.EvaluationFormSummary/ActiveVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.EvaluationFormSummary/LatestVersion
  :cognitect.aws.connect/VersionNumber)

(s/def
  :cognitect.aws.connect.EvaluationFormSummary/Title
  :cognitect.aws.connect/EvaluationFormTitle)

(s/def :cognitect.aws.connect.EvaluationFormSummary/LastActivatedBy :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.EvaluationFormSummary/CreatedBy :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.EvaluationFormSummary/LastModifiedBy :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.EvaluationFormSummary/CreatedTime :cognitect.aws.connect/Timestamp)

(s/def :cognitect.aws.connect.Reference/Value :cognitect.aws.connect/ReferenceValue)

(s/def :cognitect.aws.connect.Reference/Type :cognitect.aws.connect/ReferenceType)

(s/def :cognitect.aws.connect.Reference/Status :cognitect.aws.connect/ReferenceStatus)

(s/def :cognitect.aws.connect.Reference/Arn :cognitect.aws.connect/ReferenceArn)

(s/def :cognitect.aws.connect.Reference/StatusReason :cognitect.aws.connect/ReferenceStatusReason)

(s/def :cognitect.aws.connect.CreateViewRequest/InstanceId :cognitect.aws.connect/ViewsInstanceId)

(s/def :cognitect.aws.connect.CreateViewRequest/ClientToken :cognitect.aws.connect/ViewsClientToken)

(s/def :cognitect.aws.connect.CreateViewRequest/Status :cognitect.aws.connect/ViewStatus)

(s/def :cognitect.aws.connect.CreateViewRequest/Content :cognitect.aws.connect/ViewInputContent)

(s/def :cognitect.aws.connect.CreateViewRequest/Description :cognitect.aws.connect/ViewDescription)

(s/def :cognitect.aws.connect.CreateViewRequest/Name :cognitect.aws.connect/ViewName)

(s/def :cognitect.aws.connect.CreateViewRequest/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.ResourceNotFoundException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.SearchSecurityProfilesResponse/SecurityProfiles
  :cognitect.aws.connect/SecurityProfilesSearchSummaryList)

(s/def
  :cognitect.aws.connect.SearchSecurityProfilesResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchSecurityProfilesResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.ConflictException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.TaskTemplateDefaults/DefaultFieldValues
  :cognitect.aws.connect/TaskTemplateDefaultFieldValueList)

(s/def
  :cognitect.aws.connect.EvaluationFormQuestion/Title
  :cognitect.aws.connect/EvaluationFormQuestionTitle)

(s/def
  :cognitect.aws.connect.EvaluationFormQuestion/Instructions
  :cognitect.aws.connect/EvaluationFormQuestionInstructions)

(s/def :cognitect.aws.connect.EvaluationFormQuestion/RefId :cognitect.aws.connect/ReferenceId)

(s/def
  :cognitect.aws.connect.EvaluationFormQuestion/NotApplicableEnabled
  :cognitect.aws.connect/Boolean)

(s/def
  :cognitect.aws.connect.EvaluationFormQuestion/QuestionType
  :cognitect.aws.connect/EvaluationFormQuestionType)

(s/def
  :cognitect.aws.connect.EvaluationFormQuestion/QuestionTypeProperties
  :cognitect.aws.connect/EvaluationFormQuestionTypeProperties)

(s/def
  :cognitect.aws.connect.EvaluationFormQuestion/Weight
  :cognitect.aws.connect/EvaluationFormItemWeight)

(s/def
  :cognitect.aws.connect.SearchVocabulariesRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.SearchVocabulariesRequest/MaxResults
  :cognitect.aws.connect/MaxResult100)

(s/def
  :cognitect.aws.connect.SearchVocabulariesRequest/NextToken
  :cognitect.aws.connect/VocabularyNextToken)

(s/def
  :cognitect.aws.connect.SearchVocabulariesRequest/State
  :cognitect.aws.connect/VocabularyState)

(s/def
  :cognitect.aws.connect.SearchVocabulariesRequest/NameStartsWith
  :cognitect.aws.connect/VocabularyName)

(s/def
  :cognitect.aws.connect.SearchVocabulariesRequest/LanguageCode
  :cognitect.aws.connect/VocabularyLanguageCode)

(s/def
  :cognitect.aws.connect.DescribeQuickConnectRequest/InstanceId
  :cognitect.aws.connect/InstanceId)

(s/def
  :cognitect.aws.connect.DescribeQuickConnectRequest/QuickConnectId
  :cognitect.aws.connect/QuickConnectId)

(s/def
  :cognitect.aws.connect.SearchQuickConnectsResponse/QuickConnects
  :cognitect.aws.connect/QuickConnectSearchSummaryList)

(s/def
  :cognitect.aws.connect.SearchQuickConnectsResponse/NextToken
  :cognitect.aws.connect/NextToken2500)

(s/def
  :cognitect.aws.connect.SearchQuickConnectsResponse/ApproximateTotalCount
  :cognitect.aws.connect/ApproximateTotalCount)

(s/def :cognitect.aws.connect.AgentStatus/LastModifiedTime :cognitect.aws.connect/Timestamp)

(s/def
  :cognitect.aws.connect.AgentStatus/DisplayOrder
  :cognitect.aws.connect/AgentStatusOrderNumber)

(s/def :cognitect.aws.connect.AgentStatus/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.AgentStatus/AgentStatusARN :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.AgentStatus/LastModifiedRegion :cognitect.aws.connect/RegionName)

(s/def :cognitect.aws.connect.AgentStatus/Name :cognitect.aws.connect/AgentStatusName)

(s/def :cognitect.aws.connect.AgentStatus/Description :cognitect.aws.connect/AgentStatusDescription)

(s/def :cognitect.aws.connect.AgentStatus/AgentStatusId :cognitect.aws.connect/AgentStatusId)

(s/def :cognitect.aws.connect.AgentStatus/Type :cognitect.aws.connect/AgentStatusType)

(s/def :cognitect.aws.connect.AgentStatus/State :cognitect.aws.connect/AgentStatusState)

(s/def :cognitect.aws.connect.ResourceNotReadyException/Message :cognitect.aws.connect/Message)

(s/def
  :cognitect.aws.connect.Vocabulary/LastModifiedTime
  :cognitect.aws.connect/VocabularyLastModifiedTime)

(s/def :cognitect.aws.connect.Vocabulary/Id :cognitect.aws.connect/VocabularyId)

(s/def :cognitect.aws.connect.Vocabulary/Tags :cognitect.aws.connect/TagMap)

(s/def :cognitect.aws.connect.Vocabulary/Arn :cognitect.aws.connect/ARN)

(s/def :cognitect.aws.connect.Vocabulary/Name :cognitect.aws.connect/VocabularyName)

(s/def :cognitect.aws.connect.Vocabulary/State :cognitect.aws.connect/VocabularyState)

(s/def
  :cognitect.aws.connect.Vocabulary/FailureReason
  :cognitect.aws.connect/VocabularyFailureReason)

(s/def :cognitect.aws.connect.Vocabulary/Content :cognitect.aws.connect/VocabularyContent)

(s/def :cognitect.aws.connect.Vocabulary/LanguageCode :cognitect.aws.connect/VocabularyLanguageCode)

