;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.discovery.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.discovery/ListServerNeighborsResponse
  (s/keys
    :req-un
    [:cognitect.aws.discovery.ListServerNeighborsResponse/neighbors]
    :opt-un
    [:cognitect.aws.discovery.ListServerNeighborsResponse/knownDependencyCount
     :cognitect.aws.discovery.ListServerNeighborsResponse/nextToken]))

(s/def
  :cognitect.aws.discovery/ApplicationIdsList
  (s/coll-of :cognitect.aws.discovery/ApplicationId))

(s/def :cognitect.aws.discovery/ImportTaskIdentifier string?)

(s/def :cognitect.aws.discovery/Configurations (s/coll-of :cognitect.aws.discovery/Configuration))

(s/def
  :cognitect.aws.discovery/TagFilter
  (s/keys
    :req-un
    [:cognitect.aws.discovery.TagFilter/name :cognitect.aws.discovery.TagFilter/values]))

(s/def :cognitect.aws.discovery/TimeStamp inst?)

(s/def
  :cognitect.aws.discovery/DisassociateConfigurationItemsFromApplicationRequest
  (s/keys
    :req-un
    [:cognitect.aws.discovery.DisassociateConfigurationItemsFromApplicationRequest/applicationConfigurationId
     :cognitect.aws.discovery.DisassociateConfigurationItemsFromApplicationRequest/configurationIds]))

(s/def
  :cognitect.aws.discovery/DescribeExportConfigurationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeExportConfigurationsResponse/exportsInfo
     :cognitect.aws.discovery.DescribeExportConfigurationsResponse/nextToken]))

(s/def
  :cognitect.aws.discovery/Tag
  (s/keys :req-un [:cognitect.aws.discovery.Tag/key :cognitect.aws.discovery.Tag/value]))

(s/def
  :cognitect.aws.discovery/ImportURL
  (s/spec
    (s/and string? #(<= 1 (count %) 4000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 4000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.discovery/DeleteTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.discovery.DeleteTagsRequest/configurationIds]
    :opt-un
    [:cognitect.aws.discovery.DeleteTagsRequest/tags]))

(s/def
  :cognitect.aws.discovery/StartImportTaskRequest
  (s/keys
    :req-un
    [:cognitect.aws.discovery.StartImportTaskRequest/name
     :cognitect.aws.discovery.StartImportTaskRequest/importUrl]
    :opt-un
    [:cognitect.aws.discovery.StartImportTaskRequest/clientRequestToken]))

(s/def :cognitect.aws.discovery/S3PresignedUrl string?)

(s/def
  :cognitect.aws.discovery/StopContinuousExportRequest
  (s/keys :req-un [:cognitect.aws.discovery.StopContinuousExportRequest/exportId]))

(s/def
  :cognitect.aws.discovery/ImportTask
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.ImportTask/serverImportSuccess
     :cognitect.aws.discovery.ImportTask/importDeletedTime
     :cognitect.aws.discovery.ImportTask/clientRequestToken
     :cognitect.aws.discovery.ImportTask/name
     :cognitect.aws.discovery.ImportTask/status
     :cognitect.aws.discovery.ImportTask/serverImportFailure
     :cognitect.aws.discovery.ImportTask/applicationImportFailure
     :cognitect.aws.discovery.ImportTask/errorsAndFailedEntriesZip
     :cognitect.aws.discovery.ImportTask/importTaskId
     :cognitect.aws.discovery.ImportTask/importRequestTime
     :cognitect.aws.discovery.ImportTask/applicationImportSuccess
     :cognitect.aws.discovery.ImportTask/importCompletionTime
     :cognitect.aws.discovery.ImportTask/importUrl]))

(s/def :cognitect.aws.discovery/ImportTaskFilterName string?)

(s/def :cognitect.aws.discovery/DeleteApplicationsResponse (s/keys))

(s/def
  :cognitect.aws.discovery/AgentNetworkInfoList
  (s/coll-of :cognitect.aws.discovery/AgentNetworkInfo))

(s/def :cognitect.aws.discovery/ExportsInfo (s/coll-of :cognitect.aws.discovery/ExportInfo))

(s/def :cognitect.aws.discovery/FilterValues (s/coll-of :cognitect.aws.discovery/FilterValue))

(s/def
  :cognitect.aws.discovery/Filter
  (s/keys
    :req-un
    [:cognitect.aws.discovery.Filter/name
     :cognitect.aws.discovery.Filter/values
     :cognitect.aws.discovery.Filter/condition]))

(s/def
  :cognitect.aws.discovery/DescribeExportTasksRequest
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeExportTasksRequest/filters
     :cognitect.aws.discovery.DescribeExportTasksRequest/maxResults
     :cognitect.aws.discovery.DescribeExportTasksRequest/nextToken
     :cognitect.aws.discovery.DescribeExportTasksRequest/exportIds]))

(s/def :cognitect.aws.discovery/orderString string?)

(s/def
  :cognitect.aws.discovery/NeighborDetailsList
  (s/coll-of :cognitect.aws.discovery/NeighborConnectionDetail))

(s/def
  :cognitect.aws.discovery/AssociateConfigurationItemsToApplicationRequest
  (s/keys
    :req-un
    [:cognitect.aws.discovery.AssociateConfigurationItemsToApplicationRequest/applicationConfigurationId
     :cognitect.aws.discovery.AssociateConfigurationItemsToApplicationRequest/configurationIds]))

(s/def
  :cognitect.aws.discovery/ImportTaskFilterValueList
  (s/coll-of :cognitect.aws.discovery/ImportTaskFilterValue :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.discovery/CustomerAgentInfo
  (s/keys
    :req-un
    [:cognitect.aws.discovery.CustomerAgentInfo/activeAgents
     :cognitect.aws.discovery.CustomerAgentInfo/healthyAgents
     :cognitect.aws.discovery.CustomerAgentInfo/blackListedAgents
     :cognitect.aws.discovery.CustomerAgentInfo/shutdownAgents
     :cognitect.aws.discovery.CustomerAgentInfo/unhealthyAgents
     :cognitect.aws.discovery.CustomerAgentInfo/totalAgents
     :cognitect.aws.discovery.CustomerAgentInfo/unknownAgents]))

(s/def
  :cognitect.aws.discovery/DeleteApplicationsRequest
  (s/keys :req-un [:cognitect.aws.discovery.DeleteApplicationsRequest/configurationIds]))

(s/def
  :cognitect.aws.discovery/ConfigurationIdList
  (s/coll-of :cognitect.aws.discovery/ConfigurationId))

(s/def
  :cognitect.aws.discovery/AgentInfo
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.AgentInfo/lastHealthPingTime
     :cognitect.aws.discovery.AgentInfo/agentId
     :cognitect.aws.discovery.AgentInfo/health
     :cognitect.aws.discovery.AgentInfo/agentNetworkInfoList
     :cognitect.aws.discovery.AgentInfo/connectorId
     :cognitect.aws.discovery.AgentInfo/registeredTime
     :cognitect.aws.discovery.AgentInfo/collectionStatus
     :cognitect.aws.discovery.AgentInfo/agentType
     :cognitect.aws.discovery.AgentInfo/hostName
     :cognitect.aws.discovery.AgentInfo/version]))

(s/def
  :cognitect.aws.discovery/ListServerNeighborsRequest
  (s/keys
    :req-un
    [:cognitect.aws.discovery.ListServerNeighborsRequest/configurationId]
    :opt-un
    [:cognitect.aws.discovery.ListServerNeighborsRequest/maxResults
     :cognitect.aws.discovery.ListServerNeighborsRequest/nextToken
     :cognitect.aws.discovery.ListServerNeighborsRequest/portInformationNeeded
     :cognitect.aws.discovery.ListServerNeighborsRequest/neighborConfigurationIds]))

(s/def
  :cognitect.aws.discovery/ExportIds
  (s/coll-of :cognitect.aws.discovery/ConfigurationsExportId))

(s/def
  :cognitect.aws.discovery/ExportFilter
  (s/keys
    :req-un
    [:cognitect.aws.discovery.ExportFilter/name
     :cognitect.aws.discovery.ExportFilter/values
     :cognitect.aws.discovery.ExportFilter/condition]))

(s/def
  :cognitect.aws.discovery/CreateApplicationResponse
  (s/keys :opt-un [:cognitect.aws.discovery.CreateApplicationResponse/configurationId]))

(s/def :cognitect.aws.discovery/AgentIds (s/coll-of :cognitect.aws.discovery/AgentId))

(s/def :cognitect.aws.discovery/ExportFilters (s/coll-of :cognitect.aws.discovery/ExportFilter))

(s/def :cognitect.aws.discovery/UpdateApplicationResponse (s/keys))

(s/def :cognitect.aws.discovery/ImportStatus string?)

(s/def
  :cognitect.aws.discovery/ListConfigurationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.ListConfigurationsResponse/configurations
     :cognitect.aws.discovery.ListConfigurationsResponse/nextToken]))

(s/def
  :cognitect.aws.discovery/StopDataCollectionByAgentIdsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.StopDataCollectionByAgentIdsResponse/agentsConfigurationStatus]))

(s/def
  :cognitect.aws.discovery/GetDiscoverySummaryResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.GetDiscoverySummaryResponse/connectorSummary
     :cognitect.aws.discovery.GetDiscoverySummaryResponse/applications
     :cognitect.aws.discovery.GetDiscoverySummaryResponse/servers
     :cognitect.aws.discovery.GetDiscoverySummaryResponse/serversMappedToApplications
     :cognitect.aws.discovery.GetDiscoverySummaryResponse/serversMappedtoTags
     :cognitect.aws.discovery.GetDiscoverySummaryResponse/agentSummary]))

(s/def
  :cognitect.aws.discovery/AgentNetworkInfo
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.AgentNetworkInfo/macAddress
     :cognitect.aws.discovery.AgentNetworkInfo/ipAddress]))

(s/def
  :cognitect.aws.discovery/ExportInfo
  (s/keys
    :req-un
    [:cognitect.aws.discovery.ExportInfo/exportId
     :cognitect.aws.discovery.ExportInfo/exportStatus
     :cognitect.aws.discovery.ExportInfo/statusMessage
     :cognitect.aws.discovery.ExportInfo/exportRequestTime]
    :opt-un
    [:cognitect.aws.discovery.ExportInfo/isTruncated
     :cognitect.aws.discovery.ExportInfo/requestedStartTime
     :cognitect.aws.discovery.ExportInfo/configurationsDownloadUrl
     :cognitect.aws.discovery.ExportInfo/requestedEndTime]))

(s/def
  :cognitect.aws.discovery/DescribeContinuousExportsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeContinuousExportsResponse/descriptions
     :cognitect.aws.discovery.DescribeContinuousExportsResponse/nextToken]))

(s/def
  :cognitect.aws.discovery/StopContinuousExportResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.StopContinuousExportResponse/startTime
     :cognitect.aws.discovery.StopContinuousExportResponse/stopTime]))

(s/def
  :cognitect.aws.discovery/OrderByElement
  (s/keys
    :req-un
    [:cognitect.aws.discovery.OrderByElement/fieldName]
    :opt-un
    [:cognitect.aws.discovery.OrderByElement/sortOrder]))

(s/def :cognitect.aws.discovery/BatchDeleteImportDataErrorCode string?)

(s/def :cognitect.aws.discovery/Boolean boolean?)

(s/def :cognitect.aws.discovery/ExportStatusMessage string?)

(s/def
  :cognitect.aws.discovery/BatchDeleteImportDataResponse
  (s/keys :opt-un [:cognitect.aws.discovery.BatchDeleteImportDataResponse/errors]))

(s/def
  :cognitect.aws.discovery/ContinuousExportDescriptions
  (s/coll-of :cognitect.aws.discovery/ContinuousExportDescription))

(s/def :cognitect.aws.discovery/S3Bucket string?)

(s/def :cognitect.aws.discovery/NextToken string?)

(s/def :cognitect.aws.discovery/TagFilters (s/coll-of :cognitect.aws.discovery/TagFilter))

(s/def :cognitect.aws.discovery/AssociateConfigurationItemsToApplicationResponse (s/keys))

(s/def
  :cognitect.aws.discovery/StartImportTaskResponse
  (s/keys :opt-un [:cognitect.aws.discovery.StartImportTaskResponse/task]))

(s/def
  :cognitect.aws.discovery/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.discovery/ConfigurationsExportId string?)

(s/def :cognitect.aws.discovery/TagSet (s/coll-of :cognitect.aws.discovery/Tag))

(s/def
  :cognitect.aws.discovery/StartContinuousExportResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.StartContinuousExportResponse/exportId
     :cognitect.aws.discovery.StartContinuousExportResponse/s3Bucket
     :cognitect.aws.discovery.StartContinuousExportResponse/schemaStorageConfig
     :cognitect.aws.discovery.StartContinuousExportResponse/startTime
     :cognitect.aws.discovery.StartContinuousExportResponse/dataSource]))

(s/def :cognitect.aws.discovery/AgentId string?)

(s/def :cognitect.aws.discovery/ExportStatus string?)

(s/def :cognitect.aws.discovery/TagValue string?)

(s/def
  :cognitect.aws.discovery/AgentConfigurationStatusList
  (s/coll-of :cognitect.aws.discovery/AgentConfigurationStatus))

(s/def
  :cognitect.aws.discovery/DescribeImportTasksResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeImportTasksResponse/tasks
     :cognitect.aws.discovery.DescribeImportTasksResponse/nextToken]))

(s/def
  :cognitect.aws.discovery/ClientRequestToken
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.discovery/ConfigurationTag
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.ConfigurationTag/configurationType
     :cognitect.aws.discovery.ConfigurationTag/key
     :cognitect.aws.discovery.ConfigurationTag/configurationId
     :cognitect.aws.discovery.ConfigurationTag/value
     :cognitect.aws.discovery.ConfigurationTag/timeOfCreation]))

(s/def
  :cognitect.aws.discovery/DescribeExportTasksResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeExportTasksResponse/exportsInfo
     :cognitect.aws.discovery.DescribeExportTasksResponse/nextToken]))

(s/def
  :cognitect.aws.discovery/BatchDeleteImportDataRequest
  (s/keys :req-un [:cognitect.aws.discovery.BatchDeleteImportDataRequest/importTaskIds]))

(s/def
  :cognitect.aws.discovery/DescribeImportTasksRequest
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeImportTasksRequest/filters
     :cognitect.aws.discovery.DescribeImportTasksRequest/maxResults
     :cognitect.aws.discovery.DescribeImportTasksRequest/nextToken]))

(s/def :cognitect.aws.discovery/DeleteTagsResponse (s/keys))

(s/def :cognitect.aws.discovery/GetDiscoverySummaryRequest (s/keys))

(s/def :cognitect.aws.discovery/ExportRequestTime inst?)

(s/def
  :cognitect.aws.discovery/DescribeAgentsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeAgentsRequest/filters
     :cognitect.aws.discovery.DescribeAgentsRequest/maxResults
     :cognitect.aws.discovery.DescribeAgentsRequest/nextToken
     :cognitect.aws.discovery.DescribeAgentsRequest/agentIds]))

(s/def
  :cognitect.aws.discovery/BatchDeleteImportDataError
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.BatchDeleteImportDataError/errorDescription
     :cognitect.aws.discovery.BatchDeleteImportDataError/errorCode
     :cognitect.aws.discovery.BatchDeleteImportDataError/importTaskId]))

(s/def
  :cognitect.aws.discovery/NeighborConnectionDetail
  (s/keys
    :req-un
    [:cognitect.aws.discovery.NeighborConnectionDetail/sourceServerId
     :cognitect.aws.discovery.NeighborConnectionDetail/destinationServerId
     :cognitect.aws.discovery.NeighborConnectionDetail/connectionsCount]
    :opt-un
    [:cognitect.aws.discovery.NeighborConnectionDetail/transportProtocol
     :cognitect.aws.discovery.NeighborConnectionDetail/destinationPort]))

(s/def
  :cognitect.aws.discovery/ImportTaskName
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.discovery/UpdateApplicationRequest
  (s/keys
    :req-un
    [:cognitect.aws.discovery.UpdateApplicationRequest/configurationId]
    :opt-un
    [:cognitect.aws.discovery.UpdateApplicationRequest/name
     :cognitect.aws.discovery.UpdateApplicationRequest/description]))

(s/def
  :cognitect.aws.discovery/CreateApplicationRequest
  (s/keys
    :req-un
    [:cognitect.aws.discovery.CreateApplicationRequest/name]
    :opt-un
    [:cognitect.aws.discovery.CreateApplicationRequest/description]))

(s/def
  :cognitect.aws.discovery/ExportConfigurationsResponse
  (s/keys :opt-un [:cognitect.aws.discovery.ExportConfigurationsResponse/exportId]))

(s/def
  :cognitect.aws.discovery/DescribeConfigurationsAttribute
  (s/map-of :cognitect.aws.discovery/String :cognitect.aws.discovery/String))

(s/def
  :cognitect.aws.discovery/StartDataCollectionByAgentIdsRequest
  (s/keys :req-un [:cognitect.aws.discovery.StartDataCollectionByAgentIdsRequest/agentIds]))

(s/def :cognitect.aws.discovery/Long (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.discovery/ContinuousExportIds
  (s/coll-of :cognitect.aws.discovery/ConfigurationsExportId))

(s/def :cognitect.aws.discovery/StartContinuousExportRequest (s/keys))

(s/def
  :cognitect.aws.discovery/CreateTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.discovery.CreateTagsRequest/configurationIds
     :cognitect.aws.discovery.CreateTagsRequest/tags]))

(s/def
  :cognitect.aws.discovery/ConfigurationTagSet
  (s/coll-of :cognitect.aws.discovery/ConfigurationTag))

(s/def :cognitect.aws.discovery/ConfigurationId string?)

(s/def
  :cognitect.aws.discovery/DescribeConfigurationsResponse
  (s/keys :opt-un [:cognitect.aws.discovery.DescribeConfigurationsResponse/configurations]))

(s/def
  :cognitect.aws.discovery/ImportTaskFilterValue
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.discovery/TagKey string?)

(s/def
  :cognitect.aws.discovery/DescribeContinuousExportsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeContinuousExportsRequest/maxResults
     :cognitect.aws.discovery.DescribeContinuousExportsRequest/nextToken
     :cognitect.aws.discovery.DescribeContinuousExportsRequest/exportIds]))

(s/def :cognitect.aws.discovery/ContinuousExportStatus string?)

(s/def
  :cognitect.aws.discovery/StartExportTaskResponse
  (s/keys :opt-un [:cognitect.aws.discovery.StartExportTaskResponse/exportId]))

(s/def
  :cognitect.aws.discovery/ListConfigurationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.discovery.ListConfigurationsRequest/configurationType]
    :opt-un
    [:cognitect.aws.discovery.ListConfigurationsRequest/filters
     :cognitect.aws.discovery.ListConfigurationsRequest/maxResults
     :cognitect.aws.discovery.ListConfigurationsRequest/nextToken
     :cognitect.aws.discovery.ListConfigurationsRequest/orderBy]))

(s/def :cognitect.aws.discovery/ApplicationId string?)

(s/def :cognitect.aws.discovery/ExportDataFormat string?)

(s/def :cognitect.aws.discovery/FilterName string?)

(s/def
  :cognitect.aws.discovery/StringMax255
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.discovery/ConfigurationItemType string?)

(s/def
  :cognitect.aws.discovery/DescribeAgentsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeAgentsResponse/nextToken
     :cognitect.aws.discovery.DescribeAgentsResponse/agentsInfo]))

(s/def
  :cognitect.aws.discovery/StartExportTaskRequest
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.StartExportTaskRequest/exportDataFormat
     :cognitect.aws.discovery.StartExportTaskRequest/filters
     :cognitect.aws.discovery.StartExportTaskRequest/startTime
     :cognitect.aws.discovery.StartExportTaskRequest/endTime]))

(s/def
  :cognitect.aws.discovery/CustomerConnectorInfo
  (s/keys
    :req-un
    [:cognitect.aws.discovery.CustomerConnectorInfo/activeConnectors
     :cognitect.aws.discovery.CustomerConnectorInfo/healthyConnectors
     :cognitect.aws.discovery.CustomerConnectorInfo/blackListedConnectors
     :cognitect.aws.discovery.CustomerConnectorInfo/shutdownConnectors
     :cognitect.aws.discovery.CustomerConnectorInfo/unhealthyConnectors
     :cognitect.aws.discovery.CustomerConnectorInfo/totalConnectors
     :cognitect.aws.discovery.CustomerConnectorInfo/unknownConnectors]))

(s/def :cognitect.aws.discovery/Condition string?)

(s/def :cognitect.aws.discovery/Filters (s/coll-of :cognitect.aws.discovery/Filter))

(s/def
  :cognitect.aws.discovery/AgentConfigurationStatus
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.AgentConfigurationStatus/agentId
     :cognitect.aws.discovery.AgentConfigurationStatus/operationSucceeded
     :cognitect.aws.discovery.AgentConfigurationStatus/description]))

(s/def
  :cognitect.aws.discovery/StartDataCollectionByAgentIdsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.StartDataCollectionByAgentIdsResponse/agentsConfigurationStatus]))

(s/def
  :cognitect.aws.discovery/BatchDeleteImportDataErrorList
  (s/coll-of :cognitect.aws.discovery/BatchDeleteImportDataError))

(s/def
  :cognitect.aws.discovery/DescribeImportTasksMaxResults
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.discovery/Configuration
  (s/map-of :cognitect.aws.discovery/String :cognitect.aws.discovery/String))

(s/def :cognitect.aws.discovery/DataSource string?)

(s/def
  :cognitect.aws.discovery/DescribeConfigurationsRequest
  (s/keys :req-un [:cognitect.aws.discovery.DescribeConfigurationsRequest/configurationIds]))

(s/def :cognitect.aws.discovery/ImportTaskList (s/coll-of :cognitect.aws.discovery/ImportTask))

(s/def
  :cognitect.aws.discovery/DescribeTagsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeTagsResponse/tags
     :cognitect.aws.discovery.DescribeTagsResponse/nextToken]))

(s/def
  :cognitect.aws.discovery/DescribeContinuousExportsMaxResults
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def :cognitect.aws.discovery/FilterValue string?)

(s/def
  :cognitect.aws.discovery/DescribeImportTasksFilterList
  (s/coll-of :cognitect.aws.discovery/ImportTaskFilter))

(s/def
  :cognitect.aws.discovery/DatabaseName
  (s/spec
    (s/and string? #(<= 1 (count %) 252))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 252) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.discovery/AgentsInfo (s/coll-of :cognitect.aws.discovery/AgentInfo))

(s/def :cognitect.aws.discovery/BatchDeleteImportDataErrorDescription string?)

(s/def
  :cognitect.aws.discovery/BoxedInteger
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.discovery/DescribeTagsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeTagsRequest/filters
     :cognitect.aws.discovery.DescribeTagsRequest/maxResults
     :cognitect.aws.discovery.DescribeTagsRequest/nextToken]))

(s/def :cognitect.aws.discovery/CreateTagsResponse (s/keys))

(s/def
  :cognitect.aws.discovery/SchemaStorageConfig
  (s/map-of :cognitect.aws.discovery/DatabaseName :cognitect.aws.discovery/String))

(s/def
  :cognitect.aws.discovery/StopDataCollectionByAgentIdsRequest
  (s/keys :req-un [:cognitect.aws.discovery.StopDataCollectionByAgentIdsRequest/agentIds]))

(s/def :cognitect.aws.discovery/ConfigurationsDownloadUrl string?)

(s/def :cognitect.aws.discovery/DisassociateConfigurationItemsFromApplicationResponse (s/keys))

(s/def
  :cognitect.aws.discovery/ExportDataFormats
  (s/coll-of :cognitect.aws.discovery/ExportDataFormat))

(s/def
  :cognitect.aws.discovery/ToDeleteIdentifierList
  (s/coll-of :cognitect.aws.discovery/ImportTaskIdentifier :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.discovery/DescribeExportConfigurationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.DescribeExportConfigurationsRequest/maxResults
     :cognitect.aws.discovery.DescribeExportConfigurationsRequest/nextToken
     :cognitect.aws.discovery.DescribeExportConfigurationsRequest/exportIds]))

(s/def :cognitect.aws.discovery/String string?)

(s/def
  :cognitect.aws.discovery/ContinuousExportDescription
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.ContinuousExportDescription/exportId
     :cognitect.aws.discovery.ContinuousExportDescription/s3Bucket
     :cognitect.aws.discovery.ContinuousExportDescription/schemaStorageConfig
     :cognitect.aws.discovery.ContinuousExportDescription/statusDetail
     :cognitect.aws.discovery.ContinuousExportDescription/startTime
     :cognitect.aws.discovery.ContinuousExportDescription/status
     :cognitect.aws.discovery.ContinuousExportDescription/stopTime
     :cognitect.aws.discovery.ContinuousExportDescription/dataSource]))

(s/def
  :cognitect.aws.discovery/DescribeConfigurationsAttributes
  (s/coll-of :cognitect.aws.discovery/DescribeConfigurationsAttribute))

(s/def
  :cognitect.aws.discovery/ImportTaskFilter
  (s/keys
    :opt-un
    [:cognitect.aws.discovery.ImportTaskFilter/values
     :cognitect.aws.discovery.ImportTaskFilter/name]))

(s/def :cognitect.aws.discovery/AgentStatus string?)

(s/def :cognitect.aws.discovery/OrderByList (s/coll-of :cognitect.aws.discovery/OrderByElement))

(s/def
  :cognitect.aws.discovery.ListServerNeighborsResponse/neighbors
  :cognitect.aws.discovery/NeighborDetailsList)

(s/def
  :cognitect.aws.discovery.ListServerNeighborsResponse/nextToken
  :cognitect.aws.discovery/String)

(s/def
  :cognitect.aws.discovery.ListServerNeighborsResponse/knownDependencyCount
  :cognitect.aws.discovery/Long)

(s/def :cognitect.aws.discovery.TagFilter/name :cognitect.aws.discovery/FilterName)

(s/def :cognitect.aws.discovery.TagFilter/values :cognitect.aws.discovery/FilterValues)

(s/def
  :cognitect.aws.discovery.DisassociateConfigurationItemsFromApplicationRequest/applicationConfigurationId
  :cognitect.aws.discovery/ApplicationId)

(s/def
  :cognitect.aws.discovery.DisassociateConfigurationItemsFromApplicationRequest/configurationIds
  :cognitect.aws.discovery/ConfigurationIdList)

(s/def
  :cognitect.aws.discovery.DescribeExportConfigurationsResponse/exportsInfo
  :cognitect.aws.discovery/ExportsInfo)

(s/def
  :cognitect.aws.discovery.DescribeExportConfigurationsResponse/nextToken
  :cognitect.aws.discovery/NextToken)

(s/def :cognitect.aws.discovery.Tag/key :cognitect.aws.discovery/TagKey)

(s/def :cognitect.aws.discovery.Tag/value :cognitect.aws.discovery/TagValue)

(s/def
  :cognitect.aws.discovery.DeleteTagsRequest/configurationIds
  :cognitect.aws.discovery/ConfigurationIdList)

(s/def :cognitect.aws.discovery.DeleteTagsRequest/tags :cognitect.aws.discovery/TagSet)

(s/def
  :cognitect.aws.discovery.StartImportTaskRequest/clientRequestToken
  :cognitect.aws.discovery/ClientRequestToken)

(s/def :cognitect.aws.discovery.StartImportTaskRequest/name :cognitect.aws.discovery/ImportTaskName)

(s/def :cognitect.aws.discovery.StartImportTaskRequest/importUrl :cognitect.aws.discovery/ImportURL)

(s/def
  :cognitect.aws.discovery.StopContinuousExportRequest/exportId
  :cognitect.aws.discovery/ConfigurationsExportId)

(s/def :cognitect.aws.discovery.ImportTask/serverImportFailure :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.ImportTask/errorsAndFailedEntriesZip
  :cognitect.aws.discovery/S3PresignedUrl)

(s/def :cognitect.aws.discovery.ImportTask/importCompletionTime :cognitect.aws.discovery/TimeStamp)

(s/def :cognitect.aws.discovery.ImportTask/name :cognitect.aws.discovery/ImportTaskName)

(s/def :cognitect.aws.discovery.ImportTask/importUrl :cognitect.aws.discovery/ImportURL)

(s/def
  :cognitect.aws.discovery.ImportTask/importTaskId
  :cognitect.aws.discovery/ImportTaskIdentifier)

(s/def :cognitect.aws.discovery.ImportTask/serverImportSuccess :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.ImportTask/applicationImportSuccess
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.ImportTask/clientRequestToken
  :cognitect.aws.discovery/ClientRequestToken)

(s/def :cognitect.aws.discovery.ImportTask/status :cognitect.aws.discovery/ImportStatus)

(s/def :cognitect.aws.discovery.ImportTask/importRequestTime :cognitect.aws.discovery/TimeStamp)

(s/def
  :cognitect.aws.discovery.ImportTask/applicationImportFailure
  :cognitect.aws.discovery/Integer)

(s/def :cognitect.aws.discovery.ImportTask/importDeletedTime :cognitect.aws.discovery/TimeStamp)

(s/def :cognitect.aws.discovery.Filter/name :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.Filter/values :cognitect.aws.discovery/FilterValues)

(s/def :cognitect.aws.discovery.Filter/condition :cognitect.aws.discovery/Condition)

(s/def
  :cognitect.aws.discovery.DescribeExportTasksRequest/exportIds
  :cognitect.aws.discovery/ExportIds)

(s/def
  :cognitect.aws.discovery.DescribeExportTasksRequest/filters
  :cognitect.aws.discovery/ExportFilters)

(s/def
  :cognitect.aws.discovery.DescribeExportTasksRequest/maxResults
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.DescribeExportTasksRequest/nextToken
  :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.AssociateConfigurationItemsToApplicationRequest/applicationConfigurationId
  :cognitect.aws.discovery/ApplicationId)

(s/def
  :cognitect.aws.discovery.AssociateConfigurationItemsToApplicationRequest/configurationIds
  :cognitect.aws.discovery/ConfigurationIdList)

(s/def :cognitect.aws.discovery.CustomerAgentInfo/activeAgents :cognitect.aws.discovery/Integer)

(s/def :cognitect.aws.discovery.CustomerAgentInfo/healthyAgents :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.CustomerAgentInfo/blackListedAgents
  :cognitect.aws.discovery/Integer)

(s/def :cognitect.aws.discovery.CustomerAgentInfo/shutdownAgents :cognitect.aws.discovery/Integer)

(s/def :cognitect.aws.discovery.CustomerAgentInfo/unhealthyAgents :cognitect.aws.discovery/Integer)

(s/def :cognitect.aws.discovery.CustomerAgentInfo/totalAgents :cognitect.aws.discovery/Integer)

(s/def :cognitect.aws.discovery.CustomerAgentInfo/unknownAgents :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.DeleteApplicationsRequest/configurationIds
  :cognitect.aws.discovery/ApplicationIdsList)

(s/def
  :cognitect.aws.discovery.AgentInfo/agentNetworkInfoList
  :cognitect.aws.discovery/AgentNetworkInfoList)

(s/def :cognitect.aws.discovery.AgentInfo/lastHealthPingTime :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.AgentInfo/agentId :cognitect.aws.discovery/AgentId)

(s/def :cognitect.aws.discovery.AgentInfo/registeredTime :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.AgentInfo/hostName :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.AgentInfo/health :cognitect.aws.discovery/AgentStatus)

(s/def :cognitect.aws.discovery.AgentInfo/collectionStatus :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.AgentInfo/version :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.AgentInfo/agentType :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.AgentInfo/connectorId :cognitect.aws.discovery/String)

(s/def
  :cognitect.aws.discovery.ListServerNeighborsRequest/configurationId
  :cognitect.aws.discovery/ConfigurationId)

(s/def
  :cognitect.aws.discovery.ListServerNeighborsRequest/portInformationNeeded
  :cognitect.aws.discovery/Boolean)

(s/def
  :cognitect.aws.discovery.ListServerNeighborsRequest/neighborConfigurationIds
  :cognitect.aws.discovery/ConfigurationIdList)

(s/def
  :cognitect.aws.discovery.ListServerNeighborsRequest/maxResults
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.ListServerNeighborsRequest/nextToken
  :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.ExportFilter/name :cognitect.aws.discovery/FilterName)

(s/def :cognitect.aws.discovery.ExportFilter/values :cognitect.aws.discovery/FilterValues)

(s/def :cognitect.aws.discovery.ExportFilter/condition :cognitect.aws.discovery/Condition)

(s/def
  :cognitect.aws.discovery.CreateApplicationResponse/configurationId
  :cognitect.aws.discovery/String)

(s/def
  :cognitect.aws.discovery.ListConfigurationsResponse/configurations
  :cognitect.aws.discovery/Configurations)

(s/def
  :cognitect.aws.discovery.ListConfigurationsResponse/nextToken
  :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.StopDataCollectionByAgentIdsResponse/agentsConfigurationStatus
  :cognitect.aws.discovery/AgentConfigurationStatusList)

(s/def :cognitect.aws.discovery.GetDiscoverySummaryResponse/servers :cognitect.aws.discovery/Long)

(s/def
  :cognitect.aws.discovery.GetDiscoverySummaryResponse/applications
  :cognitect.aws.discovery/Long)

(s/def
  :cognitect.aws.discovery.GetDiscoverySummaryResponse/serversMappedToApplications
  :cognitect.aws.discovery/Long)

(s/def
  :cognitect.aws.discovery.GetDiscoverySummaryResponse/serversMappedtoTags
  :cognitect.aws.discovery/Long)

(s/def
  :cognitect.aws.discovery.GetDiscoverySummaryResponse/agentSummary
  :cognitect.aws.discovery/CustomerAgentInfo)

(s/def
  :cognitect.aws.discovery.GetDiscoverySummaryResponse/connectorSummary
  :cognitect.aws.discovery/CustomerConnectorInfo)

(s/def :cognitect.aws.discovery.AgentNetworkInfo/ipAddress :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.AgentNetworkInfo/macAddress :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.ExportInfo/exportId :cognitect.aws.discovery/ConfigurationsExportId)

(s/def :cognitect.aws.discovery.ExportInfo/exportStatus :cognitect.aws.discovery/ExportStatus)

(s/def
  :cognitect.aws.discovery.ExportInfo/statusMessage
  :cognitect.aws.discovery/ExportStatusMessage)

(s/def
  :cognitect.aws.discovery.ExportInfo/configurationsDownloadUrl
  :cognitect.aws.discovery/ConfigurationsDownloadUrl)

(s/def
  :cognitect.aws.discovery.ExportInfo/exportRequestTime
  :cognitect.aws.discovery/ExportRequestTime)

(s/def :cognitect.aws.discovery.ExportInfo/isTruncated :cognitect.aws.discovery/Boolean)

(s/def :cognitect.aws.discovery.ExportInfo/requestedStartTime :cognitect.aws.discovery/TimeStamp)

(s/def :cognitect.aws.discovery.ExportInfo/requestedEndTime :cognitect.aws.discovery/TimeStamp)

(s/def
  :cognitect.aws.discovery.DescribeContinuousExportsResponse/descriptions
  :cognitect.aws.discovery/ContinuousExportDescriptions)

(s/def
  :cognitect.aws.discovery.DescribeContinuousExportsResponse/nextToken
  :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.StopContinuousExportResponse/startTime
  :cognitect.aws.discovery/TimeStamp)

(s/def
  :cognitect.aws.discovery.StopContinuousExportResponse/stopTime
  :cognitect.aws.discovery/TimeStamp)

(s/def :cognitect.aws.discovery.OrderByElement/fieldName :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.OrderByElement/sortOrder :cognitect.aws.discovery/orderString)

(s/def
  :cognitect.aws.discovery.BatchDeleteImportDataResponse/errors
  :cognitect.aws.discovery/BatchDeleteImportDataErrorList)

(s/def :cognitect.aws.discovery.StartImportTaskResponse/task :cognitect.aws.discovery/ImportTask)

(s/def
  :cognitect.aws.discovery.StartContinuousExportResponse/exportId
  :cognitect.aws.discovery/ConfigurationsExportId)

(s/def
  :cognitect.aws.discovery.StartContinuousExportResponse/s3Bucket
  :cognitect.aws.discovery/S3Bucket)

(s/def
  :cognitect.aws.discovery.StartContinuousExportResponse/startTime
  :cognitect.aws.discovery/TimeStamp)

(s/def
  :cognitect.aws.discovery.StartContinuousExportResponse/dataSource
  :cognitect.aws.discovery/DataSource)

(s/def
  :cognitect.aws.discovery.StartContinuousExportResponse/schemaStorageConfig
  :cognitect.aws.discovery/SchemaStorageConfig)

(s/def
  :cognitect.aws.discovery.DescribeImportTasksResponse/nextToken
  :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.DescribeImportTasksResponse/tasks
  :cognitect.aws.discovery/ImportTaskList)

(s/def
  :cognitect.aws.discovery.ConfigurationTag/configurationType
  :cognitect.aws.discovery/ConfigurationItemType)

(s/def
  :cognitect.aws.discovery.ConfigurationTag/configurationId
  :cognitect.aws.discovery/ConfigurationId)

(s/def :cognitect.aws.discovery.ConfigurationTag/key :cognitect.aws.discovery/TagKey)

(s/def :cognitect.aws.discovery.ConfigurationTag/value :cognitect.aws.discovery/TagValue)

(s/def :cognitect.aws.discovery.ConfigurationTag/timeOfCreation :cognitect.aws.discovery/TimeStamp)

(s/def
  :cognitect.aws.discovery.DescribeExportTasksResponse/exportsInfo
  :cognitect.aws.discovery/ExportsInfo)

(s/def
  :cognitect.aws.discovery.DescribeExportTasksResponse/nextToken
  :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.BatchDeleteImportDataRequest/importTaskIds
  :cognitect.aws.discovery/ToDeleteIdentifierList)

(s/def
  :cognitect.aws.discovery.DescribeImportTasksRequest/filters
  :cognitect.aws.discovery/DescribeImportTasksFilterList)

(s/def
  :cognitect.aws.discovery.DescribeImportTasksRequest/maxResults
  :cognitect.aws.discovery/DescribeImportTasksMaxResults)

(s/def
  :cognitect.aws.discovery.DescribeImportTasksRequest/nextToken
  :cognitect.aws.discovery/NextToken)

(s/def :cognitect.aws.discovery.DescribeAgentsRequest/agentIds :cognitect.aws.discovery/AgentIds)

(s/def :cognitect.aws.discovery.DescribeAgentsRequest/filters :cognitect.aws.discovery/Filters)

(s/def :cognitect.aws.discovery.DescribeAgentsRequest/maxResults :cognitect.aws.discovery/Integer)

(s/def :cognitect.aws.discovery.DescribeAgentsRequest/nextToken :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.BatchDeleteImportDataError/importTaskId
  :cognitect.aws.discovery/ImportTaskIdentifier)

(s/def
  :cognitect.aws.discovery.BatchDeleteImportDataError/errorCode
  :cognitect.aws.discovery/BatchDeleteImportDataErrorCode)

(s/def
  :cognitect.aws.discovery.BatchDeleteImportDataError/errorDescription
  :cognitect.aws.discovery/BatchDeleteImportDataErrorDescription)

(s/def
  :cognitect.aws.discovery.NeighborConnectionDetail/sourceServerId
  :cognitect.aws.discovery/ConfigurationId)

(s/def
  :cognitect.aws.discovery.NeighborConnectionDetail/destinationServerId
  :cognitect.aws.discovery/ConfigurationId)

(s/def
  :cognitect.aws.discovery.NeighborConnectionDetail/destinationPort
  :cognitect.aws.discovery/BoxedInteger)

(s/def
  :cognitect.aws.discovery.NeighborConnectionDetail/transportProtocol
  :cognitect.aws.discovery/String)

(s/def
  :cognitect.aws.discovery.NeighborConnectionDetail/connectionsCount
  :cognitect.aws.discovery/Long)

(s/def
  :cognitect.aws.discovery.UpdateApplicationRequest/configurationId
  :cognitect.aws.discovery/ApplicationId)

(s/def :cognitect.aws.discovery.UpdateApplicationRequest/name :cognitect.aws.discovery/String)

(s/def
  :cognitect.aws.discovery.UpdateApplicationRequest/description
  :cognitect.aws.discovery/String)

(s/def :cognitect.aws.discovery.CreateApplicationRequest/name :cognitect.aws.discovery/String)

(s/def
  :cognitect.aws.discovery.CreateApplicationRequest/description
  :cognitect.aws.discovery/String)

(s/def
  :cognitect.aws.discovery.ExportConfigurationsResponse/exportId
  :cognitect.aws.discovery/ConfigurationsExportId)

(s/def
  :cognitect.aws.discovery.StartDataCollectionByAgentIdsRequest/agentIds
  :cognitect.aws.discovery/AgentIds)

(s/def
  :cognitect.aws.discovery.CreateTagsRequest/configurationIds
  :cognitect.aws.discovery/ConfigurationIdList)

(s/def :cognitect.aws.discovery.CreateTagsRequest/tags :cognitect.aws.discovery/TagSet)

(s/def
  :cognitect.aws.discovery.DescribeConfigurationsResponse/configurations
  :cognitect.aws.discovery/DescribeConfigurationsAttributes)

(s/def
  :cognitect.aws.discovery.DescribeContinuousExportsRequest/exportIds
  :cognitect.aws.discovery/ContinuousExportIds)

(s/def
  :cognitect.aws.discovery.DescribeContinuousExportsRequest/maxResults
  :cognitect.aws.discovery/DescribeContinuousExportsMaxResults)

(s/def
  :cognitect.aws.discovery.DescribeContinuousExportsRequest/nextToken
  :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.StartExportTaskResponse/exportId
  :cognitect.aws.discovery/ConfigurationsExportId)

(s/def
  :cognitect.aws.discovery.ListConfigurationsRequest/configurationType
  :cognitect.aws.discovery/ConfigurationItemType)

(s/def :cognitect.aws.discovery.ListConfigurationsRequest/filters :cognitect.aws.discovery/Filters)

(s/def
  :cognitect.aws.discovery.ListConfigurationsRequest/maxResults
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.ListConfigurationsRequest/nextToken
  :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.ListConfigurationsRequest/orderBy
  :cognitect.aws.discovery/OrderByList)

(s/def
  :cognitect.aws.discovery.DescribeAgentsResponse/agentsInfo
  :cognitect.aws.discovery/AgentsInfo)

(s/def :cognitect.aws.discovery.DescribeAgentsResponse/nextToken :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.StartExportTaskRequest/exportDataFormat
  :cognitect.aws.discovery/ExportDataFormats)

(s/def
  :cognitect.aws.discovery.StartExportTaskRequest/filters
  :cognitect.aws.discovery/ExportFilters)

(s/def :cognitect.aws.discovery.StartExportTaskRequest/startTime :cognitect.aws.discovery/TimeStamp)

(s/def :cognitect.aws.discovery.StartExportTaskRequest/endTime :cognitect.aws.discovery/TimeStamp)

(s/def
  :cognitect.aws.discovery.CustomerConnectorInfo/activeConnectors
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.CustomerConnectorInfo/healthyConnectors
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.CustomerConnectorInfo/blackListedConnectors
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.CustomerConnectorInfo/shutdownConnectors
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.CustomerConnectorInfo/unhealthyConnectors
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.CustomerConnectorInfo/totalConnectors
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.CustomerConnectorInfo/unknownConnectors
  :cognitect.aws.discovery/Integer)

(s/def :cognitect.aws.discovery.AgentConfigurationStatus/agentId :cognitect.aws.discovery/String)

(s/def
  :cognitect.aws.discovery.AgentConfigurationStatus/operationSucceeded
  :cognitect.aws.discovery/Boolean)

(s/def
  :cognitect.aws.discovery.AgentConfigurationStatus/description
  :cognitect.aws.discovery/String)

(s/def
  :cognitect.aws.discovery.StartDataCollectionByAgentIdsResponse/agentsConfigurationStatus
  :cognitect.aws.discovery/AgentConfigurationStatusList)

(s/def
  :cognitect.aws.discovery.DescribeConfigurationsRequest/configurationIds
  :cognitect.aws.discovery/ConfigurationIdList)

(s/def
  :cognitect.aws.discovery.DescribeTagsResponse/tags
  :cognitect.aws.discovery/ConfigurationTagSet)

(s/def :cognitect.aws.discovery.DescribeTagsResponse/nextToken :cognitect.aws.discovery/NextToken)

(s/def :cognitect.aws.discovery.DescribeTagsRequest/filters :cognitect.aws.discovery/TagFilters)

(s/def :cognitect.aws.discovery.DescribeTagsRequest/maxResults :cognitect.aws.discovery/Integer)

(s/def :cognitect.aws.discovery.DescribeTagsRequest/nextToken :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.StopDataCollectionByAgentIdsRequest/agentIds
  :cognitect.aws.discovery/AgentIds)

(s/def
  :cognitect.aws.discovery.DescribeExportConfigurationsRequest/exportIds
  :cognitect.aws.discovery/ExportIds)

(s/def
  :cognitect.aws.discovery.DescribeExportConfigurationsRequest/maxResults
  :cognitect.aws.discovery/Integer)

(s/def
  :cognitect.aws.discovery.DescribeExportConfigurationsRequest/nextToken
  :cognitect.aws.discovery/NextToken)

(s/def
  :cognitect.aws.discovery.ContinuousExportDescription/exportId
  :cognitect.aws.discovery/ConfigurationsExportId)

(s/def
  :cognitect.aws.discovery.ContinuousExportDescription/status
  :cognitect.aws.discovery/ContinuousExportStatus)

(s/def
  :cognitect.aws.discovery.ContinuousExportDescription/statusDetail
  :cognitect.aws.discovery/StringMax255)

(s/def
  :cognitect.aws.discovery.ContinuousExportDescription/s3Bucket
  :cognitect.aws.discovery/S3Bucket)

(s/def
  :cognitect.aws.discovery.ContinuousExportDescription/startTime
  :cognitect.aws.discovery/TimeStamp)

(s/def
  :cognitect.aws.discovery.ContinuousExportDescription/stopTime
  :cognitect.aws.discovery/TimeStamp)

(s/def
  :cognitect.aws.discovery.ContinuousExportDescription/dataSource
  :cognitect.aws.discovery/DataSource)

(s/def
  :cognitect.aws.discovery.ContinuousExportDescription/schemaStorageConfig
  :cognitect.aws.discovery/SchemaStorageConfig)

(s/def :cognitect.aws.discovery.ImportTaskFilter/name :cognitect.aws.discovery/ImportTaskFilterName)

(s/def
  :cognitect.aws.discovery.ImportTaskFilter/values
  :cognitect.aws.discovery/ImportTaskFilterValueList)

