;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.es.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.es/StartElasticsearchServiceSoftwareUpdateRequest
  (s/keys :req-un [:cognitect.aws.es.StartElasticsearchServiceSoftwareUpdateRequest/DomainName]))

(s/def
  :cognitect.aws.es/AccessPoliciesStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.AccessPoliciesStatus/Options :cognitect.aws.es.AccessPoliciesStatus/Status]))

(s/def :cognitect.aws.es/ListTagsRequest (s/keys :req-un [:cognitect.aws.es.ListTagsRequest/ARN]))

(s/def :cognitect.aws.es/LogType string?)

(s/def :cognitect.aws.es/LimitValueList (s/coll-of :cognitect.aws.es/LimitValue))

(s/def :cognitect.aws.es/UpdateTimestamp inst?)

(s/def
  :cognitect.aws.es/InstanceCountLimits
  (s/keys
    :opt-un
    [:cognitect.aws.es.InstanceCountLimits/MaximumInstanceCount
     :cognitect.aws.es.InstanceCountLimits/MinimumInstanceCount]))

(s/def
  :cognitect.aws.es/Tag
  (s/keys :req-un [:cognitect.aws.es.Tag/Key :cognitect.aws.es.Tag/Value]))

(s/def :cognitect.aws.es/DomainNameList (s/coll-of :cognitect.aws.es/DomainName))

(s/def
  :cognitect.aws.es/LogPublishingOptionsStatus
  (s/keys
    :opt-un
    [:cognitect.aws.es.LogPublishingOptionsStatus/Status
     :cognitect.aws.es.LogPublishingOptionsStatus/Options]))

(s/def
  :cognitect.aws.es/EncryptionAtRestOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.EncryptionAtRestOptionsStatus/Options
     :cognitect.aws.es.EncryptionAtRestOptionsStatus/Status]))

(s/def :cognitect.aws.es/StorageTypeList (s/coll-of :cognitect.aws.es/StorageType))

(s/def
  :cognitect.aws.es/ElasticsearchDomainStatusList
  (s/coll-of :cognitect.aws.es/ElasticsearchDomainStatus))

(s/def
  :cognitect.aws.es/ZoneAwarenessConfig
  (s/keys :opt-un [:cognitect.aws.es.ZoneAwarenessConfig/AvailabilityZoneCount]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainResponse
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainResponse/DomainStatus]))

(s/def
  :cognitect.aws.es/UpgradeElasticsearchDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.UpgradeElasticsearchDomainRequest/DomainName
     :cognitect.aws.es.UpgradeElasticsearchDomainRequest/TargetVersion]
    :opt-un
    [:cognitect.aws.es.UpgradeElasticsearchDomainRequest/PerformCheckOnly]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainsResponse
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainsResponse/DomainStatusList]))

(s/def
  :cognitect.aws.es/RemoveTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.RemoveTagsRequest/ARN :cognitect.aws.es.RemoveTagsRequest/TagKeys]))

(s/def
  :cognitect.aws.es/EBSOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.EBSOptionsStatus/Options :cognitect.aws.es.EBSOptionsStatus/Status]))

(s/def
  :cognitect.aws.es/ElasticsearchDomainConfig
  (s/keys
    :opt-un
    [:cognitect.aws.es.ElasticsearchDomainConfig/SnapshotOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/EBSOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/ElasticsearchVersion
     :cognitect.aws.es.ElasticsearchDomainConfig/NodeToNodeEncryptionOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/AccessPolicies
     :cognitect.aws.es.ElasticsearchDomainConfig/CognitoOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/ElasticsearchClusterConfig
     :cognitect.aws.es.ElasticsearchDomainConfig/AdvancedOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/LogPublishingOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/EncryptionAtRestOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/VPCOptions]))

(s/def
  :cognitect.aws.es/IdentityPoolId
  (s/with-gen #(re-matches (re-pattern "[\\w-]+:[0-9a-f-]+") %) #(gen/string)))

(s/def
  :cognitect.aws.es/NodeToNodeEncryptionOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.NodeToNodeEncryptionOptionsStatus/Options
     :cognitect.aws.es.NodeToNodeEncryptionOptionsStatus/Status]))

(s/def
  :cognitect.aws.es/ElasticsearchVersionList
  (s/coll-of :cognitect.aws.es/ElasticsearchVersionString))

(s/def
  :cognitect.aws.es/ReservedElasticsearchInstanceOfferingList
  (s/coll-of :cognitect.aws.es/ReservedElasticsearchInstanceOffering))

(s/def :cognitect.aws.es/DeploymentStatus string?)

(s/def
  :cognitect.aws.es/ListElasticsearchVersionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.es.ListElasticsearchVersionsRequest/NextToken
     :cognitect.aws.es.ListElasticsearchVersionsRequest/MaxResults]))

(s/def
  :cognitect.aws.es/StartElasticsearchServiceSoftwareUpdateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.StartElasticsearchServiceSoftwareUpdateResponse/ServiceSoftwareOptions]))

(s/def :cognitect.aws.es/StorageSubTypeName string?)

(s/def :cognitect.aws.es/TagList (s/coll-of :cognitect.aws.es/Tag))

(s/def :cognitect.aws.es/InstanceRole string?)

(s/def :cognitect.aws.es/ElasticsearchVersionString string?)

(s/def
  :cognitect.aws.es/DomainName
  (s/with-gen #(re-matches (re-pattern "[a-z][a-z0-9\\-]+") %) #(gen/string)))

(s/def
  :cognitect.aws.es/PurchaseReservedElasticsearchInstanceOfferingRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/ReservedElasticsearchInstanceOfferingId
     :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/ReservationName]
    :opt-un
    [:cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/InstanceCount]))

(s/def
  :cognitect.aws.es/DomainId
  (s/with-gen
    (s/and string? #(<= 1 (count %) 64))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 64 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/CompatibleVersionsMap
  (s/keys
    :opt-un
    [:cognitect.aws.es.CompatibleVersionsMap/TargetVersions
     :cognitect.aws.es.CompatibleVersionsMap/SourceVersion]))

(s/def
  :cognitect.aws.es/ElasticsearchVersionStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.ElasticsearchVersionStatus/Options
     :cognitect.aws.es.ElasticsearchVersionStatus/Status]))

(s/def
  :cognitect.aws.es/ElasticsearchClusterConfig
  (s/keys
    :opt-un
    [:cognitect.aws.es.ElasticsearchClusterConfig/InstanceCount
     :cognitect.aws.es.ElasticsearchClusterConfig/InstanceType
     :cognitect.aws.es.ElasticsearchClusterConfig/ZoneAwarenessEnabled
     :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterCount
     :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterEnabled
     :cognitect.aws.es.ElasticsearchClusterConfig/ZoneAwarenessConfig
     :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterType]))

(s/def
  :cognitect.aws.es/AdvancedOptions
  (s/map-of :cognitect.aws.es/String :cognitect.aws.es/String))

(s/def
  :cognitect.aws.es/ElasticsearchInstanceTypeList
  (s/coll-of :cognitect.aws.es/ESPartitionInstanceType))

(s/def
  :cognitect.aws.es/UpgradeElasticsearchDomainResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.UpgradeElasticsearchDomainResponse/TargetVersion
     :cognitect.aws.es.UpgradeElasticsearchDomainResponse/DomainName
     :cognitect.aws.es.UpgradeElasticsearchDomainResponse/PerformCheckOnly]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainsRequest
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainsRequest/DomainNames]))

(s/def :cognitect.aws.es/UpgradeStatus string?)

(s/def
  :cognitect.aws.es/GetCompatibleElasticsearchVersionsRequest
  (s/keys :opt-un [:cognitect.aws.es.GetCompatibleElasticsearchVersionsRequest/DomainName]))

(s/def
  :cognitect.aws.es/ListElasticsearchInstanceTypesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.ListElasticsearchInstanceTypesResponse/ElasticsearchInstanceTypes
     :cognitect.aws.es.ListElasticsearchInstanceTypesResponse/NextToken]))

(s/def
  :cognitect.aws.es/AdvancedOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.AdvancedOptionsStatus/Options
     :cognitect.aws.es.AdvancedOptionsStatus/Status]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainConfigRequest
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainConfigRequest/DomainName]))

(s/def
  :cognitect.aws.es/ElasticsearchDomainStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.ElasticsearchDomainStatus/DomainId
     :cognitect.aws.es.ElasticsearchDomainStatus/DomainName
     :cognitect.aws.es.ElasticsearchDomainStatus/ARN
     :cognitect.aws.es.ElasticsearchDomainStatus/ElasticsearchClusterConfig]
    :opt-un
    [:cognitect.aws.es.ElasticsearchDomainStatus/SnapshotOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/EBSOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/Created
     :cognitect.aws.es.ElasticsearchDomainStatus/ElasticsearchVersion
     :cognitect.aws.es.ElasticsearchDomainStatus/NodeToNodeEncryptionOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/AccessPolicies
     :cognitect.aws.es.ElasticsearchDomainStatus/Endpoints
     :cognitect.aws.es.ElasticsearchDomainStatus/CognitoOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/Deleted
     :cognitect.aws.es.ElasticsearchDomainStatus/UpgradeProcessing
     :cognitect.aws.es.ElasticsearchDomainStatus/AdvancedOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/Processing
     :cognitect.aws.es.ElasticsearchDomainStatus/LogPublishingOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/EncryptionAtRestOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/Endpoint
     :cognitect.aws.es.ElasticsearchDomainStatus/ServiceSoftwareOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/VPCOptions]))

(s/def
  :cognitect.aws.es/UpdateElasticsearchDomainConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/DomainName]
    :opt-un
    [:cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/SnapshotOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/EBSOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/AccessPolicies
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/CognitoOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/ElasticsearchClusterConfig
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/AdvancedOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/LogPublishingOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/VPCOptions]))

(s/def
  :cognitect.aws.es/ElasticsearchClusterConfigStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.ElasticsearchClusterConfigStatus/Options
     :cognitect.aws.es.ElasticsearchClusterConfigStatus/Status]))

(s/def
  :cognitect.aws.es/ListElasticsearchInstanceTypesRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.ListElasticsearchInstanceTypesRequest/ElasticsearchVersion]
    :opt-un
    [:cognitect.aws.es.ListElasticsearchInstanceTypesRequest/NextToken
     :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/MaxResults
     :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/DomainName]))

(s/def
  :cognitect.aws.es/EBSOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.EBSOptions/Iops
     :cognitect.aws.es.EBSOptions/VolumeType
     :cognitect.aws.es.EBSOptions/VolumeSize
     :cognitect.aws.es.EBSOptions/EBSEnabled]))

(s/def :cognitect.aws.es/DeploymentCloseDateTimeStamp inst?)

(s/def :cognitect.aws.es/VolumeType string?)

(s/def :cognitect.aws.es/Boolean boolean?)

(s/def
  :cognitect.aws.es/AddTagsRequest
  (s/keys :req-un [:cognitect.aws.es.AddTagsRequest/ARN :cognitect.aws.es.AddTagsRequest/TagList]))

(s/def
  :cognitect.aws.es/CreateElasticsearchDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.CreateElasticsearchDomainRequest/DomainName]
    :opt-un
    [:cognitect.aws.es.CreateElasticsearchDomainRequest/SnapshotOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/EBSOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/ElasticsearchVersion
     :cognitect.aws.es.CreateElasticsearchDomainRequest/NodeToNodeEncryptionOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/AccessPolicies
     :cognitect.aws.es.CreateElasticsearchDomainRequest/CognitoOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/ElasticsearchClusterConfig
     :cognitect.aws.es.CreateElasticsearchDomainRequest/AdvancedOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/LogPublishingOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/EncryptionAtRestOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/VPCOptions]))

(s/def
  :cognitect.aws.es/CompatibleElasticsearchVersionsList
  (s/coll-of :cognitect.aws.es/CompatibleVersionsMap))

(s/def
  :cognitect.aws.es/DescribeReservedElasticsearchInstancesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribeReservedElasticsearchInstancesResponse/NextToken
     :cognitect.aws.es.DescribeReservedElasticsearchInstancesResponse/ReservedElasticsearchInstances]))

(s/def
  :cognitect.aws.es/DeleteElasticsearchDomainRequest
  (s/keys :req-un [:cognitect.aws.es.DeleteElasticsearchDomainRequest/DomainName]))

(s/def
  :cognitect.aws.es/ListDomainNamesResponse
  (s/keys :opt-un [:cognitect.aws.es.ListDomainNamesResponse/DomainNames]))

(s/def
  :cognitect.aws.es/CancelElasticsearchServiceSoftwareUpdateRequest
  (s/keys :req-un [:cognitect.aws.es.CancelElasticsearchServiceSoftwareUpdateRequest/DomainName]))

(s/def :cognitect.aws.es/StorageTypeName string?)

(s/def
  :cognitect.aws.es/NodeToNodeEncryptionOptions
  (s/keys :opt-un [:cognitect.aws.es.NodeToNodeEncryptionOptions/Enabled]))

(s/def
  :cognitect.aws.es/DescribeReservedElasticsearchInstancesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/NextToken
     :cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/ReservedElasticsearchInstanceId
     :cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/MaxResults]))

(s/def :cognitect.aws.es/NextToken string?)

(s/def
  :cognitect.aws.es/Integer
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.es/GetUpgradeHistoryRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.GetUpgradeHistoryRequest/DomainName]
    :opt-un
    [:cognitect.aws.es.GetUpgradeHistoryRequest/NextToken
     :cognitect.aws.es.GetUpgradeHistoryRequest/MaxResults]))

(s/def
  :cognitect.aws.es/ListTagsResponse
  (s/keys :opt-un [:cognitect.aws.es.ListTagsResponse/TagList]))

(s/def
  :cognitect.aws.es/LimitsByRole
  (s/map-of :cognitect.aws.es/InstanceRole :cognitect.aws.es/Limits))

(s/def
  :cognitect.aws.es/EndpointsMap
  (s/map-of :cognitect.aws.es/String :cognitect.aws.es/ServiceUrl))

(s/def
  :cognitect.aws.es/TagValue
  (s/with-gen
    (s/and string? #(<= 0 (count %) 256))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 0 0) (or 256 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/VPCDerivedInfo
  (s/keys
    :opt-un
    [:cognitect.aws.es.VPCDerivedInfo/SubnetIds
     :cognitect.aws.es.VPCDerivedInfo/SecurityGroupIds
     :cognitect.aws.es.VPCDerivedInfo/AvailabilityZones
     :cognitect.aws.es.VPCDerivedInfo/VPCId]))

(s/def
  :cognitect.aws.es/UserPoolId
  (s/with-gen #(re-matches (re-pattern "[\\w-]+_[0-9a-zA-Z]+") %) #(gen/string)))

(s/def
  :cognitect.aws.es/UpgradeStepItem
  (s/keys
    :opt-un
    [:cognitect.aws.es.UpgradeStepItem/UpgradeStepStatus
     :cognitect.aws.es.UpgradeStepItem/ProgressPercent
     :cognitect.aws.es.UpgradeStepItem/UpgradeStep
     :cognitect.aws.es.UpgradeStepItem/Issues]))

(s/def :cognitect.aws.es/ReservedElasticsearchInstancePaymentOption string?)

(s/def :cognitect.aws.es/RecurringChargeList (s/coll-of :cognitect.aws.es/RecurringCharge))

(s/def :cognitect.aws.es/UpgradeHistoryList (s/coll-of :cognitect.aws.es/UpgradeHistory))

(s/def
  :cognitect.aws.es/LogPublishingOption
  (s/keys
    :opt-un
    [:cognitect.aws.es.LogPublishingOption/CloudWatchLogsLogGroupArn
     :cognitect.aws.es.LogPublishingOption/Enabled]))

(s/def
  :cognitect.aws.es/GetUpgradeStatusResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.GetUpgradeStatusResponse/UpgradeName
     :cognitect.aws.es.GetUpgradeStatusResponse/StepStatus
     :cognitect.aws.es.GetUpgradeStatusResponse/UpgradeStep]))

(s/def
  :cognitect.aws.es/ReservedElasticsearchInstance
  (s/keys
    :opt-un
    [:cognitect.aws.es.ReservedElasticsearchInstance/ElasticsearchInstanceType
     :cognitect.aws.es.ReservedElasticsearchInstance/CurrencyCode
     :cognitect.aws.es.ReservedElasticsearchInstance/StartTime
     :cognitect.aws.es.ReservedElasticsearchInstance/FixedPrice
     :cognitect.aws.es.ReservedElasticsearchInstance/PaymentOption
     :cognitect.aws.es.ReservedElasticsearchInstance/ReservationName
     :cognitect.aws.es.ReservedElasticsearchInstance/Duration
     :cognitect.aws.es.ReservedElasticsearchInstance/ReservedElasticsearchInstanceId
     :cognitect.aws.es.ReservedElasticsearchInstance/UsagePrice
     :cognitect.aws.es.ReservedElasticsearchInstance/ReservedElasticsearchInstanceOfferingId
     :cognitect.aws.es.ReservedElasticsearchInstance/State
     :cognitect.aws.es.ReservedElasticsearchInstance/RecurringCharges
     :cognitect.aws.es.ReservedElasticsearchInstance/ElasticsearchInstanceCount]))

(s/def
  :cognitect.aws.es/ReservedElasticsearchInstanceOffering
  (s/keys
    :opt-un
    [:cognitect.aws.es.ReservedElasticsearchInstanceOffering/ElasticsearchInstanceType
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/CurrencyCode
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/FixedPrice
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/PaymentOption
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/Duration
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/UsagePrice
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/ReservedElasticsearchInstanceOfferingId
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/RecurringCharges]))

(s/def :cognitect.aws.es/CloudWatchLogsLogGroupArn string?)

(s/def
  :cognitect.aws.es/OptionStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.OptionStatus/CreationDate
     :cognitect.aws.es.OptionStatus/UpdateDate
     :cognitect.aws.es.OptionStatus/State]
    :opt-un
    [:cognitect.aws.es.OptionStatus/PendingDeletion :cognitect.aws.es.OptionStatus/UpdateVersion]))

(s/def
  :cognitect.aws.es/RoleArn
  (s/with-gen
    (s/and string? #(<= 20 (count %) 2048))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 20 0) (or 2048 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/GetUpgradeStatusRequest
  (s/keys :req-un [:cognitect.aws.es.GetUpgradeStatusRequest/DomainName]))

(s/def
  :cognitect.aws.es/StorageTypeLimit
  (s/keys
    :opt-un
    [:cognitect.aws.es.StorageTypeLimit/LimitValues :cognitect.aws.es.StorageTypeLimit/LimitName]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchInstanceTypeLimitsResponse
  (s/keys :opt-un [:cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsResponse/LimitsByRole]))

(s/def
  :cognitect.aws.es/Limits
  (s/keys
    :opt-un
    [:cognitect.aws.es.Limits/AdditionalLimits
     :cognitect.aws.es.Limits/InstanceLimits
     :cognitect.aws.es.Limits/StorageTypes]))

(s/def
  :cognitect.aws.es/ListElasticsearchVersionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.ListElasticsearchVersionsResponse/ElasticsearchVersions
     :cognitect.aws.es.ListElasticsearchVersionsResponse/NextToken]))

(s/def
  :cognitect.aws.es/KmsKeyId
  (s/with-gen
    (s/and string? #(<= 1 (count %) 500))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 500 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/VPCDerivedInfoStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.VPCDerivedInfoStatus/Options :cognitect.aws.es.VPCDerivedInfoStatus/Status]))

(s/def
  :cognitect.aws.es/MinimumInstanceCount
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.es/MaximumInstanceCount
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def :cognitect.aws.es/DomainInfoList (s/coll-of :cognitect.aws.es/DomainInfo))

(s/def
  :cognitect.aws.es/RecurringCharge
  (s/keys
    :opt-un
    [:cognitect.aws.es.RecurringCharge/RecurringChargeFrequency
     :cognitect.aws.es.RecurringCharge/RecurringChargeAmount]))

(s/def
  :cognitect.aws.es/ServiceSoftwareOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.ServiceSoftwareOptions/NewVersion
     :cognitect.aws.es.ServiceSoftwareOptions/UpdateStatus
     :cognitect.aws.es.ServiceSoftwareOptions/Cancellable
     :cognitect.aws.es.ServiceSoftwareOptions/UpdateAvailable
     :cognitect.aws.es.ServiceSoftwareOptions/Description
     :cognitect.aws.es.ServiceSoftwareOptions/AutomatedUpdateDate
     :cognitect.aws.es.ServiceSoftwareOptions/CurrentVersion]))

(s/def
  :cognitect.aws.es/InstanceLimits
  (s/keys :opt-un [:cognitect.aws.es.InstanceLimits/InstanceCountLimits]))

(s/def
  :cognitect.aws.es/EncryptionAtRestOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.EncryptionAtRestOptions/Enabled
     :cognitect.aws.es.EncryptionAtRestOptions/KmsKeyId]))

(s/def :cognitect.aws.es/UpgradeStep string?)

(s/def :cognitect.aws.es/UpgradeStepsList (s/coll-of :cognitect.aws.es/UpgradeStepItem))

(s/def :cognitect.aws.es/ESPartitionInstanceType string?)

(s/def :cognitect.aws.es/LimitValue string?)

(s/def
  :cognitect.aws.es/CognitoOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.CognitoOptionsStatus/Options :cognitect.aws.es.CognitoOptionsStatus/Status]))

(s/def
  :cognitect.aws.es/SnapshotOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.SnapshotOptionsStatus/Options
     :cognitect.aws.es.SnapshotOptionsStatus/Status]))

(s/def :cognitect.aws.es/Issues (s/coll-of :cognitect.aws.es/Issue))

(s/def :cognitect.aws.es/ARN string?)

(s/def :cognitect.aws.es/UpgradeName string?)

(s/def
  :cognitect.aws.es/VPCOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.VPCOptions/SubnetIds :cognitect.aws.es.VPCOptions/SecurityGroupIds]))

(s/def
  :cognitect.aws.es/MaxResults
  (s/with-gen
    (s/and int? #(>= 100 %))
    #(gen/choose (or nil Long/MIN_VALUE) (or 100 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.es/TagKey
  (s/with-gen
    (s/and string? #(<= 1 (count %) 128))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 128 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.es/StorageTypeLimitList (s/coll-of :cognitect.aws.es/StorageTypeLimit))

(s/def
  :cognitect.aws.es/CancelElasticsearchServiceSoftwareUpdateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.CancelElasticsearchServiceSoftwareUpdateResponse/ServiceSoftwareOptions]))

(s/def :cognitect.aws.es/AdditionalLimitList (s/coll-of :cognitect.aws.es/AdditionalLimit))

(s/def
  :cognitect.aws.es/UpdateElasticsearchDomainConfigResponse
  (s/keys :req-un [:cognitect.aws.es.UpdateElasticsearchDomainConfigResponse/DomainConfig]))

(s/def :cognitect.aws.es/PolicyDocument string?)

(s/def
  :cognitect.aws.es/CreateElasticsearchDomainResponse
  (s/keys :opt-un [:cognitect.aws.es.CreateElasticsearchDomainResponse/DomainStatus]))

(s/def
  :cognitect.aws.es/SnapshotOptions
  (s/keys :opt-un [:cognitect.aws.es.SnapshotOptions/AutomatedSnapshotStartHour]))

(s/def :cognitect.aws.es/ServiceUrl string?)

(s/def
  :cognitect.aws.es/DeleteElasticsearchDomainResponse
  (s/keys :opt-un [:cognitect.aws.es.DeleteElasticsearchDomainResponse/DomainStatus]))

(s/def :cognitect.aws.es/StringList (s/coll-of :cognitect.aws.es/String))

(s/def
  :cognitect.aws.es/IntegerClass
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.es/GUID
  (s/with-gen
    #(re-matches
      (re-pattern "\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.es/DescribeReservedElasticsearchInstanceOfferingsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsResponse/NextToken
     :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsResponse/ReservedElasticsearchInstanceOfferings]))

(s/def :cognitect.aws.es/StartTimestamp inst?)

(s/def
  :cognitect.aws.es/CognitoOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.CognitoOptions/RoleArn
     :cognitect.aws.es.CognitoOptions/IdentityPoolId
     :cognitect.aws.es.CognitoOptions/UserPoolId
     :cognitect.aws.es.CognitoOptions/Enabled]))

(s/def :cognitect.aws.es/Double (s/with-gen double? #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.es/ReservedElasticsearchInstanceList
  (s/coll-of :cognitect.aws.es/ReservedElasticsearchInstance))

(s/def
  :cognitect.aws.es/AdditionalLimit
  (s/keys
    :opt-un
    [:cognitect.aws.es.AdditionalLimit/LimitValues :cognitect.aws.es.AdditionalLimit/LimitName]))

(s/def :cognitect.aws.es/Issue string?)

(s/def
  :cognitect.aws.es/PurchaseReservedElasticsearchInstanceOfferingResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingResponse/ReservationName
     :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingResponse/ReservedElasticsearchInstanceId]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchInstanceTypeLimitsRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/InstanceType
     :cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/ElasticsearchVersion]
    :opt-un
    [:cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/DomainName]))

(s/def
  :cognitect.aws.es/UIntValue
  (s/with-gen (s/and int? #(<= 0 %)) #(gen/choose (or 0 Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.es/StorageType
  (s/keys
    :opt-un
    [:cognitect.aws.es.StorageType/StorageSubTypeName
     :cognitect.aws.es.StorageType/StorageTypeName
     :cognitect.aws.es.StorageType/StorageTypeLimits]))

(s/def
  :cognitect.aws.es/ReservationToken
  (s/with-gen
    (s/and string? #(<= 5 (count %) 64))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 5 0) (or 64 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/LogPublishingOptions
  (s/map-of :cognitect.aws.es/LogType :cognitect.aws.es/LogPublishingOption))

(s/def :cognitect.aws.es/DomainInfo (s/keys :opt-un [:cognitect.aws.es.DomainInfo/DomainName]))

(s/def
  :cognitect.aws.es/GetCompatibleElasticsearchVersionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.GetCompatibleElasticsearchVersionsResponse/CompatibleElasticsearchVersions]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainRequest
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainRequest/DomainName]))

(s/def
  :cognitect.aws.es/UpgradeHistory
  (s/keys
    :opt-un
    [:cognitect.aws.es.UpgradeHistory/UpgradeName
     :cognitect.aws.es.UpgradeHistory/UpgradeStatus
     :cognitect.aws.es.UpgradeHistory/StepsList
     :cognitect.aws.es.UpgradeHistory/StartTimestamp]))

(s/def :cognitect.aws.es/String string?)

(s/def :cognitect.aws.es/OptionState string?)

(s/def
  :cognitect.aws.es/GetUpgradeHistoryResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.GetUpgradeHistoryResponse/UpgradeHistories
     :cognitect.aws.es.GetUpgradeHistoryResponse/NextToken]))

(s/def
  :cognitect.aws.es/DescribeReservedElasticsearchInstanceOfferingsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/NextToken
     :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/ReservedElasticsearchInstanceOfferingId
     :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/MaxResults]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainConfigResponse
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainConfigResponse/DomainConfig]))

(s/def
  :cognitect.aws.es/InstanceCount
  (s/with-gen (s/and int? #(<= 1 %)) #(gen/choose (or 1 Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def :cognitect.aws.es/LimitName string?)

(s/def
  :cognitect.aws.es.StartElasticsearchServiceSoftwareUpdateRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.AccessPoliciesStatus/Options :cognitect.aws.es/PolicyDocument)

(s/def :cognitect.aws.es.AccessPoliciesStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.ListTagsRequest/ARN :cognitect.aws.es/ARN)

(s/def
  :cognitect.aws.es.InstanceCountLimits/MinimumInstanceCount
  :cognitect.aws.es/MinimumInstanceCount)

(s/def
  :cognitect.aws.es.InstanceCountLimits/MaximumInstanceCount
  :cognitect.aws.es/MaximumInstanceCount)

(s/def :cognitect.aws.es.Tag/Key :cognitect.aws.es/TagKey)

(s/def :cognitect.aws.es.Tag/Value :cognitect.aws.es/TagValue)

(s/def :cognitect.aws.es.LogPublishingOptionsStatus/Options :cognitect.aws.es/LogPublishingOptions)

(s/def :cognitect.aws.es.LogPublishingOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.EncryptionAtRestOptionsStatus/Options
  :cognitect.aws.es/EncryptionAtRestOptions)

(s/def :cognitect.aws.es.EncryptionAtRestOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.ZoneAwarenessConfig/AvailabilityZoneCount :cognitect.aws.es/IntegerClass)

(s/def
  :cognitect.aws.es.DescribeElasticsearchDomainResponse/DomainStatus
  :cognitect.aws.es/ElasticsearchDomainStatus)

(s/def :cognitect.aws.es.UpgradeElasticsearchDomainRequest/DomainName :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.UpgradeElasticsearchDomainRequest/TargetVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def
  :cognitect.aws.es.UpgradeElasticsearchDomainRequest/PerformCheckOnly
  :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.DescribeElasticsearchDomainsResponse/DomainStatusList
  :cognitect.aws.es/ElasticsearchDomainStatusList)

(s/def :cognitect.aws.es.RemoveTagsRequest/ARN :cognitect.aws.es/ARN)

(s/def :cognitect.aws.es.RemoveTagsRequest/TagKeys :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.EBSOptionsStatus/Options :cognitect.aws.es/EBSOptions)

(s/def :cognitect.aws.es.EBSOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/ElasticsearchClusterConfig
  :cognitect.aws.es/ElasticsearchClusterConfigStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/AdvancedOptions
  :cognitect.aws.es/AdvancedOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/ElasticsearchVersion
  :cognitect.aws.es/ElasticsearchVersionStatus)

(s/def :cognitect.aws.es.ElasticsearchDomainConfig/EBSOptions :cognitect.aws.es/EBSOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/NodeToNodeEncryptionOptions
  :cognitect.aws.es/NodeToNodeEncryptionOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/EncryptionAtRestOptions
  :cognitect.aws.es/EncryptionAtRestOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/AccessPolicies
  :cognitect.aws.es/AccessPoliciesStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/VPCOptions
  :cognitect.aws.es/VPCDerivedInfoStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/SnapshotOptions
  :cognitect.aws.es/SnapshotOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/CognitoOptions
  :cognitect.aws.es/CognitoOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/LogPublishingOptions
  :cognitect.aws.es/LogPublishingOptionsStatus)

(s/def
  :cognitect.aws.es.NodeToNodeEncryptionOptionsStatus/Options
  :cognitect.aws.es/NodeToNodeEncryptionOptions)

(s/def :cognitect.aws.es.NodeToNodeEncryptionOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.ListElasticsearchVersionsRequest/MaxResults :cognitect.aws.es/MaxResults)

(s/def :cognitect.aws.es.ListElasticsearchVersionsRequest/NextToken :cognitect.aws.es/NextToken)

(s/def
  :cognitect.aws.es.StartElasticsearchServiceSoftwareUpdateResponse/ServiceSoftwareOptions
  :cognitect.aws.es/ServiceSoftwareOptions)

(s/def
  :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/ReservedElasticsearchInstanceOfferingId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/ReservationName
  :cognitect.aws.es/ReservationToken)

(s/def
  :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/InstanceCount
  :cognitect.aws.es/InstanceCount)

(s/def
  :cognitect.aws.es.CompatibleVersionsMap/SourceVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def
  :cognitect.aws.es.CompatibleVersionsMap/TargetVersions
  :cognitect.aws.es/ElasticsearchVersionList)

(s/def
  :cognitect.aws.es.ElasticsearchVersionStatus/Options
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def :cognitect.aws.es.ElasticsearchVersionStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/InstanceType
  :cognitect.aws.es/ESPartitionInstanceType)

(s/def :cognitect.aws.es.ElasticsearchClusterConfig/InstanceCount :cognitect.aws.es/IntegerClass)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterEnabled
  :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.ElasticsearchClusterConfig/ZoneAwarenessEnabled :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/ZoneAwarenessConfig
  :cognitect.aws.es/ZoneAwarenessConfig)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterType
  :cognitect.aws.es/ESPartitionInstanceType)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterCount
  :cognitect.aws.es/IntegerClass)

(s/def :cognitect.aws.es.UpgradeElasticsearchDomainResponse/DomainName :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.UpgradeElasticsearchDomainResponse/TargetVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def
  :cognitect.aws.es.UpgradeElasticsearchDomainResponse/PerformCheckOnly
  :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.DescribeElasticsearchDomainsRequest/DomainNames
  :cognitect.aws.es/DomainNameList)

(s/def
  :cognitect.aws.es.GetCompatibleElasticsearchVersionsRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesResponse/ElasticsearchInstanceTypes
  :cognitect.aws.es/ElasticsearchInstanceTypeList)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesResponse/NextToken
  :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.AdvancedOptionsStatus/Options :cognitect.aws.es/AdvancedOptions)

(s/def :cognitect.aws.es.AdvancedOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.DescribeElasticsearchDomainConfigRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/Endpoint :cognitect.aws.es/ServiceUrl)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/DomainId :cognitect.aws.es/DomainId)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/ElasticsearchClusterConfig
  :cognitect.aws.es/ElasticsearchClusterConfig)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/Processing :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/AdvancedOptions
  :cognitect.aws.es/AdvancedOptions)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/ElasticsearchVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/EBSOptions :cognitect.aws.es/EBSOptions)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/NodeToNodeEncryptionOptions
  :cognitect.aws.es/NodeToNodeEncryptionOptions)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/Deleted :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/ServiceSoftwareOptions
  :cognitect.aws.es/ServiceSoftwareOptions)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/EncryptionAtRestOptions
  :cognitect.aws.es/EncryptionAtRestOptions)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/ARN :cognitect.aws.es/ARN)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/AccessPolicies :cognitect.aws.es/PolicyDocument)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/VPCOptions :cognitect.aws.es/VPCDerivedInfo)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/Endpoints :cognitect.aws.es/EndpointsMap)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/SnapshotOptions
  :cognitect.aws.es/SnapshotOptions)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/Created :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/CognitoOptions :cognitect.aws.es/CognitoOptions)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/UpgradeProcessing :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/LogPublishingOptions
  :cognitect.aws.es/LogPublishingOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/ElasticsearchClusterConfig
  :cognitect.aws.es/ElasticsearchClusterConfig)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/AdvancedOptions
  :cognitect.aws.es/AdvancedOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/EBSOptions
  :cognitect.aws.es/EBSOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/AccessPolicies
  :cognitect.aws.es/PolicyDocument)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/VPCOptions
  :cognitect.aws.es/VPCOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/SnapshotOptions
  :cognitect.aws.es/SnapshotOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/CognitoOptions
  :cognitect.aws.es/CognitoOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/LogPublishingOptions
  :cognitect.aws.es/LogPublishingOptions)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfigStatus/Options
  :cognitect.aws.es/ElasticsearchClusterConfig)

(s/def :cognitect.aws.es.ElasticsearchClusterConfigStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/ElasticsearchVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/MaxResults
  :cognitect.aws.es/MaxResults)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/NextToken
  :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.EBSOptions/EBSEnabled :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.EBSOptions/VolumeType :cognitect.aws.es/VolumeType)

(s/def :cognitect.aws.es.EBSOptions/VolumeSize :cognitect.aws.es/IntegerClass)

(s/def :cognitect.aws.es.EBSOptions/Iops :cognitect.aws.es/IntegerClass)

(s/def :cognitect.aws.es.AddTagsRequest/ARN :cognitect.aws.es/ARN)

(s/def :cognitect.aws.es.AddTagsRequest/TagList :cognitect.aws.es/TagList)

(s/def :cognitect.aws.es.CreateElasticsearchDomainRequest/DomainName :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/ElasticsearchClusterConfig
  :cognitect.aws.es/ElasticsearchClusterConfig)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/AdvancedOptions
  :cognitect.aws.es/AdvancedOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/ElasticsearchVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def :cognitect.aws.es.CreateElasticsearchDomainRequest/EBSOptions :cognitect.aws.es/EBSOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/NodeToNodeEncryptionOptions
  :cognitect.aws.es/NodeToNodeEncryptionOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/EncryptionAtRestOptions
  :cognitect.aws.es/EncryptionAtRestOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/AccessPolicies
  :cognitect.aws.es/PolicyDocument)

(s/def :cognitect.aws.es.CreateElasticsearchDomainRequest/VPCOptions :cognitect.aws.es/VPCOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/SnapshotOptions
  :cognitect.aws.es/SnapshotOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/CognitoOptions
  :cognitect.aws.es/CognitoOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/LogPublishingOptions
  :cognitect.aws.es/LogPublishingOptions)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstancesResponse/NextToken
  :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstancesResponse/ReservedElasticsearchInstances
  :cognitect.aws.es/ReservedElasticsearchInstanceList)

(s/def :cognitect.aws.es.DeleteElasticsearchDomainRequest/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.ListDomainNamesResponse/DomainNames :cognitect.aws.es/DomainInfoList)

(s/def
  :cognitect.aws.es.CancelElasticsearchServiceSoftwareUpdateRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.NodeToNodeEncryptionOptions/Enabled :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/ReservedElasticsearchInstanceId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/MaxResults
  :cognitect.aws.es/MaxResults)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/NextToken
  :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.GetUpgradeHistoryRequest/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.GetUpgradeHistoryRequest/MaxResults :cognitect.aws.es/MaxResults)

(s/def :cognitect.aws.es.GetUpgradeHistoryRequest/NextToken :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.ListTagsResponse/TagList :cognitect.aws.es/TagList)

(s/def :cognitect.aws.es.VPCDerivedInfo/VPCId :cognitect.aws.es/String)

(s/def :cognitect.aws.es.VPCDerivedInfo/SubnetIds :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.VPCDerivedInfo/AvailabilityZones :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.VPCDerivedInfo/SecurityGroupIds :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.UpgradeStepItem/UpgradeStep :cognitect.aws.es/UpgradeStep)

(s/def :cognitect.aws.es.UpgradeStepItem/UpgradeStepStatus :cognitect.aws.es/UpgradeStatus)

(s/def :cognitect.aws.es.UpgradeStepItem/Issues :cognitect.aws.es/Issues)

(s/def :cognitect.aws.es.UpgradeStepItem/ProgressPercent :cognitect.aws.es/Double)

(s/def
  :cognitect.aws.es.LogPublishingOption/CloudWatchLogsLogGroupArn
  :cognitect.aws.es/CloudWatchLogsLogGroupArn)

(s/def :cognitect.aws.es.LogPublishingOption/Enabled :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.GetUpgradeStatusResponse/UpgradeStep :cognitect.aws.es/UpgradeStep)

(s/def :cognitect.aws.es.GetUpgradeStatusResponse/StepStatus :cognitect.aws.es/UpgradeStatus)

(s/def :cognitect.aws.es.GetUpgradeStatusResponse/UpgradeName :cognitect.aws.es/UpgradeName)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/RecurringCharges
  :cognitect.aws.es/RecurringChargeList)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/CurrencyCode :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/ReservationName
  :cognitect.aws.es/ReservationToken)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/FixedPrice :cognitect.aws.es/Double)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/PaymentOption
  :cognitect.aws.es/ReservedElasticsearchInstancePaymentOption)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/StartTime :cognitect.aws.es/UpdateTimestamp)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/ReservedElasticsearchInstanceOfferingId
  :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/ElasticsearchInstanceType
  :cognitect.aws.es/ESPartitionInstanceType)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/Duration :cognitect.aws.es/Integer)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/UsagePrice :cognitect.aws.es/Double)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/State :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/ReservedElasticsearchInstanceId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/ElasticsearchInstanceCount
  :cognitect.aws.es/Integer)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstanceOffering/ReservedElasticsearchInstanceOfferingId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstanceOffering/ElasticsearchInstanceType
  :cognitect.aws.es/ESPartitionInstanceType)

(s/def :cognitect.aws.es.ReservedElasticsearchInstanceOffering/Duration :cognitect.aws.es/Integer)

(s/def :cognitect.aws.es.ReservedElasticsearchInstanceOffering/FixedPrice :cognitect.aws.es/Double)

(s/def :cognitect.aws.es.ReservedElasticsearchInstanceOffering/UsagePrice :cognitect.aws.es/Double)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstanceOffering/CurrencyCode
  :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstanceOffering/PaymentOption
  :cognitect.aws.es/ReservedElasticsearchInstancePaymentOption)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstanceOffering/RecurringCharges
  :cognitect.aws.es/RecurringChargeList)

(s/def :cognitect.aws.es.OptionStatus/CreationDate :cognitect.aws.es/UpdateTimestamp)

(s/def :cognitect.aws.es.OptionStatus/UpdateDate :cognitect.aws.es/UpdateTimestamp)

(s/def :cognitect.aws.es.OptionStatus/UpdateVersion :cognitect.aws.es/UIntValue)

(s/def :cognitect.aws.es.OptionStatus/State :cognitect.aws.es/OptionState)

(s/def :cognitect.aws.es.OptionStatus/PendingDeletion :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.GetUpgradeStatusRequest/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.StorageTypeLimit/LimitName :cognitect.aws.es/LimitName)

(s/def :cognitect.aws.es.StorageTypeLimit/LimitValues :cognitect.aws.es/LimitValueList)

(s/def
  :cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsResponse/LimitsByRole
  :cognitect.aws.es/LimitsByRole)

(s/def :cognitect.aws.es.Limits/StorageTypes :cognitect.aws.es/StorageTypeList)

(s/def :cognitect.aws.es.Limits/InstanceLimits :cognitect.aws.es/InstanceLimits)

(s/def :cognitect.aws.es.Limits/AdditionalLimits :cognitect.aws.es/AdditionalLimitList)

(s/def
  :cognitect.aws.es.ListElasticsearchVersionsResponse/ElasticsearchVersions
  :cognitect.aws.es/ElasticsearchVersionList)

(s/def :cognitect.aws.es.ListElasticsearchVersionsResponse/NextToken :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.VPCDerivedInfoStatus/Options :cognitect.aws.es/VPCDerivedInfo)

(s/def :cognitect.aws.es.VPCDerivedInfoStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.RecurringCharge/RecurringChargeAmount :cognitect.aws.es/Double)

(s/def :cognitect.aws.es.RecurringCharge/RecurringChargeFrequency :cognitect.aws.es/String)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/CurrentVersion :cognitect.aws.es/String)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/NewVersion :cognitect.aws.es/String)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/UpdateAvailable :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/Cancellable :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/UpdateStatus :cognitect.aws.es/DeploymentStatus)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/Description :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.ServiceSoftwareOptions/AutomatedUpdateDate
  :cognitect.aws.es/DeploymentCloseDateTimeStamp)

(s/def :cognitect.aws.es.InstanceLimits/InstanceCountLimits :cognitect.aws.es/InstanceCountLimits)

(s/def :cognitect.aws.es.EncryptionAtRestOptions/Enabled :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.EncryptionAtRestOptions/KmsKeyId :cognitect.aws.es/KmsKeyId)

(s/def :cognitect.aws.es.CognitoOptionsStatus/Options :cognitect.aws.es/CognitoOptions)

(s/def :cognitect.aws.es.CognitoOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.SnapshotOptionsStatus/Options :cognitect.aws.es/SnapshotOptions)

(s/def :cognitect.aws.es.SnapshotOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.VPCOptions/SubnetIds :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.VPCOptions/SecurityGroupIds :cognitect.aws.es/StringList)

(s/def
  :cognitect.aws.es.CancelElasticsearchServiceSoftwareUpdateResponse/ServiceSoftwareOptions
  :cognitect.aws.es/ServiceSoftwareOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigResponse/DomainConfig
  :cognitect.aws.es/ElasticsearchDomainConfig)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainResponse/DomainStatus
  :cognitect.aws.es/ElasticsearchDomainStatus)

(s/def :cognitect.aws.es.SnapshotOptions/AutomatedSnapshotStartHour :cognitect.aws.es/IntegerClass)

(s/def
  :cognitect.aws.es.DeleteElasticsearchDomainResponse/DomainStatus
  :cognitect.aws.es/ElasticsearchDomainStatus)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsResponse/NextToken
  :cognitect.aws.es/NextToken)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsResponse/ReservedElasticsearchInstanceOfferings
  :cognitect.aws.es/ReservedElasticsearchInstanceOfferingList)

(s/def :cognitect.aws.es.CognitoOptions/Enabled :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.CognitoOptions/UserPoolId :cognitect.aws.es/UserPoolId)

(s/def :cognitect.aws.es.CognitoOptions/IdentityPoolId :cognitect.aws.es/IdentityPoolId)

(s/def :cognitect.aws.es.CognitoOptions/RoleArn :cognitect.aws.es/RoleArn)

(s/def :cognitect.aws.es.AdditionalLimit/LimitName :cognitect.aws.es/LimitName)

(s/def :cognitect.aws.es.AdditionalLimit/LimitValues :cognitect.aws.es/LimitValueList)

(s/def
  :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingResponse/ReservedElasticsearchInstanceId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingResponse/ReservationName
  :cognitect.aws.es/ReservationToken)

(s/def
  :cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/InstanceType
  :cognitect.aws.es/ESPartitionInstanceType)

(s/def
  :cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/ElasticsearchVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def :cognitect.aws.es.StorageType/StorageTypeName :cognitect.aws.es/StorageTypeName)

(s/def :cognitect.aws.es.StorageType/StorageSubTypeName :cognitect.aws.es/StorageSubTypeName)

(s/def :cognitect.aws.es.StorageType/StorageTypeLimits :cognitect.aws.es/StorageTypeLimitList)

(s/def :cognitect.aws.es.DomainInfo/DomainName :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.GetCompatibleElasticsearchVersionsResponse/CompatibleElasticsearchVersions
  :cognitect.aws.es/CompatibleElasticsearchVersionsList)

(s/def :cognitect.aws.es.DescribeElasticsearchDomainRequest/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.UpgradeHistory/UpgradeName :cognitect.aws.es/UpgradeName)

(s/def :cognitect.aws.es.UpgradeHistory/StartTimestamp :cognitect.aws.es/StartTimestamp)

(s/def :cognitect.aws.es.UpgradeHistory/UpgradeStatus :cognitect.aws.es/UpgradeStatus)

(s/def :cognitect.aws.es.UpgradeHistory/StepsList :cognitect.aws.es/UpgradeStepsList)

(s/def
  :cognitect.aws.es.GetUpgradeHistoryResponse/UpgradeHistories
  :cognitect.aws.es/UpgradeHistoryList)

(s/def :cognitect.aws.es.GetUpgradeHistoryResponse/NextToken :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/ReservedElasticsearchInstanceOfferingId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/MaxResults
  :cognitect.aws.es/MaxResults)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/NextToken
  :cognitect.aws.es/NextToken)

(s/def
  :cognitect.aws.es.DescribeElasticsearchDomainConfigResponse/DomainConfig
  :cognitect.aws.es/ElasticsearchDomainConfig)

