;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.es.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.es/DomainEndpointOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.DomainEndpointOptionsStatus/Options
     :cognitect.aws.es.DomainEndpointOptionsStatus/Status]))

(s/def
  :cognitect.aws.es/StartElasticsearchServiceSoftwareUpdateRequest
  (s/keys :req-un [:cognitect.aws.es.StartElasticsearchServiceSoftwareUpdateRequest/DomainName]))

(s/def
  :cognitect.aws.es/PackageDescription
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/AccessPoliciesStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.AccessPoliciesStatus/Options :cognitect.aws.es.AccessPoliciesStatus/Status]))

(s/def
  :cognitect.aws.es/AdvancedSecurityOptionsInput
  (s/keys
    :opt-un
    [:cognitect.aws.es.AdvancedSecurityOptionsInput/InternalUserDatabaseEnabled
     :cognitect.aws.es.AdvancedSecurityOptionsInput/Enabled
     :cognitect.aws.es.AdvancedSecurityOptionsInput/MasterUserOptions]))

(s/def :cognitect.aws.es/ListTagsRequest (s/keys :req-un [:cognitect.aws.es.ListTagsRequest/ARN]))

(s/def :cognitect.aws.es/CreatedAt inst?)

(s/def
  :cognitect.aws.es/LogType
  (s/spec string? :gen #(s/gen #{"SEARCH_SLOW_LOGS" "ES_APPLICATION_LOGS" "INDEX_SLOW_LOGS"})))

(s/def :cognitect.aws.es/LimitValueList (s/coll-of :cognitect.aws.es/LimitValue))

(s/def :cognitect.aws.es/UpdateTimestamp inst?)

(s/def
  :cognitect.aws.es/InstanceCountLimits
  (s/keys
    :opt-un
    [:cognitect.aws.es.InstanceCountLimits/MaximumInstanceCount
     :cognitect.aws.es.InstanceCountLimits/MinimumInstanceCount]))

(s/def
  :cognitect.aws.es/Tag
  (s/keys :req-un [:cognitect.aws.es.Tag/Key :cognitect.aws.es.Tag/Value]))

(s/def :cognitect.aws.es/DomainNameList (s/coll-of :cognitect.aws.es/DomainName))

(s/def
  :cognitect.aws.es/ListDomainsForPackageResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.ListDomainsForPackageResponse/NextToken
     :cognitect.aws.es.ListDomainsForPackageResponse/DomainPackageDetailsList]))

(s/def
  :cognitect.aws.es/LogPublishingOptionsStatus
  (s/keys
    :opt-un
    [:cognitect.aws.es.LogPublishingOptionsStatus/Status
     :cognitect.aws.es.LogPublishingOptionsStatus/Options]))

(s/def
  :cognitect.aws.es/EncryptionAtRestOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.EncryptionAtRestOptionsStatus/Options
     :cognitect.aws.es.EncryptionAtRestOptionsStatus/Status]))

(s/def :cognitect.aws.es/StorageTypeList (s/coll-of :cognitect.aws.es/StorageType))

(s/def
  :cognitect.aws.es/TLSSecurityPolicy
  (s/spec string? :gen #(s/gen #{"Policy-Min-TLS-1-0-2019-07" "Policy-Min-TLS-1-2-2019-07"})))

(s/def
  :cognitect.aws.es/ElasticsearchDomainStatusList
  (s/coll-of :cognitect.aws.es/ElasticsearchDomainStatus))

(s/def
  :cognitect.aws.es/ZoneAwarenessConfig
  (s/keys :opt-un [:cognitect.aws.es.ZoneAwarenessConfig/AvailabilityZoneCount]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainResponse
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainResponse/DomainStatus]))

(s/def
  :cognitect.aws.es/UpgradeElasticsearchDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.UpgradeElasticsearchDomainRequest/DomainName
     :cognitect.aws.es.UpgradeElasticsearchDomainRequest/TargetVersion]
    :opt-un
    [:cognitect.aws.es.UpgradeElasticsearchDomainRequest/PerformCheckOnly]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainsResponse
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainsResponse/DomainStatusList]))

(s/def
  :cognitect.aws.es/RemoveTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.RemoveTagsRequest/ARN :cognitect.aws.es.RemoveTagsRequest/TagKeys]))

(s/def :cognitect.aws.es/LastUpdated inst?)

(s/def
  :cognitect.aws.es/EBSOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.EBSOptionsStatus/Options :cognitect.aws.es.EBSOptionsStatus/Status]))

(s/def
  :cognitect.aws.es/ElasticsearchDomainConfig
  (s/keys
    :opt-un
    [:cognitect.aws.es.ElasticsearchDomainConfig/SnapshotOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/EBSOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/ElasticsearchVersion
     :cognitect.aws.es.ElasticsearchDomainConfig/NodeToNodeEncryptionOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/AccessPolicies
     :cognitect.aws.es.ElasticsearchDomainConfig/DomainEndpointOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/CognitoOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/ElasticsearchClusterConfig
     :cognitect.aws.es.ElasticsearchDomainConfig/AdvancedOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/LogPublishingOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/EncryptionAtRestOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/AdvancedSecurityOptions
     :cognitect.aws.es.ElasticsearchDomainConfig/VPCOptions]))

(s/def
  :cognitect.aws.es/IdentityPoolId
  (s/spec #(re-matches (re-pattern "[\\w-]+:[0-9a-f-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.es/NodeToNodeEncryptionOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.NodeToNodeEncryptionOptionsStatus/Options
     :cognitect.aws.es.NodeToNodeEncryptionOptionsStatus/Status]))

(s/def
  :cognitect.aws.es/ElasticsearchVersionList
  (s/coll-of :cognitect.aws.es/ElasticsearchVersionString))

(s/def
  :cognitect.aws.es/ListDomainsForPackageRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.ListDomainsForPackageRequest/PackageID]
    :opt-un
    [:cognitect.aws.es.ListDomainsForPackageRequest/NextToken
     :cognitect.aws.es.ListDomainsForPackageRequest/MaxResults]))

(s/def
  :cognitect.aws.es/ReservedElasticsearchInstanceOfferingList
  (s/coll-of :cognitect.aws.es/ReservedElasticsearchInstanceOffering))

(s/def
  :cognitect.aws.es/DeploymentStatus
  (s/spec
    string?
    :gen
    #(s/gen #{"COMPLETED" "IN_PROGRESS" "PENDING_UPDATE" "NOT_ELIGIBLE" "ELIGIBLE"})))

(s/def
  :cognitect.aws.es/ListElasticsearchVersionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.es.ListElasticsearchVersionsRequest/NextToken
     :cognitect.aws.es.ListElasticsearchVersionsRequest/MaxResults]))

(s/def
  :cognitect.aws.es/StartElasticsearchServiceSoftwareUpdateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.StartElasticsearchServiceSoftwareUpdateResponse/ServiceSoftwareOptions]))

(s/def :cognitect.aws.es/StorageSubTypeName string?)

(s/def :cognitect.aws.es/ErrorMessage string?)

(s/def :cognitect.aws.es/TagList (s/coll-of :cognitect.aws.es/Tag))

(s/def
  :cognitect.aws.es/DescribePackagesFilter
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribePackagesFilter/Value :cognitect.aws.es.DescribePackagesFilter/Name]))

(s/def :cognitect.aws.es/InstanceRole string?)

(s/def
  :cognitect.aws.es/DomainPackageDetailsList
  (s/coll-of :cognitect.aws.es/DomainPackageDetails))

(s/def :cognitect.aws.es/ElasticsearchVersionString string?)

(s/def
  :cognitect.aws.es/DomainName
  (s/spec #(re-matches (re-pattern "[a-z][a-z0-9\\-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.es/PurchaseReservedElasticsearchInstanceOfferingRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/ReservedElasticsearchInstanceOfferingId
     :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/ReservationName]
    :opt-un
    [:cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/InstanceCount]))

(s/def
  :cognitect.aws.es/DomainId
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/AdvancedSecurityOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.AdvancedSecurityOptionsStatus/Options
     :cognitect.aws.es.AdvancedSecurityOptionsStatus/Status]))

(s/def
  :cognitect.aws.es/CompatibleVersionsMap
  (s/keys
    :opt-un
    [:cognitect.aws.es.CompatibleVersionsMap/TargetVersions
     :cognitect.aws.es.CompatibleVersionsMap/SourceVersion]))

(s/def
  :cognitect.aws.es/ElasticsearchVersionStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.ElasticsearchVersionStatus/Options
     :cognitect.aws.es.ElasticsearchVersionStatus/Status]))

(s/def
  :cognitect.aws.es/ElasticsearchClusterConfig
  (s/keys
    :opt-un
    [:cognitect.aws.es.ElasticsearchClusterConfig/WarmEnabled
     :cognitect.aws.es.ElasticsearchClusterConfig/InstanceCount
     :cognitect.aws.es.ElasticsearchClusterConfig/InstanceType
     :cognitect.aws.es.ElasticsearchClusterConfig/ZoneAwarenessEnabled
     :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterCount
     :cognitect.aws.es.ElasticsearchClusterConfig/WarmType
     :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterEnabled
     :cognitect.aws.es.ElasticsearchClusterConfig/WarmCount
     :cognitect.aws.es.ElasticsearchClusterConfig/ZoneAwarenessConfig
     :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterType]))

(s/def
  :cognitect.aws.es/AdvancedOptions
  (s/map-of :cognitect.aws.es/String :cognitect.aws.es/String))

(s/def
  :cognitect.aws.es/ElasticsearchInstanceTypeList
  (s/coll-of :cognitect.aws.es/ESPartitionInstanceType))

(s/def
  :cognitect.aws.es/DeletePackageResponse
  (s/keys :opt-un [:cognitect.aws.es.DeletePackageResponse/PackageDetails]))

(s/def
  :cognitect.aws.es/UpgradeElasticsearchDomainResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.UpgradeElasticsearchDomainResponse/TargetVersion
     :cognitect.aws.es.UpgradeElasticsearchDomainResponse/DomainName
     :cognitect.aws.es.UpgradeElasticsearchDomainResponse/PerformCheckOnly]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainsRequest
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainsRequest/DomainNames]))

(s/def
  :cognitect.aws.es/DescribePackagesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribePackagesResponse/NextToken
     :cognitect.aws.es.DescribePackagesResponse/PackageDetailsList]))

(s/def
  :cognitect.aws.es/UpgradeStatus
  (s/spec string? :gen #(s/gen #{"SUCCEEDED_WITH_ISSUES" "IN_PROGRESS" "SUCCEEDED" "FAILED"})))

(s/def
  :cognitect.aws.es/DescribePackagesFilterValues
  (s/coll-of :cognitect.aws.es/DescribePackagesFilterValue))

(s/def
  :cognitect.aws.es/GetCompatibleElasticsearchVersionsRequest
  (s/keys :opt-un [:cognitect.aws.es.GetCompatibleElasticsearchVersionsRequest/DomainName]))

(s/def :cognitect.aws.es/S3Key string?)

(s/def
  :cognitect.aws.es/ListPackagesForDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.ListPackagesForDomainRequest/DomainName]
    :opt-un
    [:cognitect.aws.es.ListPackagesForDomainRequest/NextToken
     :cognitect.aws.es.ListPackagesForDomainRequest/MaxResults]))

(s/def
  :cognitect.aws.es/ListElasticsearchInstanceTypesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.ListElasticsearchInstanceTypesResponse/ElasticsearchInstanceTypes
     :cognitect.aws.es.ListElasticsearchInstanceTypesResponse/NextToken]))

(s/def
  :cognitect.aws.es/AdvancedOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.AdvancedOptionsStatus/Options
     :cognitect.aws.es.AdvancedOptionsStatus/Status]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainConfigRequest
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainConfigRequest/DomainName]))

(s/def
  :cognitect.aws.es/ElasticsearchDomainStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.ElasticsearchDomainStatus/DomainId
     :cognitect.aws.es.ElasticsearchDomainStatus/DomainName
     :cognitect.aws.es.ElasticsearchDomainStatus/ARN
     :cognitect.aws.es.ElasticsearchDomainStatus/ElasticsearchClusterConfig]
    :opt-un
    [:cognitect.aws.es.ElasticsearchDomainStatus/SnapshotOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/EBSOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/Created
     :cognitect.aws.es.ElasticsearchDomainStatus/ElasticsearchVersion
     :cognitect.aws.es.ElasticsearchDomainStatus/NodeToNodeEncryptionOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/AccessPolicies
     :cognitect.aws.es.ElasticsearchDomainStatus/Endpoints
     :cognitect.aws.es.ElasticsearchDomainStatus/DomainEndpointOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/CognitoOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/Deleted
     :cognitect.aws.es.ElasticsearchDomainStatus/UpgradeProcessing
     :cognitect.aws.es.ElasticsearchDomainStatus/AdvancedOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/Processing
     :cognitect.aws.es.ElasticsearchDomainStatus/LogPublishingOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/EncryptionAtRestOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/Endpoint
     :cognitect.aws.es.ElasticsearchDomainStatus/ServiceSoftwareOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/AdvancedSecurityOptions
     :cognitect.aws.es.ElasticsearchDomainStatus/VPCOptions]))

(s/def
  :cognitect.aws.es/UpdateElasticsearchDomainConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/DomainName]
    :opt-un
    [:cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/SnapshotOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/EBSOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/AccessPolicies
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/DomainEndpointOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/CognitoOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/ElasticsearchClusterConfig
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/AdvancedOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/LogPublishingOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/AdvancedSecurityOptions
     :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/VPCOptions]))

(s/def
  :cognitect.aws.es/ElasticsearchClusterConfigStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.ElasticsearchClusterConfigStatus/Options
     :cognitect.aws.es.ElasticsearchClusterConfigStatus/Status]))

(s/def
  :cognitect.aws.es/ErrorDetails
  (s/keys
    :opt-un
    [:cognitect.aws.es.ErrorDetails/ErrorMessage :cognitect.aws.es.ErrorDetails/ErrorType]))

(s/def
  :cognitect.aws.es/ListElasticsearchInstanceTypesRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.ListElasticsearchInstanceTypesRequest/ElasticsearchVersion]
    :opt-un
    [:cognitect.aws.es.ListElasticsearchInstanceTypesRequest/NextToken
     :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/MaxResults
     :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/DomainName]))

(s/def
  :cognitect.aws.es/AssociatePackageRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.AssociatePackageRequest/PackageID
     :cognitect.aws.es.AssociatePackageRequest/DomainName]))

(s/def
  :cognitect.aws.es/EBSOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.EBSOptions/Iops
     :cognitect.aws.es.EBSOptions/VolumeType
     :cognitect.aws.es.EBSOptions/VolumeSize
     :cognitect.aws.es.EBSOptions/EBSEnabled]))

(s/def :cognitect.aws.es/DeploymentCloseDateTimeStamp inst?)

(s/def :cognitect.aws.es/VolumeType (s/spec string? :gen #(s/gen #{"standard" "io1" "gp2"})))

(s/def :cognitect.aws.es/Boolean boolean?)

(s/def
  :cognitect.aws.es/AddTagsRequest
  (s/keys :req-un [:cognitect.aws.es.AddTagsRequest/ARN :cognitect.aws.es.AddTagsRequest/TagList]))

(s/def
  :cognitect.aws.es/CreateElasticsearchDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.CreateElasticsearchDomainRequest/DomainName]
    :opt-un
    [:cognitect.aws.es.CreateElasticsearchDomainRequest/SnapshotOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/EBSOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/ElasticsearchVersion
     :cognitect.aws.es.CreateElasticsearchDomainRequest/NodeToNodeEncryptionOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/AccessPolicies
     :cognitect.aws.es.CreateElasticsearchDomainRequest/DomainEndpointOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/CognitoOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/ElasticsearchClusterConfig
     :cognitect.aws.es.CreateElasticsearchDomainRequest/AdvancedOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/LogPublishingOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/EncryptionAtRestOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/AdvancedSecurityOptions
     :cognitect.aws.es.CreateElasticsearchDomainRequest/VPCOptions]))

(s/def
  :cognitect.aws.es/CompatibleElasticsearchVersionsList
  (s/coll-of :cognitect.aws.es/CompatibleVersionsMap))

(s/def
  :cognitect.aws.es/DescribeReservedElasticsearchInstancesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribeReservedElasticsearchInstancesResponse/NextToken
     :cognitect.aws.es.DescribeReservedElasticsearchInstancesResponse/ReservedElasticsearchInstances]))

(s/def
  :cognitect.aws.es/DeleteElasticsearchDomainRequest
  (s/keys :req-un [:cognitect.aws.es.DeleteElasticsearchDomainRequest/DomainName]))

(s/def
  :cognitect.aws.es/ListDomainNamesResponse
  (s/keys :opt-un [:cognitect.aws.es.ListDomainNamesResponse/DomainNames]))

(s/def
  :cognitect.aws.es/CancelElasticsearchServiceSoftwareUpdateRequest
  (s/keys :req-un [:cognitect.aws.es.CancelElasticsearchServiceSoftwareUpdateRequest/DomainName]))

(s/def :cognitect.aws.es/StorageTypeName string?)

(s/def
  :cognitect.aws.es/NodeToNodeEncryptionOptions
  (s/keys :opt-un [:cognitect.aws.es.NodeToNodeEncryptionOptions/Enabled]))

(s/def
  :cognitect.aws.es/DescribeReservedElasticsearchInstancesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/NextToken
     :cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/ReservedElasticsearchInstanceId
     :cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/MaxResults]))

(s/def :cognitect.aws.es/NextToken string?)

(s/def :cognitect.aws.es/ErrorType string?)

(s/def
  :cognitect.aws.es/DescribePackagesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribePackagesRequest/NextToken
     :cognitect.aws.es.DescribePackagesRequest/Filters
     :cognitect.aws.es.DescribePackagesRequest/MaxResults]))

(s/def :cognitect.aws.es/Integer (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.es/GetUpgradeHistoryRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.GetUpgradeHistoryRequest/DomainName]
    :opt-un
    [:cognitect.aws.es.GetUpgradeHistoryRequest/NextToken
     :cognitect.aws.es.GetUpgradeHistoryRequest/MaxResults]))

(s/def
  :cognitect.aws.es/ListTagsResponse
  (s/keys :opt-un [:cognitect.aws.es.ListTagsResponse/TagList]))

(s/def
  :cognitect.aws.es/LimitsByRole
  (s/map-of :cognitect.aws.es/InstanceRole :cognitect.aws.es/Limits))

(s/def
  :cognitect.aws.es/EndpointsMap
  (s/map-of :cognitect.aws.es/String :cognitect.aws.es/ServiceUrl))

(s/def
  :cognitect.aws.es/TagValue
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/VPCDerivedInfo
  (s/keys
    :opt-un
    [:cognitect.aws.es.VPCDerivedInfo/SubnetIds
     :cognitect.aws.es.VPCDerivedInfo/SecurityGroupIds
     :cognitect.aws.es.VPCDerivedInfo/AvailabilityZones
     :cognitect.aws.es.VPCDerivedInfo/VPCId]))

(s/def
  :cognitect.aws.es/UserPoolId
  (s/spec #(re-matches (re-pattern "[\\w-]+_[0-9a-zA-Z]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.es/UpgradeStepItem
  (s/keys
    :opt-un
    [:cognitect.aws.es.UpgradeStepItem/UpgradeStepStatus
     :cognitect.aws.es.UpgradeStepItem/ProgressPercent
     :cognitect.aws.es.UpgradeStepItem/UpgradeStep
     :cognitect.aws.es.UpgradeStepItem/Issues]))

(s/def
  :cognitect.aws.es/ReservedElasticsearchInstancePaymentOption
  (s/spec string? :gen #(s/gen #{"NO_UPFRONT" "PARTIAL_UPFRONT" "ALL_UPFRONT"})))

(s/def :cognitect.aws.es/ReferencePath string?)

(s/def :cognitect.aws.es/RecurringChargeList (s/coll-of :cognitect.aws.es/RecurringCharge))

(s/def :cognitect.aws.es/UpgradeHistoryList (s/coll-of :cognitect.aws.es/UpgradeHistory))

(s/def
  :cognitect.aws.es/DescribePackagesFilterValue
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z\\*\\.\\\\/\\?-]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.es/LogPublishingOption
  (s/keys
    :opt-un
    [:cognitect.aws.es.LogPublishingOption/CloudWatchLogsLogGroupArn
     :cognitect.aws.es.LogPublishingOption/Enabled]))

(s/def
  :cognitect.aws.es/GetUpgradeStatusResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.GetUpgradeStatusResponse/UpgradeName
     :cognitect.aws.es.GetUpgradeStatusResponse/StepStatus
     :cognitect.aws.es.GetUpgradeStatusResponse/UpgradeStep]))

(s/def
  :cognitect.aws.es/DissociatePackageRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.DissociatePackageRequest/PackageID
     :cognitect.aws.es.DissociatePackageRequest/DomainName]))

(s/def
  :cognitect.aws.es/ReservedElasticsearchInstance
  (s/keys
    :opt-un
    [:cognitect.aws.es.ReservedElasticsearchInstance/ElasticsearchInstanceType
     :cognitect.aws.es.ReservedElasticsearchInstance/CurrencyCode
     :cognitect.aws.es.ReservedElasticsearchInstance/StartTime
     :cognitect.aws.es.ReservedElasticsearchInstance/FixedPrice
     :cognitect.aws.es.ReservedElasticsearchInstance/PaymentOption
     :cognitect.aws.es.ReservedElasticsearchInstance/ReservationName
     :cognitect.aws.es.ReservedElasticsearchInstance/Duration
     :cognitect.aws.es.ReservedElasticsearchInstance/ReservedElasticsearchInstanceId
     :cognitect.aws.es.ReservedElasticsearchInstance/UsagePrice
     :cognitect.aws.es.ReservedElasticsearchInstance/ReservedElasticsearchInstanceOfferingId
     :cognitect.aws.es.ReservedElasticsearchInstance/State
     :cognitect.aws.es.ReservedElasticsearchInstance/RecurringCharges
     :cognitect.aws.es.ReservedElasticsearchInstance/ElasticsearchInstanceCount]))

(s/def
  :cognitect.aws.es/ReservedElasticsearchInstanceOffering
  (s/keys
    :opt-un
    [:cognitect.aws.es.ReservedElasticsearchInstanceOffering/ElasticsearchInstanceType
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/CurrencyCode
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/FixedPrice
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/PaymentOption
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/Duration
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/UsagePrice
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/ReservedElasticsearchInstanceOfferingId
     :cognitect.aws.es.ReservedElasticsearchInstanceOffering/RecurringCharges]))

(s/def :cognitect.aws.es/CloudWatchLogsLogGroupArn string?)

(s/def
  :cognitect.aws.es/OptionStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.OptionStatus/CreationDate
     :cognitect.aws.es.OptionStatus/UpdateDate
     :cognitect.aws.es.OptionStatus/State]
    :opt-un
    [:cognitect.aws.es.OptionStatus/PendingDeletion :cognitect.aws.es.OptionStatus/UpdateVersion]))

(s/def
  :cognitect.aws.es/RoleArn
  (s/spec
    (s/and string? #(<= 20 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 20 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/CreatePackageRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.CreatePackageRequest/PackageName
     :cognitect.aws.es.CreatePackageRequest/PackageType
     :cognitect.aws.es.CreatePackageRequest/PackageSource]
    :opt-un
    [:cognitect.aws.es.CreatePackageRequest/PackageDescription]))

(s/def
  :cognitect.aws.es/GetUpgradeStatusRequest
  (s/keys :req-un [:cognitect.aws.es.GetUpgradeStatusRequest/DomainName]))

(s/def
  :cognitect.aws.es/StorageTypeLimit
  (s/keys
    :opt-un
    [:cognitect.aws.es.StorageTypeLimit/LimitValues :cognitect.aws.es.StorageTypeLimit/LimitName]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchInstanceTypeLimitsResponse
  (s/keys :opt-un [:cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsResponse/LimitsByRole]))

(s/def
  :cognitect.aws.es/MasterUserOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.MasterUserOptions/MasterUserName
     :cognitect.aws.es.MasterUserOptions/MasterUserPassword
     :cognitect.aws.es.MasterUserOptions/MasterUserARN]))

(s/def
  :cognitect.aws.es/Limits
  (s/keys
    :opt-un
    [:cognitect.aws.es.Limits/AdditionalLimits
     :cognitect.aws.es.Limits/InstanceLimits
     :cognitect.aws.es.Limits/StorageTypes]))

(s/def
  :cognitect.aws.es/ListElasticsearchVersionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.ListElasticsearchVersionsResponse/ElasticsearchVersions
     :cognitect.aws.es.ListElasticsearchVersionsResponse/NextToken]))

(s/def
  :cognitect.aws.es/PackageName
  (s/spec #(re-matches (re-pattern "[a-z][a-z0-9\\-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.es/KmsKeyId
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/VPCDerivedInfoStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.VPCDerivedInfoStatus/Options :cognitect.aws.es.VPCDerivedInfoStatus/Status]))

(s/def
  :cognitect.aws.es/Password
  (s/spec
    (s/and string? #(<= 8 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 8 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/PackageDetails
  (s/keys
    :opt-un
    [:cognitect.aws.es.PackageDetails/PackageID
     :cognitect.aws.es.PackageDetails/PackageDescription
     :cognitect.aws.es.PackageDetails/PackageName
     :cognitect.aws.es.PackageDetails/PackageStatus
     :cognitect.aws.es.PackageDetails/CreatedAt
     :cognitect.aws.es.PackageDetails/ErrorDetails
     :cognitect.aws.es.PackageDetails/PackageType]))

(s/def
  :cognitect.aws.es/MinimumInstanceCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.es/MaximumInstanceCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.es/DescribePackagesFilterName
  (s/spec string? :gen #(s/gen #{"PackageID" "PackageName" "PackageStatus"})))

(s/def
  :cognitect.aws.es/PackageSource
  (s/keys
    :opt-un
    [:cognitect.aws.es.PackageSource/S3BucketName :cognitect.aws.es.PackageSource/S3Key]))

(s/def
  :cognitect.aws.es/DomainPackageStatus
  (s/spec
    string?
    :gen
    #(s/gen #{"ASSOCIATION_FAILED" "DISSOCIATION_FAILED" "DISSOCIATING" "ACTIVE" "ASSOCIATING"})))

(s/def :cognitect.aws.es/DomainInfoList (s/coll-of :cognitect.aws.es/DomainInfo))

(s/def
  :cognitect.aws.es/RecurringCharge
  (s/keys
    :opt-un
    [:cognitect.aws.es.RecurringCharge/RecurringChargeFrequency
     :cognitect.aws.es.RecurringCharge/RecurringChargeAmount]))

(s/def
  :cognitect.aws.es/ServiceSoftwareOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.ServiceSoftwareOptions/NewVersion
     :cognitect.aws.es.ServiceSoftwareOptions/UpdateStatus
     :cognitect.aws.es.ServiceSoftwareOptions/Cancellable
     :cognitect.aws.es.ServiceSoftwareOptions/UpdateAvailable
     :cognitect.aws.es.ServiceSoftwareOptions/Description
     :cognitect.aws.es.ServiceSoftwareOptions/AutomatedUpdateDate
     :cognitect.aws.es.ServiceSoftwareOptions/CurrentVersion
     :cognitect.aws.es.ServiceSoftwareOptions/OptionalDeployment]))

(s/def
  :cognitect.aws.es/InstanceLimits
  (s/keys :opt-un [:cognitect.aws.es.InstanceLimits/InstanceCountLimits]))

(s/def
  :cognitect.aws.es/EncryptionAtRestOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.EncryptionAtRestOptions/Enabled
     :cognitect.aws.es.EncryptionAtRestOptions/KmsKeyId]))

(s/def
  :cognitect.aws.es/PackageStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"COPYING" "AVAILABLE" "COPY_FAILED" "VALIDATION_FAILED" "DELETING" "DELETED" "VALIDATING"
        "DELETE_FAILED"})))

(s/def
  :cognitect.aws.es/UpgradeStep
  (s/spec string? :gen #(s/gen #{"SNAPSHOT" "UPGRADE" "PRE_UPGRADE_CHECK"})))

(s/def :cognitect.aws.es/UpgradeStepsList (s/coll-of :cognitect.aws.es/UpgradeStepItem))

(s/def
  :cognitect.aws.es/AdvancedSecurityOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.AdvancedSecurityOptions/InternalUserDatabaseEnabled
     :cognitect.aws.es.AdvancedSecurityOptions/Enabled]))

(s/def
  :cognitect.aws.es/ESPartitionInstanceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"i3.large.elasticsearch" "m5.2xlarge.elasticsearch" "c5.9xlarge.elasticsearch"
        "r5.12xlarge.elasticsearch" "m4.2xlarge.elasticsearch" "ultrawarm1.large.elasticsearch"
        "d2.4xlarge.elasticsearch" "m5.xlarge.elasticsearch" "t2.micro.elasticsearch"
        "r3.2xlarge.elasticsearch" "c4.large.elasticsearch" "r4.2xlarge.elasticsearch"
        "m4.xlarge.elasticsearch" "m3.xlarge.elasticsearch" "m5.4xlarge.elasticsearch"
        "i2.2xlarge.elasticsearch" "r4.8xlarge.elasticsearch" "r4.large.elasticsearch"
        "r3.xlarge.elasticsearch" "r3.4xlarge.elasticsearch" "r4.16xlarge.elasticsearch"
        "i3.8xlarge.elasticsearch" "m3.medium.elasticsearch" "i3.16xlarge.elasticsearch"
        "c5.xlarge.elasticsearch" "i3.4xlarge.elasticsearch" "t2.medium.elasticsearch"
        "c4.xlarge.elasticsearch" "i3.xlarge.elasticsearch" "r4.4xlarge.elasticsearch"
        "d2.2xlarge.elasticsearch" "c5.2xlarge.elasticsearch" "m4.large.elasticsearch"
        "r5.4xlarge.elasticsearch" "m5.12xlarge.elasticsearch" "ultrawarm1.medium.elasticsearch"
        "t2.small.elasticsearch" "m4.4xlarge.elasticsearch" "d2.8xlarge.elasticsearch"
        "c4.2xlarge.elasticsearch" "r3.large.elasticsearch" "m3.2xlarge.elasticsearch"
        "m4.10xlarge.elasticsearch" "d2.xlarge.elasticsearch" "r5.large.elasticsearch"
        "r5.xlarge.elasticsearch" "m3.large.elasticsearch" "c5.4xlarge.elasticsearch"
        "i2.xlarge.elasticsearch" "c5.18xlarge.elasticsearch" "r4.xlarge.elasticsearch"
        "i3.2xlarge.elasticsearch" "c4.4xlarge.elasticsearch" "m5.large.elasticsearch"
        "c4.8xlarge.elasticsearch" "r5.2xlarge.elasticsearch" "r3.8xlarge.elasticsearch"
        "c5.large.elasticsearch"})))

(s/def :cognitect.aws.es/LimitValue string?)

(s/def
  :cognitect.aws.es/CognitoOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.CognitoOptionsStatus/Options :cognitect.aws.es.CognitoOptionsStatus/Status]))

(s/def
  :cognitect.aws.es/SnapshotOptionsStatus
  (s/keys
    :req-un
    [:cognitect.aws.es.SnapshotOptionsStatus/Options
     :cognitect.aws.es.SnapshotOptionsStatus/Status]))

(s/def :cognitect.aws.es/PackageID string?)

(s/def
  :cognitect.aws.es/CreatePackageResponse
  (s/keys :opt-un [:cognitect.aws.es.CreatePackageResponse/PackageDetails]))

(s/def :cognitect.aws.es/Issues (s/coll-of :cognitect.aws.es/Issue))

(s/def :cognitect.aws.es/ARN string?)

(s/def :cognitect.aws.es/UpgradeName string?)

(s/def
  :cognitect.aws.es/VPCOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.VPCOptions/SubnetIds :cognitect.aws.es.VPCOptions/SecurityGroupIds]))

(s/def
  :cognitect.aws.es/MaxResults
  (s/spec (s/and int? #(>= 100 %)) :gen #(gen/choose Long/MIN_VALUE 100)))

(s/def
  :cognitect.aws.es/TagKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.es/StorageTypeLimitList (s/coll-of :cognitect.aws.es/StorageTypeLimit))

(s/def
  :cognitect.aws.es/DomainEndpointOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.DomainEndpointOptions/EnforceHTTPS
     :cognitect.aws.es.DomainEndpointOptions/TLSSecurityPolicy]))

(s/def
  :cognitect.aws.es/CancelElasticsearchServiceSoftwareUpdateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.CancelElasticsearchServiceSoftwareUpdateResponse/ServiceSoftwareOptions]))

(s/def
  :cognitect.aws.es/DomainPackageDetails
  (s/keys
    :opt-un
    [:cognitect.aws.es.DomainPackageDetails/PackageID
     :cognitect.aws.es.DomainPackageDetails/DomainPackageStatus
     :cognitect.aws.es.DomainPackageDetails/ReferencePath
     :cognitect.aws.es.DomainPackageDetails/PackageName
     :cognitect.aws.es.DomainPackageDetails/ErrorDetails
     :cognitect.aws.es.DomainPackageDetails/DomainName
     :cognitect.aws.es.DomainPackageDetails/PackageType
     :cognitect.aws.es.DomainPackageDetails/LastUpdated]))

(s/def :cognitect.aws.es/AdditionalLimitList (s/coll-of :cognitect.aws.es/AdditionalLimit))

(s/def
  :cognitect.aws.es/AssociatePackageResponse
  (s/keys :opt-un [:cognitect.aws.es.AssociatePackageResponse/DomainPackageDetails]))

(s/def
  :cognitect.aws.es/DescribePackagesFilterList
  (s/coll-of :cognitect.aws.es/DescribePackagesFilter))

(s/def
  :cognitect.aws.es/UpdateElasticsearchDomainConfigResponse
  (s/keys :req-un [:cognitect.aws.es.UpdateElasticsearchDomainConfigResponse/DomainConfig]))

(s/def :cognitect.aws.es/PolicyDocument string?)

(s/def
  :cognitect.aws.es/S3BucketName
  (s/spec
    (s/and string? #(<= 3 (count %) 63))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 3 63) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.es/PackageType (s/spec string? :gen #(s/gen #{"TXT-DICTIONARY"})))

(s/def
  :cognitect.aws.es/CreateElasticsearchDomainResponse
  (s/keys :opt-un [:cognitect.aws.es.CreateElasticsearchDomainResponse/DomainStatus]))

(s/def
  :cognitect.aws.es/SnapshotOptions
  (s/keys :opt-un [:cognitect.aws.es.SnapshotOptions/AutomatedSnapshotStartHour]))

(s/def :cognitect.aws.es/ServiceUrl string?)

(s/def
  :cognitect.aws.es/DeleteElasticsearchDomainResponse
  (s/keys :opt-un [:cognitect.aws.es.DeleteElasticsearchDomainResponse/DomainStatus]))

(s/def
  :cognitect.aws.es/ListPackagesForDomainResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.ListPackagesForDomainResponse/NextToken
     :cognitect.aws.es.ListPackagesForDomainResponse/DomainPackageDetailsList]))

(s/def :cognitect.aws.es/StringList (s/coll-of :cognitect.aws.es/String))

(s/def
  :cognitect.aws.es/IntegerClass
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.es/GUID
  (s/spec
    #(re-matches
      (re-pattern "\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.es/ESWarmPartitionInstanceType
  (s/spec
    string?
    :gen
    #(s/gen #{"ultrawarm1.large.elasticsearch" "ultrawarm1.medium.elasticsearch"})))

(s/def
  :cognitect.aws.es/DissociatePackageResponse
  (s/keys :opt-un [:cognitect.aws.es.DissociatePackageResponse/DomainPackageDetails]))

(s/def :cognitect.aws.es/PackageDetailsList (s/coll-of :cognitect.aws.es/PackageDetails))

(s/def
  :cognitect.aws.es/DescribeReservedElasticsearchInstanceOfferingsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsResponse/NextToken
     :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsResponse/ReservedElasticsearchInstanceOfferings]))

(s/def :cognitect.aws.es/StartTimestamp inst?)

(s/def
  :cognitect.aws.es/CognitoOptions
  (s/keys
    :opt-un
    [:cognitect.aws.es.CognitoOptions/RoleArn
     :cognitect.aws.es.CognitoOptions/IdentityPoolId
     :cognitect.aws.es.CognitoOptions/UserPoolId
     :cognitect.aws.es.CognitoOptions/Enabled]))

(s/def
  :cognitect.aws.es/Double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.es/Username
  (s/spec
    (s/and string? #(<= 1 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/ReservedElasticsearchInstanceList
  (s/coll-of :cognitect.aws.es/ReservedElasticsearchInstance))

(s/def
  :cognitect.aws.es/AdditionalLimit
  (s/keys
    :opt-un
    [:cognitect.aws.es.AdditionalLimit/LimitValues :cognitect.aws.es.AdditionalLimit/LimitName]))

(s/def :cognitect.aws.es/Issue string?)

(s/def
  :cognitect.aws.es/PurchaseReservedElasticsearchInstanceOfferingResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingResponse/ReservationName
     :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingResponse/ReservedElasticsearchInstanceId]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchInstanceTypeLimitsRequest
  (s/keys
    :req-un
    [:cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/InstanceType
     :cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/ElasticsearchVersion]
    :opt-un
    [:cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/DomainName]))

(s/def
  :cognitect.aws.es/UIntValue
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.es/StorageType
  (s/keys
    :opt-un
    [:cognitect.aws.es.StorageType/StorageSubTypeName
     :cognitect.aws.es.StorageType/StorageTypeName
     :cognitect.aws.es.StorageType/StorageTypeLimits]))

(s/def
  :cognitect.aws.es/ReservationToken
  (s/spec
    (s/and string? #(<= 5 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 5 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.es/LogPublishingOptions
  (s/map-of :cognitect.aws.es/LogType :cognitect.aws.es/LogPublishingOption))

(s/def :cognitect.aws.es/DomainInfo (s/keys :opt-un [:cognitect.aws.es.DomainInfo/DomainName]))

(s/def
  :cognitect.aws.es/GetCompatibleElasticsearchVersionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.GetCompatibleElasticsearchVersionsResponse/CompatibleElasticsearchVersions]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainRequest
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainRequest/DomainName]))

(s/def
  :cognitect.aws.es/UpgradeHistory
  (s/keys
    :opt-un
    [:cognitect.aws.es.UpgradeHistory/UpgradeName
     :cognitect.aws.es.UpgradeHistory/UpgradeStatus
     :cognitect.aws.es.UpgradeHistory/StepsList
     :cognitect.aws.es.UpgradeHistory/StartTimestamp]))

(s/def :cognitect.aws.es/String string?)

(s/def
  :cognitect.aws.es/OptionState
  (s/spec string? :gen #(s/gen #{"Active" "RequiresIndexDocuments" "Processing"})))

(s/def
  :cognitect.aws.es/GetUpgradeHistoryResponse
  (s/keys
    :opt-un
    [:cognitect.aws.es.GetUpgradeHistoryResponse/UpgradeHistories
     :cognitect.aws.es.GetUpgradeHistoryResponse/NextToken]))

(s/def
  :cognitect.aws.es/DeletePackageRequest
  (s/keys :req-un [:cognitect.aws.es.DeletePackageRequest/PackageID]))

(s/def
  :cognitect.aws.es/DescribeReservedElasticsearchInstanceOfferingsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/NextToken
     :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/ReservedElasticsearchInstanceOfferingId
     :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/MaxResults]))

(s/def
  :cognitect.aws.es/DescribeElasticsearchDomainConfigResponse
  (s/keys :req-un [:cognitect.aws.es.DescribeElasticsearchDomainConfigResponse/DomainConfig]))

(s/def
  :cognitect.aws.es/InstanceCount
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def :cognitect.aws.es/LimitName string?)

(s/def
  :cognitect.aws.es.DomainEndpointOptionsStatus/Options
  :cognitect.aws.es/DomainEndpointOptions)

(s/def :cognitect.aws.es.DomainEndpointOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.StartElasticsearchServiceSoftwareUpdateRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.AccessPoliciesStatus/Options :cognitect.aws.es/PolicyDocument)

(s/def :cognitect.aws.es.AccessPoliciesStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.AdvancedSecurityOptionsInput/Enabled :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.AdvancedSecurityOptionsInput/InternalUserDatabaseEnabled
  :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.AdvancedSecurityOptionsInput/MasterUserOptions
  :cognitect.aws.es/MasterUserOptions)

(s/def :cognitect.aws.es.ListTagsRequest/ARN :cognitect.aws.es/ARN)

(s/def
  :cognitect.aws.es.InstanceCountLimits/MinimumInstanceCount
  :cognitect.aws.es/MinimumInstanceCount)

(s/def
  :cognitect.aws.es.InstanceCountLimits/MaximumInstanceCount
  :cognitect.aws.es/MaximumInstanceCount)

(s/def :cognitect.aws.es.Tag/Key :cognitect.aws.es/TagKey)

(s/def :cognitect.aws.es.Tag/Value :cognitect.aws.es/TagValue)

(s/def
  :cognitect.aws.es.ListDomainsForPackageResponse/DomainPackageDetailsList
  :cognitect.aws.es/DomainPackageDetailsList)

(s/def :cognitect.aws.es.ListDomainsForPackageResponse/NextToken :cognitect.aws.es/String)

(s/def :cognitect.aws.es.LogPublishingOptionsStatus/Options :cognitect.aws.es/LogPublishingOptions)

(s/def :cognitect.aws.es.LogPublishingOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.EncryptionAtRestOptionsStatus/Options
  :cognitect.aws.es/EncryptionAtRestOptions)

(s/def :cognitect.aws.es.EncryptionAtRestOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.ZoneAwarenessConfig/AvailabilityZoneCount :cognitect.aws.es/IntegerClass)

(s/def
  :cognitect.aws.es.DescribeElasticsearchDomainResponse/DomainStatus
  :cognitect.aws.es/ElasticsearchDomainStatus)

(s/def :cognitect.aws.es.UpgradeElasticsearchDomainRequest/DomainName :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.UpgradeElasticsearchDomainRequest/TargetVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def
  :cognitect.aws.es.UpgradeElasticsearchDomainRequest/PerformCheckOnly
  :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.DescribeElasticsearchDomainsResponse/DomainStatusList
  :cognitect.aws.es/ElasticsearchDomainStatusList)

(s/def :cognitect.aws.es.RemoveTagsRequest/ARN :cognitect.aws.es/ARN)

(s/def :cognitect.aws.es.RemoveTagsRequest/TagKeys :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.EBSOptionsStatus/Options :cognitect.aws.es/EBSOptions)

(s/def :cognitect.aws.es.EBSOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/ElasticsearchClusterConfig
  :cognitect.aws.es/ElasticsearchClusterConfigStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/AdvancedOptions
  :cognitect.aws.es/AdvancedOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/ElasticsearchVersion
  :cognitect.aws.es/ElasticsearchVersionStatus)

(s/def :cognitect.aws.es.ElasticsearchDomainConfig/EBSOptions :cognitect.aws.es/EBSOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/NodeToNodeEncryptionOptions
  :cognitect.aws.es/NodeToNodeEncryptionOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/EncryptionAtRestOptions
  :cognitect.aws.es/EncryptionAtRestOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/AdvancedSecurityOptions
  :cognitect.aws.es/AdvancedSecurityOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/AccessPolicies
  :cognitect.aws.es/AccessPoliciesStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/VPCOptions
  :cognitect.aws.es/VPCDerivedInfoStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/DomainEndpointOptions
  :cognitect.aws.es/DomainEndpointOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/SnapshotOptions
  :cognitect.aws.es/SnapshotOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/CognitoOptions
  :cognitect.aws.es/CognitoOptionsStatus)

(s/def
  :cognitect.aws.es.ElasticsearchDomainConfig/LogPublishingOptions
  :cognitect.aws.es/LogPublishingOptionsStatus)

(s/def
  :cognitect.aws.es.NodeToNodeEncryptionOptionsStatus/Options
  :cognitect.aws.es/NodeToNodeEncryptionOptions)

(s/def :cognitect.aws.es.NodeToNodeEncryptionOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.ListDomainsForPackageRequest/PackageID :cognitect.aws.es/PackageID)

(s/def :cognitect.aws.es.ListDomainsForPackageRequest/MaxResults :cognitect.aws.es/MaxResults)

(s/def :cognitect.aws.es.ListDomainsForPackageRequest/NextToken :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.ListElasticsearchVersionsRequest/MaxResults :cognitect.aws.es/MaxResults)

(s/def :cognitect.aws.es.ListElasticsearchVersionsRequest/NextToken :cognitect.aws.es/NextToken)

(s/def
  :cognitect.aws.es.StartElasticsearchServiceSoftwareUpdateResponse/ServiceSoftwareOptions
  :cognitect.aws.es/ServiceSoftwareOptions)

(s/def :cognitect.aws.es.DescribePackagesFilter/Name :cognitect.aws.es/DescribePackagesFilterName)

(s/def
  :cognitect.aws.es.DescribePackagesFilter/Value
  :cognitect.aws.es/DescribePackagesFilterValues)

(s/def
  :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/ReservedElasticsearchInstanceOfferingId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/ReservationName
  :cognitect.aws.es/ReservationToken)

(s/def
  :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingRequest/InstanceCount
  :cognitect.aws.es/InstanceCount)

(s/def
  :cognitect.aws.es.AdvancedSecurityOptionsStatus/Options
  :cognitect.aws.es/AdvancedSecurityOptions)

(s/def :cognitect.aws.es.AdvancedSecurityOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.CompatibleVersionsMap/SourceVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def
  :cognitect.aws.es.CompatibleVersionsMap/TargetVersions
  :cognitect.aws.es/ElasticsearchVersionList)

(s/def
  :cognitect.aws.es.ElasticsearchVersionStatus/Options
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def :cognitect.aws.es.ElasticsearchVersionStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/ZoneAwarenessConfig
  :cognitect.aws.es/ZoneAwarenessConfig)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/InstanceType
  :cognitect.aws.es/ESPartitionInstanceType)

(s/def :cognitect.aws.es.ElasticsearchClusterConfig/ZoneAwarenessEnabled :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.ElasticsearchClusterConfig/WarmEnabled :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterCount
  :cognitect.aws.es/IntegerClass)

(s/def :cognitect.aws.es.ElasticsearchClusterConfig/WarmCount :cognitect.aws.es/IntegerClass)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterEnabled
  :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/WarmType
  :cognitect.aws.es/ESWarmPartitionInstanceType)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfig/DedicatedMasterType
  :cognitect.aws.es/ESPartitionInstanceType)

(s/def :cognitect.aws.es.ElasticsearchClusterConfig/InstanceCount :cognitect.aws.es/IntegerClass)

(s/def :cognitect.aws.es.DeletePackageResponse/PackageDetails :cognitect.aws.es/PackageDetails)

(s/def :cognitect.aws.es.UpgradeElasticsearchDomainResponse/DomainName :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.UpgradeElasticsearchDomainResponse/TargetVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def
  :cognitect.aws.es.UpgradeElasticsearchDomainResponse/PerformCheckOnly
  :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.DescribeElasticsearchDomainsRequest/DomainNames
  :cognitect.aws.es/DomainNameList)

(s/def
  :cognitect.aws.es.DescribePackagesResponse/PackageDetailsList
  :cognitect.aws.es/PackageDetailsList)

(s/def :cognitect.aws.es.DescribePackagesResponse/NextToken :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.GetCompatibleElasticsearchVersionsRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.ListPackagesForDomainRequest/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.ListPackagesForDomainRequest/MaxResults :cognitect.aws.es/MaxResults)

(s/def :cognitect.aws.es.ListPackagesForDomainRequest/NextToken :cognitect.aws.es/NextToken)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesResponse/ElasticsearchInstanceTypes
  :cognitect.aws.es/ElasticsearchInstanceTypeList)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesResponse/NextToken
  :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.AdvancedOptionsStatus/Options :cognitect.aws.es/AdvancedOptions)

(s/def :cognitect.aws.es.AdvancedOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def
  :cognitect.aws.es.DescribeElasticsearchDomainConfigRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/Endpoint :cognitect.aws.es/ServiceUrl)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/DomainId :cognitect.aws.es/DomainId)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/ElasticsearchClusterConfig
  :cognitect.aws.es/ElasticsearchClusterConfig)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/Processing :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/AdvancedOptions
  :cognitect.aws.es/AdvancedOptions)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/ElasticsearchVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/EBSOptions :cognitect.aws.es/EBSOptions)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/NodeToNodeEncryptionOptions
  :cognitect.aws.es/NodeToNodeEncryptionOptions)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/Deleted :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/ServiceSoftwareOptions
  :cognitect.aws.es/ServiceSoftwareOptions)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/EncryptionAtRestOptions
  :cognitect.aws.es/EncryptionAtRestOptions)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/AdvancedSecurityOptions
  :cognitect.aws.es/AdvancedSecurityOptions)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/ARN :cognitect.aws.es/ARN)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/AccessPolicies :cognitect.aws.es/PolicyDocument)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/VPCOptions :cognitect.aws.es/VPCDerivedInfo)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/DomainEndpointOptions
  :cognitect.aws.es/DomainEndpointOptions)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/Endpoints :cognitect.aws.es/EndpointsMap)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/SnapshotOptions
  :cognitect.aws.es/SnapshotOptions)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/Created :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/CognitoOptions :cognitect.aws.es/CognitoOptions)

(s/def :cognitect.aws.es.ElasticsearchDomainStatus/UpgradeProcessing :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.ElasticsearchDomainStatus/LogPublishingOptions
  :cognitect.aws.es/LogPublishingOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/ElasticsearchClusterConfig
  :cognitect.aws.es/ElasticsearchClusterConfig)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/AdvancedOptions
  :cognitect.aws.es/AdvancedOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/EBSOptions
  :cognitect.aws.es/EBSOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/AdvancedSecurityOptions
  :cognitect.aws.es/AdvancedSecurityOptionsInput)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/AccessPolicies
  :cognitect.aws.es/PolicyDocument)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/VPCOptions
  :cognitect.aws.es/VPCOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/DomainEndpointOptions
  :cognitect.aws.es/DomainEndpointOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/SnapshotOptions
  :cognitect.aws.es/SnapshotOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/CognitoOptions
  :cognitect.aws.es/CognitoOptions)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigRequest/LogPublishingOptions
  :cognitect.aws.es/LogPublishingOptions)

(s/def
  :cognitect.aws.es.ElasticsearchClusterConfigStatus/Options
  :cognitect.aws.es/ElasticsearchClusterConfig)

(s/def :cognitect.aws.es.ElasticsearchClusterConfigStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.ErrorDetails/ErrorType :cognitect.aws.es/ErrorType)

(s/def :cognitect.aws.es.ErrorDetails/ErrorMessage :cognitect.aws.es/ErrorMessage)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/ElasticsearchVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/MaxResults
  :cognitect.aws.es/MaxResults)

(s/def
  :cognitect.aws.es.ListElasticsearchInstanceTypesRequest/NextToken
  :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.AssociatePackageRequest/PackageID :cognitect.aws.es/PackageID)

(s/def :cognitect.aws.es.AssociatePackageRequest/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.EBSOptions/EBSEnabled :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.EBSOptions/VolumeType :cognitect.aws.es/VolumeType)

(s/def :cognitect.aws.es.EBSOptions/VolumeSize :cognitect.aws.es/IntegerClass)

(s/def :cognitect.aws.es.EBSOptions/Iops :cognitect.aws.es/IntegerClass)

(s/def :cognitect.aws.es.AddTagsRequest/ARN :cognitect.aws.es/ARN)

(s/def :cognitect.aws.es.AddTagsRequest/TagList :cognitect.aws.es/TagList)

(s/def :cognitect.aws.es.CreateElasticsearchDomainRequest/DomainName :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/ElasticsearchClusterConfig
  :cognitect.aws.es/ElasticsearchClusterConfig)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/AdvancedOptions
  :cognitect.aws.es/AdvancedOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/ElasticsearchVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def :cognitect.aws.es.CreateElasticsearchDomainRequest/EBSOptions :cognitect.aws.es/EBSOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/NodeToNodeEncryptionOptions
  :cognitect.aws.es/NodeToNodeEncryptionOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/EncryptionAtRestOptions
  :cognitect.aws.es/EncryptionAtRestOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/AdvancedSecurityOptions
  :cognitect.aws.es/AdvancedSecurityOptionsInput)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/AccessPolicies
  :cognitect.aws.es/PolicyDocument)

(s/def :cognitect.aws.es.CreateElasticsearchDomainRequest/VPCOptions :cognitect.aws.es/VPCOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/DomainEndpointOptions
  :cognitect.aws.es/DomainEndpointOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/SnapshotOptions
  :cognitect.aws.es/SnapshotOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/CognitoOptions
  :cognitect.aws.es/CognitoOptions)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainRequest/LogPublishingOptions
  :cognitect.aws.es/LogPublishingOptions)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstancesResponse/NextToken
  :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstancesResponse/ReservedElasticsearchInstances
  :cognitect.aws.es/ReservedElasticsearchInstanceList)

(s/def :cognitect.aws.es.DeleteElasticsearchDomainRequest/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.ListDomainNamesResponse/DomainNames :cognitect.aws.es/DomainInfoList)

(s/def
  :cognitect.aws.es.CancelElasticsearchServiceSoftwareUpdateRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.NodeToNodeEncryptionOptions/Enabled :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/ReservedElasticsearchInstanceId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/MaxResults
  :cognitect.aws.es/MaxResults)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstancesRequest/NextToken
  :cognitect.aws.es/NextToken)

(s/def
  :cognitect.aws.es.DescribePackagesRequest/Filters
  :cognitect.aws.es/DescribePackagesFilterList)

(s/def :cognitect.aws.es.DescribePackagesRequest/MaxResults :cognitect.aws.es/MaxResults)

(s/def :cognitect.aws.es.DescribePackagesRequest/NextToken :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.GetUpgradeHistoryRequest/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.GetUpgradeHistoryRequest/MaxResults :cognitect.aws.es/MaxResults)

(s/def :cognitect.aws.es.GetUpgradeHistoryRequest/NextToken :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.ListTagsResponse/TagList :cognitect.aws.es/TagList)

(s/def :cognitect.aws.es.VPCDerivedInfo/VPCId :cognitect.aws.es/String)

(s/def :cognitect.aws.es.VPCDerivedInfo/SubnetIds :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.VPCDerivedInfo/AvailabilityZones :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.VPCDerivedInfo/SecurityGroupIds :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.UpgradeStepItem/UpgradeStep :cognitect.aws.es/UpgradeStep)

(s/def :cognitect.aws.es.UpgradeStepItem/UpgradeStepStatus :cognitect.aws.es/UpgradeStatus)

(s/def :cognitect.aws.es.UpgradeStepItem/Issues :cognitect.aws.es/Issues)

(s/def :cognitect.aws.es.UpgradeStepItem/ProgressPercent :cognitect.aws.es/Double)

(s/def
  :cognitect.aws.es.LogPublishingOption/CloudWatchLogsLogGroupArn
  :cognitect.aws.es/CloudWatchLogsLogGroupArn)

(s/def :cognitect.aws.es.LogPublishingOption/Enabled :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.GetUpgradeStatusResponse/UpgradeStep :cognitect.aws.es/UpgradeStep)

(s/def :cognitect.aws.es.GetUpgradeStatusResponse/StepStatus :cognitect.aws.es/UpgradeStatus)

(s/def :cognitect.aws.es.GetUpgradeStatusResponse/UpgradeName :cognitect.aws.es/UpgradeName)

(s/def :cognitect.aws.es.DissociatePackageRequest/PackageID :cognitect.aws.es/PackageID)

(s/def :cognitect.aws.es.DissociatePackageRequest/DomainName :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/RecurringCharges
  :cognitect.aws.es/RecurringChargeList)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/CurrencyCode :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/ReservationName
  :cognitect.aws.es/ReservationToken)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/FixedPrice :cognitect.aws.es/Double)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/PaymentOption
  :cognitect.aws.es/ReservedElasticsearchInstancePaymentOption)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/StartTime :cognitect.aws.es/UpdateTimestamp)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/ReservedElasticsearchInstanceOfferingId
  :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/ElasticsearchInstanceType
  :cognitect.aws.es/ESPartitionInstanceType)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/Duration :cognitect.aws.es/Integer)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/UsagePrice :cognitect.aws.es/Double)

(s/def :cognitect.aws.es.ReservedElasticsearchInstance/State :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/ReservedElasticsearchInstanceId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstance/ElasticsearchInstanceCount
  :cognitect.aws.es/Integer)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstanceOffering/ReservedElasticsearchInstanceOfferingId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstanceOffering/ElasticsearchInstanceType
  :cognitect.aws.es/ESPartitionInstanceType)

(s/def :cognitect.aws.es.ReservedElasticsearchInstanceOffering/Duration :cognitect.aws.es/Integer)

(s/def :cognitect.aws.es.ReservedElasticsearchInstanceOffering/FixedPrice :cognitect.aws.es/Double)

(s/def :cognitect.aws.es.ReservedElasticsearchInstanceOffering/UsagePrice :cognitect.aws.es/Double)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstanceOffering/CurrencyCode
  :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstanceOffering/PaymentOption
  :cognitect.aws.es/ReservedElasticsearchInstancePaymentOption)

(s/def
  :cognitect.aws.es.ReservedElasticsearchInstanceOffering/RecurringCharges
  :cognitect.aws.es/RecurringChargeList)

(s/def :cognitect.aws.es.OptionStatus/CreationDate :cognitect.aws.es/UpdateTimestamp)

(s/def :cognitect.aws.es.OptionStatus/UpdateDate :cognitect.aws.es/UpdateTimestamp)

(s/def :cognitect.aws.es.OptionStatus/UpdateVersion :cognitect.aws.es/UIntValue)

(s/def :cognitect.aws.es.OptionStatus/State :cognitect.aws.es/OptionState)

(s/def :cognitect.aws.es.OptionStatus/PendingDeletion :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.CreatePackageRequest/PackageName :cognitect.aws.es/PackageName)

(s/def :cognitect.aws.es.CreatePackageRequest/PackageType :cognitect.aws.es/PackageType)

(s/def
  :cognitect.aws.es.CreatePackageRequest/PackageDescription
  :cognitect.aws.es/PackageDescription)

(s/def :cognitect.aws.es.CreatePackageRequest/PackageSource :cognitect.aws.es/PackageSource)

(s/def :cognitect.aws.es.GetUpgradeStatusRequest/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.StorageTypeLimit/LimitName :cognitect.aws.es/LimitName)

(s/def :cognitect.aws.es.StorageTypeLimit/LimitValues :cognitect.aws.es/LimitValueList)

(s/def
  :cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsResponse/LimitsByRole
  :cognitect.aws.es/LimitsByRole)

(s/def :cognitect.aws.es.MasterUserOptions/MasterUserARN :cognitect.aws.es/ARN)

(s/def :cognitect.aws.es.MasterUserOptions/MasterUserName :cognitect.aws.es/Username)

(s/def :cognitect.aws.es.MasterUserOptions/MasterUserPassword :cognitect.aws.es/Password)

(s/def :cognitect.aws.es.Limits/StorageTypes :cognitect.aws.es/StorageTypeList)

(s/def :cognitect.aws.es.Limits/InstanceLimits :cognitect.aws.es/InstanceLimits)

(s/def :cognitect.aws.es.Limits/AdditionalLimits :cognitect.aws.es/AdditionalLimitList)

(s/def
  :cognitect.aws.es.ListElasticsearchVersionsResponse/ElasticsearchVersions
  :cognitect.aws.es/ElasticsearchVersionList)

(s/def :cognitect.aws.es.ListElasticsearchVersionsResponse/NextToken :cognitect.aws.es/NextToken)

(s/def :cognitect.aws.es.VPCDerivedInfoStatus/Options :cognitect.aws.es/VPCDerivedInfo)

(s/def :cognitect.aws.es.VPCDerivedInfoStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.PackageDetails/PackageID :cognitect.aws.es/PackageID)

(s/def :cognitect.aws.es.PackageDetails/PackageName :cognitect.aws.es/PackageName)

(s/def :cognitect.aws.es.PackageDetails/PackageType :cognitect.aws.es/PackageType)

(s/def :cognitect.aws.es.PackageDetails/PackageDescription :cognitect.aws.es/PackageDescription)

(s/def :cognitect.aws.es.PackageDetails/PackageStatus :cognitect.aws.es/PackageStatus)

(s/def :cognitect.aws.es.PackageDetails/CreatedAt :cognitect.aws.es/CreatedAt)

(s/def :cognitect.aws.es.PackageDetails/ErrorDetails :cognitect.aws.es/ErrorDetails)

(s/def :cognitect.aws.es.PackageSource/S3BucketName :cognitect.aws.es/S3BucketName)

(s/def :cognitect.aws.es.PackageSource/S3Key :cognitect.aws.es/S3Key)

(s/def :cognitect.aws.es.RecurringCharge/RecurringChargeAmount :cognitect.aws.es/Double)

(s/def :cognitect.aws.es.RecurringCharge/RecurringChargeFrequency :cognitect.aws.es/String)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/CurrentVersion :cognitect.aws.es/String)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/NewVersion :cognitect.aws.es/String)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/UpdateAvailable :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/Cancellable :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/UpdateStatus :cognitect.aws.es/DeploymentStatus)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/Description :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.ServiceSoftwareOptions/AutomatedUpdateDate
  :cognitect.aws.es/DeploymentCloseDateTimeStamp)

(s/def :cognitect.aws.es.ServiceSoftwareOptions/OptionalDeployment :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.InstanceLimits/InstanceCountLimits :cognitect.aws.es/InstanceCountLimits)

(s/def :cognitect.aws.es.EncryptionAtRestOptions/Enabled :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.EncryptionAtRestOptions/KmsKeyId :cognitect.aws.es/KmsKeyId)

(s/def :cognitect.aws.es.AdvancedSecurityOptions/Enabled :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.AdvancedSecurityOptions/InternalUserDatabaseEnabled
  :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.CognitoOptionsStatus/Options :cognitect.aws.es/CognitoOptions)

(s/def :cognitect.aws.es.CognitoOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.SnapshotOptionsStatus/Options :cognitect.aws.es/SnapshotOptions)

(s/def :cognitect.aws.es.SnapshotOptionsStatus/Status :cognitect.aws.es/OptionStatus)

(s/def :cognitect.aws.es.CreatePackageResponse/PackageDetails :cognitect.aws.es/PackageDetails)

(s/def :cognitect.aws.es.VPCOptions/SubnetIds :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.VPCOptions/SecurityGroupIds :cognitect.aws.es/StringList)

(s/def :cognitect.aws.es.DomainEndpointOptions/EnforceHTTPS :cognitect.aws.es/Boolean)

(s/def
  :cognitect.aws.es.DomainEndpointOptions/TLSSecurityPolicy
  :cognitect.aws.es/TLSSecurityPolicy)

(s/def
  :cognitect.aws.es.CancelElasticsearchServiceSoftwareUpdateResponse/ServiceSoftwareOptions
  :cognitect.aws.es/ServiceSoftwareOptions)

(s/def :cognitect.aws.es.DomainPackageDetails/PackageID :cognitect.aws.es/PackageID)

(s/def :cognitect.aws.es.DomainPackageDetails/PackageName :cognitect.aws.es/PackageName)

(s/def :cognitect.aws.es.DomainPackageDetails/PackageType :cognitect.aws.es/PackageType)

(s/def :cognitect.aws.es.DomainPackageDetails/LastUpdated :cognitect.aws.es/LastUpdated)

(s/def :cognitect.aws.es.DomainPackageDetails/DomainName :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.DomainPackageDetails/DomainPackageStatus
  :cognitect.aws.es/DomainPackageStatus)

(s/def :cognitect.aws.es.DomainPackageDetails/ReferencePath :cognitect.aws.es/ReferencePath)

(s/def :cognitect.aws.es.DomainPackageDetails/ErrorDetails :cognitect.aws.es/ErrorDetails)

(s/def
  :cognitect.aws.es.AssociatePackageResponse/DomainPackageDetails
  :cognitect.aws.es/DomainPackageDetails)

(s/def
  :cognitect.aws.es.UpdateElasticsearchDomainConfigResponse/DomainConfig
  :cognitect.aws.es/ElasticsearchDomainConfig)

(s/def
  :cognitect.aws.es.CreateElasticsearchDomainResponse/DomainStatus
  :cognitect.aws.es/ElasticsearchDomainStatus)

(s/def :cognitect.aws.es.SnapshotOptions/AutomatedSnapshotStartHour :cognitect.aws.es/IntegerClass)

(s/def
  :cognitect.aws.es.DeleteElasticsearchDomainResponse/DomainStatus
  :cognitect.aws.es/ElasticsearchDomainStatus)

(s/def
  :cognitect.aws.es.ListPackagesForDomainResponse/DomainPackageDetailsList
  :cognitect.aws.es/DomainPackageDetailsList)

(s/def :cognitect.aws.es.ListPackagesForDomainResponse/NextToken :cognitect.aws.es/String)

(s/def
  :cognitect.aws.es.DissociatePackageResponse/DomainPackageDetails
  :cognitect.aws.es/DomainPackageDetails)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsResponse/NextToken
  :cognitect.aws.es/NextToken)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsResponse/ReservedElasticsearchInstanceOfferings
  :cognitect.aws.es/ReservedElasticsearchInstanceOfferingList)

(s/def :cognitect.aws.es.CognitoOptions/Enabled :cognitect.aws.es/Boolean)

(s/def :cognitect.aws.es.CognitoOptions/UserPoolId :cognitect.aws.es/UserPoolId)

(s/def :cognitect.aws.es.CognitoOptions/IdentityPoolId :cognitect.aws.es/IdentityPoolId)

(s/def :cognitect.aws.es.CognitoOptions/RoleArn :cognitect.aws.es/RoleArn)

(s/def :cognitect.aws.es.AdditionalLimit/LimitName :cognitect.aws.es/LimitName)

(s/def :cognitect.aws.es.AdditionalLimit/LimitValues :cognitect.aws.es/LimitValueList)

(s/def
  :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingResponse/ReservedElasticsearchInstanceId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.PurchaseReservedElasticsearchInstanceOfferingResponse/ReservationName
  :cognitect.aws.es/ReservationToken)

(s/def
  :cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/DomainName
  :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/InstanceType
  :cognitect.aws.es/ESPartitionInstanceType)

(s/def
  :cognitect.aws.es.DescribeElasticsearchInstanceTypeLimitsRequest/ElasticsearchVersion
  :cognitect.aws.es/ElasticsearchVersionString)

(s/def :cognitect.aws.es.StorageType/StorageTypeName :cognitect.aws.es/StorageTypeName)

(s/def :cognitect.aws.es.StorageType/StorageSubTypeName :cognitect.aws.es/StorageSubTypeName)

(s/def :cognitect.aws.es.StorageType/StorageTypeLimits :cognitect.aws.es/StorageTypeLimitList)

(s/def :cognitect.aws.es.DomainInfo/DomainName :cognitect.aws.es/DomainName)

(s/def
  :cognitect.aws.es.GetCompatibleElasticsearchVersionsResponse/CompatibleElasticsearchVersions
  :cognitect.aws.es/CompatibleElasticsearchVersionsList)

(s/def :cognitect.aws.es.DescribeElasticsearchDomainRequest/DomainName :cognitect.aws.es/DomainName)

(s/def :cognitect.aws.es.UpgradeHistory/UpgradeName :cognitect.aws.es/UpgradeName)

(s/def :cognitect.aws.es.UpgradeHistory/StartTimestamp :cognitect.aws.es/StartTimestamp)

(s/def :cognitect.aws.es.UpgradeHistory/UpgradeStatus :cognitect.aws.es/UpgradeStatus)

(s/def :cognitect.aws.es.UpgradeHistory/StepsList :cognitect.aws.es/UpgradeStepsList)

(s/def
  :cognitect.aws.es.GetUpgradeHistoryResponse/UpgradeHistories
  :cognitect.aws.es/UpgradeHistoryList)

(s/def :cognitect.aws.es.GetUpgradeHistoryResponse/NextToken :cognitect.aws.es/String)

(s/def :cognitect.aws.es.DeletePackageRequest/PackageID :cognitect.aws.es/PackageID)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/ReservedElasticsearchInstanceOfferingId
  :cognitect.aws.es/GUID)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/MaxResults
  :cognitect.aws.es/MaxResults)

(s/def
  :cognitect.aws.es.DescribeReservedElasticsearchInstanceOfferingsRequest/NextToken
  :cognitect.aws.es/NextToken)

(s/def
  :cognitect.aws.es.DescribeElasticsearchDomainConfigResponse/DomainConfig
  :cognitect.aws.es/ElasticsearchDomainConfig)

