;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.gamesparks.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.gamesparks/ListStagesResult
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ListStagesResult/Stages
     :cognitect.aws.gamesparks.ListStagesResult/NextToken]))

(s/def
  :cognitect.aws.gamesparks/DisconnectPlayerResult
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.DisconnectPlayerResult/DisconnectFailures
     :cognitect.aws.gamesparks.DisconnectPlayerResult/DisconnectSuccesses]))

(s/def
  :cognitect.aws.gamesparks/GameDetails
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.GameDetails/Created
     :cognitect.aws.gamesparks.GameDetails/Tags
     :cognitect.aws.gamesparks.GameDetails/Description
     :cognitect.aws.gamesparks.GameDetails/Arn
     :cognitect.aws.gamesparks.GameDetails/EnableTerminationProtection
     :cognitect.aws.gamesparks.GameDetails/State
     :cognitect.aws.gamesparks.GameDetails/Name
     :cognitect.aws.gamesparks.GameDetails/LastUpdated]))

(s/def
  :cognitect.aws.gamesparks/ListStageDeploymentsRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.ListStageDeploymentsRequest/GameName
     :cognitect.aws.gamesparks.ListStageDeploymentsRequest/StageName]
    :opt-un
    [:cognitect.aws.gamesparks.ListStageDeploymentsRequest/NextToken
     :cognitect.aws.gamesparks.ListStageDeploymentsRequest/MaxResults]))

(s/def
  :cognitect.aws.gamesparks/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.TagResourceRequest/ResourceArn
     :cognitect.aws.gamesparks.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.gamesparks/ResultCode
  (s/spec string? :gen #(s/gen #{"SUCCESS" "INVALID_ROLE_FAILURE" "UNSPECIFIED_FAILURE"})))

(s/def
  :cognitect.aws.gamesparks/ListExtensionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ListExtensionsRequest/NextToken
     :cognitect.aws.gamesparks.ListExtensionsRequest/MaxResults]))

(s/def
  :cognitect.aws.gamesparks/GetGeneratedCodeJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.GetGeneratedCodeJobRequest/GameName
     :cognitect.aws.gamesparks.GetGeneratedCodeJobRequest/JobId
     :cognitect.aws.gamesparks.GetGeneratedCodeJobRequest/SnapshotId]))

(s/def
  :cognitect.aws.gamesparks/StageSummaryList
  (s/coll-of :cognitect.aws.gamesparks/StageSummary))

(s/def
  :cognitect.aws.gamesparks/ListGeneratedCodeJobsResult
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ListGeneratedCodeJobsResult/NextToken
     :cognitect.aws.gamesparks.ListGeneratedCodeJobsResult/GeneratedCodeJobs]))

(s/def
  :cognitect.aws.gamesparks/StartStageDeploymentRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.StartStageDeploymentRequest/GameName
     :cognitect.aws.gamesparks.StartStageDeploymentRequest/SnapshotId
     :cognitect.aws.gamesparks.StartStageDeploymentRequest/StageName]
    :opt-un
    [:cognitect.aws.gamesparks.StartStageDeploymentRequest/ClientToken]))

(s/def
  :cognitect.aws.gamesparks/GameConfigurationDetails
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.GameConfigurationDetails/Created
     :cognitect.aws.gamesparks.GameConfigurationDetails/Sections
     :cognitect.aws.gamesparks.GameConfigurationDetails/LastUpdated]))

(s/def
  :cognitect.aws.gamesparks/GetGameResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.GetGameResult/Game]))

(s/def
  :cognitect.aws.gamesparks/SnapshotSummaryList
  (s/coll-of :cognitect.aws.gamesparks/SnapshotSummary))

(s/def
  :cognitect.aws.gamesparks/TagMap
  (s/map-of
    :cognitect.aws.gamesparks/TagKey
    :cognitect.aws.gamesparks/TagValue
    :min-count
    1
    :max-count
    50))

(s/def
  :cognitect.aws.gamesparks/S3PresignedUrl
  (s/spec
    #(re-matches (re-pattern "^https:\\/\\/(.*)\\.s3(.*)\\.amazonaws\\.com\\/(.*)$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/Path
  (s/spec #(re-matches (re-pattern "^\\/.*[^\\/]$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/DeleteStageRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.DeleteStageRequest/GameName
     :cognitect.aws.gamesparks.DeleteStageRequest/StageName]))

(s/def
  :cognitect.aws.gamesparks/ExtensionDescription
  (s/spec #(re-matches (re-pattern "^\\S(.*\\S)?$|^$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/ListGamesResult
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ListGamesResult/NextToken
     :cognitect.aws.gamesparks.ListGamesResult/Games]))

(s/def
  :cognitect.aws.gamesparks/RoleARN
  (s/spec
    #(re-matches (re-pattern "^arn:(aws[a-zA-Z-]*)?:iam::\\d{12}:role/.+$") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.gamesparks/StageState (s/spec string? :gen #(s/gen #{"DELETING" "ACTIVE"})))

(s/def
  :cognitect.aws.gamesparks/StartGeneratedCodeJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.StartGeneratedCodeJobRequest/GameName
     :cognitect.aws.gamesparks.StartGeneratedCodeJobRequest/Generator
     :cognitect.aws.gamesparks.StartGeneratedCodeJobRequest/SnapshotId]))

(s/def
  :cognitect.aws.gamesparks/ExportSnapshotResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.ExportSnapshotResult/S3Url]))

(s/def
  :cognitect.aws.gamesparks/ListStageDeploymentsResult
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ListStageDeploymentsResult/NextToken
     :cognitect.aws.gamesparks.ListStageDeploymentsResult/StageDeployments]))

(s/def :cognitect.aws.gamesparks/Message string?)

(s/def
  :cognitect.aws.gamesparks/Operation
  (s/spec string? :gen #(s/gen #{"ADD" "REMOVE" "REPLACE"})))

(s/def
  :cognitect.aws.gamesparks/ExtensionDetails
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ExtensionDetails/Description
     :cognitect.aws.gamesparks.ExtensionDetails/Namespace
     :cognitect.aws.gamesparks.ExtensionDetails/Name]))

(s/def
  :cognitect.aws.gamesparks/GetSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.GetSnapshotRequest/GameName
     :cognitect.aws.gamesparks.GetSnapshotRequest/SnapshotId]
    :opt-un
    [:cognitect.aws.gamesparks.GetSnapshotRequest/Sections]))

(s/def
  :cognitect.aws.gamesparks/UpdateGameRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.UpdateGameRequest/GameName]
    :opt-un
    [:cognitect.aws.gamesparks.UpdateGameRequest/Description]))

(s/def
  :cognitect.aws.gamesparks/DeploymentId
  (s/spec #(re-matches (re-pattern "^\\S(.*\\S)?$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/StageSummary
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.StageSummary/GameKey
     :cognitect.aws.gamesparks.StageSummary/Tags
     :cognitect.aws.gamesparks.StageSummary/Description
     :cognitect.aws.gamesparks.StageSummary/State
     :cognitect.aws.gamesparks.StageSummary/Name]))

(s/def :cognitect.aws.gamesparks/GameState (s/spec string? :gen #(s/gen #{"DELETING" "ACTIVE"})))

(s/def :cognitect.aws.gamesparks/DeleteGameResult (s/keys))

(s/def
  :cognitect.aws.gamesparks/ListGamesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ListGamesRequest/NextToken
     :cognitect.aws.gamesparks.ListGamesRequest/MaxResults]))

(s/def
  :cognitect.aws.gamesparks/CreateSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.CreateSnapshotRequest/GameName]
    :opt-un
    [:cognitect.aws.gamesparks.CreateSnapshotRequest/Description]))

(s/def
  :cognitect.aws.gamesparks/ExtensionVersionSchema
  (s/spec
    (s/and string? #(<= 0 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.gamesparks/ListExtensionsResult
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ListExtensionsResult/Extensions
     :cognitect.aws.gamesparks.ListExtensionsResult/NextToken]))

(s/def
  :cognitect.aws.gamesparks/Generator
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.Generator/TargetPlatform
     :cognitect.aws.gamesparks.Generator/Language
     :cognitect.aws.gamesparks.Generator/GameSdkVersion]))

(s/def
  :cognitect.aws.gamesparks/ListTagsForResourceResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.ListTagsForResourceResult/tags]))

(s/def
  :cognitect.aws.gamesparks/GetExtensionVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.GetExtensionVersionRequest/ExtensionVersion
     :cognitect.aws.gamesparks.GetExtensionVersionRequest/Name
     :cognitect.aws.gamesparks.GetExtensionVersionRequest/Namespace]))

(s/def
  :cognitect.aws.gamesparks/GameSdkVersion
  (s/spec
    #(re-matches (re-pattern "^((\\d|[1-9]\\d*)\\.(\\d|[0-9]\\d*)\\.(\\d|[0-9]\\d*)|LATEST)$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/GameDescription
  (s/spec #(re-matches (re-pattern "^\\S(.*\\S)?$|^$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/Sections
  (s/map-of :cognitect.aws.gamesparks/SectionName :cognitect.aws.gamesparks/Section))

(s/def
  :cognitect.aws.gamesparks/CreateGameResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.CreateGameResult/Game]))

(s/def
  :cognitect.aws.gamesparks/StageDeploymentDetails
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.StageDeploymentDetails/Created
     :cognitect.aws.gamesparks.StageDeploymentDetails/DeploymentResult
     :cognitect.aws.gamesparks.StageDeploymentDetails/DeploymentAction
     :cognitect.aws.gamesparks.StageDeploymentDetails/DeploymentState
     :cognitect.aws.gamesparks.StageDeploymentDetails/DeploymentId
     :cognitect.aws.gamesparks.StageDeploymentDetails/SnapshotId
     :cognitect.aws.gamesparks.StageDeploymentDetails/LastUpdated]))

(s/def
  :cognitect.aws.gamesparks/CreateGameRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.CreateGameRequest/GameName]
    :opt-un
    [:cognitect.aws.gamesparks.CreateGameRequest/Tags
     :cognitect.aws.gamesparks.CreateGameRequest/Description
     :cognitect.aws.gamesparks.CreateGameRequest/ClientToken]))

(s/def
  :cognitect.aws.gamesparks/GameKey
  (s/spec
    (s/and string? #(<= 1 (count %) 44))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 44) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.gamesparks/CreateStageResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.CreateStageResult/Stage]))

(s/def
  :cognitect.aws.gamesparks/ListSnapshotsRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.ListSnapshotsRequest/GameName]
    :opt-un
    [:cognitect.aws.gamesparks.ListSnapshotsRequest/NextToken
     :cognitect.aws.gamesparks.ListSnapshotsRequest/MaxResults]))

(s/def
  :cognitect.aws.gamesparks/SectionName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9.]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/LogGroupName
  (s/spec
    (s/and string? #(<= 1 (count %) 512))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 512) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.gamesparks/SnapshotDescription
  (s/spec #(re-matches (re-pattern "^\\S(.*\\S)?$|^$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/ExportSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.ExportSnapshotRequest/GameName
     :cognitect.aws.gamesparks.ExportSnapshotRequest/SnapshotId]))

(s/def
  :cognitect.aws.gamesparks/ExtensionNamespace
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/UpdateStageResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.UpdateStageResult/Stage]))

(s/def
  :cognitect.aws.gamesparks/UpdateGameResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.UpdateGameResult/Game]))

(s/def
  :cognitect.aws.gamesparks/NextToken
  (s/spec #(re-matches (re-pattern "^\\S(.*\\S)?$") %) :gen #(gen/string)))

(s/def :cognitect.aws.gamesparks/DeleteStageResult (s/keys))

(s/def
  :cognitect.aws.gamesparks/GetGameConfigurationResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.GetGameConfigurationResult/GameConfiguration]))

(s/def
  :cognitect.aws.gamesparks/GetSnapshotResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.GetSnapshotResult/Snapshot]))

(s/def
  :cognitect.aws.gamesparks/StageDetails
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.StageDetails/Created
     :cognitect.aws.gamesparks.StageDetails/GameKey
     :cognitect.aws.gamesparks.StageDetails/Tags
     :cognitect.aws.gamesparks.StageDetails/Role
     :cognitect.aws.gamesparks.StageDetails/Description
     :cognitect.aws.gamesparks.StageDetails/LogGroup
     :cognitect.aws.gamesparks.StageDetails/Arn
     :cognitect.aws.gamesparks.StageDetails/State
     :cognitect.aws.gamesparks.StageDetails/Name
     :cognitect.aws.gamesparks.StageDetails/LastUpdated]))

(s/def :cognitect.aws.gamesparks/GameSummaryList (s/coll-of :cognitect.aws.gamesparks/GameSummary))

(s/def
  :cognitect.aws.gamesparks/ExtensionVersionDetails
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ExtensionVersionDetails/Schema
     :cognitect.aws.gamesparks.ExtensionVersionDetails/Namespace
     :cognitect.aws.gamesparks.ExtensionVersionDetails/Version
     :cognitect.aws.gamesparks.ExtensionVersionDetails/Name]))

(s/def
  :cognitect.aws.gamesparks/GeneratedCodeJobDetailsList
  (s/coll-of :cognitect.aws.gamesparks/GeneratedCodeJobDetails))

(s/def
  :cognitect.aws.gamesparks/DisconnectPlayerRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.DisconnectPlayerRequest/GameName
     :cognitect.aws.gamesparks.DisconnectPlayerRequest/PlayerId
     :cognitect.aws.gamesparks.DisconnectPlayerRequest/StageName]))

(s/def
  :cognitect.aws.gamesparks/GetGameRequest
  (s/keys :req-un [:cognitect.aws.gamesparks.GetGameRequest/GameName]))

(s/def
  :cognitect.aws.gamesparks/PlayerId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/TagValue
  (s/spec #(re-matches (re-pattern "^[\\s\\w+-=\\.:/@]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/RawGameConfigurationData
  (s/spec
    (s/or
      :byte-array
      (s/and bytes? #(<= 10 (count %) 1024000))
      :input-stream
      #(instance? java.io.InputStream %))
    :gen
    (fn []
      (gen/bind
        (gen/choose (or 10 0) (or 1024000 100))
        #(gen/return (byte-array % (repeatedly (fn [] (rand-int 256)))))))))

(s/def
  :cognitect.aws.gamesparks/StageDeploymentSummary
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.StageDeploymentSummary/DeploymentResult
     :cognitect.aws.gamesparks.StageDeploymentSummary/DeploymentAction
     :cognitect.aws.gamesparks.StageDeploymentSummary/DeploymentState
     :cognitect.aws.gamesparks.StageDeploymentSummary/DeploymentId
     :cognitect.aws.gamesparks.StageDeploymentSummary/SnapshotId
     :cognitect.aws.gamesparks.StageDeploymentSummary/LastUpdated]))

(s/def
  :cognitect.aws.gamesparks/SectionModificationList
  (s/coll-of :cognitect.aws.gamesparks/SectionModification :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.gamesparks/CreateSnapshotResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.CreateSnapshotResult/Snapshot]))

(s/def
  :cognitect.aws.gamesparks/ExtensionName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/SectionList
  (s/coll-of :cognitect.aws.gamesparks/SectionName :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.gamesparks/ListSnapshotsResult
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ListSnapshotsResult/Snapshots
     :cognitect.aws.gamesparks.ListSnapshotsResult/NextToken]))

(s/def
  :cognitect.aws.gamesparks/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.gamesparks.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.gamesparks/ImportGameConfigurationResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.ImportGameConfigurationResult/GameConfiguration]))

(s/def
  :cognitect.aws.gamesparks/GetPlayerConnectionStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.GetPlayerConnectionStatusRequest/GameName
     :cognitect.aws.gamesparks.GetPlayerConnectionStatusRequest/PlayerId
     :cognitect.aws.gamesparks.GetPlayerConnectionStatusRequest/StageName]))

(s/def
  :cognitect.aws.gamesparks/ListExtensionVersionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.ListExtensionVersionsRequest/Name
     :cognitect.aws.gamesparks.ListExtensionVersionsRequest/Namespace]
    :opt-un
    [:cognitect.aws.gamesparks.ListExtensionVersionsRequest/NextToken
     :cognitect.aws.gamesparks.ListExtensionVersionsRequest/MaxResults]))

(s/def
  :cognitect.aws.gamesparks/ListGeneratedCodeJobsRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.ListGeneratedCodeJobsRequest/GameName
     :cognitect.aws.gamesparks.ListGeneratedCodeJobsRequest/SnapshotId]
    :opt-un
    [:cognitect.aws.gamesparks.ListGeneratedCodeJobsRequest/NextToken
     :cognitect.aws.gamesparks.ListGeneratedCodeJobsRequest/MaxResults]))

(s/def
  :cognitect.aws.gamesparks/ByteSize
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.gamesparks/DeploymentResult
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.DeploymentResult/ResultCode
     :cognitect.aws.gamesparks.DeploymentResult/Message]))

(s/def
  :cognitect.aws.gamesparks/GetPlayerConnectionStatusResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.GetPlayerConnectionStatusResult/Connections]))

(s/def
  :cognitect.aws.gamesparks/DeploymentAction
  (s/spec string? :gen #(s/gen #{"DEPLOY" "UNDEPLOY"})))

(s/def
  :cognitect.aws.gamesparks/StageDescription
  (s/spec #(re-matches (re-pattern "^\\S(.*\\S)?$|^$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/CreateStageRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.CreateStageRequest/GameName
     :cognitect.aws.gamesparks.CreateStageRequest/Role
     :cognitect.aws.gamesparks.CreateStageRequest/StageName]
    :opt-un
    [:cognitect.aws.gamesparks.CreateStageRequest/Tags
     :cognitect.aws.gamesparks.CreateStageRequest/Description
     :cognitect.aws.gamesparks.CreateStageRequest/ClientToken]))

(s/def
  :cognitect.aws.gamesparks/GeneratedCodeJobDescription
  (s/spec #(re-matches (re-pattern "^\\S(.*\\S)?$|^$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/GeneratedCodeJobState
  (s/spec string? :gen #(s/gen #{"COMPLETED" "IN_PROGRESS" "PENDING" "FAILED"})))

(s/def
  :cognitect.aws.gamesparks/GetGameConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.GetGameConfigurationRequest/GameName]
    :opt-un
    [:cognitect.aws.gamesparks.GetGameConfigurationRequest/Sections]))

(s/def
  :cognitect.aws.gamesparks/SnapshotSummary
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.SnapshotSummary/Created
     :cognitect.aws.gamesparks.SnapshotSummary/Description
     :cognitect.aws.gamesparks.SnapshotSummary/Id
     :cognitect.aws.gamesparks.SnapshotSummary/LastUpdated]))

(s/def
  :cognitect.aws.gamesparks/GeneratedCodeJobId
  (s/spec
    #(re-matches (re-pattern "^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/ConnectionId
  (s/spec
    (s/and string? #(<= 1 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 36) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.gamesparks/DeploymentState
  (s/spec string? :gen #(s/gen #{"COMPLETED" "IN_PROGRESS" "PENDING" "FAILED"})))

(s/def :cognitect.aws.gamesparks/GameTerminationProtection boolean?)

(s/def :cognitect.aws.gamesparks/ConnectionList (s/coll-of :cognitect.aws.gamesparks/Connection))

(s/def
  :cognitect.aws.gamesparks/GetExtensionResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.GetExtensionResult/Extension]))

(s/def
  :cognitect.aws.gamesparks/TargetPlatform
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/Section
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.Section/Attributes
     :cognitect.aws.gamesparks.Section/Size
     :cognitect.aws.gamesparks.Section/Name]))

(s/def
  :cognitect.aws.gamesparks/GeneratedCodeJobDetails
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.GeneratedCodeJobDetails/ExpirationTime
     :cognitect.aws.gamesparks.GeneratedCodeJobDetails/Status
     :cognitect.aws.gamesparks.GeneratedCodeJobDetails/Description
     :cognitect.aws.gamesparks.GeneratedCodeJobDetails/S3Url
     :cognitect.aws.gamesparks.GeneratedCodeJobDetails/GeneratedCodeJobId]))

(s/def
  :cognitect.aws.gamesparks/ExtensionDetailsList
  (s/coll-of :cognitect.aws.gamesparks/ExtensionDetails))

(s/def
  :cognitect.aws.gamesparks/ExtensionVersion
  (s/spec
    (s/and string? #(<= 0 (count %) 20))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 20) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.gamesparks/ImportGameConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.ImportGameConfigurationRequest/GameName
     :cognitect.aws.gamesparks.ImportGameConfigurationRequest/ImportSource]))

(s/def
  :cognitect.aws.gamesparks/ARN
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9:_/-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/StartGeneratedCodeJobResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.StartGeneratedCodeJobResult/GeneratedCodeJobId]))

(s/def
  :cognitect.aws.gamesparks/MaxResults
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.gamesparks/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.UntagResourceRequest/ResourceArn
     :cognitect.aws.gamesparks.UntagResourceRequest/tagKeys]))

(s/def
  :cognitect.aws.gamesparks/TagKey
  (s/spec #(re-matches (re-pattern "^(?!aws:)[a-zA-Z+-=._:/]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/UpdateSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.UpdateSnapshotRequest/GameName
     :cognitect.aws.gamesparks.UpdateSnapshotRequest/SnapshotId]
    :opt-un
    [:cognitect.aws.gamesparks.UpdateSnapshotRequest/Description]))

(s/def
  :cognitect.aws.gamesparks/GetExtensionVersionResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.GetExtensionVersionResult/ExtensionVersion]))

(s/def
  :cognitect.aws.gamesparks/DeleteGameRequest
  (s/keys :req-un [:cognitect.aws.gamesparks.DeleteGameRequest/GameName]))

(s/def :cognitect.aws.gamesparks/TagResourceResult (s/keys))

(s/def
  :cognitect.aws.gamesparks/ClientToken
  (s/spec
    (s/and string? #(<= 33 (count %) 126))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 33 126) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.gamesparks/UpdateSnapshotResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.UpdateSnapshotResult/Snapshot]))

(s/def
  :cognitect.aws.gamesparks/ConnectionIdList
  (s/coll-of :cognitect.aws.gamesparks/ConnectionId))

(s/def
  :cognitect.aws.gamesparks/GameName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/ResourceArn
  (s/spec #(re-matches (re-pattern "^arn:aws:gamesparks:") %) :gen #(gen/string)))

(s/def :cognitect.aws.gamesparks/UntagResourceResult (s/keys))

(s/def
  :cognitect.aws.gamesparks/StartStageDeploymentResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.StartStageDeploymentResult/StageDeployment]))

(s/def
  :cognitect.aws.gamesparks/Language
  (s/spec #(re-matches (re-pattern "^[a-zA-Z_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/ExtensionVersionDetailsList
  (s/coll-of :cognitect.aws.gamesparks/ExtensionVersionDetails))

(s/def
  :cognitect.aws.gamesparks/GetGeneratedCodeJobResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.GetGeneratedCodeJobResult/GeneratedCodeJob]))

(s/def
  :cognitect.aws.gamesparks/GetStageRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.GetStageRequest/GameName
     :cognitect.aws.gamesparks.GetStageRequest/StageName]))

(s/def
  :cognitect.aws.gamesparks/GameSummary
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.GameSummary/Tags
     :cognitect.aws.gamesparks.GameSummary/Description
     :cognitect.aws.gamesparks.GameSummary/State
     :cognitect.aws.gamesparks.GameSummary/Name]))

(s/def
  :cognitect.aws.gamesparks/UpdateGameConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.UpdateGameConfigurationRequest/GameName
     :cognitect.aws.gamesparks.UpdateGameConfigurationRequest/Modifications]))

(s/def :cognitect.aws.gamesparks/DateTime inst?)

(s/def
  :cognitect.aws.gamesparks/Connection
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.Connection/Created :cognitect.aws.gamesparks.Connection/Id]))

(s/def
  :cognitect.aws.gamesparks/ImportGameConfigurationSource
  (s/keys :req-un [:cognitect.aws.gamesparks.ImportGameConfigurationSource/File]))

(s/def
  :cognitect.aws.gamesparks/GetStageDeploymentRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.GetStageDeploymentRequest/GameName
     :cognitect.aws.gamesparks.GetStageDeploymentRequest/StageName]
    :opt-un
    [:cognitect.aws.gamesparks.GetStageDeploymentRequest/DeploymentId]))

(s/def
  :cognitect.aws.gamesparks/UpdateStageRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.UpdateStageRequest/GameName
     :cognitect.aws.gamesparks.UpdateStageRequest/StageName]
    :opt-un
    [:cognitect.aws.gamesparks.UpdateStageRequest/Role
     :cognitect.aws.gamesparks.UpdateStageRequest/Description]))

(s/def
  :cognitect.aws.gamesparks/StageName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/GetStageDeploymentResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.GetStageDeploymentResult/StageDeployment]))

(s/def
  :cognitect.aws.gamesparks/GetStageResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.GetStageResult/Stage]))

(s/def
  :cognitect.aws.gamesparks/ListExtensionVersionsResult
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.ListExtensionVersionsResult/NextToken
     :cognitect.aws.gamesparks.ListExtensionVersionsResult/ExtensionVersions]))

(s/def
  :cognitect.aws.gamesparks/GetExtensionRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.GetExtensionRequest/Name
     :cognitect.aws.gamesparks.GetExtensionRequest/Namespace]))

(s/def :cognitect.aws.gamesparks/Document (s/keys))

(s/def
  :cognitect.aws.gamesparks/SnapshotId
  (s/spec
    #(re-matches (re-pattern "^Snapshot_\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3,6}Z$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.gamesparks/SectionModification
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.SectionModification/Operation
     :cognitect.aws.gamesparks.SectionModification/Path
     :cognitect.aws.gamesparks.SectionModification/Section]
    :opt-un
    [:cognitect.aws.gamesparks.SectionModification/Value]))

(s/def
  :cognitect.aws.gamesparks/ListStagesRequest
  (s/keys
    :req-un
    [:cognitect.aws.gamesparks.ListStagesRequest/GameName]
    :opt-un
    [:cognitect.aws.gamesparks.ListStagesRequest/NextToken
     :cognitect.aws.gamesparks.ListStagesRequest/MaxResults]))

(s/def
  :cognitect.aws.gamesparks/StageDeploymentList
  (s/coll-of :cognitect.aws.gamesparks/StageDeploymentSummary))

(s/def
  :cognitect.aws.gamesparks/SnapshotDetails
  (s/keys
    :opt-un
    [:cognitect.aws.gamesparks.SnapshotDetails/Created
     :cognitect.aws.gamesparks.SnapshotDetails/Sections
     :cognitect.aws.gamesparks.SnapshotDetails/Description
     :cognitect.aws.gamesparks.SnapshotDetails/Id
     :cognitect.aws.gamesparks.SnapshotDetails/LastUpdated]))

(s/def
  :cognitect.aws.gamesparks/TagKeyList
  (s/coll-of :cognitect.aws.gamesparks/TagKey :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.gamesparks/UpdateGameConfigurationResult
  (s/keys :opt-un [:cognitect.aws.gamesparks.UpdateGameConfigurationResult/GameConfiguration]))

(s/def :cognitect.aws.gamesparks.ListStagesResult/NextToken :cognitect.aws.gamesparks/NextToken)

(s/def :cognitect.aws.gamesparks.ListStagesResult/Stages :cognitect.aws.gamesparks/StageSummaryList)

(s/def
  :cognitect.aws.gamesparks.DisconnectPlayerResult/DisconnectFailures
  :cognitect.aws.gamesparks/ConnectionIdList)

(s/def
  :cognitect.aws.gamesparks.DisconnectPlayerResult/DisconnectSuccesses
  :cognitect.aws.gamesparks/ConnectionIdList)

(s/def :cognitect.aws.gamesparks.GameDetails/Arn :cognitect.aws.gamesparks/ARN)

(s/def :cognitect.aws.gamesparks.GameDetails/Created :cognitect.aws.gamesparks/DateTime)

(s/def :cognitect.aws.gamesparks.GameDetails/Description :cognitect.aws.gamesparks/GameDescription)

(s/def
  :cognitect.aws.gamesparks.GameDetails/EnableTerminationProtection
  :cognitect.aws.gamesparks/GameTerminationProtection)

(s/def :cognitect.aws.gamesparks.GameDetails/LastUpdated :cognitect.aws.gamesparks/DateTime)

(s/def :cognitect.aws.gamesparks.GameDetails/Name :cognitect.aws.gamesparks/GameName)

(s/def :cognitect.aws.gamesparks.GameDetails/State :cognitect.aws.gamesparks/GameState)

(s/def :cognitect.aws.gamesparks.GameDetails/Tags :cognitect.aws.gamesparks/TagMap)

(s/def
  :cognitect.aws.gamesparks.ListStageDeploymentsRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.ListStageDeploymentsRequest/MaxResults
  :cognitect.aws.gamesparks/MaxResults)

(s/def
  :cognitect.aws.gamesparks.ListStageDeploymentsRequest/NextToken
  :cognitect.aws.gamesparks/NextToken)

(s/def
  :cognitect.aws.gamesparks.ListStageDeploymentsRequest/StageName
  :cognitect.aws.gamesparks/StageName)

(s/def
  :cognitect.aws.gamesparks.TagResourceRequest/ResourceArn
  :cognitect.aws.gamesparks/ResourceArn)

(s/def :cognitect.aws.gamesparks.TagResourceRequest/tags :cognitect.aws.gamesparks/TagMap)

(s/def
  :cognitect.aws.gamesparks.ListExtensionsRequest/MaxResults
  :cognitect.aws.gamesparks/MaxResults)

(s/def
  :cognitect.aws.gamesparks.ListExtensionsRequest/NextToken
  :cognitect.aws.gamesparks/NextToken)

(s/def
  :cognitect.aws.gamesparks.GetGeneratedCodeJobRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.GetGeneratedCodeJobRequest/JobId
  :cognitect.aws.gamesparks/GeneratedCodeJobId)

(s/def
  :cognitect.aws.gamesparks.GetGeneratedCodeJobRequest/SnapshotId
  :cognitect.aws.gamesparks/SnapshotId)

(s/def
  :cognitect.aws.gamesparks.ListGeneratedCodeJobsResult/GeneratedCodeJobs
  :cognitect.aws.gamesparks/GeneratedCodeJobDetailsList)

(s/def
  :cognitect.aws.gamesparks.ListGeneratedCodeJobsResult/NextToken
  :cognitect.aws.gamesparks/NextToken)

(s/def
  :cognitect.aws.gamesparks.StartStageDeploymentRequest/ClientToken
  :cognitect.aws.gamesparks/ClientToken)

(s/def
  :cognitect.aws.gamesparks.StartStageDeploymentRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.StartStageDeploymentRequest/SnapshotId
  :cognitect.aws.gamesparks/SnapshotId)

(s/def
  :cognitect.aws.gamesparks.StartStageDeploymentRequest/StageName
  :cognitect.aws.gamesparks/StageName)

(s/def
  :cognitect.aws.gamesparks.GameConfigurationDetails/Created
  :cognitect.aws.gamesparks/DateTime)

(s/def
  :cognitect.aws.gamesparks.GameConfigurationDetails/LastUpdated
  :cognitect.aws.gamesparks/DateTime)

(s/def
  :cognitect.aws.gamesparks.GameConfigurationDetails/Sections
  :cognitect.aws.gamesparks/Sections)

(s/def :cognitect.aws.gamesparks.GetGameResult/Game :cognitect.aws.gamesparks/GameDetails)

(s/def :cognitect.aws.gamesparks.DeleteStageRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def :cognitect.aws.gamesparks.DeleteStageRequest/StageName :cognitect.aws.gamesparks/StageName)

(s/def :cognitect.aws.gamesparks.ListGamesResult/Games :cognitect.aws.gamesparks/GameSummaryList)

(s/def :cognitect.aws.gamesparks.ListGamesResult/NextToken :cognitect.aws.gamesparks/NextToken)

(s/def
  :cognitect.aws.gamesparks.StartGeneratedCodeJobRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.StartGeneratedCodeJobRequest/Generator
  :cognitect.aws.gamesparks/Generator)

(s/def
  :cognitect.aws.gamesparks.StartGeneratedCodeJobRequest/SnapshotId
  :cognitect.aws.gamesparks/SnapshotId)

(s/def
  :cognitect.aws.gamesparks.ExportSnapshotResult/S3Url
  :cognitect.aws.gamesparks/S3PresignedUrl)

(s/def
  :cognitect.aws.gamesparks.ListStageDeploymentsResult/NextToken
  :cognitect.aws.gamesparks/NextToken)

(s/def
  :cognitect.aws.gamesparks.ListStageDeploymentsResult/StageDeployments
  :cognitect.aws.gamesparks/StageDeploymentList)

(s/def
  :cognitect.aws.gamesparks.ExtensionDetails/Description
  :cognitect.aws.gamesparks/ExtensionDescription)

(s/def :cognitect.aws.gamesparks.ExtensionDetails/Name :cognitect.aws.gamesparks/ExtensionName)

(s/def
  :cognitect.aws.gamesparks.ExtensionDetails/Namespace
  :cognitect.aws.gamesparks/ExtensionNamespace)

(s/def :cognitect.aws.gamesparks.GetSnapshotRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def :cognitect.aws.gamesparks.GetSnapshotRequest/Sections :cognitect.aws.gamesparks/SectionList)

(s/def :cognitect.aws.gamesparks.GetSnapshotRequest/SnapshotId :cognitect.aws.gamesparks/SnapshotId)

(s/def
  :cognitect.aws.gamesparks.UpdateGameRequest/Description
  :cognitect.aws.gamesparks/GameDescription)

(s/def :cognitect.aws.gamesparks.UpdateGameRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.StageSummary/Description
  :cognitect.aws.gamesparks/StageDescription)

(s/def :cognitect.aws.gamesparks.StageSummary/GameKey :cognitect.aws.gamesparks/GameKey)

(s/def :cognitect.aws.gamesparks.StageSummary/Name :cognitect.aws.gamesparks/StageName)

(s/def :cognitect.aws.gamesparks.StageSummary/State :cognitect.aws.gamesparks/StageState)

(s/def :cognitect.aws.gamesparks.StageSummary/Tags :cognitect.aws.gamesparks/TagMap)

(s/def :cognitect.aws.gamesparks.ListGamesRequest/MaxResults :cognitect.aws.gamesparks/MaxResults)

(s/def :cognitect.aws.gamesparks.ListGamesRequest/NextToken :cognitect.aws.gamesparks/NextToken)

(s/def
  :cognitect.aws.gamesparks.CreateSnapshotRequest/Description
  :cognitect.aws.gamesparks/SnapshotDescription)

(s/def :cognitect.aws.gamesparks.CreateSnapshotRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.ListExtensionsResult/Extensions
  :cognitect.aws.gamesparks/ExtensionDetailsList)

(s/def :cognitect.aws.gamesparks.ListExtensionsResult/NextToken :cognitect.aws.gamesparks/NextToken)

(s/def :cognitect.aws.gamesparks.Generator/GameSdkVersion :cognitect.aws.gamesparks/GameSdkVersion)

(s/def :cognitect.aws.gamesparks.Generator/Language :cognitect.aws.gamesparks/Language)

(s/def :cognitect.aws.gamesparks.Generator/TargetPlatform :cognitect.aws.gamesparks/TargetPlatform)

(s/def :cognitect.aws.gamesparks.ListTagsForResourceResult/tags :cognitect.aws.gamesparks/TagMap)

(s/def
  :cognitect.aws.gamesparks.GetExtensionVersionRequest/ExtensionVersion
  :cognitect.aws.gamesparks/ExtensionVersion)

(s/def
  :cognitect.aws.gamesparks.GetExtensionVersionRequest/Name
  :cognitect.aws.gamesparks/ExtensionName)

(s/def
  :cognitect.aws.gamesparks.GetExtensionVersionRequest/Namespace
  :cognitect.aws.gamesparks/ExtensionNamespace)

(s/def :cognitect.aws.gamesparks.CreateGameResult/Game :cognitect.aws.gamesparks/GameDetails)

(s/def :cognitect.aws.gamesparks.StageDeploymentDetails/Created :cognitect.aws.gamesparks/DateTime)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentDetails/DeploymentAction
  :cognitect.aws.gamesparks/DeploymentAction)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentDetails/DeploymentId
  :cognitect.aws.gamesparks/DeploymentId)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentDetails/DeploymentResult
  :cognitect.aws.gamesparks/DeploymentResult)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentDetails/DeploymentState
  :cognitect.aws.gamesparks/DeploymentState)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentDetails/LastUpdated
  :cognitect.aws.gamesparks/DateTime)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentDetails/SnapshotId
  :cognitect.aws.gamesparks/SnapshotId)

(s/def
  :cognitect.aws.gamesparks.CreateGameRequest/ClientToken
  :cognitect.aws.gamesparks/ClientToken)

(s/def
  :cognitect.aws.gamesparks.CreateGameRequest/Description
  :cognitect.aws.gamesparks/GameDescription)

(s/def :cognitect.aws.gamesparks.CreateGameRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def :cognitect.aws.gamesparks.CreateGameRequest/Tags :cognitect.aws.gamesparks/TagMap)

(s/def :cognitect.aws.gamesparks.CreateStageResult/Stage :cognitect.aws.gamesparks/StageDetails)

(s/def :cognitect.aws.gamesparks.ListSnapshotsRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.ListSnapshotsRequest/MaxResults
  :cognitect.aws.gamesparks/MaxResults)

(s/def :cognitect.aws.gamesparks.ListSnapshotsRequest/NextToken :cognitect.aws.gamesparks/NextToken)

(s/def :cognitect.aws.gamesparks.ExportSnapshotRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.ExportSnapshotRequest/SnapshotId
  :cognitect.aws.gamesparks/SnapshotId)

(s/def :cognitect.aws.gamesparks.UpdateStageResult/Stage :cognitect.aws.gamesparks/StageDetails)

(s/def :cognitect.aws.gamesparks.UpdateGameResult/Game :cognitect.aws.gamesparks/GameDetails)

(s/def
  :cognitect.aws.gamesparks.GetGameConfigurationResult/GameConfiguration
  :cognitect.aws.gamesparks/GameConfigurationDetails)

(s/def
  :cognitect.aws.gamesparks.GetSnapshotResult/Snapshot
  :cognitect.aws.gamesparks/SnapshotDetails)

(s/def :cognitect.aws.gamesparks.StageDetails/LastUpdated :cognitect.aws.gamesparks/DateTime)

(s/def :cognitect.aws.gamesparks.StageDetails/Tags :cognitect.aws.gamesparks/TagMap)

(s/def :cognitect.aws.gamesparks.StageDetails/GameKey :cognitect.aws.gamesparks/GameKey)

(s/def :cognitect.aws.gamesparks.StageDetails/LogGroup :cognitect.aws.gamesparks/LogGroupName)

(s/def :cognitect.aws.gamesparks.StageDetails/Arn :cognitect.aws.gamesparks/ARN)

(s/def :cognitect.aws.gamesparks.StageDetails/Name :cognitect.aws.gamesparks/StageName)

(s/def
  :cognitect.aws.gamesparks.StageDetails/Description
  :cognitect.aws.gamesparks/StageDescription)

(s/def :cognitect.aws.gamesparks.StageDetails/State :cognitect.aws.gamesparks/StageState)

(s/def :cognitect.aws.gamesparks.StageDetails/Role :cognitect.aws.gamesparks/RoleARN)

(s/def :cognitect.aws.gamesparks.StageDetails/Created :cognitect.aws.gamesparks/DateTime)

(s/def
  :cognitect.aws.gamesparks.ExtensionVersionDetails/Name
  :cognitect.aws.gamesparks/ExtensionName)

(s/def
  :cognitect.aws.gamesparks.ExtensionVersionDetails/Namespace
  :cognitect.aws.gamesparks/ExtensionNamespace)

(s/def
  :cognitect.aws.gamesparks.ExtensionVersionDetails/Schema
  :cognitect.aws.gamesparks/ExtensionVersionSchema)

(s/def
  :cognitect.aws.gamesparks.ExtensionVersionDetails/Version
  :cognitect.aws.gamesparks/ExtensionVersion)

(s/def
  :cognitect.aws.gamesparks.DisconnectPlayerRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.DisconnectPlayerRequest/PlayerId
  :cognitect.aws.gamesparks/PlayerId)

(s/def
  :cognitect.aws.gamesparks.DisconnectPlayerRequest/StageName
  :cognitect.aws.gamesparks/StageName)

(s/def :cognitect.aws.gamesparks.GetGameRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentSummary/DeploymentAction
  :cognitect.aws.gamesparks/DeploymentAction)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentSummary/DeploymentId
  :cognitect.aws.gamesparks/DeploymentId)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentSummary/DeploymentResult
  :cognitect.aws.gamesparks/DeploymentResult)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentSummary/DeploymentState
  :cognitect.aws.gamesparks/DeploymentState)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentSummary/LastUpdated
  :cognitect.aws.gamesparks/DateTime)

(s/def
  :cognitect.aws.gamesparks.StageDeploymentSummary/SnapshotId
  :cognitect.aws.gamesparks/SnapshotId)

(s/def
  :cognitect.aws.gamesparks.CreateSnapshotResult/Snapshot
  :cognitect.aws.gamesparks/SnapshotDetails)

(s/def :cognitect.aws.gamesparks.ListSnapshotsResult/NextToken :cognitect.aws.gamesparks/NextToken)

(s/def
  :cognitect.aws.gamesparks.ListSnapshotsResult/Snapshots
  :cognitect.aws.gamesparks/SnapshotSummaryList)

(s/def
  :cognitect.aws.gamesparks.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.gamesparks/ResourceArn)

(s/def
  :cognitect.aws.gamesparks.ImportGameConfigurationResult/GameConfiguration
  :cognitect.aws.gamesparks/GameConfigurationDetails)

(s/def
  :cognitect.aws.gamesparks.GetPlayerConnectionStatusRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.GetPlayerConnectionStatusRequest/PlayerId
  :cognitect.aws.gamesparks/PlayerId)

(s/def
  :cognitect.aws.gamesparks.GetPlayerConnectionStatusRequest/StageName
  :cognitect.aws.gamesparks/StageName)

(s/def
  :cognitect.aws.gamesparks.ListExtensionVersionsRequest/MaxResults
  :cognitect.aws.gamesparks/MaxResults)

(s/def
  :cognitect.aws.gamesparks.ListExtensionVersionsRequest/Name
  :cognitect.aws.gamesparks/ExtensionName)

(s/def
  :cognitect.aws.gamesparks.ListExtensionVersionsRequest/Namespace
  :cognitect.aws.gamesparks/ExtensionNamespace)

(s/def
  :cognitect.aws.gamesparks.ListExtensionVersionsRequest/NextToken
  :cognitect.aws.gamesparks/NextToken)

(s/def
  :cognitect.aws.gamesparks.ListGeneratedCodeJobsRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.ListGeneratedCodeJobsRequest/MaxResults
  :cognitect.aws.gamesparks/MaxResults)

(s/def
  :cognitect.aws.gamesparks.ListGeneratedCodeJobsRequest/NextToken
  :cognitect.aws.gamesparks/NextToken)

(s/def
  :cognitect.aws.gamesparks.ListGeneratedCodeJobsRequest/SnapshotId
  :cognitect.aws.gamesparks/SnapshotId)

(s/def :cognitect.aws.gamesparks.DeploymentResult/Message :cognitect.aws.gamesparks/Message)

(s/def :cognitect.aws.gamesparks.DeploymentResult/ResultCode :cognitect.aws.gamesparks/ResultCode)

(s/def
  :cognitect.aws.gamesparks.GetPlayerConnectionStatusResult/Connections
  :cognitect.aws.gamesparks/ConnectionList)

(s/def
  :cognitect.aws.gamesparks.CreateStageRequest/ClientToken
  :cognitect.aws.gamesparks/ClientToken)

(s/def
  :cognitect.aws.gamesparks.CreateStageRequest/Description
  :cognitect.aws.gamesparks/StageDescription)

(s/def :cognitect.aws.gamesparks.CreateStageRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def :cognitect.aws.gamesparks.CreateStageRequest/Role :cognitect.aws.gamesparks/RoleARN)

(s/def :cognitect.aws.gamesparks.CreateStageRequest/StageName :cognitect.aws.gamesparks/StageName)

(s/def :cognitect.aws.gamesparks.CreateStageRequest/Tags :cognitect.aws.gamesparks/TagMap)

(s/def
  :cognitect.aws.gamesparks.GetGameConfigurationRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.GetGameConfigurationRequest/Sections
  :cognitect.aws.gamesparks/SectionList)

(s/def :cognitect.aws.gamesparks.SnapshotSummary/Created :cognitect.aws.gamesparks/DateTime)

(s/def
  :cognitect.aws.gamesparks.SnapshotSummary/Description
  :cognitect.aws.gamesparks/SnapshotDescription)

(s/def :cognitect.aws.gamesparks.SnapshotSummary/Id :cognitect.aws.gamesparks/SnapshotId)

(s/def :cognitect.aws.gamesparks.SnapshotSummary/LastUpdated :cognitect.aws.gamesparks/DateTime)

(s/def
  :cognitect.aws.gamesparks.GetExtensionResult/Extension
  :cognitect.aws.gamesparks/ExtensionDetails)

(s/def :cognitect.aws.gamesparks.Section/Attributes :cognitect.aws.gamesparks/Document)

(s/def :cognitect.aws.gamesparks.Section/Name :cognitect.aws.gamesparks/SectionName)

(s/def :cognitect.aws.gamesparks.Section/Size :cognitect.aws.gamesparks/ByteSize)

(s/def
  :cognitect.aws.gamesparks.GeneratedCodeJobDetails/Description
  :cognitect.aws.gamesparks/GeneratedCodeJobDescription)

(s/def
  :cognitect.aws.gamesparks.GeneratedCodeJobDetails/ExpirationTime
  :cognitect.aws.gamesparks/DateTime)

(s/def
  :cognitect.aws.gamesparks.GeneratedCodeJobDetails/GeneratedCodeJobId
  :cognitect.aws.gamesparks/GeneratedCodeJobId)

(s/def
  :cognitect.aws.gamesparks.GeneratedCodeJobDetails/S3Url
  :cognitect.aws.gamesparks/S3PresignedUrl)

(s/def
  :cognitect.aws.gamesparks.GeneratedCodeJobDetails/Status
  :cognitect.aws.gamesparks/GeneratedCodeJobState)

(s/def
  :cognitect.aws.gamesparks.ImportGameConfigurationRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.ImportGameConfigurationRequest/ImportSource
  :cognitect.aws.gamesparks/ImportGameConfigurationSource)

(s/def
  :cognitect.aws.gamesparks.StartGeneratedCodeJobResult/GeneratedCodeJobId
  :cognitect.aws.gamesparks/GeneratedCodeJobId)

(s/def
  :cognitect.aws.gamesparks.UntagResourceRequest/ResourceArn
  :cognitect.aws.gamesparks/ResourceArn)

(s/def :cognitect.aws.gamesparks.UntagResourceRequest/tagKeys :cognitect.aws.gamesparks/TagKeyList)

(s/def
  :cognitect.aws.gamesparks.UpdateSnapshotRequest/Description
  :cognitect.aws.gamesparks/SnapshotDescription)

(s/def :cognitect.aws.gamesparks.UpdateSnapshotRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.UpdateSnapshotRequest/SnapshotId
  :cognitect.aws.gamesparks/SnapshotId)

(s/def
  :cognitect.aws.gamesparks.GetExtensionVersionResult/ExtensionVersion
  :cognitect.aws.gamesparks/ExtensionVersionDetails)

(s/def :cognitect.aws.gamesparks.DeleteGameRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.UpdateSnapshotResult/Snapshot
  :cognitect.aws.gamesparks/SnapshotDetails)

(s/def
  :cognitect.aws.gamesparks.StartStageDeploymentResult/StageDeployment
  :cognitect.aws.gamesparks/StageDeploymentDetails)

(s/def
  :cognitect.aws.gamesparks.GetGeneratedCodeJobResult/GeneratedCodeJob
  :cognitect.aws.gamesparks/GeneratedCodeJobDetails)

(s/def :cognitect.aws.gamesparks.GetStageRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def :cognitect.aws.gamesparks.GetStageRequest/StageName :cognitect.aws.gamesparks/StageName)

(s/def :cognitect.aws.gamesparks.GameSummary/Description :cognitect.aws.gamesparks/GameDescription)

(s/def :cognitect.aws.gamesparks.GameSummary/Name :cognitect.aws.gamesparks/GameName)

(s/def :cognitect.aws.gamesparks.GameSummary/State :cognitect.aws.gamesparks/GameState)

(s/def :cognitect.aws.gamesparks.GameSummary/Tags :cognitect.aws.gamesparks/TagMap)

(s/def
  :cognitect.aws.gamesparks.UpdateGameConfigurationRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.UpdateGameConfigurationRequest/Modifications
  :cognitect.aws.gamesparks/SectionModificationList)

(s/def :cognitect.aws.gamesparks.Connection/Created :cognitect.aws.gamesparks/DateTime)

(s/def :cognitect.aws.gamesparks.Connection/Id :cognitect.aws.gamesparks/ConnectionId)

(s/def
  :cognitect.aws.gamesparks.ImportGameConfigurationSource/File
  :cognitect.aws.gamesparks/RawGameConfigurationData)

(s/def
  :cognitect.aws.gamesparks.GetStageDeploymentRequest/DeploymentId
  :cognitect.aws.gamesparks/DeploymentId)

(s/def
  :cognitect.aws.gamesparks.GetStageDeploymentRequest/GameName
  :cognitect.aws.gamesparks/GameName)

(s/def
  :cognitect.aws.gamesparks.GetStageDeploymentRequest/StageName
  :cognitect.aws.gamesparks/StageName)

(s/def
  :cognitect.aws.gamesparks.UpdateStageRequest/Description
  :cognitect.aws.gamesparks/StageDescription)

(s/def :cognitect.aws.gamesparks.UpdateStageRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def :cognitect.aws.gamesparks.UpdateStageRequest/Role :cognitect.aws.gamesparks/RoleARN)

(s/def :cognitect.aws.gamesparks.UpdateStageRequest/StageName :cognitect.aws.gamesparks/StageName)

(s/def
  :cognitect.aws.gamesparks.GetStageDeploymentResult/StageDeployment
  :cognitect.aws.gamesparks/StageDeploymentDetails)

(s/def :cognitect.aws.gamesparks.GetStageResult/Stage :cognitect.aws.gamesparks/StageDetails)

(s/def
  :cognitect.aws.gamesparks.ListExtensionVersionsResult/ExtensionVersions
  :cognitect.aws.gamesparks/ExtensionVersionDetailsList)

(s/def
  :cognitect.aws.gamesparks.ListExtensionVersionsResult/NextToken
  :cognitect.aws.gamesparks/NextToken)

(s/def :cognitect.aws.gamesparks.GetExtensionRequest/Name :cognitect.aws.gamesparks/ExtensionName)

(s/def
  :cognitect.aws.gamesparks.GetExtensionRequest/Namespace
  :cognitect.aws.gamesparks/ExtensionNamespace)

(s/def :cognitect.aws.gamesparks.SectionModification/Operation :cognitect.aws.gamesparks/Operation)

(s/def :cognitect.aws.gamesparks.SectionModification/Path :cognitect.aws.gamesparks/Path)

(s/def :cognitect.aws.gamesparks.SectionModification/Section :cognitect.aws.gamesparks/SectionName)

(s/def :cognitect.aws.gamesparks.SectionModification/Value :cognitect.aws.gamesparks/Document)

(s/def :cognitect.aws.gamesparks.ListStagesRequest/GameName :cognitect.aws.gamesparks/GameName)

(s/def :cognitect.aws.gamesparks.ListStagesRequest/MaxResults :cognitect.aws.gamesparks/MaxResults)

(s/def :cognitect.aws.gamesparks.ListStagesRequest/NextToken :cognitect.aws.gamesparks/NextToken)

(s/def :cognitect.aws.gamesparks.SnapshotDetails/Created :cognitect.aws.gamesparks/DateTime)

(s/def
  :cognitect.aws.gamesparks.SnapshotDetails/Description
  :cognitect.aws.gamesparks/SnapshotDescription)

(s/def :cognitect.aws.gamesparks.SnapshotDetails/Id :cognitect.aws.gamesparks/SnapshotId)

(s/def :cognitect.aws.gamesparks.SnapshotDetails/LastUpdated :cognitect.aws.gamesparks/DateTime)

(s/def :cognitect.aws.gamesparks.SnapshotDetails/Sections :cognitect.aws.gamesparks/Sections)

(s/def
  :cognitect.aws.gamesparks.UpdateGameConfigurationResult/GameConfiguration
  :cognitect.aws.gamesparks/GameConfigurationDetails)

