;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.glacier.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.glacier/ListJobsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.ListJobsOutput/JobList :cognitect.aws.glacier.ListJobsOutput/Marker]))

(s/def
  :cognitect.aws.glacier/JobParameters
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.JobParameters/Tier
     :cognitect.aws.glacier.JobParameters/Type
     :cognitect.aws.glacier.JobParameters/ArchiveId
     :cognitect.aws.glacier.JobParameters/SNSTopic
     :cognitect.aws.glacier.JobParameters/Format
     :cognitect.aws.glacier.JobParameters/Description
     :cognitect.aws.glacier.JobParameters/InventoryRetrievalParameters
     :cognitect.aws.glacier.JobParameters/SelectParameters
     :cognitect.aws.glacier.JobParameters/OutputLocation
     :cognitect.aws.glacier.JobParameters/RetrievalByteRange]))

(s/def
  :cognitect.aws.glacier/GlacierJobDescription
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.GlacierJobDescription/Tier
     :cognitect.aws.glacier.GlacierJobDescription/JobOutputPath
     :cognitect.aws.glacier.GlacierJobDescription/CompletionDate
     :cognitect.aws.glacier.GlacierJobDescription/StatusCode
     :cognitect.aws.glacier.GlacierJobDescription/ArchiveId
     :cognitect.aws.glacier.GlacierJobDescription/StatusMessage
     :cognitect.aws.glacier.GlacierJobDescription/ArchiveSizeInBytes
     :cognitect.aws.glacier.GlacierJobDescription/SNSTopic
     :cognitect.aws.glacier.GlacierJobDescription/VaultARN
     :cognitect.aws.glacier.GlacierJobDescription/InventoryRetrievalParameters
     :cognitect.aws.glacier.GlacierJobDescription/ArchiveSHA256TreeHash
     :cognitect.aws.glacier.GlacierJobDescription/SelectParameters
     :cognitect.aws.glacier.GlacierJobDescription/SHA256TreeHash
     :cognitect.aws.glacier.GlacierJobDescription/CreationDate
     :cognitect.aws.glacier.GlacierJobDescription/InventorySizeInBytes
     :cognitect.aws.glacier.GlacierJobDescription/Completed
     :cognitect.aws.glacier.GlacierJobDescription/OutputLocation
     :cognitect.aws.glacier.GlacierJobDescription/Action
     :cognitect.aws.glacier.GlacierJobDescription/JobDescription
     :cognitect.aws.glacier.GlacierJobDescription/RetrievalByteRange
     :cognitect.aws.glacier.GlacierJobDescription/JobId]))

(s/def :cognitect.aws.glacier/VaultList (s/coll-of :cognitect.aws.glacier/DescribeVaultOutput))

(s/def
  :cognitect.aws.glacier/ListMultipartUploadsInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.ListMultipartUploadsInput/accountId
     :cognitect.aws.glacier.ListMultipartUploadsInput/vaultName]
    :opt-un
    [:cognitect.aws.glacier.ListMultipartUploadsInput/limit
     :cognitect.aws.glacier.ListMultipartUploadsInput/marker]))

(s/def
  :cognitect.aws.glacier/ListTagsForVaultInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.ListTagsForVaultInput/accountId
     :cognitect.aws.glacier.ListTagsForVaultInput/vaultName]))

(s/def
  :cognitect.aws.glacier/CompleteVaultLockInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.CompleteVaultLockInput/accountId
     :cognitect.aws.glacier.CompleteVaultLockInput/vaultName
     :cognitect.aws.glacier.CompleteVaultLockInput/lockId]))

(s/def
  :cognitect.aws.glacier/GetVaultLockInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.GetVaultLockInput/accountId
     :cognitect.aws.glacier.GetVaultLockInput/vaultName]))

(s/def
  :cognitect.aws.glacier/PartListElement
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.PartListElement/SHA256TreeHash
     :cognitect.aws.glacier.PartListElement/RangeInBytes]))

(s/def
  :cognitect.aws.glacier/InitiateJobOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.InitiateJobOutput/location
     :cognitect.aws.glacier.InitiateJobOutput/jobId
     :cognitect.aws.glacier.InitiateJobOutput/jobOutputPath]))

(s/def
  :cognitect.aws.glacier/InitiateJobInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.InitiateJobInput/accountId
     :cognitect.aws.glacier.InitiateJobInput/vaultName]
    :opt-un
    [:cognitect.aws.glacier.InitiateJobInput/jobParameters]))

(s/def
  :cognitect.aws.glacier/VaultNotificationConfig
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.VaultNotificationConfig/SNSTopic
     :cognitect.aws.glacier.VaultNotificationConfig/Events]))

(s/def
  :cognitect.aws.glacier/CreateVaultOutput
  (s/keys :opt-un [:cognitect.aws.glacier.CreateVaultOutput/location]))

(s/def
  :cognitect.aws.glacier/VaultLockPolicy
  (s/keys :opt-un [:cognitect.aws.glacier.VaultLockPolicy/Policy]))

(s/def :cognitect.aws.glacier/long (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.glacier/Encryption
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.Encryption/EncryptionType
     :cognitect.aws.glacier.Encryption/KMSKeyId
     :cognitect.aws.glacier.Encryption/KMSContext]))

(s/def
  :cognitect.aws.glacier/VaultAccessPolicy
  (s/keys :opt-un [:cognitect.aws.glacier.VaultAccessPolicy/Policy]))

(s/def
  :cognitect.aws.glacier/TagMap
  (s/map-of :cognitect.aws.glacier/TagKey :cognitect.aws.glacier/TagValue))

(s/def :cognitect.aws.glacier/PartList (s/coll-of :cognitect.aws.glacier/PartListElement))

(s/def
  :cognitect.aws.glacier/CannedACL
  (s/spec
    string?
    :gen
    #(s/gen
      #{"authenticated-read" "public-read-write" "bucket-owner-full-control" "private"
        "aws-exec-read" "bucket-owner-read" "public-read"})))

(s/def
  :cognitect.aws.glacier/DataRetrievalRule
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.DataRetrievalRule/Strategy
     :cognitect.aws.glacier.DataRetrievalRule/BytesPerHour]))

(s/def
  :cognitect.aws.glacier/ListPartsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.ListPartsOutput/Parts
     :cognitect.aws.glacier.ListPartsOutput/Marker
     :cognitect.aws.glacier.ListPartsOutput/MultipartUploadId
     :cognitect.aws.glacier.ListPartsOutput/VaultARN
     :cognitect.aws.glacier.ListPartsOutput/CreationDate
     :cognitect.aws.glacier.ListPartsOutput/ArchiveDescription
     :cognitect.aws.glacier.ListPartsOutput/PartSizeInBytes]))

(s/def
  :cognitect.aws.glacier/GetDataRetrievalPolicyOutput
  (s/keys :opt-un [:cognitect.aws.glacier.GetDataRetrievalPolicyOutput/Policy]))

(s/def
  :cognitect.aws.glacier/UploadMultipartPartInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.UploadMultipartPartInput/accountId
     :cognitect.aws.glacier.UploadMultipartPartInput/vaultName
     :cognitect.aws.glacier.UploadMultipartPartInput/uploadId]
    :opt-un
    [:cognitect.aws.glacier.UploadMultipartPartInput/range
     :cognitect.aws.glacier.UploadMultipartPartInput/body
     :cognitect.aws.glacier.UploadMultipartPartInput/checksum]))

(s/def
  :cognitect.aws.glacier/DescribeJobInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.DescribeJobInput/accountId
     :cognitect.aws.glacier.DescribeJobInput/vaultName
     :cognitect.aws.glacier.DescribeJobInput/jobId]))

(s/def :cognitect.aws.glacier/Size (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.glacier/ListJobsInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.ListJobsInput/accountId :cognitect.aws.glacier.ListJobsInput/vaultName]
    :opt-un
    [:cognitect.aws.glacier.ListJobsInput/statuscode
     :cognitect.aws.glacier.ListJobsInput/completed
     :cognitect.aws.glacier.ListJobsInput/limit
     :cognitect.aws.glacier.ListJobsInput/marker]))

(s/def
  :cognitect.aws.glacier/InitiateMultipartUploadInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.InitiateMultipartUploadInput/accountId
     :cognitect.aws.glacier.InitiateMultipartUploadInput/vaultName]
    :opt-un
    [:cognitect.aws.glacier.InitiateMultipartUploadInput/archiveDescription
     :cognitect.aws.glacier.InitiateMultipartUploadInput/partSize]))

(s/def
  :cognitect.aws.glacier/GetDataRetrievalPolicyInput
  (s/keys :req-un [:cognitect.aws.glacier.GetDataRetrievalPolicyInput/accountId]))

(s/def
  :cognitect.aws.glacier/Permission
  (s/spec string? :gen #(s/gen #{"WRITE" "FULL_CONTROL" "READ_ACP" "WRITE_ACP" "READ"})))

(s/def
  :cognitect.aws.glacier/DescribeVaultOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.DescribeVaultOutput/SizeInBytes
     :cognitect.aws.glacier.DescribeVaultOutput/VaultARN
     :cognitect.aws.glacier.DescribeVaultOutput/VaultName
     :cognitect.aws.glacier.DescribeVaultOutput/NumberOfArchives
     :cognitect.aws.glacier.DescribeVaultOutput/CreationDate
     :cognitect.aws.glacier.DescribeVaultOutput/LastInventoryDate]))

(s/def
  :cognitect.aws.glacier/InitiateVaultLockOutput
  (s/keys :opt-un [:cognitect.aws.glacier.InitiateVaultLockOutput/lockId]))

(s/def
  :cognitect.aws.glacier/UploadArchiveInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.UploadArchiveInput/vaultName
     :cognitect.aws.glacier.UploadArchiveInput/accountId]
    :opt-un
    [:cognitect.aws.glacier.UploadArchiveInput/body
     :cognitect.aws.glacier.UploadArchiveInput/archiveDescription
     :cognitect.aws.glacier.UploadArchiveInput/checksum]))

(s/def
  :cognitect.aws.glacier/InventoryRetrievalJobDescription
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.InventoryRetrievalJobDescription/EndDate
     :cognitect.aws.glacier.InventoryRetrievalJobDescription/Marker
     :cognitect.aws.glacier.InventoryRetrievalJobDescription/Limit
     :cognitect.aws.glacier.InventoryRetrievalJobDescription/Format
     :cognitect.aws.glacier.InventoryRetrievalJobDescription/StartDate]))

(s/def
  :cognitect.aws.glacier/httpstatus
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.glacier/ListPartsInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.ListPartsInput/accountId
     :cognitect.aws.glacier.ListPartsInput/vaultName
     :cognitect.aws.glacier.ListPartsInput/uploadId]
    :opt-un
    [:cognitect.aws.glacier.ListPartsInput/limit :cognitect.aws.glacier.ListPartsInput/marker]))

(s/def
  :cognitect.aws.glacier/SetVaultAccessPolicyInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.SetVaultAccessPolicyInput/accountId
     :cognitect.aws.glacier.SetVaultAccessPolicyInput/vaultName]
    :opt-un
    [:cognitect.aws.glacier.SetVaultAccessPolicyInput/policy]))

(s/def :cognitect.aws.glacier/UploadsList (s/coll-of :cognitect.aws.glacier/UploadListElement))

(s/def
  :cognitect.aws.glacier/AbortVaultLockInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.AbortVaultLockInput/accountId
     :cognitect.aws.glacier.AbortVaultLockInput/vaultName]))

(s/def
  :cognitect.aws.glacier/ProvisionedCapacityDescription
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.ProvisionedCapacityDescription/ExpirationDate
     :cognitect.aws.glacier.ProvisionedCapacityDescription/CapacityId
     :cognitect.aws.glacier.ProvisionedCapacityDescription/StartDate]))

(s/def
  :cognitect.aws.glacier/AbortMultipartUploadInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.AbortMultipartUploadInput/accountId
     :cognitect.aws.glacier.AbortMultipartUploadInput/vaultName
     :cognitect.aws.glacier.AbortMultipartUploadInput/uploadId]))

(s/def
  :cognitect.aws.glacier/InitiateVaultLockInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.InitiateVaultLockInput/accountId
     :cognitect.aws.glacier.InitiateVaultLockInput/vaultName]
    :opt-un
    [:cognitect.aws.glacier.InitiateVaultLockInput/policy]))

(s/def
  :cognitect.aws.glacier/S3Location
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.S3Location/Prefix
     :cognitect.aws.glacier.S3Location/AccessControlList
     :cognitect.aws.glacier.S3Location/CannedACL
     :cognitect.aws.glacier.S3Location/UserMetadata
     :cognitect.aws.glacier.S3Location/Encryption
     :cognitect.aws.glacier.S3Location/Tagging
     :cognitect.aws.glacier.S3Location/StorageClass
     :cognitect.aws.glacier.S3Location/BucketName]))

(s/def :cognitect.aws.glacier/ExpressionType (s/spec string? :gen #(s/gen #{"SQL"})))

(s/def
  :cognitect.aws.glacier/Grant
  (s/keys :opt-un [:cognitect.aws.glacier.Grant/Permission :cognitect.aws.glacier.Grant/Grantee]))

(s/def
  :cognitect.aws.glacier/DataRetrievalPolicy
  (s/keys :opt-un [:cognitect.aws.glacier.DataRetrievalPolicy/Rules]))

(s/def :cognitect.aws.glacier/string string?)

(s/def
  :cognitect.aws.glacier/CSVOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.CSVOutput/RecordDelimiter
     :cognitect.aws.glacier.CSVOutput/QuoteCharacter
     :cognitect.aws.glacier.CSVOutput/FieldDelimiter
     :cognitect.aws.glacier.CSVOutput/QuoteEscapeCharacter
     :cognitect.aws.glacier.CSVOutput/QuoteFields]))

(s/def
  :cognitect.aws.glacier/CSVInput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.CSVInput/Comments
     :cognitect.aws.glacier.CSVInput/RecordDelimiter
     :cognitect.aws.glacier.CSVInput/QuoteCharacter
     :cognitect.aws.glacier.CSVInput/FieldDelimiter
     :cognitect.aws.glacier.CSVInput/QuoteEscapeCharacter
     :cognitect.aws.glacier.CSVInput/FileHeaderInfo]))

(s/def
  :cognitect.aws.glacier/UploadListElement
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.UploadListElement/MultipartUploadId
     :cognitect.aws.glacier.UploadListElement/VaultARN
     :cognitect.aws.glacier.UploadListElement/CreationDate
     :cognitect.aws.glacier.UploadListElement/ArchiveDescription
     :cognitect.aws.glacier.UploadListElement/PartSizeInBytes]))

(s/def
  :cognitect.aws.glacier/AddTagsToVaultInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.AddTagsToVaultInput/accountId
     :cognitect.aws.glacier.AddTagsToVaultInput/vaultName]
    :opt-un
    [:cognitect.aws.glacier.AddTagsToVaultInput/Tags]))

(s/def
  :cognitect.aws.glacier/OutputLocation
  (s/keys :opt-un [:cognitect.aws.glacier.OutputLocation/S3]))

(s/def :cognitect.aws.glacier/TagValue string?)

(s/def :cognitect.aws.glacier/EncryptionType (s/spec string? :gen #(s/gen #{"aws:kms" "AES256"})))

(s/def
  :cognitect.aws.glacier/GetVaultLockOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.GetVaultLockOutput/ExpirationDate
     :cognitect.aws.glacier.GetVaultLockOutput/CreationDate
     :cognitect.aws.glacier.GetVaultLockOutput/Policy
     :cognitect.aws.glacier.GetVaultLockOutput/State]))

(s/def
  :cognitect.aws.glacier/DeleteVaultAccessPolicyInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.DeleteVaultAccessPolicyInput/accountId
     :cognitect.aws.glacier.DeleteVaultAccessPolicyInput/vaultName]))

(s/def
  :cognitect.aws.glacier/GetJobOutputInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.GetJobOutputInput/accountId
     :cognitect.aws.glacier.GetJobOutputInput/vaultName
     :cognitect.aws.glacier.GetJobOutputInput/jobId]
    :opt-un
    [:cognitect.aws.glacier.GetJobOutputInput/range]))

(s/def
  :cognitect.aws.glacier/UploadMultipartPartOutput
  (s/keys :opt-un [:cognitect.aws.glacier.UploadMultipartPartOutput/checksum]))

(s/def
  :cognitect.aws.glacier/InputSerialization
  (s/keys :opt-un [:cognitect.aws.glacier.InputSerialization/csv]))

(s/def
  :cognitect.aws.glacier/StatusCode
  (s/spec string? :gen #(s/gen #{"Failed" "Succeeded" "InProgress"})))

(s/def
  :cognitect.aws.glacier/ProvisionedCapacityList
  (s/coll-of :cognitect.aws.glacier/ProvisionedCapacityDescription))

(s/def
  :cognitect.aws.glacier/DeleteArchiveInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.DeleteArchiveInput/accountId
     :cognitect.aws.glacier.DeleteArchiveInput/vaultName
     :cognitect.aws.glacier.DeleteArchiveInput/archiveId]))

(s/def
  :cognitect.aws.glacier/Grantee
  (s/keys
    :req-un
    [:cognitect.aws.glacier.Grantee/Type]
    :opt-un
    [:cognitect.aws.glacier.Grantee/DisplayName
     :cognitect.aws.glacier.Grantee/ID
     :cognitect.aws.glacier.Grantee/URI
     :cognitect.aws.glacier.Grantee/EmailAddress]))

(s/def
  :cognitect.aws.glacier/Stream
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.glacier/DeleteVaultInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.DeleteVaultInput/accountId
     :cognitect.aws.glacier.DeleteVaultInput/vaultName]))

(s/def
  :cognitect.aws.glacier/ActionCode
  (s/spec string? :gen #(s/gen #{"InventoryRetrieval" "ArchiveRetrieval" "Select"})))

(s/def
  :cognitect.aws.glacier/GetVaultAccessPolicyInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.GetVaultAccessPolicyInput/accountId
     :cognitect.aws.glacier.GetVaultAccessPolicyInput/vaultName]))

(s/def
  :cognitect.aws.glacier/ArchiveCreationOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.ArchiveCreationOutput/archiveId
     :cognitect.aws.glacier.ArchiveCreationOutput/location
     :cognitect.aws.glacier.ArchiveCreationOutput/checksum]))

(s/def
  :cognitect.aws.glacier/GetVaultNotificationsOutput
  (s/keys :opt-un [:cognitect.aws.glacier.GetVaultNotificationsOutput/vaultNotificationConfig]))

(s/def
  :cognitect.aws.glacier/SetVaultNotificationsInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.SetVaultNotificationsInput/accountId
     :cognitect.aws.glacier.SetVaultNotificationsInput/vaultName]
    :opt-un
    [:cognitect.aws.glacier.SetVaultNotificationsInput/vaultNotificationConfig]))

(s/def
  :cognitect.aws.glacier/PurchaseProvisionedCapacityInput
  (s/keys :req-un [:cognitect.aws.glacier.PurchaseProvisionedCapacityInput/accountId]))

(s/def :cognitect.aws.glacier/NotificationEventList (s/coll-of :cognitect.aws.glacier/string))

(s/def
  :cognitect.aws.glacier/ListProvisionedCapacityOutput
  (s/keys :opt-un [:cognitect.aws.glacier.ListProvisionedCapacityOutput/ProvisionedCapacityList]))

(s/def
  :cognitect.aws.glacier/PurchaseProvisionedCapacityOutput
  (s/keys :opt-un [:cognitect.aws.glacier.PurchaseProvisionedCapacityOutput/capacityId]))

(s/def
  :cognitect.aws.glacier/SetDataRetrievalPolicyInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.SetDataRetrievalPolicyInput/accountId]
    :opt-un
    [:cognitect.aws.glacier.SetDataRetrievalPolicyInput/Policy]))

(s/def
  :cognitect.aws.glacier/ListTagsForVaultOutput
  (s/keys :opt-un [:cognitect.aws.glacier.ListTagsForVaultOutput/Tags]))

(s/def :cognitect.aws.glacier/TagKey string?)

(s/def
  :cognitect.aws.glacier/SelectParameters
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.SelectParameters/InputSerialization
     :cognitect.aws.glacier.SelectParameters/Expression
     :cognitect.aws.glacier.SelectParameters/OutputSerialization
     :cognitect.aws.glacier.SelectParameters/ExpressionType]))

(s/def :cognitect.aws.glacier/QuoteFields (s/spec string? :gen #(s/gen #{"ALWAYS" "ASNEEDED"})))

(s/def
  :cognitect.aws.glacier/CreateVaultInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.CreateVaultInput/accountId
     :cognitect.aws.glacier.CreateVaultInput/vaultName]))

(s/def
  :cognitect.aws.glacier/GetVaultNotificationsInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.GetVaultNotificationsInput/accountId
     :cognitect.aws.glacier.GetVaultNotificationsInput/vaultName]))

(s/def
  :cognitect.aws.glacier/GetVaultAccessPolicyOutput
  (s/keys :opt-un [:cognitect.aws.glacier.GetVaultAccessPolicyOutput/policy]))

(s/def
  :cognitect.aws.glacier/OutputSerialization
  (s/keys :opt-un [:cognitect.aws.glacier.OutputSerialization/csv]))

(s/def
  :cognitect.aws.glacier/ListVaultsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.ListVaultsOutput/Marker
     :cognitect.aws.glacier.ListVaultsOutput/VaultList]))

(s/def
  :cognitect.aws.glacier/Type
  (s/spec string? :gen #(s/gen #{"CanonicalUser" "AmazonCustomerByEmail" "Group"})))

(s/def
  :cognitect.aws.glacier/ListVaultsInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.ListVaultsInput/accountId]
    :opt-un
    [:cognitect.aws.glacier.ListVaultsInput/limit :cognitect.aws.glacier.ListVaultsInput/marker]))

(s/def :cognitect.aws.glacier/JobList (s/coll-of :cognitect.aws.glacier/GlacierJobDescription))

(s/def
  :cognitect.aws.glacier/ListProvisionedCapacityInput
  (s/keys :req-un [:cognitect.aws.glacier.ListProvisionedCapacityInput/accountId]))

(s/def
  :cognitect.aws.glacier/InventoryRetrievalJobInput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.InventoryRetrievalJobInput/EndDate
     :cognitect.aws.glacier.InventoryRetrievalJobInput/Marker
     :cognitect.aws.glacier.InventoryRetrievalJobInput/Limit
     :cognitect.aws.glacier.InventoryRetrievalJobInput/StartDate]))

(s/def
  :cognitect.aws.glacier/DeleteVaultNotificationsInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.DeleteVaultNotificationsInput/accountId
     :cognitect.aws.glacier.DeleteVaultNotificationsInput/vaultName]))

(s/def :cognitect.aws.glacier/AccessControlPolicyList (s/coll-of :cognitect.aws.glacier/Grant))

(s/def
  :cognitect.aws.glacier/hashmap
  (s/map-of :cognitect.aws.glacier/string :cognitect.aws.glacier/string))

(s/def :cognitect.aws.glacier/DateTime string?)

(s/def
  :cognitect.aws.glacier/FileHeaderInfo
  (s/spec string? :gen #(s/gen #{"USE" "NONE" "IGNORE"})))

(s/def
  :cognitect.aws.glacier/GetJobOutputOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.GetJobOutputOutput/body
     :cognitect.aws.glacier.GetJobOutputOutput/archiveDescription
     :cognitect.aws.glacier.GetJobOutputOutput/acceptRanges
     :cognitect.aws.glacier.GetJobOutputOutput/status
     :cognitect.aws.glacier.GetJobOutputOutput/contentRange
     :cognitect.aws.glacier.GetJobOutputOutput/contentType
     :cognitect.aws.glacier.GetJobOutputOutput/checksum]))

(s/def
  :cognitect.aws.glacier/CompleteMultipartUploadInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.CompleteMultipartUploadInput/accountId
     :cognitect.aws.glacier.CompleteMultipartUploadInput/vaultName
     :cognitect.aws.glacier.CompleteMultipartUploadInput/uploadId]
    :opt-un
    [:cognitect.aws.glacier.CompleteMultipartUploadInput/checksum
     :cognitect.aws.glacier.CompleteMultipartUploadInput/archiveSize]))

(s/def :cognitect.aws.glacier/boolean boolean?)

(s/def
  :cognitect.aws.glacier/StorageClass
  (s/spec string? :gen #(s/gen #{"STANDARD_IA" "STANDARD" "REDUCED_REDUNDANCY"})))

(s/def
  :cognitect.aws.glacier/DescribeVaultInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.DescribeVaultInput/accountId
     :cognitect.aws.glacier.DescribeVaultInput/vaultName]))

(s/def
  :cognitect.aws.glacier/NullableLong
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.glacier/InitiateMultipartUploadOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.InitiateMultipartUploadOutput/uploadId
     :cognitect.aws.glacier.InitiateMultipartUploadOutput/location]))

(s/def
  :cognitect.aws.glacier/DataRetrievalRulesList
  (s/coll-of :cognitect.aws.glacier/DataRetrievalRule))

(s/def
  :cognitect.aws.glacier/RemoveTagsFromVaultInput
  (s/keys
    :req-un
    [:cognitect.aws.glacier.RemoveTagsFromVaultInput/accountId
     :cognitect.aws.glacier.RemoveTagsFromVaultInput/vaultName]
    :opt-un
    [:cognitect.aws.glacier.RemoveTagsFromVaultInput/TagKeys]))

(s/def :cognitect.aws.glacier/TagKeyList (s/coll-of :cognitect.aws.glacier/string))

(s/def
  :cognitect.aws.glacier/ListMultipartUploadsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.glacier.ListMultipartUploadsOutput/UploadsList
     :cognitect.aws.glacier.ListMultipartUploadsOutput/Marker]))

(s/def :cognitect.aws.glacier.ListJobsOutput/JobList :cognitect.aws.glacier/JobList)

(s/def :cognitect.aws.glacier.ListJobsOutput/Marker :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.JobParameters/Tier :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.JobParameters/OutputLocation :cognitect.aws.glacier/OutputLocation)

(s/def
  :cognitect.aws.glacier.JobParameters/InventoryRetrievalParameters
  :cognitect.aws.glacier/InventoryRetrievalJobInput)

(s/def :cognitect.aws.glacier.JobParameters/SNSTopic :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.JobParameters/Format :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.JobParameters/ArchiveId :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.JobParameters/SelectParameters
  :cognitect.aws.glacier/SelectParameters)

(s/def :cognitect.aws.glacier.JobParameters/Description :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.JobParameters/Type :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.JobParameters/RetrievalByteRange :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GlacierJobDescription/CompletionDate :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GlacierJobDescription/Completed :cognitect.aws.glacier/boolean)

(s/def
  :cognitect.aws.glacier.GlacierJobDescription/InventorySizeInBytes
  :cognitect.aws.glacier/Size)

(s/def :cognitect.aws.glacier.GlacierJobDescription/JobId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GlacierJobDescription/Tier :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.GlacierJobDescription/ArchiveSHA256TreeHash
  :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.GlacierJobDescription/OutputLocation
  :cognitect.aws.glacier/OutputLocation)

(s/def
  :cognitect.aws.glacier.GlacierJobDescription/InventoryRetrievalParameters
  :cognitect.aws.glacier/InventoryRetrievalJobDescription)

(s/def :cognitect.aws.glacier.GlacierJobDescription/SNSTopic :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GlacierJobDescription/StatusCode :cognitect.aws.glacier/StatusCode)

(s/def :cognitect.aws.glacier.GlacierJobDescription/ArchiveId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GlacierJobDescription/Action :cognitect.aws.glacier/ActionCode)

(s/def :cognitect.aws.glacier.GlacierJobDescription/JobDescription :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GlacierJobDescription/StatusMessage :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.GlacierJobDescription/SelectParameters
  :cognitect.aws.glacier/SelectParameters)

(s/def :cognitect.aws.glacier.GlacierJobDescription/ArchiveSizeInBytes :cognitect.aws.glacier/Size)

(s/def :cognitect.aws.glacier.GlacierJobDescription/SHA256TreeHash :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GlacierJobDescription/VaultARN :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GlacierJobDescription/CreationDate :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.GlacierJobDescription/RetrievalByteRange
  :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GlacierJobDescription/JobOutputPath :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListMultipartUploadsInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListMultipartUploadsInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListMultipartUploadsInput/marker :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListMultipartUploadsInput/limit :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListTagsForVaultInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListTagsForVaultInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CompleteVaultLockInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CompleteVaultLockInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CompleteVaultLockInput/lockId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetVaultLockInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetVaultLockInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.PartListElement/RangeInBytes :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.PartListElement/SHA256TreeHash :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateJobOutput/location :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateJobOutput/jobId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateJobOutput/jobOutputPath :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateJobInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateJobInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateJobInput/jobParameters :cognitect.aws.glacier/JobParameters)

(s/def :cognitect.aws.glacier.VaultNotificationConfig/SNSTopic :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.VaultNotificationConfig/Events
  :cognitect.aws.glacier/NotificationEventList)

(s/def :cognitect.aws.glacier.CreateVaultOutput/location :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.VaultLockPolicy/Policy :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.Encryption/EncryptionType :cognitect.aws.glacier/EncryptionType)

(s/def :cognitect.aws.glacier.Encryption/KMSKeyId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.Encryption/KMSContext :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.VaultAccessPolicy/Policy :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DataRetrievalRule/Strategy :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DataRetrievalRule/BytesPerHour :cognitect.aws.glacier/NullableLong)

(s/def :cognitect.aws.glacier.ListPartsOutput/MultipartUploadId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListPartsOutput/VaultARN :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListPartsOutput/ArchiveDescription :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListPartsOutput/PartSizeInBytes :cognitect.aws.glacier/long)

(s/def :cognitect.aws.glacier.ListPartsOutput/CreationDate :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListPartsOutput/Parts :cognitect.aws.glacier/PartList)

(s/def :cognitect.aws.glacier.ListPartsOutput/Marker :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.GetDataRetrievalPolicyOutput/Policy
  :cognitect.aws.glacier/DataRetrievalPolicy)

(s/def :cognitect.aws.glacier.UploadMultipartPartInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadMultipartPartInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadMultipartPartInput/uploadId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadMultipartPartInput/checksum :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadMultipartPartInput/range :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadMultipartPartInput/body :cognitect.aws.glacier/Stream)

(s/def :cognitect.aws.glacier.DescribeJobInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DescribeJobInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DescribeJobInput/jobId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListJobsInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListJobsInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListJobsInput/limit :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListJobsInput/marker :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListJobsInput/statuscode :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListJobsInput/completed :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateMultipartUploadInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateMultipartUploadInput/vaultName :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.InitiateMultipartUploadInput/archiveDescription
  :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateMultipartUploadInput/partSize :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetDataRetrievalPolicyInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DescribeVaultOutput/VaultARN :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DescribeVaultOutput/VaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DescribeVaultOutput/CreationDate :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DescribeVaultOutput/LastInventoryDate :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DescribeVaultOutput/NumberOfArchives :cognitect.aws.glacier/long)

(s/def :cognitect.aws.glacier.DescribeVaultOutput/SizeInBytes :cognitect.aws.glacier/long)

(s/def :cognitect.aws.glacier.InitiateVaultLockOutput/lockId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadArchiveInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadArchiveInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadArchiveInput/archiveDescription :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadArchiveInput/checksum :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadArchiveInput/body :cognitect.aws.glacier/Stream)

(s/def :cognitect.aws.glacier.InventoryRetrievalJobDescription/Format :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.InventoryRetrievalJobDescription/StartDate
  :cognitect.aws.glacier/DateTime)

(s/def
  :cognitect.aws.glacier.InventoryRetrievalJobDescription/EndDate
  :cognitect.aws.glacier/DateTime)

(s/def :cognitect.aws.glacier.InventoryRetrievalJobDescription/Limit :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InventoryRetrievalJobDescription/Marker :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListPartsInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListPartsInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListPartsInput/uploadId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListPartsInput/marker :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListPartsInput/limit :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.SetVaultAccessPolicyInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.SetVaultAccessPolicyInput/vaultName :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.SetVaultAccessPolicyInput/policy
  :cognitect.aws.glacier/VaultAccessPolicy)

(s/def :cognitect.aws.glacier.AbortVaultLockInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.AbortVaultLockInput/vaultName :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.ProvisionedCapacityDescription/CapacityId
  :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.ProvisionedCapacityDescription/StartDate
  :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.ProvisionedCapacityDescription/ExpirationDate
  :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.AbortMultipartUploadInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.AbortMultipartUploadInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.AbortMultipartUploadInput/uploadId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateVaultLockInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateVaultLockInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateVaultLockInput/policy :cognitect.aws.glacier/VaultLockPolicy)

(s/def :cognitect.aws.glacier.S3Location/BucketName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.S3Location/Prefix :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.S3Location/Encryption :cognitect.aws.glacier/Encryption)

(s/def :cognitect.aws.glacier.S3Location/CannedACL :cognitect.aws.glacier/CannedACL)

(s/def
  :cognitect.aws.glacier.S3Location/AccessControlList
  :cognitect.aws.glacier/AccessControlPolicyList)

(s/def :cognitect.aws.glacier.S3Location/Tagging :cognitect.aws.glacier/hashmap)

(s/def :cognitect.aws.glacier.S3Location/UserMetadata :cognitect.aws.glacier/hashmap)

(s/def :cognitect.aws.glacier.S3Location/StorageClass :cognitect.aws.glacier/StorageClass)

(s/def :cognitect.aws.glacier.Grant/Grantee :cognitect.aws.glacier/Grantee)

(s/def :cognitect.aws.glacier.Grant/Permission :cognitect.aws.glacier/Permission)

(s/def
  :cognitect.aws.glacier.DataRetrievalPolicy/Rules
  :cognitect.aws.glacier/DataRetrievalRulesList)

(s/def :cognitect.aws.glacier.CSVOutput/QuoteFields :cognitect.aws.glacier/QuoteFields)

(s/def :cognitect.aws.glacier.CSVOutput/QuoteEscapeCharacter :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CSVOutput/RecordDelimiter :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CSVOutput/FieldDelimiter :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CSVOutput/QuoteCharacter :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CSVInput/FileHeaderInfo :cognitect.aws.glacier/FileHeaderInfo)

(s/def :cognitect.aws.glacier.CSVInput/Comments :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CSVInput/QuoteEscapeCharacter :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CSVInput/RecordDelimiter :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CSVInput/FieldDelimiter :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CSVInput/QuoteCharacter :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadListElement/MultipartUploadId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadListElement/VaultARN :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadListElement/ArchiveDescription :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadListElement/PartSizeInBytes :cognitect.aws.glacier/long)

(s/def :cognitect.aws.glacier.UploadListElement/CreationDate :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.AddTagsToVaultInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.AddTagsToVaultInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.AddTagsToVaultInput/Tags :cognitect.aws.glacier/TagMap)

(s/def :cognitect.aws.glacier.OutputLocation/S3 :cognitect.aws.glacier/S3Location)

(s/def :cognitect.aws.glacier.GetVaultLockOutput/Policy :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetVaultLockOutput/State :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetVaultLockOutput/ExpirationDate :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetVaultLockOutput/CreationDate :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DeleteVaultAccessPolicyInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DeleteVaultAccessPolicyInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetJobOutputInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetJobOutputInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetJobOutputInput/jobId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetJobOutputInput/range :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.UploadMultipartPartOutput/checksum :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InputSerialization/csv :cognitect.aws.glacier/CSVInput)

(s/def :cognitect.aws.glacier.DeleteArchiveInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DeleteArchiveInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DeleteArchiveInput/archiveId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.Grantee/Type :cognitect.aws.glacier/Type)

(s/def :cognitect.aws.glacier.Grantee/DisplayName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.Grantee/URI :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.Grantee/ID :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.Grantee/EmailAddress :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DeleteVaultInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DeleteVaultInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetVaultAccessPolicyInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetVaultAccessPolicyInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ArchiveCreationOutput/location :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ArchiveCreationOutput/checksum :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ArchiveCreationOutput/archiveId :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.GetVaultNotificationsOutput/vaultNotificationConfig
  :cognitect.aws.glacier/VaultNotificationConfig)

(s/def :cognitect.aws.glacier.SetVaultNotificationsInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.SetVaultNotificationsInput/vaultName :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.SetVaultNotificationsInput/vaultNotificationConfig
  :cognitect.aws.glacier/VaultNotificationConfig)

(s/def
  :cognitect.aws.glacier.PurchaseProvisionedCapacityInput/accountId
  :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.ListProvisionedCapacityOutput/ProvisionedCapacityList
  :cognitect.aws.glacier/ProvisionedCapacityList)

(s/def
  :cognitect.aws.glacier.PurchaseProvisionedCapacityOutput/capacityId
  :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.SetDataRetrievalPolicyInput/accountId :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.SetDataRetrievalPolicyInput/Policy
  :cognitect.aws.glacier/DataRetrievalPolicy)

(s/def :cognitect.aws.glacier.ListTagsForVaultOutput/Tags :cognitect.aws.glacier/TagMap)

(s/def
  :cognitect.aws.glacier.SelectParameters/InputSerialization
  :cognitect.aws.glacier/InputSerialization)

(s/def :cognitect.aws.glacier.SelectParameters/ExpressionType :cognitect.aws.glacier/ExpressionType)

(s/def :cognitect.aws.glacier.SelectParameters/Expression :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.SelectParameters/OutputSerialization
  :cognitect.aws.glacier/OutputSerialization)

(s/def :cognitect.aws.glacier.CreateVaultInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CreateVaultInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetVaultNotificationsInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetVaultNotificationsInput/vaultName :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.GetVaultAccessPolicyOutput/policy
  :cognitect.aws.glacier/VaultAccessPolicy)

(s/def :cognitect.aws.glacier.OutputSerialization/csv :cognitect.aws.glacier/CSVOutput)

(s/def :cognitect.aws.glacier.ListVaultsOutput/VaultList :cognitect.aws.glacier/VaultList)

(s/def :cognitect.aws.glacier.ListVaultsOutput/Marker :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListVaultsInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListVaultsInput/marker :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListVaultsInput/limit :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.ListProvisionedCapacityInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InventoryRetrievalJobInput/StartDate :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InventoryRetrievalJobInput/EndDate :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InventoryRetrievalJobInput/Limit :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InventoryRetrievalJobInput/Marker :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DeleteVaultNotificationsInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DeleteVaultNotificationsInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetJobOutputOutput/body :cognitect.aws.glacier/Stream)

(s/def :cognitect.aws.glacier.GetJobOutputOutput/checksum :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetJobOutputOutput/status :cognitect.aws.glacier/httpstatus)

(s/def :cognitect.aws.glacier.GetJobOutputOutput/contentRange :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetJobOutputOutput/acceptRanges :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetJobOutputOutput/contentType :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.GetJobOutputOutput/archiveDescription :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CompleteMultipartUploadInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CompleteMultipartUploadInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CompleteMultipartUploadInput/uploadId :cognitect.aws.glacier/string)

(s/def
  :cognitect.aws.glacier.CompleteMultipartUploadInput/archiveSize
  :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.CompleteMultipartUploadInput/checksum :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DescribeVaultInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.DescribeVaultInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateMultipartUploadOutput/location :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.InitiateMultipartUploadOutput/uploadId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.RemoveTagsFromVaultInput/accountId :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.RemoveTagsFromVaultInput/vaultName :cognitect.aws.glacier/string)

(s/def :cognitect.aws.glacier.RemoveTagsFromVaultInput/TagKeys :cognitect.aws.glacier/TagKeyList)

(s/def
  :cognitect.aws.glacier.ListMultipartUploadsOutput/UploadsList
  :cognitect.aws.glacier/UploadsList)

(s/def :cognitect.aws.glacier.ListMultipartUploadsOutput/Marker :cognitect.aws.glacier/string)

