;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.guardduty.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def :cognitect.aws.guardduty/DeleteThreatIntelSetResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/FindingType
  (s/spec
    (s/and string? #(<= 1 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/CreateIPSetResponse
  (s/keys :req-un [:cognitect.aws.guardduty.CreateIPSetResponse/IpSetId]))

(s/def
  :cognitect.aws.guardduty/GetDetectorResponse
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetDetectorResponse/ServiceRole
     :cognitect.aws.guardduty.GetDetectorResponse/Status]
    :opt-un
    [:cognitect.aws.guardduty.GetDetectorResponse/Tags
     :cognitect.aws.guardduty.GetDetectorResponse/CreatedAt
     :cognitect.aws.guardduty.GetDetectorResponse/UpdatedAt
     :cognitect.aws.guardduty.GetDetectorResponse/FindingPublishingFrequency]))

(s/def
  :cognitect.aws.guardduty/FilterDescription
  (s/spec
    (s/and string? #(<= 0 (count %) 512))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 512) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/Service
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.Service/Count
     :cognitect.aws.guardduty.Service/Evidence
     :cognitect.aws.guardduty.Service/EventFirstSeen
     :cognitect.aws.guardduty.Service/EventLastSeen
     :cognitect.aws.guardduty.Service/DetectorId
     :cognitect.aws.guardduty.Service/ServiceName
     :cognitect.aws.guardduty.Service/ResourceRole
     :cognitect.aws.guardduty.Service/UserFeedback
     :cognitect.aws.guardduty.Service/Action
     :cognitect.aws.guardduty.Service/Archived]))

(s/def
  :cognitect.aws.guardduty/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.TagResourceRequest/ResourceArn
     :cognitect.aws.guardduty.TagResourceRequest/Tags]))

(s/def :cognitect.aws.guardduty/DisassociateFromMasterAccountResponse (s/keys))

(s/def :cognitect.aws.guardduty/Neq (s/coll-of :cognitect.aws.guardduty/String))

(s/def :cognitect.aws.guardduty/UnarchiveFindingsResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/AccountDetail
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.AccountDetail/AccountId
     :cognitect.aws.guardduty.AccountDetail/Email]))

(s/def
  :cognitect.aws.guardduty/ThreatIntelligenceDetails
  (s/coll-of :cognitect.aws.guardduty/ThreatIntelligenceDetail))

(s/def
  :cognitect.aws.guardduty/CreateThreatIntelSetResponse
  (s/keys :req-un [:cognitect.aws.guardduty.CreateThreatIntelSetResponse/ThreatIntelSetId]))

(s/def
  :cognitect.aws.guardduty/LocalPortDetails
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.LocalPortDetails/PortName
     :cognitect.aws.guardduty.LocalPortDetails/Port]))

(s/def
  :cognitect.aws.guardduty/DisassociateMembersResponse
  (s/keys :req-un [:cognitect.aws.guardduty.DisassociateMembersResponse/UnprocessedAccounts]))

(s/def
  :cognitect.aws.guardduty/DeclineInvitationsResponse
  (s/keys :req-un [:cognitect.aws.guardduty.DeclineInvitationsResponse/UnprocessedAccounts]))

(s/def
  :cognitect.aws.guardduty/Members
  (s/coll-of :cognitect.aws.guardduty/Member :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.guardduty/GetMasterAccountRequest
  (s/keys :req-un [:cognitect.aws.guardduty.GetMasterAccountRequest/DetectorId]))

(s/def
  :cognitect.aws.guardduty/Tag
  (s/keys :opt-un [:cognitect.aws.guardduty.Tag/Key :cognitect.aws.guardduty.Tag/Value]))

(s/def :cognitect.aws.guardduty/Eq (s/coll-of :cognitect.aws.guardduty/String))

(s/def
  :cognitect.aws.guardduty/AwsApiCallAction
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.AwsApiCallAction/Api
     :cognitect.aws.guardduty.AwsApiCallAction/CallerType
     :cognitect.aws.guardduty.AwsApiCallAction/RemoteIpDetails
     :cognitect.aws.guardduty.AwsApiCallAction/DomainDetails
     :cognitect.aws.guardduty.AwsApiCallAction/ServiceName]))

(s/def
  :cognitect.aws.guardduty/TagMap
  (s/map-of
    :cognitect.aws.guardduty/TagKey
    :cognitect.aws.guardduty/TagValue
    :min-count
    1
    :max-count
    200))

(s/def :cognitect.aws.guardduty/DeleteIPSetResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/Evidence
  (s/keys :opt-un [:cognitect.aws.guardduty.Evidence/ThreatIntelligenceDetails]))

(s/def :cognitect.aws.guardduty/FindingPublishingFrequency string?)

(s/def
  :cognitect.aws.guardduty/ThreatIntelSetFormat
  (s/spec
    (s/and string? #(<= 1 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/DeleteInvitationsRequest
  (s/keys :req-un [:cognitect.aws.guardduty.DeleteInvitationsRequest/AccountIds]))

(s/def
  :cognitect.aws.guardduty/ListMembersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.ListMembersResponse/Members
     :cognitect.aws.guardduty.ListMembersResponse/NextToken]))

(s/def :cognitect.aws.guardduty/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/GetFindingsResponse
  (s/keys :req-un [:cognitect.aws.guardduty.GetFindingsResponse/Findings]))

(s/def
  :cognitect.aws.guardduty/InviteMembersResponse
  (s/keys :req-un [:cognitect.aws.guardduty.InviteMembersResponse/UnprocessedAccounts]))

(s/def
  :cognitect.aws.guardduty/GetFindingsStatisticsRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetFindingsStatisticsRequest/DetectorId
     :cognitect.aws.guardduty.GetFindingsStatisticsRequest/FindingStatisticTypes]
    :opt-un
    [:cognitect.aws.guardduty.GetFindingsStatisticsRequest/FindingCriteria]))

(s/def
  :cognitect.aws.guardduty/UpdateDetectorRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.UpdateDetectorRequest/DetectorId]
    :opt-un
    [:cognitect.aws.guardduty.UpdateDetectorRequest/Enable
     :cognitect.aws.guardduty.UpdateDetectorRequest/FindingPublishingFrequency]))

(s/def
  :cognitect.aws.guardduty/Invitation
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.Invitation/InvitationId
     :cognitect.aws.guardduty.Invitation/RelationshipStatus
     :cognitect.aws.guardduty.Invitation/AccountId
     :cognitect.aws.guardduty.Invitation/InvitedAt]))

(s/def
  :cognitect.aws.guardduty/UnprocessedAccount
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.UnprocessedAccount/AccountId
     :cognitect.aws.guardduty.UnprocessedAccount/Result]))

(s/def
  :cognitect.aws.guardduty/Member
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.Member/AccountId
     :cognitect.aws.guardduty.Member/MasterId
     :cognitect.aws.guardduty.Member/Email
     :cognitect.aws.guardduty.Member/RelationshipStatus
     :cognitect.aws.guardduty.Member/UpdatedAt]
    :opt-un
    [:cognitect.aws.guardduty.Member/DetectorId :cognitect.aws.guardduty.Member/InvitedAt]))

(s/def
  :cognitect.aws.guardduty/GetMasterAccountResponse
  (s/keys :req-un [:cognitect.aws.guardduty.GetMasterAccountResponse/Master]))

(s/def :cognitect.aws.guardduty/ArchiveFindingsResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/AccountId
  (s/spec
    (s/and string? #(<= 12 (count %) 12))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 12 12) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/ListMembersRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ListMembersRequest/DetectorId]
    :opt-un
    [:cognitect.aws.guardduty.ListMembersRequest/NextToken
     :cognitect.aws.guardduty.ListMembersRequest/MaxResults
     :cognitect.aws.guardduty.ListMembersRequest/OnlyAssociated]))

(s/def
  :cognitect.aws.guardduty/ProductCode
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.ProductCode/ProductType :cognitect.aws.guardduty.ProductCode/Code]))

(s/def :cognitect.aws.guardduty/Feedback string?)

(s/def
  :cognitect.aws.guardduty/ListFiltersResponse
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ListFiltersResponse/FilterNames]
    :opt-un
    [:cognitect.aws.guardduty.ListFiltersResponse/NextToken]))

(s/def
  :cognitect.aws.guardduty/ThreatIntelSetIds
  (s/coll-of :cognitect.aws.guardduty/String :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.guardduty/ListDetectorsResponse
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ListDetectorsResponse/DetectorIds]
    :opt-un
    [:cognitect.aws.guardduty.ListDetectorsResponse/NextToken]))

(s/def
  :cognitect.aws.guardduty/SecurityGroup
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.SecurityGroup/GroupName
     :cognitect.aws.guardduty.SecurityGroup/GroupId]))

(s/def
  :cognitect.aws.guardduty/DeclineInvitationsRequest
  (s/keys :req-un [:cognitect.aws.guardduty.DeclineInvitationsRequest/AccountIds]))

(s/def :cognitect.aws.guardduty/NotEquals (s/coll-of :cognitect.aws.guardduty/String))

(s/def :cognitect.aws.guardduty/OrderBy string?)

(s/def :cognitect.aws.guardduty/Tags (s/coll-of :cognitect.aws.guardduty/Tag))

(s/def
  :cognitect.aws.guardduty/FindingStatisticTypes
  (s/coll-of :cognitect.aws.guardduty/FindingStatisticType :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.guardduty/GetMembersRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetMembersRequest/DetectorId
     :cognitect.aws.guardduty.GetMembersRequest/AccountIds]))

(s/def
  :cognitect.aws.guardduty/Email
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/DeleteIPSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.DeleteIPSetRequest/DetectorId
     :cognitect.aws.guardduty.DeleteIPSetRequest/IpSetId]))

(s/def
  :cognitect.aws.guardduty/NetworkInterface
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.NetworkInterface/PublicDnsName
     :cognitect.aws.guardduty.NetworkInterface/PublicIp
     :cognitect.aws.guardduty.NetworkInterface/Ipv6Addresses
     :cognitect.aws.guardduty.NetworkInterface/SubnetId
     :cognitect.aws.guardduty.NetworkInterface/SecurityGroups
     :cognitect.aws.guardduty.NetworkInterface/NetworkInterfaceId
     :cognitect.aws.guardduty.NetworkInterface/PrivateDnsName
     :cognitect.aws.guardduty.NetworkInterface/VpcId
     :cognitect.aws.guardduty.NetworkInterface/PrivateIpAddresses
     :cognitect.aws.guardduty.NetworkInterface/PrivateIpAddress]))

(s/def
  :cognitect.aws.guardduty/UpdateFilterResponse
  (s/keys :req-un [:cognitect.aws.guardduty.UpdateFilterResponse/Name]))

(s/def :cognitect.aws.guardduty/City (s/keys :opt-un [:cognitect.aws.guardduty.City/CityName]))

(s/def
  :cognitect.aws.guardduty/DeleteThreatIntelSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.DeleteThreatIntelSetRequest/DetectorId
     :cognitect.aws.guardduty.DeleteThreatIntelSetRequest/ThreatIntelSetId]))

(s/def
  :cognitect.aws.guardduty/StartMonitoringMembersRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.StartMonitoringMembersRequest/DetectorId
     :cognitect.aws.guardduty.StartMonitoringMembersRequest/AccountIds]))

(s/def
  :cognitect.aws.guardduty/PrivateIpAddresses
  (s/coll-of :cognitect.aws.guardduty/PrivateIpAddressDetails))

(s/def
  :cognitect.aws.guardduty/StopMonitoringMembersRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.StopMonitoringMembersRequest/DetectorId
     :cognitect.aws.guardduty.StopMonitoringMembersRequest/AccountIds]))

(s/def
  :cognitect.aws.guardduty/DisassociateMembersRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.DisassociateMembersRequest/DetectorId
     :cognitect.aws.guardduty.DisassociateMembersRequest/AccountIds]))

(s/def
  :cognitect.aws.guardduty/CreateMembersRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.CreateMembersRequest/DetectorId
     :cognitect.aws.guardduty.CreateMembersRequest/AccountDetails]))

(s/def
  :cognitect.aws.guardduty/GetInvitationsCountResponse
  (s/keys :opt-un [:cognitect.aws.guardduty.GetInvitationsCountResponse/InvitationsCount]))

(s/def
  :cognitect.aws.guardduty/FilterRank
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def :cognitect.aws.guardduty/Boolean boolean?)

(s/def
  :cognitect.aws.guardduty/FindingIds
  (s/coll-of :cognitect.aws.guardduty/FindingId :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.guardduty/GetFindingsStatisticsResponse
  (s/keys :req-un [:cognitect.aws.guardduty.GetFindingsStatisticsResponse/FindingStatistics]))

(s/def
  :cognitect.aws.guardduty/CreateFilterRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.CreateFilterRequest/DetectorId
     :cognitect.aws.guardduty.CreateFilterRequest/Name
     :cognitect.aws.guardduty.CreateFilterRequest/FindingCriteria]
    :opt-un
    [:cognitect.aws.guardduty.CreateFilterRequest/Tags
     :cognitect.aws.guardduty.CreateFilterRequest/Description
     :cognitect.aws.guardduty.CreateFilterRequest/Rank
     :cognitect.aws.guardduty.CreateFilterRequest/Action
     :cognitect.aws.guardduty.CreateFilterRequest/ClientToken]))

(s/def
  :cognitect.aws.guardduty/CreateSampleFindingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.CreateSampleFindingsRequest/DetectorId]
    :opt-un
    [:cognitect.aws.guardduty.CreateSampleFindingsRequest/FindingTypes]))

(s/def
  :cognitect.aws.guardduty/ListInvitationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.ListInvitationsResponse/NextToken
     :cognitect.aws.guardduty.ListInvitationsResponse/Invitations]))

(s/def
  :cognitect.aws.guardduty/GetThreatIntelSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetThreatIntelSetRequest/DetectorId
     :cognitect.aws.guardduty.GetThreatIntelSetRequest/ThreatIntelSetId]))

(s/def
  :cognitect.aws.guardduty/IpSetFormat
  (s/spec
    (s/and string? #(<= 1 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/Invitations
  (s/coll-of :cognitect.aws.guardduty/Invitation :min-count 0 :max-count 50))

(s/def :cognitect.aws.guardduty/DeleteDetectorResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/PortProbeDetails
  (s/coll-of :cognitect.aws.guardduty/PortProbeDetail))

(s/def
  :cognitect.aws.guardduty/GetFilterRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetFilterRequest/DetectorId
     :cognitect.aws.guardduty.GetFilterRequest/FilterName]))

(s/def :cognitect.aws.guardduty/UpdateDetectorResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/GetThreatIntelSetResponse
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetThreatIntelSetResponse/Name
     :cognitect.aws.guardduty.GetThreatIntelSetResponse/Format
     :cognitect.aws.guardduty.GetThreatIntelSetResponse/Location
     :cognitect.aws.guardduty.GetThreatIntelSetResponse/Status]
    :opt-un
    [:cognitect.aws.guardduty.GetThreatIntelSetResponse/Tags]))

(s/def
  :cognitect.aws.guardduty/CreateFilterResponse
  (s/keys :req-un [:cognitect.aws.guardduty.CreateFilterResponse/Name]))

(s/def :cognitect.aws.guardduty/ProductCodes (s/coll-of :cognitect.aws.guardduty/ProductCode))

(s/def
  :cognitect.aws.guardduty/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.guardduty/DeleteMembersRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.DeleteMembersRequest/DetectorId
     :cognitect.aws.guardduty.DeleteMembersRequest/AccountIds]))

(s/def
  :cognitect.aws.guardduty/CountBySeverity
  (s/map-of :cognitect.aws.guardduty/String :cognitect.aws.guardduty/Integer))

(s/def
  :cognitect.aws.guardduty/TagValue
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/ListFindingsResponse
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ListFindingsResponse/FindingIds]
    :opt-un
    [:cognitect.aws.guardduty.ListFindingsResponse/NextToken]))

(s/def
  :cognitect.aws.guardduty/GetDetectorRequest
  (s/keys :req-un [:cognitect.aws.guardduty.GetDetectorRequest/DetectorId]))

(s/def
  :cognitect.aws.guardduty/FilterNames
  (s/coll-of :cognitect.aws.guardduty/FilterName :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.guardduty/CreateIPSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.CreateIPSetRequest/DetectorId
     :cognitect.aws.guardduty.CreateIPSetRequest/Name
     :cognitect.aws.guardduty.CreateIPSetRequest/Format
     :cognitect.aws.guardduty.CreateIPSetRequest/Location
     :cognitect.aws.guardduty.CreateIPSetRequest/Activate]
    :opt-un
    [:cognitect.aws.guardduty.CreateIPSetRequest/Tags
     :cognitect.aws.guardduty.CreateIPSetRequest/ClientToken]))

(s/def
  :cognitect.aws.guardduty/CreateMembersResponse
  (s/keys :req-un [:cognitect.aws.guardduty.CreateMembersResponse/UnprocessedAccounts]))

(s/def
  :cognitect.aws.guardduty/InstanceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.InstanceDetails/InstanceId
     :cognitect.aws.guardduty.InstanceDetails/Platform
     :cognitect.aws.guardduty.InstanceDetails/ImageId
     :cognitect.aws.guardduty.InstanceDetails/InstanceType
     :cognitect.aws.guardduty.InstanceDetails/ImageDescription
     :cognitect.aws.guardduty.InstanceDetails/Tags
     :cognitect.aws.guardduty.InstanceDetails/AvailabilityZone
     :cognitect.aws.guardduty.InstanceDetails/InstanceState
     :cognitect.aws.guardduty.InstanceDetails/ProductCodes
     :cognitect.aws.guardduty.InstanceDetails/LaunchTime
     :cognitect.aws.guardduty.InstanceDetails/IamInstanceProfile
     :cognitect.aws.guardduty.InstanceDetails/NetworkInterfaces]))

(s/def
  :cognitect.aws.guardduty/ListDetectorsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.ListDetectorsRequest/NextToken
     :cognitect.aws.guardduty.ListDetectorsRequest/MaxResults]))

(s/def
  :cognitect.aws.guardduty/StartMonitoringMembersResponse
  (s/keys :req-un [:cognitect.aws.guardduty.StartMonitoringMembersResponse/UnprocessedAccounts]))

(s/def
  :cognitect.aws.guardduty/FindingTypes
  (s/coll-of :cognitect.aws.guardduty/FindingType :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.guardduty/UnprocessedAccounts
  (s/coll-of :cognitect.aws.guardduty/UnprocessedAccount :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.guardduty/GetFilterResponse
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetFilterResponse/Name
     :cognitect.aws.guardduty.GetFilterResponse/Action
     :cognitect.aws.guardduty.GetFilterResponse/FindingCriteria]
    :opt-un
    [:cognitect.aws.guardduty.GetFilterResponse/Tags
     :cognitect.aws.guardduty.GetFilterResponse/Description
     :cognitect.aws.guardduty.GetFilterResponse/Rank]))

(s/def :cognitect.aws.guardduty/AcceptInvitationResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.guardduty.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.guardduty/ListFiltersRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ListFiltersRequest/DetectorId]
    :opt-un
    [:cognitect.aws.guardduty.ListFiltersRequest/NextToken
     :cognitect.aws.guardduty.ListFiltersRequest/MaxResults]))

(s/def
  :cognitect.aws.guardduty/ThreatIntelligenceDetail
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.ThreatIntelligenceDetail/ThreatNames
     :cognitect.aws.guardduty.ThreatIntelligenceDetail/ThreatListName]))

(s/def
  :cognitect.aws.guardduty/GetFindingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetFindingsRequest/DetectorId
     :cognitect.aws.guardduty.GetFindingsRequest/FindingIds]
    :opt-un
    [:cognitect.aws.guardduty.GetFindingsRequest/SortCriteria]))

(s/def
  :cognitect.aws.guardduty/GetMembersResponse
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetMembersResponse/Members
     :cognitect.aws.guardduty.GetMembersResponse/UnprocessedAccounts]))

(s/def
  :cognitect.aws.guardduty/CreateDetectorRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.CreateDetectorRequest/Enable]
    :opt-un
    [:cognitect.aws.guardduty.CreateDetectorRequest/Tags
     :cognitect.aws.guardduty.CreateDetectorRequest/FindingPublishingFrequency
     :cognitect.aws.guardduty.CreateDetectorRequest/ClientToken]))

(s/def
  :cognitect.aws.guardduty/ThreatIntelSetStatus
  (s/spec
    (s/and string? #(<= 1 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 300) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.guardduty/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/ListInvitationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.ListInvitationsRequest/NextToken
     :cognitect.aws.guardduty.ListInvitationsRequest/MaxResults]))

(s/def
  :cognitect.aws.guardduty/UpdateFilterRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.UpdateFilterRequest/DetectorId
     :cognitect.aws.guardduty.UpdateFilterRequest/FilterName]
    :opt-un
    [:cognitect.aws.guardduty.UpdateFilterRequest/Description
     :cognitect.aws.guardduty.UpdateFilterRequest/Rank
     :cognitect.aws.guardduty.UpdateFilterRequest/FindingCriteria
     :cognitect.aws.guardduty.UpdateFilterRequest/Action]))

(s/def :cognitect.aws.guardduty/FindingStatisticType string?)

(s/def
  :cognitect.aws.guardduty/AccountDetails
  (s/coll-of :cognitect.aws.guardduty/AccountDetail :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.guardduty/FindingCriteria
  (s/keys :opt-un [:cognitect.aws.guardduty.FindingCriteria/Criterion]))

(s/def
  :cognitect.aws.guardduty/IpSetIds
  (s/coll-of :cognitect.aws.guardduty/String :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.guardduty/DisassociateFromMasterAccountRequest
  (s/keys :req-un [:cognitect.aws.guardduty.DisassociateFromMasterAccountRequest/DetectorId]))

(s/def
  :cognitect.aws.guardduty/InviteMembersRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.InviteMembersRequest/DetectorId
     :cognitect.aws.guardduty.InviteMembersRequest/AccountIds]
    :opt-un
    [:cognitect.aws.guardduty.InviteMembersRequest/DisableEmailNotification
     :cognitect.aws.guardduty.InviteMembersRequest/Message]))

(s/def
  :cognitect.aws.guardduty/CreateDetectorResponse
  (s/keys :opt-un [:cognitect.aws.guardduty.CreateDetectorResponse/DetectorId]))

(s/def :cognitect.aws.guardduty/UpdateThreatIntelSetResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/FindingId
  (s/spec
    (s/and string? #(<= 1 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/RemotePortDetails
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.RemotePortDetails/PortName
     :cognitect.aws.guardduty.RemotePortDetails/Port]))

(s/def :cognitect.aws.guardduty/SecurityGroups (s/coll-of :cognitect.aws.guardduty/SecurityGroup))

(s/def
  :cognitect.aws.guardduty/Criterion
  (s/map-of :cognitect.aws.guardduty/String :cognitect.aws.guardduty/Condition))

(s/def
  :cognitect.aws.guardduty/UnarchiveFindingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.UnarchiveFindingsRequest/DetectorId
     :cognitect.aws.guardduty.UnarchiveFindingsRequest/FindingIds]))

(s/def
  :cognitect.aws.guardduty/Action
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.Action/PortProbeAction
     :cognitect.aws.guardduty.Action/DnsRequestAction
     :cognitect.aws.guardduty.Action/NetworkConnectionAction
     :cognitect.aws.guardduty.Action/ActionType
     :cognitect.aws.guardduty.Action/AwsApiCallAction]))

(s/def :cognitect.aws.guardduty/Long (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.guardduty/NetworkConnectionAction
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.NetworkConnectionAction/ConnectionDirection
     :cognitect.aws.guardduty.NetworkConnectionAction/Blocked
     :cognitect.aws.guardduty.NetworkConnectionAction/LocalPortDetails
     :cognitect.aws.guardduty.NetworkConnectionAction/RemoteIpDetails
     :cognitect.aws.guardduty.NetworkConnectionAction/Protocol
     :cognitect.aws.guardduty.NetworkConnectionAction/RemotePortDetails]))

(s/def
  :cognitect.aws.guardduty/RemoteIpDetails
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.RemoteIpDetails/Country
     :cognitect.aws.guardduty.RemoteIpDetails/Organization
     :cognitect.aws.guardduty.RemoteIpDetails/IpAddressV4
     :cognitect.aws.guardduty.RemoteIpDetails/GeoLocation
     :cognitect.aws.guardduty.RemoteIpDetails/City]))

(s/def
  :cognitect.aws.guardduty/GeoLocation
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.GeoLocation/Lat :cognitect.aws.guardduty.GeoLocation/Lon]))

(s/def
  :cognitect.aws.guardduty/Finding
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.Finding/AccountId
     :cognitect.aws.guardduty.Finding/Arn
     :cognitect.aws.guardduty.Finding/CreatedAt
     :cognitect.aws.guardduty.Finding/Id
     :cognitect.aws.guardduty.Finding/Region
     :cognitect.aws.guardduty.Finding/Resource
     :cognitect.aws.guardduty.Finding/SchemaVersion
     :cognitect.aws.guardduty.Finding/Severity
     :cognitect.aws.guardduty.Finding/Type
     :cognitect.aws.guardduty.Finding/UpdatedAt]
    :opt-un
    [:cognitect.aws.guardduty.Finding/Title
     :cognitect.aws.guardduty.Finding/Description
     :cognitect.aws.guardduty.Finding/Partition
     :cognitect.aws.guardduty.Finding/Service
     :cognitect.aws.guardduty.Finding/Confidence]))

(s/def
  :cognitect.aws.guardduty/AccessKeyDetails
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.AccessKeyDetails/PrincipalId
     :cognitect.aws.guardduty.AccessKeyDetails/UserType
     :cognitect.aws.guardduty.AccessKeyDetails/UserName
     :cognitect.aws.guardduty.AccessKeyDetails/AccessKeyId]))

(s/def
  :cognitect.aws.guardduty/IamInstanceProfile
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.IamInstanceProfile/Arn
     :cognitect.aws.guardduty.IamInstanceProfile/Id]))

(s/def
  :cognitect.aws.guardduty/Name
  (s/spec
    (s/and string? #(<= 1 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/MaxResults
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.guardduty/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.UntagResourceRequest/ResourceArn
     :cognitect.aws.guardduty.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.guardduty/TagKey
  (s/spec #(re-matches (re-pattern "^(?!aws:)[a-zA-Z+-=._:/]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.guardduty/SortCriteria
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.SortCriteria/AttributeName
     :cognitect.aws.guardduty.SortCriteria/OrderBy]))

(s/def
  :cognitect.aws.guardduty/Resource
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.Resource/InstanceDetails
     :cognitect.aws.guardduty.Resource/AccessKeyDetails
     :cognitect.aws.guardduty.Resource/ResourceType]))

(s/def
  :cognitect.aws.guardduty/UpdateThreatIntelSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.UpdateThreatIntelSetRequest/DetectorId
     :cognitect.aws.guardduty.UpdateThreatIntelSetRequest/ThreatIntelSetId]
    :opt-un
    [:cognitect.aws.guardduty.UpdateThreatIntelSetRequest/Location
     :cognitect.aws.guardduty.UpdateThreatIntelSetRequest/Name
     :cognitect.aws.guardduty.UpdateThreatIntelSetRequest/Activate]))

(s/def :cognitect.aws.guardduty/ThreatNames (s/coll-of :cognitect.aws.guardduty/String))

(s/def
  :cognitect.aws.guardduty/IpSetStatus
  (s/spec
    (s/and string? #(<= 1 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/ClientToken
  (s/spec
    (s/and string? #(<= 0 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/DomainDetails
  (s/keys :opt-un [:cognitect.aws.guardduty.DomainDetails/Domain]))

(s/def
  :cognitect.aws.guardduty/FilterName
  (s/spec
    (s/and string? #(<= 3 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 3 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/PrivateIpAddressDetails
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.PrivateIpAddressDetails/PrivateDnsName
     :cognitect.aws.guardduty.PrivateIpAddressDetails/PrivateIpAddress]))

(s/def
  :cognitect.aws.guardduty/UpdateIPSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.UpdateIPSetRequest/DetectorId
     :cognitect.aws.guardduty.UpdateIPSetRequest/IpSetId]
    :opt-un
    [:cognitect.aws.guardduty.UpdateIPSetRequest/Location
     :cognitect.aws.guardduty.UpdateIPSetRequest/Name
     :cognitect.aws.guardduty.UpdateIPSetRequest/Activate]))

(s/def
  :cognitect.aws.guardduty/UpdateFindingsFeedbackRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.UpdateFindingsFeedbackRequest/DetectorId
     :cognitect.aws.guardduty.UpdateFindingsFeedbackRequest/FindingIds
     :cognitect.aws.guardduty.UpdateFindingsFeedbackRequest/Feedback]
    :opt-un
    [:cognitect.aws.guardduty.UpdateFindingsFeedbackRequest/Comments]))

(s/def
  :cognitect.aws.guardduty/DeleteFilterRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.DeleteFilterRequest/DetectorId
     :cognitect.aws.guardduty.DeleteFilterRequest/FilterName]))

(s/def
  :cognitect.aws.guardduty/Country
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.Country/CountryName :cognitect.aws.guardduty.Country/CountryCode]))

(s/def
  :cognitect.aws.guardduty/GetIPSetResponse
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetIPSetResponse/Name
     :cognitect.aws.guardduty.GetIPSetResponse/Format
     :cognitect.aws.guardduty.GetIPSetResponse/Location
     :cognitect.aws.guardduty.GetIPSetResponse/Status]
    :opt-un
    [:cognitect.aws.guardduty.GetIPSetResponse/Tags]))

(s/def
  :cognitect.aws.guardduty/ArchiveFindingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ArchiveFindingsRequest/DetectorId
     :cognitect.aws.guardduty.ArchiveFindingsRequest/FindingIds]))

(s/def
  :cognitect.aws.guardduty/Condition
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.Condition/GreaterThanOrEqual
     :cognitect.aws.guardduty.Condition/Lte
     :cognitect.aws.guardduty.Condition/Lt
     :cognitect.aws.guardduty.Condition/NotEquals
     :cognitect.aws.guardduty.Condition/LessThan
     :cognitect.aws.guardduty.Condition/Neq
     :cognitect.aws.guardduty.Condition/Gt
     :cognitect.aws.guardduty.Condition/GreaterThan
     :cognitect.aws.guardduty.Condition/Gte
     :cognitect.aws.guardduty.Condition/LessThanOrEqual
     :cognitect.aws.guardduty.Condition/Eq
     :cognitect.aws.guardduty.Condition/Equals]))

(s/def
  :cognitect.aws.guardduty/PortProbeDetail
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.PortProbeDetail/LocalPortDetails
     :cognitect.aws.guardduty.PortProbeDetail/RemoteIpDetails]))

(s/def
  :cognitect.aws.guardduty/ListIPSetsRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ListIPSetsRequest/DetectorId]
    :opt-un
    [:cognitect.aws.guardduty.ListIPSetsRequest/NextToken
     :cognitect.aws.guardduty.ListIPSetsRequest/MaxResults]))

(s/def
  :cognitect.aws.guardduty/DeleteDetectorRequest
  (s/keys :req-un [:cognitect.aws.guardduty.DeleteDetectorRequest/DetectorId]))

(s/def :cognitect.aws.guardduty/GetInvitationsCountRequest (s/keys))

(s/def
  :cognitect.aws.guardduty/CreateThreatIntelSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.CreateThreatIntelSetRequest/DetectorId
     :cognitect.aws.guardduty.CreateThreatIntelSetRequest/Name
     :cognitect.aws.guardduty.CreateThreatIntelSetRequest/Format
     :cognitect.aws.guardduty.CreateThreatIntelSetRequest/Location
     :cognitect.aws.guardduty.CreateThreatIntelSetRequest/Activate]
    :opt-un
    [:cognitect.aws.guardduty.CreateThreatIntelSetRequest/Tags
     :cognitect.aws.guardduty.CreateThreatIntelSetRequest/ClientToken]))

(s/def :cognitect.aws.guardduty/UpdateFindingsFeedbackResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/DeleteMembersResponse
  (s/keys :req-un [:cognitect.aws.guardduty.DeleteMembersResponse/UnprocessedAccounts]))

(s/def
  :cognitect.aws.guardduty/Double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.guardduty/FindingStatistics
  (s/keys :opt-un [:cognitect.aws.guardduty.FindingStatistics/CountBySeverity]))

(s/def
  :cognitect.aws.guardduty/Location
  (s/spec
    (s/and string? #(<= 1 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/PortProbeAction
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.PortProbeAction/Blocked
     :cognitect.aws.guardduty.PortProbeAction/PortProbeDetails]))

(s/def
  :cognitect.aws.guardduty/Organization
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.Organization/Isp
     :cognitect.aws.guardduty.Organization/AsnOrg
     :cognitect.aws.guardduty.Organization/Org
     :cognitect.aws.guardduty.Organization/Asn]))

(s/def :cognitect.aws.guardduty/Equals (s/coll-of :cognitect.aws.guardduty/String))

(s/def
  :cognitect.aws.guardduty/FilterAction
  (s/spec
    (s/and string? #(<= 1 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/NetworkInterfaces
  (s/coll-of :cognitect.aws.guardduty/NetworkInterface))

(s/def :cognitect.aws.guardduty/DeleteFilterResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.guardduty.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.guardduty/DetectorStatus
  (s/spec
    (s/and string? #(<= 1 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/GuardDutyArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:[A-Za-z_.-]{1,20}:guardduty:[A-Za-z0-9_/.-]{0,63}:\\d+:detector/[A-Za-z0-9_/.-]{32,264}$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.guardduty/DnsRequestAction
  (s/keys :opt-un [:cognitect.aws.guardduty.DnsRequestAction/Domain]))

(s/def
  :cognitect.aws.guardduty/Master
  (s/keys
    :opt-un
    [:cognitect.aws.guardduty.Master/InvitationId
     :cognitect.aws.guardduty.Master/RelationshipStatus
     :cognitect.aws.guardduty.Master/AccountId
     :cognitect.aws.guardduty.Master/InvitedAt]))

(s/def
  :cognitect.aws.guardduty/GetIPSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.GetIPSetRequest/DetectorId
     :cognitect.aws.guardduty.GetIPSetRequest/IpSetId]))

(s/def
  :cognitect.aws.guardduty/DetectorIds
  (s/coll-of :cognitect.aws.guardduty/DetectorId :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.guardduty/ListFindingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ListFindingsRequest/DetectorId]
    :opt-un
    [:cognitect.aws.guardduty.ListFindingsRequest/NextToken
     :cognitect.aws.guardduty.ListFindingsRequest/MaxResults
     :cognitect.aws.guardduty.ListFindingsRequest/FindingCriteria
     :cognitect.aws.guardduty.ListFindingsRequest/SortCriteria]))

(s/def :cognitect.aws.guardduty/CreateSampleFindingsResponse (s/keys))

(s/def
  :cognitect.aws.guardduty/ListIPSetsResponse
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ListIPSetsResponse/IpSetIds]
    :opt-un
    [:cognitect.aws.guardduty.ListIPSetsResponse/NextToken]))

(s/def
  :cognitect.aws.guardduty/ListThreatIntelSetsResponse
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ListThreatIntelSetsResponse/ThreatIntelSetIds]
    :opt-un
    [:cognitect.aws.guardduty.ListThreatIntelSetsResponse/NextToken]))

(s/def
  :cognitect.aws.guardduty/AcceptInvitationRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.AcceptInvitationRequest/DetectorId
     :cognitect.aws.guardduty.AcceptInvitationRequest/MasterId
     :cognitect.aws.guardduty.AcceptInvitationRequest/InvitationId]))

(s/def
  :cognitect.aws.guardduty/StopMonitoringMembersResponse
  (s/keys :req-un [:cognitect.aws.guardduty.StopMonitoringMembersResponse/UnprocessedAccounts]))

(s/def
  :cognitect.aws.guardduty/DetectorId
  (s/spec
    (s/and string? #(<= 1 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.guardduty/DeleteInvitationsResponse
  (s/keys :req-un [:cognitect.aws.guardduty.DeleteInvitationsResponse/UnprocessedAccounts]))

(s/def :cognitect.aws.guardduty/String string?)

(s/def :cognitect.aws.guardduty/Ipv6Addresses (s/coll-of :cognitect.aws.guardduty/String))

(s/def
  :cognitect.aws.guardduty/Findings
  (s/coll-of :cognitect.aws.guardduty/Finding :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.guardduty/AccountIds
  (s/coll-of :cognitect.aws.guardduty/AccountId :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.guardduty/TagKeyList
  (s/coll-of :cognitect.aws.guardduty/TagKey :min-count 1 :max-count 200))

(s/def
  :cognitect.aws.guardduty/ListThreatIntelSetsRequest
  (s/keys
    :req-un
    [:cognitect.aws.guardduty.ListThreatIntelSetsRequest/DetectorId]
    :opt-un
    [:cognitect.aws.guardduty.ListThreatIntelSetsRequest/NextToken
     :cognitect.aws.guardduty.ListThreatIntelSetsRequest/MaxResults]))

(s/def :cognitect.aws.guardduty/UpdateIPSetResponse (s/keys))

(s/def :cognitect.aws.guardduty.CreateIPSetResponse/IpSetId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.GetDetectorResponse/CreatedAt :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.GetDetectorResponse/FindingPublishingFrequency
  :cognitect.aws.guardduty/FindingPublishingFrequency)

(s/def :cognitect.aws.guardduty.GetDetectorResponse/ServiceRole :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.GetDetectorResponse/Status :cognitect.aws.guardduty/DetectorStatus)

(s/def :cognitect.aws.guardduty.GetDetectorResponse/UpdatedAt :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.GetDetectorResponse/Tags :cognitect.aws.guardduty/TagMap)

(s/def :cognitect.aws.guardduty.Service/Evidence :cognitect.aws.guardduty/Evidence)

(s/def :cognitect.aws.guardduty.Service/EventLastSeen :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Service/Archived :cognitect.aws.guardduty/Boolean)

(s/def :cognitect.aws.guardduty.Service/EventFirstSeen :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Service/Action :cognitect.aws.guardduty/Action)

(s/def :cognitect.aws.guardduty.Service/UserFeedback :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Service/Count :cognitect.aws.guardduty/Integer)

(s/def :cognitect.aws.guardduty.Service/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.Service/ResourceRole :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Service/ServiceName :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.TagResourceRequest/ResourceArn
  :cognitect.aws.guardduty/GuardDutyArn)

(s/def :cognitect.aws.guardduty.TagResourceRequest/Tags :cognitect.aws.guardduty/TagMap)

(s/def :cognitect.aws.guardduty.AccountDetail/AccountId :cognitect.aws.guardduty/AccountId)

(s/def :cognitect.aws.guardduty.AccountDetail/Email :cognitect.aws.guardduty/Email)

(s/def
  :cognitect.aws.guardduty.CreateThreatIntelSetResponse/ThreatIntelSetId
  :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.LocalPortDetails/Port :cognitect.aws.guardduty/Integer)

(s/def :cognitect.aws.guardduty.LocalPortDetails/PortName :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.DisassociateMembersResponse/UnprocessedAccounts
  :cognitect.aws.guardduty/UnprocessedAccounts)

(s/def
  :cognitect.aws.guardduty.DeclineInvitationsResponse/UnprocessedAccounts
  :cognitect.aws.guardduty/UnprocessedAccounts)

(s/def
  :cognitect.aws.guardduty.GetMasterAccountRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.Tag/Key :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Tag/Value :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.AwsApiCallAction/Api :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.AwsApiCallAction/CallerType :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.AwsApiCallAction/DomainDetails
  :cognitect.aws.guardduty/DomainDetails)

(s/def
  :cognitect.aws.guardduty.AwsApiCallAction/RemoteIpDetails
  :cognitect.aws.guardduty/RemoteIpDetails)

(s/def :cognitect.aws.guardduty.AwsApiCallAction/ServiceName :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.Evidence/ThreatIntelligenceDetails
  :cognitect.aws.guardduty/ThreatIntelligenceDetails)

(s/def
  :cognitect.aws.guardduty.DeleteInvitationsRequest/AccountIds
  :cognitect.aws.guardduty/AccountIds)

(s/def :cognitect.aws.guardduty.ListMembersResponse/Members :cognitect.aws.guardduty/Members)

(s/def :cognitect.aws.guardduty.ListMembersResponse/NextToken :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.GetFindingsResponse/Findings :cognitect.aws.guardduty/Findings)

(s/def
  :cognitect.aws.guardduty.InviteMembersResponse/UnprocessedAccounts
  :cognitect.aws.guardduty/UnprocessedAccounts)

(s/def
  :cognitect.aws.guardduty.GetFindingsStatisticsRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.GetFindingsStatisticsRequest/FindingStatisticTypes
  :cognitect.aws.guardduty/FindingStatisticTypes)

(s/def
  :cognitect.aws.guardduty.GetFindingsStatisticsRequest/FindingCriteria
  :cognitect.aws.guardduty/FindingCriteria)

(s/def
  :cognitect.aws.guardduty.UpdateDetectorRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.UpdateDetectorRequest/Enable :cognitect.aws.guardduty/Boolean)

(s/def
  :cognitect.aws.guardduty.UpdateDetectorRequest/FindingPublishingFrequency
  :cognitect.aws.guardduty/FindingPublishingFrequency)

(s/def :cognitect.aws.guardduty.Invitation/AccountId :cognitect.aws.guardduty/AccountId)

(s/def :cognitect.aws.guardduty.Invitation/InvitationId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Invitation/RelationshipStatus :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Invitation/InvitedAt :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.UnprocessedAccount/AccountId :cognitect.aws.guardduty/AccountId)

(s/def :cognitect.aws.guardduty.UnprocessedAccount/Result :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Member/AccountId :cognitect.aws.guardduty/AccountId)

(s/def :cognitect.aws.guardduty.Member/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.Member/MasterId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Member/Email :cognitect.aws.guardduty/Email)

(s/def :cognitect.aws.guardduty.Member/RelationshipStatus :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Member/InvitedAt :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Member/UpdatedAt :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.GetMasterAccountResponse/Master :cognitect.aws.guardduty/Master)

(s/def :cognitect.aws.guardduty.ListMembersRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.ListMembersRequest/MaxResults :cognitect.aws.guardduty/MaxResults)

(s/def :cognitect.aws.guardduty.ListMembersRequest/NextToken :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.ListMembersRequest/OnlyAssociated :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.ProductCode/Code :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.ProductCode/ProductType :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.ListFiltersResponse/FilterNames
  :cognitect.aws.guardduty/FilterNames)

(s/def :cognitect.aws.guardduty.ListFiltersResponse/NextToken :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.ListDetectorsResponse/DetectorIds
  :cognitect.aws.guardduty/DetectorIds)

(s/def :cognitect.aws.guardduty.ListDetectorsResponse/NextToken :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.SecurityGroup/GroupId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.SecurityGroup/GroupName :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.DeclineInvitationsRequest/AccountIds
  :cognitect.aws.guardduty/AccountIds)

(s/def :cognitect.aws.guardduty.GetMembersRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.GetMembersRequest/AccountIds :cognitect.aws.guardduty/AccountIds)

(s/def :cognitect.aws.guardduty.DeleteIPSetRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.DeleteIPSetRequest/IpSetId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.NetworkInterface/PrivateIpAddress :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.NetworkInterface/PrivateIpAddresses
  :cognitect.aws.guardduty/PrivateIpAddresses)

(s/def :cognitect.aws.guardduty.NetworkInterface/PublicIp :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.NetworkInterface/SubnetId :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.NetworkInterface/SecurityGroups
  :cognitect.aws.guardduty/SecurityGroups)

(s/def :cognitect.aws.guardduty.NetworkInterface/PrivateDnsName :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.NetworkInterface/PublicDnsName :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.NetworkInterface/VpcId :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.NetworkInterface/Ipv6Addresses
  :cognitect.aws.guardduty/Ipv6Addresses)

(s/def :cognitect.aws.guardduty.NetworkInterface/NetworkInterfaceId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.UpdateFilterResponse/Name :cognitect.aws.guardduty/FilterName)

(s/def :cognitect.aws.guardduty.City/CityName :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.DeleteThreatIntelSetRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.DeleteThreatIntelSetRequest/ThreatIntelSetId
  :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.StartMonitoringMembersRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.StartMonitoringMembersRequest/AccountIds
  :cognitect.aws.guardduty/AccountIds)

(s/def
  :cognitect.aws.guardduty.StopMonitoringMembersRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.StopMonitoringMembersRequest/AccountIds
  :cognitect.aws.guardduty/AccountIds)

(s/def
  :cognitect.aws.guardduty.DisassociateMembersRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.DisassociateMembersRequest/AccountIds
  :cognitect.aws.guardduty/AccountIds)

(s/def :cognitect.aws.guardduty.CreateMembersRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.CreateMembersRequest/AccountDetails
  :cognitect.aws.guardduty/AccountDetails)

(s/def
  :cognitect.aws.guardduty.GetInvitationsCountResponse/InvitationsCount
  :cognitect.aws.guardduty/Integer)

(s/def
  :cognitect.aws.guardduty.GetFindingsStatisticsResponse/FindingStatistics
  :cognitect.aws.guardduty/FindingStatistics)

(s/def :cognitect.aws.guardduty.CreateFilterRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.CreateFilterRequest/Name :cognitect.aws.guardduty/FilterName)

(s/def
  :cognitect.aws.guardduty.CreateFilterRequest/Description
  :cognitect.aws.guardduty/FilterDescription)

(s/def :cognitect.aws.guardduty.CreateFilterRequest/Action :cognitect.aws.guardduty/FilterAction)

(s/def :cognitect.aws.guardduty.CreateFilterRequest/Rank :cognitect.aws.guardduty/FilterRank)

(s/def
  :cognitect.aws.guardduty.CreateFilterRequest/FindingCriteria
  :cognitect.aws.guardduty/FindingCriteria)

(s/def
  :cognitect.aws.guardduty.CreateFilterRequest/ClientToken
  :cognitect.aws.guardduty/ClientToken)

(s/def :cognitect.aws.guardduty.CreateFilterRequest/Tags :cognitect.aws.guardduty/TagMap)

(s/def
  :cognitect.aws.guardduty.CreateSampleFindingsRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.CreateSampleFindingsRequest/FindingTypes
  :cognitect.aws.guardduty/FindingTypes)

(s/def
  :cognitect.aws.guardduty.ListInvitationsResponse/Invitations
  :cognitect.aws.guardduty/Invitations)

(s/def :cognitect.aws.guardduty.ListInvitationsResponse/NextToken :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.GetThreatIntelSetRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.GetThreatIntelSetRequest/ThreatIntelSetId
  :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.GetFilterRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.GetFilterRequest/FilterName :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.GetThreatIntelSetResponse/Name :cognitect.aws.guardduty/Name)

(s/def
  :cognitect.aws.guardduty.GetThreatIntelSetResponse/Format
  :cognitect.aws.guardduty/ThreatIntelSetFormat)

(s/def
  :cognitect.aws.guardduty.GetThreatIntelSetResponse/Location
  :cognitect.aws.guardduty/Location)

(s/def
  :cognitect.aws.guardduty.GetThreatIntelSetResponse/Status
  :cognitect.aws.guardduty/ThreatIntelSetStatus)

(s/def :cognitect.aws.guardduty.GetThreatIntelSetResponse/Tags :cognitect.aws.guardduty/TagMap)

(s/def :cognitect.aws.guardduty.CreateFilterResponse/Name :cognitect.aws.guardduty/FilterName)

(s/def :cognitect.aws.guardduty.DeleteMembersRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.DeleteMembersRequest/AccountIds :cognitect.aws.guardduty/AccountIds)

(s/def :cognitect.aws.guardduty.ListFindingsResponse/FindingIds :cognitect.aws.guardduty/FindingIds)

(s/def :cognitect.aws.guardduty.ListFindingsResponse/NextToken :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.GetDetectorRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.CreateIPSetRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.CreateIPSetRequest/Name :cognitect.aws.guardduty/Name)

(s/def :cognitect.aws.guardduty.CreateIPSetRequest/Format :cognitect.aws.guardduty/IpSetFormat)

(s/def :cognitect.aws.guardduty.CreateIPSetRequest/Location :cognitect.aws.guardduty/Location)

(s/def :cognitect.aws.guardduty.CreateIPSetRequest/Activate :cognitect.aws.guardduty/Boolean)

(s/def :cognitect.aws.guardduty.CreateIPSetRequest/ClientToken :cognitect.aws.guardduty/ClientToken)

(s/def :cognitect.aws.guardduty.CreateIPSetRequest/Tags :cognitect.aws.guardduty/TagMap)

(s/def
  :cognitect.aws.guardduty.CreateMembersResponse/UnprocessedAccounts
  :cognitect.aws.guardduty/UnprocessedAccounts)

(s/def :cognitect.aws.guardduty.InstanceDetails/AvailabilityZone :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.InstanceDetails/LaunchTime :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.InstanceDetails/ImageId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.InstanceDetails/Tags :cognitect.aws.guardduty/Tags)

(s/def :cognitect.aws.guardduty.InstanceDetails/InstanceId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.InstanceDetails/InstanceType :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.InstanceDetails/ProductCodes :cognitect.aws.guardduty/ProductCodes)

(s/def :cognitect.aws.guardduty.InstanceDetails/Platform :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.InstanceDetails/ImageDescription :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.InstanceDetails/IamInstanceProfile
  :cognitect.aws.guardduty/IamInstanceProfile)

(s/def :cognitect.aws.guardduty.InstanceDetails/InstanceState :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.InstanceDetails/NetworkInterfaces
  :cognitect.aws.guardduty/NetworkInterfaces)

(s/def :cognitect.aws.guardduty.ListDetectorsRequest/MaxResults :cognitect.aws.guardduty/MaxResults)

(s/def :cognitect.aws.guardduty.ListDetectorsRequest/NextToken :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.StartMonitoringMembersResponse/UnprocessedAccounts
  :cognitect.aws.guardduty/UnprocessedAccounts)

(s/def :cognitect.aws.guardduty.GetFilterResponse/Name :cognitect.aws.guardduty/FilterName)

(s/def
  :cognitect.aws.guardduty.GetFilterResponse/Description
  :cognitect.aws.guardduty/FilterDescription)

(s/def :cognitect.aws.guardduty.GetFilterResponse/Action :cognitect.aws.guardduty/FilterAction)

(s/def :cognitect.aws.guardduty.GetFilterResponse/Rank :cognitect.aws.guardduty/FilterRank)

(s/def
  :cognitect.aws.guardduty.GetFilterResponse/FindingCriteria
  :cognitect.aws.guardduty/FindingCriteria)

(s/def :cognitect.aws.guardduty.GetFilterResponse/Tags :cognitect.aws.guardduty/TagMap)

(s/def
  :cognitect.aws.guardduty.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.guardduty/GuardDutyArn)

(s/def :cognitect.aws.guardduty.ListFiltersRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.ListFiltersRequest/MaxResults :cognitect.aws.guardduty/MaxResults)

(s/def :cognitect.aws.guardduty.ListFiltersRequest/NextToken :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.ThreatIntelligenceDetail/ThreatListName
  :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.ThreatIntelligenceDetail/ThreatNames
  :cognitect.aws.guardduty/ThreatNames)

(s/def :cognitect.aws.guardduty.GetFindingsRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.GetFindingsRequest/FindingIds :cognitect.aws.guardduty/FindingIds)

(s/def
  :cognitect.aws.guardduty.GetFindingsRequest/SortCriteria
  :cognitect.aws.guardduty/SortCriteria)

(s/def :cognitect.aws.guardduty.GetMembersResponse/Members :cognitect.aws.guardduty/Members)

(s/def
  :cognitect.aws.guardduty.GetMembersResponse/UnprocessedAccounts
  :cognitect.aws.guardduty/UnprocessedAccounts)

(s/def :cognitect.aws.guardduty.CreateDetectorRequest/Enable :cognitect.aws.guardduty/Boolean)

(s/def
  :cognitect.aws.guardduty.CreateDetectorRequest/ClientToken
  :cognitect.aws.guardduty/ClientToken)

(s/def
  :cognitect.aws.guardduty.CreateDetectorRequest/FindingPublishingFrequency
  :cognitect.aws.guardduty/FindingPublishingFrequency)

(s/def :cognitect.aws.guardduty.CreateDetectorRequest/Tags :cognitect.aws.guardduty/TagMap)

(s/def
  :cognitect.aws.guardduty.ListInvitationsRequest/MaxResults
  :cognitect.aws.guardduty/MaxResults)

(s/def :cognitect.aws.guardduty.ListInvitationsRequest/NextToken :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.UpdateFilterRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.UpdateFilterRequest/FilterName :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.UpdateFilterRequest/Description
  :cognitect.aws.guardduty/FilterDescription)

(s/def :cognitect.aws.guardduty.UpdateFilterRequest/Action :cognitect.aws.guardduty/FilterAction)

(s/def :cognitect.aws.guardduty.UpdateFilterRequest/Rank :cognitect.aws.guardduty/FilterRank)

(s/def
  :cognitect.aws.guardduty.UpdateFilterRequest/FindingCriteria
  :cognitect.aws.guardduty/FindingCriteria)

(s/def :cognitect.aws.guardduty.FindingCriteria/Criterion :cognitect.aws.guardduty/Criterion)

(s/def
  :cognitect.aws.guardduty.DisassociateFromMasterAccountRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.InviteMembersRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.InviteMembersRequest/AccountIds :cognitect.aws.guardduty/AccountIds)

(s/def
  :cognitect.aws.guardduty.InviteMembersRequest/DisableEmailNotification
  :cognitect.aws.guardduty/Boolean)

(s/def :cognitect.aws.guardduty.InviteMembersRequest/Message :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.CreateDetectorResponse/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.RemotePortDetails/Port :cognitect.aws.guardduty/Integer)

(s/def :cognitect.aws.guardduty.RemotePortDetails/PortName :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.UnarchiveFindingsRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.UnarchiveFindingsRequest/FindingIds
  :cognitect.aws.guardduty/FindingIds)

(s/def :cognitect.aws.guardduty.Action/ActionType :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Action/AwsApiCallAction :cognitect.aws.guardduty/AwsApiCallAction)

(s/def :cognitect.aws.guardduty.Action/DnsRequestAction :cognitect.aws.guardduty/DnsRequestAction)

(s/def
  :cognitect.aws.guardduty.Action/NetworkConnectionAction
  :cognitect.aws.guardduty/NetworkConnectionAction)

(s/def :cognitect.aws.guardduty.Action/PortProbeAction :cognitect.aws.guardduty/PortProbeAction)

(s/def :cognitect.aws.guardduty.NetworkConnectionAction/Blocked :cognitect.aws.guardduty/Boolean)

(s/def
  :cognitect.aws.guardduty.NetworkConnectionAction/ConnectionDirection
  :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.NetworkConnectionAction/LocalPortDetails
  :cognitect.aws.guardduty/LocalPortDetails)

(s/def :cognitect.aws.guardduty.NetworkConnectionAction/Protocol :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.NetworkConnectionAction/RemoteIpDetails
  :cognitect.aws.guardduty/RemoteIpDetails)

(s/def
  :cognitect.aws.guardduty.NetworkConnectionAction/RemotePortDetails
  :cognitect.aws.guardduty/RemotePortDetails)

(s/def :cognitect.aws.guardduty.RemoteIpDetails/City :cognitect.aws.guardduty/City)

(s/def :cognitect.aws.guardduty.RemoteIpDetails/Country :cognitect.aws.guardduty/Country)

(s/def :cognitect.aws.guardduty.RemoteIpDetails/GeoLocation :cognitect.aws.guardduty/GeoLocation)

(s/def :cognitect.aws.guardduty.RemoteIpDetails/IpAddressV4 :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.RemoteIpDetails/Organization :cognitect.aws.guardduty/Organization)

(s/def :cognitect.aws.guardduty.GeoLocation/Lat :cognitect.aws.guardduty/Double)

(s/def :cognitect.aws.guardduty.GeoLocation/Lon :cognitect.aws.guardduty/Double)

(s/def :cognitect.aws.guardduty.Finding/SchemaVersion :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Finding/Severity :cognitect.aws.guardduty/Double)

(s/def :cognitect.aws.guardduty.Finding/Service :cognitect.aws.guardduty/Service)

(s/def :cognitect.aws.guardduty.Finding/CreatedAt :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Finding/UpdatedAt :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Finding/AccountId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Finding/Id :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Finding/Title :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Finding/Region :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Finding/Arn :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Finding/Resource :cognitect.aws.guardduty/Resource)

(s/def :cognitect.aws.guardduty.Finding/Description :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Finding/Type :cognitect.aws.guardduty/FindingType)

(s/def :cognitect.aws.guardduty.Finding/Partition :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Finding/Confidence :cognitect.aws.guardduty/Double)

(s/def :cognitect.aws.guardduty.AccessKeyDetails/AccessKeyId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.AccessKeyDetails/PrincipalId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.AccessKeyDetails/UserName :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.AccessKeyDetails/UserType :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.IamInstanceProfile/Arn :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.IamInstanceProfile/Id :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.UntagResourceRequest/ResourceArn
  :cognitect.aws.guardduty/GuardDutyArn)

(s/def :cognitect.aws.guardduty.UntagResourceRequest/TagKeys :cognitect.aws.guardduty/TagKeyList)

(s/def :cognitect.aws.guardduty.SortCriteria/AttributeName :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.SortCriteria/OrderBy :cognitect.aws.guardduty/OrderBy)

(s/def :cognitect.aws.guardduty.Resource/AccessKeyDetails :cognitect.aws.guardduty/AccessKeyDetails)

(s/def :cognitect.aws.guardduty.Resource/InstanceDetails :cognitect.aws.guardduty/InstanceDetails)

(s/def :cognitect.aws.guardduty.Resource/ResourceType :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.UpdateThreatIntelSetRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.UpdateThreatIntelSetRequest/ThreatIntelSetId
  :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.UpdateThreatIntelSetRequest/Name :cognitect.aws.guardduty/Name)

(s/def
  :cognitect.aws.guardduty.UpdateThreatIntelSetRequest/Location
  :cognitect.aws.guardduty/Location)

(s/def
  :cognitect.aws.guardduty.UpdateThreatIntelSetRequest/Activate
  :cognitect.aws.guardduty/Boolean)

(s/def :cognitect.aws.guardduty.DomainDetails/Domain :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.PrivateIpAddressDetails/PrivateDnsName
  :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.PrivateIpAddressDetails/PrivateIpAddress
  :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.UpdateIPSetRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.UpdateIPSetRequest/IpSetId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.UpdateIPSetRequest/Name :cognitect.aws.guardduty/Name)

(s/def :cognitect.aws.guardduty.UpdateIPSetRequest/Location :cognitect.aws.guardduty/Location)

(s/def :cognitect.aws.guardduty.UpdateIPSetRequest/Activate :cognitect.aws.guardduty/Boolean)

(s/def
  :cognitect.aws.guardduty.UpdateFindingsFeedbackRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.UpdateFindingsFeedbackRequest/FindingIds
  :cognitect.aws.guardduty/FindingIds)

(s/def
  :cognitect.aws.guardduty.UpdateFindingsFeedbackRequest/Feedback
  :cognitect.aws.guardduty/Feedback)

(s/def
  :cognitect.aws.guardduty.UpdateFindingsFeedbackRequest/Comments
  :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.DeleteFilterRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.DeleteFilterRequest/FilterName :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Country/CountryCode :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Country/CountryName :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.GetIPSetResponse/Name :cognitect.aws.guardduty/Name)

(s/def :cognitect.aws.guardduty.GetIPSetResponse/Format :cognitect.aws.guardduty/IpSetFormat)

(s/def :cognitect.aws.guardduty.GetIPSetResponse/Location :cognitect.aws.guardduty/Location)

(s/def :cognitect.aws.guardduty.GetIPSetResponse/Status :cognitect.aws.guardduty/IpSetStatus)

(s/def :cognitect.aws.guardduty.GetIPSetResponse/Tags :cognitect.aws.guardduty/TagMap)

(s/def
  :cognitect.aws.guardduty.ArchiveFindingsRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.ArchiveFindingsRequest/FindingIds
  :cognitect.aws.guardduty/FindingIds)

(s/def :cognitect.aws.guardduty.Condition/Neq :cognitect.aws.guardduty/Neq)

(s/def :cognitect.aws.guardduty.Condition/Eq :cognitect.aws.guardduty/Eq)

(s/def :cognitect.aws.guardduty.Condition/GreaterThanOrEqual :cognitect.aws.guardduty/Long)

(s/def :cognitect.aws.guardduty.Condition/NotEquals :cognitect.aws.guardduty/NotEquals)

(s/def :cognitect.aws.guardduty.Condition/LessThanOrEqual :cognitect.aws.guardduty/Long)

(s/def :cognitect.aws.guardduty.Condition/Gt :cognitect.aws.guardduty/Integer)

(s/def :cognitect.aws.guardduty.Condition/LessThan :cognitect.aws.guardduty/Long)

(s/def :cognitect.aws.guardduty.Condition/Gte :cognitect.aws.guardduty/Integer)

(s/def :cognitect.aws.guardduty.Condition/GreaterThan :cognitect.aws.guardduty/Long)

(s/def :cognitect.aws.guardduty.Condition/Lte :cognitect.aws.guardduty/Integer)

(s/def :cognitect.aws.guardduty.Condition/Equals :cognitect.aws.guardduty/Equals)

(s/def :cognitect.aws.guardduty.Condition/Lt :cognitect.aws.guardduty/Integer)

(s/def
  :cognitect.aws.guardduty.PortProbeDetail/LocalPortDetails
  :cognitect.aws.guardduty/LocalPortDetails)

(s/def
  :cognitect.aws.guardduty.PortProbeDetail/RemoteIpDetails
  :cognitect.aws.guardduty/RemoteIpDetails)

(s/def :cognitect.aws.guardduty.ListIPSetsRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.ListIPSetsRequest/MaxResults :cognitect.aws.guardduty/MaxResults)

(s/def :cognitect.aws.guardduty.ListIPSetsRequest/NextToken :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.DeleteDetectorRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.CreateThreatIntelSetRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.CreateThreatIntelSetRequest/Name :cognitect.aws.guardduty/Name)

(s/def
  :cognitect.aws.guardduty.CreateThreatIntelSetRequest/Format
  :cognitect.aws.guardduty/ThreatIntelSetFormat)

(s/def
  :cognitect.aws.guardduty.CreateThreatIntelSetRequest/Location
  :cognitect.aws.guardduty/Location)

(s/def
  :cognitect.aws.guardduty.CreateThreatIntelSetRequest/Activate
  :cognitect.aws.guardduty/Boolean)

(s/def
  :cognitect.aws.guardduty.CreateThreatIntelSetRequest/ClientToken
  :cognitect.aws.guardduty/ClientToken)

(s/def :cognitect.aws.guardduty.CreateThreatIntelSetRequest/Tags :cognitect.aws.guardduty/TagMap)

(s/def
  :cognitect.aws.guardduty.DeleteMembersResponse/UnprocessedAccounts
  :cognitect.aws.guardduty/UnprocessedAccounts)

(s/def
  :cognitect.aws.guardduty.FindingStatistics/CountBySeverity
  :cognitect.aws.guardduty/CountBySeverity)

(s/def :cognitect.aws.guardduty.PortProbeAction/Blocked :cognitect.aws.guardduty/Boolean)

(s/def
  :cognitect.aws.guardduty.PortProbeAction/PortProbeDetails
  :cognitect.aws.guardduty/PortProbeDetails)

(s/def :cognitect.aws.guardduty.Organization/Asn :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Organization/AsnOrg :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Organization/Isp :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Organization/Org :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.ListTagsForResourceResponse/Tags :cognitect.aws.guardduty/TagMap)

(s/def :cognitect.aws.guardduty.DnsRequestAction/Domain :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Master/AccountId :cognitect.aws.guardduty/AccountId)

(s/def :cognitect.aws.guardduty.Master/InvitationId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Master/RelationshipStatus :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.Master/InvitedAt :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.GetIPSetRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.GetIPSetRequest/IpSetId :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.ListFindingsRequest/DetectorId :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.ListFindingsRequest/FindingCriteria
  :cognitect.aws.guardduty/FindingCriteria)

(s/def
  :cognitect.aws.guardduty.ListFindingsRequest/SortCriteria
  :cognitect.aws.guardduty/SortCriteria)

(s/def :cognitect.aws.guardduty.ListFindingsRequest/MaxResults :cognitect.aws.guardduty/MaxResults)

(s/def :cognitect.aws.guardduty.ListFindingsRequest/NextToken :cognitect.aws.guardduty/String)

(s/def :cognitect.aws.guardduty.ListIPSetsResponse/IpSetIds :cognitect.aws.guardduty/IpSetIds)

(s/def :cognitect.aws.guardduty.ListIPSetsResponse/NextToken :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.ListThreatIntelSetsResponse/ThreatIntelSetIds
  :cognitect.aws.guardduty/ThreatIntelSetIds)

(s/def
  :cognitect.aws.guardduty.ListThreatIntelSetsResponse/NextToken
  :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.AcceptInvitationRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def :cognitect.aws.guardduty.AcceptInvitationRequest/MasterId :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.AcceptInvitationRequest/InvitationId
  :cognitect.aws.guardduty/String)

(s/def
  :cognitect.aws.guardduty.StopMonitoringMembersResponse/UnprocessedAccounts
  :cognitect.aws.guardduty/UnprocessedAccounts)

(s/def
  :cognitect.aws.guardduty.DeleteInvitationsResponse/UnprocessedAccounts
  :cognitect.aws.guardduty/UnprocessedAccounts)

(s/def
  :cognitect.aws.guardduty.ListThreatIntelSetsRequest/DetectorId
  :cognitect.aws.guardduty/DetectorId)

(s/def
  :cognitect.aws.guardduty.ListThreatIntelSetsRequest/MaxResults
  :cognitect.aws.guardduty/MaxResults)

(s/def
  :cognitect.aws.guardduty.ListThreatIntelSetsRequest/NextToken
  :cognitect.aws.guardduty/String)

