;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.health.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.health/EventType
  (s/keys
    :opt-un
    [:cognitect.aws.health.EventType/category
     :cognitect.aws.health.EventType/service
     :cognitect.aws.health.EventType/code]))

(s/def
  :cognitect.aws.health/tagKey
  (s/spec #(re-matches (re-pattern ".{0,127}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/eventType
  (s/spec #(re-matches (re-pattern "[^:/]{3,100}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/DescribeAffectedEntitiesRequest
  (s/keys
    :req-un
    [:cognitect.aws.health.DescribeAffectedEntitiesRequest/filter]
    :opt-un
    [:cognitect.aws.health.DescribeAffectedEntitiesRequest/maxResults
     :cognitect.aws.health.DescribeAffectedEntitiesRequest/nextToken
     :cognitect.aws.health.DescribeAffectedEntitiesRequest/locale]))

(s/def
  :cognitect.aws.health/DescribeEventDetailsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeEventDetailsResponse/failedSet
     :cognitect.aws.health.DescribeEventDetailsResponse/successfulSet]))

(s/def
  :cognitect.aws.health/service
  (s/spec #(re-matches (re-pattern "[^:/]{2,30}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/DescribeEntityAggregatesResponse
  (s/keys :opt-un [:cognitect.aws.health.DescribeEntityAggregatesResponse/entityAggregates]))

(s/def
  :cognitect.aws.health/EntityAggregate
  (s/keys
    :opt-un
    [:cognitect.aws.health.EntityAggregate/eventArn :cognitect.aws.health.EntityAggregate/count]))

(s/def
  :cognitect.aws.health/DescribeEventsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeEventsRequest/maxResults
     :cognitect.aws.health.DescribeEventsRequest/nextToken
     :cognitect.aws.health.DescribeEventsRequest/locale
     :cognitect.aws.health.DescribeEventsRequest/filter]))

(s/def
  :cognitect.aws.health/eventStatusCode
  (s/spec string? :gen #(s/gen #{"upcoming" "closed" "open"})))

(s/def
  :cognitect.aws.health/entityStatusCodeList
  (s/coll-of :cognitect.aws.health/entityStatusCode :min-count 1 :max-count 3))

(s/def
  :cognitect.aws.health/eventTypeCategory
  (s/spec string? :gen #(s/gen #{"accountNotification" "issue" "scheduledChange" "investigation"})))

(s/def
  :cognitect.aws.health/OrganizationEventDetailFiltersList
  (s/coll-of :cognitect.aws.health/EventAccountFilter :min-count 1 :max-count 10))

(s/def :cognitect.aws.health/affectedAccountsList (s/coll-of :cognitect.aws.health/accountId))

(s/def
  :cognitect.aws.health/DescribeEventDetailsForOrganizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.health.DescribeEventDetailsForOrganizationRequest/organizationEventDetailFilters]
    :opt-un
    [:cognitect.aws.health.DescribeEventDetailsForOrganizationRequest/locale]))

(s/def :cognitect.aws.health/eventDescription string?)

(s/def
  :cognitect.aws.health/entityValueList
  (s/coll-of :cognitect.aws.health/entityValue :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.health/EventFilter
  (s/keys
    :opt-un
    [:cognitect.aws.health.EventFilter/availabilityZones
     :cognitect.aws.health.EventFilter/lastUpdatedTimes
     :cognitect.aws.health.EventFilter/services
     :cognitect.aws.health.EventFilter/tags
     :cognitect.aws.health.EventFilter/eventStatusCodes
     :cognitect.aws.health.EventFilter/entityValues
     :cognitect.aws.health.EventFilter/eventTypeCodes
     :cognitect.aws.health.EventFilter/regions
     :cognitect.aws.health.EventFilter/endTimes
     :cognitect.aws.health.EventFilter/eventArns
     :cognitect.aws.health.EventFilter/startTimes
     :cognitect.aws.health.EventFilter/eventTypeCategories
     :cognitect.aws.health.EventFilter/entityArns]))

(s/def
  :cognitect.aws.health/DescribeAffectedAccountsForOrganizationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeAffectedAccountsForOrganizationResponse/affectedAccounts
     :cognitect.aws.health.DescribeAffectedAccountsForOrganizationResponse/eventScopeCode
     :cognitect.aws.health.DescribeAffectedAccountsForOrganizationResponse/nextToken]))

(s/def
  :cognitect.aws.health/DescribeEventDetailsForOrganizationSuccessfulSet
  (s/coll-of :cognitect.aws.health/OrganizationEventDetails))

(s/def :cognitect.aws.health/EventAggregateList (s/coll-of :cognitect.aws.health/EventAggregate))

(s/def
  :cognitect.aws.health/awsAccountIdsList
  (s/coll-of :cognitect.aws.health/accountId :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.health/EventDetailsErrorItem
  (s/keys
    :opt-un
    [:cognitect.aws.health.EventDetailsErrorItem/errorName
     :cognitect.aws.health.EventDetailsErrorItem/errorMessage
     :cognitect.aws.health.EventDetailsErrorItem/eventArn]))

(s/def
  :cognitect.aws.health/entityArn
  (s/spec #(re-matches (re-pattern ".{0,1600}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/DescribeEntityAggregatesRequest
  (s/keys :opt-un [:cognitect.aws.health.DescribeEntityAggregatesRequest/eventArns]))

(s/def
  :cognitect.aws.health/entityArnList
  (s/coll-of :cognitect.aws.health/entityArn :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.health/locale
  (s/spec #(re-matches (re-pattern ".{2,256}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/OrganizationEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.health.OrganizationEventDetails/awsAccountId
     :cognitect.aws.health.OrganizationEventDetails/event
     :cognitect.aws.health.OrganizationEventDetails/eventMetadata
     :cognitect.aws.health.OrganizationEventDetails/eventDescription]))

(s/def
  :cognitect.aws.health/DescribeEventDetailsForOrganizationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeEventDetailsForOrganizationResponse/failedSet
     :cognitect.aws.health.DescribeEventDetailsForOrganizationResponse/successfulSet]))

(s/def
  :cognitect.aws.health/EventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.health.EventDetails/event
     :cognitect.aws.health.EventDetails/eventMetadata
     :cognitect.aws.health.EventDetails/eventDescription]))

(s/def :cognitect.aws.health/EntityAggregateList (s/coll-of :cognitect.aws.health/EntityAggregate))

(s/def
  :cognitect.aws.health/eventStatusCodeList
  (s/coll-of :cognitect.aws.health/eventStatusCode :min-count 1 :max-count 6))

(s/def :cognitect.aws.health/aggregateValue string?)

(s/def
  :cognitect.aws.health/EventTypeCategoryList
  (s/coll-of :cognitect.aws.health/eventTypeCategory :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.health/DescribeEventAggregatesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeEventAggregatesResponse/nextToken
     :cognitect.aws.health.DescribeEventAggregatesResponse/eventAggregates]))

(s/def
  :cognitect.aws.health/DescribeEventsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeEventsResponse/nextToken
     :cognitect.aws.health.DescribeEventsResponse/events]))

(s/def
  :cognitect.aws.health/eventTypeCategoryList
  (s/coll-of :cognitect.aws.health/eventTypeCategory :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.health/DescribeEventDetailsSuccessfulSet
  (s/coll-of :cognitect.aws.health/EventDetails))

(s/def
  :cognitect.aws.health/Event
  (s/keys
    :opt-un
    [:cognitect.aws.health.Event/arn
     :cognitect.aws.health.Event/eventScopeCode
     :cognitect.aws.health.Event/startTime
     :cognitect.aws.health.Event/lastUpdatedTime
     :cognitect.aws.health.Event/statusCode
     :cognitect.aws.health.Event/region
     :cognitect.aws.health.Event/availabilityZone
     :cognitect.aws.health.Event/eventTypeCategory
     :cognitect.aws.health.Event/eventTypeCode
     :cognitect.aws.health.Event/endTime
     :cognitect.aws.health.Event/service]))

(s/def
  :cognitect.aws.health/DescribeAffectedEntitiesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeAffectedEntitiesResponse/nextToken
     :cognitect.aws.health.DescribeAffectedEntitiesResponse/entities]))

(s/def
  :cognitect.aws.health/DescribeEventsForOrganizationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeEventsForOrganizationRequest/maxResults
     :cognitect.aws.health.DescribeEventsForOrganizationRequest/nextToken
     :cognitect.aws.health.DescribeEventsForOrganizationRequest/locale
     :cognitect.aws.health.DescribeEventsForOrganizationRequest/filter]))

(s/def
  :cognitect.aws.health/DescribeEventTypesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeEventTypesRequest/maxResults
     :cognitect.aws.health.DescribeEventTypesRequest/nextToken
     :cognitect.aws.health.DescribeEventTypesRequest/locale
     :cognitect.aws.health.DescribeEventTypesRequest/filter]))

(s/def
  :cognitect.aws.health/DescribeAffectedEntitiesForOrganizationFailedSet
  (s/coll-of :cognitect.aws.health/OrganizationAffectedEntitiesErrorItem))

(s/def
  :cognitect.aws.health/eventArn
  (s/spec
    #(re-matches
      (re-pattern "arn:aws(-[a-z]+(-[a-z]+)?)?:health:[^:]*:[^:]*:event(?:/[\\w-]+){3}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.health/tagValue
  (s/spec #(re-matches (re-pattern ".{0,255}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/EntityFilter
  (s/keys
    :req-un
    [:cognitect.aws.health.EntityFilter/eventArns]
    :opt-un
    [:cognitect.aws.health.EntityFilter/lastUpdatedTimes
     :cognitect.aws.health.EntityFilter/tags
     :cognitect.aws.health.EntityFilter/entityValues
     :cognitect.aws.health.EntityFilter/statusCodes
     :cognitect.aws.health.EntityFilter/entityArns]))

(s/def :cognitect.aws.health/EventList (s/coll-of :cognitect.aws.health/Event))

(s/def :cognitect.aws.health/string string?)

(s/def
  :cognitect.aws.health/eventArnList
  (s/coll-of :cognitect.aws.health/eventArn :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.health/entityStatusCode
  (s/spec string? :gen #(s/gen #{"UNKNOWN" "UNIMPAIRED" "IMPAIRED"})))

(s/def
  :cognitect.aws.health/eventTypeList
  (s/coll-of :cognitect.aws.health/eventType :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.health/eventMetadata
  (s/map-of :cognitect.aws.health/metadataKey :cognitect.aws.health/metadataValue))

(s/def
  :cognitect.aws.health/entityValue
  (s/spec #(re-matches (re-pattern ".{0,1224}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/EventAccountFilter
  (s/keys
    :req-un
    [:cognitect.aws.health.EventAccountFilter/eventArn]
    :opt-un
    [:cognitect.aws.health.EventAccountFilter/awsAccountId]))

(s/def
  :cognitect.aws.health/DescribeAffectedEntitiesForOrganizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.health.DescribeAffectedEntitiesForOrganizationRequest/organizationEntityFilters]
    :opt-un
    [:cognitect.aws.health.DescribeAffectedEntitiesForOrganizationRequest/maxResults
     :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationRequest/nextToken
     :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationRequest/locale]))

(s/def
  :cognitect.aws.health/OrganizationEntityFiltersList
  (s/coll-of :cognitect.aws.health/EventAccountFilter :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.health/region
  (s/spec #(re-matches (re-pattern "[^:/]{2,25}") %) :gen #(gen/string)))

(s/def :cognitect.aws.health/EntityList (s/coll-of :cognitect.aws.health/AffectedEntity))

(s/def
  :cognitect.aws.health/DescribeAffectedAccountsForOrganizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.health.DescribeAffectedAccountsForOrganizationRequest/eventArn]
    :opt-un
    [:cognitect.aws.health.DescribeAffectedAccountsForOrganizationRequest/maxResults
     :cognitect.aws.health.DescribeAffectedAccountsForOrganizationRequest/nextToken]))

(s/def
  :cognitect.aws.health/availabilityZone
  (s/spec #(re-matches (re-pattern "[a-z]{2}\\-[0-9a-z\\-]{4,16}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/EventDescription
  (s/keys :opt-un [:cognitect.aws.health.EventDescription/latestDescription]))

(s/def
  :cognitect.aws.health/regionList
  (s/coll-of :cognitect.aws.health/region :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.health/OrganizationAffectedEntitiesErrorItem
  (s/keys
    :opt-un
    [:cognitect.aws.health.OrganizationAffectedEntitiesErrorItem/awsAccountId
     :cognitect.aws.health.OrganizationAffectedEntitiesErrorItem/errorName
     :cognitect.aws.health.OrganizationAffectedEntitiesErrorItem/errorMessage
     :cognitect.aws.health.OrganizationAffectedEntitiesErrorItem/eventArn]))

(s/def
  :cognitect.aws.health/DescribeHealthServiceStatusForOrganizationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeHealthServiceStatusForOrganizationResponse/healthServiceAccessStatusForOrganization]))

(s/def :cognitect.aws.health/tagFilter (s/coll-of :cognitect.aws.health/tagSet :max-count 50))

(s/def
  :cognitect.aws.health/DescribeEventTypesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeEventTypesResponse/eventTypes
     :cognitect.aws.health.DescribeEventTypesResponse/nextToken]))

(s/def :cognitect.aws.health/entityUrl string?)

(s/def :cognitect.aws.health/count (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.health/eventScopeCode
  (s/spec string? :gen #(s/gen #{"NONE" "ACCOUNT_SPECIFIC" "PUBLIC"})))

(s/def :cognitect.aws.health/availabilityZones (s/coll-of :cognitect.aws.health/availabilityZone))

(s/def
  :cognitect.aws.health/DescribeEventAggregatesRequest
  (s/keys
    :req-un
    [:cognitect.aws.health.DescribeEventAggregatesRequest/aggregateField]
    :opt-un
    [:cognitect.aws.health.DescribeEventAggregatesRequest/maxResults
     :cognitect.aws.health.DescribeEventAggregatesRequest/nextToken
     :cognitect.aws.health.DescribeEventAggregatesRequest/filter]))

(s/def
  :cognitect.aws.health/OrganizationEventFilter
  (s/keys
    :opt-un
    [:cognitect.aws.health.OrganizationEventFilter/services
     :cognitect.aws.health.OrganizationEventFilter/eventStatusCodes
     :cognitect.aws.health.OrganizationEventFilter/startTime
     :cognitect.aws.health.OrganizationEventFilter/lastUpdatedTime
     :cognitect.aws.health.OrganizationEventFilter/awsAccountIds
     :cognitect.aws.health.OrganizationEventFilter/entityValues
     :cognitect.aws.health.OrganizationEventFilter/eventTypeCodes
     :cognitect.aws.health.OrganizationEventFilter/regions
     :cognitect.aws.health.OrganizationEventFilter/endTime
     :cognitect.aws.health.OrganizationEventFilter/eventTypeCategories
     :cognitect.aws.health.OrganizationEventFilter/entityArns]))

(s/def
  :cognitect.aws.health/eventAggregateField
  (s/spec string? :gen #(s/gen #{"eventTypeCategory"})))

(s/def
  :cognitect.aws.health/DescribeAffectedEntitiesForOrganizationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeAffectedEntitiesForOrganizationResponse/failedSet
     :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationResponse/nextToken
     :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationResponse/entities]))

(s/def
  :cognitect.aws.health/EventArnsList
  (s/coll-of :cognitect.aws.health/eventArn :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.health/DescribeEventsForOrganizationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.health.DescribeEventsForOrganizationResponse/nextToken
     :cognitect.aws.health.DescribeEventsForOrganizationResponse/events]))

(s/def
  :cognitect.aws.health/DescribeEventDetailsFailedSet
  (s/coll-of :cognitect.aws.health/EventDetailsErrorItem))

(s/def
  :cognitect.aws.health/AffectedEntity
  (s/keys
    :opt-un
    [:cognitect.aws.health.AffectedEntity/entityValue
     :cognitect.aws.health.AffectedEntity/awsAccountId
     :cognitect.aws.health.AffectedEntity/entityArn
     :cognitect.aws.health.AffectedEntity/tags
     :cognitect.aws.health.AffectedEntity/eventArn
     :cognitect.aws.health.AffectedEntity/entityUrl
     :cognitect.aws.health.AffectedEntity/lastUpdatedTime
     :cognitect.aws.health.AffectedEntity/statusCode]))

(s/def :cognitect.aws.health/EventTypeList (s/coll-of :cognitect.aws.health/EventType))

(s/def
  :cognitect.aws.health/OrganizationEvent
  (s/keys
    :opt-un
    [:cognitect.aws.health.OrganizationEvent/arn
     :cognitect.aws.health.OrganizationEvent/eventScopeCode
     :cognitect.aws.health.OrganizationEvent/startTime
     :cognitect.aws.health.OrganizationEvent/lastUpdatedTime
     :cognitect.aws.health.OrganizationEvent/statusCode
     :cognitect.aws.health.OrganizationEvent/region
     :cognitect.aws.health.OrganizationEvent/eventTypeCategory
     :cognitect.aws.health.OrganizationEvent/eventTypeCode
     :cognitect.aws.health.OrganizationEvent/endTime
     :cognitect.aws.health.OrganizationEvent/service]))

(s/def
  :cognitect.aws.health/nextToken
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9=/+_.-]{4,10000}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/metadataValue
  (s/spec
    (s/and string? #(>= 32766 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 32766) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.health/timestamp inst?)

(s/def
  :cognitect.aws.health/EventTypeFilter
  (s/keys
    :opt-un
    [:cognitect.aws.health.EventTypeFilter/services
     :cognitect.aws.health.EventTypeFilter/eventTypeCodes
     :cognitect.aws.health.EventTypeFilter/eventTypeCategories]))

(s/def
  :cognitect.aws.health/dateTimeRangeList
  (s/coll-of :cognitect.aws.health/DateTimeRange :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.health/serviceList
  (s/coll-of :cognitect.aws.health/service :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.health/DescribeEventDetailsForOrganizationFailedSet
  (s/coll-of :cognitect.aws.health/OrganizationEventDetailsErrorItem))

(s/def :cognitect.aws.health/healthServiceAccessStatusForOrganization string?)

(s/def
  :cognitect.aws.health/DescribeEventDetailsRequest
  (s/keys
    :req-un
    [:cognitect.aws.health.DescribeEventDetailsRequest/eventArns]
    :opt-un
    [:cognitect.aws.health.DescribeEventDetailsRequest/locale]))

(s/def
  :cognitect.aws.health/accountId
  (s/spec #(re-matches (re-pattern "^\\S+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/EventAggregate
  (s/keys
    :opt-un
    [:cognitect.aws.health.EventAggregate/count
     :cognitect.aws.health.EventAggregate/aggregateValue]))

(s/def
  :cognitect.aws.health/EventTypeCodeList
  (s/coll-of :cognitect.aws.health/eventTypeCode :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.health/eventTypeCode
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9\\_\\-]{3,100}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.health/maxResults
  (s/spec (s/and int? #(<= 10 % 100)) :gen #(gen/choose 10 100)))

(s/def
  :cognitect.aws.health/metadataKey
  (s/spec
    (s/and string? #(>= 32766 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 32766) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.health/OrganizationEventDetailsErrorItem
  (s/keys
    :opt-un
    [:cognitect.aws.health.OrganizationEventDetailsErrorItem/awsAccountId
     :cognitect.aws.health.OrganizationEventDetailsErrorItem/errorName
     :cognitect.aws.health.OrganizationEventDetailsErrorItem/errorMessage
     :cognitect.aws.health.OrganizationEventDetailsErrorItem/eventArn]))

(s/def
  :cognitect.aws.health/DateTimeRange
  (s/keys
    :opt-un
    [:cognitect.aws.health.DateTimeRange/from :cognitect.aws.health.DateTimeRange/to]))

(s/def
  :cognitect.aws.health/tagSet
  (s/map-of :cognitect.aws.health/tagKey :cognitect.aws.health/tagValue :max-count 50))

(s/def
  :cognitect.aws.health/OrganizationEventList
  (s/coll-of :cognitect.aws.health/OrganizationEvent))

(s/def :cognitect.aws.health.EventType/service :cognitect.aws.health/service)

(s/def :cognitect.aws.health.EventType/code :cognitect.aws.health/eventTypeCode)

(s/def :cognitect.aws.health.EventType/category :cognitect.aws.health/eventTypeCategory)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesRequest/filter
  :cognitect.aws.health/EntityFilter)

(s/def :cognitect.aws.health.DescribeAffectedEntitiesRequest/locale :cognitect.aws.health/locale)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesRequest/nextToken
  :cognitect.aws.health/nextToken)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesRequest/maxResults
  :cognitect.aws.health/maxResults)

(s/def
  :cognitect.aws.health.DescribeEventDetailsResponse/successfulSet
  :cognitect.aws.health/DescribeEventDetailsSuccessfulSet)

(s/def
  :cognitect.aws.health.DescribeEventDetailsResponse/failedSet
  :cognitect.aws.health/DescribeEventDetailsFailedSet)

(s/def
  :cognitect.aws.health.DescribeEntityAggregatesResponse/entityAggregates
  :cognitect.aws.health/EntityAggregateList)

(s/def :cognitect.aws.health.EntityAggregate/eventArn :cognitect.aws.health/eventArn)

(s/def :cognitect.aws.health.EntityAggregate/count :cognitect.aws.health/count)

(s/def :cognitect.aws.health.DescribeEventsRequest/filter :cognitect.aws.health/EventFilter)

(s/def :cognitect.aws.health.DescribeEventsRequest/nextToken :cognitect.aws.health/nextToken)

(s/def :cognitect.aws.health.DescribeEventsRequest/maxResults :cognitect.aws.health/maxResults)

(s/def :cognitect.aws.health.DescribeEventsRequest/locale :cognitect.aws.health/locale)

(s/def
  :cognitect.aws.health.DescribeEventDetailsForOrganizationRequest/organizationEventDetailFilters
  :cognitect.aws.health/OrganizationEventDetailFiltersList)

(s/def
  :cognitect.aws.health.DescribeEventDetailsForOrganizationRequest/locale
  :cognitect.aws.health/locale)

(s/def :cognitect.aws.health.EventFilter/tags :cognitect.aws.health/tagFilter)

(s/def :cognitect.aws.health.EventFilter/lastUpdatedTimes :cognitect.aws.health/dateTimeRangeList)

(s/def :cognitect.aws.health.EventFilter/regions :cognitect.aws.health/regionList)

(s/def :cognitect.aws.health.EventFilter/startTimes :cognitect.aws.health/dateTimeRangeList)

(s/def :cognitect.aws.health.EventFilter/eventTypeCodes :cognitect.aws.health/eventTypeList)

(s/def :cognitect.aws.health.EventFilter/entityValues :cognitect.aws.health/entityValueList)

(s/def :cognitect.aws.health.EventFilter/entityArns :cognitect.aws.health/entityArnList)

(s/def :cognitect.aws.health.EventFilter/eventArns :cognitect.aws.health/eventArnList)

(s/def :cognitect.aws.health.EventFilter/eventStatusCodes :cognitect.aws.health/eventStatusCodeList)

(s/def :cognitect.aws.health.EventFilter/availabilityZones :cognitect.aws.health/availabilityZones)

(s/def
  :cognitect.aws.health.EventFilter/eventTypeCategories
  :cognitect.aws.health/eventTypeCategoryList)

(s/def :cognitect.aws.health.EventFilter/endTimes :cognitect.aws.health/dateTimeRangeList)

(s/def :cognitect.aws.health.EventFilter/services :cognitect.aws.health/serviceList)

(s/def
  :cognitect.aws.health.DescribeAffectedAccountsForOrganizationResponse/affectedAccounts
  :cognitect.aws.health/affectedAccountsList)

(s/def
  :cognitect.aws.health.DescribeAffectedAccountsForOrganizationResponse/eventScopeCode
  :cognitect.aws.health/eventScopeCode)

(s/def
  :cognitect.aws.health.DescribeAffectedAccountsForOrganizationResponse/nextToken
  :cognitect.aws.health/nextToken)

(s/def :cognitect.aws.health.EventDetailsErrorItem/eventArn :cognitect.aws.health/eventArn)

(s/def :cognitect.aws.health.EventDetailsErrorItem/errorName :cognitect.aws.health/string)

(s/def :cognitect.aws.health.EventDetailsErrorItem/errorMessage :cognitect.aws.health/string)

(s/def
  :cognitect.aws.health.DescribeEntityAggregatesRequest/eventArns
  :cognitect.aws.health/EventArnsList)

(s/def :cognitect.aws.health.OrganizationEventDetails/awsAccountId :cognitect.aws.health/accountId)

(s/def :cognitect.aws.health.OrganizationEventDetails/event :cognitect.aws.health/Event)

(s/def
  :cognitect.aws.health.OrganizationEventDetails/eventDescription
  :cognitect.aws.health/EventDescription)

(s/def
  :cognitect.aws.health.OrganizationEventDetails/eventMetadata
  :cognitect.aws.health/eventMetadata)

(s/def
  :cognitect.aws.health.DescribeEventDetailsForOrganizationResponse/successfulSet
  :cognitect.aws.health/DescribeEventDetailsForOrganizationSuccessfulSet)

(s/def
  :cognitect.aws.health.DescribeEventDetailsForOrganizationResponse/failedSet
  :cognitect.aws.health/DescribeEventDetailsForOrganizationFailedSet)

(s/def :cognitect.aws.health.EventDetails/event :cognitect.aws.health/Event)

(s/def :cognitect.aws.health.EventDetails/eventDescription :cognitect.aws.health/EventDescription)

(s/def :cognitect.aws.health.EventDetails/eventMetadata :cognitect.aws.health/eventMetadata)

(s/def
  :cognitect.aws.health.DescribeEventAggregatesResponse/eventAggregates
  :cognitect.aws.health/EventAggregateList)

(s/def
  :cognitect.aws.health.DescribeEventAggregatesResponse/nextToken
  :cognitect.aws.health/nextToken)

(s/def :cognitect.aws.health.DescribeEventsResponse/events :cognitect.aws.health/EventList)

(s/def :cognitect.aws.health.DescribeEventsResponse/nextToken :cognitect.aws.health/nextToken)

(s/def :cognitect.aws.health.Event/service :cognitect.aws.health/service)

(s/def :cognitect.aws.health.Event/eventTypeCategory :cognitect.aws.health/eventTypeCategory)

(s/def :cognitect.aws.health.Event/startTime :cognitect.aws.health/timestamp)

(s/def :cognitect.aws.health.Event/lastUpdatedTime :cognitect.aws.health/timestamp)

(s/def :cognitect.aws.health.Event/endTime :cognitect.aws.health/timestamp)

(s/def :cognitect.aws.health.Event/region :cognitect.aws.health/region)

(s/def :cognitect.aws.health.Event/availabilityZone :cognitect.aws.health/availabilityZone)

(s/def :cognitect.aws.health.Event/eventScopeCode :cognitect.aws.health/eventScopeCode)

(s/def :cognitect.aws.health.Event/statusCode :cognitect.aws.health/eventStatusCode)

(s/def :cognitect.aws.health.Event/eventTypeCode :cognitect.aws.health/eventTypeCode)

(s/def :cognitect.aws.health.Event/arn :cognitect.aws.health/eventArn)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesResponse/entities
  :cognitect.aws.health/EntityList)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesResponse/nextToken
  :cognitect.aws.health/nextToken)

(s/def
  :cognitect.aws.health.DescribeEventsForOrganizationRequest/filter
  :cognitect.aws.health/OrganizationEventFilter)

(s/def
  :cognitect.aws.health.DescribeEventsForOrganizationRequest/nextToken
  :cognitect.aws.health/nextToken)

(s/def
  :cognitect.aws.health.DescribeEventsForOrganizationRequest/maxResults
  :cognitect.aws.health/maxResults)

(s/def
  :cognitect.aws.health.DescribeEventsForOrganizationRequest/locale
  :cognitect.aws.health/locale)

(s/def :cognitect.aws.health.DescribeEventTypesRequest/filter :cognitect.aws.health/EventTypeFilter)

(s/def :cognitect.aws.health.DescribeEventTypesRequest/locale :cognitect.aws.health/locale)

(s/def :cognitect.aws.health.DescribeEventTypesRequest/nextToken :cognitect.aws.health/nextToken)

(s/def :cognitect.aws.health.DescribeEventTypesRequest/maxResults :cognitect.aws.health/maxResults)

(s/def :cognitect.aws.health.EntityFilter/eventArns :cognitect.aws.health/eventArnList)

(s/def :cognitect.aws.health.EntityFilter/entityArns :cognitect.aws.health/entityArnList)

(s/def :cognitect.aws.health.EntityFilter/entityValues :cognitect.aws.health/entityValueList)

(s/def :cognitect.aws.health.EntityFilter/lastUpdatedTimes :cognitect.aws.health/dateTimeRangeList)

(s/def :cognitect.aws.health.EntityFilter/tags :cognitect.aws.health/tagFilter)

(s/def :cognitect.aws.health.EntityFilter/statusCodes :cognitect.aws.health/entityStatusCodeList)

(s/def :cognitect.aws.health.EventAccountFilter/eventArn :cognitect.aws.health/eventArn)

(s/def :cognitect.aws.health.EventAccountFilter/awsAccountId :cognitect.aws.health/accountId)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationRequest/organizationEntityFilters
  :cognitect.aws.health/OrganizationEntityFiltersList)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationRequest/locale
  :cognitect.aws.health/locale)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationRequest/nextToken
  :cognitect.aws.health/nextToken)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationRequest/maxResults
  :cognitect.aws.health/maxResults)

(s/def
  :cognitect.aws.health.DescribeAffectedAccountsForOrganizationRequest/eventArn
  :cognitect.aws.health/eventArn)

(s/def
  :cognitect.aws.health.DescribeAffectedAccountsForOrganizationRequest/nextToken
  :cognitect.aws.health/nextToken)

(s/def
  :cognitect.aws.health.DescribeAffectedAccountsForOrganizationRequest/maxResults
  :cognitect.aws.health/maxResults)

(s/def
  :cognitect.aws.health.EventDescription/latestDescription
  :cognitect.aws.health/eventDescription)

(s/def
  :cognitect.aws.health.OrganizationAffectedEntitiesErrorItem/awsAccountId
  :cognitect.aws.health/accountId)

(s/def
  :cognitect.aws.health.OrganizationAffectedEntitiesErrorItem/eventArn
  :cognitect.aws.health/eventArn)

(s/def
  :cognitect.aws.health.OrganizationAffectedEntitiesErrorItem/errorName
  :cognitect.aws.health/string)

(s/def
  :cognitect.aws.health.OrganizationAffectedEntitiesErrorItem/errorMessage
  :cognitect.aws.health/string)

(s/def
  :cognitect.aws.health.DescribeHealthServiceStatusForOrganizationResponse/healthServiceAccessStatusForOrganization
  :cognitect.aws.health/healthServiceAccessStatusForOrganization)

(s/def
  :cognitect.aws.health.DescribeEventTypesResponse/eventTypes
  :cognitect.aws.health/EventTypeList)

(s/def :cognitect.aws.health.DescribeEventTypesResponse/nextToken :cognitect.aws.health/nextToken)

(s/def
  :cognitect.aws.health.DescribeEventAggregatesRequest/filter
  :cognitect.aws.health/EventFilter)

(s/def
  :cognitect.aws.health.DescribeEventAggregatesRequest/aggregateField
  :cognitect.aws.health/eventAggregateField)

(s/def
  :cognitect.aws.health.DescribeEventAggregatesRequest/maxResults
  :cognitect.aws.health/maxResults)

(s/def
  :cognitect.aws.health.DescribeEventAggregatesRequest/nextToken
  :cognitect.aws.health/nextToken)

(s/def :cognitect.aws.health.OrganizationEventFilter/startTime :cognitect.aws.health/DateTimeRange)

(s/def
  :cognitect.aws.health.OrganizationEventFilter/lastUpdatedTime
  :cognitect.aws.health/DateTimeRange)

(s/def :cognitect.aws.health.OrganizationEventFilter/endTime :cognitect.aws.health/DateTimeRange)

(s/def :cognitect.aws.health.OrganizationEventFilter/regions :cognitect.aws.health/regionList)

(s/def
  :cognitect.aws.health.OrganizationEventFilter/eventTypeCodes
  :cognitect.aws.health/eventTypeList)

(s/def
  :cognitect.aws.health.OrganizationEventFilter/entityValues
  :cognitect.aws.health/entityValueList)

(s/def :cognitect.aws.health.OrganizationEventFilter/entityArns :cognitect.aws.health/entityArnList)

(s/def
  :cognitect.aws.health.OrganizationEventFilter/eventStatusCodes
  :cognitect.aws.health/eventStatusCodeList)

(s/def
  :cognitect.aws.health.OrganizationEventFilter/eventTypeCategories
  :cognitect.aws.health/eventTypeCategoryList)

(s/def
  :cognitect.aws.health.OrganizationEventFilter/awsAccountIds
  :cognitect.aws.health/awsAccountIdsList)

(s/def :cognitect.aws.health.OrganizationEventFilter/services :cognitect.aws.health/serviceList)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationResponse/entities
  :cognitect.aws.health/EntityList)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationResponse/failedSet
  :cognitect.aws.health/DescribeAffectedEntitiesForOrganizationFailedSet)

(s/def
  :cognitect.aws.health.DescribeAffectedEntitiesForOrganizationResponse/nextToken
  :cognitect.aws.health/nextToken)

(s/def
  :cognitect.aws.health.DescribeEventsForOrganizationResponse/events
  :cognitect.aws.health/OrganizationEventList)

(s/def
  :cognitect.aws.health.DescribeEventsForOrganizationResponse/nextToken
  :cognitect.aws.health/nextToken)

(s/def :cognitect.aws.health.AffectedEntity/entityArn :cognitect.aws.health/entityArn)

(s/def :cognitect.aws.health.AffectedEntity/eventArn :cognitect.aws.health/eventArn)

(s/def :cognitect.aws.health.AffectedEntity/entityValue :cognitect.aws.health/entityValue)

(s/def :cognitect.aws.health.AffectedEntity/entityUrl :cognitect.aws.health/entityUrl)

(s/def :cognitect.aws.health.AffectedEntity/awsAccountId :cognitect.aws.health/accountId)

(s/def :cognitect.aws.health.AffectedEntity/lastUpdatedTime :cognitect.aws.health/timestamp)

(s/def :cognitect.aws.health.AffectedEntity/statusCode :cognitect.aws.health/entityStatusCode)

(s/def :cognitect.aws.health.AffectedEntity/tags :cognitect.aws.health/tagSet)

(s/def :cognitect.aws.health.OrganizationEvent/service :cognitect.aws.health/service)

(s/def
  :cognitect.aws.health.OrganizationEvent/eventTypeCategory
  :cognitect.aws.health/eventTypeCategory)

(s/def :cognitect.aws.health.OrganizationEvent/startTime :cognitect.aws.health/timestamp)

(s/def :cognitect.aws.health.OrganizationEvent/lastUpdatedTime :cognitect.aws.health/timestamp)

(s/def :cognitect.aws.health.OrganizationEvent/endTime :cognitect.aws.health/timestamp)

(s/def :cognitect.aws.health.OrganizationEvent/region :cognitect.aws.health/region)

(s/def :cognitect.aws.health.OrganizationEvent/eventScopeCode :cognitect.aws.health/eventScopeCode)

(s/def :cognitect.aws.health.OrganizationEvent/statusCode :cognitect.aws.health/eventStatusCode)

(s/def :cognitect.aws.health.OrganizationEvent/eventTypeCode :cognitect.aws.health/eventTypeCode)

(s/def :cognitect.aws.health.OrganizationEvent/arn :cognitect.aws.health/eventArn)

(s/def :cognitect.aws.health.EventTypeFilter/eventTypeCodes :cognitect.aws.health/EventTypeCodeList)

(s/def :cognitect.aws.health.EventTypeFilter/services :cognitect.aws.health/serviceList)

(s/def
  :cognitect.aws.health.EventTypeFilter/eventTypeCategories
  :cognitect.aws.health/EventTypeCategoryList)

(s/def
  :cognitect.aws.health.DescribeEventDetailsRequest/eventArns
  :cognitect.aws.health/eventArnList)

(s/def :cognitect.aws.health.DescribeEventDetailsRequest/locale :cognitect.aws.health/locale)

(s/def :cognitect.aws.health.EventAggregate/aggregateValue :cognitect.aws.health/aggregateValue)

(s/def :cognitect.aws.health.EventAggregate/count :cognitect.aws.health/count)

(s/def
  :cognitect.aws.health.OrganizationEventDetailsErrorItem/awsAccountId
  :cognitect.aws.health/accountId)

(s/def
  :cognitect.aws.health.OrganizationEventDetailsErrorItem/eventArn
  :cognitect.aws.health/eventArn)

(s/def
  :cognitect.aws.health.OrganizationEventDetailsErrorItem/errorName
  :cognitect.aws.health/string)

(s/def
  :cognitect.aws.health.OrganizationEventDetailsErrorItem/errorMessage
  :cognitect.aws.health/string)

(s/def :cognitect.aws.health.DateTimeRange/from :cognitect.aws.health/timestamp)

(s/def :cognitect.aws.health.DateTimeRange/to :cognitect.aws.health/timestamp)

