;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.healthlake.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.healthlake/JobName
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/DatastoreArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws((-us-gov)|(-iso)|(-iso-b)|(-cn))?:healthlake:[a-zA-Z0-9-]+:[0-9]{12}:datastore/.+?")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.healthlake/ListFHIRDatastoresResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.ListFHIRDatastoresResponse/DatastorePropertiesList]
    :opt-un
    [:cognitect.aws.healthlake.ListFHIRDatastoresResponse/NextToken]))

(s/def
  :cognitect.aws.healthlake/ListFHIRDatastoresRequest
  (s/keys
    :opt-un
    [:cognitect.aws.healthlake.ListFHIRDatastoresRequest/Filter
     :cognitect.aws.healthlake.ListFHIRDatastoresRequest/NextToken
     :cognitect.aws.healthlake.ListFHIRDatastoresRequest/MaxResults]))

(s/def
  :cognitect.aws.healthlake/BoundedLengthString
  (s/spec #(re-matches (re-pattern "[\\P{M}\\p{M}]{1,5000}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/ImportJobProperties
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.ImportJobProperties/JobId
     :cognitect.aws.healthlake.ImportJobProperties/JobStatus
     :cognitect.aws.healthlake.ImportJobProperties/SubmitTime
     :cognitect.aws.healthlake.ImportJobProperties/DatastoreId
     :cognitect.aws.healthlake.ImportJobProperties/InputDataConfig]
    :opt-un
    [:cognitect.aws.healthlake.ImportJobProperties/EndTime
     :cognitect.aws.healthlake.ImportJobProperties/JobName
     :cognitect.aws.healthlake.ImportJobProperties/Message
     :cognitect.aws.healthlake.ImportJobProperties/DataAccessRoleArn]))

(s/def
  :cognitect.aws.healthlake/DeleteFHIRDatastoreResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreId
     :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreArn
     :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreStatus
     :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreEndpoint]))

(s/def
  :cognitect.aws.healthlake/Message
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/JobId
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/S3Uri
  (s/spec
    #(re-matches (re-pattern "s3://[a-z0-9][\\.\\-a-z0-9]{1,61}[a-z0-9](/.*)?") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.healthlake/DescribeFHIRDatastoreResponse
  (s/keys :req-un [:cognitect.aws.healthlake.DescribeFHIRDatastoreResponse/DatastoreProperties]))

(s/def
  :cognitect.aws.healthlake/DeleteFHIRDatastoreRequest
  (s/keys :opt-un [:cognitect.aws.healthlake.DeleteFHIRDatastoreRequest/DatastoreId]))

(s/def
  :cognitect.aws.healthlake/JobStatus
  (s/spec string? :gen #(s/gen #{"COMPLETED" "IN_PROGRESS" "SUBMITTED" "FAILED"})))

(s/def
  :cognitect.aws.healthlake/DatastoreFilter
  (s/keys
    :opt-un
    [:cognitect.aws.healthlake.DatastoreFilter/DatastoreName
     :cognitect.aws.healthlake.DatastoreFilter/CreatedAfter
     :cognitect.aws.healthlake.DatastoreFilter/CreatedBefore
     :cognitect.aws.healthlake.DatastoreFilter/DatastoreStatus]))

(s/def
  :cognitect.aws.healthlake/StartFHIRImportJobResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.StartFHIRImportJobResponse/JobId
     :cognitect.aws.healthlake.StartFHIRImportJobResponse/JobStatus]
    :opt-un
    [:cognitect.aws.healthlake.StartFHIRImportJobResponse/DatastoreId]))

(s/def
  :cognitect.aws.healthlake/DatastoreProperties
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.DatastoreProperties/DatastoreId
     :cognitect.aws.healthlake.DatastoreProperties/DatastoreArn
     :cognitect.aws.healthlake.DatastoreProperties/DatastoreStatus
     :cognitect.aws.healthlake.DatastoreProperties/DatastoreTypeVersion
     :cognitect.aws.healthlake.DatastoreProperties/DatastoreEndpoint]
    :opt-un
    [:cognitect.aws.healthlake.DatastoreProperties/DatastoreName
     :cognitect.aws.healthlake.DatastoreProperties/CreatedAt
     :cognitect.aws.healthlake.DatastoreProperties/PreloadDataConfig]))

(s/def
  :cognitect.aws.healthlake/DatastoreId
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/MaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 500)) :gen #(gen/choose 1 500)))

(s/def
  :cognitect.aws.healthlake/IamRoleArn
  (s/spec
    #(re-matches (re-pattern "arn:aws(-[^:]+)?:iam::[0-9]{12}:role/.+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.healthlake/DatastoreStatus
  (s/spec string? :gen #(s/gen #{"DELETING" "CREATING" "ACTIVE" "DELETED"})))

(s/def
  :cognitect.aws.healthlake/NextToken
  (s/spec #(re-matches (re-pattern "\\p{ASCII}{0,8192}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/PreloadDataConfig
  (s/keys :req-un [:cognitect.aws.healthlake.PreloadDataConfig/PreloadDataType]))

(s/def :cognitect.aws.healthlake/PreloadDataType (s/spec string? :gen #(s/gen #{"SYNTHEA"})))

(s/def
  :cognitect.aws.healthlake/ClientTokenString
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/DescribeFHIRImportJobResponse
  (s/keys :req-un [:cognitect.aws.healthlake.DescribeFHIRImportJobResponse/ImportJobProperties]))

(s/def
  :cognitect.aws.healthlake/CreateFHIRDatastoreResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreId
     :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreArn
     :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreStatus
     :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreEndpoint]))

(s/def
  :cognitect.aws.healthlake/DatastorePropertiesList
  (s/coll-of :cognitect.aws.healthlake/DatastoreProperties))

(s/def
  :cognitect.aws.healthlake/CreateFHIRDatastoreRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.CreateFHIRDatastoreRequest/DatastoreTypeVersion]
    :opt-un
    [:cognitect.aws.healthlake.CreateFHIRDatastoreRequest/DatastoreName
     :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/PreloadDataConfig
     :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/ClientToken]))

(s/def
  :cognitect.aws.healthlake/DescribeFHIRImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.DescribeFHIRImportJobRequest/DatastoreId
     :cognitect.aws.healthlake.DescribeFHIRImportJobRequest/JobId]))

(s/def
  :cognitect.aws.healthlake/StartFHIRImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.StartFHIRImportJobRequest/InputDataConfig
     :cognitect.aws.healthlake.StartFHIRImportJobRequest/DatastoreId
     :cognitect.aws.healthlake.StartFHIRImportJobRequest/DataAccessRoleArn
     :cognitect.aws.healthlake.StartFHIRImportJobRequest/ClientToken]
    :opt-un
    [:cognitect.aws.healthlake.StartFHIRImportJobRequest/JobName]))

(s/def :cognitect.aws.healthlake/FHIRVersion (s/spec string? :gen #(s/gen #{"R4"})))

(s/def :cognitect.aws.healthlake/Timestamp inst?)

(s/def
  :cognitect.aws.healthlake/InputDataConfig
  (s/keys :opt-un [:cognitect.aws.healthlake.InputDataConfig/S3Uri]))

(s/def
  :cognitect.aws.healthlake/DescribeFHIRDatastoreRequest
  (s/keys :opt-un [:cognitect.aws.healthlake.DescribeFHIRDatastoreRequest/DatastoreId]))

(s/def
  :cognitect.aws.healthlake/String
  (s/spec #(re-matches (re-pattern "[\\P{M}\\p{M}]{0,10000}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/DatastoreName
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake.ListFHIRDatastoresResponse/DatastorePropertiesList
  :cognitect.aws.healthlake/DatastorePropertiesList)

(s/def
  :cognitect.aws.healthlake.ListFHIRDatastoresResponse/NextToken
  :cognitect.aws.healthlake/NextToken)

(s/def
  :cognitect.aws.healthlake.ListFHIRDatastoresRequest/Filter
  :cognitect.aws.healthlake/DatastoreFilter)

(s/def
  :cognitect.aws.healthlake.ListFHIRDatastoresRequest/NextToken
  :cognitect.aws.healthlake/NextToken)

(s/def
  :cognitect.aws.healthlake.ListFHIRDatastoresRequest/MaxResults
  :cognitect.aws.healthlake/MaxResultsInteger)

(s/def :cognitect.aws.healthlake.ImportJobProperties/JobName :cognitect.aws.healthlake/JobName)

(s/def :cognitect.aws.healthlake.ImportJobProperties/EndTime :cognitect.aws.healthlake/Timestamp)

(s/def :cognitect.aws.healthlake.ImportJobProperties/Message :cognitect.aws.healthlake/Message)

(s/def :cognitect.aws.healthlake.ImportJobProperties/JobId :cognitect.aws.healthlake/JobId)

(s/def :cognitect.aws.healthlake.ImportJobProperties/JobStatus :cognitect.aws.healthlake/JobStatus)

(s/def
  :cognitect.aws.healthlake.ImportJobProperties/DataAccessRoleArn
  :cognitect.aws.healthlake/IamRoleArn)

(s/def
  :cognitect.aws.healthlake.ImportJobProperties/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def :cognitect.aws.healthlake.ImportJobProperties/SubmitTime :cognitect.aws.healthlake/Timestamp)

(s/def
  :cognitect.aws.healthlake.ImportJobProperties/InputDataConfig
  :cognitect.aws.healthlake/InputDataConfig)

(s/def
  :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreArn
  :cognitect.aws.healthlake/DatastoreArn)

(s/def
  :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreStatus
  :cognitect.aws.healthlake/DatastoreStatus)

(s/def
  :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreEndpoint
  :cognitect.aws.healthlake/BoundedLengthString)

(s/def
  :cognitect.aws.healthlake.DescribeFHIRDatastoreResponse/DatastoreProperties
  :cognitect.aws.healthlake/DatastoreProperties)

(s/def
  :cognitect.aws.healthlake.DeleteFHIRDatastoreRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.DatastoreFilter/DatastoreName
  :cognitect.aws.healthlake/DatastoreName)

(s/def
  :cognitect.aws.healthlake.DatastoreFilter/DatastoreStatus
  :cognitect.aws.healthlake/DatastoreStatus)

(s/def :cognitect.aws.healthlake.DatastoreFilter/CreatedBefore :cognitect.aws.healthlake/Timestamp)

(s/def :cognitect.aws.healthlake.DatastoreFilter/CreatedAfter :cognitect.aws.healthlake/Timestamp)

(s/def :cognitect.aws.healthlake.StartFHIRImportJobResponse/JobId :cognitect.aws.healthlake/JobId)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobResponse/JobStatus
  :cognitect.aws.healthlake/JobStatus)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobResponse/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreArn
  :cognitect.aws.healthlake/DatastoreArn)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreName
  :cognitect.aws.healthlake/DatastoreName)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreStatus
  :cognitect.aws.healthlake/DatastoreStatus)

(s/def :cognitect.aws.healthlake.DatastoreProperties/CreatedAt :cognitect.aws.healthlake/Timestamp)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreTypeVersion
  :cognitect.aws.healthlake/FHIRVersion)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreEndpoint
  :cognitect.aws.healthlake/String)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/PreloadDataConfig
  :cognitect.aws.healthlake/PreloadDataConfig)

(s/def
  :cognitect.aws.healthlake.PreloadDataConfig/PreloadDataType
  :cognitect.aws.healthlake/PreloadDataType)

(s/def
  :cognitect.aws.healthlake.DescribeFHIRImportJobResponse/ImportJobProperties
  :cognitect.aws.healthlake/ImportJobProperties)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreArn
  :cognitect.aws.healthlake/DatastoreArn)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreStatus
  :cognitect.aws.healthlake/DatastoreStatus)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreEndpoint
  :cognitect.aws.healthlake/BoundedLengthString)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/DatastoreName
  :cognitect.aws.healthlake/DatastoreName)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/DatastoreTypeVersion
  :cognitect.aws.healthlake/FHIRVersion)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/PreloadDataConfig
  :cognitect.aws.healthlake/PreloadDataConfig)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/ClientToken
  :cognitect.aws.healthlake/ClientTokenString)

(s/def
  :cognitect.aws.healthlake.DescribeFHIRImportJobRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def :cognitect.aws.healthlake.DescribeFHIRImportJobRequest/JobId :cognitect.aws.healthlake/JobId)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/JobName
  :cognitect.aws.healthlake/JobName)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/InputDataConfig
  :cognitect.aws.healthlake/InputDataConfig)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/DataAccessRoleArn
  :cognitect.aws.healthlake/IamRoleArn)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/ClientToken
  :cognitect.aws.healthlake/ClientTokenString)

(s/def :cognitect.aws.healthlake.InputDataConfig/S3Uri :cognitect.aws.healthlake/S3Uri)

(s/def
  :cognitect.aws.healthlake.DescribeFHIRDatastoreRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

