;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.healthlake.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.healthlake/JobName
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.TagResourceRequest/ResourceARN
     :cognitect.aws.healthlake.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.healthlake/DatastoreArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws((-us-gov)|(-iso)|(-iso-b)|(-cn))?:healthlake:[a-zA-Z0-9-]+:[0-9]{12}:datastore/.+?")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.healthlake/Tag
  (s/keys :req-un [:cognitect.aws.healthlake.Tag/Key :cognitect.aws.healthlake.Tag/Value]))

(s/def
  :cognitect.aws.healthlake/ListFHIRExportJobsResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.ListFHIRExportJobsResponse/ExportJobPropertiesList]
    :opt-un
    [:cognitect.aws.healthlake.ListFHIRExportJobsResponse/NextToken]))

(s/def
  :cognitect.aws.healthlake/ListFHIRDatastoresResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.ListFHIRDatastoresResponse/DatastorePropertiesList]
    :opt-un
    [:cognitect.aws.healthlake.ListFHIRDatastoresResponse/NextToken]))

(s/def :cognitect.aws.healthlake/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.healthlake/ListFHIRDatastoresRequest
  (s/keys
    :opt-un
    [:cognitect.aws.healthlake.ListFHIRDatastoresRequest/Filter
     :cognitect.aws.healthlake.ListFHIRDatastoresRequest/NextToken
     :cognitect.aws.healthlake.ListFHIRDatastoresRequest/MaxResults]))

(s/def
  :cognitect.aws.healthlake/BoundedLengthString
  (s/spec #(re-matches (re-pattern "[\\P{M}\\p{M}]{1,5000}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/ImportJobProperties
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.ImportJobProperties/JobId
     :cognitect.aws.healthlake.ImportJobProperties/JobStatus
     :cognitect.aws.healthlake.ImportJobProperties/SubmitTime
     :cognitect.aws.healthlake.ImportJobProperties/DatastoreId
     :cognitect.aws.healthlake.ImportJobProperties/InputDataConfig]
    :opt-un
    [:cognitect.aws.healthlake.ImportJobProperties/EndTime
     :cognitect.aws.healthlake.ImportJobProperties/JobName
     :cognitect.aws.healthlake.ImportJobProperties/JobOutputDataConfig
     :cognitect.aws.healthlake.ImportJobProperties/Message
     :cognitect.aws.healthlake.ImportJobProperties/DataAccessRoleArn]))

(s/def
  :cognitect.aws.healthlake/DeleteFHIRDatastoreResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreId
     :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreArn
     :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreStatus
     :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreEndpoint]))

(s/def
  :cognitect.aws.healthlake/Message
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/JobId
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/S3Uri
  (s/spec
    #(re-matches (re-pattern "s3://[a-z0-9][\\.\\-a-z0-9]{1,61}[a-z0-9](/.*)?") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.healthlake/TagList
  (s/coll-of :cognitect.aws.healthlake/Tag :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.healthlake/DescribeFHIRDatastoreResponse
  (s/keys :req-un [:cognitect.aws.healthlake.DescribeFHIRDatastoreResponse/DatastoreProperties]))

(s/def
  :cognitect.aws.healthlake/StartFHIRExportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.StartFHIRExportJobRequest/OutputDataConfig
     :cognitect.aws.healthlake.StartFHIRExportJobRequest/DatastoreId
     :cognitect.aws.healthlake.StartFHIRExportJobRequest/DataAccessRoleArn
     :cognitect.aws.healthlake.StartFHIRExportJobRequest/ClientToken]
    :opt-un
    [:cognitect.aws.healthlake.StartFHIRExportJobRequest/JobName]))

(s/def
  :cognitect.aws.healthlake/DescribeFHIRExportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.DescribeFHIRExportJobRequest/DatastoreId
     :cognitect.aws.healthlake.DescribeFHIRExportJobRequest/JobId]))

(s/def
  :cognitect.aws.healthlake/DeleteFHIRDatastoreRequest
  (s/keys :req-un [:cognitect.aws.healthlake.DeleteFHIRDatastoreRequest/DatastoreId]))

(s/def
  :cognitect.aws.healthlake/JobStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"COMPLETED"
        "IN_PROGRESS"
        "CANCEL_FAILED"
        "COMPLETED_WITH_ERRORS"
        "CANCEL_COMPLETED"
        "SUBMITTED"
        "CANCEL_SUBMITTED"
        "FAILED"
        "CANCEL_IN_PROGRESS"})))

(s/def
  :cognitect.aws.healthlake/AuthorizationStrategy
  (s/spec string? :gen #(s/gen #{"AWS_AUTH" "SMART_ON_FHIR_V1"})))

(s/def
  :cognitect.aws.healthlake/DatastoreFilter
  (s/keys
    :opt-un
    [:cognitect.aws.healthlake.DatastoreFilter/DatastoreName
     :cognitect.aws.healthlake.DatastoreFilter/CreatedAfter
     :cognitect.aws.healthlake.DatastoreFilter/CreatedBefore
     :cognitect.aws.healthlake.DatastoreFilter/DatastoreStatus]))

(s/def
  :cognitect.aws.healthlake/StartFHIRImportJobResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.StartFHIRImportJobResponse/JobId
     :cognitect.aws.healthlake.StartFHIRImportJobResponse/JobStatus]
    :opt-un
    [:cognitect.aws.healthlake.StartFHIRImportJobResponse/DatastoreId]))

(s/def
  :cognitect.aws.healthlake/DescribeFHIRExportJobResponse
  (s/keys :req-un [:cognitect.aws.healthlake.DescribeFHIRExportJobResponse/ExportJobProperties]))

(s/def
  :cognitect.aws.healthlake/CmkType
  (s/spec string? :gen #(s/gen #{"CUSTOMER_MANAGED_KMS_KEY" "AWS_OWNED_KMS_KEY"})))

(s/def
  :cognitect.aws.healthlake/LambdaArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:aws:lambda:[a-z]{2}-[a-z]+-\\d{1}:\\d{12}:function:[a-zA-Z0-9\\-_\\.]+(:(\\$LATEST|[a-zA-Z0-9\\-_]+))?")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.healthlake/Boolean boolean?)

(s/def
  :cognitect.aws.healthlake/DatastoreProperties
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.DatastoreProperties/DatastoreId
     :cognitect.aws.healthlake.DatastoreProperties/DatastoreArn
     :cognitect.aws.healthlake.DatastoreProperties/DatastoreStatus
     :cognitect.aws.healthlake.DatastoreProperties/DatastoreTypeVersion
     :cognitect.aws.healthlake.DatastoreProperties/DatastoreEndpoint]
    :opt-un
    [:cognitect.aws.healthlake.DatastoreProperties/DatastoreName
     :cognitect.aws.healthlake.DatastoreProperties/SseConfiguration
     :cognitect.aws.healthlake.DatastoreProperties/CreatedAt
     :cognitect.aws.healthlake.DatastoreProperties/PreloadDataConfig
     :cognitect.aws.healthlake.DatastoreProperties/IdentityProviderConfiguration]))

(s/def
  :cognitect.aws.healthlake/AmazonResourceName
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws((-us-gov)|(-iso)|(-iso-b)|(-cn))?:healthlake:[a-z0-9-]+:\\d{12}:datastore\\/fhir\\/.{32}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.healthlake/KmsEncryptionConfig
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.KmsEncryptionConfig/CmkType]
    :opt-un
    [:cognitect.aws.healthlake.KmsEncryptionConfig/KmsKeyId]))

(s/def
  :cognitect.aws.healthlake/DatastoreId
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/MaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 500)) :gen #(gen/choose 1 500)))

(s/def
  :cognitect.aws.healthlake/IamRoleArn
  (s/spec
    #(re-matches (re-pattern "arn:aws(-[^:]+)?:iam::[0-9]{12}:role/.+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.healthlake/DatastoreStatus
  (s/spec string? :gen #(s/gen #{"DELETING" "CREATING" "ACTIVE" "DELETED"})))

(s/def
  :cognitect.aws.healthlake/NextToken
  (s/spec #(re-matches (re-pattern "\\p{ASCII}{0,8192}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/PreloadDataConfig
  (s/keys :req-un [:cognitect.aws.healthlake.PreloadDataConfig/PreloadDataType]))

(s/def
  :cognitect.aws.healthlake/OutputDataConfig
  (s/keys :opt-un [:cognitect.aws.healthlake.OutputDataConfig/S3Configuration]))

(s/def :cognitect.aws.healthlake/PreloadDataType (s/spec string? :gen #(s/gen #{"SYNTHEA"})))

(s/def
  :cognitect.aws.healthlake/TagValue
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def :cognitect.aws.healthlake/ConfigurationMetadata string?)

(s/def
  :cognitect.aws.healthlake/ClientTokenString
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.healthlake.ListTagsForResourceRequest/ResourceARN]))

(s/def
  :cognitect.aws.healthlake/DescribeFHIRImportJobResponse
  (s/keys :req-un [:cognitect.aws.healthlake.DescribeFHIRImportJobResponse/ImportJobProperties]))

(s/def
  :cognitect.aws.healthlake/ListFHIRImportJobsResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.ListFHIRImportJobsResponse/ImportJobPropertiesList]
    :opt-un
    [:cognitect.aws.healthlake.ListFHIRImportJobsResponse/NextToken]))

(s/def
  :cognitect.aws.healthlake/CreateFHIRDatastoreResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreId
     :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreArn
     :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreStatus
     :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreEndpoint]))

(s/def
  :cognitect.aws.healthlake/DatastorePropertiesList
  (s/coll-of :cognitect.aws.healthlake/DatastoreProperties))

(s/def :cognitect.aws.healthlake/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.healthlake/ListFHIRImportJobsRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.ListFHIRImportJobsRequest/DatastoreId]
    :opt-un
    [:cognitect.aws.healthlake.ListFHIRImportJobsRequest/JobStatus
     :cognitect.aws.healthlake.ListFHIRImportJobsRequest/SubmittedBefore
     :cognitect.aws.healthlake.ListFHIRImportJobsRequest/JobName
     :cognitect.aws.healthlake.ListFHIRImportJobsRequest/NextToken
     :cognitect.aws.healthlake.ListFHIRImportJobsRequest/MaxResults
     :cognitect.aws.healthlake.ListFHIRImportJobsRequest/SubmittedAfter]))

(s/def
  :cognitect.aws.healthlake/EncryptionKeyID
  (s/spec
    #(re-matches
      (re-pattern
        "(arn:aws((-us-gov)|(-iso)|(-iso-b)|(-cn))?:kms:)?([a-z]{2}-[a-z]+(-[a-z]+)?-\\d:)?(\\d{12}:)?(((key/)?[a-zA-Z0-9-_]+)|(alias/[a-zA-Z0-9:/_-]+))")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.healthlake/S3Configuration
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.S3Configuration/S3Uri
     :cognitect.aws.healthlake.S3Configuration/KmsKeyId]))

(s/def
  :cognitect.aws.healthlake/CreateFHIRDatastoreRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.CreateFHIRDatastoreRequest/DatastoreTypeVersion]
    :opt-un
    [:cognitect.aws.healthlake.CreateFHIRDatastoreRequest/DatastoreName
     :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/Tags
     :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/SseConfiguration
     :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/PreloadDataConfig
     :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/IdentityProviderConfiguration
     :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/ClientToken]))

(s/def
  :cognitect.aws.healthlake/SseConfiguration
  (s/keys :req-un [:cognitect.aws.healthlake.SseConfiguration/KmsEncryptionConfig]))

(s/def
  :cognitect.aws.healthlake/DescribeFHIRImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.DescribeFHIRImportJobRequest/DatastoreId
     :cognitect.aws.healthlake.DescribeFHIRImportJobRequest/JobId]))

(s/def
  :cognitect.aws.healthlake/StartFHIRImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.StartFHIRImportJobRequest/InputDataConfig
     :cognitect.aws.healthlake.StartFHIRImportJobRequest/JobOutputDataConfig
     :cognitect.aws.healthlake.StartFHIRImportJobRequest/DatastoreId
     :cognitect.aws.healthlake.StartFHIRImportJobRequest/DataAccessRoleArn
     :cognitect.aws.healthlake.StartFHIRImportJobRequest/ClientToken]
    :opt-un
    [:cognitect.aws.healthlake.StartFHIRImportJobRequest/JobName]))

(s/def
  :cognitect.aws.healthlake/ExportJobProperties
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.ExportJobProperties/JobId
     :cognitect.aws.healthlake.ExportJobProperties/JobStatus
     :cognitect.aws.healthlake.ExportJobProperties/SubmitTime
     :cognitect.aws.healthlake.ExportJobProperties/DatastoreId
     :cognitect.aws.healthlake.ExportJobProperties/OutputDataConfig]
    :opt-un
    [:cognitect.aws.healthlake.ExportJobProperties/EndTime
     :cognitect.aws.healthlake.ExportJobProperties/JobName
     :cognitect.aws.healthlake.ExportJobProperties/Message
     :cognitect.aws.healthlake.ExportJobProperties/DataAccessRoleArn]))

(s/def :cognitect.aws.healthlake/FHIRVersion (s/spec string? :gen #(s/gen #{"R4"})))

(s/def
  :cognitect.aws.healthlake/IdentityProviderConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.IdentityProviderConfiguration/AuthorizationStrategy]
    :opt-un
    [:cognitect.aws.healthlake.IdentityProviderConfiguration/FineGrainedAuthorizationEnabled
     :cognitect.aws.healthlake.IdentityProviderConfiguration/IdpLambdaArn
     :cognitect.aws.healthlake.IdentityProviderConfiguration/Metadata]))

(s/def
  :cognitect.aws.healthlake/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.UntagResourceRequest/ResourceARN
     :cognitect.aws.healthlake.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.healthlake/TagKey
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/ExportJobPropertiesList
  (s/coll-of :cognitect.aws.healthlake/ExportJobProperties))

(s/def
  :cognitect.aws.healthlake/StartFHIRExportJobResponse
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.StartFHIRExportJobResponse/JobId
     :cognitect.aws.healthlake.StartFHIRExportJobResponse/JobStatus]
    :opt-un
    [:cognitect.aws.healthlake.StartFHIRExportJobResponse/DatastoreId]))

(s/def :cognitect.aws.healthlake/Timestamp inst?)

(s/def
  :cognitect.aws.healthlake/ImportJobPropertiesList
  (s/coll-of :cognitect.aws.healthlake/ImportJobProperties))

(s/def
  :cognitect.aws.healthlake/InputDataConfig
  (s/keys :opt-un [:cognitect.aws.healthlake.InputDataConfig/S3Uri]))

(s/def
  :cognitect.aws.healthlake/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.healthlake.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.healthlake/DescribeFHIRDatastoreRequest
  (s/keys :req-un [:cognitect.aws.healthlake.DescribeFHIRDatastoreRequest/DatastoreId]))

(s/def
  :cognitect.aws.healthlake/String
  (s/spec #(re-matches (re-pattern "[\\P{M}\\p{M}]{0,10000}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/TagKeyList
  (s/coll-of :cognitect.aws.healthlake/TagKey :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.healthlake/DatastoreName
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.healthlake/ListFHIRExportJobsRequest
  (s/keys
    :req-un
    [:cognitect.aws.healthlake.ListFHIRExportJobsRequest/DatastoreId]
    :opt-un
    [:cognitect.aws.healthlake.ListFHIRExportJobsRequest/JobStatus
     :cognitect.aws.healthlake.ListFHIRExportJobsRequest/SubmittedBefore
     :cognitect.aws.healthlake.ListFHIRExportJobsRequest/JobName
     :cognitect.aws.healthlake.ListFHIRExportJobsRequest/NextToken
     :cognitect.aws.healthlake.ListFHIRExportJobsRequest/MaxResults
     :cognitect.aws.healthlake.ListFHIRExportJobsRequest/SubmittedAfter]))

(s/def
  :cognitect.aws.healthlake.TagResourceRequest/ResourceARN
  :cognitect.aws.healthlake/AmazonResourceName)

(s/def :cognitect.aws.healthlake.TagResourceRequest/Tags :cognitect.aws.healthlake/TagList)

(s/def :cognitect.aws.healthlake.Tag/Key :cognitect.aws.healthlake/TagKey)

(s/def :cognitect.aws.healthlake.Tag/Value :cognitect.aws.healthlake/TagValue)

(s/def
  :cognitect.aws.healthlake.ListFHIRExportJobsResponse/ExportJobPropertiesList
  :cognitect.aws.healthlake/ExportJobPropertiesList)

(s/def
  :cognitect.aws.healthlake.ListFHIRExportJobsResponse/NextToken
  :cognitect.aws.healthlake/NextToken)

(s/def
  :cognitect.aws.healthlake.ListFHIRDatastoresResponse/DatastorePropertiesList
  :cognitect.aws.healthlake/DatastorePropertiesList)

(s/def
  :cognitect.aws.healthlake.ListFHIRDatastoresResponse/NextToken
  :cognitect.aws.healthlake/NextToken)

(s/def
  :cognitect.aws.healthlake.ListFHIRDatastoresRequest/Filter
  :cognitect.aws.healthlake/DatastoreFilter)

(s/def
  :cognitect.aws.healthlake.ListFHIRDatastoresRequest/NextToken
  :cognitect.aws.healthlake/NextToken)

(s/def
  :cognitect.aws.healthlake.ListFHIRDatastoresRequest/MaxResults
  :cognitect.aws.healthlake/MaxResultsInteger)

(s/def :cognitect.aws.healthlake.ImportJobProperties/JobName :cognitect.aws.healthlake/JobName)

(s/def :cognitect.aws.healthlake.ImportJobProperties/EndTime :cognitect.aws.healthlake/Timestamp)

(s/def :cognitect.aws.healthlake.ImportJobProperties/Message :cognitect.aws.healthlake/Message)

(s/def :cognitect.aws.healthlake.ImportJobProperties/JobId :cognitect.aws.healthlake/JobId)

(s/def :cognitect.aws.healthlake.ImportJobProperties/JobStatus :cognitect.aws.healthlake/JobStatus)

(s/def
  :cognitect.aws.healthlake.ImportJobProperties/DataAccessRoleArn
  :cognitect.aws.healthlake/IamRoleArn)

(s/def
  :cognitect.aws.healthlake.ImportJobProperties/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def :cognitect.aws.healthlake.ImportJobProperties/SubmitTime :cognitect.aws.healthlake/Timestamp)

(s/def
  :cognitect.aws.healthlake.ImportJobProperties/JobOutputDataConfig
  :cognitect.aws.healthlake/OutputDataConfig)

(s/def
  :cognitect.aws.healthlake.ImportJobProperties/InputDataConfig
  :cognitect.aws.healthlake/InputDataConfig)

(s/def
  :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreArn
  :cognitect.aws.healthlake/DatastoreArn)

(s/def
  :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreStatus
  :cognitect.aws.healthlake/DatastoreStatus)

(s/def
  :cognitect.aws.healthlake.DeleteFHIRDatastoreResponse/DatastoreEndpoint
  :cognitect.aws.healthlake/BoundedLengthString)

(s/def
  :cognitect.aws.healthlake.DescribeFHIRDatastoreResponse/DatastoreProperties
  :cognitect.aws.healthlake/DatastoreProperties)

(s/def
  :cognitect.aws.healthlake.StartFHIRExportJobRequest/JobName
  :cognitect.aws.healthlake/JobName)

(s/def
  :cognitect.aws.healthlake.StartFHIRExportJobRequest/OutputDataConfig
  :cognitect.aws.healthlake/OutputDataConfig)

(s/def
  :cognitect.aws.healthlake.StartFHIRExportJobRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.StartFHIRExportJobRequest/DataAccessRoleArn
  :cognitect.aws.healthlake/IamRoleArn)

(s/def
  :cognitect.aws.healthlake.StartFHIRExportJobRequest/ClientToken
  :cognitect.aws.healthlake/ClientTokenString)

(s/def
  :cognitect.aws.healthlake.DescribeFHIRExportJobRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def :cognitect.aws.healthlake.DescribeFHIRExportJobRequest/JobId :cognitect.aws.healthlake/JobId)

(s/def
  :cognitect.aws.healthlake.DeleteFHIRDatastoreRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.DatastoreFilter/DatastoreName
  :cognitect.aws.healthlake/DatastoreName)

(s/def
  :cognitect.aws.healthlake.DatastoreFilter/DatastoreStatus
  :cognitect.aws.healthlake/DatastoreStatus)

(s/def :cognitect.aws.healthlake.DatastoreFilter/CreatedBefore :cognitect.aws.healthlake/Timestamp)

(s/def :cognitect.aws.healthlake.DatastoreFilter/CreatedAfter :cognitect.aws.healthlake/Timestamp)

(s/def :cognitect.aws.healthlake.StartFHIRImportJobResponse/JobId :cognitect.aws.healthlake/JobId)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobResponse/JobStatus
  :cognitect.aws.healthlake/JobStatus)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobResponse/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.DescribeFHIRExportJobResponse/ExportJobProperties
  :cognitect.aws.healthlake/ExportJobProperties)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreArn
  :cognitect.aws.healthlake/DatastoreArn)

(s/def :cognitect.aws.healthlake.DatastoreProperties/CreatedAt :cognitect.aws.healthlake/Timestamp)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreEndpoint
  :cognitect.aws.healthlake/String)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreTypeVersion
  :cognitect.aws.healthlake/FHIRVersion)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreStatus
  :cognitect.aws.healthlake/DatastoreStatus)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/PreloadDataConfig
  :cognitect.aws.healthlake/PreloadDataConfig)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/SseConfiguration
  :cognitect.aws.healthlake/SseConfiguration)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/IdentityProviderConfiguration
  :cognitect.aws.healthlake/IdentityProviderConfiguration)

(s/def
  :cognitect.aws.healthlake.DatastoreProperties/DatastoreName
  :cognitect.aws.healthlake/DatastoreName)

(s/def :cognitect.aws.healthlake.KmsEncryptionConfig/CmkType :cognitect.aws.healthlake/CmkType)

(s/def
  :cognitect.aws.healthlake.KmsEncryptionConfig/KmsKeyId
  :cognitect.aws.healthlake/EncryptionKeyID)

(s/def
  :cognitect.aws.healthlake.PreloadDataConfig/PreloadDataType
  :cognitect.aws.healthlake/PreloadDataType)

(s/def
  :cognitect.aws.healthlake.OutputDataConfig/S3Configuration
  :cognitect.aws.healthlake/S3Configuration)

(s/def
  :cognitect.aws.healthlake.ListTagsForResourceRequest/ResourceARN
  :cognitect.aws.healthlake/AmazonResourceName)

(s/def
  :cognitect.aws.healthlake.DescribeFHIRImportJobResponse/ImportJobProperties
  :cognitect.aws.healthlake/ImportJobProperties)

(s/def
  :cognitect.aws.healthlake.ListFHIRImportJobsResponse/ImportJobPropertiesList
  :cognitect.aws.healthlake/ImportJobPropertiesList)

(s/def
  :cognitect.aws.healthlake.ListFHIRImportJobsResponse/NextToken
  :cognitect.aws.healthlake/NextToken)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreArn
  :cognitect.aws.healthlake/DatastoreArn)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreStatus
  :cognitect.aws.healthlake/DatastoreStatus)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreResponse/DatastoreEndpoint
  :cognitect.aws.healthlake/BoundedLengthString)

(s/def
  :cognitect.aws.healthlake.ListFHIRImportJobsRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.ListFHIRImportJobsRequest/NextToken
  :cognitect.aws.healthlake/NextToken)

(s/def
  :cognitect.aws.healthlake.ListFHIRImportJobsRequest/MaxResults
  :cognitect.aws.healthlake/MaxResultsInteger)

(s/def
  :cognitect.aws.healthlake.ListFHIRImportJobsRequest/JobName
  :cognitect.aws.healthlake/JobName)

(s/def
  :cognitect.aws.healthlake.ListFHIRImportJobsRequest/JobStatus
  :cognitect.aws.healthlake/JobStatus)

(s/def
  :cognitect.aws.healthlake.ListFHIRImportJobsRequest/SubmittedBefore
  :cognitect.aws.healthlake/Timestamp)

(s/def
  :cognitect.aws.healthlake.ListFHIRImportJobsRequest/SubmittedAfter
  :cognitect.aws.healthlake/Timestamp)

(s/def :cognitect.aws.healthlake.S3Configuration/S3Uri :cognitect.aws.healthlake/S3Uri)

(s/def :cognitect.aws.healthlake.S3Configuration/KmsKeyId :cognitect.aws.healthlake/EncryptionKeyID)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/DatastoreName
  :cognitect.aws.healthlake/DatastoreName)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/DatastoreTypeVersion
  :cognitect.aws.healthlake/FHIRVersion)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/SseConfiguration
  :cognitect.aws.healthlake/SseConfiguration)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/PreloadDataConfig
  :cognitect.aws.healthlake/PreloadDataConfig)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/ClientToken
  :cognitect.aws.healthlake/ClientTokenString)

(s/def :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/Tags :cognitect.aws.healthlake/TagList)

(s/def
  :cognitect.aws.healthlake.CreateFHIRDatastoreRequest/IdentityProviderConfiguration
  :cognitect.aws.healthlake/IdentityProviderConfiguration)

(s/def
  :cognitect.aws.healthlake.SseConfiguration/KmsEncryptionConfig
  :cognitect.aws.healthlake/KmsEncryptionConfig)

(s/def
  :cognitect.aws.healthlake.DescribeFHIRImportJobRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def :cognitect.aws.healthlake.DescribeFHIRImportJobRequest/JobId :cognitect.aws.healthlake/JobId)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/JobName
  :cognitect.aws.healthlake/JobName)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/InputDataConfig
  :cognitect.aws.healthlake/InputDataConfig)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/JobOutputDataConfig
  :cognitect.aws.healthlake/OutputDataConfig)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/DataAccessRoleArn
  :cognitect.aws.healthlake/IamRoleArn)

(s/def
  :cognitect.aws.healthlake.StartFHIRImportJobRequest/ClientToken
  :cognitect.aws.healthlake/ClientTokenString)

(s/def :cognitect.aws.healthlake.ExportJobProperties/JobName :cognitect.aws.healthlake/JobName)

(s/def :cognitect.aws.healthlake.ExportJobProperties/EndTime :cognitect.aws.healthlake/Timestamp)

(s/def :cognitect.aws.healthlake.ExportJobProperties/Message :cognitect.aws.healthlake/Message)

(s/def :cognitect.aws.healthlake.ExportJobProperties/JobId :cognitect.aws.healthlake/JobId)

(s/def :cognitect.aws.healthlake.ExportJobProperties/JobStatus :cognitect.aws.healthlake/JobStatus)

(s/def
  :cognitect.aws.healthlake.ExportJobProperties/DataAccessRoleArn
  :cognitect.aws.healthlake/IamRoleArn)

(s/def
  :cognitect.aws.healthlake.ExportJobProperties/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.ExportJobProperties/OutputDataConfig
  :cognitect.aws.healthlake/OutputDataConfig)

(s/def :cognitect.aws.healthlake.ExportJobProperties/SubmitTime :cognitect.aws.healthlake/Timestamp)

(s/def
  :cognitect.aws.healthlake.IdentityProviderConfiguration/AuthorizationStrategy
  :cognitect.aws.healthlake/AuthorizationStrategy)

(s/def
  :cognitect.aws.healthlake.IdentityProviderConfiguration/FineGrainedAuthorizationEnabled
  :cognitect.aws.healthlake/Boolean)

(s/def
  :cognitect.aws.healthlake.IdentityProviderConfiguration/Metadata
  :cognitect.aws.healthlake/ConfigurationMetadata)

(s/def
  :cognitect.aws.healthlake.IdentityProviderConfiguration/IdpLambdaArn
  :cognitect.aws.healthlake/LambdaArn)

(s/def
  :cognitect.aws.healthlake.UntagResourceRequest/ResourceARN
  :cognitect.aws.healthlake/AmazonResourceName)

(s/def :cognitect.aws.healthlake.UntagResourceRequest/TagKeys :cognitect.aws.healthlake/TagKeyList)

(s/def :cognitect.aws.healthlake.StartFHIRExportJobResponse/JobId :cognitect.aws.healthlake/JobId)

(s/def
  :cognitect.aws.healthlake.StartFHIRExportJobResponse/JobStatus
  :cognitect.aws.healthlake/JobStatus)

(s/def
  :cognitect.aws.healthlake.StartFHIRExportJobResponse/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def :cognitect.aws.healthlake.InputDataConfig/S3Uri :cognitect.aws.healthlake/S3Uri)

(s/def :cognitect.aws.healthlake.ListTagsForResourceResponse/Tags :cognitect.aws.healthlake/TagList)

(s/def
  :cognitect.aws.healthlake.DescribeFHIRDatastoreRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.ListFHIRExportJobsRequest/DatastoreId
  :cognitect.aws.healthlake/DatastoreId)

(s/def
  :cognitect.aws.healthlake.ListFHIRExportJobsRequest/NextToken
  :cognitect.aws.healthlake/NextToken)

(s/def
  :cognitect.aws.healthlake.ListFHIRExportJobsRequest/MaxResults
  :cognitect.aws.healthlake/MaxResultsInteger)

(s/def
  :cognitect.aws.healthlake.ListFHIRExportJobsRequest/JobName
  :cognitect.aws.healthlake/JobName)

(s/def
  :cognitect.aws.healthlake.ListFHIRExportJobsRequest/JobStatus
  :cognitect.aws.healthlake/JobStatus)

(s/def
  :cognitect.aws.healthlake.ListFHIRExportJobsRequest/SubmittedBefore
  :cognitect.aws.healthlake/Timestamp)

(s/def
  :cognitect.aws.healthlake.ListFHIRExportJobsRequest/SubmittedAfter
  :cognitect.aws.healthlake/Timestamp)

