;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.iot-jobs-data.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.iot-jobs-data/StartNextPendingJobExecutionResponse
  (s/keys :opt-un [:cognitect.aws.iot-jobs-data.StartNextPendingJobExecutionResponse/execution]))

(s/def
  :cognitect.aws.iot-jobs-data/StartNextPendingJobExecutionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iot-jobs-data.StartNextPendingJobExecutionRequest/thingName]
    :opt-un
    [:cognitect.aws.iot-jobs-data.StartNextPendingJobExecutionRequest/stepTimeoutInMinutes
     :cognitect.aws.iot-jobs-data.StartNextPendingJobExecutionRequest/statusDetails]))

(s/def
  :cognitect.aws.iot-jobs-data/DescribeJobExecutionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iot-jobs-data.DescribeJobExecutionRequest/jobId
     :cognitect.aws.iot-jobs-data.DescribeJobExecutionRequest/thingName]
    :opt-un
    [:cognitect.aws.iot-jobs-data.DescribeJobExecutionRequest/includeJobDocument
     :cognitect.aws.iot-jobs-data.DescribeJobExecutionRequest/executionNumber]))

(s/def
  :cognitect.aws.iot-jobs-data/UpdateJobExecutionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/jobId
     :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/thingName
     :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/status]
    :opt-un
    [:cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/stepTimeoutInMinutes
     :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/includeJobDocument
     :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/statusDetails
     :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/executionNumber
     :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/expectedVersion
     :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/includeJobExecutionState]))

(s/def
  :cognitect.aws.iot-jobs-data/JobExecution
  (s/keys
    :opt-un
    [:cognitect.aws.iot-jobs-data.JobExecution/thingName
     :cognitect.aws.iot-jobs-data.JobExecution/queuedAt
     :cognitect.aws.iot-jobs-data.JobExecution/jobDocument
     :cognitect.aws.iot-jobs-data.JobExecution/startedAt
     :cognitect.aws.iot-jobs-data.JobExecution/approximateSecondsBeforeTimedOut
     :cognitect.aws.iot-jobs-data.JobExecution/statusDetails
     :cognitect.aws.iot-jobs-data.JobExecution/executionNumber
     :cognitect.aws.iot-jobs-data.JobExecution/status
     :cognitect.aws.iot-jobs-data.JobExecution/lastUpdatedAt
     :cognitect.aws.iot-jobs-data.JobExecution/jobId
     :cognitect.aws.iot-jobs-data.JobExecution/versionNumber]))

(s/def
  :cognitect.aws.iot-jobs-data/DetailsKey
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9:_-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iot-jobs-data/JobExecutionSummary
  (s/keys
    :opt-un
    [:cognitect.aws.iot-jobs-data.JobExecutionSummary/queuedAt
     :cognitect.aws.iot-jobs-data.JobExecutionSummary/startedAt
     :cognitect.aws.iot-jobs-data.JobExecutionSummary/executionNumber
     :cognitect.aws.iot-jobs-data.JobExecutionSummary/lastUpdatedAt
     :cognitect.aws.iot-jobs-data.JobExecutionSummary/jobId
     :cognitect.aws.iot-jobs-data.JobExecutionSummary/versionNumber]))

(s/def
  :cognitect.aws.iot-jobs-data/VersionNumber
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iot-jobs-data/JobDocument
  (s/spec
    (s/and string? #(>= 32768 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 32768) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iot-jobs-data/DescribeJobExecutionResponse
  (s/keys :opt-un [:cognitect.aws.iot-jobs-data.DescribeJobExecutionResponse/execution]))

(s/def
  :cognitect.aws.iot-jobs-data/JobId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9_-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iot-jobs-data/JobExecutionStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CANCELED" "IN_PROGRESS" "TIMED_OUT" "REMOVED" "SUCCEEDED" "REJECTED" "QUEUED" "FAILED"})))

(s/def
  :cognitect.aws.iot-jobs-data/LastUpdatedAt
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iot-jobs-data/DescribeJobExecutionJobId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9_-]+|^\\$next") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iot-jobs-data/ApproximateSecondsBeforeTimedOut
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iot-jobs-data/DetailsMap
  (s/map-of :cognitect.aws.iot-jobs-data/DetailsKey :cognitect.aws.iot-jobs-data/DetailsValue))

(s/def
  :cognitect.aws.iot-jobs-data/GetPendingJobExecutionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iot-jobs-data.GetPendingJobExecutionsResponse/inProgressJobs
     :cognitect.aws.iot-jobs-data.GetPendingJobExecutionsResponse/queuedJobs]))

(s/def
  :cognitect.aws.iot-jobs-data/QueuedAt
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iot-jobs-data/ThingName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9:_-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iot-jobs-data/StartedAt
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.iot-jobs-data/IncludeExecutionState boolean?)

(s/def
  :cognitect.aws.iot-jobs-data/JobExecutionSummaryList
  (s/coll-of :cognitect.aws.iot-jobs-data/JobExecutionSummary))

(s/def
  :cognitect.aws.iot-jobs-data/ExpectedVersion
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iot-jobs-data/StepTimeoutInMinutes
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iot-jobs-data/DetailsValue
  (s/spec #(re-matches (re-pattern "[^\\p{C}]*+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iot-jobs-data/ExecutionNumber
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iot-jobs-data/JobExecutionState
  (s/keys
    :opt-un
    [:cognitect.aws.iot-jobs-data.JobExecutionState/statusDetails
     :cognitect.aws.iot-jobs-data.JobExecutionState/status
     :cognitect.aws.iot-jobs-data.JobExecutionState/versionNumber]))

(s/def
  :cognitect.aws.iot-jobs-data/UpdateJobExecutionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iot-jobs-data.UpdateJobExecutionResponse/jobDocument
     :cognitect.aws.iot-jobs-data.UpdateJobExecutionResponse/executionState]))

(s/def :cognitect.aws.iot-jobs-data/IncludeJobDocument boolean?)

(s/def
  :cognitect.aws.iot-jobs-data/GetPendingJobExecutionsRequest
  (s/keys :req-un [:cognitect.aws.iot-jobs-data.GetPendingJobExecutionsRequest/thingName]))

(s/def
  :cognitect.aws.iot-jobs-data.StartNextPendingJobExecutionResponse/execution
  :cognitect.aws.iot-jobs-data/JobExecution)

(s/def
  :cognitect.aws.iot-jobs-data.StartNextPendingJobExecutionRequest/thingName
  :cognitect.aws.iot-jobs-data/ThingName)

(s/def
  :cognitect.aws.iot-jobs-data.StartNextPendingJobExecutionRequest/statusDetails
  :cognitect.aws.iot-jobs-data/DetailsMap)

(s/def
  :cognitect.aws.iot-jobs-data.StartNextPendingJobExecutionRequest/stepTimeoutInMinutes
  :cognitect.aws.iot-jobs-data/StepTimeoutInMinutes)

(s/def
  :cognitect.aws.iot-jobs-data.DescribeJobExecutionRequest/jobId
  :cognitect.aws.iot-jobs-data/DescribeJobExecutionJobId)

(s/def
  :cognitect.aws.iot-jobs-data.DescribeJobExecutionRequest/thingName
  :cognitect.aws.iot-jobs-data/ThingName)

(s/def
  :cognitect.aws.iot-jobs-data.DescribeJobExecutionRequest/includeJobDocument
  :cognitect.aws.iot-jobs-data/IncludeJobDocument)

(s/def
  :cognitect.aws.iot-jobs-data.DescribeJobExecutionRequest/executionNumber
  :cognitect.aws.iot-jobs-data/ExecutionNumber)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/statusDetails
  :cognitect.aws.iot-jobs-data/DetailsMap)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/includeJobExecutionState
  :cognitect.aws.iot-jobs-data/IncludeExecutionState)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/expectedVersion
  :cognitect.aws.iot-jobs-data/ExpectedVersion)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/thingName
  :cognitect.aws.iot-jobs-data/ThingName)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/status
  :cognitect.aws.iot-jobs-data/JobExecutionStatus)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/executionNumber
  :cognitect.aws.iot-jobs-data/ExecutionNumber)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/stepTimeoutInMinutes
  :cognitect.aws.iot-jobs-data/StepTimeoutInMinutes)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/includeJobDocument
  :cognitect.aws.iot-jobs-data/IncludeJobDocument)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionRequest/jobId
  :cognitect.aws.iot-jobs-data/JobId)

(s/def :cognitect.aws.iot-jobs-data.JobExecution/startedAt :cognitect.aws.iot-jobs-data/StartedAt)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecution/statusDetails
  :cognitect.aws.iot-jobs-data/DetailsMap)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecution/approximateSecondsBeforeTimedOut
  :cognitect.aws.iot-jobs-data/ApproximateSecondsBeforeTimedOut)

(s/def :cognitect.aws.iot-jobs-data.JobExecution/thingName :cognitect.aws.iot-jobs-data/ThingName)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecution/jobDocument
  :cognitect.aws.iot-jobs-data/JobDocument)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecution/versionNumber
  :cognitect.aws.iot-jobs-data/VersionNumber)

(s/def :cognitect.aws.iot-jobs-data.JobExecution/queuedAt :cognitect.aws.iot-jobs-data/QueuedAt)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecution/status
  :cognitect.aws.iot-jobs-data/JobExecutionStatus)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecution/executionNumber
  :cognitect.aws.iot-jobs-data/ExecutionNumber)

(s/def :cognitect.aws.iot-jobs-data.JobExecution/jobId :cognitect.aws.iot-jobs-data/JobId)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecution/lastUpdatedAt
  :cognitect.aws.iot-jobs-data/LastUpdatedAt)

(s/def :cognitect.aws.iot-jobs-data.JobExecutionSummary/jobId :cognitect.aws.iot-jobs-data/JobId)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecutionSummary/queuedAt
  :cognitect.aws.iot-jobs-data/QueuedAt)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecutionSummary/startedAt
  :cognitect.aws.iot-jobs-data/StartedAt)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecutionSummary/lastUpdatedAt
  :cognitect.aws.iot-jobs-data/LastUpdatedAt)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecutionSummary/versionNumber
  :cognitect.aws.iot-jobs-data/VersionNumber)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecutionSummary/executionNumber
  :cognitect.aws.iot-jobs-data/ExecutionNumber)

(s/def
  :cognitect.aws.iot-jobs-data.DescribeJobExecutionResponse/execution
  :cognitect.aws.iot-jobs-data/JobExecution)

(s/def
  :cognitect.aws.iot-jobs-data.GetPendingJobExecutionsResponse/inProgressJobs
  :cognitect.aws.iot-jobs-data/JobExecutionSummaryList)

(s/def
  :cognitect.aws.iot-jobs-data.GetPendingJobExecutionsResponse/queuedJobs
  :cognitect.aws.iot-jobs-data/JobExecutionSummaryList)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecutionState/status
  :cognitect.aws.iot-jobs-data/JobExecutionStatus)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecutionState/statusDetails
  :cognitect.aws.iot-jobs-data/DetailsMap)

(s/def
  :cognitect.aws.iot-jobs-data.JobExecutionState/versionNumber
  :cognitect.aws.iot-jobs-data/VersionNumber)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionResponse/executionState
  :cognitect.aws.iot-jobs-data/JobExecutionState)

(s/def
  :cognitect.aws.iot-jobs-data.UpdateJobExecutionResponse/jobDocument
  :cognitect.aws.iot-jobs-data/JobDocument)

(s/def
  :cognitect.aws.iot-jobs-data.GetPendingJobExecutionsRequest/thingName
  :cognitect.aws.iot-jobs-data/ThingName)

