;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.iotevents-data.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.iotevents-data/DescribeDetectorResponse
  (s/keys :opt-un [:cognitect.aws.iotevents-data.DescribeDetectorResponse/detector]))

(s/def :cognitect.aws.iotevents-data/ErrorCode string?)

(s/def
  :cognitect.aws.iotevents-data/BatchUpdateDetectorErrorEntry
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/errorMessage
     :cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/errorCode
     :cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/messageId]))

(s/def
  :cognitect.aws.iotevents-data/Message
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.Message/messageId
     :cognitect.aws.iotevents-data.Message/inputName
     :cognitect.aws.iotevents-data.Message/payload]))

(s/def
  :cognitect.aws.iotevents-data/UpdateDetectorRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.UpdateDetectorRequest/messageId
     :cognitect.aws.iotevents-data.UpdateDetectorRequest/detectorModelName
     :cognitect.aws.iotevents-data.UpdateDetectorRequest/state]
    :opt-un
    [:cognitect.aws.iotevents-data.UpdateDetectorRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/DetectorSummaries
  (s/coll-of :cognitect.aws.iotevents-data/DetectorSummary))

(s/def :cognitect.aws.iotevents-data/ErrorMessage string?)

(s/def
  :cognitect.aws.iotevents-data/InputName
  (s/with-gen #(re-matches (re-pattern "^[a-zA-Z][a-zA-Z0-9_]*$") %) #(gen/string)))

(s/def
  :cognitect.aws.iotevents-data/ListDetectorsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.ListDetectorsResponse/nextToken
     :cognitect.aws.iotevents-data.ListDetectorsResponse/detectorSummaries]))

(s/def
  :cognitect.aws.iotevents-data/VariableDefinitions
  (s/coll-of :cognitect.aws.iotevents-data/VariableDefinition))

(s/def
  :cognitect.aws.iotevents-data/BatchUpdateDetectorRequest
  (s/keys :req-un [:cognitect.aws.iotevents-data.BatchUpdateDetectorRequest/detectors]))

(s/def
  :cognitect.aws.iotevents-data/Messages
  (s/coll-of :cognitect.aws.iotevents-data/Message :min-count 1))

(s/def
  :cognitect.aws.iotevents-data/VariableValue
  (s/with-gen
    (s/and string? #(<= 1 (count %) 1024))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 1024 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iotevents-data/KeyValue
  (s/with-gen #(re-matches (re-pattern "^[a-zA-Z0-9\\-_:]+$") %) #(gen/string)))

(s/def
  :cognitect.aws.iotevents-data/Detector
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.Detector/creationTime
     :cognitect.aws.iotevents-data.Detector/state
     :cognitect.aws.iotevents-data.Detector/lastUpdateTime
     :cognitect.aws.iotevents-data.Detector/detectorModelVersion
     :cognitect.aws.iotevents-data.Detector/detectorModelName
     :cognitect.aws.iotevents-data.Detector/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/BatchPutMessageErrorEntry
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/errorMessage
     :cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/errorCode
     :cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/messageId]))

(s/def
  :cognitect.aws.iotevents-data/DetectorStateSummary
  (s/keys :opt-un [:cognitect.aws.iotevents-data.DetectorStateSummary/stateName]))

(s/def
  :cognitect.aws.iotevents-data/BatchPutMessageErrorEntries
  (s/coll-of :cognitect.aws.iotevents-data/BatchPutMessageErrorEntry))

(s/def
  :cognitect.aws.iotevents-data/UpdateDetectorRequests
  (s/coll-of :cognitect.aws.iotevents-data/UpdateDetectorRequest :min-count 1))

(s/def
  :cognitect.aws.iotevents-data/Payload
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.iotevents-data/MessageId
  (s/with-gen #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) #(gen/string)))

(s/def :cognitect.aws.iotevents-data/NextToken string?)

(s/def
  :cognitect.aws.iotevents-data/StateName
  (s/with-gen
    (s/and string? #(<= 1 (count %) 128))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 128 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iotevents-data/BatchPutMessageRequest
  (s/keys :req-un [:cognitect.aws.iotevents-data.BatchPutMessageRequest/messages]))

(s/def
  :cognitect.aws.iotevents-data/ListDetectorsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.ListDetectorsRequest/detectorModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.ListDetectorsRequest/maxResults
     :cognitect.aws.iotevents-data.ListDetectorsRequest/nextToken
     :cognitect.aws.iotevents-data.ListDetectorsRequest/stateName]))

(s/def
  :cognitect.aws.iotevents-data/DescribeDetectorRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.DescribeDetectorRequest/detectorModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.DescribeDetectorRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/DetectorState
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.DetectorState/stateName
     :cognitect.aws.iotevents-data.DetectorState/variables
     :cognitect.aws.iotevents-data.DetectorState/timers]))

(s/def
  :cognitect.aws.iotevents-data/DetectorModelVersion
  (s/with-gen
    (s/and string? #(<= 1 (count %) 128))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 128 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iotevents-data/Timer
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.Timer/name :cognitect.aws.iotevents-data.Timer/timestamp]))

(s/def
  :cognitect.aws.iotevents-data/DetectorSummary
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.DetectorSummary/creationTime
     :cognitect.aws.iotevents-data.DetectorSummary/state
     :cognitect.aws.iotevents-data.DetectorSummary/lastUpdateTime
     :cognitect.aws.iotevents-data.DetectorSummary/detectorModelVersion
     :cognitect.aws.iotevents-data.DetectorSummary/detectorModelName
     :cognitect.aws.iotevents-data.DetectorSummary/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/Variable
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.Variable/name :cognitect.aws.iotevents-data.Variable/value]))

(s/def
  :cognitect.aws.iotevents-data/TimerDefinitions
  (s/coll-of :cognitect.aws.iotevents-data/TimerDefinition))

(s/def
  :cognitect.aws.iotevents-data/MaxResults
  (s/with-gen
    (s/and int? #(<= 1 % 250))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 250 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.iotevents-data/DetectorStateDefinition
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.DetectorStateDefinition/stateName
     :cognitect.aws.iotevents-data.DetectorStateDefinition/variables
     :cognitect.aws.iotevents-data.DetectorStateDefinition/timers]))

(s/def :cognitect.aws.iotevents-data/Variables (s/coll-of :cognitect.aws.iotevents-data/Variable))

(s/def :cognitect.aws.iotevents-data/Timestamp inst?)

(s/def
  :cognitect.aws.iotevents-data/DetectorModelName
  (s/with-gen #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) #(gen/string)))

(s/def
  :cognitect.aws.iotevents-data/BatchUpdateDetectorResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchUpdateDetectorResponse/batchUpdateDetectorErrorEntries]))

(s/def
  :cognitect.aws.iotevents-data/BatchUpdateDetectorErrorEntries
  (s/coll-of :cognitect.aws.iotevents-data/BatchUpdateDetectorErrorEntry))

(s/def
  :cognitect.aws.iotevents-data/TimerDefinition
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.TimerDefinition/name
     :cognitect.aws.iotevents-data.TimerDefinition/seconds]))

(s/def
  :cognitect.aws.iotevents-data/Seconds
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.iotevents-data/BatchPutMessageResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchPutMessageResponse/BatchPutMessageErrorEntries]))

(s/def
  :cognitect.aws.iotevents-data/VariableName
  (s/with-gen #(re-matches (re-pattern "^[a-zA-Z][a-zA-Z0-9_]*$") %) #(gen/string)))

(s/def
  :cognitect.aws.iotevents-data/VariableDefinition
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.VariableDefinition/name
     :cognitect.aws.iotevents-data.VariableDefinition/value]))

(s/def
  :cognitect.aws.iotevents-data/TimerName
  (s/with-gen
    (s/and string? #(<= 1 (count %) 128))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 128 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.iotevents-data/Timers (s/coll-of :cognitect.aws.iotevents-data/Timer))

(s/def
  :cognitect.aws.iotevents-data.DescribeDetectorResponse/detector
  :cognitect.aws.iotevents-data/Detector)

(s/def
  :cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/messageId
  :cognitect.aws.iotevents-data/MessageId)

(s/def
  :cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/errorCode
  :cognitect.aws.iotevents-data/ErrorCode)

(s/def
  :cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/errorMessage
  :cognitect.aws.iotevents-data/ErrorMessage)

(s/def :cognitect.aws.iotevents-data.Message/messageId :cognitect.aws.iotevents-data/MessageId)

(s/def :cognitect.aws.iotevents-data.Message/inputName :cognitect.aws.iotevents-data/InputName)

(s/def :cognitect.aws.iotevents-data.Message/payload :cognitect.aws.iotevents-data/Payload)

(s/def
  :cognitect.aws.iotevents-data.UpdateDetectorRequest/messageId
  :cognitect.aws.iotevents-data/MessageId)

(s/def
  :cognitect.aws.iotevents-data.UpdateDetectorRequest/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def
  :cognitect.aws.iotevents-data.UpdateDetectorRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.UpdateDetectorRequest/state
  :cognitect.aws.iotevents-data/DetectorStateDefinition)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsResponse/detectorSummaries
  :cognitect.aws.iotevents-data/DetectorSummaries)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsResponse/nextToken
  :cognitect.aws.iotevents-data/NextToken)

(s/def
  :cognitect.aws.iotevents-data.BatchUpdateDetectorRequest/detectors
  :cognitect.aws.iotevents-data/UpdateDetectorRequests)

(s/def
  :cognitect.aws.iotevents-data.Detector/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def :cognitect.aws.iotevents-data.Detector/keyValue :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.Detector/detectorModelVersion
  :cognitect.aws.iotevents-data/DetectorModelVersion)

(s/def :cognitect.aws.iotevents-data.Detector/state :cognitect.aws.iotevents-data/DetectorState)

(s/def :cognitect.aws.iotevents-data.Detector/creationTime :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.Detector/lastUpdateTime
  :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/messageId
  :cognitect.aws.iotevents-data/MessageId)

(s/def
  :cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/errorCode
  :cognitect.aws.iotevents-data/ErrorCode)

(s/def
  :cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/errorMessage
  :cognitect.aws.iotevents-data/ErrorMessage)

(s/def
  :cognitect.aws.iotevents-data.DetectorStateSummary/stateName
  :cognitect.aws.iotevents-data/StateName)

(s/def
  :cognitect.aws.iotevents-data.BatchPutMessageRequest/messages
  :cognitect.aws.iotevents-data/Messages)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsRequest/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsRequest/stateName
  :cognitect.aws.iotevents-data/StateName)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsRequest/nextToken
  :cognitect.aws.iotevents-data/NextToken)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsRequest/maxResults
  :cognitect.aws.iotevents-data/MaxResults)

(s/def
  :cognitect.aws.iotevents-data.DescribeDetectorRequest/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def
  :cognitect.aws.iotevents-data.DescribeDetectorRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.DetectorState/stateName
  :cognitect.aws.iotevents-data/StateName)

(s/def
  :cognitect.aws.iotevents-data.DetectorState/variables
  :cognitect.aws.iotevents-data/Variables)

(s/def :cognitect.aws.iotevents-data.DetectorState/timers :cognitect.aws.iotevents-data/Timers)

(s/def :cognitect.aws.iotevents-data.Timer/name :cognitect.aws.iotevents-data/TimerName)

(s/def :cognitect.aws.iotevents-data.Timer/timestamp :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/detectorModelVersion
  :cognitect.aws.iotevents-data/DetectorModelVersion)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/state
  :cognitect.aws.iotevents-data/DetectorStateSummary)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/creationTime
  :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/lastUpdateTime
  :cognitect.aws.iotevents-data/Timestamp)

(s/def :cognitect.aws.iotevents-data.Variable/name :cognitect.aws.iotevents-data/VariableName)

(s/def :cognitect.aws.iotevents-data.Variable/value :cognitect.aws.iotevents-data/VariableValue)

(s/def
  :cognitect.aws.iotevents-data.DetectorStateDefinition/stateName
  :cognitect.aws.iotevents-data/StateName)

(s/def
  :cognitect.aws.iotevents-data.DetectorStateDefinition/variables
  :cognitect.aws.iotevents-data/VariableDefinitions)

(s/def
  :cognitect.aws.iotevents-data.DetectorStateDefinition/timers
  :cognitect.aws.iotevents-data/TimerDefinitions)

(s/def
  :cognitect.aws.iotevents-data.BatchUpdateDetectorResponse/batchUpdateDetectorErrorEntries
  :cognitect.aws.iotevents-data/BatchUpdateDetectorErrorEntries)

(s/def :cognitect.aws.iotevents-data.TimerDefinition/name :cognitect.aws.iotevents-data/TimerName)

(s/def :cognitect.aws.iotevents-data.TimerDefinition/seconds :cognitect.aws.iotevents-data/Seconds)

(s/def
  :cognitect.aws.iotevents-data.BatchPutMessageResponse/BatchPutMessageErrorEntries
  :cognitect.aws.iotevents-data/BatchPutMessageErrorEntries)

(s/def
  :cognitect.aws.iotevents-data.VariableDefinition/name
  :cognitect.aws.iotevents-data/VariableName)

(s/def
  :cognitect.aws.iotevents-data.VariableDefinition/value
  :cognitect.aws.iotevents-data/VariableValue)

